/*
 * Decompiled with CFR 0.152.
 */
package org.savarese.vserv.tcpip;

import org.savarese.vserv.tcpip.IPPacket;

public abstract class ICMPPacket
extends IPPacket {
    int _offset = 0;

    public ICMPPacket(int size) {
        super(size);
    }

    public abstract int getICMPHeaderByteLength();

    @Override
    public void setIPHeaderLength(int length) {
        super.setIPHeaderLength(length);
        this._offset = this.getIPHeaderByteLength();
    }

    public final int getCombinedHeaderByteLength() {
        return this._offset + this.getICMPHeaderByteLength();
    }

    public final void setICMPDataByteLength(int length) {
        if (length < 0) {
            length = 0;
        }
        this.setIPPacketLength(this.getCombinedHeaderByteLength() + length);
    }

    public final int getICMPPacketByteLength() {
        return this.getIPPacketLength() - this._offset;
    }

    @Override
    public void setData(byte[] data) {
        super.setData(data);
        this._offset = this.getIPHeaderByteLength();
    }

    public final void setType(int type) {
        this._data_[this._offset + 0] = (byte)(type & 0xFF);
    }

    public final int getType() {
        return this._data_[this._offset + 0] & 0xFF;
    }

    public final void setCode(int code) {
        this._data_[this._offset + 1] = (byte)(code & 0xFF);
    }

    public final int computeICMPChecksum(boolean update) {
        return this._computeChecksum_(this._offset, this._offset + 2, this.getIPPacketLength(), 0, update);
    }

    public final int computeICMPChecksum() {
        return this.computeICMPChecksum(true);
    }
}

