/*
 * Decompiled with CFR 0.152.
 */
package org.savarese.vserv.tcpip;

import java.net.InetAddress;
import java.net.UnknownHostException;

public class IPPacket {
    protected byte[] _data_;

    public IPPacket(int size) {
        this.setData(new byte[size]);
    }

    public void setData(byte[] data) {
        this._data_ = data;
    }

    public void setIPHeaderLength(int length) {
        this._data_[0] = (byte)(this._data_[0] & 0xF0);
        this._data_[0] = (byte)(this._data_[0] | length & 0xF);
    }

    public final int getIPHeaderLength() {
        return this._data_[0] & 0xF;
    }

    public final int getIPHeaderByteLength() {
        return this.getIPHeaderLength() << 2;
    }

    public final void setIPPacketLength(int length) {
        this._data_[2] = (byte)(length >> 8 & 0xFF);
        this._data_[3] = (byte)(length & 0xFF);
    }

    public final int getIPPacketLength() {
        return (this._data_[2] & 0xFF) << 8 | this._data_[3] & 0xFF;
    }

    public final int getTTL() {
        return this._data_[8];
    }

    protected int _computeChecksum_(int startOffset, int checksumOffset, int length, int virtualHeaderTotal, boolean update) {
        int total = 0;
        int i = startOffset;
        int imax = checksumOffset;
        while (i < imax) {
            total += (this._data_[i++] & 0xFF) << 8 | this._data_[i++] & 0xFF;
        }
        i = checksumOffset + 2;
        imax = length - length % 2;
        while (i < imax) {
            total += (this._data_[i++] & 0xFF) << 8 | this._data_[i++] & 0xFF;
        }
        if (i < length) {
            total += (this._data_[i] & 0xFF) << 8;
        }
        total += virtualHeaderTotal;
        while ((total & 0xFFFF0000) != 0) {
            total = (total & 0xFFFF) + (total >>> 16);
        }
        total = ~total & 0xFFFF;
        if (update) {
            this._data_[checksumOffset] = (byte)(total >> 8);
            this._data_[checksumOffset + 1] = (byte)(total & 0xFF);
        }
        return total;
    }

    public final void getSource(byte[] address) {
        System.arraycopy(this._data_, 12, address, 0, address.length < 4 ? address.length : 4);
    }

    public final InetAddress getSourceAsInetAddress() throws UnknownHostException {
        byte[] octets = new byte[4];
        this.getSource(octets);
        return InetAddress.getByAddress(octets);
    }
}

