/*
 * Decompiled with CFR 0.152.
 */
package pilot.simplerpg;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pilot.simplerpg.SimpleRPG;
import pilot.simplerpg.capabilities.IRpgPlayer;
import pilot.simplerpg.capabilities.RpgPlayerProvider;
import pilot.simplerpg.item.ItemMagicStick;

@SideOnly(value=Side.CLIENT)
public class GuiOverlay
extends Gui {
    private Minecraft mc;

    public GuiOverlay(Minecraft mc) {
        this.mc = mc;
    }

    @SubscribeEvent
    public void renderHealth(RenderGameOverlayEvent e) {
        if (!SimpleRPG.CustomHealthBar) {
            return;
        }
        if (e.getType() == RenderGameOverlayEvent.ElementType.ARMOR) {
            ScaledResolution res = new ScaledResolution(this.mc);
            int l = res.func_78326_a() / 2 - 91;
            int i3 = this.mc.field_71439_g.func_70658_aO();
            int j1 = res.func_78328_b() - 39;
            float f = 20.0f;
            int l1 = MathHelper.func_76123_f((float)(f / 2.0f / 10.0f));
            int i2 = Math.max(10 - (l1 - 2), 3);
            int j2 = j1 - (l1 - 1) * i2 - 10;
            for (int k3 = 0; k3 < 10; ++k3) {
                if (i3 <= 0) continue;
                int l3 = l + k3 * 8;
                if (k3 * 2 + 1 < i3) {
                    this.func_73729_b(l3, j2, 34, 9, 9, 9);
                }
                if (k3 * 2 + 1 == i3) {
                    this.func_73729_b(l3, j2, 25, 9, 9, 9);
                }
                if (k3 * 2 + 1 <= i3) continue;
                this.func_73729_b(l3, j2, 16, 9, 9, 9);
            }
            e.setCanceled(true);
        } else if (e.getType() == RenderGameOverlayEvent.ElementType.HEALTH) {
            FontRenderer font = this.mc.field_71466_p;
            ScaledResolution res = new ScaledResolution(this.mc);
            int width = res.func_78326_a();
            int height = res.func_78328_b();
            double percent = this.mc.field_71439_g.func_110143_aJ() / this.mc.field_71439_g.func_110138_aP();
            String str = String.format("%.0f/%.0f", Float.valueOf(this.mc.field_71439_g.func_110143_aJ() + this.mc.field_71439_g.func_110139_bj()), Float.valueOf(this.mc.field_71439_g.func_110138_aP()));
            if (font.func_78256_a(str) > 79) {
                str = String.format("%.0f", Float.valueOf(this.mc.field_71439_g.func_110138_aP() + this.mc.field_71439_g.func_110139_bj()));
            }
            this.rect(width / 2 - 91, height - 40, 81, 9, 0x7F000000);
            this.rect(width / 2 - 90, height - 39, 79, 7, 0x3F000000);
            this.rect(width / 2 - 90, height - 39, (int)(percent * 79.0), 7, -1073807360);
            this.string(str, width / 2 - 90, height - 39, 0xFFFFFF);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.mc.func_110434_K().func_110577_a(field_110324_m);
            e.setCanceled(true);
        } else {
            return;
        }
    }

    @SubscribeEvent
    public void render(RenderGameOverlayEvent.Post e) {
        if (e.getType() != RenderGameOverlayEvent.ElementType.EXPERIENCE) {
            return;
        }
        IRpgPlayer rpg = (IRpgPlayer)this.mc.field_71439_g.getCapability(RpgPlayerProvider.RPG_PLAYER_CAP, null);
        if (rpg == null) {
            return;
        }
        FontRenderer font = this.mc.field_71466_p;
        ScaledResolution res = new ScaledResolution(this.mc);
        int xpBarWidth = (int)(Math.abs(SimpleRPG.XpBarWidth) * (double)res.func_78326_a());
        int xpBarHeight = (int)(Math.abs(SimpleRPG.XpBarHeight) * (double)res.func_78328_b());
        if (SimpleRPG.SizeMode.equals("PIXELS")) {
            xpBarWidth = (int)Math.abs(SimpleRPG.XpBarWidth);
            xpBarHeight = (int)Math.abs(SimpleRPG.XpBarHeight);
        }
        String str = String.format("\u7ecf\u9a8c: %.2f/%.2f", rpg.getXP() - rpg.getXPReq(rpg.getLevel() - 1), rpg.getXPReq(rpg.getLevel()) - rpg.getXPReq(rpg.getLevel() - 1));
        double percent = (rpg.getXP() - rpg.getXPReq(rpg.getLevel() - 1)) / (rpg.getXPReq(rpg.getLevel()) - rpg.getXPReq(rpg.getLevel() - 1));
        if (rpg.getLevel() >= SimpleRPG.MaxLevel || rpg.getXP() == Double.POSITIVE_INFINITY) {
            percent = 1.0;
            str = "\u7ecf\u9a8c: \u6700\u5927\u7b49\u7ea7";
        }
        this.rect(SimpleRPG.XpBarX, SimpleRPG.XpBarY, xpBarWidth, xpBarHeight, 0x7F000000);
        this.rect(SimpleRPG.XpBarX + 1, SimpleRPG.XpBarY + 1, xpBarWidth - 2, xpBarHeight - 2, 0x3F000000);
        if (Math.abs(SimpleRPG.XpBarWidth) >= Math.abs(SimpleRPG.XpBarHeight)) {
            if (SimpleRPG.XpBarWidth > 0.0) {
                this.rect(SimpleRPG.XpBarX + 1, SimpleRPG.XpBarY + 1, (int)(percent * (double)(xpBarWidth - 2)), xpBarHeight - 2, 2142699264);
            } else {
                this.rect(SimpleRPG.XpBarX + (int)((1.0 - percent) * (double)(xpBarWidth - 2)) + 2, SimpleRPG.XpBarY + 1, (int)(percent * (double)(xpBarWidth - 2)), xpBarHeight - 2, 2142699264);
            }
            if (SimpleRPG.XpBarY >= 0) {
                this.rect(SimpleRPG.XpBarX + xpBarWidth - font.func_78256_a(str) - 1, SimpleRPG.XpBarY + xpBarHeight, font.func_78256_a(str) + 1, 9, 0x7F000000);
                this.string(str, SimpleRPG.XpBarX + xpBarWidth - font.func_78256_a(str), SimpleRPG.XpBarY + xpBarHeight + 1, 0xFFFFFF);
                str = String.format("\u7b49\u7ea7: %d", rpg.getLevel());
                this.rect(SimpleRPG.XpBarX, SimpleRPG.XpBarY + xpBarHeight, font.func_78256_a(str) + 1, 9, 0x7F000000);
                this.string(str, SimpleRPG.XpBarX + 1, SimpleRPG.XpBarY + xpBarHeight + 1, 0xFFFFFF);
            } else {
                this.rect(SimpleRPG.XpBarX + xpBarWidth - font.func_78256_a(str) - 1, SimpleRPG.XpBarY - (xpBarHeight + 4), font.func_78256_a(str) + 1, 9, 0x7F000000);
                this.string(str, SimpleRPG.XpBarX + xpBarWidth - font.func_78256_a(str), SimpleRPG.XpBarY - (xpBarHeight + 4) + 1, 0xFFFFFF);
                str = String.format("\u7b49\u7ea7: %d", rpg.getLevel());
                this.rect(SimpleRPG.XpBarX, SimpleRPG.XpBarY - (xpBarHeight + 4), font.func_78256_a(str) + 1, 9, 0x7F000000);
                this.string(str, SimpleRPG.XpBarX + 1, SimpleRPG.XpBarY - (xpBarHeight + 4) + 1, 0xFFFFFF);
            }
        } else {
            if (SimpleRPG.XpBarHeight > 0.0) {
                this.rect(SimpleRPG.XpBarX + 1, SimpleRPG.XpBarY + 1, xpBarWidth - 2, (int)(percent * (double)(xpBarHeight - 2)), 2142699264);
            } else {
                this.rect(SimpleRPG.XpBarX + 1, SimpleRPG.XpBarY + (int)((1.0 - percent) * (double)(xpBarHeight - 2)) + 2, xpBarWidth - 2, (int)(percent * (double)(xpBarHeight - 2)), 2142699264);
            }
            if (SimpleRPG.XpBarX >= 0) {
                this.rect(SimpleRPG.XpBarX + xpBarWidth, SimpleRPG.XpBarY + xpBarHeight - 9, font.func_78256_a(str) + 1, 9, 0x7F000000);
                this.string(str, SimpleRPG.XpBarX + xpBarWidth + 1, SimpleRPG.XpBarY + xpBarHeight - 8, 0xFFFFFF);
                str = String.format("\u7b49\u7ea7: %d", rpg.getLevel());
                this.rect(SimpleRPG.XpBarX + xpBarWidth, SimpleRPG.XpBarY, font.func_78256_a(str) + 1, 9, 0x7F000000);
                this.string(str, SimpleRPG.XpBarX + xpBarWidth + 1, SimpleRPG.XpBarY + 1, 0xFFFFFF);
            } else {
                this.rect(SimpleRPG.XpBarX - (xpBarWidth + font.func_78256_a(str) - 4), SimpleRPG.XpBarY + xpBarHeight - 9, font.func_78256_a(str) + 1, 9, 0x7F000000);
                this.string(str, SimpleRPG.XpBarX - (xpBarWidth + font.func_78256_a(str) - 5), SimpleRPG.XpBarY + xpBarHeight - 8, 0xFFFFFF);
                str = String.format("\u7b49\u7ea7: %d", rpg.getLevel());
                this.rect(SimpleRPG.XpBarX - (xpBarWidth + font.func_78256_a(str) - 4), SimpleRPG.XpBarY, font.func_78256_a(str) + 1, 9, 0x7F000000);
                this.string(str, SimpleRPG.XpBarX - (xpBarWidth + font.func_78256_a(str) - 5), SimpleRPG.XpBarY + 1, 0xFFFFFF);
            }
        }
        ItemStack held = this.mc.field_71439_g.func_184614_ca();
        if (held != null && held.func_77973_b() instanceof ItemMagicStick || rpg.getMana() < rpg.getMaxMana()) {
            percent = Math.min(rpg.getMana() / rpg.getMaxMana(), 1.0);
            str = String.format("%.0f/%.0f", rpg.getMana(), rpg.getMaxMana());
            this.rect(res.func_78326_a() / 2 - 91, 29, 182, 5, 0x7F000000);
            this.rect(res.func_78326_a() / 2 - 90, 30, 180, 3, 0x3F000000);
            this.rect(res.func_78326_a() / 2 - 90, 30, (int)(180.0 * percent), 3, -1090518785);
            this.rect(res.func_78326_a() / 2 - 91, 34, font.func_78256_a(str) + 1, 9, 0x7F000000);
            this.string(str, res.func_78326_a() / 2 - 90, 35, 0xFFFFFF);
            str = String.format("\u6a21\u5f0f: %s", rpg.getMode().getName());
            this.rect(res.func_78326_a() / 2 - 91, 20, font.func_78256_a(str) + 1, 9, 0x7F000000);
            this.string(str, res.func_78326_a() / 2 - 90, 21, 0xFFFFFF);
        }
    }

    public void rect(int x, int y, int width, int height, int color) {
        ScaledResolution res = new ScaledResolution(this.mc);
        if (y < 0) {
            if (x >= 0) {
                GuiOverlay.func_73734_a((int)x, (int)(res.func_78328_b() + y), (int)(x + width), (int)(res.func_78328_b() + y + height), (int)color);
            } else {
                GuiOverlay.func_73734_a((int)(res.func_78326_a() + x), (int)(res.func_78328_b() + y), (int)(res.func_78326_a() + x + width), (int)(res.func_78328_b() + y + height), (int)color);
            }
        } else if (x >= 0) {
            GuiOverlay.func_73734_a((int)x, (int)y, (int)(x + width), (int)(y + height), (int)color);
        } else {
            GuiOverlay.func_73734_a((int)(res.func_78326_a() + x), (int)y, (int)(res.func_78326_a() + x + width), (int)(y + height), (int)color);
        }
    }

    public void string(String text, int x, int y, int color) {
        FontRenderer font = this.mc.field_71466_p;
        ScaledResolution res = new ScaledResolution(this.mc);
        if (y < 0) {
            if (x >= 0) {
                font.func_78276_b(text, x, res.func_78328_b() + y, color);
            } else {
                font.func_78276_b(text, res.func_78326_a() + x, res.func_78328_b() + y, color);
            }
        } else if (x >= 0) {
            font.func_78276_b(text, x, y, color);
        } else {
            font.func_78276_b(text, res.func_78326_a() + x, y, color);
        }
    }
}

