/*
 * Decompiled with CFR 0.152.
 */
package pilot.simplerpg;

import net.minecraft.command.ICommand;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import pilot.simplerpg.ModEventHandle;
import pilot.simplerpg.capabilities.CapabilityRpgPlayer;
import pilot.simplerpg.capabilities.IRpgPlayer;
import pilot.simplerpg.capabilities.RpgPlayer;
import pilot.simplerpg.command.CommandSet;
import pilot.simplerpg.command.CommandStats;
import pilot.simplerpg.packet.PacketDispatcher;
import pilot.simplerpg.proxy.CommonProxy;

@Mod(modid="simplerpg", version="2.2", acceptedMinecraftVersions="[1.11.2]")
public class SimpleRPG {
    public static final String MODID = "simplerpg";
    public static final String VERSION = "2.2";
    @SidedProxy(clientSide="pilot.simplerpg.proxy.ClientProxy", serverSide="pilot.simplerpg.proxy.ServerProxy")
    public static CommonProxy proxy;
    public static SimpleRPG instance;
    public static boolean RenderOverlay;
    public static boolean CustomHealthBar;
    public static String SizeMode;
    public static int XpBarX;
    public static int XpBarY;
    public static double XpBarWidth;
    public static double XpBarHeight;
    public static int MaxLevel;
    public static float BaseHealth;
    public static float HealthFlat;
    public static float HealthRate;
    public static double BaseXP;
    public static double XpExponent;
    public static float AttackVar;
    public static float BaseAttack;
    public static float AttackRate;
    public static float AttackFlat;
    public static double MaxAttack;
    public static boolean DamageBasedXP;
    public static double DamageVal;
    public static double HealthVal;
    public static double AttackVal;
    public static double ArmorVal;
    public static String DeathMode;
    public static boolean EnableMagic;
    public static double MagicBase;
    public static double MagicFlat;
    public static double MagicCap;
    public static double HealthConversion;
    public static int FireTime;
    public static int BlindTime;
    public static int SlowTime;
    public static double WindStrength;
    public static double[] DifficultyMultipliers;
    public static double[] ManaCosts;
    public static double[] BaseDamages;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        RenderOverlay = config.getBoolean("RenderOverlay", "client", true, "If the mod's overlay should render.");
        CustomHealthBar = config.getBoolean("RenderCustomHealth", "client", true, "If the mod's custom health bar should render. If RenderOverlay is false this won't have any effect.");
        SizeMode = config.getString("SizeMode", "client", "PERCENTAGES", "How the values of XpBarWidth and XpBarHeight are used.\nPERCENTAGES - The values are used as a percentage of the screen size\nPIXELS - The values are the exact size in pixels", new String[]{"PERCENTAGES", "PIXELS"});
        XpBarX = config.getInt("XpBarX", "client", 0, Short.MIN_VALUE, 32768, "The X-position of the experience bar.");
        XpBarY = config.getInt("XpBarY", "client", 0, Short.MIN_VALUE, 32768, "The Y-position of the experience bar.");
        XpBarWidth = config.get("client", "XpBarWidth", 1.0, "The width of the experience bar. Positive values fill from left to right, negative from right to left. If XpBarHeight is greater, than it fills vertically instead.", -32768.0, 32768.0).getDouble();
        XpBarHeight = config.get("client", "XpBarHeight", 0.020833333333333332, "The height of the experience bar. Positive values fill from top to bottom, negative from bottom to top. If XpBarWidth is greater, than it fills horizontally instead.", -32768.0, 32768.0).getDouble();
        MaxLevel = config.getInt("MaxLevel", "player", 999, 1, Integer.MAX_VALUE, "The max level any player can get.");
        BaseHealth = config.getFloat("BaseHealth", "player", 20.0f, 1.0f, Float.MAX_VALUE, "The base health of the player.");
        HealthFlat = config.getFloat("HealthFlatRate", "player", 2.0f, 0.0f, Float.MAX_VALUE, "The flat rate that the player's health increases by every level.");
        HealthRate = config.getFloat("HealthRate", "player", 0.0075f, 0.0f, Float.MAX_VALUE, "The rate that the player's health multiplier increases by every level.");
        BaseXP = config.get("player", "BaseExperience", 20.0, "The amount of experience the player needs to go from level 1 to 2", 1.0, Double.MAX_VALUE).getDouble();
        AttackFlat = config.getFloat("AttackFlatRate", "player", 1.0f, 0.0f, Float.MAX_VALUE, "The flat rate that the player's attack increases by every level.");
        AttackRate = config.getFloat("AttackRate", "player", 0.005f, 0.0f, Float.MAX_VALUE, "The rate that the player's attack multipliers increases by every level.");
        MaxAttack = config.get("player", "MaxAttack", 2.147483647E9, "The max attack a player can have from leveling.", 1.0, Double.MAX_VALUE).getDouble();
        BaseAttack = config.getFloat("BaseAttack", "player", 0.75f, 0.0f, Float.MAX_VALUE, "The minimum damage multiplier you can get for an attack.");
        AttackVar = config.getFloat("AttackVariation", "player", 0.5f, 0.0f, Float.MAX_VALUE, "The amount of variation in attack damage.");
        XpExponent = config.get("player", "XpExponent", 1.05, "The exponent in the exponential function that determines the experience needed to level up.", 1.0, Double.MAX_VALUE).getDouble();
        DamageBasedXP = config.getBoolean("DamageBasedXpMode", "experience", false, "IF this is true then instead of gaining XP by killing mobs, you gain it based on damage dealt.");
        DamageVal = config.get("experience", "DamageValue", 0.13333333333333333, "The amount of experience you gain per half-heart of damage dealt if DamageBasedXpMode is true.", 0.0, Double.MAX_VALUE).getDouble();
        HealthVal = config.get("experience", "HealthValue", 0.05, "The amount of experience a mob is worth per half-heart of health.", 0.0, Double.MAX_VALUE).getDouble();
        AttackVal = config.get("experience", "AttackValue", 0.1, "The amount of experience a mob is worth per half-heart of damage it does.", 0.0, Double.MAX_VALUE).getDouble();
        ArmorVal = config.get("experience", "ArmorValue", 0.1, "The amount of experience a mob is worth per armor point it has.", 0.0, Double.MAX_VALUE).getDouble();
        DifficultyMultipliers = config.get("experience", "DifficultMultiplers", new double[]{0.25, 0.75, 1.0, 1.25, 1.5}, "The experience multiplier for each difficulty in the order [Peaceful, Easy, Normal, Hard, Hardcore]. Note that if the list is not at least 5 elements long the game will crash on killing a mob.", 0.0, Double.MAX_VALUE).getDoubleList();
        DeathMode = config.getString("DeathMode", "experience", "KEEP", "How death affects the player's experience and levels.\n  KEEP - Keep all experience and levels\n  KEEPINVENTORY - Keep all experience and levels only if keepInventory is enabled\n  LOOSE - Loose all experience and levels\n  0.0-1.0 - Loose a percentage of experience gained on the current level");
        EnableMagic = config.getBoolean("EnableMagic", "magic", true, "Should the magic part (and related items) of the mod be enabled.");
        MagicBase = config.get("magic", "ManaBase", 10.0, "The amount of mana a player has at level 1.", 0.0, Double.MAX_VALUE).getDouble();
        MagicFlat = config.get("magic", "ManaFlatRate", 0.125, "The amount of mana a player gains per level.", 0.0, Double.MAX_VALUE).getDouble();
        MagicCap = config.get("magic", "ManaLimit", Double.MAX_VALUE, "The most mana a player can ever have.", 0.0, Double.MAX_VALUE).getDouble();
        HealthConversion = config.get("magic", "DamageRate", 0.5, "The mana cost per half-heart of damage reduced in Passive mode.", 0.0, Double.MAX_VALUE).getDouble();
        ManaCosts = config.get("magic", "ManaCosts", new double[]{3.0, 4.0, 5.0, 4.0}, "The mana costs of each of the active modes in the order [Fire, Lightning, Void, Wind]. Must contain 4 values.", 0.0, Double.MAX_VALUE).getDoubleList();
        BaseDamages = config.get("magic", "MagicBaseDamage", new double[]{4.0, 5.0, 2.0}, "The base damage of the active magic modes that deal damage directly in the order [Fire, Void, Wind]. Must contain 3 values.", 0.0, Double.MAX_VALUE).getDoubleList();
        FireTime = config.getInt("FireTime", "magic", 5, 1, 0x3FFFFFFF, "The amount of time, in seconds, entities attacked using Fire Mode are set on fire for at level 1.");
        BlindTime = config.getInt("BlindTime", "magic", 600, 0, 0x3FFFFFFF, "The amount of time, in ticks, entities attacked using Void Mode are blinded for at level 1.");
        SlowTime = config.getInt("SlowTime", "magic", 300, 0, 0x3FFFFFFF, "The amount of time, in ticks, entities attacked using Void Mode are slowed for at level 1.");
        WindStrength = config.get("magic", "WindStrength", 1.2, "The amount of vertical velocity entities hit using Wind Mode gain.", 0.0, Double.MAX_VALUE).getDouble();
        config.save();
        CapabilityManager.INSTANCE.register(IRpgPlayer.class, (Capability.IStorage)new CapabilityRpgPlayer(), RpgPlayer.class);
        MinecraftForge.EVENT_BUS.register((Object)new ModEventHandle());
        proxy.PreInit(event);
        PacketDispatcher.registerPackets();
    }

    @Mod.EventHandler
    public void Init(FMLInitializationEvent event) {
        proxy.Init(event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.PostInit(event);
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent e) {
        e.registerServerCommand((ICommand)new CommandStats());
        e.registerServerCommand((ICommand)new CommandSet());
    }

    static {
        instance = new SimpleRPG();
    }

    public static enum MagicMode {
        PASSIVE("passive"),
        FIRE("fire"),
        LIGHTNING("lightning"),
        VOID("void"),
        WIND("wind");

        private String name;

        public String getName() {
            return I18n.func_74838_a((String)("mode." + this.name + ".name"));
        }

        private MagicMode(String name) {
            this.name = name;
        }
    }
}

