/*
 * Decompiled with CFR 0.152.
 */
package pilot.simplerpg.capabilities;

import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import pilot.simplerpg.SimpleRPG;
import pilot.simplerpg.capabilities.IRpgPlayer;

public class RpgPlayer
implements IRpgPlayer {
    private int level = 1;
    private double xp = 0.0;
    private double mana = this.maxMana = SimpleRPG.MagicBase;
    private double maxMana;
    private SimpleRPG.MagicMode mode = SimpleRPG.MagicMode.FIRE;

    @Override
    public void update(EntityPlayer player) {
        while (this.level < SimpleRPG.MaxLevel && this.xp >= this.getXPReq(this.level) && this.xp != Double.POSITIVE_INFINITY) {
            ++this.level;
        }
        if (player.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b() < (double)(SimpleRPG.BaseHealth + SimpleRPG.HealthFlat * (float)(this.level - 1)) * (1.0 + (double)SimpleRPG.HealthRate * (double)(this.level - 1))) {
            player.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)(SimpleRPG.BaseHealth + SimpleRPG.HealthFlat * (float)(this.level - 1)) * (1.0 + (double)SimpleRPG.HealthRate * (double)(this.level - 1)));
        }
        if (this.maxMana < Math.floor(SimpleRPG.MagicBase + SimpleRPG.MagicFlat * (double)(this.level - 1))) {
            this.maxMana = Math.floor(SimpleRPG.MagicBase + SimpleRPG.MagicFlat * (double)(this.level - 1));
        }
        if (this.mana < this.maxMana) {
            double rate = Math.max(this.mana / this.maxMana * (this.mana / this.maxMana), 0.1);
            this.mana = Math.min(this.mana + this.maxMana * 0.0025 * rate, this.maxMana);
        }
    }

    @Override
    public void addXP(double amt) {
        this.xp += amt;
    }

    @Override
    public void setStats(int level, double xp) {
        this.level = level;
        this.xp = xp;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public double getXP() {
        return this.xp;
    }

    @Override
    public double getXPReq(int level) {
        if (Math.pow(SimpleRPG.XpExponent, level) == Double.POSITIVE_INFINITY) {
            return Double.POSITIVE_INFINITY;
        }
        double val = 0.0;
        for (int i = 0; i < level; ++i) {
            val += Math.pow(SimpleRPG.XpExponent, i) * SimpleRPG.BaseXP;
        }
        return val;
    }

    @Override
    public void setMana(double amt) {
        this.mana = amt;
        if (this.mana > this.maxMana) {
            this.mana = this.maxMana;
        }
    }

    @Override
    public void addMana(double amt) {
        this.mana += amt;
        if (this.mana > this.maxMana) {
            this.mana = this.maxMana;
        }
    }

    @Override
    public double getMana() {
        return this.mana;
    }

    @Override
    public double getMaxMana() {
        return this.maxMana;
    }

    @Override
    public void setMaxMana(double amt) {
        this.maxMana = amt;
    }

    @Override
    public SimpleRPG.MagicMode getMode() {
        return this.mode;
    }

    @Override
    public void setMode(SimpleRPG.MagicMode mode) {
        this.mode = mode;
    }
}

