/*
 * Decompiled with CFR 0.152.
 */
package pilot.simplerpg.command;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import pilot.simplerpg.SimpleRPG;
import pilot.simplerpg.capabilities.IRpgPlayer;
import pilot.simplerpg.capabilities.RpgPlayerProvider;

public class CommandStats
implements ICommand {
    private List<String> aliases = new ArrayList<String>();

    public CommandStats() {
        this.aliases.add("simplerpg_stats");
        this.aliases.add("pilotsrpg_stats");
    }

    public int compareTo(ICommand o) {
        return 0;
    }

    public String func_71517_b() {
        return "simplerpg_stats";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/simplerpg_stats [player]";
    }

    public List<String> func_71514_a() {
        return this.aliases;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length != 0 && args.length != 1) {
            throw new CommandException("Incorrect number of arguments, got " + args.length + ", expected 0 or 1.", new Object[0]);
        }
        if (sender.func_174793_f() == null || sender.func_174793_f() != null && !(sender.func_174793_f() instanceof EntityPlayer)) {
            throw new CommandException("Sender must be a player!", new Object[0]);
        }
        if (args.length == 0) {
            EntityPlayer p = (EntityPlayer)sender.func_174793_f();
            IRpgPlayer rpg = (IRpgPlayer)p.getCapability(RpgPlayerProvider.RPG_PLAYER_CAP, null);
            sender.func_145747_a((ITextComponent)new TextComponentString(String.format("Level: \u00a7a%d\u00a7r", rpg.getLevel())));
            if (rpg.getLevel() >= SimpleRPG.MaxLevel || rpg.getXP() == Double.POSITIVE_INFINITY) {
                sender.func_145747_a((ITextComponent)new TextComponentString("XP: \u00a76MAX LEVEL\u00a7r"));
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentString(String.format("XP: \u00a7e%.2f\u00a7r", rpg.getXP())));
                sender.func_145747_a((ITextComponent)new TextComponentString(String.format("Next Level: \u00a76%.2f\u00a7r", rpg.getXPReq(rpg.getLevel()))));
            }
            sender.func_145747_a((ITextComponent)new TextComponentString(String.format("Attack: \u00a7c%.2f\u00a7r", Math.floor(Math.min((double)((1.0f + SimpleRPG.AttackFlat * (float)(rpg.getLevel() - 1)) * (1.0f + SimpleRPG.AttackRate * (float)(rpg.getLevel() - 1))), SimpleRPG.MaxAttack)))));
        } else {
            PlayerList players = server.func_184103_al();
            String[] names = players.func_72369_d();
            EntityPlayerMP p = null;
            for (int i = 0; i < names.length; ++i) {
                if (!args[0].equals(names[i])) continue;
                p = players.func_152612_a(args[0]);
                break;
            }
            if (p == null) {
                throw new CommandException("Could not find the player '" + args[0] + "'!", new Object[0]);
            }
            IRpgPlayer rpg = (IRpgPlayer)p.getCapability(RpgPlayerProvider.RPG_PLAYER_CAP, null);
            sender.func_145747_a((ITextComponent)new TextComponentString("Stats for player '" + args[0] + "':"));
            sender.func_145747_a((ITextComponent)new TextComponentString(String.format("  Level: \u00a7a%d\u00a7r", rpg.getLevel())));
            if (rpg.getLevel() >= SimpleRPG.MaxLevel || rpg.getXP() == Double.POSITIVE_INFINITY) {
                sender.func_145747_a((ITextComponent)new TextComponentString("  XP: \u00a76MAX LEVEL\u00a7r"));
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentString(String.format("  XP: \u00a7e%.2f\u00a7r", rpg.getXP())));
                sender.func_145747_a((ITextComponent)new TextComponentString(String.format("  Next Level: \u00a76%.2f\u00a7r", rpg.getXPReq(rpg.getLevel()))));
            }
            sender.func_145747_a((ITextComponent)new TextComponentString(String.format("  Attack: \u00a7c%.2f\u00a7r", Math.floor(Math.min((double)((1.0f + SimpleRPG.AttackFlat * (float)(rpg.getLevel() - 1)) * (1.0f + SimpleRPG.AttackRate * (float)(rpg.getLevel() - 1))), SimpleRPG.MaxAttack)))));
        }
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        ArrayList<String> tabCompletions = new ArrayList<String>();
        if (args.length == 1) {
            PlayerList players = server.func_184103_al();
            String[] names = players.func_72369_d();
            for (int i = 0; i < names.length; ++i) {
                tabCompletions.add(names[i]);
            }
        }
        return tabCompletions;
    }

    public boolean func_82358_a(String[] args, int index) {
        return index == 0;
    }
}

