/*
 * Decompiled with CFR 0.152.
 */
package pilot.simplerpg.packet.client;

import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.relauncher.Side;
import pilot.simplerpg.SimpleRPG;
import pilot.simplerpg.capabilities.IRpgPlayer;
import pilot.simplerpg.capabilities.RpgPlayerProvider;
import pilot.simplerpg.packet.AbstractMessage;

public class SyncRpgData
extends AbstractMessage.AbstractClientMessage<SyncRpgData> {
    private int level;
    private byte mode;
    private double xp;
    private double mana;
    private double maxMana;

    public SyncRpgData() {
    }

    public SyncRpgData(IRpgPlayer rpg) {
        this.level = rpg.getLevel();
        this.xp = rpg.getXP();
        this.mana = rpg.getMana();
        this.maxMana = rpg.getMaxMana();
        switch (rpg.getMode()) {
            case PASSIVE: {
                this.mode = 0;
                break;
            }
            case FIRE: {
                this.mode = 1;
                break;
            }
            case LIGHTNING: {
                this.mode = (byte)2;
                break;
            }
            case WIND: {
                this.mode = (byte)3;
                break;
            }
            case VOID: {
                this.mode = (byte)4;
                break;
            }
            default: {
                this.mode = (byte)-1;
            }
        }
    }

    @Override
    protected void read(PacketBuffer buffer) throws IOException {
        this.level = buffer.readInt();
        this.xp = buffer.readDouble();
        this.mana = buffer.readDouble();
        this.maxMana = buffer.readDouble();
        this.mode = buffer.readByte();
    }

    @Override
    protected void write(PacketBuffer buffer) throws IOException {
        buffer.writeInt(this.level);
        buffer.writeDouble(this.xp);
        buffer.writeDouble(this.mana);
        buffer.writeDouble(this.maxMana);
        buffer.writeByte((int)this.mode);
    }

    @Override
    public void process(EntityPlayer player, Side side) {
        IRpgPlayer rpg = (IRpgPlayer)player.getCapability(RpgPlayerProvider.RPG_PLAYER_CAP, null);
        rpg.setStats(this.level, this.xp);
        rpg.setMaxMana(this.maxMana);
        rpg.setMana(this.mana);
        switch (this.mode) {
            case 0: {
                rpg.setMode(SimpleRPG.MagicMode.PASSIVE);
                break;
            }
            case 1: {
                rpg.setMode(SimpleRPG.MagicMode.FIRE);
                break;
            }
            case 2: {
                rpg.setMode(SimpleRPG.MagicMode.LIGHTNING);
                break;
            }
            case 3: {
                rpg.setMode(SimpleRPG.MagicMode.WIND);
                break;
            }
            case 4: {
                rpg.setMode(SimpleRPG.MagicMode.VOID);
                break;
            }
            default: {
                rpg.setMode(SimpleRPG.MagicMode.PASSIVE);
            }
        }
    }
}

