/*
 * Decompiled with CFR 0.152.
 */
package pilot.simplerpg.item;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import pilot.simplerpg.SimpleRPG;
import pilot.simplerpg.capabilities.IRpgPlayer;
import pilot.simplerpg.capabilities.RpgPlayerProvider;

public class ItemMagicStick
extends Item {
    public ItemMagicStick() {
        this.field_77777_bU = 1;
        this.setRegistryName("magic_stick");
        this.func_77655_b("magicstick");
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemstack, World world, EntityPlayer player, EnumHand hand) {
        block18: {
            SimpleRPG.MagicMode mode;
            IRpgPlayer rpg;
            block22: {
                block21: {
                    block20: {
                        block19: {
                            if (!SimpleRPG.EnableMagic) break block18;
                            rpg = (IRpgPlayer)player.getCapability(RpgPlayerProvider.RPG_PLAYER_CAP, null);
                            mode = rpg.getMode();
                            if (!player.func_70093_af()) break block19;
                            switch (mode) {
                                case PASSIVE: {
                                    rpg.setMode(SimpleRPG.MagicMode.FIRE);
                                    break;
                                }
                                case FIRE: {
                                    rpg.setMode(SimpleRPG.MagicMode.LIGHTNING);
                                    break;
                                }
                                case LIGHTNING: {
                                    rpg.setMode(SimpleRPG.MagicMode.WIND);
                                    break;
                                }
                                case WIND: {
                                    rpg.setMode(SimpleRPG.MagicMode.VOID);
                                    break;
                                }
                                case VOID: {
                                    rpg.setMode(SimpleRPG.MagicMode.PASSIVE);
                                    break;
                                }
                                default: {
                                    rpg.setMode(SimpleRPG.MagicMode.PASSIVE);
                                    break;
                                }
                            }
                            break block18;
                        }
                        if (mode != SimpleRPG.MagicMode.FIRE) break block20;
                        if (world.field_72995_K) break block18;
                        if (rpg.getMana() < SimpleRPG.ManaCosts[0]) {
                            return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
                        }
                        rpg.addMana(-SimpleRPG.ManaCosts[0]);
                        RayTraceResult trace = this.func_77621_a(world, player, false);
                        if (trace == null || trace.field_72313_a == RayTraceResult.Type.ENTITY) {
                            return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
                        }
                        List loaded = world.field_72996_f;
                        for (Entity e : loaded) {
                            EntityLivingBase living;
                            if (e == null || !(e instanceof EntityLivingBase) || !(Math.sqrt((living = (EntityLivingBase)e).func_174831_c(trace.func_178782_a())) <= 5.0)) continue;
                            double atk = Math.floor(Math.min((double)((1.0f + SimpleRPG.AttackFlat * (float)(rpg.getLevel() - 1)) * (1.0f + SimpleRPG.AttackRate * (float)(rpg.getLevel() - 1))), SimpleRPG.MaxAttack));
                            float amt = (float)SimpleRPG.BaseDamages[0] * (float)(1.0 + atk * 0.1);
                            living.func_70097_a(DamageSource.field_76372_a, amt);
                            living.func_70015_d(SimpleRPG.FireTime + (int)((double)rpg.getLevel() / (double)SimpleRPG.MaxLevel * ((double)SimpleRPG.FireTime * 0.6)));
                        }
                        break block18;
                    }
                    if (mode != SimpleRPG.MagicMode.LIGHTNING) break block21;
                    if (world.field_72995_K) break block18;
                    if (rpg.getMana() < SimpleRPG.ManaCosts[1]) {
                        return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
                    }
                    rpg.addMana(-SimpleRPG.ManaCosts[1]);
                    RayTraceResult trace = this.func_77621_a(world, player, false);
                    if (trace == null || trace.field_72313_a == RayTraceResult.Type.ENTITY) {
                        return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
                    }
                    BlockPos pos = trace.func_178782_a();
                    EntityLightningBolt bolt = new EntityLightningBolt(world, (double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), false);
                    world.func_72838_d((Entity)bolt);
                    break block18;
                }
                if (mode != SimpleRPG.MagicMode.VOID) break block22;
                if (world.field_72995_K) break block18;
                if (rpg.getMana() < SimpleRPG.ManaCosts[2]) {
                    return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
                }
                rpg.addMana(-SimpleRPG.ManaCosts[2]);
                RayTraceResult trace = this.func_77621_a(world, player, false);
                if (trace == null || trace.field_72313_a == RayTraceResult.Type.ENTITY) {
                    return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
                }
                List loaded = world.field_72996_f;
                for (Entity e : loaded) {
                    EntityLivingBase living;
                    if (e == null || !(e instanceof EntityLivingBase) || !(Math.sqrt((living = (EntityLivingBase)e).func_174831_c(trace.func_178782_a())) <= 3.0)) continue;
                    double atk = Math.floor(Math.min((double)((1.0f + SimpleRPG.AttackFlat * (float)(rpg.getLevel() - 1)) * (1.0f + SimpleRPG.AttackRate * (float)(rpg.getLevel() - 1))), SimpleRPG.MaxAttack));
                    float amt = (float)SimpleRPG.BaseDamages[1] * (float)(1.0 + atk * 0.1);
                    living.func_70097_a(DamageSource.field_76380_i, amt);
                    double durationModif = 1.0 + (double)rpg.getLevel() / (double)SimpleRPG.MaxLevel;
                    living.func_70690_d(new PotionEffect(Potion.func_188412_a((int)15), (int)((double)SimpleRPG.BlindTime * durationModif), 0));
                    living.func_70690_d(new PotionEffect(Potion.func_188412_a((int)2), (int)((double)SimpleRPG.SlowTime * durationModif), 1));
                }
                break block18;
            }
            if (mode == SimpleRPG.MagicMode.WIND && !world.field_72995_K) {
                if (rpg.getMana() < SimpleRPG.ManaCosts[3]) {
                    return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
                }
                rpg.addMana(-SimpleRPG.ManaCosts[3]);
                List loaded = world.field_72996_f;
                for (Entity e : loaded) {
                    EntityLivingBase living;
                    if (e == null || !(e instanceof EntityLivingBase) || e.equals((Object)player) || !((double)(living = (EntityLivingBase)e).func_70032_d((Entity)player) <= 8.0)) continue;
                    double atk = Math.floor(Math.min((double)((1.0f + SimpleRPG.AttackFlat * (float)(rpg.getLevel() - 1)) * (1.0f + SimpleRPG.AttackRate * (float)(rpg.getLevel() - 1))), SimpleRPG.MaxAttack));
                    float amt = (float)SimpleRPG.BaseDamages[2] * (float)(1.0 + atk * 0.1);
                    living.func_70097_a(DamageSource.field_76379_h, amt);
                    living.func_70024_g(0.0, SimpleRPG.WindStrength, 0.0);
                }
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
    }

    protected RayTraceResult func_77621_a(World worldIn, EntityPlayer playerIn, boolean useLiquids) {
        float f = playerIn.field_70125_A;
        float f1 = playerIn.field_70177_z;
        double d0 = playerIn.field_70165_t;
        double d1 = playerIn.field_70163_u + (double)playerIn.func_70047_e();
        double d2 = playerIn.field_70161_v;
        Vec3d vec3d = new Vec3d(d0, d1, d2);
        float f2 = MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-f * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d3 = 5.0;
        if (playerIn instanceof EntityPlayerMP) {
            d3 = ((EntityPlayerMP)playerIn).field_71134_c.getBlockReachDistance() * 16.0;
        }
        Vec3d vec3d1 = vec3d.func_72441_c((double)f6 * d3, (double)f5 * d3, (double)f7 * d3);
        return worldIn.func_147447_a(vec3d, vec3d1, useLiquids, !useLiquids, false);
    }
}

