/*
 * Decompiled with CFR 0.152.
 */
package pilot.simplerpg;

import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import pilot.simplerpg.SimpleRPG;
import pilot.simplerpg.capabilities.IRpgPlayer;
import pilot.simplerpg.capabilities.RpgPlayerProvider;
import pilot.simplerpg.item.ModItem;
import pilot.simplerpg.packet.PacketDispatcher;
import pilot.simplerpg.packet.client.SyncRpgData;

public class ModEventHandle {
    public static final ResourceLocation RPG_PLAYER_CAP = new ResourceLocation("simplerpg", "RpgPlayer");

    @SubscribeEvent
    public void attachPlayerCapabilities(AttachCapabilitiesEvent<Entity> e) {
        if (!(e.getObject() instanceof EntityPlayer)) {
            return;
        }
        e.addCapability(RPG_PLAYER_CAP, (ICapabilityProvider)new RpgPlayerProvider());
    }

    @SubscribeEvent
    public void onPlayerUpdate(LivingEvent.LivingUpdateEvent e) {
        if (!(e.getEntityLiving() instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayer p = (EntityPlayer)e.getEntityLiving();
        IRpgPlayer rpg = (IRpgPlayer)p.getCapability(RpgPlayerProvider.RPG_PLAYER_CAP, null);
        rpg.update(p);
        PacketDispatcher.sendTo(new SyncRpgData((IRpgPlayer)e.getEntity().getCapability(RpgPlayerProvider.RPG_PLAYER_CAP, null)), (EntityPlayerMP)e.getEntity());
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent e) {
        if (e.getEntity() instanceof EntityPlayerMP) {
            PacketDispatcher.sendTo(new SyncRpgData((IRpgPlayer)e.getEntity().getCapability(RpgPlayerProvider.RPG_PLAYER_CAP, null)), (EntityPlayerMP)e.getEntity());
        }
    }

    @SubscribeEvent
    public void onEntityDeath(LivingDeathEvent e) {
        if (SimpleRPG.DamageBasedXP) {
            return;
        }
        if (e.getSource().func_76346_g() != null && e.getSource().func_76346_g() instanceof EntityPlayerMP) {
            EntityPlayer p = (EntityPlayer)e.getSource().func_76346_g();
            EntityLivingBase entity = e.getEntityLiving();
            IRpgPlayer rpg = (IRpgPlayer)p.getCapability(RpgPlayerProvider.RPG_PLAYER_CAP, null);
            double val = (double)entity.func_110138_aP() * SimpleRPG.HealthVal;
            if (entity.func_110148_a(SharedMonsterAttributes.field_111264_e) != null) {
                val += entity.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e() * SimpleRPG.AttackVal;
            }
            val *= 1.0 + entity.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111126_e() * SimpleRPG.ArmorVal;
            World world = entity.field_70170_p;
            if (world.func_175659_aa() == EnumDifficulty.PEACEFUL) {
                val *= SimpleRPG.DifficultyMultipliers[0];
            } else if (world.func_175659_aa() == EnumDifficulty.EASY) {
                val *= SimpleRPG.DifficultyMultipliers[1];
            } else if (world.func_175659_aa() == EnumDifficulty.NORMAL) {
                val *= SimpleRPG.DifficultyMultipliers[2];
            } else if (world.func_175659_aa() == EnumDifficulty.HARD) {
                val = !world.func_72912_H().func_76093_s() ? (val *= SimpleRPG.DifficultyMultipliers[3]) : (val *= SimpleRPG.DifficultyMultipliers[4]);
            }
            rpg.addXP(val);
        }
    }

    @SubscribeEvent
    public void entityHurt(LivingHurtEvent e) {
        EntityPlayer player;
        IRpgPlayer rpg;
        EntityPlayer p;
        DamageSource source = e.getSource();
        float amt = e.getAmount();
        if (source.func_76346_g() instanceof EntityPlayerMP) {
            p = (EntityPlayer)source.func_76346_g();
            rpg = (IRpgPlayer)p.getCapability(RpgPlayerProvider.RPG_PLAYER_CAP, null);
            double atk = Math.floor(Math.min((double)((1.0f + SimpleRPG.AttackFlat * (float)(rpg.getLevel() - 1)) * (1.0f + SimpleRPG.AttackRate * (float)(rpg.getLevel() - 1))), SimpleRPG.MaxAttack));
            amt = amt > 1.0f ? (float)((double)amt * (1.0 + atk * 0.1)) : (float)((double)amt + atk * 0.1);
        }
        amt = (float)((double)amt * (new Random().nextDouble() * (double)SimpleRPG.AttackVar + (double)SimpleRPG.BaseAttack));
        if (SimpleRPG.DamageBasedXP && source.func_76346_g() instanceof EntityPlayerMP) {
            World world;
            p = (EntityPlayer)source.func_76346_g();
            EntityLivingBase entity = e.getEntityLiving();
            IRpgPlayer rpg2 = (IRpgPlayer)p.getCapability(RpgPlayerProvider.RPG_PLAYER_CAP, null);
            double val = (double)amt * SimpleRPG.DamageVal * (1.0 + SimpleRPG.HealthVal * (double)entity.func_110138_aP() * 0.1) * (1.0 + SimpleRPG.ArmorVal * (double)entity.func_70658_aO() * 0.2);
            if (entity.func_110148_a(SharedMonsterAttributes.field_111264_e) != null) {
                val *= 1.0 + entity.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e() * SimpleRPG.AttackVal * 0.4;
            }
            if ((world = entity.field_70170_p).func_175659_aa() == EnumDifficulty.PEACEFUL) {
                val *= SimpleRPG.DifficultyMultipliers[0];
            } else if (world.func_175659_aa() == EnumDifficulty.EASY) {
                val *= SimpleRPG.DifficultyMultipliers[1];
            } else if (world.func_175659_aa() == EnumDifficulty.NORMAL) {
                val *= SimpleRPG.DifficultyMultipliers[2];
            } else if (world.func_175659_aa() == EnumDifficulty.HARD) {
                val = !world.func_72912_H().func_76093_s() ? (val *= SimpleRPG.DifficultyMultipliers[3]) : (val *= SimpleRPG.DifficultyMultipliers[4]);
            }
            rpg2.addXP(val);
        }
        if (e.getEntityLiving() instanceof EntityPlayerMP && (rpg = (IRpgPlayer)(player = (EntityPlayer)e.getEntityLiving()).getCapability(RpgPlayerProvider.RPG_PLAYER_CAP, null)).getMode() == SimpleRPG.MagicMode.PASSIVE) {
            if (rpg.getMana() >= (double)amt * SimpleRPG.HealthConversion * 0.5) {
                rpg.addMana((double)(-amt) * SimpleRPG.HealthConversion * 0.5);
                amt = (float)((double)amt * 0.5);
            } else {
                amt = (float)((double)amt - rpg.getMana() * (1.0 / SimpleRPG.HealthConversion));
                rpg.setMana(0.0);
            }
        }
        e.setAmount(amt);
    }

    @SubscribeEvent
    public void playerCloned(PlayerEvent.Clone e) {
        EntityPlayer newplayer = e.getEntityPlayer();
        EntityPlayer old = e.getOriginal();
        if (e.isWasDeath() && !SimpleRPG.DeathMode.equals("LOOSE")) {
            IRpgPlayer newrpg = (IRpgPlayer)newplayer.getCapability(RpgPlayerProvider.RPG_PLAYER_CAP, null);
            IRpgPlayer oldrpg = (IRpgPlayer)old.getCapability(RpgPlayerProvider.RPG_PLAYER_CAP, null);
            try {
                double percentLoss = Double.valueOf(SimpleRPG.DeathMode);
                double newVal = Math.max(oldrpg.getXPReq(oldrpg.getLevel() - 1), oldrpg.getXP() - percentLoss * (oldrpg.getXP() - oldrpg.getXPReq(oldrpg.getLevel() - 1)));
                newrpg.setStats(oldrpg.getLevel(), newVal);
            }
            catch (NumberFormatException ex) {
                if (SimpleRPG.DeathMode.equals("KEEP") || SimpleRPG.DeathMode.equals("KEEPINVENTORY") && old.field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
                    newrpg.setStats(oldrpg.getLevel(), oldrpg.getXP());
                }
            }
        } else if (!e.isWasDeath()) {
            IRpgPlayer newrpg = (IRpgPlayer)newplayer.getCapability(RpgPlayerProvider.RPG_PLAYER_CAP, null);
            IRpgPlayer oldrpg = (IRpgPlayer)old.getCapability(RpgPlayerProvider.RPG_PLAYER_CAP, null);
            newrpg.setStats(oldrpg.getLevel(), oldrpg.getXP());
        }
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> e) {
        e.getRegistry().register((IForgeRegistryEntry)ModItem.magicstick);
    }
}

