/*
 * Decompiled with CFR 0.152.
 */
package pilot.simplerpg.command;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.math.BlockPos;
import pilot.simplerpg.SimpleRPG;
import pilot.simplerpg.capabilities.IRpgPlayer;
import pilot.simplerpg.capabilities.RpgPlayerProvider;

public class CommandSet
implements ICommand {
    private List<String> aliases = new ArrayList<String>();

    public CommandSet() {
        this.aliases.add("simplerpg");
        this.aliases.add("pilotsrpg");
    }

    public int compareTo(ICommand o) {
        return 0;
    }

    public String func_71517_b() {
        return "simplerpg";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/simplerpg_stats <setlevel/setxp/addxp> <value> [player]";
    }

    public List<String> func_71514_a() {
        return this.aliases;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length != 2 && args.length != 3) {
            throw new CommandException("Incorrect number of arguments, got " + args.length + ", expected 2 or 3.", new Object[0]);
        }
        if (args.length == 2) {
            EntityPlayer p = (EntityPlayer)sender.func_174793_f();
            IRpgPlayer rpg = (IRpgPlayer)p.getCapability(RpgPlayerProvider.RPG_PLAYER_CAP, null);
            if (args[0].equals("setlevel")) {
                int val = CommandBase.func_180528_a((String)args[1], (int)1);
                rpg.setStats(val, rpg.getXPReq(val - 1));
                p.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)(SimpleRPG.BaseHealth + SimpleRPG.HealthFlat * (float)(val - 1)) * (1.0 + (double)SimpleRPG.HealthRate * (double)(val - 1)));
                return;
            } else if (args[0].equals("setxp")) {
                double val = CommandBase.func_180526_a((String)args[1], (double)0.0);
                rpg.setStats(rpg.getLevel(), Math.max(val, rpg.getXPReq(rpg.getLevel() - 1)));
                return;
            } else {
                if (!args[0].equals("addxp")) throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
                double val = CommandBase.func_175765_c((String)args[1]);
                rpg.addXP(val);
                if (!(rpg.getXP() < rpg.getXPReq(rpg.getLevel() - 1))) return;
                rpg.setStats(rpg.getLevel(), rpg.getXPReq(rpg.getLevel() - 1));
            }
            return;
        } else {
            PlayerList players = server.func_184103_al();
            String[] names = players.func_72369_d();
            EntityPlayerMP p = null;
            for (int i = 0; i < names.length; ++i) {
                if (!args[2].equals(names[i])) continue;
                p = players.func_152612_a(args[2]);
                break;
            }
            if (p == null) {
                throw new CommandException("Could not find the player '" + args[2] + "'!", new Object[0]);
            }
            IRpgPlayer rpg = (IRpgPlayer)p.getCapability(RpgPlayerProvider.RPG_PLAYER_CAP, null);
            if (args[0].equals("setlevel")) {
                int val = CommandBase.func_180528_a((String)args[1], (int)1);
                rpg.setStats(val, rpg.getXPReq(val - 1));
                p.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)(SimpleRPG.BaseHealth + SimpleRPG.HealthFlat * (float)(val - 1)) * (1.0 + (double)SimpleRPG.HealthRate * (double)(val - 1)));
                return;
            } else if (args[0].equals("setxp")) {
                double val = CommandBase.func_180526_a((String)args[1], (double)0.0);
                rpg.setStats(rpg.getLevel(), Math.max(val, rpg.getXPReq(rpg.getLevel() - 1)));
                return;
            } else {
                if (!args[0].equals("addxp")) throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
                double val = CommandBase.func_175765_c((String)args[1]);
                rpg.addXP(val);
                if (!(rpg.getXP() < rpg.getXPReq(rpg.getLevel() - 1))) return;
                rpg.setStats(rpg.getLevel(), rpg.getXPReq(rpg.getLevel() - 1));
            }
        }
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return sender.func_70003_b(2, this.func_71517_b());
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        ArrayList<String> tabCompletions = new ArrayList<String>();
        if (args.length == 3) {
            PlayerList players = server.func_184103_al();
            String[] names = players.func_72369_d();
            for (int i = 0; i < names.length; ++i) {
                tabCompletions.add(names[i]);
            }
        } else if (args.length == 1) {
            tabCompletions.add("setlevel");
            tabCompletions.add("setxp");
            tabCompletions.add("addxp");
        }
        return tabCompletions;
    }

    public boolean func_82358_a(String[] args, int index) {
        return index == 2;
    }
}

