/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.CharacterStreamSetterArgs;
import com.microsoft.sqlserver.jdbc.DDC;
import com.microsoft.sqlserver.jdbc.DTV;
import com.microsoft.sqlserver.jdbc.DTVExecuteOp;
import com.microsoft.sqlserver.jdbc.DTVImpl;
import com.microsoft.sqlserver.jdbc.DataTypes;
import com.microsoft.sqlserver.jdbc.InputStreamGetterArgs;
import com.microsoft.sqlserver.jdbc.InputStreamSetterArgs;
import com.microsoft.sqlserver.jdbc.ParameterUtils;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.TDSReader;
import com.microsoft.sqlserver.jdbc.TypeInfo;
import com.microsoft.sqlserver.jdbc.Util;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Calendar;

final class AppDTVImpl
extends DTVImpl {
    private int jdbcType = 999;
    private Object value;
    private Object setterArgs;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$java$sql$Array;
    static /* synthetic */ Class class$java$sql$Ref;
    static /* synthetic */ Class class$java$net$URL;

    AppDTVImpl() {
    }

    final void skipValue(TypeInfo typeInfo, TDSReader tDSReader, boolean bl2) throws SQLServerException {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    void setValue(DTV dTV, TypeInfo typeInfo, int n2, Object object, Object object2, SQLServerConnection sQLServerConnection) throws SQLServerException {
        SetValueOp setValueOp = new SetValueOp(typeInfo, object2, sQLServerConnection);
        DTV.executeOp(dTV, setValueOp, object, n2);
        this.value = setValueOp.getValue();
        this.jdbcType = setValueOp.getJdbcType();
        this.setterArgs = setValueOp.getSetterArgs();
    }

    Object getSetterArgs() {
        return this.setterArgs;
    }

    boolean isNull() {
        return null == this.value;
    }

    int getJdbcType(TypeInfo typeInfo) throws SQLServerException {
        return this.jdbcType;
    }

    Object getValue(DTV dTV, int n2, boolean bl2, int n3, InputStreamGetterArgs inputStreamGetterArgs, Calendar calendar, TypeInfo typeInfo, TDSReader tDSReader) throws SQLServerException {
        if (this.jdbcType != n2) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_unsupportedConversionFromTo"));
            Object[] objectArray = new Object[]{Util.javaSqlTypeToString(this.jdbcType), Util.javaSqlTypeToString(n2)};
            throw new SQLServerException(null, messageFormat.format(objectArray), null, 0, false);
        }
        return this.value;
    }

    int getInt() {
        return (Integer)this.value;
    }

    short getShort() {
        return (Short)this.value;
    }

    byte getByte(DTV dTV, TypeInfo typeInfo, TDSReader tDSReader) throws SQLServerException {
        if (!(this.value instanceof Byte)) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_unsupportedConversionFromTo"));
            Object[] objectArray = new Object[]{Util.javaSqlTypeToString(this.jdbcType), "Byte"};
            throw new SQLServerException(null, messageFormat.format(objectArray), null, 0, false);
        }
        return (Byte)this.value;
    }

    static {
        $assertionsDisabled = !AppDTVImpl.class.desiredAssertionStatus();
    }

    final class SetValueOp
    extends DTVExecuteOp {
        private int jdbcType;
        private final TypeInfo typeInfo;
        private Object value;
        private Object setterArgs;
        private final SQLServerConnection con;

        int getJdbcType() {
            return this.jdbcType;
        }

        Object getValue() {
            return this.value;
        }

        Object getSetterArgs() {
            return this.setterArgs;
        }

        SetValueOp(TypeInfo typeInfo, Object object, SQLServerConnection sQLServerConnection) {
            this.typeInfo = typeInfo;
            this.setterArgs = object;
            this.con = sQLServerConnection;
        }

        void execute(String string, int n2) throws SQLServerException {
            if (3 == n2 || 2 == n2) {
                try {
                    this.execute(new BigDecimal(string), n2);
                }
                catch (NumberFormatException numberFormatException) {
                    MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_unsupportedConversionFromTo"));
                    Object[] objectArray = new Object[]{"String", Util.javaSqlTypeToString(n2)};
                    SQLServerException.makeFromDriverError(null, null, messageFormat.format(objectArray), null, true);
                }
            } else if (DataTypes.isBinaryJDBCType(n2) || null != this.typeInfo && DataTypes.isBinary(this.typeInfo.getNativeType()) && 36 != this.typeInfo.getNativeType()) {
                this.execute(null == string ? null : ParameterUtils.HexToBin(string), -2);
            } else if (!this.con.sendStringParametersAsUnicode() && null != string) {
                byte[] byArray = null;
                try {
                    byArray = string.getBytes(this.con.getDatabaseCollation().getCharset());
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_encodingErrorWritingTDS"));
                    Object[] objectArray = new Object[]{new String(unsupportedEncodingException.getMessage())};
                    SQLServerException.makeFromDriverError(this.con, null, messageFormat.format(objectArray), null, true);
                }
                this.execute(byArray, n2);
            } else {
                this.value = string;
                this.jdbcType = n2;
            }
        }

        void execute(Clob clob, int n2) throws SQLServerException {
            this.value = clob;
            this.jdbcType = n2;
        }

        void execute(Byte by, int n2) throws SQLServerException {
            this.value = by;
            this.jdbcType = n2;
        }

        void execute(Integer n2, int n3) throws SQLServerException {
            this.value = n2;
            this.jdbcType = n3;
        }

        void execute(Time time, DTV dTV, int n2) throws SQLServerException {
            this.value = time;
            this.jdbcType = n2;
        }

        void execute(Date date, DTV dTV, int n2) throws SQLServerException {
            this.value = date;
            this.jdbcType = n2;
        }

        void execute(Timestamp timestamp, DTV dTV, int n2) throws SQLServerException {
            this.value = timestamp;
            this.jdbcType = n2;
        }

        void execute(Float f2, int n2) throws SQLServerException {
            this.value = f2;
            this.jdbcType = n2;
        }

        void execute(Double d2, int n2) throws SQLServerException {
            this.value = d2;
            this.jdbcType = n2;
        }

        void execute(BigDecimal bigDecimal, int n2) throws SQLServerException {
            Integer n3;
            if (null != bigDecimal && null != (n3 = (Integer)this.setterArgs) && n3.intValue() != bigDecimal.scale()) {
                bigDecimal = bigDecimal.setScale((int)n3, 1);
            }
            this.value = bigDecimal;
            this.jdbcType = n2;
        }

        void execute(Long l2, int n2) throws SQLServerException {
            this.value = l2;
            this.jdbcType = n2;
        }

        void execute(Short s2, int n2) throws SQLServerException {
            this.value = s2;
            this.jdbcType = n2;
        }

        void execute(Boolean bl2, int n2) throws SQLServerException {
            this.value = bl2;
            this.jdbcType = n2;
        }

        void execute(byte[] byArray, int n2) throws SQLServerException {
            this.value = byArray;
            this.jdbcType = n2;
        }

        void execute(Blob blob, int n2) throws SQLServerException {
            this.value = blob;
            this.jdbcType = n2;
        }

        void execute(InputStream inputStream, DTV dTV, int n2) throws SQLServerException {
            InputStreamSetterArgs inputStreamSetterArgs = (InputStreamSetterArgs)this.setterArgs;
            if (null != inputStream && -1L == inputStreamSetterArgs.length && !this.con.isYukonOrLater()) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8000);
                byte[] byArray = new byte[8000];
                int n3 = 0;
                while (true) {
                    try {
                        int n4;
                        while ((n4 = inputStream.read(byArray, 0, byArray.length)) > 0) {
                            byteArrayOutputStream.write(byArray);
                            n3 += n4;
                        }
                    }
                    catch (IOException iOException) {
                        SQLServerException.makeFromDriverError(null, null, iOException.getMessage(), null, true);
                        continue;
                    }
                    break;
                }
                byArray = new byte[n3];
                System.arraycopy(byteArrayOutputStream.toByteArray(), 0, byArray, 0, n3);
                this.execute(byArray, n2);
                return;
            }
            this.value = inputStream;
            this.jdbcType = n2;
        }

        void execute(Reader reader, DTV dTV, int n2) throws SQLServerException {
            CharacterStreamSetterArgs characterStreamSetterArgs = (CharacterStreamSetterArgs)this.setterArgs;
            if (null != reader && -1 == characterStreamSetterArgs.length && !this.con.isYukonOrLater() || DataTypes.isBinaryJDBCType(n2) || null != this.typeInfo && DataTypes.isBinary(this.typeInfo.getNativeType()) && 36 != this.typeInfo.getNativeType() || !this.con.sendStringParametersAsUnicode() && null != reader) {
                String string = DDC.convertReaderToString(reader, characterStreamSetterArgs.length);
                if (-1 != characterStreamSetterArgs.length && string.length() != characterStreamSetterArgs.length) {
                    MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_mismatchedStreamLength"));
                    Object[] objectArray = new Object[]{new Integer(characterStreamSetterArgs.length), new Integer(string.length())};
                    SQLServerException.makeFromDriverError(null, null, messageFormat.format(objectArray), null, true);
                }
                this.execute(string, n2);
            } else {
                this.value = reader;
                this.jdbcType = n2;
            }
        }

        void executeDefault(Object object, int n2) throws SQLServerException {
            if ((class$java$sql$Array == null ? (class$java$sql$Array = AppDTVImpl.class$("java.sql.Array")) : class$java$sql$Array).isInstance(object) || (class$java$sql$Ref == null ? (class$java$sql$Ref = AppDTVImpl.class$("java.sql.Ref")) : class$java$sql$Ref).isInstance(object) || (class$java$net$URL == null ? (class$java$net$URL = AppDTVImpl.class$("java.net.URL")) : class$java$net$URL).isInstance(object)) {
                SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_notSupported"), null, false);
            } else {
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_unknownType"));
                Object[] objectArray = new Object[]{new String(object.getClass().getName())};
                SQLServerException.makeFromDriverError(null, null, messageFormat.format(objectArray), null, false);
            }
        }
    }
}

