/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.BaseInputStream;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;

final class AsciiFilteredInputStream
extends InputStream {
    private final InputStream containedStream;
    private static final byte[] ASCII_FILTER;
    static final /* synthetic */ boolean $assertionsDisabled;

    AsciiFilteredInputStream(BaseInputStream baseInputStream) throws SQLServerException {
        if (baseInputStream.logger.isLoggable(Level.FINE)) {
            baseInputStream.logger.fine(baseInputStream.toLogString() + " wrapping in AsciiFilteredInputStream");
        }
        this.containedStream = baseInputStream;
    }

    public void close() throws IOException {
        this.containedStream.close();
    }

    public long skip(long l2) throws IOException {
        return this.containedStream.skip(l2);
    }

    public int available() throws IOException {
        return this.containedStream.available();
    }

    public int read() throws IOException {
        int n2 = this.containedStream.read();
        if (n2 >= 0 && n2 <= 255) {
            return ASCII_FILTER[n2];
        }
        return n2;
    }

    public int read(byte[] byArray) throws IOException {
        int n2 = this.containedStream.read(byArray);
        if (n2 > 0) {
            if (!$assertionsDisabled && n2 > byArray.length) {
                throw new AssertionError();
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                byArray[i2] = ASCII_FILTER[byArray[i2] & 0xFF];
            }
        }
        return n2;
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = this.containedStream.read(byArray, n2, n3);
        if (n4 > 0) {
            if (!$assertionsDisabled && n2 + n4 > byArray.length) {
                throw new AssertionError();
            }
            for (int i2 = 0; i2 < n4; ++i2) {
                byArray[n2 + i2] = ASCII_FILTER[byArray[n2 + i2] & 0xFF];
            }
        }
        return n4;
    }

    public boolean markSupported() {
        return this.containedStream.markSupported();
    }

    public void mark(int n2) {
        this.containedStream.mark(n2);
    }

    public void reset() throws IOException {
        this.containedStream.reset();
    }

    static {
        int n2;
        $assertionsDisabled = !AsciiFilteredInputStream.class.desiredAssertionStatus();
        ASCII_FILTER = new byte[256];
        for (n2 = 0; n2 < 128; ++n2) {
            AsciiFilteredInputStream.ASCII_FILTER[n2] = (byte)n2;
        }
        for (n2 = 128; n2 < 256; ++n2) {
            AsciiFilteredInputStream.ASCII_FILTER[n2] = 63;
        }
    }
}

