/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.ColumnFilter;
import com.microsoft.sqlserver.jdbc.DTV;
import com.microsoft.sqlserver.jdbc.DataTypes;
import com.microsoft.sqlserver.jdbc.InputStreamGetterArgs;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.TDSReader;
import com.microsoft.sqlserver.jdbc.TDSWriter;
import com.microsoft.sqlserver.jdbc.TypeInfo;
import com.microsoft.sqlserver.jdbc.Util;
import java.text.MessageFormat;
import java.util.Calendar;

final class Column {
    private TypeInfo typeInfo;
    private DTV updaterDTV;
    private final DTV getterDTV = new DTV();
    String name;
    String tableName;
    ColumnFilter filter;
    private int jdbcUpdateType;

    final TypeInfo getTypeInfo() {
        return this.typeInfo;
    }

    Column(TypeInfo typeInfo, String string, String string2) {
        this.typeInfo = typeInfo;
        this.name = string;
        this.tableName = string2;
    }

    Column(String string) {
        this.name = string;
    }

    final void clear() {
        this.getterDTV.clear();
    }

    final void skipValue(TDSReader tDSReader, boolean bl2) throws SQLServerException {
        this.getterDTV.skipValue(this.typeInfo, tDSReader, bl2);
    }

    void setFilter(ColumnFilter columnFilter) {
        this.filter = columnFilter;
    }

    final boolean isNull() {
        return this.getterDTV.isNull();
    }

    Object getValue(int n2, TDSReader tDSReader) throws SQLServerException {
        return this.getValue(n2, InputStreamGetterArgs.getDefaultArgs(), null, tDSReader);
    }

    Object getValue(int n2, Calendar calendar, TDSReader tDSReader) throws SQLServerException {
        return this.getValue(n2, InputStreamGetterArgs.getDefaultArgs(), calendar, tDSReader);
    }

    Object getValue(int n2, InputStreamGetterArgs inputStreamGetterArgs, Calendar calendar, TDSReader tDSReader) throws SQLServerException {
        Object object = this.getterDTV.getValue(n2, this.typeInfo.getScale(), inputStreamGetterArgs, calendar, this.typeInfo, tDSReader);
        return null != this.filter ? this.filter.apply(object, n2) : object;
    }

    byte getByte(TDSReader tDSReader) throws SQLServerException {
        byte by = this.getterDTV.getByte(this.typeInfo, tDSReader);
        return null != this.filter ? this.filter.apply(by) : by;
    }

    int getInt(TDSReader tDSReader) throws SQLServerException {
        int n2 = this.getterDTV.getInt(this.typeInfo, tDSReader);
        return null != this.filter ? this.filter.apply(n2) : n2;
    }

    short getShort(TDSReader tDSReader) throws SQLServerException {
        short s2 = this.getterDTV.getShort(this.typeInfo, tDSReader);
        return null != this.filter ? this.filter.apply(s2) : s2;
    }

    void updateValue(int n2, Object object, SQLServerConnection sQLServerConnection) throws SQLServerException {
        this.updateValue(n2, object, null, sQLServerConnection);
    }

    void updateValue(int n2, Object object, Object object2, SQLServerConnection sQLServerConnection) throws SQLServerException {
        int n3 = this.typeInfo.getNativeType();
        if (!DataTypes.canConvertToNativeTypeFromJDBCType(n3, this.typeInfo.getMaxLength(), n2)) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_unsupportedConversionFromTo"));
            Object[] objectArray = new Object[]{Util.javaSqlTypeToString(n2), DataTypes.sqlNativeTypeToString(n3)};
            SQLServerException.makeFromDriverError(null, null, messageFormat.format(objectArray), null, true);
        }
        if (null == this.updaterDTV) {
            this.updaterDTV = new DTV();
        }
        this.updaterDTV.setValue(this.typeInfo, n2, object, object2, sQLServerConnection);
        this.jdbcUpdateType = this.updaterDTV.getJdbcType(null);
    }

    boolean hasUpdates() {
        return null != this.updaterDTV;
    }

    void cancelUpdates() {
        this.updaterDTV = null;
    }

    void sendByRPC(TDSWriter tDSWriter, SQLServerConnection sQLServerConnection, int n2) throws SQLServerException {
        if (null == this.updaterDTV) {
            return;
        }
        this.updaterDTV.sendByRPC(this.name, this.jdbcUpdateType, this.typeInfo.getNativeType(), this.typeInfo.getScale(), false, tDSWriter, sQLServerConnection, n2);
    }

    final void checkGetAsciiStream() throws SQLServerException {
        this.checkConvertsAsciiStream(true);
    }

    final void checkUpdateAsciiStream() throws SQLServerException {
        this.checkConvertsAsciiStream(false);
    }

    private void checkConvertsAsciiStream(boolean bl2) throws SQLServerException {
        boolean bl3 = DataTypes.canConvertFromNativeTypeToAsciiStream(this.typeInfo);
        if (bl3 && DataTypes.isNonUnicode(this.typeInfo.getNativeType())) {
            bl3 = this.typeInfo.getSQLCollation().supportsAsciiConversion();
        }
        if (!bl3) {
            this.throwConversionError(this.typeInfo.getNativeType(), "AsciiStream", bl2);
        }
    }

    final void checkGetBinaryStream() throws SQLServerException {
        this.checkConvertsBinaryStream(true);
    }

    final void checkUpdateBinaryStream() throws SQLServerException {
        this.checkConvertsBinaryStream(false);
    }

    private void checkConvertsBinaryStream(boolean bl2) throws SQLServerException {
        if (!DataTypes.canConvertFromNativeTypeToBinaryStream(this.typeInfo)) {
            this.throwConversionError(this.typeInfo.getNativeType(), "BinaryStream", bl2);
        }
    }

    final void checkGetCharacterStream() throws SQLServerException {
        this.checkConvertsCharacterStream(true);
    }

    final void checkUpdateCharacterStream() throws SQLServerException {
        this.checkConvertsCharacterStream(false);
    }

    private void checkConvertsCharacterStream(boolean bl2) throws SQLServerException {
        if (!DataTypes.canConvertFromNativeTypeToCharStream(this.typeInfo)) {
            this.throwConversionError(this.typeInfo.getNativeType(), "CharacterStream", bl2);
        }
    }

    private void throwConversionError(int n2, String string, boolean bl2) throws SQLServerException {
        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_unsupportedConversionFromTo"));
        Object[] objectArray = new Object[2];
        objectArray[bl2 ? 0 : 1] = DataTypes.sqlNativeTypeToString(n2);
        objectArray[bl2 ? 1 : 0] = string;
        SQLServerException.makeFromDriverError(null, null, messageFormat.format(objectArray), null, true);
    }
}

