/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.AppDTVImpl;
import com.microsoft.sqlserver.jdbc.CharacterStreamSetterArgs;
import com.microsoft.sqlserver.jdbc.DDC;
import com.microsoft.sqlserver.jdbc.DTVExecuteOp;
import com.microsoft.sqlserver.jdbc.DTVImpl;
import com.microsoft.sqlserver.jdbc.DataTypes;
import com.microsoft.sqlserver.jdbc.InputStreamGetterArgs;
import com.microsoft.sqlserver.jdbc.InputStreamSetterArgs;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.ServerDTVImpl;
import com.microsoft.sqlserver.jdbc.TDSReader;
import com.microsoft.sqlserver.jdbc.TDSWriter;
import com.microsoft.sqlserver.jdbc.TypeInfo;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Locale;

final class DTV {
    private DTVImpl impl;
    static final /* synthetic */ boolean $assertionsDisabled;

    DTV() {
    }

    void setValue(TypeInfo typeInfo, int n2, Object object, Object object2, SQLServerConnection sQLServerConnection) throws SQLServerException {
        if (null == this.impl) {
            this.impl = new AppDTVImpl();
        }
        this.impl.setValue(this, typeInfo, n2, object, object2, sQLServerConnection);
    }

    final void clear() {
        this.impl = null;
    }

    final void skipValue(TypeInfo typeInfo, TDSReader tDSReader, boolean bl2) throws SQLServerException {
        if (null == this.impl) {
            this.impl = new ServerDTVImpl();
        }
        this.impl.skipValue(typeInfo, tDSReader, bl2);
    }

    Object getSetterArgs() {
        return this.impl.getSetterArgs();
    }

    boolean isNull() {
        return null == this.impl || this.impl.isNull();
    }

    final int getJdbcType(TypeInfo typeInfo) throws SQLServerException {
        if (!$assertionsDisabled && null == this.impl) {
            throw new AssertionError();
        }
        return this.impl.getJdbcType(typeInfo);
    }

    Object getValue(int n2, int n3, InputStreamGetterArgs inputStreamGetterArgs, Calendar calendar, TypeInfo typeInfo, TDSReader tDSReader) throws SQLServerException {
        if (null == this.impl) {
            this.impl = new ServerDTVImpl();
        }
        return this.impl.getValue(this, n2, true, n3, inputStreamGetterArgs, calendar, typeInfo, tDSReader);
    }

    byte getByte(TypeInfo typeInfo, TDSReader tDSReader) throws SQLServerException {
        if (null == this.impl) {
            this.impl = new ServerDTVImpl();
        }
        return this.impl.getByte(this, typeInfo, tDSReader);
    }

    int getInt(TypeInfo typeInfo, TDSReader tDSReader) throws SQLServerException {
        Object object;
        if (null == this.impl) {
            this.impl = new ServerDTVImpl();
        }
        return null != (object = this.impl.getValue(this, 4, false, 0, InputStreamGetterArgs.getDefaultArgs(), null, typeInfo, tDSReader)) ? ((Integer)object).intValue() : this.impl.getInt();
    }

    short getShort(TypeInfo typeInfo, TDSReader tDSReader) throws SQLServerException {
        Object object;
        if (null == this.impl) {
            this.impl = new ServerDTVImpl();
        }
        return null != (object = this.impl.getValue(this, 5, false, 0, InputStreamGetterArgs.getDefaultArgs(), null, typeInfo, tDSReader)) ? ((Short)object).shortValue() : this.impl.getShort();
    }

    void setImpl(DTVImpl dTVImpl) {
        this.impl = dTVImpl;
    }

    static void executeOp(DTV dTV, DTVExecuteOp dTVExecuteOp, Object object, int n2) throws SQLServerException {
        if (String.class.isInstance(object) || null == object && (1 == n2 || 12 == n2 || -1 == n2)) {
            dTVExecuteOp.execute((String)object, n2);
        } else if (Clob.class.isInstance(object) || null == object && 2005 == n2) {
            dTVExecuteOp.execute((Clob)object, n2);
        } else if (Integer.class.isInstance(object) || null == object && 4 == n2) {
            dTVExecuteOp.execute((Integer)object, n2);
        } else if (Date.class.isInstance(object) || null == object && 91 == n2) {
            dTVExecuteOp.execute((Date)object, dTV, n2);
        } else if (Timestamp.class.isInstance(object) || null == object && 93 == n2) {
            dTVExecuteOp.execute((Timestamp)object, dTV, n2);
        } else if (Float.class.isInstance(object) || null == object && (6 == n2 || 7 == n2)) {
            dTVExecuteOp.execute((Float)object, n2);
        } else if (BigDecimal.class.isInstance(object) || null == object && (2 == n2 || 3 == n2)) {
            dTVExecuteOp.execute((BigDecimal)object, n2);
        } else if ([B.class.isInstance(object) || null == object && (-2 == n2 || -3 == n2 || -4 == n2)) {
            dTVExecuteOp.execute((byte[])object, n2);
        } else if (Byte.class.isInstance(object) || null == object && -6 == n2) {
            dTVExecuteOp.execute((Byte)object, n2);
        } else if (Long.class.isInstance(object) || null == object && -5 == n2) {
            dTVExecuteOp.execute((Long)object, n2);
        } else if (Double.class.isInstance(object) || null == object && 8 == n2) {
            dTVExecuteOp.execute((Double)object, n2);
        } else if (Short.class.isInstance(object) || null == object && 5 == n2) {
            dTVExecuteOp.execute((Short)object, n2);
        } else if (Time.class.isInstance(object) || null == object && 92 == n2) {
            dTVExecuteOp.execute((Time)object, dTV, n2);
        } else if (Boolean.class.isInstance(object) || null == object && (-7 == n2 || 16 == n2)) {
            dTVExecuteOp.execute((Boolean)object, n2);
        } else if (Blob.class.isInstance(object) || null == object && 2004 == n2) {
            dTVExecuteOp.execute((Blob)object, n2);
        } else if (InputStream.class.isInstance(object)) {
            dTVExecuteOp.execute((InputStream)object, dTV, n2);
        } else if (Reader.class.isInstance(object) || null == object && -1 == n2) {
            dTVExecuteOp.execute((Reader)object, dTV, n2);
        } else {
            dTVExecuteOp.executeDefault(object, n2);
        }
    }

    void sendByRPC(String string, int n2, int n3, int n4, boolean bl2, TDSWriter tDSWriter, SQLServerConnection sQLServerConnection, int n5) throws SQLServerException {
        SendByRPCOp sendByRPCOp = new SendByRPCOp(string, n3, n4, bl2, tDSWriter, sQLServerConnection, n5);
        DTV.executeOp(this, sendByRPCOp, this.getValue(n2, n4, InputStreamGetterArgs.getDefaultArgs(), null, null, null), n2);
    }

    static {
        $assertionsDisabled = !DTV.class.desiredAssertionStatus();
    }

    final class SendByRPCOp
    extends DTVExecuteOp {
        private final String name;
        private final int nativeType;
        private final int outScale;
        private final boolean isOutParam;
        private final TDSWriter tdsWriter;
        private final SQLServerConnection conn;
        private final int index;

        SendByRPCOp(String string, int n2, int n3, boolean bl2, TDSWriter tDSWriter, SQLServerConnection sQLServerConnection, int n4) {
            this.name = string;
            this.nativeType = n2;
            this.outScale = n3;
            this.isOutParam = bl2;
            this.tdsWriter = tDSWriter;
            this.index = n4;
            this.conn = sQLServerConnection;
        }

        void execute(String string, int n2) throws SQLServerException {
            this.tdsWriter.writeRPCString(this.name, string, this.isOutParam, n2);
        }

        void execute(Clob clob, int n2) throws SQLServerException {
            long l2 = 0L;
            Reader reader = null;
            if (null != clob) {
                try {
                    l2 = clob.length();
                    reader = clob.getCharacterStream();
                }
                catch (SQLException sQLException) {
                    SQLServerException.makeFromDriverError(this.conn, null, sQLException.toString(), null, false);
                }
            }
            this.tdsWriter.writeRPCReader(this.name, reader, l2, this.isOutParam, n2);
        }

        void execute(Byte by, int n2) throws SQLServerException {
            if (null != by && (10 == this.nativeType || -6 == n2)) {
                Short s2 = new Short((short)(by.intValue() & 0xFF));
                this.tdsWriter.writeRPCShort(this.name, s2, this.isOutParam);
                return;
            }
            this.tdsWriter.writeRPCByte(this.name, by, this.isOutParam);
        }

        void execute(Integer n2, int n3) throws SQLServerException {
            this.tdsWriter.writeRPCInt(this.name, n2, this.isOutParam);
        }

        void execute(Time time, DTV dTV, int n2) throws SQLServerException {
            if (this.nativeType != 0 && !DataTypes.isTemporal(this.nativeType)) {
                this.execute(null == time ? null : time.toString(), 1);
            } else if (93 == n2 || 92 == n2 || 91 == n2) {
                Calendar calendar = null;
                if (null != time) {
                    try {
                        calendar = (Calendar)dTV.getSetterArgs();
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                    if (null == calendar) {
                        calendar = Calendar.getInstance(Locale.US);
                    }
                    if (91 == n2) {
                        calendar.clear();
                    } else {
                        calendar.setTimeInMillis(time.getTime());
                        calendar.set(1970, 0, 1);
                    }
                }
                this.tdsWriter.writeRPCTimestamp(this.name, calendar, this.isOutParam);
            } else {
                this.execute(time.toString(), n2);
            }
        }

        void execute(Date date, DTV dTV, int n2) throws SQLServerException {
            if (this.nativeType != 0 && !DataTypes.isTemporal(this.nativeType)) {
                this.execute(null == date ? null : date.toString(), 1);
            } else if (93 == n2 || 92 == n2 || 91 == n2) {
                Calendar calendar = null;
                if (null != date) {
                    try {
                        calendar = (Calendar)dTV.getSetterArgs();
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                    if (null == calendar) {
                        calendar = Calendar.getInstance(Locale.US);
                    }
                    if (92 == n2) {
                        calendar.clear();
                    } else {
                        calendar.setTimeInMillis(date.getTime());
                        calendar.set(11, 0);
                        calendar.set(12, 0);
                        calendar.set(13, 0);
                        calendar.set(14, 0);
                    }
                }
                this.tdsWriter.writeRPCTimestamp(this.name, calendar, this.isOutParam);
            } else {
                this.execute(date.toString(), n2);
            }
        }

        void execute(Timestamp timestamp, DTV dTV, int n2) throws SQLServerException {
            if (this.nativeType != 0 && !DataTypes.isTemporal(this.nativeType)) {
                this.execute(null == timestamp ? null : timestamp.toString(), 1);
            } else if (93 == n2 || 92 == n2 || 91 == n2) {
                Calendar calendar = null;
                if (null != timestamp) {
                    try {
                        calendar = (Calendar)dTV.getSetterArgs();
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                    if (null == calendar) {
                        calendar = Calendar.getInstance(Locale.US);
                    }
                    calendar.setTimeInMillis(timestamp.getTime());
                    calendar.set(14, timestamp.getNanos() / 1000000);
                    switch (n2) {
                        case 93: {
                            break;
                        }
                        case 91: {
                            calendar.set(11, 0);
                            calendar.set(12, 0);
                            calendar.set(13, 0);
                            calendar.set(14, 0);
                            break;
                        }
                        case 92: {
                            calendar.set(1970, 0, 1);
                        }
                    }
                }
                this.tdsWriter.writeRPCTimestamp(this.name, calendar, this.isOutParam);
            } else {
                this.execute(timestamp.toString(), n2);
            }
        }

        void execute(Float f2, int n2) throws SQLServerException {
            if (7 == n2) {
                this.tdsWriter.writeRPCReal(this.name, f2, this.isOutParam);
            } else {
                Double d2 = null == f2 ? null : new Double(f2.floatValue());
                this.tdsWriter.writeRPCDouble(this.name, d2, this.isOutParam);
            }
        }

        void execute(Double d2, int n2) throws SQLServerException {
            this.tdsWriter.writeRPCDouble(this.name, d2, this.isOutParam);
        }

        void execute(BigDecimal bigDecimal, int n2) throws SQLServerException {
            if (DDC.exceedsMaxRPCDecimalPrecisionOrScale(bigDecimal)) {
                String string = bigDecimal.toString();
                this.tdsWriter.writeRPCString(this.name, string, this.isOutParam, n2);
            } else {
                this.tdsWriter.writeRPCBigDecimal(this.name, bigDecimal, this.outScale, this.isOutParam);
            }
        }

        void execute(Long l2, int n2) throws SQLServerException {
            this.tdsWriter.writeRPCLong(this.name, l2, this.isOutParam);
        }

        void execute(Short s2, int n2) throws SQLServerException {
            this.tdsWriter.writeRPCShort(this.name, s2, this.isOutParam);
        }

        void execute(Boolean bl2, int n2) throws SQLServerException {
            this.tdsWriter.writeRPCBit(this.name, bl2, this.isOutParam);
        }

        void execute(byte[] byArray, int n2) throws SQLServerException {
            this.tdsWriter.writeRPCByteArray(this.name, byArray, this.isOutParam, n2);
        }

        void execute(Blob blob, int n2) throws SQLServerException {
            long l2 = 0L;
            InputStream inputStream = null;
            if (null != blob) {
                try {
                    l2 = blob.length();
                    inputStream = blob.getBinaryStream();
                }
                catch (SQLException sQLException) {
                    SQLServerException.makeFromDriverError(this.conn, null, sQLException.toString(), null, false);
                }
            }
            this.tdsWriter.writeRPCInputStream(this.name, inputStream, new InputStreamSetterArgs(1, l2), this.isOutParam);
        }

        void execute(InputStream inputStream, DTV dTV, int n2) throws SQLServerException {
            this.tdsWriter.writeRPCInputStream(this.name, inputStream, (InputStreamSetterArgs)dTV.getSetterArgs(), this.isOutParam);
        }

        void execute(Reader reader, DTV dTV, int n2) throws SQLServerException {
            this.tdsWriter.writeRPCReader(this.name, reader, null == reader ? 0L : (long)((CharacterStreamSetterArgs)dTV.getSetterArgs()).length, this.isOutParam, n2);
        }

        void executeDefault(Object object, int n2) throws SQLServerException {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_noRPCMappingForTypeColumn"));
            Object[] objectArray = new Object[]{new Integer(n2), new Integer(this.index + 1)};
            SQLServerException.makeFromDriverError(this.conn, null, messageFormat.format(objectArray), null, true);
        }
    }
}

