/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerDriver;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerPooledConnection;
import com.microsoft.sqlserver.jdbc.Util;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;

public class SQLServerDataSource
implements DataSource,
Referenceable,
Serializable {
    static Logger dsLogger = Logger.getLogger("com.microsoft.sqlserver.jdbc.SQLServerDataSource");
    private Properties connectionProps = new Properties();
    private String dataSourceURL;
    private String dataSourceDescription;
    private static int baseDataSourceID = 0;
    private final int dataSourceID = SQLServerDataSource.nextDataSourceID();
    private PrintWriter logWriter;

    String toLogString() {
        String string = " DataSourceID:" + this.dataSourceID;
        return string;
    }

    final int getRawLoggingID() {
        return this.dataSourceID;
    }

    public Connection getConnection() throws SQLException {
        if (dsLogger.isLoggable(Level.FINE)) {
            dsLogger.fine(this.toLogString() + " user:(default)");
        }
        return this.getConnectionInternal(null, null, null);
    }

    public Connection getConnection(String string, String string2) throws SQLException {
        if (dsLogger.isLoggable(Level.FINE)) {
            dsLogger.fine(this.toLogString() + " user:" + string);
        }
        return this.getConnectionInternal(string, string2, null);
    }

    public void setLoginTimeout(int n2) {
        this.setIntProperty(this.connectionProps, "loginTimeout", n2);
    }

    public int getLoginTimeout() {
        return this.getIntProperty(this.connectionProps, "loginTimeout", 0);
    }

    public void setLogWriter(PrintWriter printWriter) {
        this.logWriter = printWriter;
    }

    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    public void setApplicationName(String string) {
        this.setStringProperty(this.connectionProps, "applicationName", string);
    }

    public String getApplicationName() {
        return this.getStringProperty(this.connectionProps, "applicationName", "Microsoft SQL Server 2005 JDBC Driver");
    }

    public void setDatabaseName(String string) {
        this.setStringProperty(this.connectionProps, "databaseName", string);
    }

    public String getDatabaseName() {
        return this.getStringProperty(this.connectionProps, "databaseName", null);
    }

    public void setInstanceName(String string) {
        this.setStringProperty(this.connectionProps, "instanceName", string);
    }

    public String getInstanceName() {
        return this.getStringProperty(this.connectionProps, "instanceName", null);
    }

    public void setIntegratedSecurity(boolean bl2) {
        this.setBooleanProperty(this.connectionProps, "integratedSecurity", bl2);
    }

    public void setLastUpdateCount(boolean bl2) {
        this.setBooleanProperty(this.connectionProps, "lastUpdateCount", bl2);
    }

    public boolean getLastUpdateCount() {
        return this.getBooleanProperty(this.connectionProps, "lastUpdateCount", true);
    }

    public void setLockTimeout(int n2) {
        this.setIntProperty(this.connectionProps, "lockTimeout", n2);
    }

    public int getLockTimeout() {
        return this.getIntProperty(this.connectionProps, "lockTimeout", -1);
    }

    public void setPassword(String string) {
        this.setStringProperty(this.connectionProps, "password", string);
    }

    String getPassword() {
        return this.getStringProperty(this.connectionProps, "password", null);
    }

    public void setPortNumber(int n2) {
        this.setIntProperty(this.connectionProps, "portNumber", n2);
    }

    public int getPortNumber() {
        return this.getIntProperty(this.connectionProps, "portNumber", 1433);
    }

    public void setSelectMethod(String string) {
        this.setStringProperty(this.connectionProps, "selectMethod", string);
    }

    public String getSelectMethod() {
        return this.getStringProperty(this.connectionProps, "selectMethod", "direct");
    }

    public void setResponseBuffering(String string) {
        this.setStringProperty(this.connectionProps, "responseBuffering", string);
    }

    public String getResponseBuffering() {
        return this.getStringProperty(this.connectionProps, "responseBuffering", "full");
    }

    public void setSendStringParametersAsUnicode(boolean bl2) {
        this.setBooleanProperty(this.connectionProps, "sendStringParametersAsUnicode", bl2);
    }

    public boolean getSendStringParametersAsUnicode() {
        return this.getBooleanProperty(this.connectionProps, "sendStringParametersAsUnicode", true);
    }

    public void setServerName(String string) {
        this.setStringProperty(this.connectionProps, "serverName", string);
    }

    public String getServerName() {
        return this.getStringProperty(this.connectionProps, "serverName", null);
    }

    public void setFailoverPartner(String string) {
        this.setStringProperty(this.connectionProps, "failoverPartner", string);
    }

    public String getFailoverPartner() {
        return this.getStringProperty(this.connectionProps, "failoverPartner", null);
    }

    public void setUser(String string) {
        this.setStringProperty(this.connectionProps, "user", string);
    }

    public String getUser() {
        return this.getStringProperty(this.connectionProps, "user", null);
    }

    public void setWorkstationID(String string) {
        this.setStringProperty(this.connectionProps, "workstationID", string);
    }

    public String getWorkstationID() {
        String string = this.getStringProperty(this.connectionProps, "workstationID", null);
        if (null == string) {
            try {
                string = Util.lookupHostName();
            }
            catch (UnknownHostException unknownHostException) {
                string = "WSID Not Available";
            }
        }
        return string;
    }

    public void setXopenStates(boolean bl2) {
        this.setBooleanProperty(this.connectionProps, "xopenStates", bl2);
    }

    public boolean getXopenStates() {
        return this.getBooleanProperty(this.connectionProps, "xopenStates", false);
    }

    public void setURL(String string) {
        this.dataSourceURL = string;
    }

    public String getURL() {
        if (null == this.dataSourceURL) {
            return "jdbc:sqlserver://";
        }
        return this.dataSourceURL;
    }

    public void setDescription(String string) {
        this.dataSourceDescription = string;
    }

    public String getDescription() {
        return this.dataSourceDescription;
    }

    public void setPacketSize(int n2) {
        this.setIntProperty(this.connectionProps, "packetSize", n2);
    }

    public int getPacketSize() {
        return this.getIntProperty(this.connectionProps, "packetSize", 8000);
    }

    private void setStringProperty(Properties properties, String string, String string2) {
        if (null == string2) {
            return;
        }
        properties.setProperty(string, string2);
    }

    private String getStringProperty(Properties properties, String string, String string2) {
        String string3 = properties.getProperty(string);
        if (null == string3) {
            return string2;
        }
        return string3;
    }

    private void setIntProperty(Properties properties, String string, int n2) {
        properties.setProperty(string, new Integer(n2).toString());
    }

    private int getIntProperty(Properties properties, String string, int n2) {
        String string2 = properties.getProperty(string);
        if (null == string2) {
            return n2;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return n2;
        }
    }

    private void setBooleanProperty(Properties properties, String string, boolean bl2) {
        properties.setProperty(string, bl2 ? "true" : "false");
    }

    private boolean getBooleanProperty(Properties properties, String string, boolean bl2) {
        String string2 = properties.getProperty(string);
        if (null == string2) {
            return bl2;
        }
        Boolean bl3 = Boolean.valueOf(string2);
        return bl3;
    }

    SQLServerConnection getConnectionInternal(String string, String string2, SQLServerPooledConnection sQLServerPooledConnection) throws SQLServerException {
        Serializable serializable;
        Properties properties = null;
        Properties properties2 = null;
        if (null != string || null != string2) {
            properties = (Properties)this.connectionProps.clone();
            properties.remove("user");
            properties.remove("password");
            if (null != string) {
                properties.put("user", string);
            }
            if (null != string2) {
                properties.put("password", string2);
            }
        } else {
            properties = this.connectionProps;
        }
        if (null != this.dataSourceURL) {
            serializable = Util.parseUrl(this.dataSourceURL);
            if (null == serializable) {
                SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_errorConnectionString"), null, true);
            }
            properties2 = SQLServerDriver.mergeURLAndSuppliedProperties((Properties)serializable, properties);
        } else {
            properties2 = properties;
        }
        if (dsLogger.isLoggable(Level.FINE)) {
            dsLogger.fine(this.toLogString() + " Begin create new connection.");
        }
        serializable = new SQLServerConnection();
        ((SQLServerConnection)serializable).sConnectURL = this.dataSourceURL;
        ((SQLServerConnection)serializable).connect(properties2, sQLServerPooledConnection);
        if (dsLogger.isLoggable(Level.FINE)) {
            dsLogger.fine(this.toLogString() + " End create new connection " + ((SQLServerConnection)serializable).toLogString());
        }
        return serializable;
    }

    public Reference getReference() {
        return this.getReferenceInternal("com.microsoft.sqlserver.jdbc.SQLServerDataSource");
    }

    Reference getReferenceInternal(String string) {
        if (dsLogger.isLoggable(Level.FINE)) {
            dsLogger.fine(this.toLogString() + " creating reference for " + string + ".");
        }
        Reference reference = new Reference(this.getClass().getName(), "com.microsoft.sqlserver.jdbc.SQLServerDataSourceObjectFactory", null);
        reference.add(new StringRefAddr("class", string));
        Enumeration<Object> enumeration = this.connectionProps.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            reference.add(new StringRefAddr(string2, this.connectionProps.getProperty(string2)));
        }
        if (null != this.dataSourceURL) {
            reference.add(new StringRefAddr("dataSourceURL", this.dataSourceURL));
        }
        if (null != this.dataSourceDescription) {
            reference.add(new StringRefAddr("dataSourceDescription", this.dataSourceDescription));
        }
        return reference;
    }

    void initializeFromReference(Reference reference) {
        Enumeration<RefAddr> enumeration = reference.getAll();
        while (enumeration.hasMoreElements()) {
            StringRefAddr stringRefAddr = (StringRefAddr)enumeration.nextElement();
            String string = stringRefAddr.getType();
            String string2 = (String)stringRefAddr.getContent();
            if (string.equals("dataSourceURL")) {
                this.dataSourceURL = string2;
                continue;
            }
            if (string.equals("dataSourceDescription")) {
                this.dataSourceDescription = string2;
                continue;
            }
            if (string.equals("class")) continue;
            this.connectionProps.setProperty(string, string2);
        }
    }

    private static synchronized int nextDataSourceID() {
        return ++baseDataSourceID;
    }
}

