/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.DataTypeFilter;
import com.microsoft.sqlserver.jdbc.PrecisionFilter;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerResultSet;
import com.microsoft.sqlserver.jdbc.SQLServerStatement;
import com.microsoft.sqlserver.jdbc.Util;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Properties;

public final class SQLServerDatabaseMetaData
implements DatabaseMetaData,
Serializable {
    private SQLServerConnection connection;
    static final String urlprefix = "jdbc:sqlserver://";
    private static final String ASC_OR_DESC = "ASC_OR_DESC";
    private static final String ATTR_NAME = "ATTR_NAME";
    private static final String ATTR_TYPE_NAME = "ATTR_TYPE_NAME";
    private static final String ATTR_SIZE = "ATTR_SIZE";
    private static final String ATTR_DEF = "ATTR_DEF";
    private static final String BASE_TYPE = "BASE_TYPE";
    private static final String BUFFER_LENGTH = "BUFFER_LENGTH";
    private static final String CARDINALITY = "CARDINALITY";
    private static final String CHAR_OCTET_LENGTH = "CHAR_OCTET_LENGTH";
    private static final String CLASS_NAME = "CLASS_NAME";
    private static final String COLUMN_DEF = "COLUMN_DEF";
    private static final String COLUMN_NAME = "COLUMN_NAME";
    private static final String COLUMN_SIZE = "COLUMN_SIZE";
    private static final String COLUMN_TYPE = "COLUMN_TYPE";
    private static final String DATA_TYPE = "DATA_TYPE";
    private static final String DECIMAL_DIGITS = "DECIMAL_DIGITS";
    private static final String DEFERRABILITY = "DEFERRABILITY";
    private static final String DELETE_RULE = "DELETE_RULE";
    private static final String FILTER_CONDITION = "FILTER_CONDITION";
    private static final String FK_NAME = "FK_NAME";
    private static final String FKCOLUMN_NAME = "FKCOLUMN_NAME";
    private static final String FKTABLE_CAT = "FKTABLE_CAT";
    private static final String FKTABLE_NAME = "FKTABLE_NAME";
    private static final String FKTABLE_SCHEM = "FKTABLE_SCHEM";
    private static final String GRANTEE = "GRANTEE";
    private static final String GRANTOR = "GRANTOR";
    private static final String INDEX_NAME = "INDEX_NAME";
    private static final String INDEX_QUALIFIER = "INDEX_QUALIFIER";
    private static final String IS_GRANTABLE = "IS_GRANTABLE";
    private static final String IS_NULLABLE = "IS_NULLABLE";
    private static final String KEY_SEQ = "KEY_SEQ";
    private static final String LENGTH = "LENGTH";
    private static final String NON_UNIQUE = "NON_UNIQUE";
    private static final String NULLABLE = "NULLABLE";
    private static final String NUM_INPUT_PARAMS = "NUM_INPUT_PARAMS";
    private static final String NUM_OUTPUT_PARAMS = "NUM_OUTPUT_PARAMS";
    private static final String NUM_PREC_RADIX = "NUM_PREC_RADIX";
    private static final String NUM_RESULT_SETS = "NUM_RESULT_SETS";
    private static final String ORDINAL_POSITION = "ORDINAL_POSITION";
    private static final String PAGES = "PAGES";
    private static final String PK_NAME = "PK_NAME";
    private static final String PKCOLUMN_NAME = "PKCOLUMN_NAME";
    private static final String PKTABLE_CAT = "PKTABLE_CAT";
    private static final String PKTABLE_NAME = "PKTABLE_NAME";
    private static final String PKTABLE_SCHEM = "PKTABLE_SCHEM";
    private static final String PRECISION = "PRECISION";
    private static final String PRIVILEGE = "PRIVILEGE";
    private static final String PROCEDURE_CAT = "PROCEDURE_CAT";
    private static final String PROCEDURE_NAME = "PROCEDURE_NAME";
    private static final String PROCEDURE_SCHEM = "PROCEDURE_SCHEM";
    private static final String PROCEDURE_TYPE = "PROCEDURE_TYPE";
    private static final String PSEUDO_COLUMN = "PSEUDO_COLUMN";
    private static final String RADIX = "RADIX";
    private static final String REMARKS = "REMARKS";
    private static final String SCALE = "SCALE";
    private static final String SCOPE = "SCOPE";
    private static final String SCOPE_CATALOG = "SCOPE_CATALOG";
    private static final String SCOPE_SCHEMA = "SCOPE_SCHEMA";
    private static final String SCOPE_TABLE = "SCOPE_TABLE";
    private static final String SOURCE_DATA_TYPE = "SOURCE_DATA_TYPE";
    private static final String SQL_DATA_TYPE = "SQL_DATA_TYPE";
    private static final String SQL_DATETIME_SUB = "SQL_DATETIME_SUB";
    private static final String SS_DATA_TYPE = "SS_DATA_TYPE";
    private static final String SUPERTABLE_NAME = "SUPERTABLE_NAME";
    private static final String SUPERTYPE_CAT = "SUPERTYPE_CAT";
    private static final String SUPERTYPE_NAME = "SUPERTYPE_NAME";
    private static final String SUPERTYPE_SCHEM = "SUPERTYPE_SCHEM";
    private static final String TABLE_CAT = "TABLE_CAT";
    private static final String TABLE_NAME = "TABLE_NAME";
    private static final String TABLE_SCHEM = "TABLE_SCHEM";
    private static final String TABLE_TYPE = "TABLE_TYPE";
    private static final String TYPE = "TYPE";
    private static final String TYPE_CAT = "TYPE_CAT";
    private static final String TYPE_NAME = "TYPE_NAME";
    private static final String TYPE_SCHEM = "TYPE_SCHEM";
    private static final String UPDATE_RULE = "UPDATE_RULE";
    private static final String[] getColumnPrivilegesColumnNames = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "GRANTOR", "GRANTEE", "PRIVILEGE", "IS_GRANTABLE"};
    private static final String[] getTablesColumnNames = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "TABLE_TYPE", "REMARKS"};
    static final char LEFT_BRACKET = '[';
    static final char RIGHT_BRACKET = ']';
    static final char ESCAPE = '\\';
    static final char PERCENT = '%';
    static final char UNDERSCORE = '_';
    static final char[] DOUBLE_RIGHT_BRACKET = new char[]{']', ']'};
    private static final String[] getColumnsColumnNames = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "NUM_PREC_RADIX", "NULLABLE", "REMARKS", "COLUMN_DEF", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "CHAR_OCTET_LENGTH", "ORDINAL_POSITION", "IS_NULLABLE"};
    private static final String[] getBestRowIdentifierColumnNames = new String[]{"SCOPE", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "PSEUDO_COLUMN"};
    private static final String[] pkfkColumnNames = new String[]{"PKTABLE_CAT", "PKTABLE_SCHEM", "PKTABLE_NAME", "PKCOLUMN_NAME", "FKTABLE_CAT", "FKTABLE_SCHEM", "FKTABLE_NAME", "FKCOLUMN_NAME", "KEY_SEQ", "UPDATE_RULE", "DELETE_RULE", "FK_NAME", "PK_NAME", "DEFERRABILITY"};
    private static final String[] getIndexInfoColumnNames = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "NON_UNIQUE", "INDEX_QUALIFIER", "INDEX_NAME", "TYPE", "ORDINAL_POSITION", "COLUMN_NAME", "ASC_OR_DESC", "CARDINALITY", "PAGES", "FILTER_CONDITION"};
    private static final String[] getPrimaryKeysColumnNames = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "KEY_SEQ", "PK_NAME"};
    private static final String[] getProcedureColumnsColumnNames = new String[]{"PROCEDURE_CAT", "PROCEDURE_SCHEM", "PROCEDURE_NAME", "COLUMN_NAME", "COLUMN_TYPE", "DATA_TYPE", "TYPE_NAME", "PRECISION", "LENGTH", "SCALE", "RADIX", "NULLABLE", "REMARKS", "COLUMN_DEF", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "CHAR_OCTET_LENGTH", "ORDINAL_POSITION", "IS_NULLABLE", "SS_DATA_TYPE"};
    private static final String[] getProceduresColumnNames = new String[]{"PROCEDURE_CAT", "PROCEDURE_SCHEM", "PROCEDURE_NAME", "NUM_INPUT_PARAMS", "NUM_OUTPUT_PARAMS", "NUM_RESULT_SETS", "REMARKS", "PROCEDURE_TYPE"};
    private static final String[] getTablePrivilegesColumnNames = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "GRANTOR", "GRANTEE", "PRIVILEGE", "IS_GRANTABLE"};
    private static final String[] getVersionColumnsColumnNames = new String[]{"SCOPE", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "PSEUDO_COLUMN"};

    public SQLServerDatabaseMetaData(SQLServerConnection sQLServerConnection) {
        this.connection = sQLServerConnection;
    }

    private void checkClosed() throws SQLServerException {
        if (this.connection.isClosed()) {
            SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_connectionClosed"), null, false);
        }
    }

    private final SQLServerResultSet getResultSet(String string) throws SQLServerException {
        return ((SQLServerStatement)this.connection.createStatement()).executeQueryInternal(string);
    }

    private final SQLServerResultSet getResultSet(String string, String[] stringArray) throws SQLServerException {
        SQLServerResultSet sQLServerResultSet = this.getResultSet(string);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            sQLServerResultSet.setColumnName(1 + i2, stringArray[i2]);
        }
        return sQLServerResultSet;
    }

    final String paramString(String string, String string2, String string3, String string4, boolean bl2, String string5) {
        String string6 = " ";
        String string7 = string;
        if (string7 == null) {
            string7 = "";
        }
        String string8 = "";
        string8 = "table_";
        string6 = string2 != null ? string6 + "@" + string7 + string8 + "qualifier = '" + string2 + "'" : string6 + "@" + string7 + string8 + "qualifier = null";
        string6 = string3 != null ? string6 + ", @" + string7 + string8 + "owner" + " = '" + string3 + "'" : string6 + ", @" + string7 + string8 + "owner" + " = null";
        string6 = string4 != null ? string6 + ", @" + string7 + string8 + "name" + " = '" + string4 + "'" : string6 + ", @" + string7 + string8 + "name" + " = null";
        if (bl2) {
            string6 = string5 != null ? string6 + ", @" + string7 + "column_name = '" + string5 + "'" : string6 + ", @" + string7 + "column_name = null";
        }
        return string6 + " ";
    }

    private String switchCatalogs(String string) throws SQLServerException {
        String string2;
        if (string == null) {
            return null;
        }
        String string3 = null;
        string3 = this.connection.getCatalog().trim();
        if (string3.equals(string2 = string.trim())) {
            return null;
        }
        this.connection.setCatalog(string2);
        if (string3 == null || string3.length() == 0) {
            return null;
        }
        return string3;
    }

    public boolean allProceduresAreCallable() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean allTablesAreSelectable() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    public ResultSet getCatalogs() throws SQLServerException {
        this.checkClosed();
        String string = "SELECT name AS TABLE_CAT FROM master.dbo.sysdatabases order by name";
        return this.getResultSet(string);
    }

    public String getCatalogSeparator() throws SQLServerException {
        this.checkClosed();
        return ".";
    }

    public String getCatalogTerm() throws SQLServerException {
        this.checkClosed();
        return "database";
    }

    public ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws SQLServerException {
        this.checkClosed();
        string4 = SQLServerDatabaseMetaData.EscapeIDName(string4);
        String string5 = "exec sp_column_privileges " + this.paramString(null, string, string2, string3, true, string4);
        return this.getResultSet(string5, getColumnPrivilegesColumnNames);
    }

    public ResultSet getTables(String string, String string2, String string3, String[] stringArray) throws SQLServerException {
        this.checkClosed();
        string3 = SQLServerDatabaseMetaData.EscapeIDName(string3);
        string2 = SQLServerDatabaseMetaData.EscapeIDName(string2);
        String string4 = this.paramString(null, string, string2, string3, false, null);
        if (stringArray != null) {
            String string5 = "'";
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (i2 > 0) {
                    string5 = string5 + ",";
                }
                string5 = string5 + "''" + stringArray[i2] + "''";
            }
            string5 = string5 + "'";
            string4 = string4 + ", @table_type = " + string5;
        }
        return this.getResultSet("exec sp_tables " + string4, getTablesColumnNames);
    }

    private static String EscapeIDName(String string) throws SQLServerException {
        if (null == string) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() + 2);
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if ('\\' == c2 && ++i2 < string.length()) {
                c2 = string.charAt(i2);
                switch (c2) {
                    case '%': 
                    case '[': 
                    case '_': {
                        stringBuffer.append('[');
                        stringBuffer.append(c2);
                        stringBuffer.append(']');
                        break;
                    }
                    case '\\': 
                    case ']': {
                        stringBuffer.append(c2);
                        break;
                    }
                    default: {
                        stringBuffer.append('\\');
                        stringBuffer.append(c2);
                        break;
                    }
                }
                continue;
            }
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    public ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLServerException {
        this.checkClosed();
        String string5 = SQLServerDatabaseMetaData.EscapeIDName(string4);
        string3 = SQLServerDatabaseMetaData.EscapeIDName(string3);
        string2 = SQLServerDatabaseMetaData.EscapeIDName(string2);
        String string6 = "exec sp_columns ";
        String string7 = this.paramString(null, string, string2, string3, true, string5) + ",@ODBCVer=3";
        SQLServerResultSet sQLServerResultSet = this.getResultSet(string6 + string7, getColumnsColumnNames);
        sQLServerResultSet.setFilter(5, new DataTypeFilter());
        sQLServerResultSet.setFilter(7, new PrecisionFilter());
        return sQLServerResultSet;
    }

    public ResultSet getBestRowIdentifier(String string, String string2, String string3, int n2, boolean bl2) throws SQLServerException {
        this.checkClosed();
        String string4 = this.paramString(null, string, string2, string3, false, null) + ",@ODBCVer=3 ";
        string4 = string4 + ", @col_type = 'R'";
        if (n2 != 0) {
            string4 = string4 + ", @scope = 'T'";
        }
        string4 = bl2 ? string4 + ", @nullable = 'U'" : string4 + ", @nullable = 'O'";
        SQLServerResultSet sQLServerResultSet = this.getResultSet("exec sp_special_columns " + string4, getBestRowIdentifierColumnNames);
        sQLServerResultSet.setFilter(3, new DataTypeFilter());
        sQLServerResultSet.setFilter(5, new PrecisionFilter());
        return sQLServerResultSet;
    }

    public ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SQLServerException {
        this.checkClosed();
        String string7 = this.paramString("pk", string, string2, string3, false, null);
        String string8 = this.paramString("fk", string4, string5, string6, false, null);
        return this.getResultSet("exec sp_fkeys " + string7 + "," + string8, pkfkColumnNames);
    }

    public String getDatabaseProductName() throws SQLServerException {
        this.checkClosed();
        return "Microsoft SQL Server";
    }

    public String getDatabaseProductVersion() throws SQLServerException {
        this.checkClosed();
        return this.connection.sqlServerVersion;
    }

    public int getDefaultTransactionIsolation() throws SQLServerException {
        this.checkClosed();
        return 2;
    }

    public int getDriverMajorVersion() {
        return Util.majorVersion();
    }

    public int getDriverMinorVersion() {
        try {
            Integer n2 = new Integer(Util.minorVersion());
            return n2;
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public String getDriverName() throws SQLServerException {
        this.checkClosed();
        String string = "Microsoft SQL Server 2005 JDBC Driver";
        return string;
    }

    public String getDriverVersion() throws SQLServerException {
        int n2 = this.getDriverMinorVersion();
        String string = this.getDriverMajorVersion() + ".";
        string = string + "" + n2;
        string = string + ".";
        string = string + 2323;
        string = string + ".";
        string = string + 101;
        return string;
    }

    public ResultSet getExportedKeys(String string, String string2, String string3) throws SQLServerException {
        this.checkClosed();
        String string4 = this.paramString("pk", string, string2, string3, false, null);
        return this.getResultSet("exec sp_fkeys " + string4, pkfkColumnNames);
    }

    public String getExtraNameCharacters() throws SQLServerException {
        this.checkClosed();
        return "$#@";
    }

    public String getIdentifierQuoteString() throws SQLServerException {
        this.checkClosed();
        return "\"";
    }

    public ResultSet getImportedKeys(String string, String string2, String string3) throws SQLServerException {
        this.checkClosed();
        String string4 = this.paramString("fk", string, string2, string3, false, null);
        return this.getResultSet("exec sp_fkeys " + string4, pkfkColumnNames);
    }

    public ResultSet getIndexInfo(String string, String string2, String string3, boolean bl2, boolean bl3) throws SQLServerException {
        this.checkClosed();
        String string4 = this.paramString(null, string, string2, string3, false, null);
        string4 = bl2 ? string4 + ",@is_unique = 'Y'" : string4 + ",@is_unique = 'F'";
        return this.getResultSet("exec sp_statistics " + string4, getIndexInfoColumnNames);
    }

    public int getMaxBinaryLiteralLength() throws SQLServerException {
        this.checkClosed();
        return 0;
    }

    public int getMaxCatalogNameLength() throws SQLServerException {
        this.checkClosed();
        return 128;
    }

    public int getMaxCharLiteralLength() throws SQLServerException {
        this.checkClosed();
        return 0;
    }

    public int getMaxColumnNameLength() throws SQLServerException {
        this.checkClosed();
        return 128;
    }

    public int getMaxColumnsInGroupBy() throws SQLServerException {
        this.checkClosed();
        return 0;
    }

    public int getMaxColumnsInIndex() throws SQLServerException {
        this.checkClosed();
        return 16;
    }

    public int getMaxColumnsInOrderBy() throws SQLServerException {
        this.checkClosed();
        return 0;
    }

    public int getMaxColumnsInSelect() throws SQLServerException {
        this.checkClosed();
        return 4096;
    }

    public int getMaxColumnsInTable() throws SQLServerException {
        this.checkClosed();
        return 1024;
    }

    public int getMaxConnections() throws SQLServerException {
        this.checkClosed();
        if (this.connection.isYukonOrLater()) {
            try {
                String string = "sp_configure 'user connections'";
                SQLServerResultSet sQLServerResultSet = this.getResultSet(string);
                if (!sQLServerResultSet.next()) {
                    return 0;
                }
                return sQLServerResultSet.getInt("maximum");
            }
            catch (SQLServerException sQLServerException) {
                return 0;
            }
        }
        return 0;
    }

    public int getMaxCursorNameLength() throws SQLServerException {
        this.checkClosed();
        return 0;
    }

    public int getMaxIndexLength() throws SQLServerException {
        this.checkClosed();
        return 900;
    }

    public int getMaxProcedureNameLength() throws SQLServerException {
        this.checkClosed();
        return 128;
    }

    public int getMaxRowSize() throws SQLServerException {
        this.checkClosed();
        return 8060;
    }

    public int getMaxSchemaNameLength() throws SQLServerException {
        this.checkClosed();
        return 128;
    }

    public int getMaxStatementLength() throws SQLServerException {
        this.checkClosed();
        return 65536 * this.connection.getTDSPacketSize();
    }

    public int getMaxStatements() throws SQLServerException {
        this.checkClosed();
        return 0;
    }

    public int getMaxTableNameLength() throws SQLServerException {
        this.checkClosed();
        return 128;
    }

    public int getMaxTablesInSelect() throws SQLServerException {
        this.checkClosed();
        return 256;
    }

    public int getMaxUserNameLength() throws SQLServerException {
        this.checkClosed();
        return 128;
    }

    public String getNumericFunctions() throws SQLServerException {
        this.checkClosed();
        if (this.connection.isYukonOrLater()) {
            return "ABS,ACOS,ASIN,ATAN,ATAN2,CEILING,COS,COT,DEGREES,EXP, FLOOR,LOG,LOG10,MOD,PI,POWER,RADIANS,RAND,ROUND,SIGN,SIN,SQRT,TAN,TRUNCATE";
        }
        return "ABS,ACOS,ASIN,ATAN,ATAN2,CEILING,COS,COT,DEGREES,EXP, FLOOR,LOG,LOG10,PI,POWER,RADIANS,RAND,ROUND,SIGN,SIN,SQRT,TAN,TRUNCATE";
    }

    public ResultSet getPrimaryKeys(String string, String string2, String string3) throws SQLServerException {
        this.checkClosed();
        String string4 = this.paramString(null, string, string2, string3, false, null);
        return this.getResultSet("exec sp_pkeys " + string4, getPrimaryKeysColumnNames);
    }

    public ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws SQLServerException {
        this.checkClosed();
        String string5 = " ";
        string5 = string != null ? string5 + "@procedure_qualifier = '" + string + "'" : string5 + "@procedure_qualifier = null";
        string5 = string2 != null ? string5 + ", @procedure_owner = '" + string2 + "'" : string5 + ", @procedure_owner = null";
        if (string3 != null) {
            string3 = SQLServerDatabaseMetaData.EscapeIDName(string3);
            string5 = string5 + ", @procedure_name = '" + string3 + "'";
        } else {
            string5 = string5 + ", @procedure_name = null";
        }
        if (string4 != null) {
            string4 = SQLServerDatabaseMetaData.EscapeIDName(string4);
            string5 = string5 + ", @column_name = '" + string4 + "'";
        } else {
            string5 = string5 + ", @column_name = null";
        }
        SQLServerResultSet sQLServerResultSet = this.getResultSet("exec sp_sproc_columns " + string5 + ", @ODBCVer=3", getProcedureColumnsColumnNames);
        sQLServerResultSet.setFilter(6, new DataTypeFilter());
        sQLServerResultSet.setFilter(8, new PrecisionFilter());
        return sQLServerResultSet;
    }

    public ResultSet getProcedures(String string, String string2, String string3) throws SQLServerException {
        this.checkClosed();
        String string4 = " ";
        string4 = string != null ? string4 + "@sp_qualifier = '" + string + "'" : string4 + "@sp_qualifier = null";
        string4 = string2 != null ? string4 + ", @sp_owner = '" + string2 + "'" : string4 + ", @sp_owner = null";
        if (string3 != null) {
            string3 = SQLServerDatabaseMetaData.EscapeIDName(string3);
            string4 = string4 + ", @sp_name = '" + string3 + "'";
        } else {
            string4 = string4 + ", @sp_name = null";
        }
        return this.getResultSet("exec sp_stored_procedures " + string4, getProceduresColumnNames);
    }

    public String getProcedureTerm() throws SQLServerException {
        this.checkClosed();
        return "stored procedure";
    }

    public ResultSet getSchemas() throws SQLServerException {
        String string;
        this.checkClosed();
        if (this.connection.isYukonOrLater()) {
            string = "select sys.database_principals.name 'TABLE_SCHEM', sys.database_principals.default_schema_name 'TABLE_CATALOG' from sys.database_principals";
            string = string + " where not sid is null order by sys.database_principals.name";
        } else {
            string = "select sysusers.name 'TABLE_SCHEM' from sysusers where not ";
            string = string + "sid";
            string = string + " is null order by sysusers.name";
        }
        SQLServerResultSet sQLServerResultSet = this.getResultSet(string);
        return sQLServerResultSet;
    }

    public String getSchemaTerm() throws SQLServerException {
        this.checkClosed();
        return "schema";
    }

    public String getSearchStringEscape() throws SQLServerException {
        this.checkClosed();
        return "\\";
    }

    public String getSQLKeywords() throws SQLServerException {
        this.checkClosed();
        return "BACKUP,BREAK,BROWSE,BULK,CHECKPOINT,CLUSTERED,COMPUTE,CONTAINS,CONTAINSTABLE,DATABASE,DBCC,DENY,DISK,DISTRIBUTED,DUMMY,DUMP,ERRLVL,EXIT,FILE,FILLFACTOR,FREETEXT,FREETEXTTABLE,FUNCTION,HOLDLOCK,IDENTITY_INSERT,IDENTITYCOL,IF,KILL,LINENO,LOAD,NOCHECK,NONCLUSTERED,OFF,OFFSETS,OPENDATASOURCE,OPENQUERY,OPENROWSET,OPENXML,OVER,PERCENT,PLAN,PRINT,PROC,RAISERROR,READTEXT,RECONFIGURE,REPLICATION,RESTORE,RETURN,ROWCOUNT,ROWGUIDCOL,RULE,SAVE,SETUSER,SHUTDOWN,STATISTICS,TEXTSIZE,TOP,TRAN,TRIGGER,TRUNCATE,TSEQUAL,UPDATETEXT,USE,WAITFOR,WHILE,WRITETEXT";
    }

    public String getStringFunctions() throws SQLServerException {
        this.checkClosed();
        return "ASCII,CHAR,CONCAT, DIFFERENCE,INSERT,LCASE,LEFT,LENGTH,LOCATE,LTRIM,REPEAT,REPLACE,RIGHT,RTRIM,SOUNDEX,SPACE,SUBSTRING,UCASE";
    }

    public String getSystemFunctions() throws SQLServerException {
        this.checkClosed();
        return "DATABASE,IFNULL,USER";
    }

    public ResultSet getTablePrivileges(String string, String string2, String string3) throws SQLServerException {
        this.checkClosed();
        string3 = SQLServerDatabaseMetaData.EscapeIDName(string3);
        string2 = SQLServerDatabaseMetaData.EscapeIDName(string2);
        String string4 = "exec sp_table_privileges " + this.paramString(null, string, string2, string3, false, null);
        return this.getResultSet(string4, getTablePrivilegesColumnNames);
    }

    public ResultSet getTableTypes() throws SQLServerException {
        this.checkClosed();
        String string = "SELECT 'VIEW' 'TABLE_TYPE' UNION SELECT 'TABLE' UNION SELECT 'SYSTEM TABLE'";
        SQLServerResultSet sQLServerResultSet = this.getResultSet(string);
        return sQLServerResultSet;
    }

    public String getTimeDateFunctions() throws SQLServerException {
        this.checkClosed();
        return "CURDATE,CURTIME,DAYNAME,DAYOFMONTH,DAYOFWEEK,DAYOFYEAR,HOUR,MINUTE,MONTH,MONTHNAME,NOW,QUARTER,SECOND,TIMESTAMPADD,TIMESTAMPDIFF,WEEK,YEAR";
    }

    public ResultSet getTypeInfo() throws SQLServerException {
        this.checkClosed();
        SQLServerResultSet sQLServerResultSet = this.getResultSet("sp_datatype_info @ODBCVer=3");
        sQLServerResultSet.setColumnName(11, "FIXED_PREC_SCALE");
        sQLServerResultSet.setFilter(2, new DataTypeFilter());
        sQLServerResultSet.setFilter(3, new PrecisionFilter());
        return sQLServerResultSet;
    }

    public String getURL() throws SQLServerException {
        this.checkClosed();
        StringBuffer stringBuffer = new StringBuffer();
        Properties properties = this.connection.activeConnectionProperties;
        String string = null;
        String string2 = null;
        String string3 = null;
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string4 = (String)enumeration.nextElement();
            if (string4.equals("integratedSecurity") || string4.equals("user") || string4.equals("password")) continue;
            String string5 = properties.getProperty(string4);
            if (string4.equals("serverName")) {
                string = string5;
                continue;
            }
            if (string4.equals("instanceName")) {
                string3 = string5;
                continue;
            }
            if (string4.equals("portNumber")) {
                string2 = string5;
                continue;
            }
            stringBuffer.append(string4);
            stringBuffer.append("=");
            stringBuffer.append(string5);
            stringBuffer.append(";");
        }
        stringBuffer.insert(0, ";");
        stringBuffer.insert(0, string2);
        stringBuffer.insert(0, ":");
        if (null != string3) {
            stringBuffer.insert(0, string3);
            stringBuffer.insert(0, "\\");
        }
        stringBuffer.insert(0, string);
        stringBuffer.insert(0, urlprefix);
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUserName() throws SQLServerException {
        String string;
        SQLServerStatement sQLServerStatement;
        block9: {
            SQLServerResultSet sQLServerResultSet;
            block7: {
                String string2;
                block8: {
                    this.checkClosed();
                    sQLServerStatement = null;
                    sQLServerResultSet = null;
                    string = "";
                    try {
                        sQLServerStatement = (SQLServerStatement)this.connection.createStatement();
                        sQLServerResultSet = sQLServerStatement.executeQueryInternal("select system_user");
                        if (sQLServerResultSet.next()) break block7;
                        string2 = null;
                        Object var6_5 = null;
                        if (sQLServerResultSet == null) break block8;
                    }
                    catch (Throwable throwable) {
                        Object var6_7 = null;
                        if (sQLServerResultSet != null) {
                            sQLServerResultSet.close();
                        }
                        if (sQLServerStatement != null) {
                            sQLServerStatement.close();
                        }
                        throw throwable;
                    }
                    sQLServerResultSet.close();
                }
                if (sQLServerStatement != null) {
                    sQLServerStatement.close();
                }
                return string2;
            }
            string = sQLServerResultSet.getString(1);
            Object var6_6 = null;
            if (sQLServerResultSet == null) break block9;
            sQLServerResultSet.close();
        }
        if (sQLServerStatement != null) {
            sQLServerStatement.close();
        }
        return string;
    }

    public ResultSet getVersionColumns(String string, String string2, String string3) throws SQLServerException {
        this.checkClosed();
        String string4 = this.paramString(null, string, string2, string3, false, null);
        string4 = string4 + " ,@ODBCVer=3, @col_type= 'V', @scope ='T', @nullable = 'U'";
        SQLServerResultSet sQLServerResultSet = this.getResultSet("exec sp_special_columns " + string4, getVersionColumnsColumnNames);
        sQLServerResultSet.setFilter(3, new DataTypeFilter());
        sQLServerResultSet.setFilter(5, new PrecisionFilter());
        return sQLServerResultSet;
    }

    public boolean isCatalogAtStart() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean isReadOnly() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    public boolean nullPlusNonNullIsNull() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean nullsAreSortedAtEnd() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    public boolean nullsAreSortedAtStart() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    public boolean nullsAreSortedHigh() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    public boolean nullsAreSortedLow() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean storesLowerCaseIdentifiers() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    public boolean storesMixedCaseIdentifiers() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean storesUpperCaseIdentifiers() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsANSI92FullSQL() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsColumnAliasing() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsConvert() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsConvert(int n2, int n3) throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsCoreSQLGrammar() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsCorrelatedSubqueries() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    public boolean supportsExpressionsInOrderBy() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsExtendedSQLGrammar() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    public boolean supportsFullOuterJoins() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsGroupBy() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsGroupByBeyondSelect() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsGroupByUnrelated() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    public boolean supportsLikeEscapeClause() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsLimitedOuterJoins() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsMinimumSQLGrammar() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsMultipleResultSets() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsMultipleTransactions() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsNonNullableColumns() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsOrderByUnrelated() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsOuterJoins() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsPositionedDelete() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsPositionedUpdate() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsSchemasInDataManipulation() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsSelectForUpdate() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    public boolean supportsStoredProcedures() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsSubqueriesInComparisons() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsSubqueriesInExists() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsSubqueriesInIns() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsTableCorrelationNames() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsTransactionIsolationLevel(int n2) throws SQLServerException {
        this.checkClosed();
        switch (n2) {
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 4096: {
                return true;
            }
        }
        return false;
    }

    public boolean supportsTransactions() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsUnion() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsUnionAll() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean usesLocalFilePerTable() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    public boolean usesLocalFiles() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    public boolean supportsResultSetType(int n2) throws SQLServerException {
        this.checkClosed();
        this.checkResultType(n2);
        switch (n2) {
            case 1003: 
            case 1004: 
            case 1005: 
            case 1006: 
            case 2003: 
            case 2004: {
                return true;
            }
        }
        return false;
    }

    public boolean supportsResultSetConcurrency(int n2, int n3) throws SQLServerException {
        this.checkClosed();
        this.checkResultType(n2);
        this.checkConcurrencyType(n3);
        switch (n2) {
            case 1003: 
            case 1005: 
            case 1006: 
            case 2004: {
                return true;
            }
            case 1004: 
            case 2003: {
                return 1007 == n3;
            }
        }
        return false;
    }

    public boolean ownUpdatesAreVisible(int n2) throws SQLServerException {
        this.checkClosed();
        this.checkResultType(n2);
        return n2 == 1006 || 1003 == n2 || 1005 == n2 || 1005 == n2 || 2004 == n2;
    }

    public boolean ownDeletesAreVisible(int n2) throws SQLServerException {
        this.checkClosed();
        this.checkResultType(n2);
        return n2 == 1006 || 1003 == n2 || 1005 == n2 || 1005 == n2 || 2004 == n2;
    }

    public boolean ownInsertsAreVisible(int n2) throws SQLServerException {
        this.checkClosed();
        this.checkResultType(n2);
        return n2 == 1006 || 1003 == n2 || 1005 == n2 || 1005 == n2 || 2004 == n2;
    }

    public boolean othersUpdatesAreVisible(int n2) throws SQLServerException {
        this.checkClosed();
        this.checkResultType(n2);
        return n2 == 1006 || 1003 == n2 || 1005 == n2 || 1005 == n2 || 2004 == n2;
    }

    public boolean othersDeletesAreVisible(int n2) throws SQLServerException {
        this.checkClosed();
        this.checkResultType(n2);
        return n2 == 1006 || 1003 == n2 || 1005 == n2 || 1005 == n2 || 2004 == n2;
    }

    public boolean othersInsertsAreVisible(int n2) throws SQLServerException {
        this.checkClosed();
        this.checkResultType(n2);
        return n2 == 1006 || 1003 == n2 || 2004 == n2;
    }

    public boolean updatesAreDetected(int n2) throws SQLServerException {
        this.checkClosed();
        this.checkResultType(n2);
        return false;
    }

    public boolean deletesAreDetected(int n2) throws SQLServerException {
        this.checkClosed();
        this.checkResultType(n2);
        return 1005 == n2;
    }

    private void checkResultType(int n2) throws SQLServerException {
        switch (n2) {
            case 1003: 
            case 1004: 
            case 1005: 
            case 1006: 
            case 2003: 
            case 2004: {
                return;
            }
        }
        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidArgument"));
        Object[] objectArray = new Object[]{new Integer(n2)};
        throw new SQLServerException(null, messageFormat.format(objectArray), null, 0, true);
    }

    private void checkConcurrencyType(int n2) throws SQLServerException {
        switch (n2) {
            case 1007: 
            case 1008: 
            case 1009: 
            case 1010: {
                return;
            }
        }
        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidArgument"));
        Object[] objectArray = new Object[]{new Integer(n2)};
        throw new SQLServerException(null, messageFormat.format(objectArray), null, 0, true);
    }

    public boolean insertsAreDetected(int n2) throws SQLServerException {
        this.checkClosed();
        this.checkResultType(n2);
        return false;
    }

    public boolean supportsBatchUpdates() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public ResultSet getUDTs(String string, String string2, String string3, int[] nArray) throws SQLServerException {
        this.checkClosed();
        return this.getResultSet("SELECT cast(NULL as char(1)) as TYPE_CAT, cast(NULL as char(1)) as TYPE_SCHEM, cast(NULL as char(1)) as TYPE_NAME, cast(NULL as char(1)) as CLASS_NAME, cast(0 as int) as DATA_TYPE, cast(NULL as char(1)) as REMARKS, cast(0 as smallint) as BASE_TYPE where 0 = 1");
    }

    public Connection getConnection() throws SQLServerException {
        this.checkClosed();
        return this.connection;
    }

    public int getSQLStateType() throws SQLServerException {
        this.checkClosed();
        if (this.connection != null && this.connection.xopenStates) {
            return 1;
        }
        return 2;
    }

    public int getDatabaseMajorVersion() throws SQLServerException {
        this.checkClosed();
        String string = this.connection.sqlServerVersion;
        int n2 = string.indexOf(46);
        if (n2 > 0) {
            string = string.substring(0, n2);
        }
        try {
            return new Integer(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public int getDatabaseMinorVersion() throws SQLServerException {
        this.checkClosed();
        String string = this.connection.sqlServerVersion;
        int n2 = string.indexOf(46);
        int n3 = string.indexOf(46, n2 + 1);
        if (n2 > 0 && n3 > 0) {
            string = string.substring(n2 + 1, n3);
        }
        try {
            return new Integer(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public int getJDBCMajorVersion() throws SQLServerException {
        this.checkClosed();
        return 3;
    }

    public int getJDBCMinorVersion() throws SQLServerException {
        this.checkClosed();
        return 0;
    }

    public int getResultSetHoldability() throws SQLServerException {
        this.checkClosed();
        return 1;
    }

    public boolean supportsResultSetHoldability(int n2) throws SQLServerException {
        this.checkClosed();
        if (1 == n2 || 2 == n2) {
            return true;
        }
        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidArgument"));
        Object[] objectArray = new Object[]{new Integer(n2)};
        throw new SQLServerException(null, messageFormat.format(objectArray), null, 0, true);
    }

    public ResultSet getAttributes(String string, String string2, String string3, String string4) throws SQLServerException {
        this.checkClosed();
        return this.getResultSet("SELECT cast(NULL as char(1)) as TYPE_CAT, cast(NULL as char(1)) as TYPE_SCHEM, cast(NULL as char(1)) as TYPE_NAME, cast(NULL as char(1)) as ATTR_NAME, cast(0 as int) as DATA_TYPE, cast(NULL as char(1)) as ATTR_TYPE_NAME, cast(0 as int) as ATTR_SIZE, cast(0 as int) as DECIMAL_DIGITS, cast(0 as int) as NUM_PREC_RADIX, cast(0 as int) as NULLABLE, cast(NULL as char(1)) as REMARKS, cast(NULL as char(1)) as ATTR_DEF, cast(0 as int) as SQL_DATA_TYPE, cast(0 as int) as SQL_DATETIME_SUB, cast(0 as int) as CHAR_OCTET_LENGTH, cast(0 as int) as ORDINAL_POSITION, cast(NULL as char(1)) as IS_NULLABLE, cast(NULL as char(1)) as SCOPE_CATALOG, cast(NULL as char(1)) as SCOPE_SCHEMA, cast(NULL as char(1)) as SCOPE_TABLE, cast(0 as smallint) as SOURCE_DATA_TYPE where 0 = 1");
    }

    public ResultSet getSuperTables(String string, String string2, String string3) throws SQLServerException {
        this.checkClosed();
        return this.getResultSet("SELECT cast(NULL as char(1)) as TYPE_CAT, cast(NULL as char(1)) as TYPE_SCHEM, cast(NULL as char(1)) as TYPE_NAME, cast(NULL as char(1)) as SUPERTABLE_NAME where 0 = 1");
    }

    public ResultSet getSuperTypes(String string, String string2, String string3) throws SQLServerException {
        this.checkClosed();
        return this.getResultSet("SELECT cast(NULL as char(1)) as TYPE_CAT, cast(NULL as char(1)) as TYPE_SCHEM, cast(NULL as char(1)) as TYPE_NAME, cast(NULL as char(1)) as SUPERTYPE_CAT, cast(NULL as char(1)) as SUPERTYPE_SCHEM, cast(NULL as char(1)) as SUPERTYPE_NAME where 0 = 1");
    }

    public boolean supportsGetGeneratedKeys() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsMultipleOpenResults() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    public boolean supportsNamedParameters() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsSavepoints() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsStatementPooling() throws SQLException {
        this.checkClosed();
        return false;
    }

    public boolean locatorsUpdateCopy() throws SQLException {
        this.checkClosed();
        return true;
    }
}

