/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.Util;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Properties;

public final class SQLServerDriver
implements Driver {
    static final String[] driverProperties = new String[]{"databaseName", "user", "password", "serverName", "portNumber", "disableStatementPooling", "integratedSecurity", "lockTimeout", "sendStringParametersAsUnicode", "lastUpdateCount", "applicationName", "selectMethod", "loginTimeout", "instanceName", "workstationID", "xopenStates", "failoverPartner", "packetSize", "responseBuffering"};
    static final String[][] driverPropertiesSynonyms = new String[][]{{"database", "databaseName"}, {"userName", "user"}, {"server", "serverName"}, {"port", "portNumber"}};

    static Properties fixupProperties(Properties properties) throws SQLServerException {
        Properties properties2 = new Properties();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = Util.normalizePropertyNames(string);
            if (null == string2) continue;
            String string3 = properties.getProperty(string);
            if (null != string3) {
                properties2.setProperty(string2, string3);
                continue;
            }
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidpropertyValue"));
            Object[] objectArray = new Object[]{string};
            throw new SQLServerException(null, messageFormat.format(objectArray), null, 0, false);
        }
        return properties2;
    }

    static Properties mergeURLAndSuppliedProperties(Properties properties, Properties properties2) throws SQLServerException {
        if (null == properties2) {
            return properties;
        }
        if (properties2.isEmpty()) {
            return properties;
        }
        Properties properties3 = SQLServerDriver.fixupProperties(properties2);
        for (int i2 = 0; i2 < driverProperties.length; ++i2) {
            String string = driverProperties[i2];
            String string2 = properties3.getProperty(string);
            if (null == string2) continue;
            properties.put(string, string2);
        }
        return properties;
    }

    public Connection connect(String string, Properties properties) throws SQLServerException {
        SQLServerConnection sQLServerConnection = null;
        Properties properties2 = this.parseAndMergeProperties(string, properties);
        if (properties2 == null) {
            return null;
        }
        sQLServerConnection = new SQLServerConnection();
        sQLServerConnection.sConnectURL = string;
        sQLServerConnection.connect(properties2, null);
        return sQLServerConnection;
    }

    private final Properties parseAndMergeProperties(String string, Properties properties) throws SQLServerException {
        if (string == null) {
            throw new SQLServerException(null, SQLServerException.getErrString("R_nullConnection"), null, 0, false);
        }
        Properties properties2 = Util.parseUrl(string);
        if (properties2 == null) {
            return null;
        }
        int n2 = DriverManager.getLoginTimeout();
        if (n2 > 0) {
            properties2.put("loginTimeout", new Integer(n2).toString());
        }
        properties2 = SQLServerDriver.mergeURLAndSuppliedProperties(properties2, properties);
        return properties2;
    }

    public boolean acceptsURL(String string) throws SQLServerException {
        boolean bl2 = false;
        try {
            bl2 = Util.parseUrl(string) != null;
        }
        catch (SQLServerException sQLServerException) {
            // empty catch block
        }
        return bl2;
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLServerException {
        DriverPropertyInfo driverPropertyInfo = null;
        int n2 = 0;
        Properties properties2 = this.parseAndMergeProperties(string, properties);
        if (null == properties2) {
            throw new SQLServerException(null, SQLServerException.getErrString("R_invalidConnection"), null, 0, false);
        }
        DriverPropertyInfo[] driverPropertyInfoArray = new DriverPropertyInfo[driverProperties.length];
        String string2 = properties2.getProperty("user");
        if (null == string2) {
            string2 = "";
        }
        driverPropertyInfo = new DriverPropertyInfo("user", string2);
        driverPropertyInfo.required = true;
        driverPropertyInfo.description = "User name";
        driverPropertyInfoArray[n2++] = driverPropertyInfo;
        driverPropertyInfo = new DriverPropertyInfo("password", "");
        driverPropertyInfo.required = true;
        driverPropertyInfo.description = "Password";
        driverPropertyInfoArray[n2++] = driverPropertyInfo;
        string2 = properties2.getProperty("databaseName");
        if (null == string2) {
            string2 = "";
        }
        driverPropertyInfo = new DriverPropertyInfo("databaseName", string2);
        driverPropertyInfo.required = false;
        driverPropertyInfo.description = "Database to connect to";
        driverPropertyInfoArray[n2++] = driverPropertyInfo;
        string2 = properties2.getProperty("serverName");
        if (null == string2) {
            string2 = "";
        }
        driverPropertyInfo = new DriverPropertyInfo("serverName", string2);
        driverPropertyInfo.required = false;
        driverPropertyInfo.description = "The host to connect to";
        driverPropertyInfoArray[n2++] = driverPropertyInfo;
        string2 = properties2.getProperty("portNumber");
        if (string2 == null) {
            string2 = "1433";
        }
        driverPropertyInfo = new DriverPropertyInfo("portNumber", string2);
        driverPropertyInfo.required = false;
        driverPropertyInfo.description = "The SQL Server port";
        driverPropertyInfoArray[n2++] = driverPropertyInfo;
        string2 = properties2.getProperty("sendStringParametersAsUnicode");
        if (string2 == null) {
            string2 = "true";
        }
        driverPropertyInfo = new DriverPropertyInfo("sendStringParametersAsUnicode", string2);
        driverPropertyInfo.required = false;
        driverPropertyInfo.description = "Send prepared string parameters as Unicode";
        driverPropertyInfoArray[n2++] = driverPropertyInfo;
        string2 = properties2.getProperty("applicationName");
        if (string2 == null) {
            string2 = "Microsoft SQL Server 2005 JDBC Driver";
        }
        driverPropertyInfo = new DriverPropertyInfo("applicationName", string2);
        driverPropertyInfo.required = false;
        driverPropertyInfo.description = "Set the application name for profiling";
        driverPropertyInfoArray[n2++] = driverPropertyInfo;
        string2 = properties2.getProperty("lastUpdateCount");
        if (string2 == null) {
            string2 = "true";
        }
        driverPropertyInfo = new DriverPropertyInfo("lastUpdateCount", string2);
        driverPropertyInfo.required = false;
        driverPropertyInfo.description = "Ensure that only the last update count from an update or insert is returned";
        driverPropertyInfoArray[n2++] = driverPropertyInfo;
        string2 = properties2.getProperty("disableStatementPooling");
        if (string2 == null) {
            string2 = "true";
        }
        driverPropertyInfo = new DriverPropertyInfo("disableStatementPooling", string2);
        driverPropertyInfo.required = false;
        driverPropertyInfo.description = "Disable statement pooling";
        driverPropertyInfoArray[n2++] = driverPropertyInfo;
        string2 = properties2.getProperty("integratedSecurity");
        if (string2 == null) {
            string2 = "false";
        }
        driverPropertyInfo = new DriverPropertyInfo("integratedSecurity", string2);
        driverPropertyInfo.required = false;
        driverPropertyInfo.description = "Integrated security";
        driverPropertyInfoArray[n2++] = driverPropertyInfo;
        string2 = properties2.getProperty("lockTimeout");
        if (string2 == null) {
            string2 = "-1";
        }
        driverPropertyInfo = new DriverPropertyInfo("lockTimeout", string2);
        driverPropertyInfo.required = false;
        driverPropertyInfo.description = "Set the lock timeout";
        driverPropertyInfoArray[n2++] = driverPropertyInfo;
        string2 = properties2.getProperty("loginTimeout");
        if (string2 == null) {
            string2 = "0";
        }
        driverPropertyInfo = new DriverPropertyInfo("loginTimeout", string2);
        driverPropertyInfo.required = false;
        driverPropertyInfo.description = "Set the login Timeout";
        driverPropertyInfoArray[n2++] = driverPropertyInfo;
        string2 = properties2.getProperty("instanceName");
        if (null == string2) {
            string2 = "";
        }
        driverPropertyInfo = new DriverPropertyInfo("instanceName", string2);
        driverPropertyInfo.required = false;
        driverPropertyInfo.description = "Set the Instance Name";
        driverPropertyInfoArray[n2++] = driverPropertyInfo;
        string2 = properties2.getProperty("xopenStates");
        if (string2 == null) {
            string2 = "false";
        }
        driverPropertyInfo = new DriverPropertyInfo("xopenStates", string2);
        driverPropertyInfo.required = false;
        driverPropertyInfo.description = "Set the SQLException state to XOPEN mode";
        driverPropertyInfoArray[n2++] = driverPropertyInfo;
        string2 = properties2.getProperty("selectMethod");
        if (string2 == null) {
            string2 = "direct";
        }
        driverPropertyInfo = new DriverPropertyInfo("selectMethod", string2);
        driverPropertyInfo.required = false;
        driverPropertyInfo.description = "Enable Serverside cursors";
        driverPropertyInfoArray[n2++] = driverPropertyInfo;
        string2 = properties2.getProperty("responseBuffering");
        if (string2 == null) {
            string2 = "full";
        }
        driverPropertyInfo = new DriverPropertyInfo("responseBuffering", string2);
        driverPropertyInfo.required = false;
        driverPropertyInfo.description = "Controls the buffering behavior";
        driverPropertyInfoArray[n2++] = driverPropertyInfo;
        string2 = properties2.getProperty("workstationID");
        if (string2 == null) {
            string2 = "WSID Not Available";
        }
        driverPropertyInfo = new DriverPropertyInfo("workstationID", string2);
        driverPropertyInfo.required = false;
        driverPropertyInfo.description = "Host name of the workstation";
        driverPropertyInfoArray[n2++] = driverPropertyInfo;
        string2 = properties2.getProperty("failoverPartner");
        if (null == string2) {
            string2 = "";
        }
        driverPropertyInfo = new DriverPropertyInfo("failoverPartner", string2);
        driverPropertyInfo.required = false;
        driverPropertyInfo.description = "Failover Partner Name";
        driverPropertyInfoArray[n2++] = driverPropertyInfo;
        string2 = properties2.getProperty("packetSize");
        if (string2 == null) {
            string2 = String.valueOf(8000);
        }
        driverPropertyInfo = new DriverPropertyInfo("packetSize", string2);
        driverPropertyInfo.required = false;
        driverPropertyInfo.description = "Network packet size";
        driverPropertyInfoArray[n2++] = driverPropertyInfo;
        return driverPropertyInfoArray;
    }

    public int getMajorVersion() {
        return Util.majorVersion();
    }

    public int getMinorVersion() {
        try {
            Integer n2 = new Integer(Util.minorVersion());
            return n2;
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public boolean jdbcCompliant() {
        return true;
    }

    static {
        try {
            DriverManager.registerDriver(new SQLServerDriver());
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }
}

