/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerConnectionPoolProxy;
import com.microsoft.sqlserver.jdbc.SQLServerDataSource;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;

public class SQLServerPooledConnection
implements PooledConnection {
    private Vector listeners;
    private SQLServerDataSource factoryDataSource;
    private SQLServerConnection physicalConnection;
    private SQLServerConnectionPoolProxy lastProxyConnection;
    private String factoryUser;
    private String factoryPassword;
    private Logger pcLogger;
    private static int basePooledConnectionID = 0;
    private final int pooledConnectionID = SQLServerPooledConnection.nextPooledConnectionID();

    SQLServerPooledConnection(SQLServerDataSource sQLServerDataSource, String string, String string2) throws SQLException {
        this.pcLogger = SQLServerDataSource.dsLogger;
        this.factoryDataSource = sQLServerDataSource;
        this.factoryUser = string;
        this.factoryPassword = string2;
        if (this.pcLogger.isLoggable(Level.FINE)) {
            this.pcLogger.fine(this.toLogString() + " Start create new connection for pool.");
        }
        this.physicalConnection = this.createNewConnection();
        this.listeners = new Vector();
        if (this.pcLogger.isLoggable(Level.FINE)) {
            this.pcLogger.fine(this.toLogString() + " End create new connection for pool, " + this.safeCID());
        }
    }

    String toLogString() {
        String string = " PooledConnectionID:" + this.pooledConnectionID;
        return string;
    }

    final int getRawLoggingID() {
        return this.pooledConnectionID;
    }

    private SQLServerConnection createNewConnection() throws SQLException {
        return this.factoryDataSource.getConnectionInternal(this.factoryUser, this.factoryPassword, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws SQLException {
        if (this.pcLogger.isLoggable(Level.FINE)) {
            this.pcLogger.fine(this.toLogString() + " user:(default).");
        }
        SQLServerPooledConnection sQLServerPooledConnection = this;
        synchronized (sQLServerPooledConnection) {
            if (this.physicalConnection == null) {
                throw new SQLException(SQLServerException.getErrString("R_physicalConnectionIsClosed"));
            }
            this.physicalConnection.getSecurityManager().checkConnect();
            if (this.pcLogger.isLoggable(Level.FINE)) {
                this.pcLogger.fine(this.toLogString() + " Physical connection, " + this.safeCID());
            }
            if (null != this.lastProxyConnection) {
                if (this.pcLogger.isLoggable(Level.FINE) && !this.lastProxyConnection.isClosed()) {
                    this.pcLogger.fine(this.toLogString() + "proxy " + this.lastProxyConnection.toLogString() + " is not closed before getting the connection.");
                }
                this.lastProxyConnection.internalClose();
            }
            this.lastProxyConnection = new SQLServerConnectionPoolProxy(this.physicalConnection);
            if (this.pcLogger.isLoggable(Level.FINE) && !this.lastProxyConnection.isClosed()) {
                this.pcLogger.fine(this.toLogString() + " proxy " + this.lastProxyConnection.toLogString() + " is returned.");
            }
            return this.lastProxyConnection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyEvent(SQLServerException sQLServerException) {
        Object object;
        if (this.pcLogger.isLoggable(Level.FINE)) {
            this.pcLogger.fine(this.toLogString() + " Exception:" + sQLServerException + this.safeCID());
        }
        if (null != sQLServerException) {
            object = this;
            synchronized (object) {
                if (null != this.lastProxyConnection) {
                    this.lastProxyConnection.internalClose();
                    this.lastProxyConnection = null;
                }
            }
        }
        object = this.listeners;
        synchronized (object) {
            for (int i2 = 0; i2 < this.listeners.size(); ++i2) {
                ConnectionEventListener connectionEventListener = (ConnectionEventListener)this.listeners.elementAt(i2);
                if (connectionEventListener == null) continue;
                ConnectionEvent connectionEvent = new ConnectionEvent(this, sQLServerException);
                if (null == sQLServerException) {
                    if (this.pcLogger.isLoggable(Level.FINE)) {
                        this.pcLogger.fine(this.toLogString() + " notifyEvent:connectionClosed " + this.safeCID());
                    }
                    connectionEventListener.connectionClosed(connectionEvent);
                    continue;
                }
                if (this.pcLogger.isLoggable(Level.FINE)) {
                    this.pcLogger.fine(this.toLogString() + " notifyEvent:connectionErrorOccurred " + this.safeCID());
                }
                connectionEventListener.connectionErrorOccurred(connectionEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (this.pcLogger.isLoggable(Level.FINE)) {
            this.pcLogger.fine(this.toLogString() + this.safeCID());
        }
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.add(connectionEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        if (this.pcLogger.isLoggable(Level.FINE)) {
            this.pcLogger.fine(this.toLogString() + " Closing physical connection, " + this.safeCID());
        }
        Object object = this;
        synchronized (object) {
            if (null != this.lastProxyConnection) {
                this.lastProxyConnection.internalClose();
            }
            if (null != this.physicalConnection) {
                this.physicalConnection.DetachFromPool();
                this.physicalConnection.close();
            }
            this.physicalConnection = null;
        }
        object = this.listeners;
        synchronized (object) {
            this.listeners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (this.pcLogger.isLoggable(Level.FINE)) {
            this.pcLogger.fine(this.toLogString() + this.safeCID());
        }
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.remove(connectionEventListener);
        }
    }

    Connection getPhysicalConnection() {
        return this.physicalConnection;
    }

    private static synchronized int nextPooledConnectionID() {
        return ++basePooledConnectionID;
    }

    private String safeCID() {
        if (null == this.physicalConnection) {
            return " ConnectionID:(null)";
        }
        return this.physicalConnection.toLogString();
    }
}

