/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.CharacterStreamSetterArgs;
import com.microsoft.sqlserver.jdbc.Column;
import com.microsoft.sqlserver.jdbc.ColumnFilter;
import com.microsoft.sqlserver.jdbc.DataTypes;
import com.microsoft.sqlserver.jdbc.InputStreamGetterArgs;
import com.microsoft.sqlserver.jdbc.InputStreamSetterArgs;
import com.microsoft.sqlserver.jdbc.SQLServerClob;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerParameterMetaData;
import com.microsoft.sqlserver.jdbc.SQLServerResultSet;
import com.microsoft.sqlserver.jdbc.SQLServerResultSetMetaData;
import com.microsoft.sqlserver.jdbc.SQLServerStatement;
import com.microsoft.sqlserver.jdbc.ScrollWindow;
import com.microsoft.sqlserver.jdbc.StreamColumns;
import com.microsoft.sqlserver.jdbc.StreamRetStatus;
import com.microsoft.sqlserver.jdbc.TDSCommand;
import com.microsoft.sqlserver.jdbc.TDSParser;
import com.microsoft.sqlserver.jdbc.TDSReader;
import com.microsoft.sqlserver.jdbc.TDSReaderMark;
import com.microsoft.sqlserver.jdbc.TDSTokenHandler;
import com.microsoft.sqlserver.jdbc.TDSWriter;
import com.microsoft.sqlserver.jdbc.TypeInfo;
import com.microsoft.sqlserver.jdbc.UninterruptableTDSCommand;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SQLServerResultSet
implements ResultSet {
    public static final int TYPE_SS_DIRECT_FORWARD_ONLY = 2003;
    public static final int TYPE_SS_SERVER_CURSOR_FORWARD_ONLY = 2004;
    public static final int TYPE_SS_SCROLL_STATIC = 1004;
    public static final int TYPE_SS_SCROLL_KEYSET = 1005;
    public static final int TYPE_SS_SCROLL_DYNAMIC = 1006;
    public static final int CONCUR_SS_OPTIMISTIC_CC = 1008;
    public static final int CONCUR_SS_SCROLL_LOCKS = 1009;
    public static final int CONCUR_SS_OPTIMISTIC_CCVAL = 1010;
    private final int resultSetID;
    private static int lastResultSetID;
    static Logger logger;
    SQLServerStatement stmt;
    private final int maxRows;
    private final boolean wasResponseBufferingSetOnStatement;
    private final boolean isAdaptive;
    private ResultSetMetaData metaData;
    private boolean isClosed = false;
    private final int serverCursorId;
    private String cursorTableName;
    private int fetchDirection;
    private int fetchSize;
    private boolean isOnInsertRow = false;
    private boolean lastValueWasNull = false;
    private int lastColumnIndex;
    private Object activeStream;
    private final ScrollWindow scrollWindow;
    private static final int BEFORE_FIRST_ROW = 0;
    private static final int AFTER_LAST_ROW = -1;
    private static final int UNKNOWN_ROW = -2;
    private int currentRow = 0;
    private boolean updatedCurrentRow = false;
    private boolean deletedCurrentRow = false;
    private static final int UNKNOWN_ROW_COUNT = -3;
    private int rowCount;
    private final Column[] columns;
    private TDSReader tdsReader;
    private TDSReaderMark fetchBufferStart = null;
    private int numFetchedRows;
    private final FetchHandler fetchHandler = new FetchHandler("FetchHandler");
    static final /* synthetic */ boolean $assertionsDisabled;

    private static synchronized int nextResultSetID() {
        return ++lastResultSetID;
    }

    String toLogString() {
        return "ResultSet ID:" + this.resultSetID + " (" + this.stmt.connection.toLogString() + ")";
    }

    String logCursorState() {
        return " currentRow:" + this.currentRow + " numFetchedRows:" + this.numFetchedRows + " rowCount:" + this.rowCount;
    }

    final boolean getUpdatedCurrentRow() {
        return this.updatedCurrentRow;
    }

    final void setUpdatedCurrentRow(boolean bl2) {
        this.updatedCurrentRow = bl2;
    }

    final boolean getDeletedCurrentRow() {
        return this.deletedCurrentRow;
    }

    final void setDeletedCurrentRow(boolean bl2) {
        this.deletedCurrentRow = bl2;
    }

    final void setColumnName(int n2, String string) {
        this.columns[n2 - 1].name = string;
    }

    private final void skipColumns(int n2, boolean bl2) throws SQLServerException {
        if (!$assertionsDisabled && this.lastColumnIndex < 1) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || 0 <= n2 && n2 <= this.columns.length)) {
            throw new AssertionError();
        }
        this.closeActiveStream();
        for (int i2 = 0; i2 < n2; ++i2) {
            Column column = this.getColumn(this.lastColumnIndex++);
            column.skipValue(this.tdsReader, bl2 && this.isForwardOnly());
            if (!bl2) continue;
            column.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeActiveStream() throws SQLServerException {
        if (null != this.activeStream) {
            try {
                if (this.activeStream instanceof InputStream) {
                    ((InputStream)this.activeStream).close();
                } else if (this.activeStream instanceof Reader) {
                    ((Reader)this.activeStream).close();
                } else if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
            catch (IOException iOException) {
                SQLServerException.makeFromDriverError(null, null, iOException.getMessage(), null, true);
            }
            finally {
                this.activeStream = null;
            }
        }
    }

    SQLServerResultSet(SQLServerStatement sQLServerStatement, Column[] columnArray, int n2, int n3) {
        this.resultSetID = SQLServerResultSet.nextResultSetID();
        this.stmt = sQLServerStatement;
        this.maxRows = sQLServerStatement.maxRows;
        this.tdsReader = sQLServerStatement.tdsReader;
        this.fetchSize = sQLServerStatement.nFetchSize;
        this.fetchDirection = sQLServerStatement.nFetchDirection;
        this.wasResponseBufferingSetOnStatement = sQLServerStatement.wasResponseBufferingSet();
        this.isAdaptive = sQLServerStatement.getIsResponseBufferingAdaptive();
        this.columns = columnArray;
        this.serverCursorId = n2;
        this.scrollWindow = this.isForwardOnly() ? null : new ScrollWindow(this.fetchSize);
        this.fetchBufferStart = this.isForwardOnly() ? null : this.tdsReader.mark();
        this.rowCount = -1 != n3 ? n3 : -3;
        this.numFetchedRows = 0;
    }

    void checkClosed() throws SQLServerException {
        if (this.isClosed) {
            SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_resultsetClosed"), null, false);
        }
        this.stmt.checkClosed();
    }

    private final void throwNotScrollable() throws SQLServerException {
        SQLServerException.makeFromDriverError(this.stmt.connection, this, SQLServerException.getErrString("R_requestedOpNotSupportedOnForward"), null, true);
    }

    private final boolean isForwardOnly() {
        return 2003 == this.stmt.getSQLResultSetType() || 2004 == this.stmt.getSQLResultSetType();
    }

    private final boolean isDynamic() {
        return 0 != this.serverCursorId && 2 == this.stmt.getCursorType();
    }

    private final void verifyResultSetIsScrollable() throws SQLServerException {
        if (this.isForwardOnly()) {
            this.throwNotScrollable();
        }
    }

    private final void throwNotUpdatable() throws SQLServerException {
        SQLServerException.makeFromDriverError(this.stmt.connection, this, SQLServerException.getErrString("R_resultsetNotUpdatable"), null, true);
    }

    private final void verifyResultSetIsUpdatable() throws SQLServerException {
        if (1007 == this.stmt.resultSetConcurrency || 0 == this.serverCursorId) {
            this.throwNotUpdatable();
        }
    }

    private boolean hasCurrentRow() {
        return 0 != this.currentRow && -1 != this.currentRow;
    }

    private void verifyResultSetHasCurrentRow() throws SQLServerException {
        if (!this.hasCurrentRow()) {
            SQLServerException.makeFromDriverError(this.stmt.connection, this.stmt, SQLServerException.getErrString("R_resultsetNoCurrentRow"), null, true);
        }
    }

    private void verifyCurrentRowIsNotDeleted(String string) throws SQLServerException {
        if (this.currentRowDeleted()) {
            SQLServerException.makeFromDriverError(this.stmt.connection, this.stmt, SQLServerException.getErrString(string), null, true);
        }
    }

    private void verifyValidColumnIndex(int n2) throws SQLServerException {
        int n3 = this.columns.length;
        if (0 != this.serverCursorId) {
            --n3;
        }
        if (n2 < 1 || n2 > n3) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_indexOutOfRange"));
            Object[] objectArray = new Object[]{new Integer(n2)};
            SQLServerException.makeFromDriverError(this.stmt.connection, this.stmt, messageFormat.format(objectArray), "07009", false);
        }
    }

    private void verifyResultSetIsNotOnInsertRow() throws SQLServerException {
        if (this.isOnInsertRow) {
            SQLServerException.makeFromDriverError(this.stmt.connection, this.stmt, SQLServerException.getErrString("R_mustNotBeOnInsertRow"), null, true);
        }
    }

    private final void throwUnsupportedCursorOp() throws SQLServerException {
        SQLServerException.makeFromDriverError(this.stmt.connection, this, SQLServerException.getErrString("R_unsupportedCursorOperation"), null, true);
    }

    public void close() throws SQLServerException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.toLogString());
        }
        if (this.isClosed) {
            return;
        }
        if (null != this.scrollWindow) {
            while (this.scrollWindow.next(this)) {
            }
            this.scrollWindow.clear();
        }
        while (this.fetchBufferNext()) {
        }
        this.metaData = null;
        this.isClosed = true;
        if (0 != this.serverCursorId) {
            this.closeServerCursor();
        }
    }

    public int findColumn(String string) throws SQLServerException {
        int n2;
        this.checkClosed();
        for (n2 = 0; n2 < this.columns.length; ++n2) {
            if (!this.columns[n2].name.equals(string)) continue;
            return n2 + 1;
        }
        for (n2 = 0; n2 < this.columns.length; ++n2) {
            if (!this.columns[n2].name.equalsIgnoreCase(string)) continue;
            return n2 + 1;
        }
        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidColumnName"));
        Object[] objectArray = new Object[]{string};
        SQLServerException.makeFromDriverError(this.stmt.connection, this.stmt, messageFormat.format(objectArray), "07009", false);
        return 0;
    }

    final int getColumnCount() {
        int n2 = this.columns.length;
        if (0 != this.serverCursorId) {
            --n2;
        }
        return n2;
    }

    final void setFilter(int n2, ColumnFilter columnFilter) throws SQLServerException {
        this.getColumn(n2).setFilter(columnFilter);
    }

    final TypeInfo getTypeInfo(int n2) throws SQLServerException {
        return this.getColumn(n2).getTypeInfo();
    }

    private final Column getColumn(int n2) throws SQLServerException {
        return this.columns[n2 - 1];
    }

    final String getTableName(int n2) throws SQLServerException {
        return this.getColumn((int)n2).tableName;
    }

    final String getColumnName(int n2) throws SQLServerException {
        return this.getColumn((int)n2).name;
    }

    private final Column loadColumn(int n2) throws SQLServerException {
        if (!($assertionsDisabled || 1 <= n2 && n2 <= this.columns.length)) {
            throw new AssertionError();
        }
        if (n2 > this.lastColumnIndex) {
            this.skipColumns(n2 - this.lastColumnIndex, false);
        }
        return this.getColumn(n2);
    }

    private void NotImplemented() throws SQLServerException {
        SQLServerException.makeFromDriverError(this.stmt.connection, this.stmt, SQLServerException.getErrString("R_notSupported"), null, false);
    }

    public void clearWarnings() throws SQLServerException {
    }

    private void moverInit() throws SQLServerException {
        this.closeActiveStream();
        this.cancelInsert();
        this.cancelUpdates();
    }

    public boolean relative(int n2) throws SQLServerException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.toLogString() + " rows:" + n2 + this.logCursorState());
        }
        this.checkClosed();
        this.verifyResultSetIsScrollable();
        this.verifyResultSetHasCurrentRow();
        this.moverInit();
        this.moveRelative(n2);
        return this.hasCurrentRow();
    }

    private final void moveRelative(int n2) throws SQLServerException {
        if (!$assertionsDisabled && !this.hasCurrentRow()) {
            throw new AssertionError();
        }
        if (0 == n2) {
            return;
        }
        if (n2 > 0) {
            this.moveForward(n2);
        } else {
            this.moveBackward(n2);
        }
    }

    private final void moveForward(int n2) throws SQLServerException {
        if (!$assertionsDisabled && !this.hasCurrentRow()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && n2 <= 0) {
            throw new AssertionError();
        }
        if (this.scrollWindow.getRow() + n2 <= this.scrollWindow.getMaxRows()) {
            int n3 = 0;
            while (n2 > 0 && this.scrollWindow.next(this)) {
                ++n3;
                --n2;
            }
            if (-2 != this.currentRow) {
                this.currentRow += n3;
            }
            if (0 == n2) {
                return;
            }
        }
        if (!$assertionsDisabled && n2 <= 0) {
            throw new AssertionError();
        }
        if (0 == this.serverCursorId) {
            this.currentRow = this.clientMoveAbsolute(this.currentRow + n2);
            return;
        }
        if (1 == n2) {
            this.doServerFetch(2, 0, this.fetchSize);
        } else {
            this.doServerFetch(32, n2 + this.scrollWindow.getRow() - 1, this.fetchSize);
        }
        if (!this.scrollWindow.next(this)) {
            this.currentRow = -1;
            return;
        }
        if (-2 != this.currentRow) {
            this.currentRow += n2;
        }
    }

    private final void moveBackward(int n2) throws SQLServerException {
        if (!$assertionsDisabled && !this.hasCurrentRow()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && n2 >= 0) {
            throw new AssertionError();
        }
        if (this.scrollWindow.getRow() + n2 >= 1) {
            for (int i2 = 0; i2 > n2; --i2) {
                this.scrollWindow.previous(this);
            }
            if (-2 != this.currentRow) {
                this.currentRow += n2;
            }
            return;
        }
        if (0 == this.serverCursorId) {
            if (this.currentRow + n2 < 1) {
                this.moveBeforeFirst();
            } else {
                this.currentRow = this.clientMoveAbsolute(this.currentRow + n2);
            }
            return;
        }
        if (-1 == n2) {
            this.doServerFetch(512, 0, this.fetchSize);
            if (!this.scrollWindow.next(this)) {
                this.currentRow = 0;
                return;
            }
            while (this.scrollWindow.next(this)) {
            }
            this.scrollWindow.previous(this);
        } else {
            this.doServerFetch(32, n2 + this.scrollWindow.getRow() - 1, this.fetchSize);
            if (!this.scrollWindow.next(this)) {
                this.currentRow = 0;
                return;
            }
        }
        if (-2 != this.currentRow) {
            this.currentRow += n2;
        }
    }

    public boolean next() throws SQLServerException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.toLogString() + this.logCursorState());
        }
        this.checkClosed();
        this.moverInit();
        if (-1 == this.currentRow) {
            return false;
        }
        if (!this.isForwardOnly()) {
            if (0 == this.currentRow) {
                this.moveFirst();
            } else {
                this.moveForward(1);
            }
            return this.hasCurrentRow();
        }
        if (0 != this.serverCursorId && this.maxRows > 0 && this.currentRow == this.maxRows) {
            this.currentRow = -1;
            return false;
        }
        if (this.fetchBufferNext()) {
            this.currentRow = 0 == this.currentRow ? 1 : ++this.currentRow;
            if (!$assertionsDisabled && 0 != this.maxRows && this.currentRow > this.maxRows) {
                throw new AssertionError();
            }
            return true;
        }
        if (0 != this.serverCursorId) {
            this.doServerFetch(2, 0, this.fetchSize);
            if (this.fetchBufferNext()) {
                this.currentRow = 0 == this.currentRow ? 1 : ++this.currentRow;
                if (!$assertionsDisabled && 0 != this.maxRows && this.currentRow > this.maxRows) {
                    throw new AssertionError();
                }
                return true;
            }
        }
        if (-3 == this.rowCount) {
            this.rowCount = this.currentRow;
        }
        this.currentRow = -1;
        return false;
    }

    public boolean wasNull() throws SQLServerException {
        this.checkClosed();
        return this.lastValueWasNull;
    }

    public boolean isBeforeFirst() throws SQLServerException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.toLogString() + this.logCursorState());
        }
        this.checkClosed();
        if (0 != this.serverCursorId) {
            switch (this.stmt.getCursorType()) {
                case 4: {
                    this.throwNotScrollable();
                }
                case 2: {
                    this.throwUnsupportedCursorOp();
                }
                case 16: {
                    this.throwNotScrollable();
                }
            }
        }
        if (this.isOnInsertRow) {
            return false;
        }
        if (0 != this.currentRow) {
            return false;
        }
        if (0 == this.serverCursorId) {
            return this.fetchBufferHasRows();
        }
        if (!$assertionsDisabled && this.rowCount < 0) {
            throw new AssertionError();
        }
        return this.rowCount > 0;
    }

    public boolean isAfterLast() throws SQLServerException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.toLogString() + this.logCursorState());
        }
        this.checkClosed();
        if (0 != this.serverCursorId) {
            this.verifyResultSetIsScrollable();
            if (2 == this.stmt.getCursorType() && !this.isForwardOnly()) {
                this.throwUnsupportedCursorOp();
            }
        }
        if (this.isOnInsertRow) {
            return false;
        }
        if (!$assertionsDisabled && -1 == this.currentRow && -3 == this.rowCount) {
            throw new AssertionError();
        }
        return -1 == this.currentRow && this.rowCount > 0;
    }

    public boolean isFirst() throws SQLServerException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.toLogString() + this.logCursorState());
        }
        this.checkClosed();
        this.verifyResultSetIsScrollable();
        if (this.isDynamic()) {
            this.throwUnsupportedCursorOp();
        }
        if (this.isOnInsertRow) {
            return false;
        }
        if (!$assertionsDisabled && -2 == this.currentRow) {
            throw new AssertionError();
        }
        return 1 == this.currentRow;
    }

    public boolean isLast() throws SQLServerException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.toLogString() + this.logCursorState());
        }
        this.checkClosed();
        this.verifyResultSetIsScrollable();
        if (this.isDynamic()) {
            this.throwUnsupportedCursorOp();
        }
        if (this.isOnInsertRow) {
            return false;
        }
        if (!this.hasCurrentRow()) {
            return false;
        }
        if (!$assertionsDisabled && this.currentRow < 1) {
            throw new AssertionError();
        }
        if (-3 != this.rowCount) {
            if (!$assertionsDisabled && this.currentRow > this.rowCount) {
                throw new AssertionError();
            }
            return this.currentRow == this.rowCount;
        }
        if (!$assertionsDisabled && 0 != this.serverCursorId) {
            throw new AssertionError();
        }
        boolean bl2 = !this.next();
        this.previous();
        return bl2;
    }

    public void beforeFirst() throws SQLServerException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.toLogString() + this.logCursorState());
        }
        this.checkClosed();
        this.verifyResultSetIsScrollable();
        this.moverInit();
        this.moveBeforeFirst();
    }

    private final void moveBeforeFirst() throws SQLServerException {
        if (0 == this.serverCursorId) {
            this.fetchBufferBeforeFirst();
            this.scrollWindow.clear();
        } else {
            this.doServerFetch(1, 0, 0);
        }
        this.currentRow = 0;
    }

    public void afterLast() throws SQLServerException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.toLogString() + this.logCursorState());
        }
        this.checkClosed();
        this.verifyResultSetIsScrollable();
        this.moverInit();
        this.moveAfterLast();
    }

    private void moveAfterLast() throws SQLServerException {
        if (!$assertionsDisabled && this.isForwardOnly()) {
            throw new AssertionError();
        }
        if (0 == this.serverCursorId) {
            this.clientMoveAfterLast();
        } else {
            this.doServerFetch(8, 0, 0);
        }
        this.currentRow = -1;
    }

    public boolean first() throws SQLServerException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.toLogString() + this.logCursorState());
        }
        this.checkClosed();
        this.verifyResultSetIsScrollable();
        this.moverInit();
        this.moveFirst();
        return this.hasCurrentRow();
    }

    private final void moveFirst() throws SQLServerException {
        if (0 == this.serverCursorId) {
            this.moveBeforeFirst();
        } else {
            this.doServerFetch(1, 0, this.fetchSize);
        }
        if (!this.scrollWindow.next(this)) {
            this.currentRow = -1;
            return;
        }
        this.currentRow = this.isDynamic() ? -2 : 1;
    }

    public boolean last() throws SQLServerException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.toLogString() + this.logCursorState());
        }
        this.checkClosed();
        this.verifyResultSetIsScrollable();
        this.moverInit();
        this.moveLast();
        return this.hasCurrentRow();
    }

    private final void moveLast() throws SQLServerException {
        if (0 == this.serverCursorId) {
            this.currentRow = this.clientMoveAbsolute(-1);
            return;
        }
        this.doServerFetch(8, 0, this.fetchSize);
        if (!this.scrollWindow.next(this)) {
            this.currentRow = -1;
            return;
        }
        while (this.scrollWindow.next(this)) {
        }
        this.scrollWindow.previous(this);
        this.currentRow = this.isDynamic() ? -2 : this.rowCount;
    }

    public int getRow() throws SQLServerException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.toLogString() + this.logCursorState());
        }
        this.checkClosed();
        if (this.isDynamic() && !this.isForwardOnly()) {
            this.throwUnsupportedCursorOp();
        }
        if (!this.hasCurrentRow() || this.isOnInsertRow) {
            return 0;
        }
        if (!$assertionsDisabled && this.currentRow < 1) {
            throw new AssertionError();
        }
        return this.currentRow;
    }

    public boolean absolute(int n2) throws SQLServerException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.toLogString() + " row:" + n2 + this.logCursorState());
        }
        this.checkClosed();
        this.verifyResultSetIsScrollable();
        if (this.isDynamic()) {
            this.throwUnsupportedCursorOp();
        }
        this.moverInit();
        this.moveAbsolute(n2);
        return this.hasCurrentRow();
    }

    private void moveAbsolute(int n2) throws SQLServerException {
        if (!$assertionsDisabled && -2 == this.currentRow) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.isDynamic()) {
            throw new AssertionError();
        }
        switch (n2) {
            case 0: {
                this.moveBeforeFirst();
                return;
            }
            case 1: {
                this.moveFirst();
                return;
            }
            case -1: {
                this.moveLast();
                return;
            }
        }
        if (this.hasCurrentRow() && -2 != this.currentRow) {
            if (!$assertionsDisabled && this.currentRow < 1) {
                throw new AssertionError();
            }
            if (n2 > 0) {
                this.moveRelative(n2 - this.currentRow);
                return;
            }
            if (-3 != this.rowCount) {
                if (!$assertionsDisabled && n2 >= 0) {
                    throw new AssertionError();
                }
                this.moveRelative(this.rowCount + n2 + 1 - this.currentRow);
                return;
            }
        }
        if (0 == this.serverCursorId) {
            this.currentRow = this.clientMoveAbsolute(n2);
            return;
        }
        this.doServerFetch(16, n2, this.fetchSize);
        if (!this.scrollWindow.next(this)) {
            this.currentRow = n2 < 0 ? 0 : -1;
            return;
        }
        if (n2 > 0) {
            this.currentRow = n2;
        } else {
            if (!$assertionsDisabled && n2 >= 0) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.rowCount <= 0) {
                throw new AssertionError();
            }
            this.currentRow = this.rowCount + n2 + 1;
        }
    }

    private final boolean fetchBufferHasRows() throws SQLServerException {
        if (!$assertionsDisabled && this.lastColumnIndex < 0) {
            throw new AssertionError();
        }
        if (this.lastColumnIndex >= 1) {
            return true;
        }
        int n2 = this.tdsReader.peekTokenType();
        return 209 == n2 || 171 == n2 || 170 == n2;
    }

    final void discardCurrentRow() throws SQLServerException {
        if (!$assertionsDisabled && this.lastColumnIndex < 0) {
            throw new AssertionError();
        }
        this.updatedCurrentRow = false;
        this.deletedCurrentRow = false;
        if (this.lastColumnIndex >= 1) {
            for (int i2 = 1; i2 < this.lastColumnIndex; ++i2) {
                this.getColumn(i2).clear();
            }
            this.skipColumns(this.columns.length + 1 - this.lastColumnIndex, true);
        }
    }

    final int fetchBufferGetRow() {
        if (this.isForwardOnly()) {
            return this.numFetchedRows;
        }
        return this.scrollWindow.getRow();
    }

    final void fetchBufferBeforeFirst() throws SQLServerException {
        this.discardCurrentRow();
        if (!$assertionsDisabled && null == this.fetchBufferStart) {
            throw new AssertionError();
        }
        this.tdsReader.reset(this.fetchBufferStart);
        this.lastColumnIndex = 0;
    }

    final TDSReaderMark fetchBufferMark() {
        return this.tdsReader.mark();
    }

    final void fetchBufferReset(TDSReaderMark tDSReaderMark) throws SQLServerException {
        if (!$assertionsDisabled && null == tDSReaderMark) {
            throw new AssertionError();
        }
        this.discardCurrentRow();
        this.tdsReader.reset(tDSReaderMark);
        this.lastColumnIndex = 1;
    }

    final boolean fetchBufferNext() throws SQLServerException {
        this.discardCurrentRow();
        this.fetchHandler.reset();
        TDSParser.parse(this.tdsReader, this.fetchHandler);
        if (!this.fetchHandler.foundRow()) {
            this.lastColumnIndex = 0;
            return false;
        }
        ++this.numFetchedRows;
        this.lastColumnIndex = 1;
        return true;
    }

    private final void clientMoveAfterLast() throws SQLServerException {
        if (!$assertionsDisabled && -2 == this.currentRow) {
            throw new AssertionError();
        }
        int n2 = 0;
        while (this.fetchBufferNext()) {
            ++n2;
        }
        if (-3 == this.rowCount) {
            if (!$assertionsDisabled && -1 == this.currentRow) {
                throw new AssertionError();
            }
            this.rowCount = (0 == this.currentRow ? 0 : this.currentRow) + n2;
        }
    }

    private final int clientMoveAbsolute(int n2) throws SQLServerException {
        if (!$assertionsDisabled && 0 != this.serverCursorId) {
            throw new AssertionError();
        }
        this.scrollWindow.clear();
        if (n2 < 0) {
            if (-3 == this.rowCount) {
                this.clientMoveAfterLast();
                this.currentRow = -1;
            }
            if (!$assertionsDisabled && this.rowCount < 0) {
                throw new AssertionError();
            }
            if (this.rowCount + n2 < 0) {
                this.moveBeforeFirst();
                return 0;
            }
            n2 = this.rowCount + n2 + 1;
        }
        if (!$assertionsDisabled && n2 <= 0) {
            throw new AssertionError();
        }
        if (-1 == this.currentRow || n2 <= this.currentRow) {
            this.moveBeforeFirst();
        }
        if (!$assertionsDisabled && 0 != this.currentRow && this.currentRow >= n2) {
            throw new AssertionError();
        }
        while (this.currentRow != n2) {
            if (!this.fetchBufferNext()) {
                if (-3 == this.rowCount) {
                    this.rowCount = this.currentRow;
                }
                return -1;
            }
            if (0 == this.currentRow) {
                this.currentRow = 1;
                continue;
            }
            ++this.currentRow;
        }
        return n2;
    }

    public boolean previous() throws SQLServerException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.toLogString() + this.logCursorState());
        }
        this.checkClosed();
        this.verifyResultSetIsScrollable();
        this.moverInit();
        if (0 == this.currentRow) {
            return false;
        }
        if (-1 == this.currentRow) {
            this.moveLast();
        } else {
            this.moveBackward(-1);
        }
        return this.hasCurrentRow();
    }

    private final void cancelInsert() {
        if (this.isOnInsertRow) {
            this.isOnInsertRow = false;
            this.clearColumnsValues();
        }
    }

    final void clearColumnsValues() {
        int n2 = this.columns.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.columns[i2].cancelUpdates();
        }
    }

    public SQLWarning getWarnings() throws SQLServerException {
        return null;
    }

    public void setFetchDirection(int n2) throws SQLServerException {
        this.checkClosed();
        this.verifyResultSetIsScrollable();
        if (1000 != n2 && 1001 != n2 && 1002 != n2 || 1000 != n2 && (2003 == this.stmt.resultSetType || 2004 == this.stmt.resultSetType)) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidFetchDirection"));
            Object[] objectArray = new Object[]{new Integer(n2)};
            SQLServerException.makeFromDriverError(this.stmt.connection, this.stmt, messageFormat.format(objectArray), null, false);
        }
        this.fetchDirection = n2;
    }

    public int getFetchDirection() throws SQLServerException {
        this.checkClosed();
        return this.fetchDirection;
    }

    public void setFetchSize(int n2) throws SQLServerException {
        this.checkClosed();
        if (n2 < 0) {
            SQLServerException.makeFromDriverError(this.stmt.connection, this.stmt, SQLServerException.getErrString("R_invalidFetchSize"), null, false);
        }
        this.fetchSize = 0 == n2 ? this.stmt.defaultFetchSize : n2;
    }

    public int getFetchSize() throws SQLServerException {
        this.checkClosed();
        return this.fetchSize;
    }

    public int getType() throws SQLServerException {
        this.checkClosed();
        return this.stmt.getResultSetType();
    }

    public int getConcurrency() throws SQLServerException {
        this.checkClosed();
        return this.stmt.getResultSetConcurrency();
    }

    private Column getterGetColumn(int n2) throws SQLServerException {
        this.checkClosed();
        this.closeActiveStream();
        this.verifyResultSetHasCurrentRow();
        this.verifyCurrentRowIsNotDeleted("R_cantGetColumnValueFromDeletedRow");
        this.verifyValidColumnIndex(n2);
        if (this.updatedCurrentRow) {
            this.doRefreshRow();
            this.verifyResultSetHasCurrentRow();
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.fine(this.toLogString() + " Getting Column:" + n2);
        }
        return this.loadColumn(n2);
    }

    public InputStream getAsciiStream(int n2) throws SQLServerException {
        Column column = this.getterGetColumn(n2);
        column.checkGetAsciiStream();
        InputStream inputStream = (InputStream)column.getValue(1, new InputStreamGetterArgs(3, this.isAdaptive, this.isForwardOnly(), this.toLogString()), null, this.tdsReader);
        this.activeStream = inputStream;
        this.lastValueWasNull = null == inputStream;
        return inputStream;
    }

    public InputStream getAsciiStream(String string) throws SQLServerException {
        return this.getAsciiStream(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(int n2, int n3) throws SQLServerException {
        BigDecimal bigDecimal = ((BigDecimal)this.getterGetColumn(n2).getValue(3, this.tdsReader)).setScale(n3, 1);
        this.lastValueWasNull = null == bigDecimal;
        return bigDecimal;
    }

    public BigDecimal getBigDecimal(String string, int n2) throws SQLServerException {
        return this.getBigDecimal(this.findColumn(string), n2);
    }

    public InputStream getBinaryStream(int n2) throws SQLServerException {
        Column column = this.getterGetColumn(n2);
        column.checkGetBinaryStream();
        InputStream inputStream = (InputStream)column.getValue(-4, new InputStreamGetterArgs(1, this.isAdaptive, this.isForwardOnly(), this.toLogString()), null, this.tdsReader);
        this.activeStream = inputStream;
        this.lastValueWasNull = null == inputStream;
        return inputStream;
    }

    public InputStream getBinaryStream(String string) throws SQLServerException {
        return this.getBinaryStream(this.findColumn(string));
    }

    public boolean getBoolean(int n2) throws SQLServerException {
        Object object = this.getterGetColumn(n2).getValue(-7, this.tdsReader);
        boolean bl2 = this.lastValueWasNull = null == object;
        if (this.lastValueWasNull) {
            return false;
        }
        return (Boolean)object;
    }

    public boolean getBoolean(String string) throws SQLServerException {
        return this.getBoolean(this.findColumn(string));
    }

    public byte getByte(int n2) throws SQLServerException {
        Column column = this.getterGetColumn(n2);
        byte by = column.getByte(this.tdsReader);
        this.lastValueWasNull = column.isNull();
        return by;
    }

    public byte getByte(String string) throws SQLServerException {
        return this.getByte(this.findColumn(string));
    }

    public byte[] getBytes(int n2) throws SQLServerException {
        byte[] byArray = (byte[])this.getterGetColumn(n2).getValue(-2, this.tdsReader);
        this.lastValueWasNull = null == byArray;
        return byArray;
    }

    public byte[] getBytes(String string) throws SQLServerException {
        return this.getBytes(this.findColumn(string));
    }

    public Date getDate(int n2) throws SQLServerException {
        return this.getDate(n2, null);
    }

    public Date getDate(String string) throws SQLServerException {
        return this.getDate(this.findColumn(string), null);
    }

    public Date getDate(int n2, Calendar calendar) throws SQLServerException {
        Date date = (Date)this.getterGetColumn(n2).getValue(91, calendar, this.tdsReader);
        this.lastValueWasNull = null == date;
        return date;
    }

    public Date getDate(String string, Calendar calendar) throws SQLServerException {
        return this.getDate(this.findColumn(string), calendar);
    }

    public double getDouble(int n2) throws SQLServerException {
        Object object = this.getterGetColumn(n2).getValue(8, this.tdsReader);
        boolean bl2 = this.lastValueWasNull = null == object;
        if (this.lastValueWasNull) {
            return 0.0;
        }
        return (Double)object;
    }

    public double getDouble(String string) throws SQLServerException {
        return this.getDouble(this.findColumn(string));
    }

    public float getFloat(int n2) throws SQLServerException {
        Object object = this.getterGetColumn(n2).getValue(6, this.tdsReader);
        boolean bl2 = this.lastValueWasNull = null == object;
        if (this.lastValueWasNull) {
            return 0.0f;
        }
        return ((Float)object).floatValue();
    }

    public float getFloat(String string) throws SQLServerException {
        return this.getFloat(this.findColumn(string));
    }

    public int getInt(int n2) throws SQLServerException {
        Column column = this.getterGetColumn(n2);
        int n3 = column.getInt(this.tdsReader);
        this.lastValueWasNull = column.isNull();
        return n3;
    }

    public int getInt(String string) throws SQLServerException {
        return this.getInt(this.findColumn(string));
    }

    public long getLong(int n2) throws SQLServerException {
        Object object = this.getterGetColumn(n2).getValue(-5, this.tdsReader);
        boolean bl2 = this.lastValueWasNull = null == object;
        if (this.lastValueWasNull) {
            return 0L;
        }
        return (Long)object;
    }

    public long getLong(String string) throws SQLServerException {
        return this.getLong(this.findColumn(string));
    }

    public ResultSetMetaData getMetaData() throws SQLServerException {
        this.checkClosed();
        if (this.metaData == null) {
            this.metaData = new SQLServerResultSetMetaData(this.stmt.connection, this);
        }
        return this.metaData;
    }

    public Object getObject(int n2) throws SQLServerException {
        int n3;
        Column column = this.getterGetColumn(n2);
        Object object = column.getValue(n3 = DataTypes.nativeTypeToJdbcType(this.stmt.connection, column.getTypeInfo().getNativeType(), column.getTypeInfo().getMaxLength()), this.tdsReader);
        boolean bl2 = this.lastValueWasNull = null == object;
        if (this.lastValueWasNull) {
            return null;
        }
        if (object instanceof InputStream || object instanceof Reader) {
            this.activeStream = object;
        }
        return object;
    }

    public Object getObject(String string) throws SQLServerException {
        return this.getObject(this.findColumn(string));
    }

    public short getShort(int n2) throws SQLServerException {
        Column column = this.getterGetColumn(n2);
        short s2 = column.getShort(this.tdsReader);
        this.lastValueWasNull = column.isNull();
        return s2;
    }

    public short getShort(String string) throws SQLServerException {
        return this.getShort(this.findColumn(string));
    }

    public String getString(int n2) throws SQLServerException {
        String string = (String)this.getterGetColumn(n2).getValue(1, this.tdsReader);
        this.lastValueWasNull = null == string;
        return string;
    }

    public String getString(String string) throws SQLServerException {
        return this.getString(this.findColumn(string));
    }

    public Time getTime(int n2) throws SQLServerException {
        return this.getTime(n2, null);
    }

    public Time getTime(String string) throws SQLServerException {
        return this.getTime(this.findColumn(string), null);
    }

    public Time getTime(int n2, Calendar calendar) throws SQLServerException {
        Time time = (Time)this.getterGetColumn(n2).getValue(92, calendar, this.tdsReader);
        this.lastValueWasNull = null == time;
        return time;
    }

    public Time getTime(String string, Calendar calendar) throws SQLServerException {
        return this.getTime(this.findColumn(string), calendar);
    }

    public Timestamp getTimestamp(int n2) throws SQLServerException {
        return this.getTimestamp(n2, null);
    }

    public Timestamp getTimestamp(String string) throws SQLServerException {
        return this.getTimestamp(this.findColumn(string), null);
    }

    public Timestamp getTimestamp(int n2, Calendar calendar) throws SQLServerException {
        Timestamp timestamp = (Timestamp)this.getterGetColumn(n2).getValue(93, calendar, this.tdsReader);
        this.lastValueWasNull = null == timestamp;
        return timestamp;
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLServerException {
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    public InputStream getUnicodeStream(int n2) throws SQLServerException {
        this.NotImplemented();
        return null;
    }

    public InputStream getUnicodeStream(String string) throws SQLServerException {
        this.NotImplemented();
        return null;
    }

    public Object getObject(int n2, Map map) throws SQLServerException {
        this.NotImplemented();
        return null;
    }

    public Ref getRef(int n2) throws SQLServerException {
        this.NotImplemented();
        return null;
    }

    public Blob getBlob(int n2) throws SQLServerException {
        Blob blob = (Blob)this.getterGetColumn(n2).getValue(2004, this.tdsReader);
        this.lastValueWasNull = null == blob;
        return blob;
    }

    public Clob getClob(int n2) throws SQLServerException {
        Column column = this.getterGetColumn(n2);
        SQLServerClob sQLServerClob = (SQLServerClob)column.getValue(2005, this.tdsReader);
        boolean bl2 = this.lastValueWasNull = null == sQLServerClob;
        if (null != sQLServerClob) {
            sQLServerClob.setSQLCollation(column.getTypeInfo().getSQLCollation());
        }
        return sQLServerClob;
    }

    public Array getArray(int n2) throws SQLServerException {
        this.NotImplemented();
        return null;
    }

    public Object getObject(String string, Map map) throws SQLServerException {
        this.NotImplemented();
        return null;
    }

    public Ref getRef(String string) throws SQLServerException {
        this.NotImplemented();
        return null;
    }

    public Blob getBlob(String string) throws SQLServerException {
        return this.getBlob(this.findColumn(string));
    }

    public Clob getClob(String string) throws SQLServerException {
        return this.getClob(this.findColumn(string));
    }

    public Array getArray(String string) throws SQLServerException {
        this.NotImplemented();
        return null;
    }

    public String getCursorName() throws SQLServerException {
        SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_positionedUpdatesNotSupported"), null, false);
        return null;
    }

    public Reader getCharacterStream(int n2) throws SQLServerException {
        Object object;
        Column column = this.getterGetColumn(n2);
        column.checkGetCharacterStream();
        this.activeStream = object = column.getValue(-1, new InputStreamGetterArgs(2, this.isAdaptive, this.isForwardOnly(), this.toLogString()), null, this.tdsReader);
        if (null != object && object instanceof InputStream) {
            try {
                object = new BufferedReader(new InputStreamReader((InputStream)object, "UTF-16LE"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SQLServerException(null, unsupportedEncodingException.getMessage(), null, 0, true);
            }
        }
        this.lastValueWasNull = null == object;
        return (Reader)object;
    }

    public Reader getCharacterStream(String string) throws SQLServerException {
        return this.getCharacterStream(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(int n2) throws SQLServerException {
        BigDecimal bigDecimal = (BigDecimal)this.getterGetColumn(n2).getValue(3, this.tdsReader);
        this.lastValueWasNull = null == bigDecimal;
        return bigDecimal;
    }

    public BigDecimal getBigDecimal(String string) throws SQLServerException {
        return this.getBigDecimal(this.findColumn(string));
    }

    public boolean rowUpdated() throws SQLServerException {
        this.checkClosed();
        this.verifyResultSetIsUpdatable();
        return false;
    }

    public boolean rowInserted() throws SQLServerException {
        this.checkClosed();
        this.verifyResultSetIsUpdatable();
        return false;
    }

    public boolean rowDeleted() throws SQLServerException {
        this.checkClosed();
        this.verifyResultSetIsUpdatable();
        if (this.isOnInsertRow || !this.hasCurrentRow()) {
            return false;
        }
        return this.currentRowDeleted();
    }

    private final boolean currentRowDeleted() throws SQLServerException {
        if (!$assertionsDisabled && !this.hasCurrentRow()) {
            throw new AssertionError();
        }
        return this.deletedCurrentRow || 0 != this.serverCursorId && 2 == this.loadColumn(this.columns.length).getInt(this.tdsReader);
    }

    private final Column updaterGetColumn(int n2) throws SQLServerException {
        this.checkClosed();
        this.closeActiveStream();
        this.verifyResultSetIsUpdatable();
        if (!this.isOnInsertRow) {
            if (!this.hasCurrentRow()) {
                SQLServerException.makeFromDriverError(this.stmt.connection, this.stmt, SQLServerException.getErrString("R_resultsetNoCurrentRow"), null, true);
            }
            this.verifyCurrentRowIsNotDeleted("R_cantUpdateDeletedRow");
        }
        this.verifyValidColumnIndex(n2);
        return this.getColumn(n2);
    }

    public void updateNull(int n2) throws SQLServerException {
        Column column = this.updaterGetColumn(n2);
        int n3 = DataTypes.nativeTypeToJdbcType(this.stmt.connection, column.getTypeInfo().getNativeType(), column.getTypeInfo().getMaxLength());
        column.updateValue(n3, null, this.stmt.connection);
    }

    public void updateBoolean(int n2, boolean bl2) throws SQLServerException {
        this.updaterGetColumn(n2).updateValue(-7, new Boolean(bl2), this.stmt.connection);
    }

    public void updateByte(int n2, byte by) throws SQLServerException {
        this.updaterGetColumn(n2).updateValue(5, new Byte(by), this.stmt.connection);
    }

    public void updateShort(int n2, short s2) throws SQLServerException {
        this.updaterGetColumn(n2).updateValue(5, new Short(s2), this.stmt.connection);
    }

    public void updateInt(int n2, int n3) throws SQLServerException {
        this.updaterGetColumn(n2).updateValue(4, new Integer(n3), this.stmt.connection);
    }

    public void updateLong(int n2, long l2) throws SQLServerException {
        this.updaterGetColumn(n2).updateValue(-5, new Long(l2), this.stmt.connection);
    }

    public void updateFloat(int n2, float f2) throws SQLServerException {
        this.updaterGetColumn(n2).updateValue(7, new Float(f2), this.stmt.connection);
    }

    public void updateDouble(int n2, double d2) throws SQLServerException {
        this.updaterGetColumn(n2).updateValue(8, new Double(d2), this.stmt.connection);
    }

    public void updateBigDecimal(int n2, BigDecimal bigDecimal) throws SQLServerException {
        this.updaterGetColumn(n2).updateValue(3, bigDecimal, this.stmt.connection);
    }

    public void updateString(int n2, String string) throws SQLServerException {
        this.updaterGetColumn(n2).updateValue(1, string, this.stmt.connection);
    }

    public void updateBytes(int n2, byte[] byArray) throws SQLServerException {
        this.updaterGetColumn(n2).updateValue(-2, byArray, this.stmt.connection);
    }

    public void updateDate(int n2, Date date) throws SQLServerException {
        Column column = this.updaterGetColumn(n2);
        column.updateValue(91, date, this.stmt.connection);
    }

    public void updateTime(int n2, Time time) throws SQLServerException {
        Column column = this.updaterGetColumn(n2);
        column.updateValue(92, time, this.stmt.connection);
    }

    public void updateTimestamp(int n2, Timestamp timestamp) throws SQLServerException {
        Column column = this.updaterGetColumn(n2);
        column.updateValue(93, timestamp, this.stmt.connection);
    }

    public void updateAsciiStream(int n2, InputStream inputStream, int n3) throws SQLServerException {
        Column column = this.updaterGetColumn(n2);
        column.checkUpdateAsciiStream();
        column.updateValue(-1, inputStream, new InputStreamSetterArgs(3, n3), this.stmt.connection);
    }

    public void updateBinaryStream(int n2, InputStream inputStream, int n3) throws SQLServerException {
        Column column = this.updaterGetColumn(n2);
        column.checkUpdateBinaryStream();
        column.updateValue(-4, inputStream, new InputStreamSetterArgs(1, n3), this.stmt.connection);
    }

    public void updateCharacterStream(int n2, Reader reader, int n3) throws SQLServerException {
        Column column = this.updaterGetColumn(n2);
        column.checkUpdateCharacterStream();
        column.updateValue(-1, reader, new CharacterStreamSetterArgs(n3), this.stmt.connection);
    }

    public void updateObject(int n2, Object object) throws SQLServerException {
        this.updateObject(n2, object, (Integer)null);
    }

    public void updateObject(int n2, Object object, int n3) throws SQLServerException {
        this.updateObject(n2, object, new Integer(n3));
    }

    private final void updateObject(int n2, Object object, Integer n3) throws SQLServerException {
        Column column = this.updaterGetColumn(n2);
        int n4 = DataTypes.nativeTypeToJdbcType(this.stmt.connection, column.getTypeInfo().getNativeType(), column.getTypeInfo().getMaxLength());
        int n5 = DataTypes.getObjectJDBCType(object, n4);
        if (Reader.class.isInstance(object)) {
            column.updateValue(n5, object, new CharacterStreamSetterArgs(-1), this.stmt.connection);
        } else if (InputStream.class.isInstance(object)) {
            column.updateValue(n5, object, new InputStreamSetterArgs(DataTypes.isBinary(column.getTypeInfo().getNativeType()) ? 1 : 3, -1L), this.stmt.connection);
        } else {
            column.updateValue(n5, object, n3, this.stmt.connection);
        }
    }

    public void updateNull(String string) throws SQLServerException {
        this.checkClosed();
        this.updateNull(this.findColumn(string));
    }

    public void updateBoolean(String string, boolean bl2) throws SQLServerException {
        this.checkClosed();
        this.updateBoolean(this.findColumn(string), bl2);
    }

    public void updateByte(String string, byte by) throws SQLServerException {
        this.checkClosed();
        this.updateByte(this.findColumn(string), by);
    }

    public void updateShort(String string, short s2) throws SQLServerException {
        this.checkClosed();
        this.updateShort(this.findColumn(string), s2);
    }

    public void updateInt(String string, int n2) throws SQLServerException {
        this.checkClosed();
        this.updateInt(this.findColumn(string), n2);
    }

    public void updateLong(String string, long l2) throws SQLServerException {
        this.checkClosed();
        this.updateLong(this.findColumn(string), l2);
    }

    public void updateFloat(String string, float f2) throws SQLServerException {
        this.checkClosed();
        this.updateFloat(this.findColumn(string), f2);
    }

    public void updateDouble(String string, double d2) throws SQLServerException {
        this.checkClosed();
        this.updateDouble(this.findColumn(string), d2);
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLServerException {
        this.checkClosed();
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    public void updateString(String string, String string2) throws SQLServerException {
        this.checkClosed();
        this.updateString(this.findColumn(string), string2);
    }

    public void updateBytes(String string, byte[] byArray) throws SQLServerException {
        this.checkClosed();
        this.updateBytes(this.findColumn(string), byArray);
    }

    public void updateDate(String string, Date date) throws SQLServerException {
        this.checkClosed();
        this.updateDate(this.findColumn(string), date);
    }

    public void updateTime(String string, Time time) throws SQLServerException {
        this.checkClosed();
        this.updateTime(this.findColumn(string), time);
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLServerException {
        this.checkClosed();
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n2) throws SQLServerException {
        this.checkClosed();
        this.updateAsciiStream(this.findColumn(string), inputStream, n2);
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n2) throws SQLServerException {
        this.checkClosed();
        this.updateBinaryStream(this.findColumn(string), inputStream, n2);
    }

    public void updateCharacterStream(String string, Reader reader, int n2) throws SQLServerException {
        this.checkClosed();
        this.updateCharacterStream(this.findColumn(string), reader, n2);
    }

    public void updateObject(String string, Object object, int n2) throws SQLServerException {
        this.checkClosed();
        this.updateObject(this.findColumn(string), object, n2);
    }

    public void updateObject(String string, Object object) throws SQLServerException {
        this.checkClosed();
        this.updateObject(this.findColumn(string), object);
    }

    public void insertRow() throws SQLServerException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.toLogString() + this.logCursorState());
        }
        this.checkClosed();
        this.closeActiveStream();
        this.verifyResultSetIsUpdatable();
        if (!this.isOnInsertRow) {
            SQLServerException.makeFromDriverError(this.stmt.connection, this.stmt, SQLServerException.getErrString("R_mustBeOnInsertRow"), null, true);
        }
        final class InsertRowRPC
        extends TDSCommand {
            InsertRowRPC() {
                super("InsertRowRPC", 0);
            }

            final boolean doExecute() throws SQLServerException {
                SQLServerResultSet.this.doInsertRowRPC(this);
                return true;
            }
        }
        this.stmt.executeCommand(new InsertRowRPC());
        if (-3 != this.rowCount) {
            ++this.rowCount;
        }
    }

    private final void doInsertRowRPC(TDSCommand tDSCommand) throws SQLServerException {
        if (!$assertionsDisabled && 0 == this.serverCursorId) {
            throw new AssertionError();
        }
        TDSWriter tDSWriter = tDSCommand.startRequest((byte)3);
        tDSWriter.writeShort((short)-1);
        tDSWriter.writeShort((short)1);
        tDSWriter.writeByte((byte)0);
        tDSWriter.writeByte((byte)0);
        tDSWriter.writeRPCInt(null, new Integer(this.serverCursorId), false);
        tDSWriter.writeRPCInt(null, new Integer(4), false);
        tDSWriter.writeRPCInt(null, new Integer(this.fetchBufferGetRow()), false);
        tDSWriter.writeRPCString("");
        if (this.hasUpdatedColumns()) {
            for (int i2 = 0; i2 < this.columns.length; ++i2) {
                this.columns[i2].sendByRPC(tDSWriter, this.stmt.connection, i2);
            }
        } else {
            if (null == this.cursorTableName) {
                if (null == this.stmt.getPreparedSQL()) {
                    SQLServerException.makeFromDriverError(this.stmt.connection, this, SQLServerException.getErrString("R_noColumnParameterValue"), null, true);
                }
                this.cursorTableName = new SQLServerParameterMetaData(this.stmt, this.stmt.getPreparedSQL()).getTableName();
            }
            if (!$assertionsDisabled && null == this.cursorTableName) {
                throw new AssertionError();
            }
            tDSWriter.writeRPCString("INSERT " + this.cursorTableName + " DEFAULT VALUES");
        }
        TDSParser.parse(tDSCommand.startResponse(), tDSCommand.getLogContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRow() throws SQLServerException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.toLogString() + this.logCursorState());
        }
        this.checkClosed();
        this.closeActiveStream();
        this.verifyResultSetIsUpdatable();
        this.verifyResultSetIsNotOnInsertRow();
        this.verifyResultSetHasCurrentRow();
        this.verifyCurrentRowIsNotDeleted("R_cantUpdateDeletedRow");
        if (!this.hasUpdatedColumns()) {
            SQLServerException.makeFromDriverError(this.stmt.connection, this.stmt, SQLServerException.getErrString("R_noColumnParameterValue"), null, true);
        }
        try {
            final class UpdateRowRPC
            extends TDSCommand {
                UpdateRowRPC() {
                    super("UpdateRowRPC", 0);
                }

                final boolean doExecute() throws SQLServerException {
                    SQLServerResultSet.this.doUpdateRowRPC(this);
                    return true;
                }
            }
            this.stmt.executeCommand(new UpdateRowRPC());
        }
        finally {
            this.cancelUpdates();
        }
        this.updatedCurrentRow = true;
    }

    private final void doUpdateRowRPC(TDSCommand tDSCommand) throws SQLServerException {
        if (!$assertionsDisabled && 0 == this.serverCursorId) {
            throw new AssertionError();
        }
        TDSWriter tDSWriter = tDSCommand.startRequest((byte)3);
        tDSWriter.writeShort((short)-1);
        tDSWriter.writeShort((short)1);
        tDSWriter.writeByte((byte)0);
        tDSWriter.writeByte((byte)0);
        tDSWriter.writeRPCInt(null, new Integer(this.serverCursorId), false);
        tDSWriter.writeRPCInt(null, new Integer(33), false);
        tDSWriter.writeRPCInt(null, new Integer(this.fetchBufferGetRow()), false);
        tDSWriter.writeRPCString("");
        if (!$assertionsDisabled && !this.hasUpdatedColumns()) {
            throw new AssertionError();
        }
        for (int i2 = 0; i2 < this.columns.length; ++i2) {
            this.columns[i2].sendByRPC(tDSWriter, this.stmt.connection, i2);
        }
        TDSParser.parse(tDSCommand.startResponse(), tDSCommand.getLogContext());
    }

    final boolean hasUpdatedColumns() {
        for (int i2 = 0; i2 < this.columns.length; ++i2) {
            if (!this.columns[i2].hasUpdates()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRow() throws SQLServerException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.toLogString() + this.logCursorState());
        }
        this.checkClosed();
        this.closeActiveStream();
        this.verifyResultSetIsUpdatable();
        this.verifyResultSetIsNotOnInsertRow();
        this.verifyResultSetHasCurrentRow();
        this.verifyCurrentRowIsNotDeleted("R_cantUpdateDeletedRow");
        try {
            final class DeleteRowRPC
            extends TDSCommand {
                DeleteRowRPC() {
                    super("DeleteRowRPC", 0);
                }

                final boolean doExecute() throws SQLServerException {
                    SQLServerResultSet.this.doDeleteRowRPC(this);
                    return true;
                }
            }
            this.stmt.executeCommand(new DeleteRowRPC());
        }
        finally {
            this.cancelUpdates();
        }
        this.deletedCurrentRow = true;
    }

    private final void doDeleteRowRPC(TDSCommand tDSCommand) throws SQLServerException {
        if (!$assertionsDisabled && 0 == this.serverCursorId) {
            throw new AssertionError();
        }
        TDSWriter tDSWriter = tDSCommand.startRequest((byte)3);
        tDSWriter.writeShort((short)-1);
        tDSWriter.writeShort((short)1);
        tDSWriter.writeByte((byte)0);
        tDSWriter.writeByte((byte)0);
        tDSWriter.writeRPCInt(null, new Integer(this.serverCursorId), false);
        tDSWriter.writeRPCInt(null, new Integer(34), false);
        tDSWriter.writeRPCInt(null, new Integer(this.fetchBufferGetRow()), false);
        tDSWriter.writeRPCString("");
        TDSParser.parse(tDSCommand.startResponse(), tDSCommand.getLogContext());
    }

    public void refreshRow() throws SQLServerException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.toLogString() + this.logCursorState());
        }
        this.checkClosed();
        this.verifyResultSetIsScrollable();
        this.verifyResultSetIsUpdatable();
        this.verifyResultSetIsNotOnInsertRow();
        this.verifyResultSetHasCurrentRow();
        this.verifyCurrentRowIsNotDeleted("R_cantUpdateDeletedRow");
        if (1004 == this.stmt.getResultSetType() || 0 == this.serverCursorId) {
            return;
        }
        this.doRefreshRow();
    }

    private void doRefreshRow() throws SQLServerException {
        int n2;
        if (!$assertionsDisabled && !this.hasCurrentRow()) {
            throw new AssertionError();
        }
        this.closeActiveStream();
        this.cancelUpdates();
        int n3 = this.fetchBufferGetRow();
        this.doServerFetch(128, 0, 0);
        for (n2 = 0; n2 < n3 && (this.isForwardOnly() ? this.fetchBufferNext() : this.scrollWindow.next(this)); ++n2) {
        }
        if (n2 < n3) {
            this.currentRow = -1;
            return;
        }
        this.updatedCurrentRow = false;
    }

    private final void cancelUpdates() {
        if (!this.isOnInsertRow) {
            this.clearColumnsValues();
        }
    }

    public void cancelRowUpdates() throws SQLServerException {
        this.checkClosed();
        this.verifyResultSetIsUpdatable();
        this.verifyResultSetIsNotOnInsertRow();
        this.cancelUpdates();
    }

    public void moveToInsertRow() throws SQLServerException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.toLogString() + this.logCursorState());
        }
        this.checkClosed();
        this.verifyResultSetIsUpdatable();
        this.cancelUpdates();
        this.isOnInsertRow = true;
    }

    public void moveToCurrentRow() throws SQLServerException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.toLogString() + this.logCursorState());
        }
        this.checkClosed();
        this.verifyResultSetIsUpdatable();
        this.cancelInsert();
    }

    public Statement getStatement() throws SQLServerException {
        this.checkClosed();
        return this.stmt;
    }

    public void updateClob(int n2, Clob clob) throws SQLServerException {
        this.updaterGetColumn(n2).updateValue(2005, clob, this.stmt.connection);
    }

    public void updateClob(String string, Clob clob) throws SQLServerException {
        this.checkClosed();
        this.updateClob(this.findColumn(string), clob);
    }

    public void updateBlob(int n2, Blob blob) throws SQLServerException {
        this.updaterGetColumn(n2).updateValue(2004, blob, this.stmt.connection);
    }

    public void updateBlob(String string, Blob blob) throws SQLServerException {
        this.checkClosed();
        this.updateBlob(this.findColumn(string), blob);
    }

    public void updateArray(int n2, Array array) throws SQLServerException {
        this.stmt.NotImplemented();
    }

    public void updateArray(String string, Array array) throws SQLServerException {
        this.stmt.NotImplemented();
    }

    public void updateRef(int n2, Ref ref) throws SQLServerException {
        this.stmt.NotImplemented();
    }

    public void updateRef(String string, Ref ref) throws SQLServerException {
        this.stmt.NotImplemented();
    }

    public URL getURL(int n2) throws SQLServerException {
        this.stmt.NotImplemented();
        return null;
    }

    public URL getURL(String string) throws SQLServerException {
        this.stmt.NotImplemented();
        return null;
    }

    final void doServerFetch(int n2, int n3, int n4) throws SQLServerException {
        if (logger.isLoggable(Level.FINER)) {
            logger.fine(this.toLogString() + " fetchType:" + n2 + " startRow:" + n3 + " numRows:" + n4);
        }
        this.fetchBufferStart = null;
        if (null != this.scrollWindow) {
            this.scrollWindow.clear();
        }
        while (this.fetchBufferNext()) {
        }
        final class CursorFetchCommand
        extends TDSCommand {
            private final int serverCursorId;
            private int fetchType;
            private int startRow;
            private int numRows;

            CursorFetchCommand(int n2, int n3, int n4, int n5) {
                super("doServerFetch", SQLServerResultSet.this.stmt.queryTimeout);
                this.serverCursorId = n2;
                this.fetchType = n3;
                this.startRow = n4;
                this.numRows = n5;
            }

            final boolean doExecute() throws SQLServerException {
                TDSWriter tDSWriter = this.startRequest((byte)3);
                tDSWriter.writeShort((short)-1);
                tDSWriter.writeShort((short)7);
                tDSWriter.writeByte((byte)2);
                tDSWriter.writeByte((byte)0);
                tDSWriter.writeRPCInt(null, new Integer(this.serverCursorId), false);
                tDSWriter.writeRPCInt(null, new Integer(this.fetchType), false);
                tDSWriter.writeRPCInt(null, new Integer(this.startRow), false);
                tDSWriter.writeRPCInt(null, new Integer(this.numRows), false);
                SQLServerResultSet.this.tdsReader = this.startResponse(SQLServerResultSet.this.isForwardOnly() && 1007 != SQLServerResultSet.this.stmt.resultSetConcurrency && SQLServerResultSet.this.wasResponseBufferingSetOnStatement && SQLServerResultSet.this.isAdaptive);
                final class ServerFetchHandler
                extends TDSTokenHandler {
                    private final /* synthetic */ SQLServerResultSet this$0;

                    ServerFetchHandler(SQLServerResultSet sQLServerResultSet) {
                        this.this$0 = sQLServerResultSet;
                        super("ServerFetchHandler");
                    }

                    boolean onColMetaData(TDSReader tDSReader) throws SQLServerException {
                        new StreamColumns().setFromTDS(tDSReader);
                        return false;
                    }
                }
                TDSParser.parse(SQLServerResultSet.this.tdsReader, new ServerFetchHandler(SQLServerResultSet.this));
                return false;
            }

            final void onAttention(TDSReader tDSReader) throws SQLServerException {
                TDSParser.parse(tDSReader, new ServerFetchHandler(SQLServerResultSet.this));
                SQLServerResultSet.this.processAttention(tDSReader);
                super.onAttention(tDSReader);
            }
        }
        this.stmt.executeCommand(new CursorFetchCommand(this.serverCursorId, n2, n3, n4));
        this.fetchBufferStart = this.tdsReader.mark();
        this.numFetchedRows = 0;
        this.lastColumnIndex = 0;
        if (null != this.scrollWindow && 128 != n2) {
            this.scrollWindow.resize(this.fetchSize);
        }
        if (n4 < 0 || n3 < 0) {
            block9: {
                try {
                    while (this.scrollWindow.next(this)) {
                    }
                }
                catch (SQLException sQLException) {
                    if (!logger.isLoggable(Level.FINE)) break block9;
                    logger.fine(this.toLogString() + " Ignored exception from row error during server cursor fixup: " + sQLException.getMessage());
                }
            }
            final class ServerCursorFixup
            extends TDSTokenHandler {
                boolean isNeeded;

                ServerCursorFixup() {
                    super("ServerCursorFixup");
                    this.isNeeded = false;
                }

                boolean onRetStatus(TDSReader tDSReader) throws SQLServerException {
                    StreamRetStatus streamRetStatus = new StreamRetStatus();
                    streamRetStatus.setFromTDS(tDSReader);
                    this.isNeeded = 2 == streamRetStatus.getStatus();
                    return false;
                }
            }
            ServerCursorFixup serverCursorFixup = new ServerCursorFixup();
            TDSParser.parse(this.tdsReader, serverCursorFixup);
            if (serverCursorFixup.isNeeded) {
                this.doServerFetch(1, 0, 0);
                return;
            }
            this.scrollWindow.reset();
        }
    }

    private final void processAttention(TDSReader tDSReader) throws SQLServerException {
        this.tdsReader = tDSReader;
        while (this.fetchBufferNext()) {
        }
    }

    final void closeServerCursor() throws SQLServerException {
        if (!$assertionsDisabled && 0 == this.serverCursorId) {
            throw new AssertionError();
        }
        if (this.stmt.connection.isClosed()) {
            return;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.toLogString() + " Closing cursor:" + this.serverCursorId);
        }
        try {
            final class CloseServerCursorCommand
            extends UninterruptableTDSCommand {
                CloseServerCursorCommand() {
                    super("closeServerCursor");
                }

                final boolean doExecute() throws SQLServerException {
                    this.startRequest((byte)1).writeString("sp_cursorclose " + SQLServerResultSet.this.serverCursorId);
                    TDSParser.parse(this.startResponse(), this.getLogContext());
                    return true;
                }
            }
            this.stmt.executeCommand(new CloseServerCursorCommand());
        }
        catch (SQLServerException sQLServerException) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(this.toLogString() + " Error closing cursor:" + this.serverCursorId + " " + sQLServerException.getMessage());
            }
            throw sQLServerException;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.toLogString() + " Closed cursor:" + this.serverCursorId);
        }
    }

    static {
        $assertionsDisabled = !SQLServerResultSet.class.desiredAssertionStatus();
        lastResultSetID = 0;
        logger = Logger.getLogger("com.microsoft.sqlserver.jdbc.SQLServerResultSet");
    }

    private class FetchHandler
    extends TDSTokenHandler {
        private boolean foundRow;
        static final /* synthetic */ boolean $assertionsDisabled;

        final boolean foundRow() {
            return this.foundRow;
        }

        FetchHandler(String string) {
            super(string);
            this.reset();
        }

        final void reset() {
            this.foundRow = false;
        }

        boolean onRow(TDSReader tDSReader) throws SQLServerException {
            if (209 != tDSReader.readUnsignedByte() && !$assertionsDisabled) {
                throw new AssertionError();
            }
            this.foundRow = true;
            return false;
        }

        boolean onDone(TDSReader tDSReader) throws SQLServerException {
            return false;
        }

        static {
            $assertionsDisabled = !(class$com$microsoft$sqlserver$jdbc$SQLServerResultSet == null ? (class$com$microsoft$sqlserver$jdbc$SQLServerResultSet = SQLServerResultSet.class$("com.microsoft.sqlserver.jdbc.SQLServerResultSet")) : class$com$microsoft$sqlserver$jdbc$SQLServerResultSet).desiredAssertionStatus();
        }
    }
}

