/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.DataTypes;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerResultSet;
import com.microsoft.sqlserver.jdbc.TypeInfo;
import java.sql.ResultSetMetaData;
import java.text.MessageFormat;

public final class SQLServerResultSetMetaData
implements ResultSetMetaData {
    private SQLServerConnection con;
    private SQLServerResultSet rs;
    public int nBeforeExecuteCols;

    public SQLServerResultSetMetaData(SQLServerConnection sQLServerConnection, SQLServerResultSet sQLServerResultSet) {
        this.con = sQLServerConnection;
        this.rs = sQLServerResultSet;
    }

    private void checkIndex(int n2) throws SQLServerException {
        if (n2 > 0 && n2 <= this.rs.getColumnCount()) {
            return;
        }
        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_indexOutOfRange"));
        Object[] objectArray = new Object[]{new Integer(n2)};
        SQLServerException.makeFromDriverError(this.con, null, messageFormat.format(objectArray), null, false);
    }

    public String getCatalogName(int n2) throws SQLServerException {
        this.checkIndex(n2);
        return "";
    }

    public int getColumnCount() throws SQLServerException {
        if (this.rs == null) {
            return 0;
        }
        return this.rs.getColumnCount();
    }

    public int getColumnDisplaySize(int n2) throws SQLServerException {
        this.checkIndex(n2);
        int n3 = this.rs.getTypeInfo(n2).getTDSType();
        int n4 = this.getPrecision(n2);
        if (DataTypes.isBinary(n3) && 36 != n3) {
            n4 = n4 < 0x3FFFFFFF ? 2 * n4 : Integer.MAX_VALUE;
        } else {
            switch (n3) {
                case 38: 
                case 52: 
                case 56: 
                case 127: {
                    if (n4 <= 3) break;
                    ++n4;
                    break;
                }
                case 60: 
                case 106: 
                case 108: 
                case 110: 
                case 122: {
                    n4 += 2;
                    break;
                }
                case 16: 
                case 59: 
                case 62: 
                case 109: {
                    n4 = 7 == n4 ? 13 : 22;
                }
            }
        }
        return n4;
    }

    public String getColumnLabel(int n2) throws SQLServerException {
        this.checkIndex(n2);
        return this.rs.getColumnName(n2);
    }

    public String getColumnName(int n2) throws SQLServerException {
        this.checkIndex(n2);
        return this.rs.getColumnName(n2);
    }

    public int getColumnType(int n2) throws SQLServerException {
        this.checkIndex(n2);
        int n3 = this.rs.getTypeInfo(n2).getNativeType();
        int n4 = this.rs.getTypeInfo(n2).getMaxLength();
        return DataTypes.nativeTypeToJdbcType(this.con, n3, n4);
    }

    public String getColumnTypeName(int n2) throws SQLServerException {
        this.checkIndex(n2);
        int n3 = this.rs.getTypeInfo(n2).getNativeType();
        int n4 = this.rs.getTypeInfo(n2).getMaxLength();
        if (240 == n3) {
            return this.rs.getTypeInfo(n2).getUDTTDSHeader().getTypeName();
        }
        return DataTypes.getDataTypeSQLServerName(n3, n4, this.rs.getTypeInfo(n2).getUserType());
    }

    public int getPrecision(int n2) throws SQLServerException {
        this.checkIndex(n2);
        return this.rs.getTypeInfo(n2).getPrecision();
    }

    public int getScale(int n2) throws SQLServerException {
        this.checkIndex(n2);
        return this.rs.getTypeInfo(n2).getScale();
    }

    public String getSchemaName(int n2) throws SQLServerException {
        this.checkIndex(n2);
        return "";
    }

    public String getTableName(int n2) throws SQLServerException {
        this.checkIndex(n2);
        return this.rs.getTableName(n2);
    }

    public boolean isAutoIncrement(int n2) throws SQLServerException {
        this.checkIndex(n2);
        boolean bl2 = this.rs.getTypeInfo(n2).isIdentity();
        return bl2;
    }

    public boolean isCaseSensitive(int n2) throws SQLServerException {
        this.checkIndex(n2);
        return this.rs.getTypeInfo(n2).isCaseSensitive();
    }

    public boolean isCurrency(int n2) throws SQLServerException {
        this.checkIndex(n2);
        int n3 = this.rs.getTypeInfo(n2).getNativeType();
        switch (n3) {
            case 14: 
            case 110: {
                return true;
            }
        }
        return false;
    }

    public boolean isDefinitelyWritable(int n2) throws SQLServerException {
        this.checkIndex(n2);
        return TypeInfo.UPDATABLE_READ_WRITE == this.rs.getTypeInfo(n2).getUpdatability();
    }

    public int isNullable(int n2) throws SQLServerException {
        this.checkIndex(n2);
        return this.rs.getTypeInfo(n2).isNullable() ? 1 : 0;
    }

    public boolean isReadOnly(int n2) throws SQLServerException {
        this.checkIndex(n2);
        return TypeInfo.UPDATABLE_READ_ONLY == this.rs.getTypeInfo(n2).getUpdatability();
    }

    public boolean isSearchable(int n2) throws SQLServerException {
        this.checkIndex(n2);
        int n3 = this.rs.getTypeInfo(n2).getNativeType();
        return DataTypes.getDataType((int)n3, (int)0).bSearchable;
    }

    public boolean isSigned(int n2) throws SQLServerException {
        this.checkIndex(n2);
        int n3 = this.rs.getTypeInfo(n2).getNativeType();
        return DataTypes.isSigned(n3);
    }

    public boolean isWritable(int n2) throws SQLServerException {
        this.checkIndex(n2);
        return TypeInfo.UPDATABLE_READ_WRITE == this.rs.getTypeInfo(n2).getUpdatability() || TypeInfo.UPDATABLE_UNKNOWN == this.rs.getTypeInfo(n2).getUpdatability();
    }

    public String getColumnClassName(int n2) throws SQLServerException {
        this.checkIndex(n2);
        int n3 = this.rs.getTypeInfo(n2).getNativeType();
        int n4 = this.rs.getTypeInfo(n2).getMaxLength();
        return DataTypes.getDataType((int)n3, (int)n4).sClassName;
    }
}

