/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.JDBCCallSyntaxTranslator;
import com.microsoft.sqlserver.jdbc.Parameter;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerResultSet;
import com.microsoft.sqlserver.jdbc.StreamColumns;
import com.microsoft.sqlserver.jdbc.StreamDone;
import com.microsoft.sqlserver.jdbc.StreamInfo;
import com.microsoft.sqlserver.jdbc.StreamRetStatus;
import com.microsoft.sqlserver.jdbc.TDSCommand;
import com.microsoft.sqlserver.jdbc.TDSParser;
import com.microsoft.sqlserver.jdbc.TDSReader;
import com.microsoft.sqlserver.jdbc.TDSTokenHandler;
import com.microsoft.sqlserver.jdbc.TDSWriter;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SQLServerStatement
implements Statement {
    static final char LEFT_CURLY_BRACKET = '{';
    static final char RIGHT_CURLY_BRACKET = '}';
    private boolean isResponseBufferingAdaptive = false;
    private boolean wasResponseBufferingSet = false;
    static final String identityQuery = " select SCOPE_IDENTITY() AS GENERATED_KEYS";
    String userSQL;
    String procedureName;
    StreamRetStatus procedureRetStatToken;
    TDSReader tdsReader;
    int prepStmtHandle = -1;
    int prepexecOutParamCount;
    int prepexecOutParamIndexAdjustment;
    Parameter[] inOutParam;
    final SQLServerConnection connection;
    int queryTimeout;
    private volatile TDSCommand currentCommand = null;
    boolean moreResults = false;
    SQLServerResultSet resultSet;
    static final int EXECUTE_NOT_SET = 0;
    static final int EXECUTE_QUERY = 1;
    static final int EXECUTE_UPDATE = 2;
    static final int EXECUTE = 3;
    static final int EXECUTE_BATCH = 4;
    static final int EXECUTE_QUERY_INTERNAL = 5;
    int executeMethod = 0;
    int updateCount = -1;
    boolean escapeProcessing;
    int maxRows = 0;
    int maxFieldSize = 0;
    int resultSetConcurrency;
    int appResultSetType;
    int resultSetType;
    boolean isServerSideCursor;
    String cursorName;
    int nFetchSize;
    int defaultFetchSize;
    int nFetchDirection;
    boolean bIsClosed;
    boolean bRequestedGeneratedKeys;
    private ResultSet autoGeneratedKeys;
    boolean sendStringParametersAsUnicode = true;
    private boolean useLastUpdateCount;
    StringBuffer batchStatementBuffer;
    int batchSize;
    private static Logger stmtlogger = Logger.getLogger("com.microsoft.sqlserver.jdbc.SQLServerStatement");
    private final int statementID = SQLServerStatement.nextStatementID();
    private static int lastStatementID = 0;
    Vector sqlWarnings;

    final boolean getIsResponseBufferingAdaptive() {
        return this.isResponseBufferingAdaptive;
    }

    final boolean wasResponseBufferingSet() {
        return this.wasResponseBufferingSet;
    }

    String getPreparedSQL() {
        return this.userSQL;
    }

    final void executeStatement(TDSCommand tDSCommand) throws SQLServerException {
        this.processResponse();
        this.executeCommand(tDSCommand);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final synchronized void executeCommand(TDSCommand tDSCommand) throws SQLServerException {
        if (null != this.currentCommand) {
            this.currentCommand.detach();
        }
        boolean bl2 = false;
        TDSCommand tDSCommand2 = this.currentCommand;
        this.currentCommand = tDSCommand;
        try {
            bl2 = this.connection.executeCommand(tDSCommand);
        }
        finally {
            if (bl2) {
                this.currentCommand = tDSCommand2;
            }
        }
    }

    final int getSQLResultSetType() {
        return this.resultSetType;
    }

    final int getCursorType() {
        return this.getResultSetScrollOpt() & 0xFFFFEFFF;
    }

    String toLogString() {
        String string = this.getClass().getName();
        return string.substring(1 + string.lastIndexOf(46)) + "ID:" + this.statementID + " (" + this.connection.toLogString() + ")";
    }

    private static synchronized int nextStatementID() {
        return ++lastStatementID;
    }

    SQLServerStatement(SQLServerConnection sQLServerConnection, int n2, int n3) throws SQLServerException {
        String string;
        this.connection = sQLServerConnection;
        this.bIsClosed = false;
        this.useLastUpdateCount = sQLServerConnection.useLastUpdateCount();
        if (1003 != n2 && 1005 != n2 && 1004 != n2 && 2003 != n2 && 2004 != n2 && 1006 != n2 && 1005 != n2 && 1004 != n2) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_unsupportedCursor"), null, true);
        }
        if (1007 != n3 && 1008 != n3 && 1009 != n3 && 1008 != n3 && 1010 != n3) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_unsupportedConcurrency"), null, true);
        }
        this.resultSetConcurrency = n3;
        this.appResultSetType = n2;
        this.resultSetType = 1003 == n2 ? (1007 == n3 ? (null == (string = sQLServerConnection.getSelectMethod()) || !string.equals("cursor") ? 2003 : 2004) : 2004) : (1004 == n2 ? 1004 : (1005 == n2 ? 1005 : n2));
        this.nFetchDirection = 2003 == this.resultSetType || 2004 == this.resultSetType ? 1000 : 1002;
        this.defaultFetchSize = this.nFetchSize = 1009 == this.resultSetConcurrency ? 8 : 128;
        if (1007 != n3 && (2003 == this.resultSetType || 1004 == this.resultSetType)) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_unsupportedCursorAndConcurrency"), null, true);
        }
        this.isServerSideCursor = this.resultSetType != 2003;
        this.setResponseBuffering(this.connection.getResponseBuffering());
        stmtlogger = Logger.getLogger("com.microsoft.sqlserver.jdbc.SQLServerStatement");
        if (stmtlogger.isLoggable(Level.FINE)) {
            stmtlogger.fine("Properties for " + this.toLogString() + ":" + " Result type:" + this.appResultSetType + " (" + this.resultSetType + ")" + " Concurrency:" + this.resultSetConcurrency + " Fetchsize:" + this.nFetchSize + " bIsClosed:" + this.bIsClosed + " useLastUpdateCount:" + this.useLastUpdateCount + " isServerSideCursor:" + this.isServerSideCursor);
        }
    }

    final Logger getStatementLogger() {
        return stmtlogger;
    }

    final void NotImplemented() throws SQLServerException {
        SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_notSupported"), null, false);
    }

    public void close() throws SQLServerException {
        if (this.bIsClosed) {
            return;
        }
        this.resetForReexecute();
        this.bIsClosed = true;
        this.inOutParam = null;
        if (stmtlogger.isLoggable(Level.FINE)) {
            stmtlogger.fine(this.toLogString() + " Closing statement.");
        }
    }

    public ResultSet executeQuery(String string) throws SQLServerException {
        this.checkClosed();
        this.executeStatement(new StmtExecCmd(this, string, 1, 2));
        return this.resultSet;
    }

    final SQLServerResultSet executeQueryInternal(String string) throws SQLServerException {
        this.checkClosed();
        this.executeStatement(new StmtExecCmd(this, string, 5, 2));
        return this.resultSet;
    }

    public int executeUpdate(String string) throws SQLServerException {
        this.checkClosed();
        this.executeStatement(new StmtExecCmd(this, string, 2, 2));
        return this.updateCount;
    }

    public boolean execute(String string) throws SQLServerException {
        this.checkClosed();
        this.executeStatement(new StmtExecCmd(this, string, 3, 2));
        return null != this.resultSet;
    }

    private String ensureSQLSyntax(String string) {
        if (string.indexOf(123) >= 0) {
            JDBCCallSyntaxTranslator jDBCCallSyntaxTranslator = new JDBCCallSyntaxTranslator();
            String string2 = jDBCCallSyntaxTranslator.translate(string);
            this.procedureName = jDBCCallSyntaxTranslator.getProcedureName();
            return string2;
        }
        return string;
    }

    final void doExecuteStatement(StmtExecCmd stmtExecCmd) throws SQLServerException {
        String string;
        boolean bl2 = stmtlogger.isLoggable(Level.FINE);
        this.currentCommand = stmtExecCmd;
        this.executeMethod = stmtExecCmd.executeMethod;
        this.resetForReexecute();
        this.userSQL = string = this.ensureSQLSyntax(stmtExecCmd.sql);
        if (2 != this.executeMethod) {
            this.connection.setMaxRows(this.maxRows);
            this.connection.setMaxFieldSize(this.maxFieldSize);
        }
        if ((1 == this.executeMethod || 3 == this.executeMethod) && this.isServerSideCursor && this.isSelect(string)) {
            if (bl2) {
                stmtlogger.fine(this.toLogString() + " Executing server side cursor " + string);
            }
            this.doExecuteCursored(stmtExecCmd, string);
        } else {
            TDSWriter tDSWriter = stmtExecCmd.startRequest((byte)1);
            tDSWriter.writeString(string);
            if (1 == stmtExecCmd.autoGeneratedKeys && (2 == this.executeMethod || 3 == this.executeMethod) && string.trim().toUpperCase().startsWith("INSERT")) {
                tDSWriter.writeString(identityQuery);
            }
            if (bl2) {
                stmtlogger.fine(this.toLogString() + " Executing (not server cursor) " + string);
            }
            this.tdsReader = stmtExecCmd.startResponse(this.isResponseBufferingAdaptive);
            this.moreResults = true;
            this.getNextResult();
        }
        if (null == this.resultSet) {
            if (1 == this.executeMethod) {
                SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_noResultset"), null, true);
            }
        } else if (2 == this.executeMethod || 4 == this.executeMethod) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_resultsetGeneratedForUpdate"), null, false);
        }
    }

    void resetForReexecute() throws SQLServerException {
        this.processResponse();
        this.tdsReader = null;
        this.autoGeneratedKeys = null;
        this.updateCount = -1;
        this.procedureRetStatToken = null;
        this.sqlWarnings = null;
    }

    final boolean isSelect(String string) throws SQLServerException {
        this.checkClosed();
        String string2 = string.trim();
        char c2 = string2.charAt(0);
        if (c2 != 's' && c2 != 'S') {
            return false;
        }
        return string2.substring(0, 6).equalsIgnoreCase("select");
    }

    private HashMap parseColumns(String string) throws SQLServerException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        boolean bl2 = false;
        boolean bl3 = false;
        String string2 = "";
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            boolean bl4;
            String string3 = stringTokenizer.nextToken();
            if (string3.indexOf("(") >= 0 && !bl2) {
                bl2 = true;
                bl4 = SQLServerStatement.checkBalancedParenthesis(string3);
                if (!bl4) {
                    string2 = string2 + string3;
                }
                if (!bl4) continue;
                hashMap.put(new Integer(n2++), string3);
                continue;
            }
            if (bl2) {
                bl4 = SQLServerStatement.checkBalancedParenthesis(string2 = string2 + string3);
                if (!bl4) continue;
                bl2 = false;
                hashMap.put(new Integer(n2++), string2);
                string2 = "";
                continue;
            }
            hashMap.put(new Integer(n2++), string3);
        }
        if (bl2) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_errorProcessingComplexQuery"), null, true);
        }
        return hashMap;
    }

    private static boolean checkBalancedParenthesis(String string) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while ((n2 = string.indexOf("(", n2 + 1)) != -1) {
            ++n4;
        }
        while ((n3 = string.indexOf(")", n3 + 1)) != -1) {
            ++n5;
        }
        return n4 == n5;
    }

    static String replaceParameterWithString(String string, char c2, String string2) {
        int n2 = 0;
        while ((n2 = string.indexOf("" + c2)) >= 0) {
            string = string.substring(0, n2) + string2 + string.substring(n2 + 1, string.length());
        }
        return string;
    }

    static String replaceMarkerWithNull(String string) {
        if (string.indexOf("'") < 0) {
            String string2 = SQLServerStatement.replaceParameterWithString(string, '?', "null");
            return string2;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "'", true);
        boolean bl2 = true;
        String string3 = "";
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (string4.equals("'")) {
                string3 = string3 + "'";
                bl2 = !bl2;
                continue;
            }
            if (bl2) {
                String string5 = SQLServerStatement.replaceParameterWithString(string4, '?', "null");
                string3 = string3 + string5;
                continue;
            }
            string3 = string3 + string4;
        }
        return string3;
    }

    void checkClosed() throws SQLServerException {
        if (this.bIsClosed) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_statementIsClosed"), null, false);
        }
        this.connection.checkClosed();
    }

    public final int getMaxFieldSize() throws SQLServerException {
        this.checkClosed();
        return this.maxFieldSize;
    }

    public final void setMaxFieldSize(int n2) throws SQLServerException {
        this.checkClosed();
        if (n2 < 0) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidLength"));
            Object[] objectArray = new Object[]{new Integer(n2)};
            SQLServerException.makeFromDriverError(this.connection, this, messageFormat.format(objectArray), null, true);
        }
        this.maxFieldSize = n2;
    }

    public final int getMaxRows() throws SQLServerException {
        this.checkClosed();
        return this.maxRows;
    }

    public final void setMaxRows(int n2) throws SQLServerException {
        this.checkClosed();
        if (n2 < 0) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidRowcount"));
            Object[] objectArray = new Object[]{new Integer(n2)};
            SQLServerException.makeFromDriverError(this.connection, this, messageFormat.format(objectArray), null, true);
        }
        this.maxRows = n2;
    }

    public final void setEscapeProcessing(boolean bl2) throws SQLServerException {
        this.checkClosed();
        this.escapeProcessing = bl2;
    }

    public final int getQueryTimeout() throws SQLServerException {
        this.checkClosed();
        return this.queryTimeout;
    }

    public final void setQueryTimeout(int n2) throws SQLServerException {
        this.checkClosed();
        if (n2 < 0) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidQueryTimeOutValue"));
            Object[] objectArray = new Object[]{new Integer(n2)};
            SQLServerException.makeFromDriverError(this.connection, this, messageFormat.format(objectArray), null, true);
        }
        this.queryTimeout = n2;
    }

    public final void cancel() throws SQLServerException {
        this.checkClosed();
        if (null != this.currentCommand) {
            this.currentCommand.interrupt(SQLServerException.getErrString("R_queryCancelled"));
        }
    }

    public final SQLWarning getWarnings() throws SQLServerException {
        this.checkClosed();
        if (this.sqlWarnings == null) {
            return null;
        }
        return (SQLWarning)this.sqlWarnings.elementAt(0);
    }

    public final void clearWarnings() throws SQLServerException {
        this.checkClosed();
        this.sqlWarnings = null;
    }

    public final void setCursorName(String string) throws SQLServerException {
        this.checkClosed();
        this.cursorName = string;
    }

    final String getCursorName() {
        return this.cursorName;
    }

    public final ResultSet getResultSet() throws SQLServerException {
        this.checkClosed();
        return this.resultSet;
    }

    public final int getUpdateCount() throws SQLServerException {
        this.checkClosed();
        return this.updateCount;
    }

    final void processAttention(TDSReader tDSReader) throws SQLServerException {
        this.tdsReader = tDSReader;
        this.movePastResults();
    }

    void processResponse() throws SQLServerException {
        if (null != this.tdsReader) {
            this.movePastResults();
        }
    }

    final void movePastResults() throws SQLServerException {
        do {
            try {
                this.getNextResult();
            }
            catch (SQLServerException sQLServerException) {
                if (2 == sQLServerException.getDriverErrorCode()) continue;
                throw sQLServerException;
            }
        } while (this.moreResults);
    }

    public final boolean getMoreResults() throws SQLServerException {
        this.checkClosed();
        return this.getNextResult();
    }

    final boolean getNextResult() throws SQLServerException {
        if (null == this.tdsReader) {
            return false;
        }
        if (null != this.resultSet) {
            this.resultSet.close();
            this.resultSet = null;
        }
        this.updateCount = -1;
        if (!this.moreResults) {
            return false;
        }
        final class NextResult
        extends TDSTokenHandler {
            StreamColumns columnMetaDataToken;
            StreamDone rowCountDoneToken;
            int serverCursorId;
            int serverCursorRowCount;
            StreamDone stmtDoneToken;
            boolean executedSqlDirectly;

            NextResult() {
                super("getNextResult");
                this.columnMetaDataToken = null;
                this.rowCountDoneToken = null;
                this.serverCursorId = 0;
                this.serverCursorRowCount = -1;
                this.stmtDoneToken = null;
                this.executedSqlDirectly = false;
            }

            boolean onColMetaData(TDSReader tDSReader) throws SQLServerException {
                if (null != this.stmtDoneToken) {
                    return false;
                }
                if (null != this.getDatabaseError()) {
                    return false;
                }
                this.columnMetaDataToken = new StreamColumns();
                this.columnMetaDataToken.setFromTDS(tDSReader);
                return true;
            }

            boolean onRow(TDSReader tDSReader) throws SQLServerException {
                return false;
            }

            boolean onDone(TDSReader tDSReader) throws SQLServerException {
                if (null != this.columnMetaDataToken && (!SQLServerStatement.this.isServerSideCursor || this.executedSqlDirectly)) {
                    return false;
                }
                StreamDone streamDone = new StreamDone();
                streamDone.setFromTDS(tDSReader);
                if (streamDone.isAttnAck()) {
                    return false;
                }
                if (null != SQLServerStatement.this.resultSet && null == this.rowCountDoneToken) {
                    this.rowCountDoneToken = streamDone;
                    return true;
                }
                if (streamDone.hasUpdateCount()) {
                    this.stmtDoneToken = streamDone;
                    if (255 != streamDone.getTokenType()) {
                        return false;
                    }
                    if (null != SQLServerStatement.this.procedureName) {
                        return false;
                    }
                    if (!SQLServerStatement.this.useLastUpdateCount) {
                        return false;
                    }
                } else {
                    if (streamDone.isFinal()) {
                        return false;
                    }
                    if (4 == SQLServerStatement.this.executeMethod && (255 != streamDone.getTokenType() || streamDone.wasRPCInBatch())) {
                        return false;
                    }
                    if (224 == streamDone.getCurCmd() && null != this.stmtDoneToken && -1 != this.stmtDoneToken.getUpdateCount()) {
                        return false;
                    }
                }
                return true;
            }

            boolean onRetStatus(TDSReader tDSReader) throws SQLServerException {
                SQLServerStatement.this.procedureRetStatToken = new StreamRetStatus();
                SQLServerStatement.this.procedureRetStatToken.setFromTDS(tDSReader);
                return true;
            }

            boolean onRetValue(TDSReader tDSReader) throws SQLServerException {
                if (null == SQLServerStatement.this.procedureRetStatToken) {
                    Parameter parameter = new Parameter();
                    parameter.skipRetValStatus(tDSReader);
                    parameter.skipValue(tDSReader, true);
                    return true;
                }
                if (0 == SQLServerStatement.this.prepStmtHandle) {
                    Parameter parameter = new Parameter();
                    parameter.skipRetValStatus(tDSReader);
                    SQLServerStatement.this.prepStmtHandle = parameter.getInt(tDSReader);
                    parameter.skipValue(tDSReader, true);
                    if (stmtlogger.isLoggable(Level.FINE)) {
                        stmtlogger.fine(SQLServerStatement.this.toLogString() + ": Setting PreparedHandle:" + SQLServerStatement.this.prepStmtHandle);
                    }
                    --SQLServerStatement.this.prepexecOutParamCount;
                    return true;
                }
                if (SQLServerStatement.this.prepexecOutParamCount > 0) {
                    Parameter parameter = new Parameter();
                    parameter.skipRetValStatus(tDSReader);
                    this.serverCursorId = parameter.getInt(tDSReader);
                    parameter.skipValue(tDSReader, true);
                    --SQLServerStatement.this.prepexecOutParamCount;
                    parameter = new Parameter();
                    parameter.skipRetValStatus(tDSReader);
                    this.serverCursorRowCount = parameter.getInt(tDSReader);
                    parameter.skipValue(tDSReader, true);
                    --SQLServerStatement.this.prepexecOutParamCount;
                    return false;
                }
                if (4 == SQLServerStatement.this.executeMethod) {
                    Parameter parameter = new Parameter();
                    parameter.skipRetValStatus(tDSReader);
                    parameter.skipValue(tDSReader, true);
                    return true;
                }
                SQLServerStatement.this.moreResults = false;
                return false;
            }

            boolean onInfo(TDSReader tDSReader) throws SQLServerException {
                StreamInfo streamInfo = new StreamInfo();
                streamInfo.setFromTDS(tDSReader);
                if (16954 == streamInfo.msg.getErrorNumber()) {
                    this.executedSqlDirectly = true;
                }
                SQLWarning sQLWarning = new SQLWarning(streamInfo.msg.getMessage(), SQLServerException.generateStateCode(SQLServerStatement.this.connection, streamInfo.msg.getErrorNumber(), streamInfo.msg.getErrorState()), streamInfo.msg.getErrorNumber());
                if (SQLServerStatement.this.sqlWarnings == null) {
                    SQLServerStatement.this.sqlWarnings = new Vector();
                } else {
                    int n2 = SQLServerStatement.this.sqlWarnings.size();
                    SQLWarning sQLWarning2 = (SQLWarning)SQLServerStatement.this.sqlWarnings.elementAt(n2 - 1);
                    sQLWarning2.setNextWarning(sQLWarning);
                }
                SQLServerStatement.this.sqlWarnings.add(sQLWarning);
                return true;
            }

            void onEOF(TDSReader tDSReader) throws SQLServerException {
                SQLServerStatement.this.moreResults = false;
            }
        }
        NextResult nextResult = new NextResult();
        TDSParser.parse(this.tdsReader, nextResult);
        if (null != nextResult.getDatabaseError()) {
            SQLServerException.makeFromDatabaseError(this.connection, null, nextResult.getDatabaseError().getMessage(), nextResult.getDatabaseError(), false);
        } else if (null != nextResult.columnMetaDataToken) {
            this.resultSet = new SQLServerResultSet(this, nextResult.columnMetaDataToken.columns, nextResult.serverCursorId, nextResult.serverCursorRowCount);
        } else {
            this.updateCount = null != nextResult.stmtDoneToken ? nextResult.stmtDoneToken.getUpdateCount() : -1;
        }
        return null != this.resultSet;
    }

    public final void setFetchDirection(int n2) throws SQLServerException {
        this.checkClosed();
        if (1000 != n2 && 1001 != n2 && 1002 != n2 || 1000 != n2 && (2003 == this.resultSetType || 2004 == this.resultSetType)) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidFetchDirection"));
            Object[] objectArray = new Object[]{new Integer(n2)};
            SQLServerException.makeFromDriverError(this.connection, this, messageFormat.format(objectArray), null, false);
        }
        this.nFetchDirection = n2;
    }

    public final int getFetchDirection() throws SQLServerException {
        this.checkClosed();
        return this.nFetchDirection;
    }

    public final void setFetchSize(int n2) throws SQLServerException {
        this.checkClosed();
        if (n2 < 0) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_invalidFetchSize"), null, false);
        }
        this.nFetchSize = 0 == n2 ? this.defaultFetchSize : n2;
    }

    public final int getFetchSize() throws SQLServerException {
        this.checkClosed();
        return this.nFetchSize;
    }

    public final int getResultSetConcurrency() throws SQLServerException {
        this.checkClosed();
        return this.resultSetConcurrency;
    }

    public final int getResultSetType() throws SQLServerException {
        this.checkClosed();
        return this.appResultSetType;
    }

    public void addBatch(String string) throws SQLServerException {
        this.checkClosed();
        if (null == this.batchStatementBuffer) {
            this.batchStatementBuffer = new StringBuffer(262144);
        }
        if (0 == this.batchSize) {
            this.batchStatementBuffer.append(string);
        } else {
            this.batchStatementBuffer.append(" ; " + string);
        }
        ++this.batchSize;
    }

    public void clearBatch() throws SQLServerException {
        this.checkClosed();
        this.batchStatementBuffer = null;
        this.batchSize = 0;
    }

    /*
     * Exception decompiling
     */
    public int[] executeBatch() throws SQLServerException, BatchUpdateException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Missing node tying up JSR block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.tieUpRelations(Op02WithProcessedDataAndRefs.java:2900)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.copyBlock(Op02WithProcessedDataAndRefs.java:2889)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.inlineJSR(Op02WithProcessedDataAndRefs.java:2845)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSRs(Op02WithProcessedDataAndRefs.java:2591)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSR(Op02WithProcessedDataAndRefs.java:2481)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:444)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public final Connection getConnection() throws SQLServerException {
        this.checkClosed();
        return this.connection;
    }

    final int getResultSetScrollOpt() {
        int n2 = null == this.inOutParam ? 0 : 4096;
        switch (this.resultSetType) {
            case 2004: {
                return n2 | (1007 == this.resultSetConcurrency ? 16 : 4);
            }
            case 1006: {
                return n2 | 2;
            }
            case 1005: {
                return n2 | 1;
            }
            case 1004: {
                return n2 | 8;
            }
        }
        return 0;
    }

    final int getResultSetCCOpt() {
        switch (this.resultSetConcurrency) {
            case 1007: {
                return 8193;
            }
            case 1008: {
                return 24580;
            }
            case 1009: {
                return 24578;
            }
            case 1010: {
                return 24584;
            }
        }
        return 0;
    }

    private final void doExecuteCursored(StmtExecCmd stmtExecCmd, String string) throws SQLServerException {
        if (stmtlogger.isLoggable(Level.FINE)) {
            stmtlogger.fine(this.toLogString() + " Execute for cursor open" + " SQL:" + string + " Scrollability:" + this.getResultSetScrollOpt() + " Concurrency:" + this.getResultSetCCOpt());
        }
        this.prepexecOutParamCount = 2;
        TDSWriter tDSWriter = stmtExecCmd.startRequest((byte)3);
        tDSWriter.writeShort((short)-1);
        tDSWriter.writeShort((short)2);
        tDSWriter.writeByte((byte)0);
        tDSWriter.writeByte((byte)0);
        tDSWriter.writeRPCInt(null, new Integer(0), true);
        tDSWriter.writeRPCString(string);
        tDSWriter.writeRPCInt(null, new Integer(this.getResultSetScrollOpt()), false);
        tDSWriter.writeRPCInt(null, new Integer(this.getResultSetCCOpt()), false);
        tDSWriter.writeRPCInt(null, new Integer(0), true);
        this.tdsReader = stmtExecCmd.startResponse(this.isResponseBufferingAdaptive);
        this.moreResults = true;
        this.getNextResult();
    }

    public final int getResultSetHoldability() throws SQLServerException {
        this.checkClosed();
        return this.connection.getHoldability();
    }

    public final boolean execute(String string, int n2) throws SQLServerException {
        if (n2 != 1 && n2 != 2) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidAutoGeneratedKeys"));
            Object[] objectArray = new Object[]{new Integer(n2)};
            SQLServerException.makeFromDriverError(this.connection, this, messageFormat.format(objectArray), null, false);
        }
        this.checkClosed();
        this.executeStatement(new StmtExecCmd(this, string, 3, n2));
        return null != this.resultSet;
    }

    public final boolean execute(String string, int[] nArray) throws SQLServerException {
        if (nArray == null || nArray.length != 1) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_invalidColumnArrayLength"), null, false);
        }
        return this.execute(string, 1);
    }

    public final boolean execute(String string, String[] stringArray) throws SQLServerException {
        if (stringArray == null || stringArray.length != 1) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_invalidColumnArrayLength"), null, false);
        }
        return this.execute(string, 1);
    }

    public final int executeUpdate(String string, int n2) throws SQLServerException {
        if (n2 != 1 && n2 != 2) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidAutoGeneratedKeys"));
            Object[] objectArray = new Object[]{new Integer(n2)};
            SQLServerException.makeFromDriverError(this.connection, this, messageFormat.format(objectArray), null, false);
        }
        this.checkClosed();
        this.executeStatement(new StmtExecCmd(this, string, 2, n2));
        return this.updateCount;
    }

    public final int executeUpdate(String string, int[] nArray) throws SQLServerException {
        if (nArray == null || nArray.length != 1) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_invalidColumnArrayLength"), null, false);
        }
        return this.executeUpdate(string, 1);
    }

    public final int executeUpdate(String string, String[] stringArray) throws SQLServerException {
        if (stringArray == null || stringArray.length != 1) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_invalidColumnArrayLength"), null, false);
        }
        return this.executeUpdate(string, 1);
    }

    public final ResultSet getGeneratedKeys() throws SQLServerException {
        this.checkClosed();
        if (null == this.autoGeneratedKeys) {
            int n2 = this.updateCount;
            boolean bl2 = this.getNextResult();
            if (bl2) {
                this.autoGeneratedKeys = this.getResultSet();
            }
            this.updateCount = n2;
            if (!bl2 || null == this.autoGeneratedKeys) {
                SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_statementMustBeExecuted"), null, false);
            }
        }
        return this.autoGeneratedKeys;
    }

    public final boolean getMoreResults(int n2) throws SQLServerException {
        if (2 == n2) {
            this.NotImplemented();
        }
        if (1 != n2 && 3 != n2) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_modeSuppliedNotValid"), null, true);
        }
        this.checkClosed();
        SQLServerResultSet sQLServerResultSet = this.resultSet;
        boolean bl2 = this.getMoreResults();
        if (sQLServerResultSet != null) {
            try {
                sQLServerResultSet.close();
            }
            catch (SQLException sQLException) {
                throw new SQLServerException(null, sQLException.getMessage(), null, 0, false);
            }
        }
        return bl2;
    }

    public final void setResponseBuffering(String string) throws SQLServerException {
        if (string.equalsIgnoreCase("full")) {
            this.isResponseBufferingAdaptive = false;
            this.wasResponseBufferingSet = true;
        } else if (string.equalsIgnoreCase("adaptive")) {
            this.isResponseBufferingAdaptive = true;
            this.wasResponseBufferingSet = true;
        } else {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidresponseBuffering"));
            Object[] objectArray = new Object[]{new String(string)};
            SQLServerException.makeFromDriverError(this.connection, this, messageFormat.format(objectArray), null, false);
        }
    }

    public final String getResponseBuffering() {
        if (this.wasResponseBufferingSet) {
            if (this.isResponseBufferingAdaptive) {
                return "adaptive";
            }
            return "full";
        }
        return this.connection.getResponseBuffering();
    }

    private final class StmtExecCmd
    extends TDSCommand {
        final SQLServerStatement stmt;
        final String sql;
        final int executeMethod;
        final int autoGeneratedKeys;

        StmtExecCmd(SQLServerStatement sQLServerStatement2, String string, int n2, int n3) {
            super(sQLServerStatement2.toLogString() + " executeXXX", sQLServerStatement2.queryTimeout);
            this.stmt = sQLServerStatement2;
            this.sql = string;
            this.executeMethod = n2;
            this.autoGeneratedKeys = n3;
        }

        final boolean doExecute() throws SQLServerException {
            this.stmt.doExecuteStatement(this);
            return false;
        }

        final void onAttention(TDSReader tDSReader) throws SQLServerException {
            SQLServerStatement.this.processAttention(tDSReader);
            super.onAttention(tDSReader);
        }
    }
}

