/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.TDSReader;
import com.microsoft.sqlserver.jdbc.TDSWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;

final class TDSChannel {
    private static Logger logger = Logger.getLogger("com.microsoft.sqlserver.jdbc.TDSChannel");
    private final boolean isLoggable = logger.isLoggable(Level.FINEST);
    private final SQLServerConnection con;
    private TDSWriter tdsWriter;
    private Socket socket;
    private boolean isClosed;
    private InputStream inputStream;
    private OutputStream outputStream;
    private static Logger packetLogger = Logger.getLogger("com.microsoft.sqlserver.jdbc.TDS.DATA");
    private final boolean isLoggingPackets = packetLogger.isLoggable(Level.FINEST);
    int numMsgsSent = 0;
    int numMsgsRcvd = 0;

    final String toLogString() {
        return "TDSChannel (" + this.con.toLogString() + ")";
    }

    final TDSWriter getWriter() {
        if (null == this.tdsWriter) {
            this.tdsWriter = new TDSWriter(this, this.con);
        }
        return this.tdsWriter;
    }

    final TDSReader getReader() {
        return new TDSReader(this, this.con);
    }

    private final void checkClosed() throws SQLServerException {
        if (this.isClosed) {
            SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_connectionIsClosed"), null, false);
        }
    }

    private final synchronized InputStream getInputStream() throws SQLServerException {
        this.checkClosed();
        return this.inputStream;
    }

    private final synchronized OutputStream getOutputStream() throws SQLServerException {
        this.checkClosed();
        return this.outputStream;
    }

    final void setSendBufferSize(int n2) {
        try {
            this.socket.setSendBufferSize(n2);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    final void setRecvBufferSize(int n2) {
        try {
            this.socket.setReceiveBufferSize(n2);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    final boolean isLoggingPackets() {
        return this.isLoggingPackets;
    }

    TDSChannel(SQLServerConnection sQLServerConnection) {
        this.con = sQLServerConnection;
        this.isClosed = false;
        this.socket = null;
        this.inputStream = null;
        this.outputStream = null;
    }

    final void open(String string, int n2, int n3) throws IOException {
        if (0 == n3) {
            this.socket = new Socket(string, n2);
        } else {
            this.socket = new Socket();
            InetSocketAddress inetSocketAddress = new InetSocketAddress(string, n2);
            if (inetSocketAddress.isUnresolved()) {
                throw new UnknownHostException();
            }
            this.socket.connect(inetSocketAddress, n3);
        }
        this.setSendBufferSize(4096);
        this.setRecvBufferSize(4096);
        this.socket.setTcpNoDelay(true);
        this.socket.setKeepAlive(true);
        this.inputStream = this.socket.getInputStream();
        this.outputStream = this.socket.getOutputStream();
    }

    final int read(byte[] byArray, int n2, int n3) throws SQLServerException {
        try {
            return this.getInputStream().read(byArray, n2, n3);
        }
        catch (IOException iOException) {
            SQLServerException.makeFromDriverError(this.con, null, iOException.getMessage(), "08006", true);
            return 0;
        }
    }

    final void write(byte[] byArray, int n2, int n3) throws SQLServerException {
        try {
            this.getOutputStream().write(byArray, n2, n3);
        }
        catch (IOException iOException) {
            SQLServerException.makeFromDriverError(this.con, null, iOException.getMessage(), "08006", true);
        }
    }

    final void flush() throws SQLServerException {
        try {
            this.getOutputStream().flush();
        }
        catch (IOException iOException) {
            SQLServerException.makeFromDriverError(this.con, null, iOException.getMessage(), "08006", true);
        }
    }

    final synchronized void close() {
        if (null != this.inputStream) {
            block12: {
                if (this.isLoggable) {
                    logger.finest(this.toLogString() + ": Closing inputStream...");
                }
                try {
                    this.inputStream.close();
                }
                catch (IOException iOException) {
                    if (!this.isLoggable) break block12;
                    logger.log(Level.WARNING, this.toLogString() + ": Ignored error closing inputStream", iOException);
                }
            }
            this.inputStream = null;
        }
        if (null != this.outputStream) {
            block13: {
                if (this.isLoggable) {
                    logger.finest(this.toLogString() + ": Closing outputStream...");
                }
                try {
                    this.outputStream.close();
                }
                catch (IOException iOException) {
                    if (!this.isLoggable) break block13;
                    logger.log(Level.WARNING, this.toLogString() + ": Ignored error closing outputStream", iOException);
                }
            }
            this.outputStream = null;
        }
        if (null != this.socket) {
            block14: {
                if (this.isLoggable) {
                    logger.finest(this.toLogString() + ": Closing socket...");
                }
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {
                    if (!this.isLoggable) break block14;
                    logger.log(Level.WARNING, this.toLogString() + ": Ignored error closing socket", iOException);
                }
            }
            this.socket = null;
        }
        this.isClosed = true;
    }

    void logPacket(byte[] byArray, int n2, int n3, String string) {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] cArray2 = new char[]{'.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.'};
        char[] cArray3 = new char[]{' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.'};
        char[] cArray4 = new char[cArray3.length];
        System.arraycopy(cArray3, 0, cArray4, 0, cArray3.length);
        StringBuffer stringBuffer = new StringBuffer(string.length() + 4 * n3 + 4 * (1 + n3 / 16) + 80);
        stringBuffer.append(this.socket.getLocalAddress().toString() + ":" + this.socket.getLocalPort() + " " + string + "\r\n");
        int n4 = 0;
        while (true) {
            int n5;
            int n6;
            for (n6 = 0; n6 < 16 && n4 < n3; ++n6, ++n4) {
                n5 = (byArray[n2 + n4] + 256) % 256;
                cArray4[3 * n6] = cArray[n5 / 16];
                cArray4[3 * n6 + 1] = cArray[n5 % 16];
                cArray4[50 + n6] = cArray2[n5];
            }
            for (n5 = n6; n5 < 16; ++n5) {
                cArray4[3 * n5] = 32;
                cArray4[3 * n5 + 1] = 32;
            }
            stringBuffer.append(cArray4, 0, 50 + n6);
            if (n4 == n3) break;
            stringBuffer.append("\r\n");
        }
        packetLogger.finest(stringBuffer.toString());
    }
}

