/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.TDSParser;
import com.microsoft.sqlserver.jdbc.TDSReader;
import com.microsoft.sqlserver.jdbc.TDSWriter;
import com.microsoft.sqlserver.jdbc.TimeoutTimer;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;

abstract class TDSCommand {
    private static Logger logger;
    private final boolean isLoggable = logger.isLoggable(Level.FINEST);
    private final String logContext;
    private final TimeoutTimer timeoutTimer;
    private TDSWriter tdsWriter;
    private TDSReader tdsReader;
    private static final int NOT_STARTED = 0;
    private static final int REQUEST = 1;
    private static final int EXECUTION = 2;
    private static final int RESPONSE = 3;
    private static final int DONE = 4;
    private volatile int state;
    private String interruptReason;
    static final /* synthetic */ boolean $assertionsDisabled;

    final String getLogContext() {
        return this.logContext;
    }

    final String toLogString() {
        return "TDSCommand@" + Integer.toHexString(this.hashCode()) + " (" + this.logContext + ")";
    }

    TDSCommand(String string, int n2) {
        this.logContext = string;
        this.timeoutTimer = n2 > 0 ? new TimeoutTimer(n2, this) : null;
        this.state = 0;
        this.interruptReason = null;
    }

    private final String getStateString(int n2) {
        switch (n2) {
            case 0: {
                return "NOT_STARTED";
            }
            case 1: {
                return "REQUEST";
            }
            case 2: {
                return "EXECUTION";
            }
            case 3: {
                return "RESPONSE";
            }
            case 4: {
                return "DONE";
            }
        }
        return "UNKNOWN";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setState(int n2) {
        if (this.isLoggable) {
            logger.finest(this.toLogString() + ": Changing state from " + this.getStateString(this.state) + " to " + this.getStateString(n2));
        }
        TDSCommand tDSCommand = this;
        synchronized (tDSCommand) {
            this.state = n2;
        }
    }

    abstract boolean doExecute() throws SQLServerException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean execute(TDSWriter tDSWriter, TDSReader tDSReader) throws SQLServerException {
        block11: {
            this.tdsWriter = tDSWriter;
            this.tdsReader = tDSReader;
            try {
                if (!this.doExecute()) break block11;
                TDSCommand tDSCommand = this;
                synchronized (tDSCommand) {
                    if (null != this.interruptReason) {
                        if (this.isLoggable) {
                            logger.finest(this.toLogString() + ": execute throwing interrupt exception, reason=" + this.interruptReason);
                        }
                        this.throwInterruptReason();
                    }
                    this.setState(4);
                }
            }
            catch (SQLServerException sQLServerException) {
                block12: {
                    if (1 == sQLServerException.getDriverErrorCode() && tDSWriter.attentionSent()) {
                        try {
                            this.onAttention(tDSReader);
                        }
                        catch (SQLException sQLException) {
                            if (!this.isLoggable) break block12;
                            logger.finest(this.toLogString() + ": Ignoring inner exception: " + sQLException.getMessage());
                        }
                    }
                }
                this.setState(4);
                throw sQLServerException;
            }
        }
        if (!$assertionsDisabled && 3 != this.state && 4 != this.state) {
            throw new AssertionError();
        }
        return 4 == this.state;
    }

    void onAttention(TDSReader tDSReader) throws SQLServerException {
        tDSReader.readPacket();
        TDSParser.parse(tDSReader, this.getLogContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void detach() throws SQLServerException {
        if (3 != this.state) {
            return;
        }
        if (this.isLoggable) {
            logger.finest(this.toLogString() + ": detaching...");
        }
        try {
            this.tdsReader.readResponse();
        }
        finally {
            this.setState(4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void interrupt(String string) throws SQLServerException {
        TDSCommand tDSCommand = this;
        synchronized (tDSCommand) {
            if (null != this.interruptReason) {
                return;
            }
            switch (this.state) {
                case 0: {
                    if (!this.isLoggable) break;
                    logger.finest(this.toLogString() + ": NOT_STARTED: Ignoring interrupt, reason=" + string);
                    break;
                }
                case 1: {
                    if (this.isLoggable) {
                        logger.finest(this.toLogString() + ": REQUEST: Raising attention, reason=" + string);
                    }
                    this.interruptReason = string;
                    this.tdsWriter.raiseAttention(string);
                    break;
                }
                case 2: {
                    if (this.isLoggable) {
                        logger.finest(this.toLogString() + ": EXECUTION: Sending attention, reason=" + string);
                    }
                    this.interruptReason = string;
                    this.tdsWriter.sendAttention();
                    break;
                }
                case 3: {
                    if (this.isLoggable) {
                        logger.finest(this.toLogString() + ": RESPONSE: Sending attention, reason=" + string);
                    }
                    this.interruptReason = string;
                    this.tdsWriter.sendAttention();
                    break;
                }
                case 4: {
                    if (!this.isLoggable) break;
                    logger.finest(this.toLogString() + ": DONE: Ignoring interrupt, reason=" + string);
                }
            }
        }
    }

    final TDSWriter startRequest(byte by) throws SQLServerException {
        TDSCommand tDSCommand = this;
        synchronized (tDSCommand) {
            this.interruptReason = null;
            if (this.isLoggable) {
                logger.finest(this.toLogString() + ": Starting request...");
            }
            this.setState(1);
            try {
                return this.tdsWriter.startMessage(by);
            }
            catch (SQLServerException sQLServerException) {
                if (this.isLoggable) {
                    logger.finest(this.toLogString() + ": Exception starting request: " + sQLServerException.getMessage());
                }
                this.setState(4);
                throw sQLServerException;
            }
        }
    }

    final TDSReader startResponse() throws SQLServerException {
        return this.startResponse(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final TDSReader startResponse(boolean bl2) throws SQLServerException {
        TDSCommand tDSCommand = this;
        synchronized (tDSCommand) {
            if (!$assertionsDisabled && 1 != this.state) {
                throw new AssertionError();
            }
            if (this.isLoggable) {
                logger.finest(this.toLogString() + ": Finishing request...");
            }
            try {
                this.tdsWriter.endMessage();
            }
            catch (SQLServerException sQLServerException) {
                if (this.isLoggable) {
                    logger.finest(this.toLogString() + ": Exception finishing request: " + sQLServerException.getMessage());
                }
                this.setState(4);
                throw sQLServerException;
            }
            this.setState(2);
        }
        if (null != this.timeoutTimer) {
            if (this.isLoggable) {
                logger.finest(this.toLogString() + ": Starting timer...");
            }
            this.timeoutTimer.start();
        }
        if (this.isLoggable) {
            logger.finest(this.toLogString() + ": Reading response...");
        }
        try {
            block26: {
                try {
                    this.tdsReader.readPacket();
                    if (bl2) break block26;
                    this.tdsReader.readResponse();
                }
                catch (SQLServerException sQLServerException) {
                    if (this.isLoggable) {
                        logger.finest(this.toLogString() + ": Exception reading response: " + sQLServerException.getMessage());
                    }
                    this.setState(4);
                    throw sQLServerException;
                }
            }
            Object var6_6 = null;
            if (null != this.timeoutTimer) {
                if (this.isLoggable) {
                    logger.finest(this.toLogString() + ": Stopping timer...");
                }
                this.timeoutTimer.stop();
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (null != this.timeoutTimer) {
                if (this.isLoggable) {
                    logger.finest(this.toLogString() + ": Stopping timer...");
                }
                this.timeoutTimer.stop();
            }
            throw throwable;
        }
        tDSCommand = this;
        synchronized (tDSCommand) {
            if (!$assertionsDisabled && 2 != this.state) {
                throw new AssertionError();
            }
            this.setState(this.tdsReader.responseEOM() ? 4 : 3);
            if (null != this.interruptReason) {
                if (this.isLoggable) {
                    logger.finest(this.toLogString() + ": startResponse throwing interrupt exception, reason=" + this.interruptReason);
                }
                this.throwInterruptReason();
            }
        }
        return this.tdsReader;
    }

    private final void throwInterruptReason() throws SQLServerException {
        SQLServerException sQLServerException = new SQLServerException(null, this.interruptReason, null, 0, false);
        sQLServerException.setDriverErrorCode(1);
        throw sQLServerException;
    }

    static {
        $assertionsDisabled = !TDSCommand.class.desiredAssertionStatus();
        logger = Logger.getLogger("com.microsoft.sqlserver.jdbc.TDSCommand");
    }
}

