/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.DataTypes;
import com.microsoft.sqlserver.jdbc.SQLCollation;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.TDSReader;
import com.microsoft.sqlserver.jdbc.UDTTDSHeader;
import com.microsoft.sqlserver.jdbc.XMLTDSHeader;
import java.text.MessageFormat;

final class TypeInfo {
    private int userType;
    private boolean isNullable;
    private int tdsType;
    private int nativeType;
    private int maxLength;
    private int valueLengthSize;
    private int precision;
    private int scale;
    private short flags;
    private boolean isPLPType;
    private UDTTDSHeader udtTDSHeader;
    private XMLTDSHeader xmlTDSHeader;
    private SQLCollation collation;
    static int UPDATABLE_READ_ONLY = 0;
    static int UPDATABLE_READ_WRITE = 1;
    static int UPDATABLE_UNKNOWN = 2;

    TypeInfo() {
    }

    int getTDSType() {
        return this.tdsType;
    }

    int getUserType() {
        return this.userType;
    }

    int getNativeType() {
        return this.nativeType;
    }

    int getMaxLength() {
        return this.maxLength;
    }

    int getValueLengthSize() {
        return this.valueLengthSize;
    }

    int getPrecision() {
        return this.precision;
    }

    int getScale() {
        return this.scale;
    }

    SQLCollation getSQLCollation() {
        return this.collation;
    }

    boolean isPLPType() {
        return this.isPLPType;
    }

    UDTTDSHeader getUDTTDSHeader() {
        return this.udtTDSHeader;
    }

    boolean isNullable() {
        return 1 == (this.flags & 1);
    }

    boolean isCaseSensitive() {
        return 2 == (this.flags & 2);
    }

    int getUpdatability() {
        return this.flags >> 2 & 3;
    }

    boolean isIdentity() {
        return 16 == (this.flags & 0x10);
    }

    void setFromTDS(TDSReader tDSReader) throws SQLServerException {
        this.userType = 0;
        this.tdsType = 0;
        this.nativeType = 0;
        this.maxLength = 0;
        this.valueLengthSize = 0;
        this.precision = 0;
        this.scale = 0;
        this.isPLPType = false;
        this.udtTDSHeader = null;
        this.xmlTDSHeader = null;
        this.userType = tDSReader.getConnection().isYukonOrLater() ? tDSReader.readInt() : (int)tDSReader.readShort();
        this.flags = tDSReader.readShort();
        boolean bl2 = false;
        boolean bl3 = false;
        this.tdsType = tDSReader.readUnsignedByte();
        switch (this.tdsType) {
            case 60: 
            case 61: 
            case 62: 
            case 127: {
                this.maxLength = 8;
                break;
            }
            case 56: 
            case 58: 
            case 59: 
            case 122: {
                this.maxLength = 4;
                break;
            }
            case 52: {
                this.maxLength = 2;
                break;
            }
            case 48: 
            case 50: {
                this.maxLength = 1;
                break;
            }
            case 106: 
            case 108: {
                bl3 = true;
            }
            case 36: 
            case 38: 
            case 104: 
            case 109: 
            case 110: 
            case 111: {
                this.valueLengthSize = 1;
                break;
            }
            case 167: 
            case 175: 
            case 231: 
            case 239: {
                bl2 = true;
            }
            case 165: 
            case 173: {
                this.valueLengthSize = 2;
                break;
            }
            case 35: 
            case 99: {
                bl2 = true;
            }
            case 34: {
                this.valueLengthSize = 4;
                break;
            }
            case 240: {
                this.isPLPType = true;
                this.udtTDSHeader = new UDTTDSHeader(tDSReader);
                this.maxLength = 8000;
                break;
            }
            case 241: {
                this.isPLPType = true;
                this.xmlTDSHeader = new XMLTDSHeader(tDSReader);
                break;
            }
            case 98: {
                SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_variantNotSupported"), null, false);
            }
            default: {
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_unknownNativeType"));
                Object[] objectArray = new Object[]{new Integer(this.tdsType)};
                SQLServerException.makeFromDriverError(null, null, messageFormat.format(objectArray), null, false);
            }
        }
        if (1 == this.valueLengthSize) {
            this.maxLength = tDSReader.readUnsignedByte();
        } else if (2 == this.valueLengthSize) {
            this.maxLength = tDSReader.readUnsignedShort();
            if (65535 == this.maxLength && (167 == this.tdsType || 231 == this.tdsType || 165 == this.tdsType)) {
                this.isPLPType = true;
            }
        } else if (4 == this.valueLengthSize) {
            this.maxLength = tDSReader.readInt();
        }
        if (bl2) {
            this.collation = new SQLCollation(tDSReader);
        }
        if (bl3) {
            this.precision = tDSReader.readUnsignedByte();
            this.scale = tDSReader.readUnsignedByte();
        } else {
            this.setPrecisionAndScaleFromType();
        }
        this.nativeType = DataTypes.deriveType(this.tdsType, this.maxLength);
    }

    private void setPrecisionAndScaleFromType() {
        switch (this.tdsType) {
            case 34: 
            case 35: {
                this.precision = Integer.MAX_VALUE;
                break;
            }
            case 99: 
            case 241: {
                this.precision = 0x3FFFFFFF;
                break;
            }
            case 173: 
            case 175: 
            case 240: {
                this.precision = this.maxLength;
                break;
            }
            case 239: {
                this.precision = this.maxLength / 2;
                break;
            }
            case 165: 
            case 167: {
                this.precision = 65535 == this.maxLength ? Integer.MAX_VALUE : this.maxLength;
                break;
            }
            case 231: {
                this.precision = (65535 == this.maxLength ? Integer.MAX_VALUE : this.maxLength) / 2;
                break;
            }
            case 50: 
            case 104: {
                this.precision = 1;
                break;
            }
            case 36: {
                this.precision = 36;
                break;
            }
            case 38: 
            case 48: 
            case 52: 
            case 56: 
            case 127: {
                if (8 == this.maxLength) {
                    this.precision = 19;
                    break;
                }
                if (4 == this.maxLength) {
                    this.precision = 10;
                    break;
                }
                if (2 == this.maxLength) {
                    this.precision = 5;
                    break;
                }
                if (1 != this.maxLength) break;
                this.precision = 3;
                break;
            }
            case 60: 
            case 110: 
            case 122: {
                if (8 == this.maxLength) {
                    this.precision = 19;
                } else if (4 == this.maxLength) {
                    this.precision = 10;
                }
                this.scale = 4;
                break;
            }
            case 59: 
            case 62: 
            case 109: {
                if (8 == this.maxLength) {
                    this.precision = 15;
                    break;
                }
                if (4 != this.maxLength) break;
                this.precision = 7;
                break;
            }
            case 58: 
            case 61: 
            case 111: {
                if (8 == this.maxLength) {
                    this.precision = 23;
                    this.scale = 3;
                    break;
                }
                if (4 != this.maxLength) break;
                this.precision = 16;
                this.scale = 0;
            }
        }
    }

    String getCharset() throws SQLServerException {
        if (null == this.collation) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_charSetNotAvailableForColumn"));
            Object[] objectArray = new Object[]{new Integer(0)};
            throw new SQLServerException(null, messageFormat.format(objectArray), null, 0, false);
        }
        return this.collation.getCharset();
    }
}

