/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.Messages;

public class Constants {
    public static final byte[] EMPTY_BYTE_ARRAY;
    public static final String MILLIS_I18N;
    public static final byte[] SLASH_STAR_SPACE_AS_BYTES;
    public static final byte[] SPACE_STAR_SLASH_SPACE_AS_BYTES;
    private static final Character[] CHARACTER_CACHE;
    private static final int BYTE_CACHE_OFFSET = 128;
    private static final Byte[] BYTE_CACHE;
    private static final int INTEGER_CACHE_OFFSET = 128;
    private static final Integer[] INTEGER_CACHE;
    private static final int SHORT_CACHE_OFFSET = 128;
    private static final Short[] SHORT_CACHE;
    private static final Long[] LONG_CACHE;
    private static final int LONG_CACHE_OFFSET = 128;

    public static Character characterValueOf(char c2) {
        if (c2 <= '\u007f') {
            return CHARACTER_CACHE[c2];
        }
        return new Character(c2);
    }

    public static final Byte byteValueOf(byte b2) {
        return BYTE_CACHE[b2 + 128];
    }

    public static final Integer integerValueOf(int i2) {
        if (i2 >= -128 && i2 <= 127) {
            return INTEGER_CACHE[i2 + 128];
        }
        return new Integer(i2);
    }

    public static Short shortValueOf(short s2) {
        if (s2 >= -128 && s2 <= 127) {
            return SHORT_CACHE[s2 + 128];
        }
        return new Short(s2);
    }

    public static final Long longValueOf(long l2) {
        if (l2 >= -128L && l2 <= 127L) {
            return LONG_CACHE[(int)l2 + 128];
        }
        return new Long(l2);
    }

    private Constants() {
    }

    static {
        int i2;
        EMPTY_BYTE_ARRAY = new byte[0];
        MILLIS_I18N = Messages.getString("Milliseconds");
        SLASH_STAR_SPACE_AS_BYTES = new byte[]{47, 42, 32};
        SPACE_STAR_SLASH_SPACE_AS_BYTES = new byte[]{32, 42, 47, 32};
        CHARACTER_CACHE = new Character[128];
        BYTE_CACHE = new Byte[256];
        INTEGER_CACHE = new Integer[256];
        SHORT_CACHE = new Short[256];
        LONG_CACHE = new Long[256];
        for (i2 = 0; i2 < CHARACTER_CACHE.length; ++i2) {
            Constants.CHARACTER_CACHE[i2] = new Character((char)i2);
        }
        for (i2 = 0; i2 < INTEGER_CACHE.length; ++i2) {
            Constants.INTEGER_CACHE[i2] = new Integer(i2 - 128);
        }
        for (i2 = 0; i2 < SHORT_CACHE.length; ++i2) {
            Constants.SHORT_CACHE[i2] = new Short((short)(i2 - 128));
        }
        for (i2 = 0; i2 < LONG_CACHE.length; ++i2) {
            Constants.LONG_CACHE[i2] = new Long(i2 - 128);
        }
        for (i2 = 0; i2 < BYTE_CACHE.length; ++i2) {
            Constants.BYTE_CACHE[i2] = new Byte((byte)(i2 - 128));
        }
    }
}

