/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleResultSetMetaData;
import oracle.jdbc.driver.OracleReturnResultSet;

class AutoKeyInfo
extends OracleResultSetMetaData {
    String originalSql;
    String newSql;
    String tableName;
    String[] columnNames;
    int[] columnIndexes;
    int numColumns;
    String[] tableColumnNames;
    int[] tableColumnTypes;
    int[] tableMaxLengths;
    boolean[] tableNullables;
    short[] tableFormOfUses;
    int[] tablePrecisions;
    int[] tableScales;
    String[] tableTypeNames;
    int autoKeyType;
    static final int KEYFLAG = 0;
    static final int COLUMNAME = 1;
    static final int COLUMNINDEX = 2;
    int[] returnTypes;
    Accessor[] returnAccessors;

    AutoKeyInfo(String string) {
        this.originalSql = string;
        this.autoKeyType = 0;
    }

    AutoKeyInfo(String string, int[] nArray) {
        this.originalSql = string;
        this.columnIndexes = nArray;
        this.autoKeyType = 2;
    }

    AutoKeyInfo(String string, String[] stringArray) {
        this.originalSql = string;
        this.columnNames = stringArray;
        this.autoKeyType = 1;
    }

    void allocateSpaceForDescribedData(int n2) throws SQLException {
        this.numColumns = n2;
        this.tableColumnNames = new String[n2];
        this.tableColumnTypes = new int[n2];
        this.tableMaxLengths = new int[n2];
        this.tableNullables = new boolean[n2];
        this.tableFormOfUses = new short[n2];
        this.tablePrecisions = new int[n2];
        this.tableScales = new int[n2];
        this.tableTypeNames = new String[n2];
    }

    void fillDescribedData(int n2, String string, int n3, int n4, boolean bl2, short s2, int n5, int n6, String string2) throws SQLException {
        this.tableColumnNames[n2] = string;
        this.tableColumnTypes[n2] = n3;
        this.tableMaxLengths[n2] = n4;
        this.tableNullables[n2] = bl2;
        this.tableFormOfUses[n2] = s2;
        this.tablePrecisions[n2] = n5;
        this.tableScales[n2] = n6;
        this.tableTypeNames[n2] = string2;
    }

    public int getColumnCount() throws SQLException {
        return this.returnAccessors.length;
    }

    public String getColumnName(int n2) throws SQLException {
        if (n2 <= 0 || n2 > this.returnAccessors.length) {
            DatabaseError.throwSqlException(3);
        }
        return this.returnAccessors[n2 - 1].columnName;
    }

    Accessor[] getDescription() throws SQLException {
        return this.returnAccessors;
    }

    String getNewSql() throws SQLException {
        if (this.newSql != null) {
            return this.newSql;
        }
        switch (this.autoKeyType) {
            case 0: {
                this.newSql = String.valueOf(this.originalSql) + " RETURNING ROWID INTO ?";
                this.returnTypes = new int[1];
                this.returnTypes[0] = 104;
                return this.newSql;
            }
            case 1: {
                return this.getNewSqlByColumnName();
            }
            case 2: {
                return this.getNewSqlByColumnIndexes();
            }
        }
        DatabaseError.throwSqlException(89);
        return null;
    }

    private String getNewSqlByColumnIndexes() throws SQLException {
        this.returnTypes = new int[this.columnIndexes.length];
        StringBuffer stringBuffer = new StringBuffer(this.originalSql);
        stringBuffer.append(" RETURNING ");
        int n2 = 0;
        while (n2 < this.columnIndexes.length) {
            int n3 = this.columnIndexes[n2] - 1;
            if (n3 < 0 || n3 > this.tableColumnNames.length) {
                DatabaseError.throwSqlException(68);
            }
            int n4 = this.tableColumnTypes[n3];
            String string = this.tableColumnNames[n3];
            this.returnTypes[n2] = n4;
            stringBuffer.append(string);
            if (n2 < this.columnIndexes.length - 1) {
                stringBuffer.append(", ");
            }
            ++n2;
        }
        stringBuffer.append(" INTO ");
        n2 = 0;
        while (n2 < this.columnIndexes.length - 1) {
            stringBuffer.append("?, ");
            ++n2;
        }
        stringBuffer.append("?");
        this.newSql = new String(stringBuffer);
        return this.newSql;
    }

    private String getNewSqlByColumnName() throws SQLException {
        this.returnTypes = new int[this.columnNames.length];
        this.columnIndexes = new int[this.columnNames.length];
        StringBuffer stringBuffer = new StringBuffer(this.originalSql);
        stringBuffer.append(" RETURNING ");
        int n2 = 0;
        while (n2 < this.columnNames.length) {
            int n3;
            this.returnTypes[n2] = n3 = this.getReturnParamTypeCode(n2, this.columnNames[n2], this.columnIndexes);
            stringBuffer.append(this.columnNames[n2]);
            if (n2 < this.columnNames.length - 1) {
                stringBuffer.append(", ");
            }
            ++n2;
        }
        stringBuffer.append(" INTO ");
        n2 = 0;
        while (n2 < this.columnNames.length - 1) {
            stringBuffer.append("?, ");
            ++n2;
        }
        stringBuffer.append("?");
        this.newSql = new String(stringBuffer);
        return this.newSql;
    }

    private final int getReturnParamTypeCode(int n2, String string, int[] nArray) throws SQLException {
        int n3 = 0;
        while (n3 < this.tableColumnNames.length) {
            if (string.equalsIgnoreCase(this.tableColumnNames[n3])) {
                nArray[n2] = n3 + 1;
                return this.tableColumnTypes[n3];
            }
            ++n3;
        }
        DatabaseError.throwSqlException(68);
        return -1;
    }

    String getTableName() throws SQLException {
        if (this.tableName != null) {
            return this.tableName;
        }
        String string = this.originalSql.trim().toUpperCase();
        int n2 = string.indexOf("INSERT");
        if ((n2 = string.indexOf("INTO", n2)) < 0) {
            DatabaseError.throwSqlException(68);
        }
        int n3 = string.length();
        int n4 = n2 + 5;
        while (n4 < n3 && string.charAt(n4) == ' ') {
            ++n4;
        }
        if (n4 >= n3) {
            DatabaseError.throwSqlException(68);
        }
        int n5 = n4 + 1;
        while (n5 < n3 && string.charAt(n5) != ' ' && string.charAt(n5) != '(') {
            ++n5;
        }
        if (n4 == n5 - 1) {
            DatabaseError.throwSqlException(68);
        }
        this.tableName = string.substring(n4, n5);
        return this.tableName;
    }

    public String getTableName(int n2) throws SQLException {
        if (n2 <= 0 || n2 > this.returnAccessors.length) {
            DatabaseError.throwSqlException(3);
        }
        return this.getTableName();
    }

    int getValidColumnIndex(int n2) throws SQLException {
        if (n2 <= 0 || n2 > this.returnAccessors.length) {
            DatabaseError.throwSqlException(3);
        }
        return n2 - 1;
    }

    void initMetaData(OracleReturnResultSet oracleReturnResultSet) throws SQLException {
        if (this.returnAccessors != null) {
            return;
        }
        this.returnAccessors = oracleReturnResultSet.returnAccessors;
        switch (this.autoKeyType) {
            case 0: {
                this.initMetaDataKeyFlag();
                break;
            }
            case 1: 
            case 2: {
                this.initMetaDataColumnIndexes();
                break;
            }
        }
    }

    void initMetaDataColumnIndexes() throws SQLException {
        int n2 = 0;
        while (n2 < this.returnAccessors.length) {
            Accessor accessor = this.returnAccessors[n2];
            int n3 = this.columnIndexes[n2] - 1;
            accessor.columnName = this.tableColumnNames[n3];
            accessor.describeType = this.tableColumnTypes[n3];
            accessor.describeMaxLength = this.tableMaxLengths[n3];
            accessor.nullable = this.tableNullables[n3];
            accessor.precision = this.tablePrecisions[n3];
            accessor.scale = this.tablePrecisions[n3];
            accessor.formOfUse = this.tableFormOfUses[n3];
            ++n2;
        }
    }

    void initMetaDataKeyFlag() throws SQLException {
        this.returnAccessors[0].columnName = "ROWID";
        this.returnAccessors[0].describeType = 104;
        this.returnAccessors[0].describeMaxLength = 4;
        this.returnAccessors[0].nullable = true;
        this.returnAccessors[0].precision = 0;
        this.returnAccessors[0].scale = 0;
        this.returnAccessors[0].formOfUse = 0;
    }

    static final boolean isInsertSqlStmt(String string) throws SQLException {
        if (string == null) {
            DatabaseError.throwSqlException(68);
        }
        return string.trim().toUpperCase().startsWith("INSERT");
    }
}

