/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.sql.CLOB;

public class OracleClobOutputStream
extends OutputStream {
    long lobOffset;
    CLOB clob;
    byte[] buf;
    int count;
    int bufSize;
    boolean isClosed;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Jun_22_11:15:40_PDT_2005";

    public OracleClobOutputStream(CLOB cLOB) throws SQLException {
        this(cLOB, ((PhysicalConnection)cLOB.getJavaSqlConnection()).getDefaultStreamChunkSize(), 1L);
    }

    public OracleClobOutputStream(CLOB cLOB, int n2) throws SQLException {
        this(cLOB, n2, 1L);
    }

    public OracleClobOutputStream(CLOB cLOB, int n2, long l2) throws SQLException {
        if (cLOB == null || n2 <= 0 || l2 < 1L) {
            throw new IllegalArgumentException("Illegal Arguments");
        }
        this.clob = cLOB;
        this.lobOffset = l2;
        this.buf = new byte[n2];
        this.count = 0;
        this.bufSize = n2;
        this.isClosed = false;
    }

    public void close() throws IOException {
        this.flushBuffer();
        this.isClosed = true;
    }

    void ensureOpen() throws IOException {
        try {
            if (this.isClosed) {
                DatabaseError.throwSqlException(57, null);
            }
        }
        catch (SQLException sQLException) {
            DatabaseError.SQLToIOException(sQLException);
        }
    }

    public void flush() throws IOException {
        this.ensureOpen();
        this.flushBuffer();
    }

    private void flushBuffer() throws IOException {
        try {
            if (this.count > 0) {
                char[] cArray = new char[this.count];
                int n2 = 0;
                while (n2 < this.count) {
                    cArray[n2] = (char)this.buf[n2];
                    ++n2;
                }
                this.lobOffset += (long)this.clob.putChars(this.lobOffset, cArray);
                this.count = 0;
            }
        }
        catch (SQLException sQLException) {
            DatabaseError.SQLToIOException(sQLException);
        }
    }

    public void write(int n2) throws IOException {
        this.ensureOpen();
        if (this.count >= this.buf.length) {
            this.flushBuffer();
        }
        this.buf[this.count++] = (byte)n2;
    }

    public void write(byte[] byArray, int n2, int n3) throws IOException {
        this.ensureOpen();
        int n4 = n2;
        int n5 = n4 + Math.min(n3, byArray.length - n2);
        while (n4 < n5) {
            int n6 = Math.min(this.bufSize - this.count, n5 - n4);
            System.arraycopy(byArray, n4, this.buf, this.count, n6);
            n4 += n6;
            this.count += n6;
            if (this.count < this.bufSize) continue;
            this.flushBuffer();
        }
    }
}

