/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.Reader;
import java.sql.SQLException;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.sql.CLOB;

public class OracleClobReader
extends Reader {
    CLOB clob;
    DBConversion dbConversion;
    long lobOffset;
    long markedChar;
    char[] buf;
    int pos;
    int count;
    int chunkSize;
    boolean isClosed;
    boolean endOfStream;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Jun_22_11:15:40_PDT_2005";

    public OracleClobReader(CLOB cLOB) throws SQLException {
        this(cLOB, ((PhysicalConnection)cLOB.getInternalConnection()).getDefaultStreamChunkSize() / 3);
    }

    public OracleClobReader(CLOB cLOB, int n2) throws SQLException {
        this(cLOB, n2, 1L);
    }

    public OracleClobReader(CLOB cLOB, int n2, long l2) throws SQLException {
        if (cLOB == null || n2 <= 0 || cLOB.getInternalConnection() == null || l2 < 1L) {
            throw new IllegalArgumentException("Illegal Arguments");
        }
        this.dbConversion = ((PhysicalConnection)cLOB.getInternalConnection()).conversion;
        this.clob = cLOB;
        this.lobOffset = l2;
        this.markedChar = -1L;
        this.buf = new char[n2];
        this.count = 0;
        this.pos = 0;
        this.chunkSize = n2;
        this.isClosed = false;
    }

    public void close() throws IOException {
        this.isClosed = true;
    }

    void ensureOpen() throws IOException {
        try {
            if (this.isClosed) {
                DatabaseError.throwSqlException(57, null);
            }
        }
        catch (SQLException sQLException) {
            DatabaseError.SQLToIOException(sQLException);
        }
    }

    public void mark(int n2) throws IOException {
        if (n2 < 0) {
            throw new IllegalArgumentException("Read-ahead limit < 0");
        }
        this.markedChar = this.lobOffset - (long)this.count + (long)this.pos;
    }

    public boolean markSupported() {
        return true;
    }

    protected boolean needChars() throws IOException {
        this.ensureOpen();
        if (this.pos >= this.count) {
            if (!this.endOfStream) {
                try {
                    this.count = this.clob.getChars(this.lobOffset, this.chunkSize, this.buf);
                    if (this.count < this.chunkSize) {
                        this.endOfStream = true;
                    }
                    if (this.count > 0) {
                        this.pos = 0;
                        this.lobOffset += (long)this.count;
                        return true;
                    }
                }
                catch (SQLException sQLException) {
                    DatabaseError.SQLToIOException(sQLException);
                }
            }
            return false;
        }
        return true;
    }

    public int read(char[] cArray, int n2, int n3) throws IOException {
        this.ensureOpen();
        if (!this.needChars()) {
            return -1;
        }
        int n4 = n2;
        int n5 = n4 + Math.min(n3, cArray.length - n2);
        n4 += this.writeChars(cArray, n4, n5 - n4);
        while (n4 < n5 && this.needChars()) {
            n4 += this.writeChars(cArray, n4, n5 - n4);
        }
        return n4 - n2;
    }

    public boolean ready() throws IOException {
        this.ensureOpen();
        return this.pos < this.count;
    }

    public void reset() throws IOException {
        this.ensureOpen();
        if (this.markedChar < 0L) {
            throw new IOException("Mark invalid or stream not marked.");
        }
        this.lobOffset = this.markedChar;
        this.pos = this.count;
        this.endOfStream = false;
    }

    public long skip(long l2) throws IOException {
        long l3;
        block5: {
            this.ensureOpen();
            l3 = 0L;
            if ((long)(this.count - this.pos) >= l2) {
                this.pos = (int)((long)this.pos + l2);
                l3 += l2;
            } else {
                l3 += (long)(this.count - this.pos);
                this.pos = this.count;
                try {
                    long l4 = this.clob.length() - this.lobOffset + 1L;
                    if (l4 >= l2 - l3) {
                        this.lobOffset += l2 - l3;
                        l3 += l2 - l3;
                        break block5;
                    }
                    this.lobOffset += l4;
                    l3 += l4;
                }
                catch (SQLException sQLException) {
                    DatabaseError.SQLToIOException(sQLException);
                }
            }
        }
        return l3;
    }

    protected int writeChars(char[] cArray, int n2, int n3) {
        int n4 = Math.min(n3, this.count - this.pos);
        System.arraycopy(this.buf, this.pos, cArray, n2, n4);
        this.pos += n4;
        return n4;
    }
}

