/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Properties;
import oracle.jdbc.OracleParameterMetaData;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.Binder;
import oracle.jdbc.driver.CopiedByteBinder;
import oracle.jdbc.driver.CopiedCharBinder;
import oracle.jdbc.driver.CopiedNullBinder;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleBlobOutputStream;
import oracle.jdbc.driver.OracleClobWriter;
import oracle.jdbc.driver.OraclePreparedStatementReadOnly;
import oracle.jdbc.driver.OracleResultSetImpl;
import oracle.jdbc.driver.OracleReturnResultSet;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.PlsqlIbtBindInfo;
import oracle.jdbc.driver.PlsqlIndexTableAccessor;
import oracle.jdbc.driver.ResultSetUtil;
import oracle.jdbc.driver.ScrollRsetStatement;
import oracle.jdbc.internal.ObjectData;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCOLLECTION;
import oracle.jdbc.oracore.OracleTypeNUMBER;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.BFILE;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.BINARY_FLOAT;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CharacterSet;
import oracle.sql.CustomDatum;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.OpaqueDescriptor;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

public abstract class OraclePreparedStatement
extends OracleStatement
implements oracle.jdbc.internal.OraclePreparedStatement,
ScrollRsetStatement {
    int numberOfBindRowsAllocated;
    static Binder theStaticVarnumCopyingBinder = OraclePreparedStatementReadOnly.theStaticVarnumCopyingBinder;
    static Binder theStaticVarnumNullBinder = OraclePreparedStatementReadOnly.theStaticVarnumNullBinder;
    Binder theVarnumNullBinder = theStaticVarnumNullBinder;
    static Binder theStaticBooleanBinder = OraclePreparedStatementReadOnly.theStaticBooleanBinder;
    Binder theBooleanBinder = theStaticBooleanBinder;
    static Binder theStaticByteBinder = OraclePreparedStatementReadOnly.theStaticByteBinder;
    Binder theByteBinder = theStaticByteBinder;
    static Binder theStaticShortBinder = OraclePreparedStatementReadOnly.theStaticShortBinder;
    Binder theShortBinder = theStaticShortBinder;
    static Binder theStaticIntBinder = OraclePreparedStatementReadOnly.theStaticIntBinder;
    Binder theIntBinder = theStaticIntBinder;
    static Binder theStaticLongBinder = OraclePreparedStatementReadOnly.theStaticLongBinder;
    Binder theLongBinder = theStaticLongBinder;
    static Binder theStaticFloatBinder = OraclePreparedStatementReadOnly.theStaticFloatBinder;
    Binder theFloatBinder = null;
    static Binder theStaticDoubleBinder = OraclePreparedStatementReadOnly.theStaticDoubleBinder;
    Binder theDoubleBinder = null;
    static Binder theStaticBigDecimalBinder = OraclePreparedStatementReadOnly.theStaticBigDecimalBinder;
    Binder theBigDecimalBinder = theStaticBigDecimalBinder;
    static Binder theStaticVarcharCopyingBinder = OraclePreparedStatementReadOnly.theStaticVarcharCopyingBinder;
    static Binder theStaticVarcharNullBinder = OraclePreparedStatementReadOnly.theStaticVarcharNullBinder;
    Binder theVarcharNullBinder = theStaticVarcharNullBinder;
    static Binder theStaticStringBinder = OraclePreparedStatementReadOnly.theStaticStringBinder;
    Binder theStringBinder = theStaticStringBinder;
    static Binder theStaticSetCHARCopyingBinder = OraclePreparedStatementReadOnly.theStaticSetCHARCopyingBinder;
    static Binder theStaticSetCHARBinder = OraclePreparedStatementReadOnly.theStaticSetCHARBinder;
    static Binder theStaticLittleEndianSetCHARBinder = OraclePreparedStatementReadOnly.theStaticLittleEndianSetCHARBinder;
    static Binder theStaticSetCHARNullBinder = OraclePreparedStatementReadOnly.theStaticSetCHARNullBinder;
    Binder theSetCHARBinder;
    Binder theSetCHARNullBinder = theStaticSetCHARNullBinder;
    static Binder theStaticFixedCHARCopyingBinder = OraclePreparedStatementReadOnly.theStaticFixedCHARCopyingBinder;
    static Binder theStaticFixedCHARBinder = OraclePreparedStatementReadOnly.theStaticFixedCHARBinder;
    static Binder theStaticFixedCHARNullBinder = OraclePreparedStatementReadOnly.theStaticFixedCHARNullBinder;
    Binder theFixedCHARBinder = theStaticFixedCHARBinder;
    Binder theFixedCHARNullBinder = theStaticFixedCHARNullBinder;
    static Binder theStaticDateCopyingBinder = OraclePreparedStatementReadOnly.theStaticDateCopyingBinder;
    static Binder theStaticDateBinder = OraclePreparedStatementReadOnly.theStaticDateBinder;
    static Binder theStaticDateNullBinder = OraclePreparedStatementReadOnly.theStaticDateNullBinder;
    Binder theDateBinder = theStaticDateBinder;
    Binder theDateNullBinder = theStaticDateNullBinder;
    static Binder theStaticTimeCopyingBinder = OraclePreparedStatementReadOnly.theStaticTimeCopyingBinder;
    static Binder theStaticTimeBinder = OraclePreparedStatementReadOnly.theStaticTimeBinder;
    Binder theTimeBinder = theStaticTimeBinder;
    static Binder theStaticTimestampCopyingBinder = OraclePreparedStatementReadOnly.theStaticTimestampCopyingBinder;
    static Binder theStaticTimestampBinder = OraclePreparedStatementReadOnly.theStaticTimestampBinder;
    static Binder theStaticTimestampNullBinder = OraclePreparedStatementReadOnly.theStaticTimestampNullBinder;
    Binder theTimestampBinder = theStaticTimestampBinder;
    Binder theTimestampNullBinder = theStaticTimestampNullBinder;
    static Binder theStaticOracleNumberBinder = OraclePreparedStatementReadOnly.theStaticOracleNumberBinder;
    Binder theOracleNumberBinder = theStaticOracleNumberBinder;
    static Binder theStaticOracleDateBinder = OraclePreparedStatementReadOnly.theStaticOracleDateBinder;
    Binder theOracleDateBinder = theStaticOracleDateBinder;
    static Binder theStaticOracleTimestampBinder = OraclePreparedStatementReadOnly.theStaticOracleTimestampBinder;
    Binder theOracleTimestampBinder = theStaticOracleTimestampBinder;
    static Binder theStaticTSTZCopyingBinder = OraclePreparedStatementReadOnly.theStaticTSTZCopyingBinder;
    static Binder theStaticTSTZBinder = OraclePreparedStatementReadOnly.theStaticTSTZBinder;
    static Binder theStaticTSTZNullBinder = OraclePreparedStatementReadOnly.theStaticTSTZNullBinder;
    Binder theTSTZBinder = theStaticTSTZBinder;
    Binder theTSTZNullBinder = theStaticTSTZNullBinder;
    static Binder theStaticTSLTZCopyingBinder = OraclePreparedStatementReadOnly.theStaticTSLTZCopyingBinder;
    static Binder theStaticTSLTZBinder = OraclePreparedStatementReadOnly.theStaticTSLTZBinder;
    static Binder theStaticTSLTZNullBinder = OraclePreparedStatementReadOnly.theStaticTSLTZNullBinder;
    Binder theTSLTZBinder = theStaticTSLTZBinder;
    Binder theTSLTZNullBinder = theStaticTSLTZNullBinder;
    static Binder theStaticRowidCopyingBinder = OraclePreparedStatementReadOnly.theStaticRowidCopyingBinder;
    static Binder theStaticRowidBinder = OraclePreparedStatementReadOnly.theStaticRowidBinder;
    static Binder theStaticLittleEndianRowidBinder = OraclePreparedStatementReadOnly.theStaticLittleEndianRowidBinder;
    static Binder theStaticRowidNullBinder = OraclePreparedStatementReadOnly.theStaticRowidNullBinder;
    Binder theRowidBinder;
    Binder theRowidNullBinder = theStaticRowidNullBinder;
    static Binder theStaticIntervalDSCopyingBinder = OraclePreparedStatementReadOnly.theStaticIntervalDSCopyingBinder;
    static Binder theStaticIntervalDSBinder = OraclePreparedStatementReadOnly.theStaticIntervalDSBinder;
    static Binder theStaticIntervalDSNullBinder = OraclePreparedStatementReadOnly.theStaticIntervalDSNullBinder;
    Binder theIntervalDSBinder = theStaticIntervalDSBinder;
    Binder theIntervalDSNullBinder = theStaticIntervalDSNullBinder;
    static Binder theStaticIntervalYMCopyingBinder = OraclePreparedStatementReadOnly.theStaticIntervalYMCopyingBinder;
    static Binder theStaticIntervalYMBinder = OraclePreparedStatementReadOnly.theStaticIntervalYMBinder;
    static Binder theStaticIntervalYMNullBinder = OraclePreparedStatementReadOnly.theStaticIntervalYMNullBinder;
    Binder theIntervalYMBinder = theStaticIntervalYMBinder;
    Binder theIntervalYMNullBinder = theStaticIntervalYMNullBinder;
    static Binder theStaticBfileCopyingBinder = OraclePreparedStatementReadOnly.theStaticBfileCopyingBinder;
    static Binder theStaticBfileBinder = OraclePreparedStatementReadOnly.theStaticBfileBinder;
    static Binder theStaticBfileNullBinder = OraclePreparedStatementReadOnly.theStaticBfileNullBinder;
    Binder theBfileBinder = theStaticBfileBinder;
    Binder theBfileNullBinder = theStaticBfileNullBinder;
    static Binder theStaticBlobCopyingBinder = OraclePreparedStatementReadOnly.theStaticBlobCopyingBinder;
    static Binder theStaticBlobBinder = OraclePreparedStatementReadOnly.theStaticBlobBinder;
    static Binder theStaticBlobNullBinder = OraclePreparedStatementReadOnly.theStaticBlobNullBinder;
    Binder theBlobBinder = theStaticBlobBinder;
    Binder theBlobNullBinder = theStaticBlobNullBinder;
    static Binder theStaticClobCopyingBinder = OraclePreparedStatementReadOnly.theStaticClobCopyingBinder;
    static Binder theStaticClobBinder = OraclePreparedStatementReadOnly.theStaticClobBinder;
    static Binder theStaticClobNullBinder = OraclePreparedStatementReadOnly.theStaticClobNullBinder;
    Binder theClobBinder = theStaticClobBinder;
    Binder theClobNullBinder = theStaticClobNullBinder;
    static Binder theStaticRawCopyingBinder = OraclePreparedStatementReadOnly.theStaticRawCopyingBinder;
    static Binder theStaticRawBinder = OraclePreparedStatementReadOnly.theStaticRawBinder;
    static Binder theStaticRawNullBinder = OraclePreparedStatementReadOnly.theStaticRawNullBinder;
    Binder theRawBinder = theStaticRawBinder;
    Binder theRawNullBinder = theStaticRawNullBinder;
    static Binder theStaticPlsqlRawCopyingBinder = OraclePreparedStatementReadOnly.theStaticPlsqlRawCopyingBinder;
    static Binder theStaticPlsqlRawBinder = OraclePreparedStatementReadOnly.theStaticPlsqlRawBinder;
    Binder thePlsqlRawBinder = theStaticPlsqlRawBinder;
    static Binder theStaticBinaryFloatCopyingBinder = OraclePreparedStatementReadOnly.theStaticBinaryFloatCopyingBinder;
    static Binder theStaticBinaryFloatBinder = OraclePreparedStatementReadOnly.theStaticBinaryFloatBinder;
    static Binder theStaticBinaryFloatNullBinder = OraclePreparedStatementReadOnly.theStaticBinaryFloatNullBinder;
    Binder theBinaryFloatBinder = theStaticBinaryFloatBinder;
    Binder theBinaryFloatNullBinder = theStaticBinaryFloatNullBinder;
    static Binder theStaticBINARY_FLOATCopyingBinder = OraclePreparedStatementReadOnly.theStaticBINARY_FLOATCopyingBinder;
    static Binder theStaticBINARY_FLOATBinder = OraclePreparedStatementReadOnly.theStaticBINARY_FLOATBinder;
    static Binder theStaticBINARY_FLOATNullBinder = OraclePreparedStatementReadOnly.theStaticBINARY_FLOATNullBinder;
    Binder theBINARY_FLOATBinder = theStaticBINARY_FLOATBinder;
    Binder theBINARY_FLOATNullBinder = theStaticBINARY_FLOATNullBinder;
    static Binder theStaticBinaryDoubleCopyingBinder = OraclePreparedStatementReadOnly.theStaticBinaryDoubleCopyingBinder;
    static Binder theStaticBinaryDoubleBinder = OraclePreparedStatementReadOnly.theStaticBinaryDoubleBinder;
    static Binder theStaticBinaryDoubleNullBinder = OraclePreparedStatementReadOnly.theStaticBinaryDoubleNullBinder;
    Binder theBinaryDoubleBinder = theStaticBinaryDoubleBinder;
    Binder theBinaryDoubleNullBinder = theStaticBinaryDoubleNullBinder;
    static Binder theStaticBINARY_DOUBLECopyingBinder = OraclePreparedStatementReadOnly.theStaticBINARY_DOUBLECopyingBinder;
    static Binder theStaticBINARY_DOUBLEBinder = OraclePreparedStatementReadOnly.theStaticBINARY_DOUBLEBinder;
    static Binder theStaticBINARY_DOUBLENullBinder = OraclePreparedStatementReadOnly.theStaticBINARY_DOUBLENullBinder;
    Binder theBINARY_DOUBLEBinder = theStaticBINARY_DOUBLEBinder;
    Binder theBINARY_DOUBLENullBinder = theStaticBINARY_DOUBLENullBinder;
    static Binder theStaticLongStreamBinder = OraclePreparedStatementReadOnly.theStaticLongStreamBinder;
    Binder theLongStreamBinder = theStaticLongStreamBinder;
    static Binder theStaticLongRawStreamBinder = OraclePreparedStatementReadOnly.theStaticLongRawStreamBinder;
    Binder theLongRawStreamBinder = theStaticLongRawStreamBinder;
    static Binder theStaticNamedTypeCopyingBinder = OraclePreparedStatementReadOnly.theStaticNamedTypeCopyingBinder;
    static Binder theStaticNamedTypeBinder = OraclePreparedStatementReadOnly.theStaticNamedTypeBinder;
    static Binder theStaticNamedTypeNullBinder = OraclePreparedStatementReadOnly.theStaticNamedTypeNullBinder;
    Binder theNamedTypeBinder = theStaticNamedTypeBinder;
    Binder theNamedTypeNullBinder = theStaticNamedTypeNullBinder;
    static Binder theStaticRefTypeCopyingBinder = OraclePreparedStatementReadOnly.theStaticRefTypeCopyingBinder;
    static Binder theStaticRefTypeBinder = OraclePreparedStatementReadOnly.theStaticRefTypeBinder;
    static Binder theStaticRefTypeNullBinder = OraclePreparedStatementReadOnly.theStaticRefTypeNullBinder;
    Binder theRefTypeBinder = theStaticRefTypeBinder;
    Binder theRefTypeNullBinder = theStaticRefTypeNullBinder;
    static Binder theStaticPlsqlIbtCopyingBinder = OraclePreparedStatementReadOnly.theStaticPlsqlIbtCopyingBinder;
    static Binder theStaticPlsqlIbtBinder = OraclePreparedStatementReadOnly.theStaticPlsqlIbtBinder;
    static Binder theStaticPlsqlIbtNullBinder = OraclePreparedStatementReadOnly.theStaticPlsqlIbtNullBinder;
    Binder thePlsqlIbtBinder = theStaticPlsqlIbtBinder;
    Binder thePlsqlNullBinder = theStaticPlsqlIbtNullBinder;
    static Binder theStaticOutBinder = OraclePreparedStatementReadOnly.theStaticOutBinder;
    Binder theOutBinder = theStaticOutBinder;
    static Binder theStaticReturnParamBinder = OraclePreparedStatementReadOnly.theStaticReturnParamBinder;
    Binder theReturnParamBinder = theStaticReturnParamBinder;
    static Binder theStaticT4CRowidBinder = OraclePreparedStatementReadOnly.theStaticT4CRowidBinder;
    static Binder theStaticT4CRowidNullBinder = OraclePreparedStatementReadOnly.theStaticT4CRowidNullBinder;
    public static final int TypeBinder_BYTELEN = 24;
    char[] digits = new char[20];
    Binder[][] binders;
    int[][] parameterInt;
    long[][] parameterLong;
    float[][] parameterFloat;
    double[][] parameterDouble;
    BigDecimal[][] parameterBigDecimal;
    String[][] parameterString;
    Date[][] parameterDate;
    Time[][] parameterTime;
    Timestamp[][] parameterTimestamp;
    byte[][][] parameterDatum;
    OracleTypeADT[][] parameterOtype;
    PlsqlIbtBindInfo[][] parameterPlsqlIbt;
    Binder[] currentRowBinders;
    int[] currentRowCharLens;
    Accessor[] currentRowBindAccessors;
    short[] currentRowFormOfUse;
    boolean currentRowNeedToPrepareBinds = true;
    int[] currentBatchCharLens;
    Accessor[] currentBatchBindAccessors;
    short[] currentBatchFormOfUse;
    boolean currentBatchNeedToPrepareBinds;
    PushedBatch pushedBatches;
    PushedBatch pushedBatchesTail;
    int totalBindByteLength;
    int totalBindCharLength;
    int totalBindIndicatorLength;
    static final int BIND_METADATA_NUMBER_OF_BIND_POSITIONS_OFFSET = 0;
    static final int BIND_METADATA_BIND_BUFFER_CAPACITY_OFFSET = 1;
    static final int BIND_METADATA_NUMBER_OF_BOUND_ROWS_OFFSET = 2;
    static final int BIND_METADATA_PER_POSITION_DATA_OFFSET = 3;
    static final int BIND_METADATA_TYPE_OFFSET = 0;
    static final int BIND_METADATA_BYTE_PITCH_OFFSET = 1;
    static final int BIND_METADATA_CHAR_PITCH_OFFSET = 2;
    static final int BIND_METADATA_VALUE_DATA_OFFSET_HI = 3;
    static final int BIND_METADATA_VALUE_DATA_OFFSET_LO = 4;
    static final int BIND_METADATA_NULL_INDICATORS_OFFSET_HI = 5;
    static final int BIND_METADATA_NULL_INDICATORS_OFFSET_LO = 6;
    static final int BIND_METADATA_VALUE_LENGTHS_OFFSET_HI = 7;
    static final int BIND_METADATA_VALUE_LENGTHS_OFFSET_LO = 8;
    static final int BIND_METADATA_FORM_OF_USE_OFFSET = 9;
    static final int BIND_METADATA_PER_POSITION_SIZE = 10;
    int bindBufferCapacity;
    int numberOfBoundRows;
    int indicatorsOffset;
    int valueLengthsOffset;
    boolean preparedAllBinds;
    boolean preparedCharBinds;
    Binder[] lastBinders;
    byte[] lastBoundBytes;
    int lastBoundByteOffset;
    char[] lastBoundChars;
    int lastBoundCharOffset;
    int[] lastBoundByteOffsets;
    int[] lastBoundCharOffsets;
    int[] lastBoundByteLens;
    int[] lastBoundCharLens;
    short[] lastBoundInds;
    short[] lastBoundLens;
    boolean lastBoundNeeded = false;
    byte[][] lastBoundTypeBytes;
    OracleTypeADT[] lastBoundTypeOtypes;
    private static final int STREAM_MAX_BYTES_SQL = Integer.MAX_VALUE;
    int maxRawBytesSql;
    int maxRawBytesPlsql;
    int maxVcsCharsSql;
    int maxVcsBytesPlsql;
    private int maxCharSize = 0;
    private int maxNCharSize = 0;
    private int charMaxCharsSql = 0;
    private int charMaxNCharsSql = 0;
    private int maxVcsCharsPlsql = 0;
    private int maxVcsNCharsPlsql = 0;
    private int maxStreamCharsSql = 0;
    private int maxStreamNCharsSql = 0;
    private boolean isServerCharSetFixedWidth = false;
    private boolean isServerNCharSetFixedWidth = false;
    int minVcsBindSize;
    int prematureBatchCount;
    boolean checkBindTypes = true;
    boolean scrollRsetTypeSolved;
    int SetBigStringTryClob = 0;
    static final int BSTYLE_UNKNOWN = 0;
    static final int BSTYLE_ORACLE = 1;
    static final int BSTYLE_JDBC = 2;
    int m_batchStyle = 0;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Jun_22_11:15:41_PDT_2005";

    OraclePreparedStatement(PhysicalConnection physicalConnection, String string, int n2, int n3) throws SQLException {
        this(physicalConnection, string, n2, n3, 1003, 1007);
    }

    OraclePreparedStatement(PhysicalConnection physicalConnection, String string, int n2, int n3, int n4, int n5) throws SQLException {
        super(physicalConnection, n2, n3, n4, n5);
        this.theSetCHARBinder = physicalConnection.useLittleEndianSetCHARBinder() ? theStaticLittleEndianSetCHARBinder : theStaticSetCHARBinder;
        this.theRowidBinder = physicalConnection.useLittleEndianSetCHARBinder() ? theStaticLittleEndianRowidBinder : theStaticRowidBinder;
        this.statementType = 1;
        this.currentRow = -1;
        this.needToParse = true;
        this.processEscapes = physicalConnection.processEscapes;
        this.sqlObject.initialize(string);
        this.sqlKind = this.sqlObject.getSqlKind();
        this.clearParameters = true;
        this.scrollRsetTypeSolved = false;
        this.prematureBatchCount = 0;
        this.initializeBinds();
        this.minVcsBindSize = physicalConnection.minVcsBindSize;
        this.maxRawBytesSql = physicalConnection.maxRawBytesSql;
        this.maxRawBytesPlsql = physicalConnection.maxRawBytesPlsql;
        this.maxVcsCharsSql = physicalConnection.maxVcsCharsSql;
        this.maxVcsBytesPlsql = physicalConnection.maxVcsBytesPlsql;
        this.maxCharSize = this.connection.conversion.sMaxCharSize;
        this.maxNCharSize = this.connection.conversion.maxNCharSize;
        this.maxVcsCharsPlsql = this.maxVcsBytesPlsql / this.maxCharSize;
        this.maxVcsNCharsPlsql = this.maxVcsBytesPlsql / this.maxNCharSize;
        this.maxStreamCharsSql = Integer.MAX_VALUE / this.maxCharSize;
        this.maxStreamNCharsSql = this.maxRawBytesSql / this.maxNCharSize;
        this.isServerCharSetFixedWidth = this.connection.conversion.isServerCharSetFixedWidth;
        this.isServerNCharSetFixedWidth = this.connection.conversion.isServerNCharSetFixedWidth;
    }

    public OracleParameterMetaData OracleGetParameterMetaData() throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public synchronized void addBatch() throws SQLException {
        this.setJdbcBatchStyle();
        this.processCompletedBindRow(this.currentRank + 2, this.currentRank > 0 && (this.sqlKind == 1 || this.sqlKind == 4));
        ++this.currentRank;
    }

    public synchronized void addBatch(String string) throws SQLException {
        DatabaseError.throwSqlException(23);
    }

    void allocBinds(int n2) throws SQLException {
        int n3;
        boolean bl2 = n2 > this.numberOfBindRowsAllocated;
        this.initializeIndicatorSubRange();
        int n4 = this.bindIndicatorSubRange + 3 + this.numberOfBindPositions * 10;
        int n5 = n2 * this.numberOfBindPositions;
        int n6 = n4 + 2 * n5;
        if (n6 > this.totalBindIndicatorLength) {
            short[] sArray = this.bindIndicators;
            n3 = this.bindIndicatorOffset;
            this.bindIndicatorOffset = 0;
            this.bindIndicators = new short[n6];
            this.totalBindIndicatorLength = n6;
            if (sArray != null && bl2) {
                System.arraycopy(sArray, n3, this.bindIndicators, this.bindIndicatorOffset, n4);
            }
        }
        this.bindIndicatorSubRange += this.bindIndicatorOffset;
        this.bindIndicators[this.bindIndicatorSubRange] = (short)this.numberOfBindPositions;
        this.indicatorsOffset = this.bindIndicatorOffset + n4;
        this.valueLengthsOffset = this.indicatorsOffset + n5;
        int n7 = this.indicatorsOffset;
        n3 = this.valueLengthsOffset;
        int n8 = this.bindIndicatorSubRange + 3;
        int n9 = 0;
        while (n9 < this.numberOfBindPositions) {
            this.bindIndicators[n8 + 5] = (short)(n7 >> 16);
            this.bindIndicators[n8 + 6] = (short)(n7 & 0xFFFF);
            this.bindIndicators[n8 + 7] = (short)(n3 >> 16);
            this.bindIndicators[n8 + 8] = (short)(n3 & 0xFFFF);
            n7 += n2;
            n3 += n2;
            n8 += 10;
            ++n9;
        }
    }

    protected void alwaysOnClose() throws SQLException {
        if (this.currentRank > 0) {
            if (this.m_batchStyle == 2) {
                this.clearBatch();
            } else {
                this.sendBatch();
            }
        }
        super.alwaysOnClose();
    }

    void basicBindAsciiStream(int n2, InputStream inputStream, int n3) throws SQLException {
        if (this.userRsetType != 1) {
            DatabaseError.throwSqlException(169);
        }
        int n4 = n2 - 1;
        this.currentRowBinders[n4] = this.theLongStreamBinder;
        if (this.parameterStream == null) {
            this.parameterStream = new InputStream[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        }
        this.parameterStream[this.currentRank][n4] = this.connection.conversion.ConvertStream(inputStream, 5, n3);
        this.currentRowCharLens[n4] = 0;
    }

    void basicBindBinaryStream(int n2, InputStream inputStream, int n3) throws SQLException {
        int n4 = n2 - 1;
        this.currentRowBinders[n4] = this.theLongRawStreamBinder;
        if (this.parameterStream == null) {
            this.parameterStream = new InputStream[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        }
        this.parameterStream[this.currentRank][n4] = this.connection.conversion.ConvertStream(inputStream, 6, n3);
        this.currentRowCharLens[n4] = 0;
    }

    void basicBindBytes(int n2, byte[] byArray) throws SQLException {
        Binder binder;
        int n3 = n2 - 1;
        this.currentRowBinders[n3] = binder = this.sqlKind == 1 || this.sqlKind == 4 ? this.thePlsqlRawBinder : this.theRawBinder;
        if (this.parameterDatum == null) {
            this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
        }
        this.parameterDatum[this.currentRank][n3] = byArray;
        this.currentRowCharLens[n3] = 0;
    }

    void basicBindCharacterStream(int n2, Reader reader, int n3) throws SQLException {
        int n4 = n2 - 1;
        this.currentRowBinders[n4] = this.theLongStreamBinder;
        if (this.parameterStream == null) {
            this.parameterStream = new InputStream[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        }
        this.parameterStream[this.currentRank][n4] = this.connection.conversion.ConvertStream(reader, 7, n3, this.currentRowFormOfUse[n4]);
        this.currentRowCharLens[n4] = 0;
    }

    void basicBindNullString(int n2) throws SQLException {
        int n3 = n2 - 1;
        this.currentRowBinders[n3] = this.theVarcharNullBinder;
        this.currentRowCharLens[n3] = this.sqlKind == 1 || this.sqlKind == 4 ? this.minVcsBindSize : 1;
    }

    void basicBindString(int n2, String string) throws SQLException {
        int n3;
        int n4;
        int n5 = n2 - 1;
        this.currentRowBinders[n5] = this.theStringBinder;
        int n6 = string.length();
        this.currentRowCharLens[n5] = this.sqlKind == 1 || this.sqlKind == 4 ? ((n4 = n6 + 1) < (n3 = this.connection.minVcsBindSize) ? n3 : n4) : n6 + 1;
        if (this.parameterString == null) {
            this.parameterString = new String[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        }
        this.parameterString[this.currentRank][n5] = string;
    }

    void bindBytesAsStream(int n2, byte[] byArray) throws SQLException {
        int n3 = byArray.length;
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, 0, byArray2, 0, n3);
        this.basicBindBinaryStream(n2, new ByteArrayInputStream(byArray2), n3);
    }

    final void checkIfJdbcBatchExists() throws SQLException {
        if (this.doesJdbcBatchExist()) {
            DatabaseError.throwSqlException(81, "batch must be either executed or cleared");
        }
    }

    public synchronized void clearBatch() throws SQLException {
        int n2 = this.currentRank;
        while (n2 >= 0) {
            int n3 = 0;
            while (n3 < this.numberOfBindPositions) {
                this.binders[n2][n3] = null;
                ++n3;
            }
            --n2;
        }
        this.currentRank = 0;
        if (this.binders != null) {
            this.currentRowBinders = this.binders[0];
        }
        this.pushedBatches = null;
        this.pushedBatchesTail = null;
        this.firstRowInBatch = 0;
        this.clearParameters = true;
    }

    public synchronized void clearParameters() throws SQLException {
        this.clearParameters = true;
        int n2 = 0;
        while (n2 < this.numberOfBindPositions) {
            this.currentRowBinders[n2] = null;
            ++n2;
        }
    }

    public void closeWithKey(String string) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OraclePreparedStatement oraclePreparedStatement = this;
            synchronized (oraclePreparedStatement) {
                this.closeOrCache(string);
            }
        }
    }

    Binder copiedByteBinder(short s2, byte[] byArray, int n2, int n3, short s3) throws SQLException {
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n2, byArray2, 0, n3);
        return new CopiedByteBinder(s2, n3, byArray2, s3);
    }

    Binder copiedCharBinder(short s2, char[] cArray, int n2, int n3, short s3) throws SQLException {
        char[] cArray2 = new char[n3];
        System.arraycopy(cArray, n2, cArray2, 0, n3);
        return new CopiedCharBinder(s2, cArray2, s3);
    }

    Binder copiedNullBinder(short s2, int n2) throws SQLException {
        return new CopiedNullBinder(s2, n2);
    }

    public int copyBinds(Statement statement, int n2) throws SQLException {
        if (this.numberOfBindPositions > 0) {
            OraclePreparedStatement oraclePreparedStatement = (OraclePreparedStatement)statement;
            Binder[] binderArray = this.binders[0];
            int n3 = this.bindIndicatorSubRange + 3;
            int n4 = this.bindByteSubRange;
            int n5 = this.bindCharSubRange;
            int n6 = this.indicatorsOffset;
            int n7 = this.valueLengthsOffset;
            int n8 = 0;
            while (n8 < this.numberOfBindPositions) {
                short s2 = this.bindIndicators[n3];
                short s3 = this.bindIndicators[n3 + 1];
                int n9 = this.bindIndicators[n3 + 2];
                int n10 = n8 + n2;
                if (this.bindIndicators[n6] == -1) {
                    oraclePreparedStatement.currentRowBinders[n10] = this.copiedNullBinder(s2, s3);
                    if (n9 > 0) {
                        oraclePreparedStatement.currentRowCharLens[n10] = 1;
                    }
                } else if (s2 == 109 || s2 == 111) {
                    oraclePreparedStatement.currentRowBinders[n10] = s2 == 109 ? this.theNamedTypeBinder : this.theRefTypeBinder;
                    byte[] byArray = this.parameterDatum[0][n8];
                    int n11 = byArray.length;
                    byte[] byArray2 = new byte[n11];
                    oraclePreparedStatement.parameterDatum[0][n10] = byArray2;
                    System.arraycopy(byArray, 0, byArray2, 0, n11);
                    oraclePreparedStatement.parameterOtype[0][n10] = this.parameterOtype[0][n8];
                } else if (s3 > 0) {
                    oraclePreparedStatement.currentRowBinders[n10] = this.copiedByteBinder(s2, this.bindBytes, n4, s3, this.bindIndicators[n7]);
                } else if (n9 > 0) {
                    oraclePreparedStatement.currentRowBinders[n10] = this.copiedCharBinder(s2, this.bindChars, n5, n9, this.bindIndicators[n7]);
                    oraclePreparedStatement.currentRowCharLens[n10] = n9;
                } else {
                    throw new Error("copyBinds doesn't understand type " + s2);
                }
                n4 += this.bindBufferCapacity * s3;
                n5 += this.bindBufferCapacity * n9;
                n6 += this.numberOfBindRowsAllocated;
                n7 += this.numberOfBindRowsAllocated;
                n3 += 10;
                ++n8;
            }
        }
        return this.numberOfBindPositions;
    }

    public synchronized void defineParameterType(int n2, int n3, int n4) throws SQLException {
        this.defineParameterTypeBytes(n2, n3, n4);
    }

    public synchronized void defineParameterTypeBytes(int n2, int n3, int n4) throws SQLException {
        if (n4 < 0) {
            DatabaseError.throwSqlException(53);
        }
        if (n2 < 1) {
            DatabaseError.throwSqlException(3);
        }
        switch (n3) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n3 = 6;
                break;
            }
            case 1: {
                n3 = 96;
                break;
            }
            case 12: {
                n3 = 1;
                break;
            }
            case 91: 
            case 92: {
                n3 = 12;
                break;
            }
            case -103: {
                n3 = 182;
                break;
            }
            case -104: {
                n3 = 183;
                break;
            }
            case -100: 
            case 93: {
                n3 = 180;
                break;
            }
            case -101: {
                n3 = 181;
                break;
            }
            case -102: {
                n3 = 231;
                break;
            }
            case -3: 
            case -2: {
                n3 = 23;
                break;
            }
            case 100: {
                n3 = 100;
                break;
            }
            case 101: {
                n3 = 101;
                break;
            }
            case -8: {
                n3 = 104;
                break;
            }
            case 2004: {
                n3 = 113;
                break;
            }
            case 2005: {
                n3 = 112;
                break;
            }
            case -13: {
                n3 = 114;
                break;
            }
            case -10: {
                n3 = 102;
                break;
            }
            case 0: {
                DatabaseError.throwSqlException(4);
            }
            default: {
                DatabaseError.throwSqlException(23);
            }
        }
    }

    public synchronized void defineParameterTypeChars(int n2, int n3, int n4) throws SQLException {
        int n5 = this.connection.getNlsRatio();
        if (n3 == 1 || n3 == 12) {
            this.defineParameterTypeBytes(n2, n3, n4 * n5);
        } else {
            this.defineParameterTypeBytes(n2, n3, n4);
        }
    }

    int doScrollPstmtExecuteUpdate() throws SQLException {
        this.doScrollExecuteCommon();
        if (this.sqlKind == 0) {
            this.scrollRsetTypeSolved = true;
        }
        return this.validRows;
    }

    boolean doesJdbcBatchExist() {
        return this.currentRank > 0 && this.m_batchStyle == 2;
    }

    void endOfResultSet(boolean bl2) throws SQLException {
        if (!bl2) {
            this.prepareForNewResults(false, false);
        }
    }

    public void enterExplicitCache() throws SQLException {
        this.cacheState = 2;
        this.creationState = 2;
        this.defaultTZ = null;
        this.alwaysOnClose();
    }

    public void enterImplicitCache() throws SQLException {
        this.alwaysOnClose();
        if (!this.connection.isClosed()) {
            this.cleanAllTempLobs();
        }
        if (this.connection.clearStatementMetaData) {
            this.lastBoundBytes = null;
            this.lastBoundChars = null;
        }
        this.clearParameters();
        this.cacheState = 2;
        this.creationState = 1;
        this.currentResultSet = null;
        this.lastIndex = 0;
        this.queryTimeout = 0;
        this.autoRollback = 2;
        this.rowPrefetchChanged = false;
        this.currentRank = 0;
        this.currentRow = -1;
        this.validRows = 0;
        this.maxRows = 0;
        this.totalRowsVisited = 0;
        this.maxFieldSize = 0;
        this.gotLastBatch = false;
        this.clearParameters = true;
        this.scrollRset = null;
        this.needToAddIdentifier = false;
        this.defaultFetchDirection = 1000;
        this.defaultTZ = null;
        if (this.sqlKind == 3) {
            this.needToParse = true;
            this.needToPrepareDefineBuffer = true;
            this.columnsDefinedByUser = false;
        }
        if (this.connection.isMemoryFreedOnEnteringCache && this.defineIndicators != null) {
            this.cachedDefineByteSize = this.defineBytes != null ? this.defineBytes.length : 0;
            this.cachedDefineCharSize = this.defineChars != null ? this.defineChars.length : 0;
            this.cachedDefineIndicatorSize = this.defineIndicators != null ? this.defineIndicators.length : 0;
            this.defineChars = null;
            this.defineBytes = null;
            this.defineIndicators = null;
        }
        if (this.accessors != null) {
            int n2 = this.accessors.length;
            int n3 = 0;
            while (n3 < n2) {
                if (this.accessors[n3] != null) {
                    if (this.connection.isMemoryFreedOnEnteringCache) {
                        this.accessors[n3].rowSpaceByte = null;
                        this.accessors[n3].rowSpaceChar = null;
                        this.accessors[n3].rowSpaceIndicator = null;
                    }
                    if (this.columnsDefinedByUser) {
                        this.accessors[n3].externalType = 0;
                    }
                }
                ++n3;
            }
        }
        this.fixedString = this.connection.getDefaultFixedString();
        this.defaultRowPrefetch = this.rowPrefetch;
        if (this.connection.clearStatementMetaData) {
            this.sqlStringChanged = true;
            this.needToParse = true;
            this.needToPrepareDefineBuffer = true;
            this.columnsDefinedByUser = false;
            if (this.userRsetType == 0) {
                this.userRsetType = 1;
                this.realRsetType = 1;
            }
            this.currentRowNeedToPrepareBinds = true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean execute() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OraclePreparedStatement oraclePreparedStatement = this;
            synchronized (oraclePreparedStatement) {
                this.executionType = (byte)3;
                this.executeInternal();
                if (this.sqlKind == 0) return true;
                return false;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public int[] executeBatch() throws SQLException {
        var1_1 = this.connection;
        synchronized (var1_1) {
            var4_2 = this;
            synchronized (var4_2) {
                block27: {
                    block25: {
                        var6_3 = 0;
                        this.setJdbcBatchStyle();
                        var7_4 = new int[this.currentRank];
                        if (this.currentRank <= 0) break block27;
                        this.ensureOpen();
                        this.prepareForNewResults(true, true);
                        if (this.sqlKind == 0) {
                            DatabaseError.throwBatchUpdateException(80, 0, null);
                        }
                        this.noMoreUpdateCounts = false;
                        var8_5 = 0;
                        try {
                            block26: {
                                try {
                                    this.connection.needLine();
                                    if (!this.isOpen) {
                                        this.connection.open(this);
                                        this.isOpen = true;
                                    }
                                    var11_6 = this.currentRank;
                                    if (this.pushedBatches == null) {
                                        this.setupBindBuffers(0, this.currentRank);
                                        this.executeForRows(false);
                                    } else {
                                        if (this.currentRank > this.firstRowInBatch) {
                                            this.pushBatch(true);
                                        }
                                        var12_8 = this.needToParse;
                                        do {
                                            var13_9 = this.pushedBatches;
                                            this.currentBatchCharLens = var13_9.currentBatchCharLens;
                                            this.lastBoundCharLens = var13_9.lastBoundCharLens;
                                            this.lastBoundNeeded = var13_9.lastBoundNeeded;
                                            this.currentBatchBindAccessors = var13_9.currentBatchBindAccessors;
                                            this.needToParse = var13_9.need_to_parse;
                                            this.currentBatchNeedToPrepareBinds = var13_9.current_batch_need_to_prepare_binds;
                                            this.firstRowInBatch = var13_9.first_row_in_batch;
                                            this.setupBindBuffers(var13_9.first_row_in_batch, var13_9.number_of_rows_to_be_bound);
                                            this.currentRank = var13_9.number_of_rows_to_be_bound;
                                            this.executeForRows(false);
                                            if (this.sqlKind == 1 || this.sqlKind == 4) {
                                                var8_5 += this.validRows;
                                                var7_4[var6_3++] = this.validRows;
                                            }
                                            this.pushedBatches = var13_9.next;
                                        } while (this.pushedBatches != null);
                                        this.pushedBatchesTail = null;
                                        this.firstRowInBatch = 0;
                                        this.needToParse = var12_8;
                                    }
                                    this.slideDownCurrentRow(var11_6);
                                    break block25;
                                }
                                catch (SQLException var11_7) {
                                    this.clearBatch();
                                    this.needToParse = true;
                                    if (this.sqlKind == 1 || this.sqlKind == 4) break block26;
                                    var6_3 = 0;
                                    ** while (var6_3 < var7_4.length)
                                }
lbl-1000:
                                // 1 sources

                                {
                                    var7_4[var6_3] = -3;
                                    ++var6_3;
                                    continue;
                                }
                            }
                            DatabaseError.throwBatchUpdateException(var11_7, this.sqlKind == 1 || this.sqlKind == 4 ? var6_3 : var7_4.length, var7_4);
                        }
                        catch (Throwable var9_12) {
                            var10_11 = null;
                            if (this.sqlKind == 1 || this.sqlKind == 4) {
                                this.validRows = var8_5;
                            }
                            this.checkValidRowsStatus();
                            this.currentRank = 0;
                            this.cleanOldTempLobs();
                            throw var9_12;
                        }
                    }
                    var10_10 = null;
                    if (this.sqlKind == 1 || this.sqlKind == 4) {
                        this.validRows = var8_5;
                    }
                    this.checkValidRowsStatus();
                    this.currentRank = 0;
                    this.cleanOldTempLobs();
                    if (this.validRows < 0) {
                        var6_3 = 0;
                        while (var6_3 < var7_4.length) {
                            var7_4[var6_3] = -3;
                            ++var6_3;
                        }
                        DatabaseError.throwBatchUpdateException(81, 0, var7_4);
                    } else if (this.sqlKind != 1 && this.sqlKind != 4) {
                        var6_3 = 0;
                        while (var6_3 < var7_4.length) {
                            var7_4[var6_3] = -2;
                            ++var6_3;
                        }
                    }
                }
                var3_13 = var7_4;
                var5_14 = null;
            }
            var2_15 = null;
            return var3_13;
            {
                catch (Throwable v0) {
                    throw v0;
                }
            }
        }
    }

    int executeInternal() throws SQLException {
        boolean bl2;
        this.noMoreUpdateCounts = false;
        this.ensureOpen();
        if (this.currentRank > 0 && this.m_batchStyle == 2) {
            DatabaseError.throwSqlException(81, "batch must be either executed or cleared");
        }
        boolean bl3 = this.userRsetType == 1;
        this.prepareForNewResults(true, false);
        this.processCompletedBindRow(this.sqlKind == 0 ? 1 : this.batch, false);
        if (!bl3 && !this.scrollRsetTypeSolved) {
            return this.doScrollPstmtExecuteUpdate() + this.prematureBatchCount;
        }
        this.doExecuteWithTimeout();
        boolean bl4 = bl2 = this.prematureBatchCount != 0 && this.validRows > 0;
        if (!bl3) {
            this.currentResultSet = new OracleResultSetImpl(this.connection, this);
            this.scrollRset = ResultSetUtil.createScrollResultSet(this, this.currentResultSet, this.realRsetType);
            if (!this.connection.accumulateBatchResult) {
                bl2 = false;
            }
        }
        if (bl2) {
            this.validRows += this.prematureBatchCount;
            this.prematureBatchCount = 0;
        }
        return this.validRows;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ResultSet executeQuery() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OraclePreparedStatement oraclePreparedStatement = this;
            synchronized (oraclePreparedStatement) {
                this.executionType = 1;
                this.executeInternal();
                if (this.userRsetType == 1) {
                    this.currentResultSet = new OracleResultSetImpl(this.connection, this);
                    return this.currentResultSet;
                }
                if (this.scrollRset != null) return this.scrollRset;
                this.currentResultSet = new OracleResultSetImpl(this.connection, this);
                this.scrollRset = this.currentResultSet;
                return this.scrollRset;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int executeUpdate() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OraclePreparedStatement oraclePreparedStatement = this;
            synchronized (oraclePreparedStatement) {
                this.executionType = (byte)2;
                return this.executeInternal();
            }
        }
    }

    public void exitExplicitCacheToActive() throws SQLException {
        this.cacheState = 1;
        this.closed = false;
    }

    public void exitExplicitCacheToClose() throws SQLException {
        this.cacheState = 0;
        this.closed = false;
        OraclePreparedStatement oraclePreparedStatement = this;
        synchronized (oraclePreparedStatement) {
            this.hardClose();
        }
    }

    public void exitImplicitCacheToActive() throws SQLException {
        this.cacheState = 1;
        this.closed = false;
        if (this.rowPrefetch != this.connection.getDefaultRowPrefetch() && this.streamList == null) {
            this.defaultRowPrefetch = this.rowPrefetch = this.connection.getDefaultRowPrefetch();
            this.rowPrefetchChanged = true;
        }
        if (this.batch != this.connection.getDefaultExecuteBatch()) {
            this.resetBatch();
        }
        if (this.autoRefetch != this.connection.getDefaultAutoRefetch()) {
            this.autoRefetch = this.connection.getDefaultAutoRefetch();
        }
        this.processEscapes = this.connection.processEscapes;
        if (this.connection.isMemoryFreedOnEnteringCache && this.cachedDefineIndicatorSize != 0) {
            this.defineBytes = new byte[this.cachedDefineByteSize];
            this.defineChars = new char[this.cachedDefineCharSize];
            this.defineIndicators = new short[this.cachedDefineIndicatorSize];
            if (this.accessors != null) {
                int n2 = this.accessors.length;
                int n3 = 0;
                while (n3 < n2) {
                    if (this.accessors[n3] != null && this.connection.isMemoryFreedOnEnteringCache) {
                        this.accessors[n3].rowSpaceByte = this.defineBytes;
                        this.accessors[n3].rowSpaceChar = this.defineChars;
                        this.accessors[n3].rowSpaceIndicator = this.defineIndicators;
                    }
                    ++n3;
                }
            }
        }
    }

    public void exitImplicitCacheToClose() throws SQLException {
        this.cacheState = 0;
        this.closed = false;
        OraclePreparedStatement oraclePreparedStatement = this;
        synchronized (oraclePreparedStatement) {
            this.hardClose();
        }
    }

    public final int getExecuteBatch() {
        return this.batch;
    }

    int getInternalTypeForDmlReturning(int n2) throws SQLException {
        int n3 = 0;
        switch (n2) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n3 = 6;
                break;
            }
            case 100: {
                n3 = 100;
                break;
            }
            case 101: {
                n3 = 101;
                break;
            }
            case 1: {
                n3 = 96;
                break;
            }
            case 12: {
                n3 = 1;
                break;
            }
            case -1: {
                n3 = 8;
                break;
            }
            case 91: 
            case 92: {
                n3 = 12;
                break;
            }
            case 93: {
                n3 = 180;
                break;
            }
            case -101: {
                n3 = 181;
                break;
            }
            case -102: {
                n3 = 231;
                break;
            }
            case -103: {
                n3 = 182;
                break;
            }
            case -104: {
                n3 = 183;
                break;
            }
            case -3: 
            case -2: {
                n3 = 23;
                break;
            }
            case -4: {
                n3 = 24;
                break;
            }
            case -8: {
                n3 = 104;
                break;
            }
            case 2004: {
                n3 = 113;
                break;
            }
            case 2005: {
                n3 = 112;
                break;
            }
            case -13: {
                n3 = 114;
                break;
            }
            case 2002: 
            case 2003: 
            case 2007: 
            case 2008: {
                n3 = 109;
                break;
            }
            case 2006: {
                n3 = 111;
                break;
            }
            case 70: {
                n3 = 1;
                break;
            }
            default: {
                DatabaseError.throwSqlException(4);
            }
        }
        return n3;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        ResultSet resultSet = this.getResultSet();
        if (resultSet != null) {
            return resultSet.getMetaData();
        }
        return null;
    }

    static int getReturnParameterCount(String string) {
        int n2 = -1;
        String string2 = string.toUpperCase();
        int n3 = string2.indexOf("RETURNING");
        if (n3 >= 0) {
            char[] cArray = new char[string2.length() - n3];
            string2.getChars(n3, string2.length(), cArray, 0);
            n2 = 0;
            int n4 = 0;
            while (n4 < cArray.length) {
                if (cArray[n4] == '?') {
                    ++n2;
                }
                ++n4;
            }
        }
        return n2;
    }

    public ResultSet getReturnResultSet() throws SQLException {
        if (this.closed) {
            DatabaseError.throwSqlException(9);
        }
        if (this.returnParamAccessors == null || this.numReturnParams == 0) {
            DatabaseError.throwSqlException(144);
        }
        if (this.returnResultSet == null) {
            this.returnResultSet = new OracleReturnResultSet(this);
        }
        return this.returnResultSet;
    }

    void growBinds(int n2) throws SQLException {
        Object object;
        Binder[][] binderArray = this.binders;
        this.binders = new Binder[n2][];
        if (binderArray != null) {
            System.arraycopy(binderArray, 0, this.binders, 0, this.numberOfBindRowsAllocated);
        }
        int n3 = this.numberOfBindRowsAllocated;
        while (n3 < n2) {
            this.binders[n3] = new Binder[this.numberOfBindPositions];
            ++n3;
        }
        this.allocBinds(n2);
        if (this.parameterInt != null) {
            object = this.parameterInt;
            this.parameterInt = new int[n2][];
            System.arraycopy(object, 0, this.parameterInt, 0, this.numberOfBindRowsAllocated);
            n3 = this.numberOfBindRowsAllocated;
            while (n3 < n2) {
                this.parameterInt[n3] = new int[this.numberOfBindPositions];
                ++n3;
            }
        }
        if (this.parameterLong != null) {
            object = this.parameterLong;
            this.parameterLong = new long[n2][];
            System.arraycopy(object, 0, this.parameterLong, 0, this.numberOfBindRowsAllocated);
            n3 = this.numberOfBindRowsAllocated;
            while (n3 < n2) {
                this.parameterLong[n3] = new long[this.numberOfBindPositions];
                ++n3;
            }
        }
        if (this.parameterFloat != null) {
            object = this.parameterFloat;
            this.parameterFloat = new float[n2][];
            System.arraycopy(object, 0, this.parameterFloat, 0, this.numberOfBindRowsAllocated);
            n3 = this.numberOfBindRowsAllocated;
            while (n3 < n2) {
                this.parameterFloat[n3] = new float[this.numberOfBindPositions];
                ++n3;
            }
        }
        if (this.parameterDouble != null) {
            object = this.parameterDouble;
            this.parameterDouble = new double[n2][];
            System.arraycopy(object, 0, this.parameterDouble, 0, this.numberOfBindRowsAllocated);
            n3 = this.numberOfBindRowsAllocated;
            while (n3 < n2) {
                this.parameterDouble[n3] = new double[this.numberOfBindPositions];
                ++n3;
            }
        }
        if (this.parameterBigDecimal != null) {
            object = this.parameterBigDecimal;
            this.parameterBigDecimal = new BigDecimal[n2][];
            System.arraycopy(object, 0, this.parameterBigDecimal, 0, this.numberOfBindRowsAllocated);
            n3 = this.numberOfBindRowsAllocated;
            while (n3 < n2) {
                this.parameterBigDecimal[n3] = new BigDecimal[this.numberOfBindPositions];
                ++n3;
            }
        }
        if (this.parameterString != null) {
            object = this.parameterString;
            this.parameterString = new String[n2][];
            System.arraycopy(object, 0, this.parameterString, 0, this.numberOfBindRowsAllocated);
            n3 = this.numberOfBindRowsAllocated;
            while (n3 < n2) {
                this.parameterString[n3] = new String[this.numberOfBindPositions];
                ++n3;
            }
        }
        if (this.parameterDate != null) {
            object = this.parameterDate;
            this.parameterDate = new Date[n2][];
            System.arraycopy(object, 0, this.parameterDate, 0, this.numberOfBindRowsAllocated);
            n3 = this.numberOfBindRowsAllocated;
            while (n3 < n2) {
                this.parameterDate[n3] = new Date[this.numberOfBindPositions];
                ++n3;
            }
        }
        if (this.parameterTime != null) {
            object = this.parameterTime;
            this.parameterTime = new Time[n2][];
            System.arraycopy(object, 0, this.parameterTime, 0, this.numberOfBindRowsAllocated);
            n3 = this.numberOfBindRowsAllocated;
            while (n3 < n2) {
                this.parameterTime[n3] = new Time[this.numberOfBindPositions];
                ++n3;
            }
        }
        if (this.parameterTimestamp != null) {
            object = this.parameterTimestamp;
            this.parameterTimestamp = new Timestamp[n2][];
            System.arraycopy(object, 0, this.parameterTimestamp, 0, this.numberOfBindRowsAllocated);
            n3 = this.numberOfBindRowsAllocated;
            while (n3 < n2) {
                this.parameterTimestamp[n3] = new Timestamp[this.numberOfBindPositions];
                ++n3;
            }
        }
        if (this.parameterDatum != null) {
            object = this.parameterDatum;
            this.parameterDatum = new byte[n2][][];
            System.arraycopy(object, 0, this.parameterDatum, 0, this.numberOfBindRowsAllocated);
            n3 = this.numberOfBindRowsAllocated;
            while (n3 < n2) {
                this.parameterDatum[n3] = new byte[this.numberOfBindPositions][];
                ++n3;
            }
        }
        if (this.parameterOtype != null) {
            object = this.parameterOtype;
            this.parameterOtype = new OracleTypeADT[n2][];
            System.arraycopy(object, 0, this.parameterOtype, 0, this.numberOfBindRowsAllocated);
            n3 = this.numberOfBindRowsAllocated;
            while (n3 < n2) {
                this.parameterOtype[n3] = new OracleTypeADT[this.numberOfBindPositions];
                ++n3;
            }
        }
        if (this.parameterStream != null) {
            object = this.parameterStream;
            this.parameterStream = new InputStream[n2][];
            System.arraycopy(object, 0, this.parameterStream, 0, this.numberOfBindRowsAllocated);
            n3 = this.numberOfBindRowsAllocated;
            while (n3 < n2) {
                this.parameterStream[n3] = new InputStream[this.numberOfBindPositions];
                ++n3;
            }
        }
        if (this.parameterPlsqlIbt != null) {
            object = this.parameterPlsqlIbt;
            this.parameterPlsqlIbt = new PlsqlIbtBindInfo[n2][];
            System.arraycopy(object, 0, this.parameterPlsqlIbt, 0, this.numberOfBindRowsAllocated);
            n3 = this.numberOfBindRowsAllocated;
            while (n3 < n2) {
                this.parameterPlsqlIbt[n3] = new PlsqlIbtBindInfo[this.numberOfBindPositions];
                ++n3;
            }
        }
        this.numberOfBindRowsAllocated = n2;
        this.currentRowNeedToPrepareBinds = true;
    }

    protected void hardClose() throws SQLException {
        super.hardClose();
        this.bindBytes = null;
        this.bindChars = null;
        this.bindIndicators = null;
        if (!this.connection.isClosed()) {
            this.cleanAllTempLobs();
        }
        this.lastBoundBytes = null;
        this.lastBoundChars = null;
        this.clearParameters();
    }

    void initializeBindSubRanges(int n2, int n3) {
        this.bindByteSubRange = 0;
        this.bindCharSubRange = 0;
    }

    void initializeBinds() throws SQLException {
        this.numberOfBindPositions = this.sqlObject.getParameterCount();
        if (this.numberOfBindPositions == 0) {
            this.currentRowNeedToPrepareBinds = false;
            return;
        }
        this.numberOfBindRowsAllocated = this.batch;
        this.binders = new Binder[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        this.currentRowBinders = this.binders[0];
        this.currentRowCharLens = new int[this.numberOfBindPositions];
        this.currentBatchCharLens = new int[this.numberOfBindPositions];
        this.currentRowFormOfUse = new short[this.numberOfBindPositions];
        this.currentBatchFormOfUse = new short[this.numberOfBindPositions];
        int n2 = 1;
        if (this.connection.defaultNChar) {
            n2 = 2;
        }
        int n3 = 0;
        while (n3 < this.numberOfBindPositions) {
            this.currentRowFormOfUse[n3] = n2;
            this.currentBatchFormOfUse[n3] = n2;
            ++n3;
        }
        this.lastBinders = new Binder[this.numberOfBindPositions];
        this.lastBoundCharLens = new int[this.numberOfBindPositions];
        this.lastBoundByteOffsets = new int[this.numberOfBindPositions];
        this.lastBoundCharOffsets = new int[this.numberOfBindPositions];
        this.lastBoundByteLens = new int[this.numberOfBindPositions];
        this.lastBoundInds = new short[this.numberOfBindPositions];
        this.lastBoundLens = new short[this.numberOfBindPositions];
        this.lastBoundTypeBytes = new byte[this.numberOfBindPositions][];
        this.lastBoundTypeOtypes = new OracleTypeADT[this.numberOfBindPositions];
        this.allocBinds(this.numberOfBindRowsAllocated);
    }

    void initializeIndicatorSubRange() {
        this.bindIndicatorSubRange = 0;
    }

    boolean isJdbcBatchStyle() {
        return this.m_batchStyle == 2;
    }

    void prepareBindPreambles(int n2, int n3) {
    }

    void printByteArray(byte[] byArray) {
        if (byArray != null) {
            int n2 = byArray.length;
            int n3 = 0;
            while (n3 < n2) {
                int n4 = byArray[n3] & 0xFF;
                ++n3;
            }
        }
    }

    void processCompletedBindRow(int n2, boolean bl2) throws SQLException {
        int n3;
        Object object;
        Object object2;
        int n4;
        Binder[] binderArray;
        boolean bl3;
        if (this.numberOfBindPositions == 0) {
            return;
        }
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = bl3 = this.currentRank == this.firstRowInBatch;
        Binder[] binderArray2 = this.currentRank == 0 ? (this.lastBinders[0] == null ? null : this.lastBinders) : (binderArray = this.binders[this.currentRank - 1]);
        if (this.currentRowBindAccessors == null) {
            if (binderArray == null) {
                n4 = 0;
                while (n4 < this.numberOfBindPositions) {
                    if (this.currentRowBinders[n4] == null) {
                        DatabaseError.throwSqlException(41, new Integer(n4 + 1));
                    }
                    ++n4;
                }
            } else if (this.checkBindTypes) {
                object2 = this.currentRank == 0 ? this.lastBoundTypeOtypes : (this.parameterOtype == null ? null : this.parameterOtype[this.currentRank - 1]);
                n4 = 0;
                while (n4 < this.numberOfBindPositions) {
                    object = this.currentRowBinders[n4];
                    if (object == null) {
                        if (this.clearParameters) {
                            DatabaseError.throwSqlException(41, new Integer(n4 + 1));
                        }
                        this.currentRowBinders[n4] = binderArray[n4].copyingBinder();
                        this.currentRowCharLens[n4] = -1;
                        if (bl3) {
                            this.lastBoundNeeded = true;
                        }
                    } else {
                        short s2 = ((Binder)object).type;
                        if (s2 != binderArray[n4].type || (s2 == 109 || s2 == 111) && !this.parameterOtype[this.currentRank][n4].isInHierarchyOf(object2[n4]) || s2 == 9 && ((Binder)object).bytelen == 0 != (binderArray[n4].bytelen == 0)) {
                            bl4 = true;
                        }
                    }
                    if (this.currentBatchFormOfUse[n4] != this.currentRowFormOfUse[n4]) {
                        bl4 = true;
                    }
                    ++n4;
                }
            } else {
                n4 = 0;
                while (n4 < this.numberOfBindPositions) {
                    object2 = this.currentRowBinders[n4];
                    if (object2 == null) {
                        if (this.clearParameters) {
                            DatabaseError.throwSqlException(41, new Integer(n4 + 1));
                        }
                        this.currentRowBinders[n4] = binderArray[n4].copyingBinder();
                        this.currentRowCharLens[n4] = -1;
                        if (bl3) {
                            this.lastBoundNeeded = true;
                        }
                    }
                    ++n4;
                }
            }
        } else if (binderArray == null) {
            n4 = 0;
            while (n4 < this.numberOfBindPositions) {
                object2 = this.currentRowBinders[n4];
                object = this.currentRowBindAccessors[n4];
                if (object2 == null) {
                    if (object == null) {
                        DatabaseError.throwSqlException(41, new Integer(n4 + 1));
                    } else {
                        this.currentRowBinders[n4] = this.theOutBinder;
                    }
                } else if (!(object == null || ((Accessor)object).defineType == object2.type || this.connection.looseTimestampDateCheck && object2.type == 180 && ((Accessor)object).defineType == 12)) {
                    bl5 = true;
                }
                ++n4;
            }
        } else if (this.checkBindTypes) {
            object2 = this.currentRank == 0 ? this.lastBoundTypeOtypes : (this.parameterOtype == null ? null : this.parameterOtype[this.currentRank - 1]);
            n4 = 0;
            while (n4 < this.numberOfBindPositions) {
                object = this.currentRowBinders[n4];
                Accessor accessor = this.currentRowBindAccessors[n4];
                if (object == null) {
                    if (this.clearParameters && binderArray[n4] != this.theOutBinder) {
                        DatabaseError.throwSqlException(41, new Integer(n4 + 1));
                    }
                    this.currentRowBinders[n4] = object = binderArray[n4];
                    this.currentRowCharLens[n4] = -1;
                    if (bl3 && object != this.theOutBinder) {
                        this.lastBoundNeeded = true;
                    }
                } else {
                    short s3 = ((Binder)object).type;
                    if (s3 != binderArray[n4].type || (s3 == 109 || s3 == 111) && !this.parameterOtype[this.currentRank][n4].isInHierarchyOf(object2[n4]) || s3 == 9 && ((Binder)object).bytelen == 0 != (binderArray[n4].bytelen == 0)) {
                        bl4 = true;
                    }
                }
                if (this.currentBatchFormOfUse[n4] != this.currentRowFormOfUse[n4]) {
                    bl4 = true;
                }
                Accessor accessor2 = this.currentBatchBindAccessors[n4];
                if (accessor == null) {
                    this.currentRowBindAccessors[n4] = accessor = accessor2;
                } else if (accessor2 != null && accessor.defineType != accessor2.defineType) {
                    bl4 = true;
                }
                if (!(accessor == null || object == this.theOutBinder || accessor.defineType == ((Binder)object).type || this.connection.looseTimestampDateCheck && ((Binder)object).type == 180 && accessor.defineType == 12)) {
                    bl5 = true;
                }
                ++n4;
            }
        } else {
            n4 = 0;
            while (n4 < this.numberOfBindPositions) {
                object2 = this.currentRowBinders[n4];
                if (object2 == null) {
                    if (this.clearParameters && binderArray[n4] != this.theOutBinder) {
                        DatabaseError.throwSqlException(41, new Integer(n4 + 1));
                    }
                    this.currentRowBinders[n4] = object2 = binderArray[n4];
                    this.currentRowCharLens[n4] = -1;
                    if (bl3 && object2 != this.theOutBinder) {
                        this.lastBoundNeeded = true;
                    }
                }
                if (this.currentRowBindAccessors[n4] == null) {
                    this.currentRowBindAccessors[n4] = this.currentBatchBindAccessors[n4];
                }
                ++n4;
            }
        }
        if (bl4) {
            if (!bl3) {
                if (this.m_batchStyle == 2) {
                    this.pushBatch(false);
                } else {
                    int n5 = this.validRows;
                    this.prematureBatchCount = this.sendBatch();
                    this.validRows = n5;
                }
            }
            this.needToParse = true;
            this.currentRowNeedToPrepareBinds = true;
        } else if (bl2) {
            this.pushBatch(false);
            this.needToParse = false;
            this.currentBatchNeedToPrepareBinds = false;
        }
        if (bl5) {
            DatabaseError.throwSqlException(12);
        }
        n4 = 0;
        while (n4 < this.numberOfBindPositions) {
            int n6 = this.currentRowCharLens[n4];
            if (n6 == -1) {
                n6 = this.lastBoundCharLens[n4];
            }
            if (this.currentBatchCharLens[n4] < n6) {
                this.currentBatchCharLens[n4] = n6;
            }
            this.currentRowCharLens[n4] = 0;
            this.currentBatchFormOfUse[n4] = this.currentRowFormOfUse[n4];
            ++n4;
        }
        if (this.currentRowNeedToPrepareBinds) {
            this.currentBatchNeedToPrepareBinds = true;
        }
        if (this.currentRowBindAccessors != null) {
            Accessor[] accessorArray = this.currentBatchBindAccessors;
            this.currentBatchBindAccessors = this.currentRowBindAccessors;
            if (accessorArray == null) {
                accessorArray = new Accessor[this.numberOfBindPositions];
            } else {
                n4 = 0;
                while (n4 < this.numberOfBindPositions) {
                    accessorArray[n4] = null;
                    ++n4;
                }
            }
            this.currentRowBindAccessors = accessorArray;
        }
        if ((n3 = this.currentRank + 1) < n2) {
            if (n3 >= this.numberOfBindRowsAllocated) {
                int n7 = this.numberOfBindRowsAllocated << 1;
                if (n7 <= n3) {
                    n7 = n3 + 1;
                }
                this.growBinds(n7);
                this.currentBatchNeedToPrepareBinds = true;
            }
            this.currentRowBinders = this.binders[n3];
        } else {
            this.setupBindBuffers(0, n2);
            this.currentRowBinders = this.binders[0];
        }
        this.currentRowNeedToPrepareBinds = false;
        this.clearParameters = false;
    }

    void processPlsqlIndexTabBinds(int n2) throws SQLException {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        Binder[] binderArray = this.binders[n2];
        PlsqlIbtBindInfo[] plsqlIbtBindInfoArray = this.parameterPlsqlIbt == null ? null : this.parameterPlsqlIbt[n2];
        int n7 = 0;
        while (n7 < this.numberOfBindPositions) {
            PlsqlIndexTableAccessor plsqlIndexTableAccessor;
            Binder binder = binderArray[n7];
            Accessor accessor = this.currentBatchBindAccessors == null ? null : this.currentBatchBindAccessors[n7];
            PlsqlIndexTableAccessor plsqlIndexTableAccessor2 = plsqlIndexTableAccessor = accessor == null || accessor.defineType != 998 ? null : (PlsqlIndexTableAccessor)accessor;
            if (binder.type == 998) {
                PlsqlIbtBindInfo plsqlIbtBindInfo = plsqlIbtBindInfoArray[n7];
                if (plsqlIndexTableAccessor != null) {
                    if (plsqlIbtBindInfo.element_internal_type != plsqlIndexTableAccessor.elementInternalType) {
                        DatabaseError.throwSqlException(12);
                    }
                    if (plsqlIbtBindInfo.maxLen < plsqlIndexTableAccessor.maxNumberOfElements) {
                        plsqlIbtBindInfo.maxLen = plsqlIndexTableAccessor.maxNumberOfElements;
                    }
                    if (plsqlIbtBindInfo.elemMaxLen < plsqlIndexTableAccessor.elementMaxLen) {
                        plsqlIbtBindInfo.elemMaxLen = plsqlIndexTableAccessor.elementMaxLen;
                    }
                    if (plsqlIbtBindInfo.ibtByteLength > 0) {
                        plsqlIbtBindInfo.ibtByteLength = plsqlIbtBindInfo.elemMaxLen * plsqlIbtBindInfo.maxLen;
                    } else {
                        plsqlIbtBindInfo.ibtCharLength = plsqlIbtBindInfo.elemMaxLen * plsqlIbtBindInfo.maxLen;
                    }
                }
                ++n3;
                n5 += plsqlIbtBindInfo.ibtByteLength;
                n6 += plsqlIbtBindInfo.ibtCharLength;
                n4 += plsqlIbtBindInfo.maxLen;
            } else if (plsqlIndexTableAccessor != null) {
                ++n3;
                n5 += plsqlIndexTableAccessor.ibtByteLength;
                n6 += plsqlIndexTableAccessor.ibtCharLength;
                n4 += plsqlIndexTableAccessor.maxNumberOfElements;
            }
            ++n7;
        }
        if (n3 == 0) {
            return;
        }
        this.ibtBindIndicatorSize = 6 + n3 * 8 + n4 * 2;
        this.ibtBindIndicators = new short[this.ibtBindIndicatorSize];
        this.ibtBindIndicatorOffset = 0;
        if (n5 > 0) {
            this.ibtBindBytes = new byte[n5];
        }
        this.ibtBindByteOffset = 0;
        if (n6 > 0) {
            this.ibtBindChars = new char[n6];
        }
        this.ibtBindCharOffset = 0;
        int n8 = this.ibtBindByteOffset;
        int n9 = this.ibtBindCharOffset;
        int n10 = this.ibtBindIndicatorOffset;
        int n11 = n10 + 6 + n3 * 8;
        this.ibtBindIndicators[n10++] = (short)(n3 >> 16);
        this.ibtBindIndicators[n10++] = (short)(n3 & 0xFFFF);
        this.ibtBindIndicators[n10++] = (short)(n5 >> 16);
        this.ibtBindIndicators[n10++] = (short)(n5 & 0xFFFF);
        this.ibtBindIndicators[n10++] = (short)(n6 >> 16);
        this.ibtBindIndicators[n10++] = (short)(n6 & 0xFFFF);
        int n12 = 0;
        while (n12 < this.numberOfBindPositions) {
            PlsqlIndexTableAccessor plsqlIndexTableAccessor;
            Binder binder = binderArray[n12];
            Accessor accessor = this.currentBatchBindAccessors == null ? null : this.currentBatchBindAccessors[n12];
            PlsqlIndexTableAccessor plsqlIndexTableAccessor3 = plsqlIndexTableAccessor = accessor == null || accessor.defineType != 998 ? null : (PlsqlIndexTableAccessor)accessor;
            if (binder.type == 998) {
                int n13;
                PlsqlIbtBindInfo plsqlIbtBindInfo = plsqlIbtBindInfoArray[n12];
                int n14 = plsqlIbtBindInfo.maxLen;
                this.ibtBindIndicators[n10++] = (short)plsqlIbtBindInfo.element_internal_type;
                this.ibtBindIndicators[n10++] = (short)plsqlIbtBindInfo.elemMaxLen;
                this.ibtBindIndicators[n10++] = (short)(n14 >> 16);
                this.ibtBindIndicators[n10++] = (short)(n14 & 0xFFFF);
                this.ibtBindIndicators[n10++] = (short)(plsqlIbtBindInfo.curLen >> 16);
                this.ibtBindIndicators[n10++] = (short)(plsqlIbtBindInfo.curLen & 0xFFFF);
                if (plsqlIbtBindInfo.ibtByteLength > 0) {
                    n13 = n8;
                    n8 += plsqlIbtBindInfo.ibtByteLength;
                } else {
                    n13 = n9;
                    n9 += plsqlIbtBindInfo.ibtCharLength;
                }
                this.ibtBindIndicators[n10++] = (short)(n13 >> 16);
                this.ibtBindIndicators[n10++] = (short)(n13 & 0xFFFF);
                plsqlIbtBindInfo.ibtValueIndex = n13;
                plsqlIbtBindInfo.ibtIndicatorIndex = n11;
                plsqlIbtBindInfo.ibtLengthIndex = n11 + n14;
                if (plsqlIndexTableAccessor != null) {
                    plsqlIndexTableAccessor.ibtIndicatorIndex = plsqlIbtBindInfo.ibtIndicatorIndex;
                    plsqlIndexTableAccessor.ibtLengthIndex = plsqlIbtBindInfo.ibtLengthIndex;
                    plsqlIndexTableAccessor.ibtMetaIndex = n10 - 8;
                    plsqlIndexTableAccessor.ibtValueIndex = n13;
                }
                n11 += 2 * n14;
            } else if (plsqlIndexTableAccessor != null) {
                int n15;
                int n16 = plsqlIndexTableAccessor.maxNumberOfElements;
                this.ibtBindIndicators[n10++] = (short)plsqlIndexTableAccessor.elementInternalType;
                this.ibtBindIndicators[n10++] = (short)plsqlIndexTableAccessor.elementMaxLen;
                this.ibtBindIndicators[n10++] = (short)(n16 >> 16);
                this.ibtBindIndicators[n10++] = (short)(n16 & 0xFFFF);
                this.ibtBindIndicators[n10++] = 0;
                this.ibtBindIndicators[n10++] = 0;
                if (plsqlIndexTableAccessor.ibtByteLength > 0) {
                    n15 = n8;
                    n8 += plsqlIndexTableAccessor.ibtByteLength;
                } else {
                    n15 = n9;
                    n9 += plsqlIndexTableAccessor.ibtCharLength;
                }
                this.ibtBindIndicators[n10++] = (short)(n15 >> 16);
                this.ibtBindIndicators[n10++] = (short)(n15 & 0xFFFF);
                plsqlIndexTableAccessor.ibtValueIndex = n15;
                plsqlIndexTableAccessor.ibtIndicatorIndex = n11;
                plsqlIndexTableAccessor.ibtLengthIndex = n11 + n16;
                plsqlIndexTableAccessor.ibtMetaIndex = n10 - 8;
                n11 += 2 * n16;
            }
            ++n12;
        }
    }

    void pushBatch(boolean bl2) {
        PushedBatch pushedBatch = new PushedBatch();
        pushedBatch.currentBatchCharLens = new int[this.numberOfBindPositions];
        System.arraycopy(this.currentBatchCharLens, 0, pushedBatch.currentBatchCharLens, 0, this.numberOfBindPositions);
        pushedBatch.lastBoundCharLens = new int[this.numberOfBindPositions];
        System.arraycopy(this.lastBoundCharLens, 0, pushedBatch.lastBoundCharLens, 0, this.numberOfBindPositions);
        if (this.currentBatchBindAccessors != null) {
            pushedBatch.currentBatchBindAccessors = new Accessor[this.numberOfBindPositions];
            System.arraycopy(this.currentBatchBindAccessors, 0, pushedBatch.currentBatchBindAccessors, 0, this.numberOfBindPositions);
        }
        pushedBatch.lastBoundNeeded = this.lastBoundNeeded;
        pushedBatch.need_to_parse = this.needToParse;
        pushedBatch.current_batch_need_to_prepare_binds = this.currentBatchNeedToPrepareBinds;
        pushedBatch.first_row_in_batch = this.firstRowInBatch;
        pushedBatch.number_of_rows_to_be_bound = this.currentRank - this.firstRowInBatch;
        if (this.pushedBatches == null) {
            this.pushedBatches = pushedBatch;
        } else {
            this.pushedBatchesTail.next = pushedBatch;
        }
        this.pushedBatchesTail = pushedBatch;
        if (!bl2) {
            int[] nArray = this.currentBatchCharLens;
            this.currentBatchCharLens = this.lastBoundCharLens;
            this.lastBoundCharLens = nArray;
            this.lastBoundNeeded = false;
            int n2 = 0;
            while (n2 < this.numberOfBindPositions) {
                this.currentBatchCharLens[n2] = 0;
                ++n2;
            }
            this.firstRowInBatch = this.currentRank;
        }
    }

    public void registerReturnParameter(int n2, int n3) throws SQLException {
        int n4;
        if (this.numberOfBindPositions <= 0) {
            DatabaseError.throwSqlException(90);
        }
        if (this.numReturnParams <= 0) {
            this.numReturnParams = OraclePreparedStatement.getReturnParameterCount(this.sqlObject.getOriginalSql());
            if (this.numReturnParams <= 0) {
                DatabaseError.throwSqlException(90);
            }
        }
        if ((n4 = n2 - 1) < this.numberOfBindPositions - this.numReturnParams || n2 > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        int n5 = this.getInternalTypeForDmlReturning(n3);
        short s2 = 0;
        if (this.currentRowFormOfUse != null && this.currentRowFormOfUse[n4] != 0) {
            s2 = this.currentRowFormOfUse[n4];
        }
        this.registerReturnParameterInternal(n4, n5, n3, -1, s2, null);
        this.currentRowBinders[n4] = this.theReturnParamBinder;
    }

    public void registerReturnParameter(int n2, int n3, int n4) throws SQLException {
        int n5;
        if (this.numberOfBindPositions <= 0) {
            DatabaseError.throwSqlException(90);
        }
        if ((n5 = n2 - 1) < 0 || n2 > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        if (n3 != 1 && n3 != 12 && n3 != -1 && n3 != -2 && n3 != -3 && n3 != -4 && n3 != 12) {
            DatabaseError.throwSqlException(68);
        }
        if (n4 <= 0) {
            DatabaseError.throwSqlException(68);
        }
        int n6 = this.getInternalTypeForDmlReturning(n3);
        short s2 = 0;
        if (this.currentRowFormOfUse != null && this.currentRowFormOfUse[n5] != 0) {
            s2 = this.currentRowFormOfUse[n5];
        }
        this.registerReturnParameterInternal(n5, n6, n3, n4, s2, null);
        this.currentRowBinders[n5] = this.theReturnParamBinder;
    }

    public void registerReturnParameter(int n2, int n3, String string) throws SQLException {
        int n4;
        int n5;
        if (this.numberOfBindPositions <= 0) {
            DatabaseError.throwSqlException(90);
        }
        if ((n5 = n2 - 1) < 0 || n2 > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        if ((n4 = this.getInternalTypeForDmlReturning(n3)) != 111 && n4 != 109) {
            DatabaseError.throwSqlException(68);
        }
        this.registerReturnParameterInternal(n5, n4, n3, -1, (short)0, string);
        this.currentRowBinders[n5] = this.theReturnParamBinder;
    }

    void registerReturnParamsForAutoKey() throws SQLException {
        int[] nArray = this.autoKeyInfo.returnTypes;
        short[] sArray = this.autoKeyInfo.tableFormOfUses;
        int[] nArray2 = this.autoKeyInfo.columnIndexes;
        int n2 = nArray.length;
        int n3 = this.numberOfBindPositions - n2;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = n3 + n4;
            this.currentRowBinders[n5] = this.theReturnParamBinder;
            short s2 = 0;
            if (sArray != null && nArray2 != null && sArray[nArray2[n4] - 1] == 2) {
                s2 = 2;
                this.setFormOfUse(n5 + 1, s2);
            }
            this.checkTypeForAutoKey(nArray[n4]);
            String string = null;
            if (nArray[n4] == 111) {
                string = this.autoKeyInfo.tableTypeNames[nArray2[n4] - 1];
            }
            this.registerReturnParameterInternal(n5, nArray[n4], nArray[n4], -1, s2, string);
            ++n4;
        }
    }

    void resetBatch() {
        this.batch = this.connection.getDefaultExecuteBatch();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int sendBatch() throws SQLException {
        if (this.isJdbcBatchStyle()) {
            return 0;
        }
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OraclePreparedStatement oraclePreparedStatement = this;
            synchronized (oraclePreparedStatement) {
                int n2;
                try {
                    this.ensureOpen();
                    if (this.currentRank <= 0) {
                        int n3 = this.connection.accumulateBatchResult ? 0 : this.validRows;
                        Object var7_5 = null;
                        this.currentRank = 0;
                        return n3;
                    }
                    int n4 = this.batch;
                    try {
                        int n5 = this.currentRank;
                        if (this.batch != this.currentRank) {
                            this.batch = this.currentRank;
                        }
                        this.setupBindBuffers(0, this.currentRank);
                        --this.currentRank;
                        this.doExecuteWithTimeout();
                        this.slideDownCurrentRow(n5);
                    }
                    finally {
                        Object var10_14 = null;
                        if (this.batch != n4) {
                            this.batch = n4;
                        }
                    }
                    if (this.connection.accumulateBatchResult) {
                        this.validRows += this.prematureBatchCount;
                        this.prematureBatchCount = 0;
                    }
                    n2 = this.validRows;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    this.currentRank = 0;
                    throw throwable;
                }
                Object var7_6 = null;
                this.currentRank = 0;
                return n2;
            }
        }
    }

    public void setARRAY(int n2, ARRAY aRRAY) throws SQLException {
        this.setARRAYInternal(n2, aRRAY);
    }

    public void setARRAYAtName(String string, ARRAY aRRAY) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl2 = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n3 = 0;
        while (n3 < n2) {
            if (stringArray[n3] == string2) {
                this.setARRAYInternal(n3 + 1, aRRAY);
                bl2 = true;
            }
            ++n3;
        }
        if (!bl2) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setARRAYInternal(int n2, ARRAY aRRAY) throws SQLException {
        int n3 = n2 - 1;
        if (n3 < 0 || n2 > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        if (aRRAY == null) {
            DatabaseError.throwSqlException(68);
        } else {
            PhysicalConnection physicalConnection = this.connection;
            synchronized (physicalConnection) {
                OraclePreparedStatement oraclePreparedStatement = this;
                synchronized (oraclePreparedStatement) {
                    this.setArrayCritical(n3, aRRAY);
                    this.currentRowCharLens[n3] = 0;
                }
            }
        }
    }

    public void setArray(int n2, Array array) throws SQLException {
        this.setARRAYInternal(n2, (ARRAY)array);
    }

    public void setArrayAtName(String string, Array array) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl2 = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n3 = 0;
        while (n3 < n2) {
            if (stringArray[n3] == string2) {
                this.setArrayInternal(n3 + 1, array);
                bl2 = true;
            }
            ++n3;
        }
        if (!bl2) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setArrayCritical(int n2, ARRAY aRRAY) throws SQLException {
        ArrayDescriptor arrayDescriptor = aRRAY.getDescriptor();
        if (arrayDescriptor == null) {
            DatabaseError.throwSqlException(61);
        }
        this.currentRowBinders[n2] = this.theNamedTypeBinder;
        if (this.parameterDatum == null) {
            this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
        }
        this.parameterDatum[this.currentRank][n2] = aRRAY.toBytes();
        OracleTypeCOLLECTION oracleTypeCOLLECTION = arrayDescriptor.getOracleTypeCOLLECTION();
        oracleTypeCOLLECTION.getTOID();
        if (this.parameterOtype == null) {
            this.parameterOtype = new OracleTypeADT[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        }
        this.parameterOtype[this.currentRank][n2] = oracleTypeCOLLECTION;
    }

    void setArrayInternal(int n2, Array array) throws SQLException {
        this.setARRAYInternal(n2, (ARRAY)array);
    }

    public synchronized void setAsciiStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.setAsciiStreamInternal(n2, inputStream, n3);
    }

    public void setAsciiStreamAtName(String string, InputStream inputStream, int n2) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        int n3 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        boolean bl2 = true;
        int n4 = 0;
        while (n4 < n3) {
            if (stringArray[n4] == string2) {
                if (bl2) {
                    this.setAsciiStream(n4 + 1, inputStream, n2);
                    bl2 = false;
                } else {
                    DatabaseError.throwSqlException(135);
                }
            }
            ++n4;
        }
    }

    void setAsciiStreamContentsForClobCritical(int n2, InputStream inputStream, int n3) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OraclePreparedStatement oraclePreparedStatement = this;
            synchronized (oraclePreparedStatement) {
                CLOB cLOB = CLOB.createTemporary(this.connection, true, 10, this.currentRowFormOfUse[n2 - 1]);
                OracleClobWriter oracleClobWriter = (OracleClobWriter)cLOB.setCharacterStream(1L);
                int n4 = cLOB.getBufferSize();
                byte[] byArray = new byte[n4];
                char[] cArray = new char[n4];
                int n5 = n3;
                try {
                    while (n5 >= n4) {
                        inputStream.read(byArray);
                        DBConversion cfr_ignored_0 = this.connection.conversion;
                        DBConversion.asciiBytesToJavaChars(byArray, n4, cArray);
                        oracleClobWriter.write(cArray);
                        n5 -= n4;
                    }
                    if (n5 > 0) {
                        inputStream.read(byArray, 0, n5);
                        DBConversion cfr_ignored_1 = this.connection.conversion;
                        DBConversion.asciiBytesToJavaChars(byArray, n5, cArray);
                        oracleClobWriter.write(cArray, 0, n5);
                    }
                    oracleClobWriter.flush();
                }
                catch (IOException iOException) {}
                this.addToTempLobsToFree(cLOB);
                this.setCLOBInternal(n2, cLOB);
            }
        }
    }

    void setAsciiStreamContentsForStringInternal(int n2, InputStream inputStream, int n3) throws SQLException {
        byte[] byArray = new byte[n3];
        int n4 = 0;
        try {
            n4 = inputStream.read(byArray, 0, n3);
            if (n4 == -1) {
                n4 = 0;
            }
        }
        catch (IOException iOException) {
            DatabaseError.throwSqlException(iOException);
        }
        if (n4 == 0) {
            this.basicBindNullString(n2);
        }
        char[] cArray = new char[n3];
        DBConversion cfr_ignored_0 = this.connection.conversion;
        DBConversion.asciiBytesToJavaChars(byArray, n4, cArray);
        this.basicBindString(n2, new String(cArray));
    }

    void setAsciiStreamInternal(int n2, InputStream inputStream, int n3) throws SQLException {
        int n4 = n2 - 1;
        if (n4 < 0 || n2 > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        this.set_execute_batch(1);
        if (inputStream == null) {
            this.basicBindNullString(n2);
        } else if (this.userRsetType != 1 && n3 > this.maxVcsCharsSql) {
            DatabaseError.throwSqlException(169);
        } else if (this.currentRowFormOfUse[n4] == 1) {
            if (this.sqlKind == 1 || this.sqlKind == 4) {
                if (n3 <= this.maxVcsCharsPlsql) {
                    this.setAsciiStreamContentsForStringInternal(n2, inputStream, n3);
                } else {
                    this.setAsciiStreamContentsForClobCritical(n2, inputStream, n3);
                }
            } else if (n3 <= this.maxVcsCharsSql) {
                this.setAsciiStreamContentsForStringInternal(n2, inputStream, n3);
            } else {
                this.basicBindAsciiStream(n2, inputStream, n3);
            }
        } else if (this.sqlKind == 1 || this.sqlKind == 4) {
            if (n3 <= this.maxVcsNCharsPlsql) {
                this.setAsciiStreamContentsForStringInternal(n2, inputStream, n3);
            } else {
                this.setAsciiStreamContentsForClobCritical(n2, inputStream, n3);
            }
        } else if (n3 <= this.maxVcsCharsSql) {
            this.setAsciiStreamContentsForStringInternal(n2, inputStream, n3);
        } else {
            this.setAsciiStreamContentsForClobCritical(n2, inputStream, n3);
        }
    }

    public synchronized void setBFILE(int n2, BFILE bFILE) throws SQLException {
        this.setBFILEInternal(n2, bFILE);
    }

    public void setBFILEAtName(String string, BFILE bFILE) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl2 = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n3 = 0;
        while (n3 < n2) {
            if (stringArray[n3] == string2) {
                this.setBFILE(n3 + 1, bFILE);
                bl2 = true;
            }
            ++n3;
        }
        if (!bl2) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setBFILEInternal(int n2, BFILE bFILE) throws SQLException {
        int n3 = n2 - 1;
        if (n3 < 0 || n2 > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        this.currentRowCharLens[n3] = 0;
        if (bFILE == null) {
            this.currentRowBinders[n3] = this.theBfileNullBinder;
        } else {
            this.currentRowBinders[n3] = this.theBfileBinder;
            if (this.parameterDatum == null) {
                this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
            }
            this.parameterDatum[this.currentRank][n3] = bFILE.getBytes();
        }
    }

    public synchronized void setBLOB(int n2, BLOB bLOB) throws SQLException {
        this.setBLOBInternal(n2, bLOB);
    }

    public void setBLOBAtName(String string, BLOB bLOB) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl2 = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n3 = 0;
        while (n3 < n2) {
            if (stringArray[n3] == string2) {
                this.setBLOB(n3 + 1, bLOB);
                bl2 = true;
            }
            ++n3;
        }
        if (!bl2) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setBLOBInternal(int n2, BLOB bLOB) throws SQLException {
        int n3 = n2 - 1;
        if (n3 < 0 || n2 > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        this.currentRowCharLens[n3] = 0;
        if (bLOB == null) {
            this.currentRowBinders[n3] = this.theBlobNullBinder;
        } else {
            this.currentRowBinders[n3] = this.theBlobBinder;
            if (this.parameterDatum == null) {
                this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
            }
            this.parameterDatum[this.currentRank][n3] = bLOB.getBytes();
        }
    }

    public synchronized void setBfile(int n2, BFILE bFILE) throws SQLException {
        this.setBFILEInternal(n2, bFILE);
    }

    public void setBfileAtName(String string, BFILE bFILE) throws SQLException {
        this.setBFILEAtName(string, bFILE);
    }

    void setBfileInternal(int n2, BFILE bFILE) throws SQLException {
        this.setBFILEInternal(n2, bFILE);
    }

    public synchronized void setBigDecimal(int n2, BigDecimal bigDecimal) throws SQLException {
        this.setBigDecimalInternal(n2, bigDecimal);
    }

    public void setBigDecimalAtName(String string, BigDecimal bigDecimal) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl2 = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n3 = 0;
        while (n3 < n2) {
            if (stringArray[n3] == string2) {
                this.setBigDecimal(n3 + 1, bigDecimal);
                bl2 = true;
            }
            ++n3;
        }
        if (!bl2) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setBigDecimalInternal(int n2, BigDecimal bigDecimal) throws SQLException {
        int n3 = n2 - 1;
        if (n3 < 0 || n2 > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        if (bigDecimal == null) {
            this.currentRowBinders[n3] = this.theVarnumNullBinder;
        } else {
            this.currentRowBinders[n3] = this.theBigDecimalBinder;
            if (this.parameterBigDecimal == null) {
                this.parameterBigDecimal = new BigDecimal[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
            }
            this.parameterBigDecimal[this.currentRank][n3] = bigDecimal;
        }
        this.currentRowCharLens[n3] = 0;
    }

    public synchronized void setBinaryDouble(int n2, double d2) throws SQLException {
        this.setBinaryDoubleInternal(n2, d2);
    }

    public synchronized void setBinaryDouble(int n2, BINARY_DOUBLE bINARY_DOUBLE) throws SQLException {
        this.setBinaryDoubleInternal(n2, bINARY_DOUBLE);
    }

    public void setBinaryDoubleAtName(String string, double d2) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl2 = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n3 = 0;
        while (n3 < n2) {
            if (stringArray[n3] == string2) {
                this.setBinaryDouble(n3 + 1, d2);
                bl2 = true;
            }
            ++n3;
        }
        if (!bl2) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    public void setBinaryDoubleAtName(String string, BINARY_DOUBLE bINARY_DOUBLE) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl2 = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n3 = 0;
        while (n3 < n2) {
            if (stringArray[n3] == string2) {
                this.setBinaryDouble(n3 + 1, bINARY_DOUBLE);
                bl2 = true;
            }
            ++n3;
        }
        if (!bl2) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setBinaryDoubleInternal(int n2, double d2) throws SQLException {
        int n3 = n2 - 1;
        if (n3 < 0 || n2 > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        this.currentRowBinders[n3] = this.theBinaryDoubleBinder;
        if (this.parameterDouble == null) {
            this.parameterDouble = new double[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        }
        this.currentRowCharLens[n3] = 0;
        this.parameterDouble[this.currentRank][n3] = d2;
    }

    void setBinaryDoubleInternal(int n2, BINARY_DOUBLE bINARY_DOUBLE) throws SQLException {
        int n3 = n2 - 1;
        if (n3 < 0 || n2 > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        if (bINARY_DOUBLE == null) {
            this.currentRowBinders[n3] = this.theBINARY_DOUBLENullBinder;
        } else {
            this.currentRowBinders[n3] = this.theBINARY_DOUBLEBinder;
            if (this.parameterDatum == null) {
                this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
            }
            this.parameterDatum[this.currentRank][n3] = bINARY_DOUBLE.getBytes();
        }
        this.currentRowCharLens[n3] = 0;
    }

    public synchronized void setBinaryFloat(int n2, float f2) throws SQLException {
        this.setBinaryFloatInternal(n2, f2);
    }

    public synchronized void setBinaryFloat(int n2, BINARY_FLOAT bINARY_FLOAT) throws SQLException {
        this.setBinaryFloatInternal(n2, bINARY_FLOAT);
    }

    public void setBinaryFloatAtName(String string, float f2) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl2 = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n3 = 0;
        while (n3 < n2) {
            if (stringArray[n3] == string2) {
                this.setBinaryFloat(n3 + 1, f2);
                bl2 = true;
            }
            ++n3;
        }
        if (!bl2) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    public void setBinaryFloatAtName(String string, BINARY_FLOAT bINARY_FLOAT) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl2 = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n3 = 0;
        while (n3 < n2) {
            if (stringArray[n3] == string2) {
                this.setBinaryFloat(n3 + 1, bINARY_FLOAT);
                bl2 = true;
            }
            ++n3;
        }
        if (!bl2) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setBinaryFloatInternal(int n2, float f2) throws SQLException {
        int n3 = n2 - 1;
        if (n3 < 0 || n2 > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        this.currentRowCharLens[n3] = 0;
        this.currentRowBinders[n3] = this.theBinaryFloatBinder;
        if (this.parameterFloat == null) {
            this.parameterFloat = new float[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        }
        this.parameterFloat[this.currentRank][n3] = f2;
    }

    void setBinaryFloatInternal(int n2, BINARY_FLOAT bINARY_FLOAT) throws SQLException {
        int n3 = n2 - 1;
        if (n3 < 0 || n2 > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        if (bINARY_FLOAT == null) {
            this.currentRowBinders[n3] = this.theBINARY_FLOATNullBinder;
        } else {
            this.currentRowBinders[n3] = this.theBINARY_FLOATBinder;
            if (this.parameterDatum == null) {
                this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
            }
            this.parameterDatum[this.currentRank][n3] = bINARY_FLOAT.getBytes();
        }
        this.currentRowCharLens[n3] = 0;
    }

    public synchronized void setBinaryStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.setBinaryStreamInternal(n2, inputStream, n3);
    }

    public void setBinaryStreamAtName(String string, InputStream inputStream, int n2) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        int n3 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        boolean bl2 = true;
        int n4 = 0;
        while (n4 < n3) {
            if (stringArray[n4] == string2) {
                if (bl2) {
                    this.setBinaryStream(n4 + 1, inputStream, n2);
                    bl2 = false;
                } else {
                    DatabaseError.throwSqlException(135);
                }
            }
            ++n4;
        }
    }

    void setBinaryStreamContentsForBlobCritical(int n2, InputStream inputStream, int n3) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OraclePreparedStatement oraclePreparedStatement = this;
            synchronized (oraclePreparedStatement) {
                BLOB bLOB = BLOB.createTemporary(this.connection, true, 10);
                OracleBlobOutputStream oracleBlobOutputStream = (OracleBlobOutputStream)bLOB.setBinaryStream(1L);
                int n4 = bLOB.getBufferSize();
                byte[] byArray = new byte[n4];
                int n5 = n3;
                try {
                    while (n5 >= n4) {
                        inputStream.read(byArray);
                        oracleBlobOutputStream.write(byArray);
                        n5 -= n4;
                    }
                    if (n5 > 0) {
                        inputStream.read(byArray, 0, n5);
                        oracleBlobOutputStream.write(byArray, 0, n5);
                    }
                    oracleBlobOutputStream.flush();
                }
                catch (IOException iOException) {}
                this.addToTempLobsToFree(bLOB);
                this.setBLOBInternal(n2, bLOB);
            }
        }
    }

    void setBinaryStreamContentsForByteArrayInternal(int n2, InputStream inputStream, int n3) throws SQLException {
        byte[] byArray = new byte[n3];
        int n4 = 0;
        try {
            n4 = inputStream.read(byArray, 0, n3);
            if (n4 == -1) {
                n4 = 0;
            }
        }
        catch (IOException iOException) {
            DatabaseError.throwSqlException(iOException);
        }
        if (n4 != n3) {
            byte[] byArray2 = new byte[n4];
            System.arraycopy(byArray, 0, byArray2, 0, n4);
            byArray = byArray2;
        }
        this.setBytesInternal(n2, byArray);
    }

    void setBinaryStreamInternal(int n2, InputStream inputStream, int n3) throws SQLException {
        int n4 = n2 - 1;
        if (n4 < 0 || n2 > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        this.set_execute_batch(1);
        if (inputStream == null) {
            this.setRAWInternal(n2, null);
        } else if (this.userRsetType != 1 && n3 > this.maxRawBytesSql) {
            DatabaseError.throwSqlException(169);
        } else if (this.sqlKind == 1 || this.sqlKind == 4) {
            if (n3 > this.maxRawBytesPlsql) {
                this.setBinaryStreamContentsForBlobCritical(n2, inputStream, n3);
            } else {
                this.setBinaryStreamContentsForByteArrayInternal(n2, inputStream, n3);
            }
        } else if (n3 > this.maxRawBytesSql) {
            this.basicBindBinaryStream(n2, inputStream, n3);
        } else {
            this.setBinaryStreamContentsForByteArrayInternal(n2, inputStream, n3);
        }
    }

    public synchronized void setBlob(int n2, Blob blob) throws SQLException {
        this.setBLOBInternal(n2, (BLOB)blob);
    }

    public void setBlobAtName(String string, Blob blob) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl2 = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n3 = 0;
        while (n3 < n2) {
            if (stringArray[n3] == string2) {
                this.setBlob(n3 + 1, blob);
                bl2 = true;
            }
            ++n3;
        }
        if (!bl2) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setBlobInternal(int n2, Blob blob) throws SQLException {
        this.setBLOBInternal(n2, (BLOB)blob);
    }

    public synchronized void setBoolean(int n2, boolean bl2) throws SQLException {
        this.setBooleanInternal(n2, bl2);
    }

    public void setBooleanAtName(String string, boolean bl2) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl3 = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n3 = 0;
        while (n3 < n2) {
            if (stringArray[n3] == string2) {
                this.setBoolean(n3 + 1, bl2);
                bl3 = true;
            }
            ++n3;
        }
        if (!bl3) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setBooleanInternal(int n2, boolean bl2) throws SQLException {
        int n3 = n2 - 1;
        if (n3 < 0 || n2 > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        this.currentRowCharLens[n3] = 0;
        this.currentRowBinders[n3] = this.theBooleanBinder;
        if (this.parameterInt == null) {
            this.parameterInt = new int[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        }
        this.parameterInt[this.currentRank][n3] = bl2 ? 1 : 0;
    }

    public synchronized void setByte(int n2, byte by) throws SQLException {
        this.setByteInternal(n2, by);
    }

    public void setByteAtName(String string, byte by) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl2 = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n3 = 0;
        while (n3 < n2) {
            if (stringArray[n3] == string2) {
                this.setByte(n3 + 1, by);
                bl2 = true;
            }
            ++n3;
        }
        if (!bl2) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setByteInternal(int n2, byte by) throws SQLException {
        int n3 = n2 - 1;
        if (n3 < 0 || n2 > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        this.currentRowCharLens[n3] = 0;
        this.currentRowBinders[n3] = this.theByteBinder;
        if (this.parameterInt == null) {
            this.parameterInt = new int[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        }
        this.parameterInt[this.currentRank][n3] = by;
    }

    public synchronized void setBytes(int n2, byte[] byArray) throws SQLException {
        this.setBytesInternal(n2, byArray);
    }

    public void setBytesAtName(String string, byte[] byArray) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl2 = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n3 = 0;
        while (n3 < n2) {
            if (stringArray[n3] == string2) {
                this.setBytes(n3 + 1, byArray);
                bl2 = true;
            }
            ++n3;
        }
        if (!bl2) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    public void setBytesForBlob(int n2, byte[] byArray) throws SQLException {
        if (byArray == null) {
            this.setNull(n2, -2);
            return;
        }
        int n3 = byArray.length;
        if (n3 == 0) {
            this.setNull(n2, -2);
            return;
        }
        if (this.sqlKind == 1 || this.sqlKind == 4) {
            if (n3 <= this.maxRawBytesPlsql) {
                this.setBytes(n2, byArray);
            } else {
                this.setBytesForBlobCritical(n2, byArray);
            }
        } else if (n3 <= this.maxRawBytesSql) {
            this.setBytes(n2, byArray);
        } else {
            this.setBytesForBlobCritical(n2, byArray);
        }
    }

    public void setBytesForBlobAtName(String string, byte[] byArray) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl2 = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n3 = 0;
        while (n3 < n2) {
            if (stringArray[n3] == string2) {
                this.setBytesForBlob(n3 + 1, byArray);
                bl2 = true;
            }
            ++n3;
        }
        if (!bl2) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setBytesForBlobCritical(int n2, byte[] byArray) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OraclePreparedStatement oraclePreparedStatement = this;
            synchronized (oraclePreparedStatement) {
                BLOB bLOB = BLOB.createTemporary(this.connection, true, 10);
                bLOB.putBytes(1L, byArray);
                this.addToTempLobsToFree(bLOB);
                this.setBLOBInternal(n2, bLOB);
            }
        }
    }

    void setBytesInternal(int n2, byte[] byArray) throws SQLException {
        int n3;
        int n4 = n2 - 1;
        if (n4 < 0 || n2 > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        int n5 = n3 = byArray != null ? byArray.length : 0;
        if (n3 == 0) {
            this.setNullInternal(n2, -2);
        } else if (this.sqlKind == 1) {
            if (n3 > this.maxRawBytesPlsql) {
                this.setBytesForBlobCritical(n2, byArray);
            } else {
                this.basicBindBytes(n2, byArray);
            }
        } else if (this.sqlKind == 4) {
            if (n3 > this.maxRawBytesPlsql) {
                this.setBytesForBlobCritical(n2, byArray);
            } else {
                this.basicBindBytes(n2, byArray);
            }
        } else if (n3 > this.maxRawBytesSql) {
            this.bindBytesAsStream(n2, byArray);
        } else {
            this.basicBindBytes(n2, byArray);
        }
    }

    public synchronized void setCHAR(int n2, CHAR cHAR) throws SQLException {
        this.setCHARInternal(n2, cHAR);
    }

    public void setCHARAtName(String string, CHAR cHAR) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl2 = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n3 = 0;
        while (n3 < n2) {
            if (stringArray[n3] == string2) {
                this.setCHAR(n3 + 1, cHAR);
                bl2 = true;
            }
            ++n3;
        }
        if (!bl2) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setCHARInternal(int n2, CHAR cHAR) throws SQLException {
        int n3 = n2 - 1;
        if (n3 < 0 || n2 > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        if (cHAR == null || cHAR.shareBytes().length == 0) {
            this.currentRowBinders[n3] = this.theSetCHARNullBinder;
            this.currentRowCharLens[n3] = 1;
        } else {
            byte[] byArray;
            CharacterSet characterSet;
            short s2 = (short)cHAR.oracleId();
            this.currentRowBinders[n3] = this.theSetCHARBinder;
            if (this.parameterDatum == null) {
                this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
            }
            CharacterSet characterSet2 = characterSet = this.currentRowFormOfUse[n3] == 2 ? this.connection.setCHARNCharSetObj : this.connection.setCHARCharSetObj;
            if (characterSet != null && characterSet.getOracleId() != s2) {
                byte[] byArray2 = cHAR.shareBytes();
                byArray = characterSet.convert(cHAR.getCharacterSet(), byArray2, 0, byArray2.length);
            } else {
                byArray = cHAR.getBytes();
            }
            this.parameterDatum[this.currentRank][n3] = byArray;
            this.currentRowCharLens[n3] = (byArray.length + 1 >> 1) + 1;
        }
        if ((this.sqlKind == 1 || this.sqlKind == 4) && this.currentRowCharLens[n3] < this.minVcsBindSize) {
            this.currentRowCharLens[n3] = this.minVcsBindSize;
        }
    }

    public synchronized void setCLOB(int n2, CLOB cLOB) throws SQLException {
        this.setCLOBInternal(n2, cLOB);
    }

    public void setCLOBAtName(String string, CLOB cLOB) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl2 = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n3 = 0;
        while (n3 < n2) {
            if (stringArray[n3] == string2) {
                this.setCLOB(n3 + 1, cLOB);
                bl2 = true;
            }
            ++n3;
        }
        if (!bl2) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setCLOBInternal(int n2, CLOB cLOB) throws SQLException {
        int n3 = n2 - 1;
        if (n3 < 0 || n2 > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        this.currentRowCharLens[n3] = 0;
        if (cLOB == null) {
            this.currentRowBinders[n3] = this.theClobNullBinder;
        } else {
            this.currentRowBinders[n3] = this.theClobBinder;
            if (this.parameterDatum == null) {
                this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
            }
            this.parameterDatum[this.currentRank][n3] = cLOB.getBytes();
        }
    }

    public void setCharacterStream(int n2, Reader reader, int n3) throws SQLException {
        this.setCharacterStreamInternal(n2, reader, n3);
    }

    void setCharacterStreamInternal(int n2, Reader reader, int n3) throws SQLException {
        int n4 = n2 - 1;
        if (n4 < 0 || n2 > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        this.set_execute_batch(1);
        if (reader == null) {
            this.basicBindNullString(n2);
        } else if (this.userRsetType != 1 && n3 > this.maxVcsCharsSql) {
            DatabaseError.throwSqlException(169);
        } else if (this.currentRowFormOfUse[n4] == 1) {
            if (this.sqlKind == 1 || this.sqlKind == 4) {
                if (n3 > this.maxVcsBytesPlsql || n3 > this.maxVcsCharsPlsql & this.isServerCharSetFixedWidth) {
                    this.setReaderContentsForClobCritical(n2, reader, n3);
                } else if (n3 <= this.maxVcsCharsPlsql) {
                    this.setReaderContentsForStringInternal(n2, reader, n3);
                } else {
                    this.setReaderContentsForStringOrClobInVariableWidthCase(n2, reader, n3, false);
                }
            } else if (n3 <= this.maxVcsCharsSql) {
                this.setReaderContentsForStringInternal(n2, reader, n3);
            } else {
                this.basicBindCharacterStream(n2, reader, n3);
            }
        } else if (this.sqlKind == 1 || this.sqlKind == 4) {
            if (n3 > this.maxVcsBytesPlsql || n3 > this.maxVcsNCharsPlsql & this.isServerCharSetFixedWidth) {
                this.setReaderContentsForClobCritical(n2, reader, n3);
            } else if (n3 <= this.maxVcsNCharsPlsql) {
                this.setReaderContentsForStringInternal(n2, reader, n3);
            } else {
                this.setReaderContentsForStringOrClobInVariableWidthCase(n2, reader, n3, true);
            }
        } else if (n3 <= this.maxVcsCharsSql) {
            this.setReaderContentsForStringInternal(n2, reader, n3);
        } else {
            this.setReaderContentsForClobCritical(n2, reader, n3);
        }
    }

    public void setCheckBindTypes(boolean bl2) {
        this.checkBindTypes = bl2;
    }

    public synchronized void setClob(int n2, Clob clob) throws SQLException {
        this.setCLOBInternal(n2, (CLOB)clob);
    }

    public void setClobAtName(String string, Clob clob) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl2 = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n3 = 0;
        while (n3 < n2) {
            if (stringArray[n3] == string2) {
                this.setClob(n3 + 1, clob);
                bl2 = true;
            }
            ++n3;
        }
        if (!bl2) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setClobInternal(int n2, Clob clob) throws SQLException {
        this.setCLOBInternal(n2, (CLOB)clob);
    }

    public synchronized void setCursor(int n2, ResultSet resultSet) throws SQLException {
        this.setCursorInternal(n2, resultSet);
    }

    public void setCursorAtName(String string, ResultSet resultSet) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl2 = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n3 = 0;
        while (n3 < n2) {
            if (stringArray[n3] == string2) {
                this.setCursor(n3 + 1, resultSet);
                bl2 = true;
            }
            ++n3;
        }
        if (!bl2) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setCursorInternal(int n2, ResultSet resultSet) throws SQLException {
        throw DatabaseError.newSqlException(23);
    }

    public void setCustomDatum(int n2, CustomDatum customDatum) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OraclePreparedStatement oraclePreparedStatement = this;
            synchronized (oraclePreparedStatement) {
                this.setObjectInternal(n2, this.connection.toDatum(customDatum));
            }
        }
    }

    public void setCustomDatumAtName(String string, CustomDatum customDatum) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl2 = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n3 = 0;
        while (n3 < n2) {
            if (stringArray[n3] == string2) {
                this.setCustomDatumInternal(n3 + 1, customDatum);
                bl2 = true;
            }
            ++n3;
        }
        if (!bl2) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setCustomDatumInternal(int n2, CustomDatum customDatum) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OraclePreparedStatement oraclePreparedStatement = this;
            synchronized (oraclePreparedStatement) {
                Datum datum = this.connection.toDatum(customDatum);
                int n3 = this.sqlTypeForObject(datum);
                this.setObjectCritical(n2, datum, n3, 0);
                this.currentRowCharLens[n2 - 1] = 0;
            }
        }
    }

    public synchronized void setDATE(int n2, DATE dATE) throws SQLException {
        this.setDATEInternal(n2, dATE);
    }

    public void setDATEAtName(String string, DATE dATE) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl2 = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n3 = 0;
        while (n3 < n2) {
            if (stringArray[n3] == string2) {
                this.setDATE(n3 + 1, dATE);
                bl2 = true;
            }
            ++n3;
        }
        if (!bl2) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setDATEInternal(int n2, DATE dATE) throws SQLException {
        int n3 = n2 - 1;
        if (n3 < 0 || n2 > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        this.currentRowCharLens[n3] = 0;
        if (dATE == null) {
            this.currentRowBinders[n3] = this.theDateNullBinder;
        } else {
            this.currentRowBinders[n3] = this.theOracleDateBinder;
            if (this.parameterDatum == null) {
                this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
            }
            this.parameterDatum[this.currentRank][n3] = dATE.getBytes();
        }
    }

    public synchronized void setDate(int n2, Date date) throws SQLException {
        this.setDateInternal(n2, date);
    }

    public void setDate(int n2, Date date, Calendar calendar) throws SQLException {
        this.setDATEInternal(n2, date == null ? null : new DATE(date, calendar));
    }

    public void setDateAtName(String string, Date date) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl2 = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n3 = 0;
        while (n3 < n2) {
            if (stringArray[n3] == string2) {
                this.setDate(n3 + 1, date);
                bl2 = true;
            }
            ++n3;
        }
        if (!bl2) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setDateInternal(int n2, Date date) throws SQLException {
        int n3 = n2 - 1;
        if (n3 < 0 || n2 > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        if (date == null) {
            this.currentRowBinders[n3] = this.theDateNullBinder;
        } else {
            this.currentRowBinders[n3] = this.theDateBinder;
            if (this.parameterDate == null) {
                this.parameterDate = new Date[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
            }
            this.parameterDate[this.currentRank][n3] = date;
        }
        this.currentRowCharLens[n3] = 0;
    }

    void setDateInternal(int n2, Date date, Calendar calendar) throws SQLException {
        this.setDATEInternal(n2, date == null ? null : new DATE(date, calendar));
    }

    public synchronized void setDisableStmtCaching(boolean bl2) {
        if (bl2) {
            this.cacheState = 3;
        }
    }

    public synchronized void setDouble(int n2, double d2) throws SQLException {
        this.setDoubleInternal(n2, d2);
    }

    public void setDoubleAtName(String string, double d2) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl2 = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n3 = 0;
        while (n3 < n2) {
            if (stringArray[n3] == string2) {
                this.setDouble(n3 + 1, d2);
                bl2 = true;
            }
            ++n3;
        }
        if (!bl2) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setDoubleInternal(int n2, double d2) throws SQLException {
        int n3 = n2 - 1;
        if (n3 < 0 || n2 > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.theDoubleBinder == null) {
            String string;
            this.theDoubleBinder = theStaticDoubleBinder;
            Properties properties = this.connection.connectionProperties;
            if (properties != null && (string = properties.getProperty("SetFloatAndDoubleUseBinary")) != null && string.equalsIgnoreCase("true")) {
                this.theDoubleBinder = theStaticBinaryDoubleBinder;
            }
        }
        this.currentRowCharLens[n3] = 0;
        this.currentRowBinders[n3] = this.theDoubleBinder;
        if (this.parameterDouble == null) {
            this.parameterDouble = new double[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        }
        this.parameterDouble[this.currentRank][n3] = d2;
    }

    public synchronized void setExecuteBatch(int n2) throws SQLException {
        this.setOracleBatchStyle();
        this.set_execute_batch(n2);
    }

    public synchronized void setFixedCHAR(int n2, String string) throws SQLException {
        this.setFixedCHARInternal(n2, string);
    }

    public void setFixedCHARAtName(String string, String string2) throws SQLException {
        String string3 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl2 = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n3 = 0;
        while (n3 < n2) {
            if (stringArray[n3] == string3) {
                this.setFixedCHAR(n3 + 1, string2);
                bl2 = true;
            }
            ++n3;
        }
        if (!bl2) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setFixedCHARInternal(int n2, String string) throws SQLException {
        int n3 = n2 - 1;
        if (n3 < 0 || n2 > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        int n4 = 0;
        if (string != null) {
            n4 = string.length();
        }
        if (n4 > 32766) {
            DatabaseError.throwSqlException(157);
        }
        if (string == null) {
            this.currentRowBinders[n3] = this.theFixedCHARNullBinder;
            this.currentRowCharLens[n3] = 1;
        } else {
            this.currentRowBinders[n3] = this.theFixedCHARBinder;
            this.currentRowCharLens[n3] = n4 + 1;
            if (this.parameterString == null) {
                this.parameterString = new String[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
            }
            this.parameterString[this.currentRank][n3] = string;
        }
    }

    public synchronized void setFloat(int n2, float f2) throws SQLException {
        this.setFloatInternal(n2, f2);
    }

    public void setFloatAtName(String string, float f2) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl2 = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n3 = 0;
        while (n3 < n2) {
            if (stringArray[n3] == string2) {
                this.setFloat(n3 + 1, f2);
                bl2 = true;
            }
            ++n3;
        }
        if (!bl2) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setFloatInternal(int n2, float f2) throws SQLException {
        int n3 = n2 - 1;
        if (n3 < 0 || n2 > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.theFloatBinder == null) {
            String string;
            this.theFloatBinder = theStaticFloatBinder;
            Properties properties = this.connection.connectionProperties;
            if (properties != null && (string = properties.getProperty("SetFloatAndDoubleUseBinary")) != null && string.equalsIgnoreCase("true")) {
                this.theFloatBinder = theStaticBinaryFloatBinder;
            }
        }
        this.currentRowCharLens[n3] = 0;
        this.currentRowBinders[n3] = this.theFloatBinder;
        if (this.theFloatBinder == theStaticFloatBinder) {
            if (this.parameterDouble == null) {
                this.parameterDouble = new double[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
            }
            this.parameterDouble[this.currentRank][n3] = f2;
        } else {
            if (this.parameterFloat == null) {
                this.parameterFloat = new float[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
            }
            this.parameterFloat[this.currentRank][n3] = f2;
        }
    }

    public synchronized void setFormOfUse(int n2, short s2) {
        int n3 = n2 - 1;
        if (this.currentRowFormOfUse[n3] != s2) {
            Accessor accessor;
            this.currentRowFormOfUse[n3] = s2;
            if (this.currentRowBindAccessors != null && (accessor = this.currentRowBindAccessors[n3]) != null) {
                accessor.setFormOfUse(s2);
            }
            if (this.returnParamAccessors != null && (accessor = this.returnParamAccessors[n3]) != null) {
                accessor.setFormOfUse(s2);
            }
        }
    }

    public synchronized void setINTERVALDS(int n2, INTERVALDS iNTERVALDS) throws SQLException {
        this.setINTERVALDSInternal(n2, iNTERVALDS);
    }

    public void setINTERVALDSAtName(String string, INTERVALDS iNTERVALDS) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl2 = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n3 = 0;
        while (n3 < n2) {
            if (stringArray[n3] == string2) {
                this.setINTERVALDS(n3 + 1, iNTERVALDS);
                bl2 = true;
            }
            ++n3;
        }
        if (!bl2) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setINTERVALDSInternal(int n2, INTERVALDS iNTERVALDS) throws SQLException {
        int n3 = n2 - 1;
        if (n3 < 0 || n2 > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        if (iNTERVALDS == null) {
            this.currentRowBinders[n3] = this.theIntervalDSNullBinder;
        } else {
            this.currentRowBinders[n3] = this.theIntervalDSBinder;
            if (this.parameterDatum == null) {
                this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
            }
            this.parameterDatum[this.currentRank][n3] = iNTERVALDS.getBytes();
        }
        this.currentRowCharLens[n3] = 0;
    }

    public synchronized void setINTERVALYM(int n2, INTERVALYM iNTERVALYM) throws SQLException {
        this.setINTERVALYMInternal(n2, iNTERVALYM);
    }

    public void setINTERVALYMAtName(String string, INTERVALYM iNTERVALYM) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl2 = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n3 = 0;
        while (n3 < n2) {
            if (stringArray[n3] == string2) {
                this.setINTERVALYM(n3 + 1, iNTERVALYM);
                bl2 = true;
            }
            ++n3;
        }
        if (!bl2) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setINTERVALYMInternal(int n2, INTERVALYM iNTERVALYM) throws SQLException {
        int n3 = n2 - 1;
        if (n3 < 0 || n2 > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        if (iNTERVALYM == null) {
            this.currentRowBinders[n3] = this.theIntervalYMNullBinder;
        } else {
            this.currentRowBinders[n3] = this.theIntervalYMBinder;
            if (this.parameterDatum == null) {
                this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
            }
            this.parameterDatum[this.currentRank][n3] = iNTERVALYM.getBytes();
        }
        this.currentRowCharLens[n3] = 0;
    }

    public synchronized void setInt(int n2, int n3) throws SQLException {
        this.setIntInternal(n2, n3);
    }

    public void setIntAtName(String string, int n2) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl2 = false;
        int n3 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n4 = 0;
        while (n4 < n3) {
            if (stringArray[n4] == string2) {
                this.setInt(n4 + 1, n2);
                bl2 = true;
            }
            ++n4;
        }
        if (!bl2) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setIntInternal(int n2, int n3) throws SQLException {
        int n4 = n2 - 1;
        if (n4 < 0 || n2 > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        this.currentRowCharLens[n4] = 0;
        this.currentRowBinders[n4] = this.theIntBinder;
        if (this.parameterInt == null) {
            this.parameterInt = new int[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        }
        this.parameterInt[this.currentRank][n4] = n3;
    }

    public synchronized void setInternalBytes(int n2, byte[] byArray, int n3) throws SQLException {
        this.setInternalBytesInternal(n2, byArray, n3);
    }

    void setInternalBytesInternal(int n2, byte[] byArray, int n3) throws SQLException {
        DatabaseError.throwSqlException(23);
    }

    final void setJdbcBatchStyle() throws SQLException {
        if (this.m_batchStyle == 1) {
            DatabaseError.throwSqlException(90, "operation cannot be mixed with Oracle-style batching");
        }
        this.m_batchStyle = 2;
    }

    public synchronized void setLong(int n2, long l2) throws SQLException {
        this.setLongInternal(n2, l2);
    }

    public void setLongAtName(String string, long l2) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl2 = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n3 = 0;
        while (n3 < n2) {
            if (stringArray[n3] == string2) {
                this.setLong(n3 + 1, l2);
                bl2 = true;
            }
            ++n3;
        }
        if (!bl2) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setLongInternal(int n2, long l2) throws SQLException {
        int n3 = n2 - 1;
        if (n3 < 0 || n2 > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        this.currentRowCharLens[n3] = 0;
        this.currentRowBinders[n3] = this.theLongBinder;
        if (this.parameterLong == null) {
            this.parameterLong = new long[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        }
        this.parameterLong[this.currentRank][n3] = l2;
    }

    public synchronized void setNUMBER(int n2, NUMBER nUMBER) throws SQLException {
        this.setNUMBERInternal(n2, nUMBER);
    }

    public void setNUMBERAtName(String string, NUMBER nUMBER) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl2 = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n3 = 0;
        while (n3 < n2) {
            if (stringArray[n3] == string2) {
                this.setNUMBER(n3 + 1, nUMBER);
                bl2 = true;
            }
            ++n3;
        }
        if (!bl2) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setNUMBERInternal(int n2, NUMBER nUMBER) throws SQLException {
        int n3 = n2 - 1;
        if (n3 < 0 || n2 > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        this.currentRowCharLens[n3] = 0;
        if (nUMBER == null) {
            this.currentRowBinders[n3] = this.theVarnumNullBinder;
        } else {
            this.currentRowBinders[n3] = this.theOracleNumberBinder;
            if (this.parameterDatum == null) {
                this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
            }
            this.parameterDatum[this.currentRank][n3] = nUMBER.getBytes();
        }
    }

    public synchronized void setNull(int n2, int n3) throws SQLException {
        this.setNullCritical(n2, n3);
    }

    public void setNull(int n2, int n3, String string) throws SQLException {
        this.setNullInternal(n2, n3, string);
    }

    public void setNullAtName(String string, int n2) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl2 = false;
        int n3 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n4 = 0;
        while (n4 < n3) {
            if (stringArray[n4] == string2) {
                this.setNull(n4 + 1, n2);
                bl2 = true;
            }
            ++n4;
        }
        if (!bl2) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    public void setNullAtName(String string, int n2, String string2) throws SQLException {
        String string3 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl2 = false;
        int n3 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n4 = 0;
        while (n4 < n3) {
            if (stringArray[n4] == string3) {
                this.setNullInternal(n4 + 1, n2, string2);
                bl2 = true;
            }
            ++n4;
        }
        if (!bl2) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setNullCritial(int n2, int n3, String string) throws SQLException {
        OracleTypeADT oracleTypeADT = null;
        Binder binder = this.theNamedTypeNullBinder;
        switch (n3) {
            case 2006: {
                binder = this.theRefTypeNullBinder;
            }
            case 2002: 
            case 2008: {
                StructDescriptor structDescriptor = StructDescriptor.createDescriptor(string, (Connection)this.connection);
                oracleTypeADT = structDescriptor.getOracleTypeADT();
                break;
            }
            case 2003: {
                ArrayDescriptor arrayDescriptor = ArrayDescriptor.createDescriptor(string, (Connection)this.connection);
                oracleTypeADT = arrayDescriptor.getOracleTypeCOLLECTION();
                break;
            }
            case 2007: {
                OpaqueDescriptor opaqueDescriptor = OpaqueDescriptor.createDescriptor(string, (Connection)this.connection);
                oracleTypeADT = (OracleTypeADT)opaqueDescriptor.getPickler();
                break;
            }
        }
        this.currentRowBinders[n2] = binder;
        if (this.parameterDatum == null) {
            this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
        }
        this.parameterDatum[this.currentRank][n2] = null;
        oracleTypeADT.getTOID();
        if (this.parameterOtype == null) {
            this.parameterOtype = new OracleTypeADT[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        }
        this.parameterOtype[this.currentRank][n2] = oracleTypeADT;
    }

    void setNullCritical(int n2, int n3) throws SQLException {
        int n4 = n2 - 1;
        if (n4 < 0 || n2 > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        Binder binder = null;
        int n5 = this.getInternalType(n3);
        switch (n5) {
            case 6: {
                binder = this.theVarnumNullBinder;
                break;
            }
            case 1: 
            case 8: 
            case 96: 
            case 995: {
                binder = this.theVarcharNullBinder;
                this.currentRowCharLens[n4] = 1;
                break;
            }
            case 999: {
                binder = this.theFixedCHARNullBinder;
                break;
            }
            case 12: {
                binder = this.theDateNullBinder;
                break;
            }
            case 180: {
                binder = this.connection.v8Compatible ? this.theDateNullBinder : this.theTimestampNullBinder;
                break;
            }
            case 181: {
                binder = this.theTSTZNullBinder;
                break;
            }
            case 231: {
                binder = this.theTSLTZNullBinder;
                break;
            }
            case 104: {
                binder = this.theRowidNullBinder;
                break;
            }
            case 183: {
                binder = this.theIntervalDSNullBinder;
                break;
            }
            case 182: {
                binder = this.theIntervalYMNullBinder;
                break;
            }
            case 23: 
            case 24: {
                binder = this.theRawNullBinder;
                break;
            }
            case 100: {
                binder = this.theBinaryFloatNullBinder;
                break;
            }
            case 101: {
                binder = this.theBinaryDoubleNullBinder;
                break;
            }
            case 113: {
                binder = this.theBlobNullBinder;
                break;
            }
            case 112: {
                binder = this.theClobNullBinder;
                break;
            }
            case 114: {
                binder = this.theBfileNullBinder;
                break;
            }
            case 109: 
            case 111: {
                DatabaseError.throwSqlException(4, "sqlType=" + n3);
            }
            default: {
                DatabaseError.throwSqlException(23, "sqlType=" + n3);
            }
        }
        this.currentRowBinders[n4] = binder;
    }

    synchronized void setNullInternal(int n2, int n3) throws SQLException {
        this.setNullCritical(n2, n3);
    }

    void setNullInternal(int n2, int n3, String string) throws SQLException {
        int n4 = n2 - 1;
        if (n4 < 0 || n2 > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        if (n3 == 2002 || n3 == 2008 || n3 == 2003 || n3 == 2007 || n3 == 2006) {
            PhysicalConnection physicalConnection = this.connection;
            synchronized (physicalConnection) {
                OraclePreparedStatement oraclePreparedStatement = this;
                synchronized (oraclePreparedStatement) {
                    this.setNullCritial(n4, n3, string);
                    this.currentRowCharLens[n4] = 0;
                }
            }
        }
        this.setNullInternal(n2, n3);
        return;
    }

    public void setOPAQUE(int n2, OPAQUE oPAQUE) throws SQLException {
        this.setOPAQUEInternal(n2, oPAQUE);
    }

    public void setOPAQUEAtName(String string, OPAQUE oPAQUE) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl2 = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n3 = 0;
        while (n3 < n2) {
            if (stringArray[n3] == string2) {
                this.setOPAQUEInternal(n3 + 1, oPAQUE);
                bl2 = true;
            }
            ++n3;
        }
        if (!bl2) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setOPAQUECritical(int n2, OPAQUE oPAQUE) throws SQLException {
        OpaqueDescriptor opaqueDescriptor = oPAQUE.getDescriptor();
        if (opaqueDescriptor == null) {
            DatabaseError.throwSqlException(61);
        }
        this.currentRowBinders[n2] = this.theNamedTypeBinder;
        if (this.parameterDatum == null) {
            this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
        }
        this.parameterDatum[this.currentRank][n2] = oPAQUE.toBytes();
        OracleTypeADT oracleTypeADT = (OracleTypeADT)opaqueDescriptor.getPickler();
        oracleTypeADT.getTOID();
        if (this.parameterOtype == null) {
            this.parameterOtype = new OracleTypeADT[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        }
        this.parameterOtype[this.currentRank][n2] = oracleTypeADT;
    }

    void setOPAQUEInternal(int n2, OPAQUE oPAQUE) throws SQLException {
        int n3 = n2 - 1;
        if (n3 < 0 || n2 > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        if (oPAQUE == null) {
            DatabaseError.throwSqlException(68);
        } else {
            PhysicalConnection physicalConnection = this.connection;
            synchronized (physicalConnection) {
                OraclePreparedStatement oraclePreparedStatement = this;
                synchronized (oraclePreparedStatement) {
                    this.setOPAQUECritical(n3, oPAQUE);
                    this.currentRowCharLens[n3] = 0;
                }
            }
        }
    }

    public void setORAData(int n2, ORAData oRAData) throws SQLException {
        this.setORADataInternal(n2, oRAData);
    }

    public void setORADataAtName(String string, ORAData oRAData) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl2 = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n3 = 0;
        while (n3 < n2) {
            if (stringArray[n3] == string2) {
                this.setORADataInternal(n3 + 1, oRAData);
                bl2 = true;
            }
            ++n3;
        }
        if (!bl2) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setORADataInternal(int n2, ORAData oRAData) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OraclePreparedStatement oraclePreparedStatement = this;
            synchronized (oraclePreparedStatement) {
                Datum datum = oRAData.toDatum(this.connection);
                int n3 = this.sqlTypeForObject(datum);
                this.setObjectCritical(n2, datum, n3, 0);
                this.currentRowCharLens[n2 - 1] = 0;
            }
        }
    }

    public void setObject(int n2, Object object) throws SQLException {
        this.setObjectInternal(n2, object);
    }

    public void setObject(int n2, Object object, int n3) throws SQLException {
        this.setObjectInternal(n2, object, n3, 0);
    }

    public void setObject(int n2, Object object, int n3, int n4) throws SQLException {
        this.setObjectInternal(n2, object, n3, n4);
    }

    public void setObjectAtName(String string, Object object) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl2 = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n3 = 0;
        while (n3 < n2) {
            if (stringArray[n3] == string2) {
                this.setObjectInternal(n3 + 1, object);
                bl2 = true;
            }
            ++n3;
        }
        if (!bl2) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    public void setObjectAtName(String string, Object object, int n2) throws SQLException {
        this.setObjectAtName(string, object, n2, 0);
    }

    public void setObjectAtName(String string, Object object, int n2, int n3) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl2 = false;
        int n4 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n5 = 0;
        while (n5 < n4) {
            if (stringArray[n5] == string2) {
                this.setObjectInternal(n5 + 1, object);
                bl2 = true;
            }
            ++n5;
        }
        if (!bl2) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setObjectCritical(int n2, Object object, int n3, int n4) throws SQLException {
        switch (n3) {
            case 1: {
                if (object instanceof CHAR) {
                    this.setCHARInternal(n2, (CHAR)object);
                    break;
                }
                if (object instanceof String) {
                    this.setStringInternal(n2, (String)object);
                    break;
                }
                if (object instanceof Boolean) {
                    this.setStringInternal(n2, String.valueOf((Boolean)object != false ? 1 : 0));
                    break;
                }
                if (object instanceof Integer) {
                    this.setStringInternal(n2, String.valueOf((Integer)object));
                    break;
                }
                if (object instanceof Long) {
                    this.setStringInternal(n2, String.valueOf((Long)object));
                    break;
                }
                if (object instanceof Float) {
                    this.setStringInternal(n2, String.valueOf(((Float)object).floatValue()));
                    break;
                }
                if (object instanceof Double) {
                    this.setStringInternal(n2, String.valueOf((Double)object));
                    break;
                }
                if (object instanceof BigDecimal) {
                    this.setStringInternal(n2, ((BigDecimal)object).toString());
                    break;
                }
                if (object instanceof Date) {
                    this.setStringInternal(n2, String.valueOf(((Date)object).toString()));
                    break;
                }
                if (object instanceof Time) {
                    this.setStringInternal(n2, String.valueOf(((Time)object).toString()));
                    break;
                }
                if (object instanceof Timestamp) {
                    this.setStringInternal(n2, String.valueOf(((Timestamp)object).toString()));
                    break;
                }
                DatabaseError.throwSqlException(132);
                break;
            }
            case 12: {
                if (object instanceof String) {
                    this.setStringInternal(n2, (String)object);
                    break;
                }
                if (object instanceof Boolean) {
                    this.setStringInternal(n2, String.valueOf((Boolean)object != false ? 1 : 0));
                    break;
                }
                if (object instanceof Integer) {
                    this.setStringInternal(n2, String.valueOf((Integer)object));
                    break;
                }
                if (object instanceof Long) {
                    this.setStringInternal(n2, String.valueOf((Long)object));
                    break;
                }
                if (object instanceof Float) {
                    this.setStringInternal(n2, String.valueOf(((Float)object).floatValue()));
                    break;
                }
                if (object instanceof Double) {
                    this.setStringInternal(n2, String.valueOf((Double)object));
                    break;
                }
                if (object instanceof BigDecimal) {
                    this.setStringInternal(n2, ((BigDecimal)object).toString());
                    break;
                }
                if (object instanceof Date) {
                    this.setStringInternal(n2, String.valueOf(((Date)object).toString()));
                    break;
                }
                if (object instanceof Time) {
                    this.setStringInternal(n2, String.valueOf(((Time)object).toString()));
                    break;
                }
                if (object instanceof Timestamp) {
                    this.setStringInternal(n2, String.valueOf(((Timestamp)object).toString()));
                    break;
                }
                DatabaseError.throwSqlException(132);
                break;
            }
            case 999: {
                this.setFixedCHARInternal(n2, (String)object);
                break;
            }
            case -1: {
                if (object instanceof String) {
                    this.setStringInternal(n2, (String)object);
                    break;
                }
                if (object instanceof Boolean) {
                    this.setStringInternal(n2, String.valueOf((Boolean)object != false ? 1 : 0));
                    break;
                }
                if (object instanceof Integer) {
                    this.setStringInternal(n2, String.valueOf((Integer)object));
                    break;
                }
                if (object instanceof Long) {
                    this.setStringInternal(n2, String.valueOf((Long)object));
                    break;
                }
                if (object instanceof Float) {
                    this.setStringInternal(n2, String.valueOf(((Float)object).floatValue()));
                    break;
                }
                if (object instanceof Double) {
                    this.setStringInternal(n2, String.valueOf((Double)object));
                    break;
                }
                if (object instanceof BigDecimal) {
                    this.setStringInternal(n2, ((BigDecimal)object).toString());
                    break;
                }
                if (object instanceof Date) {
                    this.setStringInternal(n2, String.valueOf(((Date)object).toString()));
                    break;
                }
                if (object instanceof Time) {
                    this.setStringInternal(n2, String.valueOf(((Time)object).toString()));
                    break;
                }
                if (object instanceof Timestamp) {
                    this.setStringInternal(n2, String.valueOf(((Timestamp)object).toString()));
                    break;
                }
                DatabaseError.throwSqlException(132);
                break;
            }
            case 2: {
                if (object instanceof NUMBER) {
                    this.setNUMBERInternal(n2, (NUMBER)object);
                    break;
                }
                if (object instanceof Integer) {
                    this.setIntInternal(n2, (Integer)object);
                    break;
                }
                if (object instanceof Long) {
                    this.setLongInternal(n2, (Long)object);
                    break;
                }
                if (object instanceof Float) {
                    this.setFloatInternal(n2, ((Float)object).floatValue());
                    break;
                }
                if (object instanceof Double) {
                    this.setDoubleInternal(n2, (Double)object);
                    break;
                }
                if (object instanceof BigDecimal) {
                    this.setBigDecimalInternal(n2, (BigDecimal)object);
                    break;
                }
                if (object instanceof String) {
                    this.setNUMBERInternal(n2, new NUMBER((String)object, 0));
                    break;
                }
                if (object instanceof Boolean) {
                    this.setIntInternal(n2, (Boolean)object != false ? 1 : 0);
                    break;
                }
                DatabaseError.throwSqlException(132);
                break;
            }
            case 3: {
                if (object instanceof BigDecimal) {
                    this.setBigDecimalInternal(n2, (BigDecimal)object);
                    break;
                }
                if (object instanceof Number) {
                    this.setBigDecimalInternal(n2, new BigDecimal(((Number)object).doubleValue()));
                    break;
                }
                if (object instanceof NUMBER) {
                    this.setBigDecimalInternal(n2, ((NUMBER)object).bigDecimalValue());
                    break;
                }
                if (object instanceof String) {
                    this.setBigDecimalInternal(n2, new BigDecimal((String)object));
                    break;
                }
                if (object instanceof Boolean) {
                    this.setBigDecimalInternal(n2, new BigDecimal((Boolean)object != false ? 1.0 : 0.0));
                    break;
                }
                DatabaseError.throwSqlException(132);
                break;
            }
            case -7: {
                if (object instanceof Boolean) {
                    this.setByteInternal(n2, (byte)((Boolean)object != false ? 1 : 0));
                    break;
                }
                if (object instanceof String) {
                    this.setByteInternal(n2, (byte)("true".equalsIgnoreCase((String)object) || "1".equals(object) ? 1 : 0));
                    break;
                }
                if (object instanceof Number) {
                    this.setIntInternal(n2, ((Number)object).byteValue() != 0 ? 1 : 0);
                    break;
                }
                DatabaseError.throwSqlException(132);
                break;
            }
            case -6: {
                if (object instanceof Number) {
                    this.setByteInternal(n2, ((Number)object).byteValue());
                    break;
                }
                if (object instanceof String) {
                    this.setByteInternal(n2, Byte.parseByte((String)object));
                    break;
                }
                if (object instanceof Boolean) {
                    this.setByteInternal(n2, (byte)((Boolean)object != false ? 1 : 0));
                    break;
                }
                DatabaseError.throwSqlException(132);
                break;
            }
            case 5: {
                if (object instanceof Number) {
                    this.setShortInternal(n2, ((Number)object).shortValue());
                    break;
                }
                if (object instanceof String) {
                    this.setShortInternal(n2, Short.parseShort((String)object));
                    break;
                }
                if (object instanceof Boolean) {
                    this.setShortInternal(n2, (short)((Boolean)object != false ? 1 : 0));
                    break;
                }
                DatabaseError.throwSqlException(132);
                break;
            }
            case 4: {
                if (object instanceof Number) {
                    this.setIntInternal(n2, ((Number)object).intValue());
                    break;
                }
                if (object instanceof String) {
                    this.setIntInternal(n2, Integer.parseInt((String)object));
                    break;
                }
                if (object instanceof Boolean) {
                    this.setIntInternal(n2, (Boolean)object != false ? 1 : 0);
                    break;
                }
                DatabaseError.throwSqlException(132);
                break;
            }
            case -5: {
                if (object instanceof Number) {
                    this.setLongInternal(n2, ((Number)object).longValue());
                    break;
                }
                if (object instanceof String) {
                    this.setLongInternal(n2, Long.parseLong((String)object));
                    break;
                }
                if (object instanceof Boolean) {
                    this.setLongInternal(n2, (Boolean)object != false ? 1L : 0L);
                    break;
                }
                DatabaseError.throwSqlException(132);
                break;
            }
            case 7: {
                if (object instanceof Number) {
                    this.setFloatInternal(n2, ((Number)object).floatValue());
                    break;
                }
                if (object instanceof String) {
                    this.setFloatInternal(n2, Float.valueOf((String)object).floatValue());
                    break;
                }
                if (object instanceof Boolean) {
                    this.setFloatInternal(n2, (Boolean)object != false ? 1.0f : 0.0f);
                    break;
                }
                DatabaseError.throwSqlException(132);
                break;
            }
            case 6: 
            case 8: {
                if (object instanceof Number) {
                    this.setDoubleInternal(n2, ((Number)object).doubleValue());
                    break;
                }
                if (object instanceof String) {
                    this.setDoubleInternal(n2, Double.valueOf((String)object));
                    break;
                }
                if (object instanceof Boolean) {
                    this.setDoubleInternal(n2, (Boolean)object != false ? 1.0 : 0.0);
                    break;
                }
                DatabaseError.throwSqlException(132);
                break;
            }
            case -2: {
                if (object instanceof RAW) {
                    this.setRAWInternal(n2, (RAW)object);
                    break;
                }
                this.setBytesInternal(n2, (byte[])object);
                break;
            }
            case -3: {
                this.setBytesInternal(n2, (byte[])object);
                break;
            }
            case -4: {
                this.setBytesInternal(n2, (byte[])object);
                break;
            }
            case 91: {
                if (object instanceof DATE) {
                    this.setDATEInternal(n2, (DATE)object);
                    break;
                }
                if (object instanceof Date) {
                    this.setDateInternal(n2, (Date)object);
                    break;
                }
                if (object instanceof Timestamp) {
                    this.setTimestampInternal(n2, (Timestamp)object);
                    break;
                }
                if (object instanceof String) {
                    this.setDateInternal(n2, Date.valueOf((String)object));
                    break;
                }
                DatabaseError.throwSqlException(132);
                break;
            }
            case 92: {
                if (object instanceof Time) {
                    this.setTimeInternal(n2, (Time)object);
                    break;
                }
                if (object instanceof Timestamp) {
                    this.setTimeInternal(n2, new Time(((java.util.Date)((Timestamp)object)).getTime()));
                    break;
                }
                if (object instanceof Date) {
                    this.setTimeInternal(n2, new Time(((Date)object).getTime()));
                    break;
                }
                if (object instanceof String) {
                    this.setTimeInternal(n2, Time.valueOf((String)object));
                    break;
                }
                DatabaseError.throwSqlException(132);
                break;
            }
            case 93: {
                if (object instanceof TIMESTAMP) {
                    this.setTIMESTAMPInternal(n2, (TIMESTAMP)object);
                    break;
                }
                if (object instanceof Timestamp) {
                    this.setTimestampInternal(n2, (Timestamp)object);
                    break;
                }
                if (object instanceof Date) {
                    this.setDateInternal(n2, (Date)object);
                    break;
                }
                if (object instanceof DATE) {
                    this.setDATEInternal(n2, (DATE)object);
                    break;
                }
                if (object instanceof String) {
                    this.setTimestampInternal(n2, Timestamp.valueOf((String)object));
                    break;
                }
                DatabaseError.throwSqlException(132);
                break;
            }
            case -100: {
                this.setTIMESTAMPInternal(n2, (TIMESTAMP)object);
                break;
            }
            case -101: {
                this.setTIMESTAMPTZInternal(n2, (TIMESTAMPTZ)object);
                break;
            }
            case -102: {
                this.setTIMESTAMPLTZInternal(n2, (TIMESTAMPLTZ)object);
                break;
            }
            case -103: {
                this.setINTERVALYMInternal(n2, (INTERVALYM)object);
                break;
            }
            case -104: {
                this.setINTERVALDSInternal(n2, (INTERVALDS)object);
                break;
            }
            case -8: {
                this.setROWIDInternal(n2, (ROWID)object);
                break;
            }
            case 100: {
                this.setBinaryFloatInternal(n2, (BINARY_FLOAT)object);
                break;
            }
            case 101: {
                this.setBinaryDoubleInternal(n2, (BINARY_DOUBLE)object);
                break;
            }
            case 2004: {
                this.setBLOBInternal(n2, (BLOB)object);
                break;
            }
            case 2005: {
                this.setCLOBInternal(n2, (CLOB)object);
                break;
            }
            case -13: {
                this.setBFILEInternal(n2, (BFILE)object);
                break;
            }
            case 2002: 
            case 2008: {
                this.setSTRUCTInternal(n2, STRUCT.toSTRUCT(object, this.connection));
                break;
            }
            case 2003: {
                this.setARRAYInternal(n2, ARRAY.toARRAY(object, this.connection));
                break;
            }
            case 2007: {
                this.setOPAQUEInternal(n2, (OPAQUE)object);
                break;
            }
            case 2006: {
                this.setREFInternal(n2, (REF)object);
                break;
            }
            default: {
                DatabaseError.throwSqlException(4);
            }
        }
    }

    void setObjectInternal(int n2, Object object) throws SQLException {
        if (object instanceof ORAData) {
            this.setORADataInternal(n2, (ORAData)object);
        } else if (object instanceof CustomDatum) {
            this.setCustomDatumInternal(n2, (CustomDatum)object);
        } else {
            int n3 = this.sqlTypeForObject(object);
            this.setObjectInternal(n2, object, n3, 0);
        }
    }

    void setObjectInternal(int n2, Object object, int n3) throws SQLException {
        this.setObjectInternal(n2, object, n3, 0);
    }

    void setObjectInternal(int n2, Object object, int n3, int n4) throws SQLException {
        if (object == null && n3 != 2002 && n3 != 2008 && n3 != 2003 && n3 != 2007 && n3 != 2006) {
            this.setNullInternal(n2, n3);
        } else {
            if (n3 == 2002 || n3 == 2008 || n3 == 2003) {
                PhysicalConnection physicalConnection = this.connection;
                synchronized (physicalConnection) {
                    OraclePreparedStatement oraclePreparedStatement = this;
                    synchronized (oraclePreparedStatement) {
                        this.setObjectCritical(n2, object, n3, n4);
                        this.currentRowCharLens[n2 - 1] = 0;
                    }
                }
            }
            OraclePreparedStatement oraclePreparedStatement = this;
            synchronized (oraclePreparedStatement) {
                this.setObjectCritical(n2, object, n3, n4);
            }
        }
    }

    final void setOracleBatchStyle() throws SQLException {
        if (this.m_batchStyle == 2) {
            DatabaseError.throwSqlException(90, "operation cannot be mixed with JDBC-2.0-style batching");
        }
        this.m_batchStyle = 1;
    }

    public void setOracleObject(int n2, Datum datum) throws SQLException {
        this.setObjectInternal(n2, datum);
    }

    public void setOracleObjectAtName(String string, Datum datum) throws SQLException {
        this.setObjectAtName(string, datum);
    }

    void setOracleObjectInternal(int n2, Datum datum) throws SQLException {
        this.setObjectInternal(n2, datum);
    }

    public synchronized void setPlsqlIndexTable(int n2, Object object, int n3, int n4, int n5, int n6) throws SQLException {
        this.setPlsqlIndexTableInternal(n2, object, n3, n4, n5, n6);
    }

    public synchronized void setPlsqlIndexTableAtName(String string, Object object, int n2, int n3, int n4, int n5) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl2 = false;
        int n6 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n7 = 0;
        while (n7 < n6) {
            if (stringArray[n7] == string2) {
                this.setPlsqlIndexTableInternal(n7 + 1, object, n2, n3, n4, n5);
                bl2 = true;
            }
            ++n7;
        }
        if (!bl2) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setPlsqlIndexTableInternal(int n2, Object object, int n3, int n4, int n5, int n6) throws SQLException {
        int n7 = n2 - 1;
        if (n7 < 0 || n2 > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        int n8 = this.getInternalType(n5);
        Object[] objectArray = null;
        switch (n8) {
            case 1: 
            case 96: {
                String[] stringArray = null;
                int n9 = 0;
                if (object instanceof CHAR[]) {
                    CHAR[] cHARArray = (CHAR[])object;
                    n9 = cHARArray.length;
                    stringArray = new String[n9];
                    int n10 = 0;
                    while (n10 < n9) {
                        CHAR cHAR = cHARArray[n10];
                        if (cHAR != null) {
                            stringArray[n10] = cHAR.getString();
                        }
                        ++n10;
                    }
                } else if (object instanceof String[]) {
                    stringArray = (String[])object;
                    n9 = stringArray.length;
                }
                if (n6 == 0 && stringArray != null) {
                    int n11 = 0;
                    while (n11 < n9) {
                        String string = stringArray[n11];
                        if (string != null && n6 < string.length()) {
                            n6 = string.length();
                        }
                        ++n11;
                    }
                }
                objectArray = stringArray;
                break;
            }
            case 2: 
            case 6: {
                objectArray = OracleTypeNUMBER.toNUMBERArray(object, this.connection, 1L, n4);
                if (n6 == 0 && objectArray != null) {
                    n6 = 22;
                }
                this.currentRowCharLens[n7] = 0;
                break;
            }
            default: {
                DatabaseError.throwSqlException(97);
                return;
            }
        }
        this.currentRowBinders[n7] = this.thePlsqlIbtBinder;
        if (this.parameterPlsqlIbt == null) {
            this.parameterPlsqlIbt = new PlsqlIbtBindInfo[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        }
        this.parameterPlsqlIbt[this.currentRank][n7] = new PlsqlIbtBindInfo(objectArray, n3, n4, n8, n6);
        this.hasIbtBind = true;
    }

    synchronized void setPreBindsCompelete() throws SQLException {
    }

    public synchronized void setRAW(int n2, RAW rAW) throws SQLException {
        this.setRAWInternal(n2, rAW);
    }

    public void setRAWAtName(String string, RAW rAW) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl2 = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n3 = 0;
        while (n3 < n2) {
            if (stringArray[n3] == string2) {
                this.setRAW(n3 + 1, rAW);
                bl2 = true;
            }
            ++n3;
        }
        if (!bl2) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setRAWInternal(int n2, RAW rAW) throws SQLException {
        int n3 = n2 - 1;
        if (n3 < 0 || n2 > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        this.currentRowCharLens[n3] = 0;
        if (rAW == null) {
            this.currentRowBinders[n3] = this.theRawNullBinder;
        } else {
            this.setBytesInternal(n2, rAW.getBytes());
        }
    }

    public void setREF(int n2, REF rEF) throws SQLException {
        this.setREFInternal(n2, rEF);
    }

    public void setREFAtName(String string, REF rEF) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl2 = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n3 = 0;
        while (n3 < n2) {
            if (stringArray[n3] == string2) {
                this.setREFInternal(n3 + 1, rEF);
                bl2 = true;
            }
            ++n3;
        }
        if (!bl2) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setREFCritical(int n2, REF rEF) throws SQLException {
        StructDescriptor structDescriptor = rEF.getDescriptor();
        if (structDescriptor == null) {
            DatabaseError.throwSqlException(52);
        }
        this.currentRowBinders[n2] = this.theRefTypeBinder;
        if (this.parameterDatum == null) {
            this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
        }
        this.parameterDatum[this.currentRank][n2] = rEF.getBytes();
        OracleTypeADT oracleTypeADT = structDescriptor.getOracleTypeADT();
        oracleTypeADT.getTOID();
        if (this.parameterOtype == null) {
            this.parameterOtype = new OracleTypeADT[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        }
        this.parameterOtype[this.currentRank][n2] = oracleTypeADT;
    }

    void setREFInternal(int n2, REF rEF) throws SQLException {
        int n3 = n2 - 1;
        if (n3 < 0 || n2 > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        if (rEF == null) {
            DatabaseError.throwSqlException(68);
        } else {
            PhysicalConnection physicalConnection = this.connection;
            synchronized (physicalConnection) {
                OraclePreparedStatement oraclePreparedStatement = this;
                synchronized (oraclePreparedStatement) {
                    this.setREFCritical(n3, rEF);
                    this.currentRowCharLens[n3] = 0;
                }
            }
        }
    }

    public synchronized void setROWID(int n2, ROWID rOWID) throws SQLException {
        this.setROWIDInternal(n2, rOWID);
    }

    public void setROWIDAtName(String string, ROWID rOWID) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl2 = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n3 = 0;
        while (n3 < n2) {
            if (stringArray[n3] == string2) {
                this.setROWID(n3 + 1, rOWID);
                bl2 = true;
            }
            ++n3;
        }
        if (!bl2) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setROWIDInternal(int n2, ROWID rOWID) throws SQLException {
        int n3 = n2 - 1;
        if (n3 < 0 || n2 > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        if (rOWID == null) {
            this.currentRowBinders[n3] = this.theRowidNullBinder;
        } else {
            this.currentRowBinders[n3] = this.theRowidBinder;
            if (this.parameterDatum == null) {
                this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
            }
            this.parameterDatum[this.currentRank][n3] = rOWID.getBytes();
        }
        this.currentRowCharLens[n3] = 0;
    }

    void setReaderContentsForClobCritical(int n2, Reader reader, int n3) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OraclePreparedStatement oraclePreparedStatement = this;
            synchronized (oraclePreparedStatement) {
                CLOB cLOB = CLOB.createTemporary(this.connection, true, 10, this.currentRowFormOfUse[n2 - 1]);
                OracleClobWriter oracleClobWriter = (OracleClobWriter)cLOB.setCharacterStream(1L);
                int n4 = cLOB.getBufferSize();
                char[] cArray = new char[n4];
                int n5 = n3;
                try {
                    while (n5 >= n4) {
                        reader.read(cArray);
                        oracleClobWriter.write(cArray);
                        n5 -= n4;
                    }
                    if (n5 > 0) {
                        reader.read(cArray, 0, n5);
                        oracleClobWriter.write(cArray, 0, n5);
                    }
                    oracleClobWriter.flush();
                }
                catch (IOException iOException) {}
                this.addToTempLobsToFree(cLOB);
                this.setCLOBInternal(n2, cLOB);
            }
        }
    }

    void setReaderContentsForStringInternal(int n2, Reader reader, int n3) throws SQLException {
        char[] cArray = new char[n3];
        int n4 = 0;
        try {
            n4 = reader.read(cArray, 0, n3);
            if (n4 == -1) {
                n4 = 0;
            }
        }
        catch (IOException iOException) {
            DatabaseError.throwSqlException(iOException);
        }
        if (n4 != n3) {
            char[] cArray2 = new char[n4];
            System.arraycopy(cArray, 0, cArray2, 0, n4);
            cArray = cArray2;
        }
        this.setStringInternal(n2, new String(cArray));
    }

    void setReaderContentsForStringOrClobInVariableWidthCase(int n2, Reader reader, int n3, boolean bl2) throws SQLException {
        int n4;
        char[] cArray = new char[n3];
        int n5 = 0;
        try {
            n5 = reader.read(cArray, 0, n3);
            if (n5 == -1) {
                n5 = 0;
            }
        }
        catch (IOException iOException) {
            DatabaseError.throwSqlException(iOException);
        }
        if (n5 != n3) {
            char[] cArray2 = new char[n5];
            System.arraycopy(cArray, 0, cArray2, 0, n5);
            cArray = cArray2;
        }
        if ((n4 = this.connection.conversion.encodedByteLength(cArray, bl2)) < this.maxVcsBytesPlsql) {
            this.setStringInternal(n2, new String(cArray));
        } else {
            this.setStringForClobCritical(n2, new String(cArray));
        }
    }

    public void setRef(int n2, Ref ref) throws SQLException {
        this.setREFInternal(n2, (REF)ref);
    }

    public void setRefAtName(String string, Ref ref) throws SQLException {
        this.setREFAtName(string, (REF)ref);
    }

    void setRefInternal(int n2, Ref ref) throws SQLException {
        this.setREFInternal(n2, (REF)ref);
    }

    public void setRefType(int n2, REF rEF) throws SQLException {
        this.setREFInternal(n2, rEF);
    }

    public void setRefTypeAtName(String string, REF rEF) throws SQLException {
        this.setREFAtName(string, rEF);
    }

    void setRefTypeInternal(int n2, REF rEF) throws SQLException {
        this.setREFInternal(n2, rEF);
    }

    public void setSTRUCT(int n2, STRUCT sTRUCT) throws SQLException {
        this.setSTRUCTInternal(n2, sTRUCT);
    }

    public void setSTRUCTAtName(String string, STRUCT sTRUCT) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl2 = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n3 = 0;
        while (n3 < n2) {
            if (stringArray[n3] == string2) {
                this.setSTRUCTInternal(n3 + 1, sTRUCT);
                bl2 = true;
            }
            ++n3;
        }
        if (!bl2) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setSTRUCTCritical(int n2, STRUCT sTRUCT) throws SQLException {
        StructDescriptor structDescriptor = sTRUCT.getDescriptor();
        if (structDescriptor == null) {
            DatabaseError.throwSqlException(61);
        }
        this.currentRowBinders[n2] = this.theNamedTypeBinder;
        if (this.parameterDatum == null) {
            this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
        }
        this.parameterDatum[this.currentRank][n2] = sTRUCT.toBytes();
        OracleTypeADT oracleTypeADT = structDescriptor.getOracleTypeADT();
        oracleTypeADT.getTOID();
        if (this.parameterOtype == null) {
            this.parameterOtype = new OracleTypeADT[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        }
        this.parameterOtype[this.currentRank][n2] = oracleTypeADT;
    }

    void setSTRUCTInternal(int n2, STRUCT sTRUCT) throws SQLException {
        int n3 = n2 - 1;
        if (n3 < 0 || n2 > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        if (sTRUCT == null) {
            DatabaseError.throwSqlException(68);
        } else {
            PhysicalConnection physicalConnection = this.connection;
            synchronized (physicalConnection) {
                OraclePreparedStatement oraclePreparedStatement = this;
                synchronized (oraclePreparedStatement) {
                    this.setSTRUCTCritical(n3, sTRUCT);
                    this.currentRowCharLens[n3] = 0;
                }
            }
        }
    }

    public synchronized void setShort(int n2, short s2) throws SQLException {
        this.setShortInternal(n2, s2);
    }

    public void setShortAtName(String string, short s2) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl2 = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n3 = 0;
        while (n3 < n2) {
            if (stringArray[n3] == string2) {
                this.setShort(n3 + 1, s2);
                bl2 = true;
            }
            ++n3;
        }
        if (!bl2) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setShortInternal(int n2, short s2) throws SQLException {
        int n3 = n2 - 1;
        if (n3 < 0 || n2 > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        this.currentRowCharLens[n3] = 0;
        this.currentRowBinders[n3] = this.theShortBinder;
        if (this.parameterInt == null) {
            this.parameterInt = new int[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        }
        this.parameterInt[this.currentRank][n3] = s2;
    }

    public synchronized void setString(int n2, String string) throws SQLException {
        this.setStringInternal(n2, string);
    }

    public void setStringAtName(String string, String string2) throws SQLException {
        String string3 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl2 = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n3 = 0;
        while (n3 < n2) {
            if (stringArray[n3] == string3) {
                this.setString(n3 + 1, string2);
                bl2 = true;
            }
            ++n3;
        }
        if (!bl2) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    public void setStringForClob(int n2, String string) throws SQLException {
        if (string == null) {
            this.setNull(n2, 1);
            return;
        }
        int n3 = string.length();
        if (n3 == 0) {
            this.setNull(n2, 1);
            return;
        }
        if (this.sqlKind == 1 || this.sqlKind == 4) {
            if (n3 <= this.maxVcsCharsPlsql) {
                this.setStringInternal(n2, string);
            } else {
                this.setStringForClobCritical(n2, string);
            }
        } else if (n3 <= this.maxVcsCharsSql) {
            this.setStringInternal(n2, string);
        } else {
            this.setStringForClobCritical(n2, string);
        }
    }

    public void setStringForClobAtName(String string, String string2) throws SQLException {
        String string3 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl2 = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n3 = 0;
        while (n3 < n2) {
            if (stringArray[n3] == string3) {
                this.setStringForClob(n3 + 1, string2);
                bl2 = true;
            }
            ++n3;
        }
        if (!bl2) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setStringForClobCritical(int n2, String string) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OraclePreparedStatement oraclePreparedStatement = this;
            synchronized (oraclePreparedStatement) {
                CLOB cLOB = CLOB.createTemporary(this.connection, true, 10, this.currentRowFormOfUse[n2 - 1]);
                cLOB.setString(1L, string);
                this.addToTempLobsToFree(cLOB);
                this.setCLOBInternal(n2, cLOB);
            }
        }
    }

    void setStringInternal(int n2, String string) throws SQLException {
        int n3;
        int n4 = n2 - 1;
        if (n4 < 0 || n2 > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        int n5 = n3 = string != null ? string.length() : 0;
        if (n3 == 0) {
            this.basicBindNullString(n2);
        } else if (this.currentRowFormOfUse[n2 - 1] == 1) {
            if (this.sqlKind == 1 || this.sqlKind == 4) {
                if (n3 > this.maxVcsBytesPlsql || n3 > this.maxVcsCharsPlsql && this.isServerCharSetFixedWidth) {
                    this.setStringForClobCritical(n2, string);
                } else if (n3 > this.maxVcsCharsPlsql) {
                    int n6 = this.connection.conversion.encodedByteLength(string, false);
                    if (n6 > this.maxVcsBytesPlsql) {
                        this.setStringForClobCritical(n2, string);
                    } else {
                        this.basicBindString(n2, string);
                    }
                } else {
                    this.basicBindString(n2, string);
                }
            } else if (n3 <= this.maxVcsCharsSql) {
                this.basicBindString(n2, string);
            } else if (n3 <= this.maxStreamCharsSql) {
                this.basicBindCharacterStream(n2, new StringReader(string), n3);
            } else {
                this.setStringForClobCritical(n2, string);
            }
        } else if (this.sqlKind == 1 || this.sqlKind == 4) {
            if (n3 > this.maxVcsBytesPlsql || n3 > this.maxVcsNCharsPlsql && this.isServerNCharSetFixedWidth) {
                this.setStringForClobCritical(n2, string);
            } else if (n3 > this.maxVcsNCharsPlsql) {
                int n7 = this.connection.conversion.encodedByteLength(string, true);
                if (n7 > this.maxVcsBytesPlsql) {
                    this.setStringForClobCritical(n2, string);
                } else {
                    this.basicBindString(n2, string);
                }
            } else {
                this.basicBindString(n2, string);
            }
        } else if (n3 <= this.maxVcsCharsSql) {
            this.basicBindString(n2, string);
        } else if (n3 <= this.maxStreamNCharsSql) {
            this.setStringForClobCritical(n2, string);
        } else {
            this.setStringForClobCritical(n2, string);
        }
    }

    public void setStructDescriptor(int n2, StructDescriptor structDescriptor) throws SQLException {
        this.setStructDescriptorInternal(n2, structDescriptor);
    }

    public void setStructDescriptorAtName(String string, StructDescriptor structDescriptor) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl2 = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n3 = 0;
        while (n3 < n2) {
            if (stringArray[n3] == string2) {
                this.setStructDescriptorInternal(n3 + 1, structDescriptor);
                bl2 = true;
            }
            ++n3;
        }
        if (!bl2) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setStructDescriptorCritical(int n2, StructDescriptor structDescriptor) throws SQLException {
        this.currentRowBinders[n2] = this.theNamedTypeBinder;
        if (this.parameterDatum == null) {
            this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
        }
        OracleTypeADT oracleTypeADT = structDescriptor.getOracleTypeADT();
        oracleTypeADT.getTOID();
        if (this.parameterOtype == null) {
            this.parameterOtype = new OracleTypeADT[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        }
        this.parameterOtype[this.currentRank][n2] = oracleTypeADT;
    }

    void setStructDescriptorInternal(int n2, StructDescriptor structDescriptor) throws SQLException {
        int n3 = n2 - 1;
        if (n3 < 0 || n2 > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        if (structDescriptor == null) {
            DatabaseError.throwSqlException(68);
        }
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OraclePreparedStatement oraclePreparedStatement = this;
            synchronized (oraclePreparedStatement) {
                this.setStructDescriptorCritical(n3, structDescriptor);
                this.currentRowCharLens[n3] = 0;
            }
        }
    }

    public synchronized void setTIMESTAMP(int n2, TIMESTAMP tIMESTAMP) throws SQLException {
        this.setTIMESTAMPInternal(n2, tIMESTAMP);
    }

    public void setTIMESTAMPAtName(String string, TIMESTAMP tIMESTAMP) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl2 = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n3 = 0;
        while (n3 < n2) {
            if (stringArray[n3] == string2) {
                this.setTIMESTAMP(n3 + 1, tIMESTAMP);
                bl2 = true;
            }
            ++n3;
        }
        if (!bl2) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setTIMESTAMPInternal(int n2, TIMESTAMP tIMESTAMP) throws SQLException {
        int n3 = n2 - 1;
        if (n3 < 0 || n2 > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        if (tIMESTAMP == null) {
            this.currentRowBinders[n3] = this.theTimestampNullBinder;
        } else {
            this.currentRowBinders[n3] = this.theOracleTimestampBinder;
            if (this.parameterDatum == null) {
                this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
            }
            this.parameterDatum[this.currentRank][n3] = tIMESTAMP.getBytes();
        }
        this.currentRowCharLens[n3] = 0;
    }

    public synchronized void setTIMESTAMPLTZ(int n2, TIMESTAMPLTZ tIMESTAMPLTZ) throws SQLException {
        this.setTIMESTAMPLTZInternal(n2, tIMESTAMPLTZ);
    }

    public void setTIMESTAMPLTZAtName(String string, TIMESTAMPLTZ tIMESTAMPLTZ) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl2 = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n3 = 0;
        while (n3 < n2) {
            if (stringArray[n3] == string2) {
                this.setTIMESTAMPLTZ(n3 + 1, tIMESTAMPLTZ);
                bl2 = true;
            }
            ++n3;
        }
        if (!bl2) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setTIMESTAMPLTZInternal(int n2, TIMESTAMPLTZ tIMESTAMPLTZ) throws SQLException {
        int n3;
        if (this.connection.getSessionTimeZone() == null) {
            DatabaseError.throwSqlException(105);
        }
        if ((n3 = n2 - 1) < 0 || n2 > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        if (tIMESTAMPLTZ == null) {
            this.currentRowBinders[n3] = this.theTSLTZNullBinder;
        } else {
            this.currentRowBinders[n3] = this.theTSLTZBinder;
            if (this.parameterDatum == null) {
                this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
            }
            this.parameterDatum[this.currentRank][n3] = tIMESTAMPLTZ.getBytes();
        }
        this.currentRowCharLens[n3] = 0;
    }

    public synchronized void setTIMESTAMPTZ(int n2, TIMESTAMPTZ tIMESTAMPTZ) throws SQLException {
        this.setTIMESTAMPTZInternal(n2, tIMESTAMPTZ);
    }

    public void setTIMESTAMPTZAtName(String string, TIMESTAMPTZ tIMESTAMPTZ) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl2 = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n3 = 0;
        while (n3 < n2) {
            if (stringArray[n3] == string2) {
                this.setTIMESTAMPTZ(n3 + 1, tIMESTAMPTZ);
                bl2 = true;
            }
            ++n3;
        }
        if (!bl2) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setTIMESTAMPTZInternal(int n2, TIMESTAMPTZ tIMESTAMPTZ) throws SQLException {
        int n3 = n2 - 1;
        if (n3 < 0 || n2 > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        if (tIMESTAMPTZ == null) {
            this.currentRowBinders[n3] = this.theTSTZNullBinder;
        } else {
            this.currentRowBinders[n3] = this.theTSTZBinder;
            if (this.parameterDatum == null) {
                this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
            }
            this.parameterDatum[this.currentRank][n3] = tIMESTAMPTZ.getBytes();
        }
        this.currentRowCharLens[n3] = 0;
    }

    public synchronized void setTime(int n2, Time time) throws SQLException {
        this.setTimeInternal(n2, time);
    }

    public void setTime(int n2, Time time, Calendar calendar) throws SQLException {
        this.setDATEInternal(n2, time == null ? null : new DATE(time, calendar));
    }

    public void setTimeAtName(String string, Time time) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl2 = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n3 = 0;
        while (n3 < n2) {
            if (stringArray[n3] == string2) {
                this.setTime(n3 + 1, time);
                bl2 = true;
            }
            ++n3;
        }
        if (!bl2) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setTimeInternal(int n2, Time time) throws SQLException {
        int n3 = n2 - 1;
        if (n3 < 0 || n2 > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        if (time == null) {
            this.currentRowBinders[n3] = this.theDateNullBinder;
        } else {
            this.currentRowBinders[n3] = this.theTimeBinder;
            if (this.parameterTime == null) {
                this.parameterTime = new Time[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
            }
            this.parameterTime[this.currentRank][n3] = time;
        }
        this.currentRowCharLens[n3] = 0;
    }

    void setTimeInternal(int n2, Time time, Calendar calendar) throws SQLException {
        this.setDATEInternal(n2, time == null ? null : new DATE(time, calendar));
    }

    public synchronized void setTimestamp(int n2, Timestamp timestamp) throws SQLException {
        this.setTimestampInternal(n2, timestamp);
    }

    public void setTimestamp(int n2, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.setTimestampInternal(n2, timestamp, calendar);
    }

    public void setTimestampAtName(String string, Timestamp timestamp) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl2 = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n3 = 0;
        while (n3 < n2) {
            if (stringArray[n3] == string2) {
                this.setTimestamp(n3 + 1, timestamp);
                bl2 = true;
            }
            ++n3;
        }
        if (!bl2) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setTimestampInternal(int n2, Timestamp timestamp) throws SQLException {
        if (this.connection.v8Compatible) {
            if (timestamp == null) {
                this.setDATEInternal(n2, null);
            } else {
                DATE dATE = new DATE(timestamp);
                this.setDATEInternal(n2, dATE);
            }
        } else {
            int n3 = n2 - 1;
            if (n3 < 0 || n2 > this.numberOfBindPositions) {
                DatabaseError.throwSqlException(3);
            }
            if (timestamp == null) {
                this.currentRowBinders[n3] = this.theTimestampNullBinder;
            } else {
                this.currentRowBinders[n3] = this.theTimestampBinder;
                if (this.parameterTimestamp == null) {
                    this.parameterTimestamp = new Timestamp[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
                }
                this.parameterTimestamp[this.currentRank][n3] = timestamp;
            }
            this.currentRowCharLens[n3] = 0;
        }
    }

    void setTimestampInternal(int n2, Timestamp timestamp, Calendar calendar) throws SQLException {
        if (this.connection.v8Compatible) {
            if (timestamp == null) {
                this.setDATEInternal(n2, null);
            } else {
                DATE dATE = new DATE(timestamp, calendar);
                this.setDATEInternal(n2, dATE);
            }
            return;
        }
        if (timestamp == null) {
            this.setTIMESTAMPInternal(n2, null);
        } else {
            int n3 = timestamp.getNanos();
            byte[] byArray = n3 == 0 ? new byte[7] : new byte[11];
            if (calendar == null) {
                calendar = Calendar.getInstance();
            }
            calendar.clear();
            calendar.setTime(timestamp);
            int n4 = calendar.get(1);
            if (calendar.get(0) == 0) {
                n4 = -(n4 - 1);
            }
            byArray[0] = (byte)(n4 / 100 + 100);
            byArray[1] = (byte)(n4 % 100 + 100);
            byArray[2] = (byte)(calendar.get(2) + 1);
            byArray[3] = (byte)calendar.get(5);
            byArray[4] = (byte)(calendar.get(11) + 1);
            byArray[5] = (byte)(calendar.get(12) + 1);
            byArray[6] = (byte)(calendar.get(13) + 1);
            if (n3 != 0) {
                byArray[7] = (byte)(n3 >> 24);
                byArray[8] = (byte)(n3 >> 16 & 0xFF);
                byArray[9] = (byte)(n3 >> 8 & 0xFF);
                byArray[10] = (byte)(n3 & 0xFF);
            }
            this.setTIMESTAMPInternal(n2, new TIMESTAMP(byArray));
        }
    }

    public synchronized void setURL(int n2, URL uRL) throws SQLException {
        this.setURLInternal(n2, uRL);
    }

    public void setURLAtName(String string, URL uRL) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl2 = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n3 = 0;
        while (n3 < n2) {
            if (stringArray[n3] == string2) {
                this.setURL(n3 + 1, uRL);
                bl2 = true;
            }
            ++n3;
        }
        if (!bl2) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setURLInternal(int n2, URL uRL) throws SQLException {
        this.setStringInternal(n2, uRL.toString());
    }

    public synchronized void setUnicodeStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.setUnicodeStreamInternal(n2, inputStream, n3);
    }

    public void setUnicodeStreamAtName(String string, InputStream inputStream, int n2) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        int n3 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        boolean bl2 = true;
        int n4 = 0;
        while (n4 < n3) {
            if (stringArray[n4] == string2) {
                if (bl2) {
                    this.setUnicodeStream(n4 + 1, inputStream, n2);
                    bl2 = false;
                } else {
                    DatabaseError.throwSqlException(135);
                }
            }
            ++n4;
        }
    }

    void setUnicodeStreamInternal(int n2, InputStream inputStream, int n3) throws SQLException {
        int n4 = n2 - 1;
        if (n4 < 0 || n2 > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        this.set_execute_batch(1);
        if (inputStream == null) {
            this.setStringInternal(n2, null);
        } else if (this.userRsetType != 1 && n3 > this.maxVcsCharsSql) {
            DatabaseError.throwSqlException(169);
        } else if (this.sqlKind == 1 || this.sqlKind == 4 || n3 <= this.maxVcsCharsSql) {
            byte[] byArray = new byte[n3];
            int n5 = 0;
            try {
                n5 = inputStream.read(byArray, 0, n3);
                if (n5 == -1) {
                    n5 = 0;
                }
            }
            catch (IOException iOException) {
                DatabaseError.throwSqlException(iOException);
            }
            char[] cArray = new char[n5 >> 1];
            DBConversion cfr_ignored_0 = this.connection.conversion;
            DBConversion.ucs2BytesToJavaChars(byArray, n5, cArray);
            this.setStringInternal(n2, new String(cArray));
        } else {
            this.currentRowBinders[n4] = this.theLongStreamBinder;
            if (this.parameterStream == null) {
                this.parameterStream = new InputStream[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
            }
            this.parameterStream[this.currentRank][n4] = this.connection.conversion.ConvertStream(inputStream, 4, n3);
            this.currentRowCharLens[n4] = 0;
        }
    }

    synchronized void set_execute_batch(int n2) throws SQLException {
        if (n2 <= 0) {
            DatabaseError.throwSqlException(42);
        }
        if (n2 == this.batch) {
            return;
        }
        if (this.currentRank > 0) {
            this.sendBatch();
        }
        int n3 = this.batch;
        this.batch = n2;
        if (this.numberOfBindRowsAllocated < this.batch) {
            this.growBinds(this.batch);
        }
    }

    void setupBindBuffers(int n2, int n3) throws SQLException {
        try {
            Object object;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            int n10;
            if (this.numberOfBindPositions == 0) {
                return;
            }
            this.preparedAllBinds = this.currentBatchNeedToPrepareBinds;
            this.preparedCharBinds = false;
            this.currentBatchNeedToPrepareBinds = false;
            this.numberOfBoundRows = n3;
            this.bindIndicators[this.bindIndicatorSubRange + 2] = (short)this.numberOfBoundRows;
            int n11 = this.bindBufferCapacity;
            if (this.numberOfBoundRows > this.bindBufferCapacity) {
                n11 = this.numberOfBoundRows;
                this.preparedAllBinds = true;
            }
            if (this.currentBatchBindAccessors != null) {
                if (this.outBindAccessors == null) {
                    this.outBindAccessors = new Accessor[this.numberOfBindPositions];
                }
                n10 = 0;
                while (n10 < this.numberOfBindPositions) {
                    Accessor accessor;
                    this.outBindAccessors[n10] = accessor = this.currentBatchBindAccessors[n10];
                    if (accessor != null && this.currentBatchCharLens[n10] < (n9 = accessor.charLength)) {
                        this.currentBatchCharLens[n10] = n9;
                    }
                    ++n10;
                }
            }
            int n12 = 0;
            n9 = 0;
            int n13 = n8 = this.bindIndicatorSubRange + 3;
            if (this.preparedAllBinds) {
                this.preparedCharBinds = true;
                Binder[] binderArray = this.binders[n2];
                n10 = 0;
                while (n10 < this.numberOfBindPositions) {
                    Binder binder = binderArray[n10];
                    n7 = this.currentBatchCharLens[n10];
                    if (binder == this.theOutBinder) {
                        Accessor accessor = this.currentBatchBindAccessors[n10];
                        n6 = accessor.byteLength;
                        n5 = (short)accessor.defineType;
                    } else {
                        n6 = binder.bytelen;
                        n5 = binder.type;
                    }
                    n9 += n6;
                    n12 += n7;
                    this.bindIndicators[n13] = n5;
                    this.bindIndicators[n13 + 1] = (short)n6;
                    this.bindIndicators[n13 + 2] = (short)n7;
                    this.bindIndicators[n13 + 9] = this.currentBatchFormOfUse[n10];
                    n13 += 10;
                    ++n10;
                }
            } else if (this.preparedCharBinds) {
                n10 = 0;
                while (n10 < this.numberOfBindPositions) {
                    int n14 = this.currentBatchCharLens[n10];
                    n12 += n14;
                    this.bindIndicators[n13 + 2] = (short)n14;
                    n13 += 10;
                    ++n10;
                }
            } else {
                n10 = 0;
                while (n10 < this.numberOfBindPositions) {
                    int n15 = n13 + 2;
                    n5 = this.bindIndicators[n15];
                    int n16 = this.currentBatchCharLens[n10];
                    if (n5 >= n16 && !this.preparedCharBinds) {
                        this.currentBatchCharLens[n10] = n5;
                        n12 += n5;
                    } else {
                        this.bindIndicators[n15] = (short)n16;
                        n12 += n16;
                        this.preparedCharBinds = true;
                    }
                    n13 += 10;
                    ++n10;
                }
            }
            if (this.preparedCharBinds) {
                this.initializeBindSubRanges(this.numberOfBoundRows, n11);
            }
            if (this.preparedAllBinds) {
                int n17 = this.bindByteSubRange + n9 * n11;
                if (this.lastBoundNeeded || n17 > this.totalBindByteLength) {
                    this.bindByteOffset = 0;
                    this.bindBytes = new byte[n17];
                    this.totalBindByteLength = n17;
                }
                this.bindBufferCapacity = n11;
                this.bindIndicators[this.bindIndicatorSubRange + 1] = (short)this.bindBufferCapacity;
            }
            if (this.preparedCharBinds) {
                int n18 = this.bindCharSubRange + n12 * this.bindBufferCapacity;
                if (this.lastBoundNeeded || n18 > this.totalBindCharLength) {
                    this.bindCharOffset = 0;
                    this.bindChars = new char[n18];
                    this.totalBindCharLength = n18;
                }
                this.bindByteSubRange += this.bindByteOffset;
                this.bindCharSubRange += this.bindCharOffset;
            }
            int n19 = this.bindByteSubRange;
            int n20 = this.bindCharSubRange;
            n5 = this.indicatorsOffset;
            n6 = this.valueLengthsOffset;
            n13 = n8;
            if (this.preparedCharBinds) {
                if (this.currentBatchBindAccessors == null) {
                    n10 = 0;
                    while (n10 < this.numberOfBindPositions) {
                        n7 = this.bindIndicators[n13 + 1];
                        int n21 = this.currentBatchCharLens[n10];
                        n4 = n21 == 0 ? n19 : n20;
                        this.bindIndicators[n13 + 3] = (short)(n4 >> 16);
                        this.bindIndicators[n13 + 4] = (short)(n4 & 0xFFFF);
                        n19 += n7 * this.bindBufferCapacity;
                        n20 += n21 * this.bindBufferCapacity;
                        n13 += 10;
                        ++n10;
                    }
                } else {
                    n10 = 0;
                    while (n10 < this.numberOfBindPositions) {
                        n7 = this.bindIndicators[n13 + 1];
                        int n22 = this.currentBatchCharLens[n10];
                        n4 = n22 == 0 ? n19 : n20;
                        this.bindIndicators[n13 + 3] = (short)(n4 >> 16);
                        this.bindIndicators[n13 + 4] = (short)(n4 & 0xFFFF);
                        object = this.currentBatchBindAccessors[n10];
                        if (object != null) {
                            if (n22 > 0) {
                                ((Accessor)object).columnIndex = n20;
                                ((Accessor)object).charLength = n22;
                            } else {
                                ((Accessor)object).columnIndex = n19;
                                ((Accessor)object).byteLength = n7;
                            }
                            ((Accessor)object).lengthIndex = n6;
                            ((Accessor)object).indicatorIndex = n5;
                            ((Accessor)object).rowSpaceByte = this.bindBytes;
                            ((Accessor)object).rowSpaceChar = this.bindChars;
                            ((Accessor)object).rowSpaceIndicator = this.bindIndicators;
                            if (((Accessor)object).defineType == 109 || ((Accessor)object).defineType == 111) {
                                ((Accessor)object).setOffsets(this.bindBufferCapacity);
                            }
                        }
                        n19 += n7 * this.bindBufferCapacity;
                        n20 += n22 * this.bindBufferCapacity;
                        n5 += this.numberOfBindRowsAllocated;
                        n6 += this.numberOfBindRowsAllocated;
                        n13 += 10;
                        ++n10;
                    }
                }
                n19 = this.bindByteSubRange;
                n20 = this.bindCharSubRange;
                n5 = this.indicatorsOffset;
                n6 = this.valueLengthsOffset;
                n13 = n8;
            }
            n7 = this.bindBufferCapacity - this.numberOfBoundRows;
            int n23 = this.numberOfBoundRows - 1;
            n4 = n23 + n2;
            object = this.binders[n4];
            if (this.parameterOtype != null) {
                System.arraycopy(this.parameterDatum[n4], 0, this.lastBoundTypeBytes, 0, this.numberOfBindPositions);
                System.arraycopy(this.parameterOtype[n4], 0, this.lastBoundTypeOtypes, 0, this.numberOfBindPositions);
            }
            if (this.hasIbtBind) {
                this.processPlsqlIndexTabBinds(n2);
            }
            if (this.returnParamAccessors != null) {
                this.processDmlReturningBind();
            }
            boolean bl2 = this.sqlKind != 1 && this.sqlKind != 4 || this.currentRowBindAccessors == null;
            n10 = 0;
            while (n10 < this.numberOfBindPositions) {
                int n24 = this.bindIndicators[n13 + 1];
                int n25 = this.currentBatchCharLens[n10];
                this.lastBinders[n10] = object[n10];
                this.lastBoundByteLens[n10] = n24;
                int n26 = 0;
                while (n26 < this.numberOfBoundRows) {
                    int n27 = n2 + n26;
                    this.binders[n27][n10].bind(this, n10, n26, n27, this.bindBytes, this.bindChars, this.bindIndicators, n24, n25, n19, n20, n6 + n26, n5 + n26, bl2);
                    this.binders[n27][n10] = null;
                    n19 += n24;
                    n20 += n25;
                    ++n26;
                }
                this.lastBoundByteOffsets[n10] = n19 - n24;
                this.lastBoundCharOffsets[n10] = n20 - n25;
                this.lastBoundInds[n10] = this.bindIndicators[n5 + n23];
                this.lastBoundLens[n10] = this.bindIndicators[n6 + n23];
                this.lastBoundCharLens[n10] = 0;
                n19 += n7 * n24;
                n20 += n7 * n25;
                n5 += this.numberOfBindRowsAllocated;
                n6 += this.numberOfBindRowsAllocated;
                n13 += 10;
                ++n10;
            }
            this.lastBoundBytes = this.bindBytes;
            this.lastBoundByteOffset = this.bindByteOffset;
            this.lastBoundChars = this.bindChars;
            this.lastBoundCharOffset = this.bindCharOffset;
            int[] nArray = this.currentBatchCharLens;
            this.currentBatchCharLens = this.lastBoundCharLens;
            this.lastBoundCharLens = nArray;
            this.lastBoundNeeded = false;
            this.prepareBindPreambles(this.numberOfBoundRows, this.bindBufferCapacity);
        }
        catch (NullPointerException nullPointerException) {
            DatabaseError.throwSqlException(89);
        }
    }

    void slideDownCurrentRow(int n2) {
        Object object;
        if (this.binders != null) {
            this.binders[n2] = this.binders[0];
            this.binders[0] = this.currentRowBinders;
        }
        if (this.parameterInt != null) {
            object = this.parameterInt[0];
            this.parameterInt[0] = this.parameterInt[n2];
            this.parameterInt[n2] = object;
        }
        if (this.parameterLong != null) {
            object = this.parameterLong[0];
            this.parameterLong[0] = this.parameterLong[n2];
            this.parameterLong[n2] = object;
        }
        if (this.parameterFloat != null) {
            object = this.parameterFloat[0];
            this.parameterFloat[0] = this.parameterFloat[n2];
            this.parameterFloat[n2] = object;
        }
        if (this.parameterDouble != null) {
            object = this.parameterDouble[0];
            this.parameterDouble[0] = this.parameterDouble[n2];
            this.parameterDouble[n2] = object;
        }
        if (this.parameterBigDecimal != null) {
            object = this.parameterBigDecimal[0];
            this.parameterBigDecimal[0] = this.parameterBigDecimal[n2];
            this.parameterBigDecimal[n2] = (BigDecimal[])object;
        }
        if (this.parameterString != null) {
            object = this.parameterString[0];
            this.parameterString[0] = this.parameterString[n2];
            this.parameterString[n2] = (String[])object;
        }
        if (this.parameterDate != null) {
            object = this.parameterDate[0];
            this.parameterDate[0] = this.parameterDate[n2];
            this.parameterDate[n2] = (Date[])object;
        }
        if (this.parameterTime != null) {
            object = this.parameterTime[0];
            this.parameterTime[0] = this.parameterTime[n2];
            this.parameterTime[n2] = (Time[])object;
        }
        if (this.parameterTimestamp != null) {
            object = this.parameterTimestamp[0];
            this.parameterTimestamp[0] = this.parameterTimestamp[n2];
            this.parameterTimestamp[n2] = (Timestamp[])object;
        }
        if (this.parameterDatum != null) {
            object = this.parameterDatum[0];
            this.parameterDatum[0] = this.parameterDatum[n2];
            this.parameterDatum[n2] = (byte[][])object;
        }
        if (this.parameterOtype != null) {
            object = this.parameterOtype[0];
            this.parameterOtype[0] = this.parameterOtype[n2];
            this.parameterOtype[n2] = (OracleTypeADT[])object;
        }
        if (this.parameterStream != null) {
            object = this.parameterStream[0];
            this.parameterStream[0] = this.parameterStream[n2];
            this.parameterStream[n2] = (InputStream[])object;
        }
    }

    int sqlTypeForObject(Object object) {
        if (object == null) {
            return 0;
        }
        if (!(object instanceof Datum)) {
            if (object instanceof String) {
                return this.fixedString ? 999 : 12;
            }
            if (object instanceof BigDecimal) {
                return 2;
            }
            if (object instanceof Boolean) {
                return -7;
            }
            if (object instanceof Integer) {
                return 4;
            }
            if (object instanceof Long) {
                return -5;
            }
            if (object instanceof Float) {
                return 6;
            }
            if (object instanceof Double) {
                return 8;
            }
            if (object instanceof byte[]) {
                return -3;
            }
            if (object instanceof Short) {
                return 5;
            }
            if (object instanceof Byte) {
                return -6;
            }
            if (object instanceof Date) {
                return 91;
            }
            if (object instanceof Time) {
                return 92;
            }
            if (object instanceof Timestamp) {
                return 93;
            }
            if (object instanceof SQLData) {
                return 2002;
            }
            if (object instanceof ObjectData) {
                return 2002;
            }
        } else {
            if (object instanceof BINARY_FLOAT) {
                return 100;
            }
            if (object instanceof BINARY_DOUBLE) {
                return 101;
            }
            if (object instanceof BLOB) {
                return 2004;
            }
            if (object instanceof CLOB) {
                return 2005;
            }
            if (object instanceof BFILE) {
                return -13;
            }
            if (object instanceof ROWID) {
                return -8;
            }
            if (object instanceof NUMBER) {
                return 2;
            }
            if (object instanceof DATE) {
                return 91;
            }
            if (object instanceof TIMESTAMP) {
                return 93;
            }
            if (object instanceof TIMESTAMPTZ) {
                return -101;
            }
            if (object instanceof TIMESTAMPLTZ) {
                return -102;
            }
            if (object instanceof REF) {
                return 2006;
            }
            if (object instanceof CHAR) {
                return 1;
            }
            if (object instanceof RAW) {
                return -2;
            }
            if (object instanceof ARRAY) {
                return 2003;
            }
            if (object instanceof STRUCT) {
                return 2002;
            }
            if (object instanceof OPAQUE) {
                return 2007;
            }
            if (object instanceof INTERVALYM) {
                return -103;
            }
            if (object instanceof INTERVALDS) {
                return -104;
            }
        }
        return 1111;
    }

    class PushedBatch {
        int[] currentBatchCharLens;
        int[] lastBoundCharLens;
        Accessor[] currentBatchBindAccessors;
        boolean lastBoundNeeded;
        boolean need_to_parse;
        boolean current_batch_need_to_prepare_binds;
        int first_row_in_batch;
        int number_of_rows_to_be_bound;
        PushedBatch next;

        PushedBatch() {
        }
    }
}

