/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.driver.OracleTimeoutThreadPerVM;

class OracleTimeoutPollingThread
extends Thread {
    protected static final String threadName = "OracleTimeoutPollingThread";
    public static final String pollIntervalProperty = "oracle.jdbc.TimeoutPollInterval";
    public static final String pollIntervalDefault = "1000";
    private OracleTimeoutThreadPerVM[] knownTimeouts;
    private int count;
    private long sleepMillis;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Jun_22_11:15:42_PDT_2005";

    public OracleTimeoutPollingThread() {
        super(threadName);
        this.setDaemon(true);
        this.setPriority(10);
        this.knownTimeouts = new OracleTimeoutThreadPerVM[2];
        this.count = 0;
        this.sleepMillis = Long.parseLong(OracleDriver.getSystemPropertyPollInterval());
        this.start();
    }

    public synchronized void addTimeout(OracleTimeoutThreadPerVM oracleTimeoutThreadPerVM) {
        int n2 = 0;
        if (this.count >= this.knownTimeouts.length) {
            OracleTimeoutThreadPerVM[] oracleTimeoutThreadPerVMArray = new OracleTimeoutThreadPerVM[this.knownTimeouts.length * 4];
            System.arraycopy(this.knownTimeouts, 0, oracleTimeoutThreadPerVMArray, 0, this.knownTimeouts.length);
            n2 = this.knownTimeouts.length;
            this.knownTimeouts = oracleTimeoutThreadPerVMArray;
        }
        while (n2 < this.knownTimeouts.length) {
            if (this.knownTimeouts[n2] == null) {
                this.knownTimeouts[n2] = oracleTimeoutThreadPerVM;
                ++this.count;
                break;
            }
            ++n2;
        }
    }

    private void pollOnce() {
        if (this.count > 0) {
            long l2 = System.currentTimeMillis();
            int n2 = 0;
            while (n2 < this.knownTimeouts.length) {
                try {
                    if (this.knownTimeouts[n2] != null) {
                        this.knownTimeouts[n2].interruptIfAppropriate(l2);
                    }
                }
                catch (NullPointerException nullPointerException) {}
                ++n2;
            }
        }
    }

    public synchronized void removeTimeout(OracleTimeoutThreadPerVM oracleTimeoutThreadPerVM) {
        int n2 = 0;
        while (n2 < this.knownTimeouts.length) {
            if (this.knownTimeouts[n2] == oracleTimeoutThreadPerVM) {
                this.knownTimeouts[n2] = null;
                --this.count;
                break;
            }
            ++n2;
        }
    }

    public void run() {
        while (true) {
            try {
                Thread.sleep(this.sleepMillis);
            }
            catch (InterruptedException interruptedException) {}
            this.pollOnce();
        }
    }
}

