/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.TypeAccessor;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.sql.Datum;
import oracle.sql.REF;
import oracle.sql.StructDescriptor;
import oracle.sql.TypeDescriptor;

class RefTypeAccessor
extends TypeAccessor {
    RefTypeAccessor(OracleStatement oracleStatement, int n2, boolean bl2, int n3, int n4, int n5, int n6, int n7, short s2, String string) throws SQLException {
        this.init(oracleStatement, 111, 111, s2, false);
        this.initForDescribe(111, n2, bl2, n3, n4, n5, n6, n7, s2, string);
        this.initForDataAccess(0, n2, string);
    }

    RefTypeAccessor(OracleStatement oracleStatement, int n2, boolean bl2, int n3, int n4, int n5, int n6, int n7, short s2, String string, OracleType oracleType) throws SQLException {
        this.init(oracleStatement, 111, 111, s2, false);
        this.describeOtype = oracleType;
        this.initForDescribe(111, n2, bl2, n3, n4, n5, n6, n7, s2, string);
        this.internalOtype = oracleType;
        this.initForDataAccess(0, n2, string);
    }

    RefTypeAccessor(OracleStatement oracleStatement, String string, short s2, int n2, boolean bl2) throws SQLException {
        this.init(oracleStatement, 111, 111, s2, bl2);
        this.initForDataAccess(n2, 0, string);
    }

    Object getObject(int n2) throws SQLException {
        return this.getREF(n2);
    }

    Object getObject(int n2, Map map) throws SQLException {
        return this.getREF(n2);
    }

    Datum getOracleObject(int n2) throws SQLException {
        return this.getREF(n2);
    }

    REF getREF(int n2) throws SQLException {
        REF rEF = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            byte[] byArray = this.pickledBytes(n2);
            OracleTypeADT oracleTypeADT = (OracleTypeADT)this.internalOtype;
            rEF = new REF(oracleTypeADT.getFullName(), (Connection)this.statement.connection, byArray);
        }
        return rEF;
    }

    void initForDataAccess(int n2, int n3, String string) throws SQLException {
        super.initForDataAccess(n2, n3, string);
        this.byteLength = this.statement.connection.refTypeAccessorByteLen;
    }

    OracleType otypeFromName(String string) throws SQLException {
        if (!this.outBind) {
            return TypeDescriptor.getTypeDescriptor(string, this.statement.connection).getPickler();
        }
        return StructDescriptor.createDescriptor(string, (Connection)this.statement.connection).getOracleTypeADT();
    }
}

