/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Hashtable;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import oracle.jdbc.OracleOCIFailover;
import oracle.jdbc.driver.AutoKeyInfo;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleBlobInputStream;
import oracle.jdbc.driver.OracleBlobOutputStream;
import oracle.jdbc.driver.OracleClobInputStream;
import oracle.jdbc.driver.OracleClobOutputStream;
import oracle.jdbc.driver.OracleClobReader;
import oracle.jdbc.driver.OracleClobWriter;
import oracle.jdbc.driver.OracleConversionInputStream;
import oracle.jdbc.driver.OracleConversionReader;
import oracle.jdbc.driver.OracleDriverExtension;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.T2CError;
import oracle.jdbc.driver.T2CStatement;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCLOB;
import oracle.jdbc.pool.OracleOCIConnectionPool;
import oracle.jdbc.pool.OraclePooledConnection;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.BfileDBAccess;
import oracle.sql.BlobDBAccess;
import oracle.sql.CLOB;
import oracle.sql.ClobDBAccess;
import oracle.sql.LobPlsqlUtil;
import oracle.sql.SQLName;
import oracle.sql.converter.CharacterSetMetaData;

public class T2CConnection
extends PhysicalConnection
implements BfileDBAccess,
BlobDBAccess,
ClobDBAccess {
    short[] queryMetaData1 = null;
    byte[] queryMetaData2 = null;
    int queryMetaData1Offset = 0;
    int queryMetaData2Offset = 0;
    private String password;
    int fatalErrorNumber = 0;
    String fatalErrorMessage = null;
    static final int QMD_dbtype = 0;
    static final int QMD_dbsize = 1;
    static final int QMD_nullok = 2;
    static final int QMD_precision = 3;
    static final int QMD_scale = 4;
    static final int QMD_formOfUse = 5;
    static final int QMD_columnNameLength = 6;
    static final int QMD_tdo0 = 7;
    static final int QMD_tdo1 = 8;
    static final int QMD_tdo2 = 9;
    static final int QMD_tdo3 = 10;
    static final int QMD_charLength = 11;
    static final int QMD_typeNameLength = 12;
    static final int T2C_LOCATOR_MAX_LEN = 16;
    static final int T2C_LINEARIZED_LOCATOR_MAX_LEN = 4000;
    static final int T2C_LINEARIZED_BFILE_LOCATOR_MAX_LEN = 530;
    static final int METADATA1_INDICES_PER_COLUMN = 13;
    protected static final int SIZEOF_QUERYMETADATA2 = 8;
    int queryMetaData1Size = 100;
    int queryMetaData2Size = 800;
    long m_nativeState;
    short m_clientCharacterSet;
    byte byteAlign;
    private static final int EOJ_SUCCESS = 0;
    private static final int EOJ_ERROR = -1;
    private static final int EOJ_WARNING = 1;
    private static final String OCILIBRARY = "ocijdbc10";
    private int logon_mode = 0;
    static final int LOGON_MODE_DEFAULT = 0;
    static final int LOGON_MODE_SYSDBA = 2;
    static final int LOGON_MODE_SYSOPER = 4;
    static final int LOGON_MODE_CONNECTION_POOL = 5;
    static final int LOGON_MODE_CONNPOOL_CONNECTION = 6;
    static final int LOGON_MODE_CONNPOOL_PROXY_CONNECTION = 7;
    static final int LOGON_MODE_CONNPOOL_ALIASED_CONNECTION = 8;
    static final int T2C_PROXYTYPE_NONE = 0;
    static final int T2C_PROXYTYPE_USER_NAME = 1;
    static final int T2C_PROXYTYPE_DISTINGUISHED_NAME = 2;
    static final int T2C_PROXYTYPE_CERTIFICATE = 3;
    private static boolean isLibraryLoaded;
    OracleOCIFailover appCallback = null;
    Object appCallbackObject = null;
    private Properties nativeInfo;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Jun_22_11:15:43_PDT_2005";
    static /* synthetic */ Class class$oracle$jdbc$driver$T2CConnection;

    static {
        _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    }

    protected T2CConnection(String string, String string2, String string3, String string4, Properties properties, OracleDriverExtension oracleDriverExtension) throws SQLException {
        super(string, string2, string3, string4, properties, oracleDriverExtension);
        this.initialize();
    }

    OracleStatement RefCursorBytesToStatement(byte[] byArray, OracleStatement oracleStatement) throws SQLException {
        T2CStatement t2CStatement = new T2CStatement(this, 1, this.defaultRowPrefetch, -1, -1);
        t2CStatement.needToParse = false;
        t2CStatement.serverCursor = true;
        t2CStatement.isOpen = true;
        t2CStatement.processEscapes = false;
        t2CStatement.prepareForNewResults(true, false);
        t2CStatement.sqlObject.initialize("select unknown as ref cursor from whatever");
        t2CStatement.sqlKind = 0;
        this.checkError(this.t2cCreateStatement(this.m_nativeState, oracleStatement.c_state, byArray, byArray.length, t2CStatement, true, this.defaultRowPrefetch));
        return t2CStatement;
    }

    private void allocQueryMetaDataBuffers() {
        this.queryMetaData1Offset = 0;
        this.queryMetaData1 = new short[this.queryMetaData1Size * 13];
        this.queryMetaData2Offset = 0;
        this.queryMetaData2 = new byte[this.queryMetaData2Size];
        this.namedTypeAccessorByteLen = 0;
        this.refTypeAccessorByteLen = 0;
    }

    native int bfileClose(long var1, byte[] var3, int var4, byte[][] var5);

    native int bfileExists(long var1, byte[] var3, int var4, boolean[] var5);

    native String bfileGetDirAlias(long var1, byte[] var3, int var4);

    native String bfileGetName(long var1, byte[] var3, int var4);

    native int bfileIsOpen(long var1, byte[] var3, int var4, boolean[] var5);

    native int bfileOpen(long var1, byte[] var3, int var4, byte[][] var5);

    native int blobRead(long var1, byte[] var3, int var4, long var5, int var7, byte[] var8, int var9);

    private int blobRead(byte[] byArray, long l2, int n2, byte[] byArray2) throws SQLException {
        int n3 = 0;
        n3 = this.blobRead(this.m_nativeState, byArray, byArray.length, l2, n2, byArray2, byArray2.length);
        this.checkError(n3);
        return n3;
    }

    native int blobWrite(long var1, byte[] var3, int var4, long var5, int var7, byte[] var8, int var9, byte[][] var10);

    private int blobWrite(byte[] byArray, long l2, byte[] byArray2, byte[][] byArray3, int n2, int n3) throws SQLException {
        int n4 = 0;
        n4 = this.blobWrite(this.m_nativeState, byArray, byArray.length, l2, n3, byArray2, n2, byArray3);
        this.checkError(n4);
        return n4;
    }

    static String bytes2String(byte[] byArray, int n2, int n3, DBConversion dBConversion) throws SQLException {
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n2, byArray2, 0, n3);
        return dBConversion.CharBytesToString(byArray2, n3);
    }

    synchronized int callTAFCallbackMethod(int n2, int n3) {
        int n4 = 0;
        if (this.appCallback != null) {
            n4 = this.appCallback.callbackFn(this, this.appCallbackObject, n2, n3);
        }
        return n4;
    }

    protected SQLWarning checkError(int n2) throws SQLException {
        return this.checkError(n2, null);
    }

    protected SQLWarning checkError(int n2, SQLWarning sQLWarning) throws SQLException {
        switch (n2) {
            case -1: 
            case 1: {
                T2CError t2CError = new T2CError();
                int n3 = -1;
                if (this.m_nativeState != 0L) {
                    n3 = this.t2cDescribeError(this.m_nativeState, t2CError, t2CError.m_errorMessage);
                } else if (this.fatalErrorNumber != 0) {
                    String string = DatabaseError.ErrorToSQLState(this.fatalErrorNumber);
                    DatabaseError.throwSqlException(this.fatalErrorMessage, string, t2CError.m_errorNumber);
                } else {
                    DatabaseError.throwSqlException(8);
                }
                switch (t2CError.m_errorNumber) {
                    case 28: 
                    case 600: 
                    case 1012: 
                    case 1041: 
                    case 3113: 
                    case 3114: {
                        this.internalClose();
                        break;
                    }
                }
                if (n3 == -1) {
                    DatabaseError.throwSqlException(1, "Fetch error message failed!");
                }
                int n4 = 0;
                while (n4 < t2CError.m_errorMessage.length && t2CError.m_errorMessage[n4] != 0) {
                    ++n4;
                }
                String string = this.conversion.CharBytesToString(t2CError.m_errorMessage, n4, true);
                String string2 = DatabaseError.ErrorToSQLState(t2CError.m_errorNumber);
                if (n2 == -1) {
                    DatabaseError.throwSqlException(string, string2, t2CError.m_errorNumber);
                    break;
                }
                sQLWarning = DatabaseError.addSqlWarning(sQLWarning, string, string2, t2CError.m_errorNumber);
                break;
            }
        }
        return sQLWarning;
    }

    private final void checkTrue(boolean bl2, int n2) throws SQLException {
        if (!bl2) {
            DatabaseError.throwSqlException(n2);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    native int clobRead(long var1, byte[] var3, int var4, long var5, int var7, char[] var8, int var9, boolean var10);

    native int clobWrite(long var1, byte[] var3, int var4, long var5, int var7, char[] var8, int var9, byte[][] var10, boolean var11);

    private int clobWrite(byte[] byArray, long l2, char[] cArray, byte[][] byArray2, boolean bl2, int n2, int n3) throws SQLException {
        int n4 = 0;
        n4 = this.clobWrite(this.m_nativeState, byArray, byArray.length, l2, n3, cArray, n2, byArray2, bl2);
        this.checkError(n4);
        return n4;
    }

    public void close(BFILE bFILE) throws SQLException {
        byte[] byArray = null;
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue((bFILE == null || (byArray = bFILE.shareBytes()) == null) ^ true, 54);
        byte[][] byArray2 = new byte[1][];
        this.checkError(this.lobClose(this.m_nativeState, 114, byArray, byArray.length, byArray2));
        bFILE.setShareBytes(byArray2[0]);
    }

    public void close(BLOB bLOB) throws SQLException {
        byte[] byArray = null;
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue((bLOB == null || (byArray = bLOB.shareBytes()) == null) ^ true, 54);
        byte[][] byArray2 = new byte[1][];
        this.checkError(this.lobClose(this.m_nativeState, 113, byArray, byArray.length, byArray2));
        bLOB.setShareBytes(byArray2[0]);
    }

    public void close(CLOB cLOB) throws SQLException {
        byte[] byArray = null;
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue((cLOB == null || (byArray = cLOB.shareBytes()) == null) ^ true, 54);
        byte[][] byArray2 = new byte[1][];
        this.checkError(this.lobClose(this.m_nativeState, 112, byArray, byArray.length, byArray2));
        cLOB.setShareBytes(byArray2[0]);
    }

    public void closeFile(BFILE bFILE) throws SQLException {
        byte[] byArray = null;
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue((bFILE == null || (byArray = bFILE.getLocator()) == null) ^ true, 54);
        byte[][] byArray2 = new byte[1][];
        this.checkError(this.bfileClose(this.m_nativeState, byArray, byArray.length, byArray2));
        bFILE.setLocator(byArray2[0]);
    }

    void closeProxySession() throws SQLException {
        this.checkError(this.t2cCloseProxySession(this.m_nativeState));
        this.user = this.savedUser;
    }

    public BFILE createBfile(byte[] byArray) throws SQLException {
        return new BFILE(this, byArray);
    }

    public BfileDBAccess createBfileDBAccess() {
        return this;
    }

    public BLOB createBlob(byte[] byArray) throws SQLException {
        return new BLOB(this, byArray);
    }

    public BlobDBAccess createBlobDBAccess() {
        return this;
    }

    public CLOB createClob(byte[] byArray) throws SQLException {
        return new CLOB(this, byArray);
    }

    public CLOB createClob(byte[] byArray, short s2) throws SQLException {
        return new CLOB(this, byArray, s2);
    }

    public ClobDBAccess createClobDBAccess() {
        return this;
    }

    public BLOB createTemporaryBlob(Connection connection, boolean bl2, int n2) throws SQLException {
        BLOB bLOB = null;
        this.checkTrue(this.m_nativeState != 0L, 8);
        bLOB = new BLOB((PhysicalConnection)connection);
        byte[][] byArray = new byte[1][];
        this.checkError(this.lobCreateTemporary(this.m_nativeState, 113, bl2, n2, (short)0, byArray));
        bLOB.setShareBytes(byArray[0]);
        return bLOB;
    }

    public CLOB createTemporaryClob(Connection connection, boolean bl2, int n2, short s2) throws SQLException {
        CLOB cLOB = null;
        this.checkTrue(this.m_nativeState != 0L, 8);
        cLOB = new CLOB((PhysicalConnection)connection);
        byte[][] byArray = new byte[1][];
        this.checkError(this.lobCreateTemporary(this.m_nativeState, 112, bl2, n2, s2, byArray));
        cLOB.setShareBytes(byArray[0]);
        return cLOB;
    }

    void doAbort() throws SQLException {
        this.checkError(this.t2cAbort(this.m_nativeState));
    }

    void doCancel() throws SQLException {
        this.checkError(this.t2cCancel(this.m_nativeState));
    }

    void doClearAllApplicationContext(String string) throws SQLException {
        this.checkError(this.t2cClearAllApplicationContext(this.m_nativeState, string));
    }

    protected void doCommit() throws SQLException {
        this.checkError(this.t2cCommit(this.m_nativeState));
    }

    protected void doDescribeTable(AutoKeyInfo autoKeyInfo) throws SQLException {
        int n2;
        String string = autoKeyInfo.getTableName();
        byte[] byArray = DBConversion.stringToDriverCharBytes(string, this.m_clientCharacterSet);
        boolean bl2 = false;
        do {
            if ((n2 = T2CConnection.t2cDescribeTable(this.m_nativeState, byArray, byArray.length, this.queryMetaData1, this.queryMetaData2, this.queryMetaData1Offset, this.queryMetaData2Offset, this.queryMetaData1Size, this.queryMetaData2Size)) == -1) {
                this.checkError(n2);
            }
            if (n2 != T2CStatement.T2C_EXTEND_BUFFER) continue;
            bl2 = true;
            this.reallocateQueryMetaData(this.queryMetaData1Size * 2, this.queryMetaData2Size * 2);
        } while (bl2);
        this.processDescribeTableData(n2, autoKeyInfo);
    }

    protected String doGetDatabaseProductVersion() throws SQLException {
        byte[] byArray = this.t2cGetProductionVersion(this.m_nativeState);
        return this.conversion.CharBytesToString(byArray, byArray.length);
    }

    protected short doGetVersionNumber() throws SQLException {
        short s2 = 0;
        try {
            String string = this.doGetDatabaseProductVersion();
            StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), " .", false);
            String string2 = null;
            int n2 = 0;
            short s3 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                try {
                    s3 = Integer.decode(string2).shortValue();
                    s2 = (short)(s2 * 10 + s3);
                    if (++n2 != 4) continue;
                    break;
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        catch (NoSuchElementException noSuchElementException) {}
        if (s2 == -1) {
            s2 = 0;
        }
        return s2;
    }

    void doProxySession(int n2, Properties properties) throws SQLException {
        byte[] byArray;
        byte[][] byArray2 = null;
        int n3 = 0;
        this.savedUser = this.user;
        this.user = null;
        byte[] byArray3 = byArray = new byte[0];
        byte[] byArray4 = byArray;
        byte[] byArray5 = byArray;
        switch (n2) {
            case 1: {
                this.user = properties.getProperty("PROXY_USER_NAME");
                String string = properties.getProperty("PROXY_USER_PASSWORD");
                if (this.user != null) {
                    byArray5 = DBConversion.stringToDriverCharBytes(this.user, this.m_clientCharacterSet);
                }
                if (string == null) break;
                byArray4 = DBConversion.stringToAsciiBytes(string);
                break;
            }
            case 2: {
                String string = properties.getProperty("PROXY_DISTINGUISHED_NAME");
                if (string == null) break;
                byArray3 = DBConversion.stringToDriverCharBytes(string, this.m_clientCharacterSet);
                break;
            }
            case 3: {
                Object v2 = ((Hashtable)properties).get("PROXY_CERTIFICATE");
                byArray = (byte[])v2;
            }
        }
        String[] stringArray = (String[])((Hashtable)properties).get("PROXY_ROLES");
        if (stringArray != null) {
            n3 = stringArray.length;
            byArray2 = new byte[n3][];
            int n4 = 0;
            while (n4 < n3) {
                if (stringArray[n4] == null) {
                    DatabaseError.throwSqlException(150);
                }
                byArray2[n4] = DBConversion.stringToDriverCharBytes(stringArray[n4], this.m_clientCharacterSet);
                ++n4;
            }
        }
        this.sqlWarning = this.checkError(this.t2cDoProxySession(this.m_nativeState, n2, byArray5, byArray5.length, byArray4, byArray4.length, byArray3, byArray3.length, byArray, byArray.length, n3, byArray2), this.sqlWarning);
        this.isProxy = true;
    }

    protected void doRollback() throws SQLException {
        this.checkError(this.t2cRollback(this.m_nativeState));
    }

    void doSetApplicationContext(String string, String string2, String string3) throws SQLException {
        this.checkError(this.t2cSetApplicationContext(this.m_nativeState, string, string2, string3));
    }

    protected void doSetAutoCommit(boolean bl2) throws SQLException {
        this.checkError(this.t2cSetAutoCommit(this.m_nativeState, bl2));
    }

    public boolean fileExists(BFILE bFILE) throws SQLException {
        byte[] byArray = null;
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue((bFILE == null || (byArray = bFILE.getLocator()) == null) ^ true, 54);
        boolean[] blArray = new boolean[1];
        this.checkError(this.bfileExists(this.m_nativeState, byArray, byArray.length, blArray));
        return blArray[0];
    }

    public void freeTemporary(BLOB bLOB) throws SQLException {
        byte[] byArray = null;
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue((bLOB == null || (byArray = bLOB.shareBytes()) == null) ^ true, 54);
        byte[][] byArray2 = new byte[1][];
        this.checkError(this.lobFreeTemporary(this.m_nativeState, 113, byArray, byArray.length, byArray2));
        bLOB.setShareBytes(byArray2[0]);
    }

    public void freeTemporary(CLOB cLOB) throws SQLException {
        byte[] byArray = null;
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue((cLOB == null || (byArray = cLOB.shareBytes()) == null) ^ true, 54);
        byte[][] byArray2 = new byte[1][];
        this.checkError(this.lobFreeTemporary(this.m_nativeState, 112, byArray, byArray.length, byArray2));
        cLOB.setShareBytes(byArray2[0]);
    }

    public int getBytes(BFILE bFILE, long l2, int n2, byte[] byArray) throws SQLException {
        byte[] byArray2 = null;
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue((bFILE == null || (byArray2 = bFILE.getLocator()) == null) ^ true, 54);
        if (n2 <= 0 || byArray == null) {
            return 0;
        }
        if (n2 > byArray.length) {
            n2 = byArray.length;
        }
        return this.blobRead(byArray2, l2, n2, byArray);
    }

    public int getBytes(BLOB bLOB, long l2, int n2, byte[] byArray) throws SQLException {
        byte[] byArray2 = null;
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue((bLOB == null || (byArray2 = bLOB.getLocator()) == null) ^ true, 54);
        if (n2 <= 0 || byArray == null) {
            return 0;
        }
        if (n2 > byArray.length) {
            n2 = byArray.length;
        }
        return this.blobRead(byArray2, l2, n2, byArray);
    }

    static final char[] getCharArray(String string) {
        char[] cArray = null;
        if (string == null) {
            cArray = new char[]{};
        } else {
            cArray = new char[string.length()];
            string.getChars(0, string.length(), cArray, 0);
        }
        return cArray;
    }

    public int getChars(CLOB cLOB, long l2, int n2, char[] cArray) throws SQLException {
        byte[] byArray = null;
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue((cLOB == null || (byArray = cLOB.getLocator()) == null) ^ true, 54);
        if (n2 <= 0 || cArray == null) {
            return 0;
        }
        if (n2 > cArray.length) {
            n2 = cArray.length;
        }
        int n3 = 0;
        n3 = this.clobRead(this.m_nativeState, byArray, byArray.length, l2, n2, cArray, cArray.length, cLOB.isNCLOB());
        this.checkError(n3);
        return n3;
    }

    public int getChunkSize(BLOB bLOB) throws SQLException {
        byte[] byArray = null;
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue((bLOB == null || (byArray = bLOB.getLocator()) == null) ^ true, 54);
        return this.lobGetChunkSize(byArray);
    }

    public int getChunkSize(CLOB cLOB) throws SQLException {
        byte[] byArray = null;
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue((cLOB == null || (byArray = cLOB.getLocator()) == null) ^ true, 54);
        return this.lobGetChunkSize(byArray);
    }

    public static final short getClientCharSetId() {
        return 871;
    }

    public Properties getConnectionPoolInfo() throws SQLException {
        if (this.lifecycle != 1) {
            DatabaseError.throwSqlException(8);
        }
        Properties properties = new Properties();
        this.checkError(this.t2cGetConnPoolInfo(this.m_nativeState, properties));
        return properties;
    }

    public Properties getDBAccessProperties() throws SQLException {
        return this.getOCIHandles();
    }

    public String getDirAlias(BFILE bFILE) throws SQLException {
        byte[] byArray = null;
        String string = null;
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue((bFILE == null || (byArray = bFILE.getLocator()) == null) ^ true, 54);
        string = this.bfileGetDirAlias(this.m_nativeState, byArray, byArray.length);
        this.checkError(string.length());
        return string;
    }

    public static short getDriverCharSetIdFromNLS_LANG(Properties properties) throws SQLException {
        short s2;
        if (!isLibraryLoaded) {
            T2CConnection.loadNativeLibrary(properties);
        }
        if ((s2 = T2CConnection.t2cGetDriverCharSetFromNlsLang()) < 0) {
            DatabaseError.throwSqlException(8);
        }
        return s2;
    }

    public void getForm(OracleTypeADT oracleTypeADT, OracleTypeCLOB oracleTypeCLOB, int n2) throws SQLException {
        boolean bl2 = false;
        if (oracleTypeCLOB != null) {
            String[] stringArray = new String[1];
            String[] stringArray2 = new String[1];
            SQLName.parse(oracleTypeADT.getFullName(), stringArray, stringArray2, true);
            String string = "\"" + stringArray[0] + "\".\"" + stringArray2[0] + "\"";
            byte[] byArray = this.conversion.StringToCharBytes(string);
            int n3 = this.t2cGetFormOfUse(this.m_nativeState, oracleTypeCLOB, byArray, byArray.length, n2);
            if (n3 < 0) {
                this.checkError(n3);
            }
            oracleTypeCLOB.setForm(n3);
        }
    }

    public int getHeapAllocSize() throws SQLException {
        int n2;
        if (this.lifecycle != 1) {
            DatabaseError.throwSqlException(8);
        }
        if ((n2 = this.t2cGetHeapAllocSize(this.m_nativeState)) < 0) {
            if (n2 == -999) {
                DatabaseError.throwSqlException(23);
            }
            DatabaseError.throwSqlException(89);
        }
        return n2;
    }

    public String getName(BFILE bFILE) throws SQLException {
        byte[] byArray = null;
        String string = null;
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue((bFILE == null || (byArray = bFILE.getLocator()) == null) ^ true, 54);
        string = this.bfileGetName(this.m_nativeState, byArray, byArray.length);
        this.checkError(string.length());
        return string;
    }

    public int getOCIEnvHeapAllocSize() throws SQLException {
        int n2;
        if (this.lifecycle != 1) {
            DatabaseError.throwSqlException(8);
        }
        if ((n2 = this.t2cGetOciEnvHeapAllocSize(this.m_nativeState)) < 0) {
            if (n2 == -999) {
                DatabaseError.throwSqlException(23);
            } else {
                this.checkError(n2);
            }
            DatabaseError.throwSqlException(89);
        }
        return n2;
    }

    public synchronized Properties getOCIHandles() throws SQLException {
        if (this.nativeInfo == null) {
            long[] lArray = new long[3];
            this.checkError(this.t2cGetHandles(this.m_nativeState, lArray));
            this.nativeInfo = new Properties();
            ((Hashtable)this.nativeInfo).put("OCIEnvHandle", String.valueOf(lArray[0]));
            ((Hashtable)this.nativeInfo).put("OCISvcCtxHandle", String.valueOf(lArray[1]));
            ((Hashtable)this.nativeInfo).put("OCIErrHandle", String.valueOf(lArray[2]));
            ((Hashtable)this.nativeInfo).put("ClientCharSet", String.valueOf(this.m_clientCharacterSet));
        }
        return this.nativeInfo;
    }

    public void getPropertyForPooledConnection(OraclePooledConnection oraclePooledConnection) throws SQLException {
        super.getPropertyForPooledConnection(oraclePooledConnection, this.password);
    }

    public Properties getServerSessionInfo() throws SQLException {
        if (this.lifecycle != 1) {
            DatabaseError.throwSqlException(8);
        }
        Properties properties = new Properties();
        this.checkError(T2CConnection.t2cGetServerSessionInfo(this.m_nativeState, properties));
        return properties;
    }

    public long getTdoCState(String string, String string2) throws SQLException {
        int[] nArray;
        String string3 = "\"" + string + "\".\"" + string2 + "\"";
        byte[] byArray = this.conversion.StringToCharBytes(string3);
        long l2 = this.t2cGetTDO(this.m_nativeState, byArray, byArray.length, nArray = new int[1]);
        if (l2 == 0L) {
            this.checkError(nArray[0]);
        }
        return l2;
    }

    protected void initialize() {
        this.allocQueryMetaDataBuffers();
    }

    final void initializePassword(String string) throws SQLException {
        this.password = string;
    }

    public boolean isDescriptorSharable(OracleConnection oracleConnection) throws SQLException {
        T2CConnection t2CConnection = this;
        PhysicalConnection physicalConnection = (PhysicalConnection)oracleConnection.getPhysicalConnection();
        return t2CConnection == physicalConnection;
    }

    public boolean isFileOpen(BFILE bFILE) throws SQLException {
        byte[] byArray = null;
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue((bFILE == null || (byArray = bFILE.getLocator()) == null) ^ true, 54);
        boolean[] blArray = new boolean[1];
        this.checkError(this.bfileIsOpen(this.m_nativeState, byArray, byArray.length, blArray));
        return blArray[0];
    }

    public boolean isOpen(BFILE bFILE) throws SQLException {
        byte[] byArray = null;
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue((bFILE == null || (byArray = bFILE.shareBytes()) == null) ^ true, 54);
        boolean[] blArray = new boolean[1];
        this.checkError(this.lobIsOpen(this.m_nativeState, 114, byArray, byArray.length, blArray));
        return blArray[0];
    }

    public boolean isOpen(BLOB bLOB) throws SQLException {
        byte[] byArray = null;
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue((bLOB == null || (byArray = bLOB.shareBytes()) == null) ^ true, 54);
        boolean[] blArray = new boolean[1];
        this.checkError(this.lobIsOpen(this.m_nativeState, 113, byArray, byArray.length, blArray));
        return blArray[0];
    }

    public boolean isOpen(CLOB cLOB) throws SQLException {
        byte[] byArray = null;
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue((cLOB == null || (byArray = cLOB.shareBytes()) == null) ^ true, 54);
        boolean[] blArray = new boolean[1];
        this.checkError(this.lobIsOpen(this.m_nativeState, 112, byArray, byArray.length, blArray));
        return blArray[0];
    }

    public boolean isTemporary(BLOB bLOB) throws SQLException {
        byte[] byArray = null;
        this.checkTrue((bLOB == null || (byArray = bLOB.shareBytes()) == null) ^ true, 54);
        boolean[] blArray = new boolean[1];
        this.checkError(this.lobIsTemporary(this.m_nativeState, 113, byArray, byArray.length, blArray));
        return blArray[0];
    }

    public boolean isTemporary(CLOB cLOB) throws SQLException {
        byte[] byArray = null;
        this.checkTrue((cLOB == null || (byArray = cLOB.shareBytes()) == null) ^ true, 54);
        boolean[] blArray = new boolean[1];
        this.checkError(this.lobIsTemporary(this.m_nativeState, 112, byArray, byArray.length, blArray));
        return blArray[0];
    }

    public long length(BFILE bFILE) throws SQLException {
        byte[] byArray = null;
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue((bFILE == null || (byArray = bFILE.getLocator()) == null) ^ true, 54);
        return this.lobLength(byArray);
    }

    public long length(BLOB bLOB) throws SQLException {
        byte[] byArray = null;
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue((bLOB == null || (byArray = bLOB.getLocator()) == null) ^ true, 54);
        return this.lobLength(byArray);
    }

    public long length(CLOB cLOB) throws SQLException {
        byte[] byArray = null;
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue((cLOB == null || (byArray = cLOB.getLocator()) == null) ^ true, 54);
        return this.lobLength(byArray);
    }

    private static final void loadNativeLibrary(Properties properties) throws SQLException {
        String string = null;
        if (properties != null) {
            string = properties.getProperty("oracle.jdbc.ocinativelibrary");
        }
        if (string == null || string.equals(OCILIBRARY)) {
            Class clazz = class$oracle$jdbc$driver$T2CConnection != null ? class$oracle$jdbc$driver$T2CConnection : (class$oracle$jdbc$driver$T2CConnection = T2CConnection.class$("oracle.jdbc.driver.T2CConnection"));
            synchronized (clazz) {
                if (!isLibraryLoaded) {
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            System.loadLibrary(T2CConnection.OCILIBRARY);
                            return null;
                        }
                    });
                    isLibraryLoaded = true;
                }
            }
        }
        Class clazz = class$oracle$jdbc$driver$T2CConnection != null ? class$oracle$jdbc$driver$T2CConnection : (class$oracle$jdbc$driver$T2CConnection = T2CConnection.class$("oracle.jdbc.driver.T2CConnection"));
        synchronized (clazz) {
            block11: {
                try {
                    System.loadLibrary(string);
                    isLibraryLoaded = true;
                }
                catch (SecurityException securityException) {
                    if (isLibraryLoaded) break block11;
                    System.loadLibrary(string);
                    isLibraryLoaded = true;
                }
            }
        }
    }

    native int lobClose(long var1, int var3, byte[] var4, int var5, byte[][] var6);

    native int lobCreateTemporary(long var1, int var3, boolean var4, int var5, short var6, byte[][] var7);

    native int lobFreeTemporary(long var1, int var3, byte[] var4, int var5, byte[][] var6);

    native int lobGetChunkSize(long var1, byte[] var3, int var4);

    private int lobGetChunkSize(byte[] byArray) throws SQLException {
        int n2 = 0;
        n2 = this.lobGetChunkSize(this.m_nativeState, byArray, byArray.length);
        this.checkError(n2);
        return n2;
    }

    native long lobGetLength(long var1, byte[] var3, int var4);

    native int lobIsOpen(long var1, int var3, byte[] var4, int var5, boolean[] var6);

    native int lobIsTemporary(long var1, int var3, byte[] var4, int var5, boolean[] var6);

    private long lobLength(byte[] byArray) throws SQLException {
        long l2 = 0L;
        l2 = this.lobGetLength(this.m_nativeState, byArray, byArray.length);
        this.checkError((int)l2);
        return l2;
    }

    native int lobOpen(long var1, int var3, byte[] var4, int var5, int var6, byte[][] var7);

    native int lobTrim(long var1, int var3, long var4, byte[] var6, int var7, byte[][] var8);

    protected void logoff() throws SQLException {
        try {
            if (this.m_nativeState != 0L) {
                this.checkError(this.t2cLogoff(this.m_nativeState));
            }
        }
        catch (NullPointerException nullPointerException) {}
    }

    protected void logon() throws SQLException {
        if (this.database == null) {
            DatabaseError.throwSqlException(64);
        }
        if (!isLibraryLoaded) {
            T2CConnection.loadNativeLibrary(this.connectionProperties);
        }
        if (this.connectionProperties.getProperty("is_connection_pooling") == "true") {
            this.processOCIConnectionPooling();
        } else {
            String string;
            long l2 = 0L;
            long l3 = 0L;
            long l4 = 0L;
            String string2 = this.connectionProperties.getProperty("OCISvcCtxHandle");
            if (string2 != null && (string = this.connectionProperties.getProperty("OCIEnvHandle")) != null) {
                String string3;
                l2 = Long.parseLong(string2);
                l3 = Long.parseLong(string);
                String string4 = this.connectionProperties.getProperty("OCIErrHandle");
                if (string4 != null) {
                    l4 = Long.parseLong(string4);
                }
                if ((string3 = this.connectionProperties.getProperty("JDBCDriverCharSetId")) != null) {
                    this.m_clientCharacterSet = new Integer(string3).shortValue();
                } else {
                    DatabaseError.throwSqlException(89);
                }
                this.conversion = new DBConversion(this.m_clientCharacterSet, this.m_clientCharacterSet, this.m_clientCharacterSet);
                short[] sArray = new short[3];
                this.sqlWarning = this.checkError(this.t2cUseConnection(this.m_nativeState, l3, l2, l4, sArray), this.sqlWarning);
                this.conversion = new DBConversion(sArray[0], this.m_clientCharacterSet, sArray[1]);
                this.byteAlign = (byte)(sArray[2] & 0xFF);
                return;
            }
            String string5 = this.connectionProperties.getProperty("internal_logon");
            if (string5 == null) {
                this.logon_mode = 0;
            } else if (string5.equalsIgnoreCase("SYSDBA")) {
                this.logon_mode = 2;
            } else if (string5.equalsIgnoreCase("SYSOPER")) {
                this.logon_mode = 4;
            }
            String string6 = this.connectionProperties.getProperty("oracle.jdbc.ociNlsLangBackwardCompatible");
            byte[] byArray = null;
            byte[] byArray2 = null;
            String string7 = null;
            byte[] byArray3 = new byte[]{};
            if (this.connectionProperties != null) {
                string7 = (String)((Hashtable)this.connectionProperties).get("OCINewPassword");
            }
            this.m_clientCharacterSet = string6 != null && string6.equalsIgnoreCase("true") ? T2CConnection.getDriverCharSetIdFromNLS_LANG(this.connectionProperties) : T2CConnection.getClientCharSetId();
            if (string7 != null) {
                byArray3 = DBConversion.stringToAsciiBytes(string7);
            }
            byArray = this.user == null ? new byte[]{} : DBConversion.stringToDriverCharBytes(this.user, this.m_clientCharacterSet);
            byArray2 = this.password == null ? new byte[]{} : DBConversion.stringToAsciiBytes(this.password);
            byte[] byArray4 = DBConversion.stringToAsciiBytes(this.database);
            short[] sArray = new short[3];
            byte[] byArray5 = CharacterSetMetaData.getNLSLanguage(Locale.getDefault()).getBytes();
            byte[] byArray6 = CharacterSetMetaData.getNLSTerritory(Locale.getDefault()).getBytes();
            this.conversion = new DBConversion(this.m_clientCharacterSet, this.m_clientCharacterSet, this.m_clientCharacterSet);
            this.sqlWarning = this.m_nativeState == 0L ? this.checkError(this.t2cCreateState(byArray, byArray.length, byArray2, byArray2.length, byArray3, byArray3.length, byArray4, byArray4.length, this.m_clientCharacterSet, this.logon_mode, sArray, byArray5, byArray6), this.sqlWarning) : this.checkError(this.t2cLogon(this.m_nativeState, byArray, byArray.length, byArray2, byArray2.length, byArray3, byArray3.length, byArray4, byArray4.length, this.logon_mode, sArray, byArray5, byArray6), this.sqlWarning);
            this.conversion = new DBConversion(sArray[0], this.m_clientCharacterSet, sArray[1]);
            this.byteAlign = (byte)(sArray[2] & 0xFF);
        }
    }

    public InputStream newConversionInputStream(BFILE bFILE, int n2) throws SQLException {
        this.checkTrue((bFILE == null || bFILE.shareBytes() == null) ^ true, 54);
        OracleConversionInputStream oracleConversionInputStream = new OracleConversionInputStream(this.conversion, bFILE.getBinaryStream(), n2);
        return oracleConversionInputStream;
    }

    public InputStream newConversionInputStream(BLOB bLOB, int n2) throws SQLException {
        this.checkTrue(bLOB != null && bLOB.shareBytes() != null, 54);
        OracleConversionInputStream oracleConversionInputStream = new OracleConversionInputStream(this.conversion, bLOB.getBinaryStream(), n2);
        return oracleConversionInputStream;
    }

    public Reader newConversionReader(BFILE bFILE, int n2) throws SQLException {
        this.checkTrue((bFILE == null || bFILE.shareBytes() == null) ^ true, 54);
        OracleConversionReader oracleConversionReader = new OracleConversionReader(this.conversion, bFILE.getBinaryStream(), n2);
        return oracleConversionReader;
    }

    public Reader newConversionReader(BLOB bLOB, int n2) throws SQLException {
        this.checkTrue(bLOB != null && bLOB.shareBytes() != null, 54);
        OracleConversionReader oracleConversionReader = new OracleConversionReader(this.conversion, bLOB.getBinaryStream(), n2);
        return oracleConversionReader;
    }

    public InputStream newInputStream(BFILE bFILE, int n2, long l2) throws SQLException {
        if (l2 == 0L) {
            return new OracleBlobInputStream(bFILE, n2);
        }
        return new OracleBlobInputStream(bFILE, n2, l2);
    }

    public InputStream newInputStream(BLOB bLOB, int n2, long l2) throws SQLException {
        if (l2 == 0L) {
            return new OracleBlobInputStream(bLOB, n2);
        }
        return new OracleBlobInputStream(bLOB, n2, l2);
    }

    public InputStream newInputStream(CLOB cLOB, int n2, long l2) throws SQLException {
        if (l2 == 0L) {
            return new OracleClobInputStream(cLOB, n2);
        }
        return new OracleClobInputStream(cLOB, n2, l2);
    }

    public OutputStream newOutputStream(BLOB bLOB, int n2, long l2) throws SQLException {
        if (l2 == 0L) {
            return new OracleBlobOutputStream(bLOB, n2);
        }
        return new OracleBlobOutputStream(bLOB, n2, l2);
    }

    public OutputStream newOutputStream(CLOB cLOB, int n2, long l2) throws SQLException {
        if (l2 == 0L) {
            return new OracleClobOutputStream(cLOB, n2);
        }
        return new OracleClobOutputStream(cLOB, n2, l2);
    }

    public Reader newReader(CLOB cLOB, int n2, long l2) throws SQLException {
        if (l2 == 0L) {
            return new OracleClobReader(cLOB, n2);
        }
        return new OracleClobReader(cLOB, n2, l2);
    }

    public Writer newWriter(CLOB cLOB, int n2, long l2) throws SQLException {
        if (l2 == 0L) {
            return new OracleClobWriter(cLOB, n2);
        }
        return new OracleClobWriter(cLOB, n2, l2);
    }

    public void ociPasswordChange(String string, String string2, String string3) throws SQLException {
        if (this.lifecycle != 1) {
            DatabaseError.throwSqlException(8);
        }
        byte[] byArray = string == null ? new byte[]{} : DBConversion.stringToDriverCharBytes(string, this.m_clientCharacterSet);
        byte[] byArray2 = string2 == null ? new byte[]{} : DBConversion.stringToAsciiBytes(string2);
        byte[] byArray3 = string3 == null ? new byte[]{} : DBConversion.stringToAsciiBytes(string3);
        this.sqlWarning = this.checkError(this.t2cPasswordChange(this.m_nativeState, byArray, byArray.length, byArray2, byArray2.length, byArray3, byArray3.length), this.sqlWarning);
    }

    public void open(OracleStatement oracleStatement) throws SQLException {
        byte[] byArray = oracleStatement.sqlObject.getSql(oracleStatement.processEscapes, oracleStatement.convertNcharLiterals).getBytes();
        this.checkError(this.t2cCreateStatement(this.m_nativeState, 0L, byArray, byArray.length, oracleStatement, false, oracleStatement.rowPrefetch));
    }

    public void open(BFILE bFILE, int n2) throws SQLException {
        byte[] byArray = null;
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue((bFILE == null || (byArray = bFILE.shareBytes()) == null) ^ true, 54);
        byte[][] byArray2 = new byte[1][];
        this.checkError(this.lobOpen(this.m_nativeState, 114, byArray, byArray.length, n2, byArray2));
        bFILE.setShareBytes(byArray2[0]);
    }

    public void open(BLOB bLOB, int n2) throws SQLException {
        byte[] byArray = null;
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue((bLOB == null || (byArray = bLOB.shareBytes()) == null) ^ true, 54);
        byte[][] byArray2 = new byte[1][];
        this.checkError(this.lobOpen(this.m_nativeState, 113, byArray, byArray.length, n2, byArray2));
        bLOB.setShareBytes(byArray2[0]);
    }

    public void open(CLOB cLOB, int n2) throws SQLException {
        byte[] byArray = null;
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue((cLOB == null || (byArray = cLOB.shareBytes()) == null) ^ true, 54);
        byte[][] byArray2 = new byte[1][];
        this.checkError(this.lobOpen(this.m_nativeState, 112, byArray, byArray.length, n2, byArray2));
        cLOB.setShareBytes(byArray2[0]);
    }

    public void openFile(BFILE bFILE) throws SQLException {
        byte[] byArray = null;
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue((bFILE == null || (byArray = bFILE.getLocator()) == null) ^ true, 54);
        byte[][] byArray2 = new byte[1][];
        this.checkError(this.bfileOpen(this.m_nativeState, byArray, byArray.length, byArray2));
        bFILE.setLocator(byArray2[0]);
    }

    public long position(BFILE bFILE, BFILE bFILE2, long l2) throws SQLException {
        long l3;
        if (l2 < 1L) {
            DatabaseError.throwSqlException(68, "position()");
        }
        l3 = (l3 = LobPlsqlUtil.isSubLob(bFILE, bFILE2, l2)) == 0L ? -1L : l3;
        return l3;
    }

    public long position(BFILE bFILE, byte[] byArray, long l2) throws SQLException {
        long l3;
        if (l2 < 1L) {
            DatabaseError.throwSqlException(68, "position()");
        }
        l3 = (l3 = LobPlsqlUtil.hasPattern(bFILE, byArray, l2)) == 0L ? -1L : l3;
        return l3;
    }

    public long position(BLOB bLOB, BLOB bLOB2, long l2) throws SQLException {
        long l3;
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue(bLOB != null && bLOB.shareBytes() != null, 54);
        this.checkTrue(bLOB2 != null && bLOB2.shareBytes() != null, 54);
        if (l2 < 1L) {
            DatabaseError.throwSqlException(68, "position()");
        }
        l3 = (l3 = LobPlsqlUtil.isSubLob(bLOB, bLOB2, l2)) == 0L ? -1L : l3;
        return l3;
    }

    public long position(BLOB bLOB, byte[] byArray, long l2) throws SQLException {
        long l3;
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue(bLOB != null && bLOB.shareBytes() != null, 54);
        if (l2 < 1L) {
            DatabaseError.throwSqlException(68, "position()");
        }
        l3 = (l3 = LobPlsqlUtil.hasPattern(bLOB, byArray, l2)) == 0L ? -1L : l3;
        return l3;
    }

    public long position(CLOB cLOB, String string, long l2) throws SQLException {
        if (string == null) {
            throw new SQLException("pattern cannot be null.");
        }
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue(cLOB != null && cLOB.shareBytes() != null, 54);
        if (l2 < 1L) {
            DatabaseError.throwSqlException(68, "position()");
        }
        char[] cArray = new char[string.length()];
        string.getChars(0, cArray.length, cArray, 0);
        long l3 = LobPlsqlUtil.hasPattern(cLOB, cArray, l2);
        l3 = l3 == 0L ? -1L : l3;
        return l3;
    }

    public long position(CLOB cLOB, CLOB cLOB2, long l2) throws SQLException {
        long l3;
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue(cLOB != null && cLOB.shareBytes() != null, 54);
        this.checkTrue(cLOB2 != null && cLOB2.shareBytes() != null, 54);
        if (l2 < 1L) {
            DatabaseError.throwSqlException(68, "position()");
        }
        l3 = (l3 = LobPlsqlUtil.isSubLob(cLOB, cLOB2, l2)) == 0L ? -1L : l3;
        return l3;
    }

    private void processDescribeTableData(int n2, AutoKeyInfo autoKeyInfo) throws SQLException {
        short[] sArray = this.queryMetaData1;
        byte[] byArray = this.queryMetaData2;
        int n3 = this.queryMetaData1Offset;
        int n4 = this.queryMetaData2Offset;
        autoKeyInfo.allocateSpaceForDescribedData(n2);
        int n5 = 0;
        while (n5 < n2) {
            short s2 = sArray[n3];
            short s3 = sArray[n3 + 6];
            String string = T2CConnection.bytes2String(byArray, n4, s3, this.conversion);
            short s4 = sArray[n3 + 1];
            short s5 = sArray[n3 + 11];
            boolean bl2 = sArray[n3 + 2] != 0;
            short s6 = sArray[n3 + 5];
            short s7 = sArray[n3 + 3];
            short s8 = sArray[n3 + 4];
            short s9 = sArray[n3 + 12];
            n4 += s3;
            n3 += 13;
            String string2 = null;
            if (s9 > 0) {
                string2 = T2CConnection.bytes2String(byArray, n4, s9, this.conversion);
                n4 += s9;
            }
            autoKeyInfo.fillDescribedData(n5, string, s2, s5 > 0 ? s5 : s4, bl2, s6, s7, s8, string2);
            ++n5;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processOCIConnectionPooling() throws SQLException {
        if (this.lifecycle != 1) {
            DatabaseError.throwSqlException(8);
        }
        byte[] byArray = null;
        byte[] byArray2 = this.password == null ? new byte[]{} : DBConversion.stringToAsciiBytes(this.password);
        byte[] byArray3 = DBConversion.stringToAsciiBytes(this.database);
        byte[] byArray4 = CharacterSetMetaData.getNLSLanguage(Locale.getDefault()).getBytes();
        byte[] byArray5 = CharacterSetMetaData.getNLSTerritory(Locale.getDefault()).getBytes();
        String string = this.connectionProperties.getProperty("connection_pool");
        short[] sArray = new short[3];
        if (string == "connection_pool") {
            String string2 = this.connectionProperties.getProperty("oracle.jdbc.ociNlsLangBackwardCompatible");
            this.m_clientCharacterSet = string2 != null && string2.equalsIgnoreCase("true") ? T2CConnection.getDriverCharSetIdFromNLS_LANG(this.connectionProperties) : T2CConnection.getClientCharSetId();
            byArray = this.user == null ? new byte[]{} : DBConversion.stringToDriverCharBytes(this.user, this.m_clientCharacterSet);
            this.conversion = new DBConversion(this.m_clientCharacterSet, this.m_clientCharacterSet, this.m_clientCharacterSet);
            this.logon_mode = 5;
            if (this.m_nativeState != 0L) throw DatabaseError.newSqlException(0, "Internal Error: ");
            int[] nArray = new int[6];
            OracleOCIConnectionPool.readPoolConfig(this.connectionProperties, nArray);
            this.sqlWarning = this.checkError(this.t2cCreateConnPool(byArray, byArray.length, byArray2, byArray2.length, byArray3, byArray3.length, this.m_clientCharacterSet, this.logon_mode, nArray[0], nArray[1], nArray[2], nArray[3], nArray[4], nArray[5]), this.sqlWarning);
            this.versionNumber = (short)10000;
        } else if (string == "connpool_connection") {
            this.logon_mode = 6;
            T2CConnection t2CConnection = (T2CConnection)((Hashtable)this.connectionProperties).get("connpool_object");
            this.m_clientCharacterSet = t2CConnection.m_clientCharacterSet;
            byArray = this.user == null ? new byte[]{} : DBConversion.stringToDriverCharBytes(this.user, this.m_clientCharacterSet);
            this.conversion = new DBConversion(this.m_clientCharacterSet, this.m_clientCharacterSet, this.m_clientCharacterSet);
            this.sqlWarning = this.checkError(this.t2cConnPoolLogon(t2CConnection.m_nativeState, byArray, byArray.length, byArray2, byArray2.length, byArray3, byArray3.length, this.logon_mode, 0, 0, null, null, 0, null, 0, null, 0, null, 0, null, 0, sArray, byArray4, byArray5), this.sqlWarning);
        } else if (string == "connpool_alias_connection") {
            this.logon_mode = 8;
            byte[] byArray6 = null;
            byArray6 = (byte[])((Hashtable)this.connectionProperties).get("connection_id");
            T2CConnection t2CConnection = (T2CConnection)((Hashtable)this.connectionProperties).get("connpool_object");
            this.m_clientCharacterSet = t2CConnection.m_clientCharacterSet;
            byArray = this.user == null ? new byte[]{} : DBConversion.stringToDriverCharBytes(this.user, this.m_clientCharacterSet);
            this.conversion = new DBConversion(this.m_clientCharacterSet, this.m_clientCharacterSet, this.m_clientCharacterSet);
            this.sqlWarning = this.checkError(this.t2cConnPoolLogon(t2CConnection.m_nativeState, byArray, byArray.length, byArray2, byArray2.length, byArray3, byArray3.length, this.logon_mode, 0, 0, null, null, 0, null, 0, null, 0, null, 0, byArray6, byArray6 == null ? 0 : byArray6.length, sArray, byArray4, byArray5), this.sqlWarning);
        } else if (string == "connpool_proxy_connection") {
            this.logon_mode = 7;
            String string3 = this.connectionProperties.getProperty("proxytype");
            Integer n2 = (Integer)((Hashtable)this.connectionProperties).get("proxy_num_roles");
            int n3 = n2;
            String[] stringArray = null;
            if (n3 > 0) {
                stringArray = (String[])((Hashtable)this.connectionProperties).get("proxy_roles");
            }
            byte[] byArray7 = null;
            byte[] byArray8 = null;
            byte[] byArray9 = null;
            byte[] byArray10 = null;
            int n4 = 0;
            if (string3 == "proxytype_user_name") {
                n4 = 1;
                String string4 = this.connectionProperties.getProperty("proxy_user_name");
                if (string4 != null) {
                    byArray7 = string4.getBytes();
                }
                if ((string4 = this.connectionProperties.getProperty("proxy_password")) != null) {
                    byArray8 = string4.getBytes();
                }
            } else if (string3 == "proxytype_distinguished_name") {
                n4 = 2;
                String string5 = this.connectionProperties.getProperty("proxy_distinguished_name");
                if (string5 != null) {
                    byArray9 = string5.getBytes();
                }
            } else if (string3 == "proxytype_certificate") {
                n4 = 3;
                byArray10 = (byte[])((Hashtable)this.connectionProperties).get("proxy_certificate");
            } else {
                DatabaseError.throwSqlException(107);
            }
            T2CConnection t2CConnection = (T2CConnection)((Hashtable)this.connectionProperties).get("connpool_object");
            this.m_clientCharacterSet = t2CConnection.m_clientCharacterSet;
            byArray = this.user == null ? new byte[]{} : DBConversion.stringToDriverCharBytes(this.user, this.m_clientCharacterSet);
            this.conversion = new DBConversion(this.m_clientCharacterSet, this.m_clientCharacterSet, this.m_clientCharacterSet);
            this.sqlWarning = this.checkError(this.t2cConnPoolLogon(t2CConnection.m_nativeState, byArray, byArray.length, byArray2, byArray2.length, byArray3, byArray3.length, this.logon_mode, n4, n3, stringArray, byArray7, byArray7 == null ? 0 : byArray7.length, byArray8, byArray8 == null ? 0 : byArray8.length, byArray9, byArray9 == null ? 0 : byArray9.length, byArray10, byArray10 == null ? 0 : byArray10.length, null, 0, sArray, byArray4, byArray5), this.sqlWarning);
        } else {
            DatabaseError.throwSqlException(23, "connection-pool-logon");
        }
        this.conversion = new DBConversion(sArray[0], this.m_clientCharacterSet, sArray[1]);
        this.byteAlign = (byte)(sArray[2] & 0xFF);
    }

    public int putBytes(BLOB bLOB, long l2, byte[] byArray, int n2, int n3) throws SQLException {
        this.checkTrue(l2 >= 0L, 68);
        int n4 = 0;
        if (byArray == null || byArray.length == 0 || n3 <= 0) {
            n4 = 0;
        } else {
            byte[] byArray2 = null;
            this.checkTrue(this.m_nativeState != 0L, 8);
            this.checkTrue((bLOB == null || (byArray2 = bLOB.getLocator()) == null) ^ true, 54);
            if (byArray == null) {
                return 0;
            }
            byte[][] byArray3 = new byte[1][];
            n4 = this.blobWrite(byArray2, l2, byArray, byArray3, n2, n3);
            bLOB.setLocator(byArray3[0]);
        }
        return n4;
    }

    public int putChars(CLOB cLOB, long l2, char[] cArray, int n2, int n3) throws SQLException {
        byte[] byArray = null;
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue(l2 >= 0L, 68);
        this.checkTrue((cLOB == null || (byArray = cLOB.getLocator()) == null) ^ true, 54);
        if (cArray == null) {
            return 0;
        }
        byte[][] byArray2 = new byte[1][];
        int n4 = this.clobWrite(byArray, l2, cArray, byArray2, cLOB.isNCLOB(), n2, n3);
        cLOB.setLocator(byArray2[0]);
        return n4;
    }

    void reallocateQueryMetaData(int n2, int n3) {
        this.queryMetaData1 = null;
        this.queryMetaData2 = null;
        this.queryMetaData1Size = Math.max(n2, this.queryMetaData1Size);
        this.queryMetaData2Size = Math.max(n3, this.queryMetaData2Size);
        this.allocQueryMetaDataBuffers();
    }

    public synchronized void registerTAFCallback(OracleOCIFailover oracleOCIFailover, Object object) throws SQLException {
        this.appCallback = oracleOCIFailover;
        this.appCallbackObject = object;
        this.checkError(this.t2cRegisterTAFCallback(this.m_nativeState));
    }

    public void setConnectionPoolInfo(int n2, int n3, int n4, int n5, int n6, int n7) throws SQLException {
        this.checkError(this.t2cSetConnPoolInfo(this.m_nativeState, n2, n3, n4, n5, n6, n7));
    }

    native int t2cAbort(long var1);

    private native int t2cCancel(long var1);

    native int t2cClearAllApplicationContext(long var1, String var3);

    native int t2cCloseProxySession(long var1);

    private native int t2cCommit(long var1);

    native int t2cConnPoolLogon(long var1, byte[] var3, int var4, byte[] var5, int var6, byte[] var7, int var8, int var9, int var10, int var11, String[] var12, byte[] var13, int var14, byte[] var15, int var16, byte[] var17, int var18, byte[] var19, int var20, byte[] var21, int var22, short[] var23, byte[] var24, byte[] var25);

    native int t2cCreateConnPool(byte[] var1, int var2, byte[] var3, int var4, byte[] var5, int var6, short var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14);

    native int t2cCreateState(byte[] var1, int var2, byte[] var3, int var4, byte[] var5, int var6, byte[] var7, int var8, short var9, int var10, short[] var11, byte[] var12, byte[] var13);

    private native int t2cCreateStatement(long var1, long var3, byte[] var5, int var6, OracleStatement var7, boolean var8, int var9);

    native int t2cDescribeError(long var1, T2CError var3, byte[] var4);

    static native int t2cDescribeTable(long var0, byte[] var2, int var3, short[] var4, byte[] var5, int var6, int var7, int var8, int var9);

    native int t2cDoProxySession(long var1, int var3, byte[] var4, int var5, byte[] var6, int var7, byte[] var8, int var9, byte[] var10, int var11, int var12, byte[][] var13);

    native int t2cGetConnPoolInfo(long var1, Properties var3);

    protected native byte[] t2cGetConnectionId(long var1);

    private native int t2cGetDefaultStreamChunkSize(long var1);

    static native short t2cGetDriverCharSetFromNlsLang();

    native int t2cGetFormOfUse(long var1, OracleTypeCLOB var3, byte[] var4, int var5, int var6);

    native int t2cGetHandles(long var1, long[] var3);

    native int t2cGetHeapAllocSize(long var1);

    native int t2cGetOciEnvHeapAllocSize(long var1);

    private native byte[] t2cGetProductionVersion(long var1);

    static native short t2cGetServerSessionInfo(long var0, Properties var2);

    native long t2cGetTDO(long var1, byte[] var3, int var4, int[] var5);

    private native int t2cGetVersionNumber(long var1);

    private native int t2cLogoff(long var1);

    native int t2cLogon(long var1, byte[] var3, int var4, byte[] var5, int var6, byte[] var7, int var8, byte[] var9, int var10, int var11, short[] var12, byte[] var13, byte[] var14);

    native int t2cPasswordChange(long var1, byte[] var3, int var4, byte[] var5, int var6, byte[] var7, int var8);

    native boolean t2cPlatformIsLittleEndian(long var1);

    native int t2cRegisterTAFCallback(long var1);

    private native int t2cRollback(long var1);

    native int t2cSetApplicationContext(long var1, String var3, String var4, String var5);

    private native int t2cSetAutoCommit(long var1, boolean var3);

    native int t2cSetConnPoolInfo(long var1, int var3, int var4, int var5, int var6, int var7, int var8);

    native int t2cUseConnection(long var1, long var3, long var5, long var7, short[] var9);

    public void trim(BLOB bLOB, long l2) throws SQLException {
        byte[] byArray = null;
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue((bLOB == null || (byArray = bLOB.shareBytes()) == null) ^ true, 54);
        byte[][] byArray2 = new byte[1][];
        this.checkError(this.lobTrim(this.m_nativeState, 113, l2, byArray, byArray.length, byArray2));
        bLOB.setShareBytes(byArray2[0]);
    }

    public void trim(CLOB cLOB, long l2) throws SQLException {
        byte[] byArray = null;
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue((cLOB == null || (byArray = cLOB.shareBytes()) == null) ^ true, 54);
        byte[][] byArray2 = new byte[1][];
        this.checkError(this.lobTrim(this.m_nativeState, 112, l2, byArray, byArray.length, byArray2));
        cLOB.setShareBytes(byArray2[0]);
    }

    boolean useLittleEndianSetCHARBinder() throws SQLException {
        return this.t2cPlatformIsLittleEndian(this.m_nativeState);
    }
}

