/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleCallableStatement;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.PlsqlIndexTableAccessor;
import oracle.jdbc.driver.T4C8Oall;
import oracle.jdbc.driver.T4CBfileAccessor;
import oracle.jdbc.driver.T4CBinaryDoubleAccessor;
import oracle.jdbc.driver.T4CBinaryFloatAccessor;
import oracle.jdbc.driver.T4CBlobAccessor;
import oracle.jdbc.driver.T4CCharAccessor;
import oracle.jdbc.driver.T4CClobAccessor;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CDateAccessor;
import oracle.jdbc.driver.T4CIntervaldsAccessor;
import oracle.jdbc.driver.T4CIntervalymAccessor;
import oracle.jdbc.driver.T4CLongAccessor;
import oracle.jdbc.driver.T4CLongRawAccessor;
import oracle.jdbc.driver.T4CNamedTypeAccessor;
import oracle.jdbc.driver.T4CNumberAccessor;
import oracle.jdbc.driver.T4COutRawAccessor;
import oracle.jdbc.driver.T4CPlsqlIndexTableAccessor;
import oracle.jdbc.driver.T4CRawAccessor;
import oracle.jdbc.driver.T4CRefTypeAccessor;
import oracle.jdbc.driver.T4CResultSetAccessor;
import oracle.jdbc.driver.T4CRowidAccessor;
import oracle.jdbc.driver.T4CTimestampAccessor;
import oracle.jdbc.driver.T4CTimestampltzAccessor;
import oracle.jdbc.driver.T4CTimestamptzAccessor;
import oracle.jdbc.driver.T4CVarcharAccessor;
import oracle.jdbc.driver.T4CVarnumAccessor;

class T4CCallableStatement
extends OracleCallableStatement {
    static final byte[] EMPTY_BYTE = new byte[0];
    T4CConnection t4Connection;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Jun_22_11:15:45_PDT_2005";

    T4CCallableStatement(PhysicalConnection physicalConnection, String string, int n2, int n3) throws SQLException {
        super(physicalConnection, string, physicalConnection.defaultBatch, physicalConnection.defaultRowPrefetch, n2, n3);
        this.t4Connection = (T4CConnection)physicalConnection;
        this.theRowidBinder = OraclePreparedStatement.theStaticT4CRowidBinder;
        this.theRowidNullBinder = OraclePreparedStatement.theStaticT4CRowidNullBinder;
    }

    Accessor allocateAccessor(int n2, int n3, int n4, int n5, short s2, String string, boolean bl2) throws SQLException {
        Accessor accessor = null;
        switch (n2) {
            case 96: {
                accessor = new T4CCharAccessor(this, n5, s2, n3, bl2, this.t4Connection.mare);
                break;
            }
            case 8: {
                if (!bl2) {
                    accessor = new T4CLongAccessor(this, n4, n5, s2, n3, this.t4Connection.mare);
                    break;
                }
            }
            case 1: {
                accessor = new T4CVarcharAccessor(this, n5, s2, n3, bl2, this.t4Connection.mare);
                break;
            }
            case 2: {
                accessor = new T4CNumberAccessor(this, n5, s2, n3, bl2, this.t4Connection.mare);
                break;
            }
            case 6: {
                accessor = new T4CVarnumAccessor(this, n5, s2, n3, bl2, this.t4Connection.mare);
                break;
            }
            case 24: {
                if (!bl2) {
                    accessor = new T4CLongRawAccessor(this, n4, n5, s2, n3, this.t4Connection.mare);
                    break;
                }
            }
            case 23: {
                if (bl2 && string != null) {
                    DatabaseError.throwSqlException(12, "sqlType=" + n3);
                }
                if (bl2) {
                    accessor = new T4COutRawAccessor(this, n5, s2, n3, this.t4Connection.mare);
                    break;
                }
                accessor = new T4CRawAccessor(this, n5, s2, n3, bl2, this.t4Connection.mare);
                break;
            }
            case 100: {
                accessor = new T4CBinaryFloatAccessor(this, n5, s2, n3, bl2, this.t4Connection.mare);
                break;
            }
            case 101: {
                accessor = new T4CBinaryDoubleAccessor(this, n5, s2, n3, bl2, this.t4Connection.mare);
                break;
            }
            case 104: {
                accessor = new T4CRowidAccessor(this, n5, s2, n3, bl2, this.t4Connection.mare);
                break;
            }
            case 102: {
                accessor = new T4CResultSetAccessor(this, n5, s2, n3, bl2, this.t4Connection.mare);
                break;
            }
            case 12: {
                accessor = new T4CDateAccessor(this, n5, s2, n3, bl2, this.t4Connection.mare);
                break;
            }
            case 113: {
                accessor = new T4CBlobAccessor(this, n5, s2, n3, bl2, this.t4Connection.mare);
                break;
            }
            case 112: {
                accessor = new T4CClobAccessor(this, n5, s2, n3, bl2, this.t4Connection.mare);
                break;
            }
            case 114: {
                accessor = new T4CBfileAccessor(this, n5, s2, n3, bl2, this.t4Connection.mare);
                break;
            }
            case 109: {
                accessor = new T4CNamedTypeAccessor(this, string, s2, n3, bl2, this.t4Connection.mare);
                accessor.initMetadata();
                break;
            }
            case 111: {
                accessor = new T4CRefTypeAccessor(this, string, s2, n3, bl2, this.t4Connection.mare);
                accessor.initMetadata();
                break;
            }
            case 180: {
                if (this.connection.v8Compatible) {
                    accessor = new T4CDateAccessor(this, n5, s2, n3, bl2, this.t4Connection.mare);
                    break;
                }
                accessor = new T4CTimestampAccessor(this, n5, s2, n3, bl2, this.t4Connection.mare);
                break;
            }
            case 181: {
                accessor = new T4CTimestamptzAccessor(this, n5, s2, n3, bl2, this.t4Connection.mare);
                break;
            }
            case 231: {
                accessor = new T4CTimestampltzAccessor(this, n5, s2, n3, bl2, this.t4Connection.mare);
                break;
            }
            case 182: {
                accessor = new T4CIntervalymAccessor(this, n5, s2, n3, bl2, this.t4Connection.mare);
                break;
            }
            case 183: {
                accessor = new T4CIntervaldsAccessor(this, n5, s2, n3, bl2, this.t4Connection.mare);
                break;
            }
            case 995: {
                DatabaseError.throwSqlException(89);
            }
        }
        return accessor;
    }

    PlsqlIndexTableAccessor allocateIndexTableAccessor(int n2, int n3, int n4, int n5, short s2, boolean bl2) throws SQLException {
        return new T4CPlsqlIndexTableAccessor(this, n2, n3, n4, n5, s2, bl2, this.t4Connection.mare);
    }

    void allocateRowidAccessor() throws SQLException {
        this.accessors[0] = new T4CRowidAccessor(this, 128, 1, -8, false, this.t4Connection.mare);
    }

    void allocateTmpByteArray() {
        if (this.tmpByteArray == null) {
            this.tmpByteArray = new byte[this.sizeTmpByteArray];
        } else if (this.sizeTmpByteArray > this.tmpByteArray.length) {
            this.tmpByteArray = new byte[this.sizeTmpByteArray];
        }
    }

    public synchronized void clearDefines() throws SQLException {
        super.clearDefines();
        this.definedColumnType = null;
        this.definedColumnSize = null;
        this.definedColumnFormOfUse = null;
    }

    void closeQuery() throws SQLException {
        this.t4Connection.assertLoggedOn("oracle.jdbc.driver.T4CCallableStatement.closeQuery");
        if (this.streamList != null) {
            while (this.nextStream != null) {
                try {
                    this.nextStream.close();
                }
                catch (IOException iOException) {
                    ((T4CConnection)this.connection).handleIOException(iOException);
                    DatabaseError.throwSqlException(iOException);
                }
                this.nextStream = this.nextStream.nextStream;
            }
        }
    }

    void continueReadRow(int n2) throws SQLException {
        try {
            if (!this.connection.useFetchSizeWithLongColumn) {
                T4C8Oall t4C8Oall = this.t4Connection.all8;
                t4C8Oall.continueReadRow(n2);
            }
        }
        catch (IOException iOException) {
            ((T4CConnection)this.connection).handleIOException(iOException);
            DatabaseError.throwSqlException(iOException);
        }
        catch (SQLException sQLException) {
            if (sQLException.getErrorCode() == DatabaseError.getVendorCode(110)) {
                this.sqlWarning = DatabaseError.addSqlWarning(this.sqlWarning, 110);
            }
            throw sQLException;
        }
    }

    protected void defineColumnTypeInternal(int n2, int n3, int n4, short s2, boolean bl2, String string) throws SQLException {
        int[] nArray;
        if (this.connection.disableDefineColumnType) {
            return;
        }
        if (n2 < 1) {
            DatabaseError.throwSqlException(3);
        }
        if (bl2) {
            if (n3 == 1 || n3 == 12) {
                this.sqlWarning = DatabaseError.addSqlWarning(this.sqlWarning, 108);
            }
        } else if (n4 < 0) {
            DatabaseError.throwSqlException(53);
        }
        if (this.currentResultSet != null && !this.currentResultSet.closed) {
            DatabaseError.throwSqlException(28);
        }
        int n5 = n2 - 1;
        if (this.definedColumnType == null || this.definedColumnType.length <= n5) {
            if (this.definedColumnType == null) {
                this.definedColumnType = new int[(n5 + 1) * 4];
            } else {
                nArray = new int[(n5 + 1) * 4];
                System.arraycopy(this.definedColumnType, 0, nArray, 0, this.definedColumnType.length);
                this.definedColumnType = nArray;
            }
        }
        this.definedColumnType[n5] = n3;
        if (this.definedColumnSize == null || this.definedColumnSize.length <= n5) {
            if (this.definedColumnSize == null) {
                this.definedColumnSize = new int[(n5 + 1) * 4];
            } else {
                nArray = new int[(n5 + 1) * 4];
                System.arraycopy(this.definedColumnSize, 0, nArray, 0, this.definedColumnSize.length);
                this.definedColumnSize = nArray;
            }
        }
        this.definedColumnSize[n5] = n4;
        if (this.definedColumnFormOfUse == null || this.definedColumnFormOfUse.length <= n5) {
            if (this.definedColumnFormOfUse == null) {
                this.definedColumnFormOfUse = new int[(n5 + 1) * 4];
            } else {
                nArray = new int[(n5 + 1) * 4];
                System.arraycopy(this.definedColumnFormOfUse, 0, nArray, 0, this.definedColumnFormOfUse.length);
                this.definedColumnFormOfUse = nArray;
            }
        }
        this.definedColumnFormOfUse[n5] = s2;
        if (this.accessors != null && n5 < this.accessors.length && this.accessors[n5] != null) {
            this.accessors[n5].definedColumnSize = n4;
            if (!(this.accessors[n5].internalType != 96 && this.accessors[n5].internalType != 1 || n3 != 1 && n3 != 12 || n4 > this.accessors[n5].oacmxl)) {
                this.needToPrepareDefineBuffer = true;
                this.columnsDefinedByUser = true;
                this.accessors[n5].initForDataAccess(n3, n4, null);
                this.accessors[n5].calculateSizeTmpByteArray();
            }
        }
    }

    void doClose() throws SQLException {
        this.t4Connection.assertLoggedOn("oracle.jdbc.driver.T4CCallableStatement.do_close");
        try {
            if (this.cursorId != 0) {
                this.t4Connection.cursorToClose[this.t4Connection.cursorToCloseOffset++] = this.cursorId;
                if (this.t4Connection.cursorToCloseOffset >= this.t4Connection.cursorToClose.length) {
                    this.t4Connection.sendPiggyBackedMessages();
                }
            }
        }
        catch (IOException iOException) {
            ((T4CConnection)this.connection).handleIOException(iOException);
            DatabaseError.throwSqlException(iOException);
        }
        this.tmpByteArray = null;
        this.tmpBindsByteArray = null;
        this.definedColumnType = null;
        this.definedColumnSize = null;
        this.definedColumnFormOfUse = null;
        this.oacdefSent = null;
    }

    void doDescribe(boolean bl2) throws SQLException {
        if (!this.isOpen) {
            DatabaseError.throwSqlException(144);
        }
        try {
            this.t4Connection.sendPiggyBackedMessages();
            this.t4Connection.describe.init(this, 0);
            this.t4Connection.describe.marshal();
            this.accessors = this.t4Connection.describe.receive(this.accessors);
            this.numberOfDefinePositions = this.t4Connection.describe.numuds;
            int n2 = 0;
            while (n2 < this.numberOfDefinePositions) {
                this.accessors[n2].initMetadata();
                ++n2;
            }
        }
        catch (IOException iOException) {
            ((T4CConnection)this.connection).handleIOException(iOException);
            DatabaseError.throwSqlException(iOException);
        }
        this.describedWithNames = true;
        this.described = true;
    }

    void doOall8(boolean bl2, boolean bl3, boolean bl4, boolean bl5) throws SQLException, IOException {
        int n2;
        if (bl2 || bl5 || !bl3 || this.sqlKind != 2 && this.sqlKind != 1 && this.sqlKind != 4) {
            this.oacdefSent = null;
        }
        this.t4Connection.assertLoggedOn("oracle.jdbc.driver.T4CCallableStatement.doOall8");
        if (this.sqlKind != 1 && this.sqlKind != 4 && this.sqlKind != 3 && this.sqlKind != 0 && this.sqlKind != 2) {
            DatabaseError.throwSqlException(439);
        }
        int n3 = this.numberOfDefinePositions;
        if (this.sqlKind == 2) {
            n3 = 0;
        }
        if (bl4) {
            if (this.accessors != null) {
                n2 = 0;
                while (n2 < this.numberOfDefinePositions) {
                    if (this.accessors[n2] != null) {
                        this.accessors[n2].lastRowProcessed = 0;
                    }
                    ++n2;
                }
            }
            if (this.outBindAccessors != null) {
                n2 = 0;
                while (n2 < this.outBindAccessors.length) {
                    if (this.outBindAccessors[n2] != null) {
                        this.outBindAccessors[n2].lastRowProcessed = 0;
                    }
                    ++n2;
                }
            }
        }
        if (this.returnParamAccessors != null) {
            n2 = 0;
            while (n2 < this.numberOfBindPositions) {
                if (this.returnParamAccessors[n2] != null) {
                    this.returnParamAccessors[n2].lastRowProcessed = 0;
                }
                ++n2;
            }
        }
        if (this.bindIndicators != null) {
            n2 = this.bindIndicators[this.bindIndicatorSubRange + 2] & 0xFFFF;
            int n4 = 0;
            if (this.ibtBindChars != null) {
                n4 = this.ibtBindChars.length * this.connection.conversion.cMaxCharSize;
            }
            int n5 = 0;
            while (n5 < this.numberOfBindPositions) {
                int n6 = this.bindIndicatorSubRange + 3 + 10 * n5;
                int n7 = this.bindIndicators[n6 + 2] & 0xFFFF;
                if (n7 != 0) {
                    int n8 = this.bindIndicators[n6 + 9] & 0xFFFF;
                    n4 = n8 == 2 ? Math.max(n7 * this.connection.conversion.maxNCharSize, n4) : Math.max(n7 * this.connection.conversion.cMaxCharSize, n4);
                }
                ++n5;
            }
            if (this.tmpBindsByteArray == null) {
                this.tmpBindsByteArray = new byte[n4];
            } else if (this.tmpBindsByteArray.length < n4) {
                this.tmpBindsByteArray = null;
                this.tmpBindsByteArray = new byte[n4];
            }
        } else {
            this.tmpBindsByteArray = null;
        }
        this.allocateTmpByteArray();
        T4C8Oall t4C8Oall = this.t4Connection.all8;
        this.t4Connection.sendPiggyBackedMessages();
        this.oacdefSent = t4C8Oall.marshal(bl2, bl3, bl4, bl5, this.sqlKind, this.cursorId, this.sqlObject.getSqlBytes(this.processEscapes, this.convertNcharLiterals), this.rowPrefetch, this.outBindAccessors, this.numberOfBindPositions, this.accessors, n3, this.bindBytes, this.bindChars, this.bindIndicators, this.bindIndicatorSubRange, this.connection.conversion, this.tmpBindsByteArray, this.parameterStream, this.parameterDatum, this.parameterOtype, this, this.ibtBindBytes, this.ibtBindChars, this.ibtBindIndicators, this.oacdefSent, this.definedColumnType, this.definedColumnSize, this.definedColumnFormOfUse);
        try {
            t4C8Oall.receive();
            this.cursorId = t4C8Oall.getCursorId();
        }
        catch (SQLException sQLException) {
            this.cursorId = t4C8Oall.getCursorId();
            if (sQLException.getErrorCode() == DatabaseError.getVendorCode(110)) {
                this.sqlWarning = DatabaseError.addSqlWarning(this.sqlWarning, 110);
            }
            throw sQLException;
        }
    }

    void executeForDescribe() throws SQLException {
        this.t4Connection.assertLoggedOn("oracle.jdbc.driver.T4CCallableStatement.execute_for_describe");
        this.cleanOldTempLobs();
        try {
            try {
                if (this.t4Connection.useFetchSizeWithLongColumn) {
                    this.doOall8(true, true, true, true);
                } else {
                    this.doOall8(true, true, false, true);
                }
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
            catch (IOException iOException) {
                ((T4CConnection)this.connection).handleIOException(iOException);
                DatabaseError.throwSqlException(iOException);
            }
            Object var2_3 = null;
            this.rowsProcessed = this.t4Connection.all8.rowsProcessed;
            this.validRows = this.t4Connection.all8.getNumRows();
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            this.rowsProcessed = this.t4Connection.all8.rowsProcessed;
            this.validRows = this.t4Connection.all8.getNumRows();
            throw throwable;
        }
        this.needToParse = false;
        int n2 = 0;
        while (n2 < this.numberOfDefinePositions) {
            this.accessors[n2].initMetadata();
            ++n2;
        }
        this.needToPrepareDefineBuffer = false;
    }

    void executeForRows(boolean bl2) throws SQLException {
        try {
            try {
                this.doOall8(this.needToParse, bl2 ^ true, true, false);
                this.needToParse = false;
            }
            finally {
                Object var3_2 = null;
                this.validRows = this.t4Connection.all8.getNumRows();
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (IOException iOException) {
            ((T4CConnection)this.connection).handleIOException(iOException);
            DatabaseError.throwSqlException(iOException);
        }
    }

    void executeMaybeDescribe() throws SQLException {
        if (!this.t4Connection.useFetchSizeWithLongColumn) {
            super.executeMaybeDescribe();
        } else {
            if (this.rowPrefetchChanged) {
                if (this.streamList == null && this.rowPrefetch != this.definesBatchSize) {
                    this.needToPrepareDefineBuffer = true;
                }
                this.rowPrefetchChanged = false;
            }
            if (!this.needToPrepareDefineBuffer) {
                if (this.accessors == null) {
                    this.needToPrepareDefineBuffer = true;
                } else if (this.columnsDefinedByUser) {
                    this.needToPrepareDefineBuffer = this.checkAccessorsUsable() ^ true;
                }
            }
            boolean bl2 = false;
            try {
                try {
                    this.isExecuting = true;
                    if (this.needToPrepareDefineBuffer) {
                        this.executeForDescribe();
                        bl2 = true;
                    } else {
                        int n2 = this.accessors.length;
                        int n3 = this.numberOfDefinePositions;
                        while (n3 < n2) {
                            Accessor accessor = this.accessors[n3];
                            if (accessor != null) {
                                accessor.rowSpaceIndicator = null;
                            }
                            ++n3;
                        }
                        this.executeForRows(bl2);
                    }
                }
                catch (SQLException sQLException) {
                    this.needToParse = true;
                    throw sQLException;
                }
                Object var3_6 = null;
                this.isExecuting = false;
            }
            catch (Throwable throwable) {
                Object var3_7 = null;
                this.isExecuting = false;
                throw throwable;
            }
        }
    }

    void fetch() throws SQLException {
        if (this.streamList != null) {
            while (this.nextStream != null) {
                try {
                    this.nextStream.close();
                }
                catch (IOException iOException) {
                    ((T4CConnection)this.connection).handleIOException(iOException);
                    DatabaseError.throwSqlException(iOException);
                }
                this.nextStream = this.nextStream.nextStream;
            }
        }
        try {
            this.doOall8(false, false, true, false);
            this.validRows = this.t4Connection.all8.getNumRows();
        }
        catch (IOException iOException) {
            ((T4CConnection)this.connection).handleIOException(iOException);
            DatabaseError.throwSqlException(iOException);
        }
    }

    void reparseOnRedefineIfNeeded() throws SQLException {
        this.needToParse = true;
    }

    void saveDefineBuffersIfRequired(char[] cArray, byte[] byArray, short[] sArray, boolean bl2) throws SQLException {
        int n2;
        if (bl2) {
            sArray = new short[this.defineIndicators.length];
            n2 = this.accessors[0].lengthIndexLastRow;
            int n3 = this.accessors[0].indicatorIndexLastRow;
            int n4 = 1;
            while (n4 <= this.accessors.length) {
                int n5 = n2 + this.saved_rowPrefetch * n4 - 1;
                int n6 = n3 + this.saved_rowPrefetch * n4 - 1;
                sArray[n6] = this.defineIndicators[n6];
                sArray[n5] = this.defineIndicators[n5];
                ++n4;
            }
        }
        n2 = 0;
        while (n2 < this.accessors.length) {
            this.accessors[n2].saveDataFromOldDefineBuffers(byArray, cArray, sArray, this.saved_rowPrefetch != -1 ? this.saved_rowPrefetch : this.rowPrefetch, this.rowPrefetch);
            ++n2;
        }
    }
}

