/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.AutoKeyInfo;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.Namespace;
import oracle.jdbc.driver.OracleBlobInputStream;
import oracle.jdbc.driver.OracleBlobOutputStream;
import oracle.jdbc.driver.OracleClobInputStream;
import oracle.jdbc.driver.OracleClobOutputStream;
import oracle.jdbc.driver.OracleClobReader;
import oracle.jdbc.driver.OracleClobWriter;
import oracle.jdbc.driver.OracleConversionInputStream;
import oracle.jdbc.driver.OracleConversionReader;
import oracle.jdbc.driver.OracleDriverExtension;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.T4C7Ocommoncall;
import oracle.jdbc.driver.T4C7Oversion;
import oracle.jdbc.driver.T4C8Oall;
import oracle.jdbc.driver.T4C8Oclose;
import oracle.jdbc.driver.T4C8Odscrarr;
import oracle.jdbc.driver.T4C8TTIBfile;
import oracle.jdbc.driver.T4C8TTIBlob;
import oracle.jdbc.driver.T4C8TTIClob;
import oracle.jdbc.driver.T4C8TTIdty;
import oracle.jdbc.driver.T4C8TTIpro;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CStatement;
import oracle.jdbc.driver.T4CTTIOtxen;
import oracle.jdbc.driver.T4CTTIOtxse;
import oracle.jdbc.driver.T4CTTIk2rpc;
import oracle.jdbc.driver.T4CTTIoauthenticate;
import oracle.jdbc.driver.T4CTTIoer;
import oracle.jdbc.driver.T4CTTIokeyval;
import oracle.jdbc.driver.T4CTTIoscid;
import oracle.jdbc.driver.T4CTTIoses;
import oracle.jdbc.driver.T4CTTIrxd;
import oracle.jdbc.driver.T4CTTIsto;
import oracle.jdbc.driver.T4CXAResource;
import oracle.jdbc.pool.OraclePooledConnection;
import oracle.net.ns.Communication;
import oracle.net.ns.NSProtocol;
import oracle.net.ns.NetException;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.BfileDBAccess;
import oracle.sql.BlobDBAccess;
import oracle.sql.CLOB;
import oracle.sql.ClobDBAccess;
import oracle.sql.LobPlsqlUtil;

class T4CConnection
extends PhysicalConnection
implements BfileDBAccess,
BlobDBAccess,
ClobDBAccess {
    static final short MIN_OVERSION_SUPPORTED = 7230;
    static final short MIN_TTCVER_SUPPORTED = 4;
    static final short V8_TTCVER_SUPPORTED = 5;
    static final short MAX_TTCVER_SUPPORTED = 6;
    static final int DEFAULT_LONG_PREFETCH_SIZE = 4080;
    static final String DEFAULT_CONNECT_STRING = "localhost:1521:orcl";
    static final int STREAM_CHUNK_SIZE = 255;
    static final int REFCURSOR_SIZE = 5;
    long LOGON_MODE = 0L;
    static final long SYSDBA = 8L;
    static final long SYSOPER = 16L;
    boolean isLoggedOn;
    private String password;
    Communication net;
    boolean readAsNonStream;
    T4CTTIoer oer;
    T4CMAREngine mare;
    T4C8TTIpro pro;
    T4C8TTIdty dty;
    T4CTTIrxd rxd;
    T4CTTIsto sto;
    T4CTTIoauthenticate auth;
    T4C7Oversion ver;
    T4C8Odscrarr describe;
    T4C8Oall all8;
    T4C8Oclose close8;
    T4C7Ocommoncall commoncall;
    T4C8TTIBfile bfileMsg;
    T4C8TTIBlob blobMsg;
    T4C8TTIClob clobMsg;
    T4CTTIoses oses;
    byte[] EMPTY_BYTE = new byte[0];
    T4CTTIOtxen otxen;
    T4CTTIOtxse otxse;
    T4CTTIk2rpc k2rpc;
    T4CTTIoscid oscid;
    T4CTTIokeyval okeyval;
    int[] cursorToClose;
    int cursorToCloseOffset;
    int[] queryToClose;
    int queryToCloseOffset;
    int sessionId;
    int serialNumber;
    boolean retainV9BehaviorForLong;
    Hashtable namespaces;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Jun_22_11:15:45_PDT_2005";

    T4CConnection(String string, String string2, String string3, String string4, Properties properties, OracleDriverExtension oracleDriverExtension) throws SQLException {
        super(string, string2, string3, string4, properties, oracleDriverExtension);
        String string5 = (String)((Hashtable)properties).get("oracle.jdbc.RetainV9LongBindBehavior");
        this.retainV9BehaviorForLong = string5 != null && string5.equalsIgnoreCase("true");
        this.cursorToClose = new int[4];
        this.cursorToCloseOffset = 0;
        this.queryToClose = new int[10];
        this.queryToCloseOffset = 0;
        this.minVcsBindSize = 0;
        this.streamChunkSize = 255;
        this.namespaces = new Hashtable(5);
    }

    OracleStatement RefCursorBytesToStatement(byte[] byArray, OracleStatement oracleStatement) throws SQLException {
        T4CStatement t4CStatement = new T4CStatement(this, -1, -1);
        try {
            int n2 = this.mare.unmarshalRefCursor(byArray);
            t4CStatement.setCursorId(n2);
            t4CStatement.isOpen = true;
            t4CStatement.sqlObject = oracleStatement.sqlObject;
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            DatabaseError.throwSqlException(iOException);
        }
        t4CStatement.sqlStringChanged = false;
        t4CStatement.needToParse = false;
        return t4CStatement;
    }

    void assertLoggedOn(String string) throws SQLException {
        if (!this.isLoggedOn) {
            DatabaseError.throwSqlException(430);
        }
    }

    void assertNotNull(byte[] byArray, String string) throws NullPointerException {
        if (byArray == null) {
            throw new NullPointerException("bytes are null");
        }
    }

    public synchronized void close(BFILE bFILE) throws SQLException {
        this.assertLoggedOn("close");
        this.assertNotNull(bFILE.shareBytes(), "close");
        this.needLine();
        try {
            this.bfileMsg.close(bFILE.shareBytes());
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            DatabaseError.throwSqlException(iOException);
        }
    }

    public synchronized void close(BLOB bLOB) throws SQLException {
        this.assertLoggedOn("close");
        this.assertNotNull(bLOB.shareBytes(), "close");
        this.needLine();
        try {
            this.blobMsg.close(bLOB.shareBytes());
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            DatabaseError.throwSqlException(iOException);
        }
    }

    public synchronized void close(CLOB cLOB) throws SQLException {
        this.assertLoggedOn("close");
        this.assertNotNull(cLOB.shareBytes(), "close");
        this.needLine();
        try {
            this.clobMsg.close(cLOB.shareBytes());
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            DatabaseError.throwSqlException(iOException);
        }
    }

    public synchronized void closeFile(BFILE bFILE) throws SQLException {
        this.assertLoggedOn("closeFile");
        this.assertNotNull(bFILE.shareBytes(), "closeFile");
        this.needLine();
        try {
            this.bfileMsg.close(bFILE.shareBytes());
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            DatabaseError.throwSqlException(iOException);
        }
    }

    void closeProxySession() throws SQLException {
        try {
            this.sendPiggyBackedMessages();
            this.commoncall.init((short)9);
            this.commoncall.marshal();
            this.commoncall.receive();
            this.oses.marshal(this.sessionId, this.serialNumber, 1);
            this.user = this.savedUser;
        }
        catch (IOException iOException) {
            DatabaseError.throwSqlException(iOException);
        }
    }

    void connect(String string, Properties properties) throws IOException, SQLException {
        if (string == null || properties == null) {
            DatabaseError.throwSqlException(433);
        }
        this.net = new NSProtocol();
        try {
            this.net.connect(string, properties);
        }
        catch (NetException netException) {
            throw new IOException(netException.getMessage());
        }
        this.mare = new T4CMAREngine(this.net);
        this.oer = new T4CTTIoer(this.mare, this);
        this.pro = new T4C8TTIpro(this.mare);
        this.pro.marshal();
        this.pro.receive();
        short s2 = this.pro.getOracleVersion();
        short s3 = this.pro.getCharacterSet();
        short s4 = DBConversion.findDriverCharSet(s3, s2);
        this.conversion = new DBConversion(s3, s4, this.pro.getncharCHARSET());
        this.mare.types.setServerConversion(s4 != s3);
        this.mare.types.setVersion(s2);
        if (DBConversion.isCharSetMultibyte(s4)) {
            if (DBConversion.isCharSetMultibyte(this.pro.getCharacterSet())) {
                this.mare.types.setFlags((byte)1);
            } else {
                this.mare.types.setFlags((byte)2);
            }
        } else {
            this.mare.types.setFlags(this.pro.getFlags());
        }
        this.mare.conv = this.conversion;
    }

    public synchronized BfileDBAccess createBfileDBAccess() throws SQLException {
        return this;
    }

    public synchronized BlobDBAccess createBlobDBAccess() throws SQLException {
        return this;
    }

    public synchronized ClobDBAccess createClobDBAccess() throws SQLException {
        return this;
    }

    public synchronized BLOB createTemporaryBlob(Connection connection, boolean bl2, int n2) throws SQLException {
        this.assertLoggedOn("createTemporaryBlob");
        this.needLine();
        BLOB bLOB = null;
        try {
            bLOB = (BLOB)this.blobMsg.createTemporaryLob(this, bl2, n2);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            DatabaseError.throwSqlException(iOException);
        }
        return bLOB;
    }

    public synchronized CLOB createTemporaryClob(Connection connection, boolean bl2, int n2, short s2) throws SQLException {
        this.assertLoggedOn("createTemporaryClob");
        this.needLine();
        CLOB cLOB = null;
        try {
            cLOB = (CLOB)this.clobMsg.createTemporaryLob(this, bl2, n2, s2);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            DatabaseError.throwSqlException(iOException);
        }
        return cLOB;
    }

    void doAbort() throws SQLException {
        try {
            this.net.abort();
        }
        catch (NetException netException) {
            DatabaseError.throwSqlException(netException);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            DatabaseError.throwSqlException(iOException);
        }
    }

    void doCancel() throws SQLException {
        try {
            this.net.sendBreak();
        }
        catch (NetException netException) {
            DatabaseError.throwSqlException(netException);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            DatabaseError.throwSqlException(iOException);
        }
    }

    void doClearAllApplicationContext(String string) throws SQLException {
        Namespace namespace = new Namespace(string);
        namespace.clear();
        this.namespaces.put(string, namespace);
    }

    synchronized void doCommit() throws SQLException {
        try {
            this.assertLoggedOn("T4CConnection.do_commit");
            this.sendPiggyBackedMessages();
            this.commoncall.init((short)14);
            this.commoncall.marshal();
            this.commoncall.receive();
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            DatabaseError.throwSqlException(iOException);
        }
    }

    protected void doDescribeTable(AutoKeyInfo autoKeyInfo) throws SQLException {
        T4CStatement t4CStatement = new T4CStatement(this, -1, -1);
        t4CStatement.open();
        String string = autoKeyInfo.getTableName();
        String string2 = "SELECT * FROM " + string;
        t4CStatement.sqlObject.initialize(string2);
        Accessor[] accessorArray = null;
        try {
            this.describe.init(t4CStatement, 0);
            this.describe.sqltext = t4CStatement.sqlObject.getSqlBytes(false, false);
            this.describe.marshal();
            accessorArray = this.describe.receive(accessorArray);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            DatabaseError.throwSqlException(iOException);
        }
        int n2 = this.describe.numuds;
        autoKeyInfo.allocateSpaceForDescribedData(n2);
        int n3 = 0;
        while (n3 < n2) {
            Accessor accessor = accessorArray[n3];
            String string3 = accessor.columnName;
            int n4 = accessor.describeType;
            int n5 = accessor.describeMaxLength;
            boolean bl2 = accessor.nullable;
            short s2 = accessor.formOfUse;
            int n6 = accessor.precision;
            int n7 = accessor.scale;
            String string4 = accessor.describeTypeName;
            autoKeyInfo.fillDescribedData(n3, string3, n4, n5, bl2, s2, n6, n7, string4);
            ++n3;
        }
        t4CStatement.close();
    }

    synchronized String doGetDatabaseProductVersion() throws SQLException {
        this.assertLoggedOn("T4CConnection.do_getDatabaseProductVersion");
        String string = null;
        byte[] byArray = this.ver.getVersion();
        try {
            string = new String(byArray, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            DatabaseError.throwSqlException(unsupportedEncodingException);
        }
        return string;
    }

    synchronized short doGetVersionNumber() throws SQLException {
        this.assertLoggedOn("T4CConnection.do_getVersionNumber");
        short s2 = this.ver.getVersionNumber();
        return s2;
    }

    void doProxySession(int n2, Properties properties) throws SQLException {
        try {
            this.sendPiggyBackedMessages();
            this.auth.marshalOauth(n2, properties, this.sessionId, this.serialNumber);
            this.auth.receiveOauth();
            int n3 = this.auth.getSessionId();
            int n4 = this.auth.getSerialNumber();
            this.oses.marshal(n3, n4, 1);
            this.savedUser = this.user;
            this.user = n2 == 1 ? properties.getProperty("PROXY_USER_NAME") : null;
            this.isProxy = true;
        }
        catch (IOException iOException) {
            DatabaseError.throwSqlException(iOException);
        }
    }

    synchronized void doRollback() throws SQLException {
        try {
            this.assertLoggedOn("T4CConnection.do_rollback");
            this.sendPiggyBackedMessages();
            this.commoncall.init((short)15);
            this.commoncall.marshal();
            this.commoncall.receive();
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            DatabaseError.throwSqlException(iOException);
        }
    }

    void doSetApplicationContext(String string, String string2, String string3) throws SQLException {
        Namespace namespace = (Namespace)this.namespaces.get(string);
        if (namespace == null) {
            namespace = new Namespace(string);
            this.namespaces.put(string, namespace);
        }
        namespace.setAttribute(string2, string3);
    }

    synchronized void doSetAutoCommit(boolean bl2) throws SQLException {
    }

    public synchronized boolean fileExists(BFILE bFILE) throws SQLException {
        this.assertLoggedOn("fileExists");
        this.assertNotNull(bFILE.shareBytes(), "fileExists");
        this.needLine();
        boolean bl2 = false;
        try {
            bl2 = this.bfileMsg.doesExist(bFILE.shareBytes());
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            DatabaseError.throwSqlException(iOException);
        }
        return bl2;
    }

    public synchronized void freeTemporary(BLOB bLOB) throws SQLException {
        this.assertLoggedOn("freeTemporary");
        this.assertNotNull(bLOB.shareBytes(), "freeTemporary");
        this.needLine();
        try {
            this.blobMsg.freeTemporaryLob(bLOB.shareBytes());
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            DatabaseError.throwSqlException(iOException);
        }
    }

    public synchronized void freeTemporary(CLOB cLOB) throws SQLException {
        this.assertLoggedOn("freeTemporary");
        this.assertNotNull(cLOB.shareBytes(), "freeTemporary");
        this.needLine();
        try {
            this.clobMsg.freeTemporaryLob(cLOB.shareBytes());
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            DatabaseError.throwSqlException(iOException);
        }
    }

    public synchronized int getBytes(BFILE bFILE, long l2, int n2, byte[] byArray) throws SQLException {
        long l3;
        block4: {
            this.assertLoggedOn("getBytes");
            if (l2 < 1L) {
                DatabaseError.throwSqlException(68, "getBytes()");
            }
            if (n2 <= 0 || byArray == null) {
                return 0;
            }
            this.needLine();
            l3 = 0L;
            if (n2 == 0) break block4;
            try {
                l3 = this.bfileMsg.read(bFILE.shareBytes(), l2, n2, byArray);
            }
            catch (IOException iOException) {
                this.handleIOException(iOException);
                DatabaseError.throwSqlException(iOException);
            }
        }
        return (int)l3;
    }

    public synchronized int getBytes(BLOB bLOB, long l2, int n2, byte[] byArray) throws SQLException {
        long l3;
        block4: {
            this.assertLoggedOn("getBytes");
            this.assertNotNull(bLOB.shareBytes(), "getBytes");
            if (l2 < 1L) {
                DatabaseError.throwSqlException(68, "getBytes()");
            }
            if (n2 <= 0 || byArray == null) {
                return 0;
            }
            this.needLine();
            l3 = 0L;
            if (n2 == 0) break block4;
            try {
                l3 = this.blobMsg.read(bLOB.shareBytes(), l2, n2, byArray);
            }
            catch (IOException iOException) {
                this.handleIOException(iOException);
                DatabaseError.throwSqlException(iOException);
            }
        }
        return (int)l3;
    }

    public synchronized int getChars(CLOB cLOB, long l2, int n2, char[] cArray) throws SQLException {
        long l3;
        block4: {
            this.assertLoggedOn("getChars");
            this.assertNotNull(cLOB.shareBytes(), "getChars");
            if (l2 < 1L) {
                DatabaseError.throwSqlException(68, "getChars()");
            }
            if (n2 <= 0 || cArray == null) {
                return 0;
            }
            this.needLine();
            l3 = 0L;
            if (n2 == 0) break block4;
            try {
                boolean bl2 = cLOB.isNCLOB();
                l3 = this.clobMsg.read(cLOB.shareBytes(), l2, n2, bl2, cArray);
            }
            catch (IOException iOException) {
                this.handleIOException(iOException);
                DatabaseError.throwSqlException(iOException);
            }
        }
        return (int)l3;
    }

    public synchronized int getChunkSize(BLOB bLOB) throws SQLException {
        this.assertLoggedOn("getChunkSize");
        this.assertNotNull(bLOB.shareBytes(), "getChunkSize");
        this.needLine();
        long l2 = 0L;
        try {
            l2 = this.blobMsg.getChunkSize(bLOB.shareBytes());
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            DatabaseError.throwSqlException(iOException);
        }
        return (int)l2;
    }

    public synchronized int getChunkSize(CLOB cLOB) throws SQLException {
        this.assertLoggedOn("getChunkSize");
        this.assertNotNull(cLOB.shareBytes(), "getChunkSize");
        this.needLine();
        long l2 = 0L;
        try {
            l2 = this.clobMsg.getChunkSize(cLOB.shareBytes());
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            DatabaseError.throwSqlException(iOException);
        }
        return (int)l2;
    }

    public String getDirAlias(BFILE bFILE) throws SQLException {
        this.assertLoggedOn("getDirAlias");
        this.assertNotNull(bFILE.shareBytes(), "getDirAlias");
        String string = LobPlsqlUtil.fileGetDirAlias(bFILE);
        return string;
    }

    public String getName(BFILE bFILE) throws SQLException {
        this.assertLoggedOn("getName");
        this.assertNotNull(bFILE.shareBytes(), "getName");
        String string = LobPlsqlUtil.fileGetName(bFILE);
        return string;
    }

    final void getPasswordInternal(T4CXAResource t4CXAResource) throws SQLException {
        t4CXAResource.setPasswordInternal(this.password);
    }

    public void getPropertyForPooledConnection(OraclePooledConnection oraclePooledConnection) throws SQLException {
        super.getPropertyForPooledConnection(oraclePooledConnection, this.password);
    }

    public Properties getServerSessionInfo() throws SQLException {
        Properties properties = new Properties();
        properties.setProperty("SERVER_HOST", this.auth.connectionValues.getProperty("AUTH_SC_SERVER_HOST", ""));
        properties.setProperty("INSTANCE_NAME", this.auth.connectionValues.getProperty("AUTH_SC_INSTANCE_NAME", ""));
        properties.setProperty("DATABASE_NAME", this.auth.connectionValues.getProperty("AUTH_SC_DBUNIQUE_NAME", ""));
        properties.setProperty("SERVICE_NAME", this.auth.connectionValues.getProperty("AUTH_SC_SERVICE_NAME", ""));
        return properties;
    }

    void handleIOException(IOException iOException) throws SQLException {
        try {
            this.net.disconnect();
        }
        catch (Exception exception) {}
        this.isLoggedOn = false;
        this.lifecycle = 4;
    }

    final void initializePassword(String string) throws SQLException {
        this.password = string;
    }

    void internalClose() throws SQLException {
        super.internalClose();
        this.isLoggedOn = false;
    }

    public synchronized boolean isFileOpen(BFILE bFILE) throws SQLException {
        this.assertLoggedOn("openFile");
        this.assertNotNull(bFILE.shareBytes(), "openFile");
        this.needLine();
        boolean bl2 = false;
        try {
            bl2 = this.bfileMsg.isOpen(bFILE.shareBytes());
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            DatabaseError.throwSqlException(iOException);
        }
        return bl2;
    }

    public synchronized boolean isOpen(BFILE bFILE) throws SQLException {
        this.assertLoggedOn("isOpen");
        this.assertNotNull(bFILE.shareBytes(), "isOpen");
        this.needLine();
        boolean bl2 = false;
        try {
            bl2 = this.bfileMsg.isOpen(bFILE.shareBytes());
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            DatabaseError.throwSqlException(iOException);
        }
        return bl2;
    }

    public synchronized boolean isOpen(BLOB bLOB) throws SQLException {
        this.assertLoggedOn("isOpen");
        this.assertNotNull(bLOB.shareBytes(), "isOpen");
        this.needLine();
        boolean bl2 = false;
        try {
            bl2 = this.blobMsg.isOpen(bLOB.shareBytes());
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            DatabaseError.throwSqlException(iOException);
        }
        return bl2;
    }

    public synchronized boolean isOpen(CLOB cLOB) throws SQLException {
        this.assertLoggedOn("isOpen");
        this.assertNotNull(cLOB.shareBytes(), "isOpen");
        boolean bl2 = false;
        this.needLine();
        try {
            bl2 = this.clobMsg.isOpen(cLOB.shareBytes());
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            DatabaseError.throwSqlException(iOException);
        }
        return bl2;
    }

    public boolean isTemporary(BLOB bLOB) throws SQLException {
        boolean bl2 = false;
        byte[] byArray = bLOB.shareBytes();
        if ((byArray[7] & 1) > 0 || (byArray[4] & 0x40) > 0) {
            bl2 = true;
        }
        return bl2;
    }

    public boolean isTemporary(CLOB cLOB) throws SQLException {
        boolean bl2 = false;
        byte[] byArray = cLOB.shareBytes();
        if ((byArray[7] & 1) > 0 || (byArray[4] & 0x40) > 0) {
            bl2 = true;
        }
        return bl2;
    }

    public synchronized long length(BFILE bFILE) throws SQLException {
        this.assertLoggedOn("length");
        this.assertNotNull(bFILE.shareBytes(), "length");
        this.needLine();
        long l2 = 0L;
        try {
            l2 = this.bfileMsg.getLength(bFILE.shareBytes());
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            DatabaseError.throwSqlException(iOException);
        }
        return l2;
    }

    public synchronized long length(BLOB bLOB) throws SQLException {
        this.assertLoggedOn("length");
        this.assertNotNull(bLOB.shareBytes(), "length");
        this.needLine();
        long l2 = 0L;
        try {
            l2 = this.blobMsg.getLength(bLOB.shareBytes());
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            DatabaseError.throwSqlException(iOException);
        }
        return l2;
    }

    public synchronized long length(CLOB cLOB) throws SQLException {
        this.assertLoggedOn("length");
        this.assertNotNull(cLOB.shareBytes(), "length");
        this.needLine();
        long l2 = 0L;
        try {
            l2 = this.clobMsg.getLength(cLOB.shareBytes());
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            DatabaseError.throwSqlException(iOException);
        }
        return l2;
    }

    synchronized void logoff() throws SQLException {
        try {
            try {
                this.assertLoggedOn("T4CConnection.logoff");
                if (this.lifecycle == 8) {
                    Object var2_1 = null;
                    this.isLoggedOn = false;
                    return;
                }
                this.sendPiggyBackedMessages();
                this.commoncall.init((short)9);
                this.commoncall.marshal();
                this.commoncall.receive();
                this.net.disconnect();
            }
            catch (IOException iOException) {
                this.handleIOException(iOException);
                if (this.lifecycle != 8) {
                    DatabaseError.throwSqlException(iOException);
                }
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.isLoggedOn = false;
            throw throwable;
        }
        Object var2_2 = null;
        this.isLoggedOn = false;
    }

    void logon() throws SQLException {
        try {
            if (this.isLoggedOn) {
                DatabaseError.throwSqlException(428);
            }
            if (this.user == null || this.password == null) {
                DatabaseError.throwSqlException(433);
            }
            if (this.user.length() == 0 || this.password.length() == 0) {
                DatabaseError.throwSqlException(443);
            }
            if (this.database == null) {
                this.database = DEFAULT_CONNECT_STRING;
            }
            this.connect(this.database, this.connectionProperties);
            this.all8 = new T4C8Oall(this.mare, this, this.oer);
            this.close8 = new T4C8Oclose(this.mare);
            this.sto = new T4CTTIsto(this.mare, this.oer);
            this.commoncall = new T4C7Ocommoncall(this.mare, this.oer, this);
            this.describe = new T4C8Odscrarr(this.mare, this.oer);
            this.bfileMsg = new T4C8TTIBfile(this.mare, this.oer);
            this.blobMsg = new T4C8TTIBlob(this.mare, this.oer);
            this.clobMsg = new T4C8TTIClob(this.mare, this.oer);
            this.otxen = new T4CTTIOtxen(this.mare, this.oer, this);
            this.otxse = new T4CTTIOtxse(this.mare, this.oer, this);
            this.k2rpc = new T4CTTIk2rpc(this.mare, this.oer, this);
            this.oses = new T4CTTIoses(this.mare);
            this.okeyval = new T4CTTIokeyval(this.mare);
            this.oscid = new T4CTTIoscid(this.mare);
            this.dty = new T4C8TTIdty(this.mare);
            this.dty.marshal();
            this.dty.receive();
            this.ver = new T4C7Oversion(this.mare, this.oer, this);
            this.ver.marshal();
            this.ver.receive();
            this.mare.versionNumber = this.versionNumber = this.ver.getVersionNumber();
            if (this.versionNumber < 7230) {
                DatabaseError.throwSqlException(441);
            }
            this.mare.types.setVersion(this.versionNumber);
            String string = (String)((Hashtable)this.connectionProperties).get("internal_logon");
            if (string != null) {
                if (string.equalsIgnoreCase("sysoper")) {
                    this.LOGON_MODE = 64L;
                } else if (string.equalsIgnoreCase("sysdba")) {
                    this.LOGON_MODE = 32L;
                }
            } else {
                this.LOGON_MODE = 0L;
            }
            this.auth = new T4CTTIoauthenticate(this.mare, this.user, this.password, this.connectionProperties, this.LOGON_MODE, this.ressourceManagerId, this.oer, this);
            this.auth.marshalOsesskey();
            this.auth.receiveOsesskey();
            this.auth.marshalOauth();
            this.auth.receiveOauth();
            this.sessionId = this.auth.getSessionId();
            this.serialNumber = this.auth.getSerialNumber();
            this.isLoggedOn = true;
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            DatabaseError.throwSqlException(iOException);
        }
        catch (SQLException sQLException) {
            try {
                this.net.disconnect();
            }
            catch (Exception exception) {}
            this.isLoggedOn = false;
            throw sQLException;
        }
    }

    public InputStream newConversionInputStream(BFILE bFILE, int n2) throws SQLException {
        this.assertNotNull(bFILE.shareBytes(), "newConversionInputStream");
        OracleConversionInputStream oracleConversionInputStream = new OracleConversionInputStream(this.conversion, bFILE.getBinaryStream(), n2);
        return oracleConversionInputStream;
    }

    public InputStream newConversionInputStream(BLOB bLOB, int n2) throws SQLException {
        this.assertNotNull(bLOB.shareBytes(), "newConversionInputStream");
        OracleConversionInputStream oracleConversionInputStream = new OracleConversionInputStream(this.conversion, bLOB.getBinaryStream(), n2);
        return oracleConversionInputStream;
    }

    public Reader newConversionReader(BFILE bFILE, int n2) throws SQLException {
        this.assertNotNull(bFILE.shareBytes(), "newConversionReader");
        OracleConversionReader oracleConversionReader = new OracleConversionReader(this.conversion, bFILE.getBinaryStream(), n2);
        return oracleConversionReader;
    }

    public Reader newConversionReader(BLOB bLOB, int n2) throws SQLException {
        this.assertNotNull(bLOB.shareBytes(), "newConversionReader");
        OracleConversionReader oracleConversionReader = new OracleConversionReader(this.conversion, bLOB.getBinaryStream(), n2);
        return oracleConversionReader;
    }

    public InputStream newInputStream(BFILE bFILE, int n2, long l2) throws SQLException {
        if (l2 == 0L) {
            return new OracleBlobInputStream(bFILE, n2);
        }
        return new OracleBlobInputStream(bFILE, n2, l2);
    }

    public InputStream newInputStream(BLOB bLOB, int n2, long l2) throws SQLException {
        if (l2 == 0L) {
            return new OracleBlobInputStream(bLOB, n2);
        }
        return new OracleBlobInputStream(bLOB, n2, l2);
    }

    public InputStream newInputStream(CLOB cLOB, int n2, long l2) throws SQLException {
        if (l2 == 0L) {
            return new OracleClobInputStream(cLOB, n2);
        }
        return new OracleClobInputStream(cLOB, n2, l2);
    }

    public OutputStream newOutputStream(BLOB bLOB, int n2, long l2) throws SQLException {
        if (l2 == 0L) {
            return new OracleBlobOutputStream(bLOB, n2);
        }
        return new OracleBlobOutputStream(bLOB, n2, l2);
    }

    public OutputStream newOutputStream(CLOB cLOB, int n2, long l2) throws SQLException {
        if (l2 == 0L) {
            return new OracleClobOutputStream(cLOB, n2);
        }
        return new OracleClobOutputStream(cLOB, n2, l2);
    }

    public Reader newReader(CLOB cLOB, int n2, long l2) throws SQLException {
        if (l2 == 0L) {
            return new OracleClobReader(cLOB, n2);
        }
        return new OracleClobReader(cLOB, n2, l2);
    }

    public Writer newWriter(CLOB cLOB, int n2, long l2) throws SQLException {
        if (l2 == 0L) {
            return new OracleClobWriter(cLOB, n2);
        }
        return new OracleClobWriter(cLOB, n2, l2);
    }

    public synchronized void open(OracleStatement oracleStatement) throws SQLException {
        this.assertLoggedOn("T4CConnection.open");
        oracleStatement.setCursorId(0);
    }

    public synchronized void open(BFILE bFILE, int n2) throws SQLException {
        this.assertLoggedOn("open");
        this.assertNotNull(bFILE.shareBytes(), "open");
        this.needLine();
        try {
            this.bfileMsg.open(bFILE.shareBytes(), n2);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            DatabaseError.throwSqlException(iOException);
        }
    }

    public synchronized void open(BLOB bLOB, int n2) throws SQLException {
        this.assertLoggedOn("open");
        this.assertNotNull(bLOB.shareBytes(), "open");
        this.needLine();
        try {
            this.blobMsg.open(bLOB.shareBytes(), n2);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            DatabaseError.throwSqlException(iOException);
        }
    }

    public synchronized void open(CLOB cLOB, int n2) throws SQLException {
        this.assertLoggedOn("open");
        this.assertNotNull(cLOB.shareBytes(), "open");
        this.needLine();
        try {
            this.clobMsg.open(cLOB.shareBytes(), n2);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            DatabaseError.throwSqlException(iOException);
        }
    }

    public synchronized void openFile(BFILE bFILE) throws SQLException {
        this.assertLoggedOn("openFile");
        this.assertNotNull(bFILE.shareBytes(), "openFile");
        this.needLine();
        try {
            this.bfileMsg.open(bFILE.shareBytes(), 11);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            DatabaseError.throwSqlException(iOException);
        }
    }

    public long position(BFILE bFILE, BFILE bFILE2, long l2) throws SQLException {
        long l3;
        if (l2 < 1L) {
            DatabaseError.throwSqlException(68, "position()");
        }
        l3 = (l3 = LobPlsqlUtil.isSubLob(bFILE, bFILE2, l2)) == 0L ? -1L : l3;
        return l3;
    }

    public synchronized long position(BFILE bFILE, byte[] byArray, long l2) throws SQLException {
        long l3;
        if (l2 < 1L) {
            DatabaseError.throwSqlException(68, "position()");
        }
        l3 = (l3 = LobPlsqlUtil.hasPattern(bFILE, byArray, l2)) == 0L ? -1L : l3;
        return l3;
    }

    public long position(BLOB bLOB, BLOB bLOB2, long l2) throws SQLException {
        long l3;
        this.assertLoggedOn("position");
        this.assertNotNull(bLOB.shareBytes(), "position");
        this.assertNotNull(bLOB2.shareBytes(), "position");
        if (l2 < 1L) {
            DatabaseError.throwSqlException(68, "position()");
        }
        l3 = (l3 = LobPlsqlUtil.isSubLob(bLOB, bLOB2, l2)) == 0L ? -1L : l3;
        return l3;
    }

    public long position(BLOB bLOB, byte[] byArray, long l2) throws SQLException {
        long l3;
        this.assertLoggedOn("position");
        this.assertNotNull(bLOB.shareBytes(), "position");
        if (l2 < 1L) {
            DatabaseError.throwSqlException(68, "position()");
        }
        l3 = (l3 = LobPlsqlUtil.hasPattern(bLOB, byArray, l2)) == 0L ? -1L : l3;
        return l3;
    }

    public long position(CLOB cLOB, String string, long l2) throws SQLException {
        if (string == null) {
            DatabaseError.throwSqlException(68, "position()");
        }
        this.assertLoggedOn("position");
        this.assertNotNull(cLOB.shareBytes(), "position");
        if (l2 < 1L) {
            DatabaseError.throwSqlException(68, "position()");
        }
        char[] cArray = new char[string.length()];
        string.getChars(0, cArray.length, cArray, 0);
        long l3 = LobPlsqlUtil.hasPattern(cLOB, cArray, l2);
        l3 = l3 == 0L ? -1L : l3;
        return l3;
    }

    public long position(CLOB cLOB, CLOB cLOB2, long l2) throws SQLException {
        long l3;
        if (cLOB2 == null) {
            DatabaseError.throwSqlException(68, "position()");
        }
        this.assertLoggedOn("position");
        this.assertNotNull(cLOB.shareBytes(), "position");
        this.assertNotNull(cLOB2.shareBytes(), "position");
        if (l2 < 1L) {
            DatabaseError.throwSqlException(68, "position()");
        }
        l3 = (l3 = LobPlsqlUtil.isSubLob(cLOB, cLOB2, l2)) == 0L ? -1L : l3;
        return l3;
    }

    public synchronized int putBytes(BLOB bLOB, long l2, byte[] byArray, int n2, int n3) throws SQLException {
        long l3;
        block4: {
            this.assertLoggedOn("putBytes");
            this.assertNotNull(bLOB.shareBytes(), "putBytes");
            if (l2 < 1L) {
                DatabaseError.throwSqlException(68, "putBytes()");
            }
            if (byArray == null || n3 <= 0) {
                return 0;
            }
            this.needLine();
            l3 = 0L;
            if (n3 == 0) break block4;
            try {
                l3 = this.blobMsg.write(bLOB.shareBytes(), l2, byArray, n2, n3);
            }
            catch (IOException iOException) {
                this.handleIOException(iOException);
                DatabaseError.throwSqlException(iOException);
            }
        }
        return (int)l3;
    }

    public synchronized int putChars(CLOB cLOB, long l2, char[] cArray, int n2, int n3) throws SQLException {
        long l3;
        block4: {
            this.assertLoggedOn("putChars");
            this.assertNotNull(cLOB.shareBytes(), "putChars");
            if (l2 < 1L) {
                DatabaseError.throwSqlException(68, "putChars()");
            }
            if (cArray == null || n3 <= 0) {
                return 0;
            }
            this.needLine();
            l3 = 0L;
            if (n3 == 0) break block4;
            try {
                boolean bl2 = cLOB.isNCLOB();
                l3 = this.clobMsg.write(cLOB.shareBytes(), l2, bl2, cArray, n2, n3);
            }
            catch (IOException iOException) {
                this.handleIOException(iOException);
                DatabaseError.throwSqlException(iOException);
            }
        }
        return (int)l3;
    }

    private void sendPiggyBackedClose() throws SQLException, IOException {
        if (this.queryToCloseOffset > 0) {
            this.close8.initCloseQuery();
            this.close8.marshal(this.queryToClose, this.queryToCloseOffset);
            this.queryToCloseOffset = 0;
        }
        if (this.cursorToCloseOffset > 0) {
            this.close8.initCloseStatement();
            this.close8.marshal(this.cursorToClose, this.cursorToCloseOffset);
            this.cursorToCloseOffset = 0;
        }
    }

    void sendPiggyBackedMessages() throws SQLException, IOException {
        this.sendPiggyBackedClose();
        if (this.endToEndAnyChanged && this.versionNumber >= 10000) {
            this.oscid.marshal(this.endToEndHasChanged, this.endToEndValues, this.endToEndECIDSequenceNumber);
            int n2 = 0;
            while (n2 < 4) {
                if (this.endToEndHasChanged[n2]) {
                    this.endToEndHasChanged[n2] = false;
                }
                ++n2;
            }
        }
        this.endToEndAnyChanged = false;
        if (!this.namespaces.isEmpty()) {
            if (this.versionNumber >= 10200) {
                Object[] objectArray = this.namespaces.values().toArray();
                int n3 = 0;
                while (n3 < objectArray.length) {
                    this.okeyval.marshal((Namespace)objectArray[n3]);
                    ++n3;
                }
            }
            this.namespaces.clear();
        }
    }

    public synchronized void trim(BLOB bLOB, long l2) throws SQLException {
        this.assertLoggedOn("trim");
        this.assertNotNull(bLOB.shareBytes(), "trim");
        if (l2 < 0L) {
            DatabaseError.throwSqlException(68, "trim()");
        }
        this.needLine();
        try {
            this.blobMsg.trim(bLOB.shareBytes(), l2);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            DatabaseError.throwSqlException(iOException);
        }
    }

    public synchronized void trim(CLOB cLOB, long l2) throws SQLException {
        this.assertLoggedOn("trim");
        this.assertNotNull(cLOB.shareBytes(), "trim");
        if (l2 < 0L) {
            DatabaseError.throwSqlException(68, "trim()");
        }
        this.needLine();
        try {
            this.clobMsg.trim(cLOB.shareBytes(), l2);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            DatabaseError.throwSqlException(iOException);
        }
    }
}

