/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleInputStream;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.T4CConnection;

class T4CInputStream
extends OracleInputStream {
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Jun_22_11:15:45_PDT_2005";

    T4CInputStream(OracleStatement oracleStatement, int n2, Accessor accessor) {
        super(oracleStatement, n2, accessor);
    }

    public int getBytes() throws IOException {
        int n2 = 0;
        try {
            n2 = this.accessor.readStream(this.buf, this.chunkSize);
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getMessage());
        }
        catch (IOException iOException) {
            try {
                ((T4CConnection)this.statement.connection).handleIOException(iOException);
            }
            catch (SQLException sQLException) {}
            throw iOException;
        }
        return n2;
    }

    public boolean isNull() throws IOException {
        if (!this.statement.connection.useFetchSizeWithLongColumn) {
            return super.isNull();
        }
        boolean bl2 = false;
        try {
            int n2 = this.statement.currentRow;
            if (n2 < 0) {
                n2 = 0;
            }
            if (n2 >= this.statement.validRows) {
                return true;
            }
            bl2 = this.accessor.isNull(n2);
        }
        catch (SQLException sQLException) {
            DatabaseError.SQLToIOException(sQLException);
        }
        return bl2;
    }
}

