/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.Vector;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.T4CTypeRep;
import oracle.net.ns.BreakNetException;
import oracle.net.ns.Communication;
import oracle.net.ns.NetException;

class T4CMAREngine {
    static final int TTCC_MXL = 252;
    static final int TTCC_ESC = 253;
    static final int TTCC_LNG = 254;
    static final int TTCC_ERR = 255;
    static final int TTCC_MXIN = 64;
    static final byte TTCLXMULTI = 1;
    static final byte TTCLXMCONV = 2;
    T4CTypeRep types;
    Communication net;
    DBConversion conv;
    short versionNumber = (short)-1;
    byte proSvrVer;
    InputStream inStream;
    OutputStream outStream;
    final byte[] ignored = new byte[255];
    final byte[] tmpBuffer1 = new byte[1];
    final byte[] tmpBuffer2 = new byte[2];
    final byte[] tmpBuffer3 = new byte[3];
    final byte[] tmpBuffer4 = new byte[4];
    final byte[] tmpBuffer5 = new byte[5];
    final byte[] tmpBuffer6 = new byte[6];
    final byte[] tmpBuffer7 = new byte[7];
    final byte[] tmpBuffer8 = new byte[8];
    final int[] retLen = new int[1];
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Jun_22_11:15:46_PDT_2005";

    T4CMAREngine(Communication communication) throws SQLException, IOException {
        if (communication == null) {
            DatabaseError.throwSqlException(433);
        }
        this.net = communication;
        try {
            this.inStream = communication.getInputStream();
            this.outStream = communication.getOutputStream();
        }
        catch (NetException netException) {
            throw new IOException(netException.getMessage());
        }
        this.types = new T4CTypeRep();
        this.types.setRep((byte)1, (byte)2);
    }

    void addPtr(byte by) throws IOException {
        if ((this.types.rep[4] & 1) > 0) {
            this.outStream.write(by);
        } else {
            byte by2 = this.value2Buffer(by, this.tmpBuffer4, (byte)4);
            if (by2 != 0) {
                this.outStream.write(this.tmpBuffer4, 0, by2);
            }
        }
    }

    long buffer2Value(byte by) throws SQLException, IOException {
        byte[] byArray;
        int n2 = 0;
        long l2 = 0L;
        boolean bl2 = false;
        if ((this.types.rep[by] & 1) > 0) {
            try {
                n2 = this.inStream.read();
            }
            catch (BreakNetException breakNetException) {
                this.net.sendReset();
                throw breakNetException;
            }
            if ((n2 & 0x80) > 0) {
                n2 &= 0x7F;
                bl2 = true;
            }
            if (n2 < 0) {
                DatabaseError.throwSqlException(410);
            }
            if (n2 == 0) {
                return 0L;
            }
            if (by == 1 && n2 > 2 || by == 2 && n2 > 4 || by == 3 && n2 > 8) {
                DatabaseError.throwSqlException(412);
            }
        } else if (by == 1) {
            n2 = 2;
        } else if (by == 2) {
            n2 = 4;
        } else if (by == 3) {
            n2 = 8;
        }
        switch (n2) {
            case 1: {
                byArray = this.tmpBuffer1;
                break;
            }
            case 2: {
                byArray = this.tmpBuffer2;
                break;
            }
            case 3: {
                byArray = this.tmpBuffer3;
                break;
            }
            case 4: {
                byArray = this.tmpBuffer4;
                break;
            }
            case 5: {
                byArray = this.tmpBuffer5;
                break;
            }
            case 6: {
                byArray = this.tmpBuffer6;
                break;
            }
            case 7: {
                byArray = this.tmpBuffer7;
                break;
            }
            case 8: {
                byArray = this.tmpBuffer8;
                break;
            }
            default: {
                byArray = new byte[n2];
                break;
            }
        }
        try {
            if (this.inStream.read(byArray) < 0) {
                DatabaseError.throwSqlException(410);
            }
        }
        catch (BreakNetException breakNetException) {
            this.net.sendReset();
            throw breakNetException;
        }
        int n3 = 0;
        while (n3 < byArray.length) {
            long l3 = (this.types.rep[by] & 2) > 0 ? (long)(byArray[byArray.length - 1 - n3] & 0xFF) & 0xFFL : (long)(byArray[n3] & 0xFF) & 0xFFL;
            l2 |= l3 << 8 * (byArray.length - 1 - n3);
            ++n3;
        }
        if (by != 3) {
            l2 &= 0xFFFFFFFFFFFFFFFFL;
        }
        if (bl2) {
            l2 = -l2;
        }
        return l2;
    }

    long buffer2Value(byte by, ByteArrayInputStream byteArrayInputStream) throws SQLException, IOException {
        byte[] byArray;
        int n2 = 0;
        long l2 = 0L;
        boolean bl2 = false;
        if ((this.types.rep[by] & 1) > 0) {
            n2 = byteArrayInputStream.read();
            if ((n2 & 0x80) > 0) {
                n2 &= 0x7F;
                bl2 = true;
            }
            if (n2 < 0) {
                DatabaseError.throwSqlException(410);
            }
            if (n2 == 0) {
                return 0L;
            }
            if (by == 1 && n2 > 2 || by == 2 && n2 > 4) {
                DatabaseError.throwSqlException(412);
            }
        } else if (by == 1) {
            n2 = 2;
        } else if (by == 2) {
            n2 = 4;
        }
        if (byteArrayInputStream.read(byArray = new byte[n2]) < 0) {
            DatabaseError.throwSqlException(410);
        }
        int n3 = 0;
        while (n3 < byArray.length) {
            short s2 = (this.types.rep[by] & 2) > 0 ? (short)(byArray[byArray.length - 1 - n3] & 0xFF) : (short)(byArray[n3] & 0xFF);
            l2 |= (long)(s2 << 8 * (byArray.length - 1 - n3));
            ++n3;
        }
        l2 &= 0xFFFFFFFFFFFFFFFFL;
        if (bl2) {
            l2 = -l2;
        }
        return l2;
    }

    boolean escapeSequenceNull(int n2) throws SQLException {
        boolean bl2 = false;
        switch (n2) {
            case 0: {
                bl2 = true;
                break;
            }
            case 253: {
                DatabaseError.throwSqlException(401);
            }
            case 255: {
                bl2 = true;
                break;
            }
        }
        return bl2;
    }

    byte[] getNBytes(int n2) throws SQLException, IOException {
        byte[] byArray = new byte[n2];
        try {
            if (this.inStream.read(byArray) < 0) {
                DatabaseError.throwSqlException(410);
            }
        }
        catch (BreakNetException breakNetException) {
            this.net.sendReset();
            throw breakNetException;
        }
        return byArray;
    }

    int getNBytes(byte[] byArray, int n2, int n3) throws SQLException, IOException {
        int n4 = 0;
        try {
            n4 = this.inStream.read(byArray, n2, n3);
            if (n4 < 0) {
                DatabaseError.throwSqlException(410);
            }
        }
        catch (BreakNetException breakNetException) {
            this.net.sendReset();
            throw breakNetException;
        }
        return n4;
    }

    void initBuffers() {
    }

    void marshalB1Array(byte[] byArray) throws IOException {
        if (byArray.length > 0) {
            this.outStream.write(byArray);
        }
    }

    void marshalB1Array(byte[] byArray, int n2, int n3) throws IOException {
        if (byArray.length > 0) {
            this.outStream.write(byArray, n2, n3);
        }
    }

    void marshalCHR(byte[] byArray) throws IOException {
        this.marshalCHR(byArray, 0, byArray.length);
    }

    void marshalCHR(byte[] byArray, int n2, int n3) throws IOException {
        if (n3 > 0) {
            if (this.types.isConvNeeded()) {
                this.marshalCLR(byArray, n2, n3);
            } else {
                this.outStream.write(byArray, n2, n3);
            }
        }
    }

    void marshalCLR(byte[] byArray, int n2) throws IOException {
        this.marshalCLR(byArray, 0, n2);
    }

    void marshalCLR(byte[] byArray, int n2, int n3) throws IOException {
        if (n3 > 64) {
            int n4;
            int n5 = 0;
            this.outStream.write(-2);
            do {
                int n6;
                n4 = (n6 = n3 - n5) > 64 ? 64 : n6;
                this.outStream.write((byte)(n4 & 0xFF));
                this.outStream.write(byArray, n2 + n5, n4);
            } while ((n5 += n4) < n3);
            this.outStream.write(0);
        } else {
            this.outStream.write((byte)(n3 & 0xFF));
            if (byArray.length != 0) {
                this.outStream.write(byArray, n2, n3);
            }
        }
    }

    void marshalDALC(byte[] byArray) throws SQLException, IOException {
        if (byArray == null || byArray.length < 1) {
            this.outStream.write(0);
        } else {
            this.marshalSB4(0xFFFFFFFF & byArray.length);
            this.marshalCLR(byArray, byArray.length);
        }
    }

    void marshalKEYVAL(byte[][] byArray, int[] nArray, byte[][] byArray2, int[] nArray2, byte[] byArray3, int n2) throws SQLException, IOException {
        int n3 = 0;
        while (n3 < n2) {
            if (byArray[n3] != null && nArray[n3] > 0) {
                this.marshalUB4(nArray[n3]);
                this.marshalCLR(byArray[n3], 0, nArray[n3]);
            } else {
                this.marshalUB4(0L);
            }
            if (byArray2[n3] != null && nArray2[n3] > 0) {
                this.marshalUB4(nArray2[n3]);
                this.marshalCLR(byArray2[n3], 0, nArray2[n3]);
            } else {
                this.marshalUB4(0L);
            }
            if (byArray3[n3] != 0) {
                this.marshalUB4(1L);
            } else {
                this.marshalUB4(0L);
            }
            ++n3;
        }
    }

    void marshalKEYVAL(byte[][] byArray, byte[][] byArray2, byte[] byArray3, int n2) throws SQLException, IOException {
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        int n3 = 0;
        while (n3 < n2) {
            if (byArray[n3] != null) {
                nArray[n3] = byArray[n3].length;
            }
            if (byArray2[n3] != null) {
                nArray2[n3] = byArray2[n3].length;
            }
            ++n3;
        }
        this.marshalKEYVAL(byArray, nArray, byArray2, nArray2, byArray3, n2);
    }

    void marshalNULLPTR() throws IOException {
        this.addPtr((byte)0);
    }

    void marshalO2U(boolean bl2) throws IOException {
        if (bl2) {
            this.addPtr((byte)1);
        } else {
            this.addPtr((byte)0);
        }
    }

    void marshalPTR() throws IOException {
        this.addPtr((byte)1);
    }

    void marshalSB1(byte by) throws IOException {
        this.outStream.write(by);
    }

    void marshalSB2(short s2) throws IOException {
        byte by = this.value2Buffer(s2, this.tmpBuffer2, (byte)1);
        if (by != 0) {
            this.outStream.write(this.tmpBuffer2, 0, by);
        }
    }

    void marshalSB4(int n2) throws IOException {
        byte by = this.value2Buffer(n2, this.tmpBuffer4, (byte)2);
        if (by != 0) {
            this.outStream.write(this.tmpBuffer4, 0, by);
        }
    }

    void marshalSB8(long l2) throws IOException {
        byte by = this.value2Buffer(l2, this.tmpBuffer8, (byte)3);
        if (by != 0) {
            this.outStream.write(this.tmpBuffer8, 0, by);
        }
    }

    void marshalSWORD(int n2) throws IOException {
        this.marshalSB4(n2);
    }

    void marshalUB1(short s2) throws IOException {
        this.outStream.write((byte)(s2 & 0xFF));
    }

    void marshalUB2(int n2) throws IOException {
        this.marshalSB2((short)(n2 & 0xFFFF));
    }

    void marshalUB4(long l2) throws IOException {
        this.marshalSB4((int)(l2 & 0xFFFFFFFFFFFFFFFFL));
    }

    void marshalUB4Array(long[] lArray) throws IOException {
        int n2 = 0;
        while (n2 < lArray.length) {
            this.marshalSB4((int)(lArray[n2] & 0xFFFFFFFFFFFFFFFFL));
            ++n2;
        }
    }

    void marshalUWORD(long l2) throws IOException {
        this.marshalSB4((int)(l2 & 0xFFFFFFFFFFFFFFFFL));
    }

    int processIndicator(boolean bl2, int n2) throws SQLException, IOException {
        short s2 = this.unmarshalSB2();
        int n3 = 0;
        if (!bl2) {
            n3 = s2 == 0 ? n2 : (s2 == -2 || s2 > 0 ? (int)s2 : 65536 + s2);
        }
        return n3;
    }

    void reverseArray(byte[] byArray, byte by) {
        int n2 = 0;
        while (n2 < by / 2) {
            byte by2 = byArray[n2];
            byArray[n2] = byArray[by - 1 - n2];
            byArray[by - 1 - n2] = by2;
            ++n2;
        }
    }

    static String toHex(byte by) {
        String string = "00" + Integer.toHexString(by & 0xFF);
        return "0x" + string.substring(string.length() - 2);
    }

    static String toHex(int n2) {
        return T4CMAREngine.toHex(n2, 4);
    }

    static String toHex(long l2, int n2) {
        String string;
        switch (n2) {
            case 1: {
                string = "00" + Long.toString(l2 & 0xFFL, 16);
                break;
            }
            case 2: {
                string = "0000" + Long.toString(l2 & 0xFFFFL, 16);
                break;
            }
            case 3: {
                string = "000000" + Long.toString(l2 & 0xFFFFFFL, 16);
                break;
            }
            case 4: {
                string = "00000000" + Long.toString(l2 & 0xFFFFFFFFL, 16);
                break;
            }
            case 5: {
                string = "0000000000" + Long.toString(l2 & 0xFFFFFFFFFFL, 16);
                break;
            }
            case 6: {
                string = "000000000000" + Long.toString(l2 & 0xFFFFFFFFFFFFL, 16);
                break;
            }
            case 7: {
                string = "00000000000000" + Long.toString(l2 & 0xFFFFFFFFFFFFFFL, 16);
                break;
            }
            case 8: {
                return String.valueOf(T4CMAREngine.toHex(l2 >> 32, 4)) + T4CMAREngine.toHex(l2, 4).substring(2);
            }
            default: {
                return "more than 8 bytes";
            }
        }
        return "0x" + string.substring(string.length() - 2 * n2);
    }

    static String toHex(short s2) {
        return T4CMAREngine.toHex(s2, 2);
    }

    static String toHex(byte[] byArray) {
        if (byArray == null) {
            return "null";
        }
        return T4CMAREngine.toHex(byArray, byArray.length);
    }

    static String toHex(byte[] byArray, int n2) {
        if (byArray == null) {
            return "null";
        }
        if (n2 > byArray.length) {
            return "byte array not long enough";
        }
        String string = "[";
        int n3 = Math.min(64, n2);
        int n4 = 0;
        while (n4 < n3) {
            string = String.valueOf(string) + T4CMAREngine.toHex(byArray[n4]) + " ";
            ++n4;
        }
        if (n3 < n2) {
            string = String.valueOf(string) + "...";
        }
        return String.valueOf(string) + "]";
    }

    int unmarshalBuffer(byte[] byArray, int n2, int n3) throws SQLException, IOException {
        if (n3 <= 0) {
            return n2;
        }
        if (byArray.length < n2 + n3) {
            this.unmarshalNBytes(byArray, n2, byArray.length - n2);
            this.unmarshalNBytes(this.ignored, 0, n2 + n3 - byArray.length);
            n2 = -1;
        } else {
            this.unmarshalNBytes(byArray, n2, n3);
            n2 += n3;
        }
        return n2;
    }

    byte[] unmarshalCHR(int n2) throws SQLException, IOException {
        byte[] byArray = null;
        if (this.types.isConvNeeded()) {
            byArray = this.unmarshalCLR(n2, this.retLen);
            if (byArray.length != this.retLen[0]) {
                byte[] byArray2 = new byte[this.retLen[0]];
                System.arraycopy(byArray, 0, byArray2, 0, this.retLen[0]);
                byArray = byArray2;
            }
        } else {
            byArray = this.getNBytes(n2);
        }
        return byArray;
    }

    byte[] unmarshalCLR(int n2, int[] nArray) throws SQLException, IOException {
        byte[] byArray = new byte[n2 * this.conv.c2sNlsRatio];
        this.unmarshalCLR(byArray, 0, nArray, n2);
        return byArray;
    }

    void unmarshalCLR(byte[] byArray, int n2, int[] nArray) throws SQLException, IOException {
        this.unmarshalCLR(byArray, n2, nArray, Integer.MAX_VALUE);
    }

    void unmarshalCLR(byte[] byArray, int n2, int[] nArray, int n3) throws SQLException, IOException {
        short s2 = 0;
        int n4 = n2;
        boolean bl2 = false;
        int n5 = 0;
        int n6 = 0;
        int n7 = -1;
        s2 = this.unmarshalUB1();
        if (s2 < 0) {
            DatabaseError.throwSqlException(401);
        }
        if (s2 == 0) {
            nArray[0] = 0;
            return;
        }
        if (this.escapeSequenceNull(s2)) {
            nArray[0] = 0;
            return;
        }
        if (s2 != 254) {
            n6 = Math.min(n3 - n5, s2);
            n4 = this.unmarshalBuffer(byArray, n4, n6);
            n5 += n6;
            int n8 = s2 - n6;
            if (n8 > 0) {
                this.unmarshalBuffer(this.ignored, 0, n8);
            }
        } else {
            n7 = -1;
            block5: while (n7 == -1 || (s2 = this.unmarshalUB1()) > 0) {
                if (s2 == 254) {
                    switch (n7) {
                        case -1: {
                            n7 = 1;
                            continue block5;
                        }
                        case 1: {
                            n7 = 0;
                            break;
                        }
                        case 0: {
                            if (bl2) {
                                n7 = 0;
                                break;
                            }
                            n7 = 0;
                            continue block5;
                        }
                    }
                }
                if (n4 == -1) {
                    this.unmarshalBuffer(this.ignored, 0, s2);
                } else {
                    n6 = Math.min(n3 - n5, s2);
                    n4 = this.unmarshalBuffer(byArray, n4, n6);
                    n5 += n6;
                    int n9 = s2 - n6;
                    if (n9 > 0) {
                        this.unmarshalBuffer(this.ignored, 0, n9);
                    }
                }
                n7 = 0;
                if (s2 <= 252) continue;
                bl2 = true;
            }
        }
        if (nArray != null) {
            nArray[0] = n4 != -1 ? n5 : byArray.length - n2;
        }
    }

    byte[] unmarshalCLRforREFS() throws SQLException, IOException {
        short s2 = 0;
        short s3 = 0;
        byte[] byArray = null;
        Vector<byte[]> vector = new Vector<byte[]>(10, 10);
        short s4 = this.unmarshalUB1();
        if (s4 < 0) {
            DatabaseError.throwSqlException(401);
        }
        if (s4 == 0) {
            return null;
        }
        if (!this.escapeSequenceNull(s4)) {
            byte[] byArray2;
            if (s4 == 254) {
                while ((s2 = this.unmarshalUB1()) > 0) {
                    if (s2 == 254 && this.types.isServerConversion()) continue;
                    s3 = (short)(s3 + s2);
                    byArray2 = new byte[s2];
                    this.unmarshalBuffer(byArray2, 0, s2);
                    vector.addElement(byArray2);
                }
            } else {
                s3 = s4;
                byArray2 = new byte[s4];
                this.unmarshalBuffer(byArray2, 0, s4);
                vector.addElement(byArray2);
            }
            byArray = new byte[s3];
            int n2 = 0;
            while (vector.size() > 0) {
                int n3 = ((byte[])vector.elementAt(0)).length;
                System.arraycopy(vector.elementAt(0), 0, byArray, n2, n3);
                n2 += n3;
                vector.removeElementAt(0);
            }
        } else {
            byArray = null;
        }
        return byArray;
    }

    byte[] unmarshalDALC() throws SQLException, IOException {
        long l2 = this.unmarshalUB4();
        byte[] byArray = new byte[(int)(0xFFFFFFFFFFFFFFFFL & l2)];
        if (byArray.length > 0) {
            if ((byArray = this.unmarshalCLR(byArray.length, this.retLen)) == null) {
                DatabaseError.throwSqlException(401);
            }
        } else {
            byArray = new byte[]{};
        }
        return byArray;
    }

    long unmarshalDALC(byte[] byArray, int n2, int[] nArray) throws SQLException, IOException {
        long l2 = this.unmarshalUB4();
        if (l2 > 0L) {
            this.unmarshalCLR(byArray, n2, nArray);
        }
        return l2;
    }

    byte[] unmarshalDALC(int[] nArray) throws SQLException, IOException {
        long l2 = this.unmarshalUB4();
        byte[] byArray = new byte[(int)(0xFFFFFFFFFFFFFFFFL & l2)];
        if (byArray.length > 0) {
            if ((byArray = this.unmarshalCLR(byArray.length, nArray)) == null) {
                DatabaseError.throwSqlException(401);
            }
        } else {
            byArray = new byte[]{};
        }
        return byArray;
    }

    int unmarshalKEYVAL(byte[][] byArray, byte[][] byArray2, int n2) throws SQLException, IOException {
        byte[] byArray3 = new byte[1000];
        int[] nArray = new int[1];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = this.unmarshalSB4();
            if (n5 > 0) {
                this.unmarshalCLR(byArray3, 0, nArray);
                byArray[n4] = new byte[nArray[0]];
                System.arraycopy(byArray3, 0, byArray[n4], 0, nArray[0]);
            }
            if ((n5 = this.unmarshalSB4()) > 0) {
                this.unmarshalCLR(byArray3, 0, nArray);
                byArray2[n4] = new byte[nArray[0]];
                System.arraycopy(byArray3, 0, byArray2[n4], 0, nArray[0]);
            }
            n3 = this.unmarshalSB4();
            ++n4;
        }
        byArray3 = null;
        return n3;
    }

    byte[] unmarshalNBytes(int n2) throws SQLException, IOException {
        byte[] byArray = new byte[n2];
        try {
            if (this.inStream.read(byArray) < 0) {
                DatabaseError.throwSqlException(410);
            }
        }
        catch (BreakNetException breakNetException) {
            this.net.sendReset();
            throw breakNetException;
        }
        return byArray;
    }

    int unmarshalNBytes(byte[] byArray, int n2, int n3) throws SQLException, IOException {
        int n4 = 0;
        while (n4 < n3) {
            n4 += this.getNBytes(byArray, n2 + n4, n3 - n4);
        }
        return n4;
    }

    int unmarshalRefCursor(byte[] byArray) throws SQLException, IOException {
        int n2 = this.unmarshalSB4(byArray);
        return n2;
    }

    byte unmarshalSB1() throws SQLException, IOException {
        byte by = (byte)this.unmarshalUB1();
        return by;
    }

    short unmarshalSB2() throws SQLException, IOException {
        short s2 = (short)this.unmarshalUB2();
        return s2;
    }

    int unmarshalSB4() throws SQLException, IOException {
        int n2 = (int)this.unmarshalUB4();
        return n2;
    }

    int unmarshalSB4(byte[] byArray) throws SQLException, IOException {
        long l2 = this.buffer2Value((byte)2, new ByteArrayInputStream(byArray));
        return (int)l2;
    }

    long unmarshalSB8() throws SQLException, IOException {
        long l2 = this.buffer2Value((byte)3);
        return l2;
    }

    int unmarshalSWORD() throws SQLException, IOException {
        int n2 = (int)this.unmarshalUB4();
        return n2;
    }

    byte[] unmarshalTEXT(int n2) throws SQLException, IOException {
        byte[] byArray;
        int n3 = 0;
        byte[] byArray2 = new byte[n2];
        while (n3 < n2) {
            try {
                if (this.inStream.read(byArray2, n3, 1) < 0) {
                    DatabaseError.throwSqlException(410);
                }
            }
            catch (BreakNetException breakNetException) {
                this.net.sendReset();
                throw breakNetException;
            }
            if (byArray2[n3++] == 0) break;
        }
        if (byArray2.length == --n3) {
            byArray = byArray2;
        } else {
            byArray = new byte[n3];
            System.arraycopy(byArray2, 0, byArray, 0, n3);
        }
        return byArray;
    }

    short unmarshalUB1() throws SQLException, IOException {
        short s2 = 0;
        try {
            s2 = (short)this.inStream.read();
        }
        catch (BreakNetException breakNetException) {
            this.net.sendReset();
            throw breakNetException;
        }
        if (s2 < 0) {
            DatabaseError.throwSqlException(410);
        }
        return s2;
    }

    int unmarshalUB2() throws SQLException, IOException {
        int n2 = (int)this.buffer2Value((byte)1);
        return n2 & 0xFFFF;
    }

    long unmarshalUB4() throws SQLException, IOException {
        long l2 = this.buffer2Value((byte)2);
        return l2;
    }

    int unmarshalUCS2(byte[] byArray, long l2) throws SQLException, IOException {
        int n2 = this.unmarshalUB2();
        this.tmpBuffer2[0] = (byte)((n2 & 0xFF00) >> 8);
        this.tmpBuffer2[1] = (byte)(n2 & 0xFF);
        if (l2 + 1L < (long)byArray.length) {
            byArray[(int)l2] = this.tmpBuffer2[0];
            byArray[(int)l2 + 1] = this.tmpBuffer2[1];
        }
        return this.tmpBuffer2[0] == 0 ? (this.tmpBuffer2[1] == 0 ? 1 : 2) : 3;
    }

    long unmarshalUWORD() throws SQLException, IOException {
        long l2 = this.unmarshalUB4();
        return l2;
    }

    byte value2Buffer(int n2, byte[] byArray, byte by) throws IOException {
        boolean bl2 = true;
        byte by2 = 0;
        int n3 = byArray.length - 1;
        while (n3 >= 0) {
            byArray[by2] = (byte)(n2 >>> 8 * n3 & 0xFF);
            if ((this.types.rep[by] & 1) > 0) {
                if (!bl2 || byArray[by2] != 0) {
                    bl2 = false;
                    by2 = (byte)(by2 + 1);
                }
            } else {
                by2 = (byte)(by2 + 1);
            }
            --n3;
        }
        if ((this.types.rep[by] & 1) > 0) {
            this.outStream.write(by2);
        }
        if ((this.types.rep[by] & 2) > 0) {
            this.reverseArray(byArray, by2);
        }
        return by2;
    }

    byte value2Buffer(long l2, byte[] byArray, byte by) throws IOException {
        boolean bl2 = true;
        byte by2 = 0;
        int n2 = byArray.length - 1;
        while (n2 >= 0) {
            byArray[by2] = (byte)(l2 >>> 8 * n2 & 0xFFL);
            if ((this.types.rep[by] & 1) > 0) {
                if (!bl2 || byArray[by2] != 0) {
                    bl2 = false;
                    by2 = (byte)(by2 + 1);
                }
            } else {
                by2 = (byte)(by2 + 1);
            }
            --n2;
        }
        if ((this.types.rep[by] & 1) > 0) {
            this.outStream.write(by2);
        }
        if ((this.types.rep[by] & 2) > 0) {
            this.reverseArray(byArray, by2);
        }
        return by2;
    }
}

