/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CLongAccessor;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.VarcharAccessor;

class T4CVarcharAccessor
extends VarcharAccessor {
    T4CMAREngine mare;
    static final int t4MaxLength = 4000;
    static final int t4CallMaxLength = 4001;
    static final int t4PlsqlMaxLength = 32512;
    boolean underlyingLong = false;
    final int[] meta = new int[1];
    final int[] tmp = new int[1];
    final int[] escapeSequenceArr = new int[1];
    final boolean[] readHeaderArr = new boolean[1];
    final boolean[] readAsNonStreamArr = new boolean[1];
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Jun_22_11:15:47_PDT_2005";

    T4CVarcharAccessor(OracleStatement oracleStatement, int n2, short s2, int n3, boolean bl2, T4CMAREngine t4CMAREngine) throws SQLException {
        super(oracleStatement, n2, s2, n3, bl2);
        this.mare = t4CMAREngine;
        this.calculateSizeTmpByteArray();
    }

    T4CVarcharAccessor(OracleStatement oracleStatement, int n2, boolean bl2, int n3, int n4, int n5, int n6, int n7, short s2, int n8, int n9, int n10, T4CMAREngine t4CMAREngine) throws SQLException {
        super(oracleStatement, n2, bl2, n3, n4, n5, n6, n7, s2);
        this.mare = t4CMAREngine;
        this.definedColumnType = n9;
        this.definedColumnSize = n10;
        this.calculateSizeTmpByteArray();
        this.oacmxl = n8;
        if (this.oacmxl == -1) {
            this.underlyingLong = true;
            this.oacmxl = 4000;
        }
    }

    void calculateSizeTmpByteArray() {
        int n2 = this.formOfUse == 2 ? (this.charLength - 1) * this.statement.connection.conversion.maxNCharSize : (this.charLength - 1) * this.statement.connection.conversion.cMaxCharSize;
        if (this.statement.sizeTmpByteArray < n2) {
            this.statement.sizeTmpByteArray = n2;
        }
    }

    void copyRow() throws SQLException, IOException {
        int n2 = this.lastRowProcessed == 0 ? this.statement.rowPrefetch : this.lastRowProcessed;
        int n3 = this.columnIndex + this.lastRowProcessed * this.charLength;
        int n4 = this.columnIndex + (n2 - 1) * this.charLength;
        int n5 = this.indicatorIndex + this.lastRowProcessed;
        int n6 = this.indicatorIndex + n2 - 1;
        int n7 = this.lengthIndex + this.lastRowProcessed;
        int n8 = this.lengthIndex + n2 - 1;
        short s2 = this.rowSpaceIndicator[n8];
        this.rowSpaceIndicator[n7] = s2;
        this.rowSpaceIndicator[n5] = this.rowSpaceIndicator[n6];
        System.arraycopy(this.rowSpaceChar, n4, this.rowSpaceChar, n3, this.rowSpaceChar[n4] / 2 + 1);
        ++this.lastRowProcessed;
    }

    Object getObject(int n2) throws SQLException {
        if (this.definedColumnType == 0) {
            return super.getObject(n2);
        }
        Object var2_2 = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            switch (this.definedColumnType) {
                case -1: 
                case 1: 
                case 12: {
                    return this.getString(n2);
                }
                case 2: 
                case 3: {
                    return this.getBigDecimal(n2);
                }
                case 4: {
                    return new Integer(this.getInt(n2));
                }
                case -6: {
                    return new Byte(this.getByte(n2));
                }
                case 5: {
                    return new Short(this.getShort(n2));
                }
                case -7: 
                case 16: {
                    return new Boolean(this.getBoolean(n2));
                }
                case -5: {
                    return new Long(this.getLong(n2));
                }
                case 7: {
                    return new Float(this.getFloat(n2));
                }
                case 6: 
                case 8: {
                    return new Double(this.getDouble(n2));
                }
                case 91: {
                    return this.getDate(n2);
                }
                case 92: {
                    return this.getTime(n2);
                }
                case 93: {
                    return this.getTimestamp(n2);
                }
                case -4: 
                case -3: 
                case -2: {
                    return this.getBytes(n2);
                }
            }
            DatabaseError.throwSqlException(4);
            return null;
        }
        return var2_2;
    }

    String getString(int n2) throws SQLException {
        String string = super.getString(n2);
        if (string != null && this.definedColumnSize > 0 && string.length() > this.definedColumnSize) {
            string = string.substring(0, this.definedColumnSize);
        }
        return string;
    }

    void processIndicator(int n2) throws IOException, SQLException {
        if (this.internalType == 1 && this.describeType == 112 || this.internalType == 23 && this.describeType == 113) {
            this.mare.unmarshalUB2();
            this.mare.unmarshalUB2();
        } else if (this.mare.versionNumber < 9200) {
            this.mare.unmarshalSB2();
            if (this.statement.sqlKind != 1 && this.statement.sqlKind != 4) {
                this.mare.unmarshalSB2();
            }
        } else if (this.statement.sqlKind == 1 || this.statement.sqlKind == 4 || this.isDMLReturnedParam) {
            this.mare.processIndicator(n2 <= 0, n2);
        }
    }

    void saveDataFromOldDefineBuffers(byte[] byArray, char[] cArray, short[] sArray, int n2, int n3) throws SQLException {
        int n4 = this.columnIndex + (n3 - 1) * this.charLength;
        int n5 = this.columnIndexLastRow + (n2 - 1) * this.charLength;
        int n6 = this.indicatorIndex + n3 - 1;
        int n7 = this.indicatorIndexLastRow + n2 - 1;
        int n8 = this.lengthIndex + n3 - 1;
        int n9 = this.lengthIndexLastRow + n2 - 1;
        short s2 = sArray[n9];
        this.rowSpaceIndicator[n8] = s2;
        this.rowSpaceIndicator[n6] = sArray[n7];
        if (s2 != 0) {
            System.arraycopy(cArray, n5, this.rowSpaceChar, n4, cArray[n5] / 2 + 1);
        }
    }

    boolean unmarshalOneRow() throws SQLException, IOException {
        int n2;
        if (this.isUseLess) {
            ++this.lastRowProcessed;
            return false;
        }
        int n3 = this.indicatorIndex + this.lastRowProcessed;
        int n4 = this.lengthIndex + this.lastRowProcessed;
        byte[] byArray = this.statement.tmpByteArray;
        int n5 = this.columnIndex + this.lastRowProcessed * this.charLength;
        if (!this.underlyingLong) {
            if (this.rowSpaceIndicator == null) {
                byte[] byArray2 = new byte[16000];
                this.mare.unmarshalCLR(byArray2, 0, this.meta);
                this.processIndicator(this.meta[0]);
                ++this.lastRowProcessed;
                return false;
            }
            if (this.isNullByDescribe) {
                this.rowSpaceIndicator[n3] = -1;
                this.rowSpaceIndicator[n4] = 0;
                ++this.lastRowProcessed;
                if (this.mare.versionNumber < 9200) {
                    this.processIndicator(0);
                }
                return false;
            }
            if (this.statement.maxFieldSize > 0) {
                this.mare.unmarshalCLR(byArray, 0, this.meta, this.statement.maxFieldSize);
            } else {
                this.mare.unmarshalCLR(byArray, 0, this.meta);
            }
        } else {
            this.escapeSequenceArr[0] = this.mare.unmarshalUB1();
            if (this.mare.escapeSequenceNull(this.escapeSequenceArr[0])) {
                this.meta[0] = 0;
                this.mare.processIndicator(false, 0);
                n2 = this.mare.unmarshalUB2();
            } else {
                n2 = 0;
                int n6 = 0;
                byte[] byArray3 = byArray;
                int n7 = 0;
                this.readHeaderArr[0] = true;
                this.readAsNonStreamArr[0] = false;
                while (n2 != -1) {
                    if (byArray3 == byArray && n6 + 255 > byArray.length) {
                        byArray3 = new byte[255];
                    }
                    if ((n2 = T4CLongAccessor.readStreamFromWire(byArray3, n7 = byArray3 == byArray ? n6 : 0, 255, this.escapeSequenceArr, this.readHeaderArr, this.readAsNonStreamArr, this.mare, ((T4CConnection)this.statement.connection).oer)) == -1) continue;
                    if (byArray3 == byArray) {
                        n6 += n2;
                        continue;
                    }
                    if (byArray.length - n6 <= 0) continue;
                    int n8 = byArray.length - n6;
                    System.arraycopy(byArray3, 0, byArray, n6, n8);
                    n6 += n8;
                }
                if (byArray3 != byArray) {
                    byArray3 = null;
                }
                this.meta[0] = n6;
            }
        }
        this.tmp[0] = this.meta[0];
        n2 = 0;
        n2 = this.formOfUse == 2 ? this.statement.connection.conversion.NCHARBytesToJavaChars(byArray, 0, this.rowSpaceChar, n5 + 1, this.tmp, this.charLength - 1) : this.statement.connection.conversion.CHARBytesToJavaChars(byArray, 0, this.rowSpaceChar, n5 + 1, this.tmp, this.charLength - 1);
        this.rowSpaceChar[n5] = (char)(n2 * 2);
        if (!this.underlyingLong) {
            this.processIndicator(this.meta[0]);
        }
        if (this.meta[0] == 0) {
            this.rowSpaceIndicator[n3] = -1;
            this.rowSpaceIndicator[n4] = 0;
        } else {
            this.rowSpaceIndicator[n4] = (short)(this.meta[0] * 2);
            this.rowSpaceIndicator[n3] = 0;
        }
        ++this.lastRowProcessed;
        return false;
    }
}

