/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.TimeZone;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DateTimeCommonAccessor;
import oracle.jdbc.driver.OracleStatement;
import oracle.sql.Datum;
import oracle.sql.TIMESTAMPTZ;
import oracle.sql.TIMEZONETAB;
import oracle.sql.ZONEIDMAP;

class TimestamptzAccessor
extends DateTimeCommonAccessor {
    static final int maxLength = 13;
    static int OFFSET_HOUR = 20;
    static int OFFSET_MINUTE = 60;
    static byte REGIONIDBIT = (byte)-128;

    TimestamptzAccessor(OracleStatement oracleStatement, int n2, short s2, int n3, boolean bl2) throws SQLException {
        this.init(oracleStatement, 181, 181, s2, bl2);
        this.initForDataAccess(n3, n2, null);
    }

    TimestamptzAccessor(OracleStatement oracleStatement, int n2, boolean bl2, int n3, int n4, int n5, int n6, int n7, short s2) throws SQLException {
        this.init(oracleStatement, 181, 181, s2, false);
        this.initForDescribe(181, n2, bl2, n3, n4, n5, n6, n7, s2, null);
        this.initForDataAccess(0, n2, null);
    }

    Date getDate(int n2) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] == -1) {
            return null;
        }
        int n3 = this.columnIndex + this.byteLength * n2;
        TimeZone timeZone = this.statement.getDefaultTimeZone();
        Calendar calendar = Calendar.getInstance(timeZone);
        int n4 = ((this.rowSpaceByte[n3] & 0xFF) - 100) * 100 + (this.rowSpaceByte[1 + n3] & 0xFF) - 100;
        calendar.set(1, n4);
        calendar.set(2, this.oracleMonth(n3));
        calendar.set(5, this.oracleDay(n3));
        calendar.set(11, this.oracleHour(n3));
        calendar.set(12, this.oracleMin(n3));
        calendar.set(13, this.oracleSec(n3));
        calendar.set(14, 0);
        if ((this.oracleTZ1(n3) & REGIONIDBIT) != 0) {
            int n5 = TimestamptzAccessor.getHighOrderbits(this.oracleTZ1(n3));
            if (TIMEZONETAB.checkID(n5 += TimestamptzAccessor.getLowOrderbits(this.oracleTZ2(n3)))) {
                TIMEZONETAB.updateTable(this.statement.connection, n5);
            }
            int n6 = TIMEZONETAB.getOffset(calendar, n5);
            calendar.add(10, n6 / 3600000);
            calendar.add(12, n6 % 3600000 / 60000);
        } else {
            calendar.add(10, this.oracleTZ1(n3) - OFFSET_HOUR);
            calendar.add(12, this.oracleTZ2(n3) - OFFSET_MINUTE);
        }
        long l2 = calendar.getTime().getTime();
        return new Date(l2);
    }

    static int getHighOrderbits(int n2) {
        return (n2 & 0x7F) << 6;
    }

    static int getLowOrderbits(int n2) {
        return (n2 & 0xFC) >> 2;
    }

    Object getObject(int n2) throws SQLException {
        return this.getTIMESTAMPTZ(n2);
    }

    Object getObject(int n2, Map map) throws SQLException {
        return this.getTIMESTAMPTZ(n2);
    }

    Datum getOracleObject(int n2) throws SQLException {
        return this.getTIMESTAMPTZ(n2);
    }

    String getString(int n2) throws SQLException {
        String string;
        int n3;
        int n4;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] == -1) {
            return null;
        }
        int n5 = this.columnIndex + this.byteLength * n2;
        TimeZone timeZone = this.statement.getDefaultTimeZone();
        Calendar calendar = Calendar.getInstance(timeZone);
        int n6 = ((this.rowSpaceByte[n5] & 0xFF) - 100) * 100 + (this.rowSpaceByte[1 + n5] & 0xFF) - 100;
        calendar.set(1, n6);
        calendar.set(2, this.oracleMonth(n5));
        calendar.set(5, this.oracleDay(n5));
        calendar.set(11, this.oracleHour(n5));
        calendar.set(12, this.oracleMin(n5));
        calendar.set(13, this.oracleSec(n5));
        calendar.set(14, 0);
        if ((this.oracleTZ1(n5) & REGIONIDBIT) != 0) {
            n4 = TimestamptzAccessor.getHighOrderbits(this.oracleTZ1(n5));
            if (TIMEZONETAB.checkID(n4 += TimestamptzAccessor.getLowOrderbits(this.oracleTZ2(n5)))) {
                TIMEZONETAB.updateTable(this.statement.connection, n4);
            }
            n3 = TIMEZONETAB.getOffset(calendar, n4);
            calendar.add(10, n3 / 3600000);
            calendar.add(12, n3 % 3600000 / 60000);
            string = new String(ZONEIDMAP.getRegion(n4));
        } else {
            calendar.add(10, this.oracleTZ1(n5) - OFFSET_HOUR);
            calendar.add(12, this.oracleTZ2(n5) - OFFSET_MINUTE);
            n4 = this.oracleTZ1(n5) - OFFSET_HOUR;
            n3 = this.oracleTZ2(n5) - OFFSET_MINUTE;
            string = new String(String.valueOf(n4) + ":" + n3);
        }
        n6 = calendar.get(1);
        n4 = calendar.get(2) + 1;
        n3 = calendar.get(5);
        int n7 = calendar.get(11);
        int n8 = calendar.get(12);
        int n9 = calendar.get(13);
        int n10 = this.oracleNanos(n5);
        return String.valueOf(n6) + "-" + n4 + "-" + n3 + " " + n7 + "." + n8 + "." + n9 + "." + n10 + " " + string;
    }

    TIMESTAMPTZ getTIMESTAMPTZ(int n2) throws SQLException {
        TIMESTAMPTZ tIMESTAMPTZ = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            int n3 = this.columnIndex + this.byteLength * n2;
            byte[] byArray = new byte[13];
            System.arraycopy(this.rowSpaceByte, n3, byArray, 0, 13);
            tIMESTAMPTZ = new TIMESTAMPTZ(byArray);
        }
        return tIMESTAMPTZ;
    }

    Time getTime(int n2) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] == -1) {
            return null;
        }
        int n3 = this.columnIndex + this.byteLength * n2;
        TimeZone timeZone = this.statement.getDefaultTimeZone();
        Calendar calendar = Calendar.getInstance(timeZone);
        int n4 = ((this.rowSpaceByte[n3] & 0xFF) - 100) * 100 + (this.rowSpaceByte[1 + n3] & 0xFF) - 100;
        calendar.set(1, n4);
        calendar.set(2, this.oracleMonth(n3));
        calendar.set(5, this.oracleDay(n3));
        calendar.set(11, this.oracleHour(n3));
        calendar.set(12, this.oracleMin(n3));
        calendar.set(13, this.oracleSec(n3));
        calendar.set(14, 0);
        if ((this.oracleTZ1(n3) & REGIONIDBIT) != 0) {
            int n5 = TimestamptzAccessor.getHighOrderbits(this.oracleTZ1(n3));
            if (TIMEZONETAB.checkID(n5 += TimestamptzAccessor.getLowOrderbits(this.oracleTZ2(n3)))) {
                TIMEZONETAB.updateTable(this.statement.connection, n5);
            }
            int n6 = TIMEZONETAB.getOffset(calendar, n5);
            calendar.add(10, n6 / 3600000);
            calendar.add(12, n6 % 3600000 / 60000);
        } else {
            calendar.add(10, this.oracleTZ1(n3) - OFFSET_HOUR);
            calendar.add(12, this.oracleTZ2(n3) - OFFSET_MINUTE);
        }
        long l2 = calendar.getTime().getTime();
        return new Time(l2);
    }

    Timestamp getTimestamp(int n2) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] == -1) {
            return null;
        }
        int n3 = this.columnIndex + this.byteLength * n2;
        TimeZone timeZone = this.statement.getDefaultTimeZone();
        Calendar calendar = Calendar.getInstance(timeZone);
        int n4 = ((this.rowSpaceByte[n3] & 0xFF) - 100) * 100 + (this.rowSpaceByte[1 + n3] & 0xFF) - 100;
        calendar.set(1, n4);
        calendar.set(2, this.oracleMonth(n3));
        calendar.set(5, this.oracleDay(n3));
        calendar.set(11, this.oracleHour(n3));
        calendar.set(12, this.oracleMin(n3));
        calendar.set(13, this.oracleSec(n3));
        calendar.set(14, 0);
        if ((this.oracleTZ1(n3) & REGIONIDBIT) != 0) {
            int n5 = TimestamptzAccessor.getHighOrderbits(this.oracleTZ1(n3));
            if (TIMEZONETAB.checkID(n5 += TimestamptzAccessor.getLowOrderbits(this.oracleTZ2(n3)))) {
                TIMEZONETAB.updateTable(this.statement.connection, n5);
            }
            int n6 = TIMEZONETAB.getOffset(calendar, n5);
            calendar.add(10, n6 / 3600000);
            calendar.add(12, n6 % 3600000 / 60000);
        } else {
            calendar.add(10, this.oracleTZ1(n3) - OFFSET_HOUR);
            calendar.add(12, this.oracleTZ2(n3) - OFFSET_MINUTE);
        }
        long l2 = calendar.getTime().getTime();
        Timestamp timestamp = new Timestamp(l2);
        int n7 = this.oracleNanos(n3);
        timestamp.setNanos(n7);
        return timestamp;
    }

    void initForDataAccess(int n2, int n3, String string) throws SQLException {
        if (n2 != 0) {
            this.externalType = n2;
        }
        this.internalTypeMaxLength = 13;
        if (n3 > 0 && n3 < this.internalTypeMaxLength) {
            this.internalTypeMaxLength = n3;
        }
        this.byteLength = this.internalTypeMaxLength;
    }

    static int setHighOrderbits(int n2) {
        return (n2 & 0x1FC0) >> 6;
    }

    static int setLowOrderbits(int n2) {
        return (n2 & 0x3F) << 2;
    }
}

