/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import oracle.jdbc.driver.BaseResultSet;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleResultSetImpl;
import oracle.jdbc.driver.OracleResultSetMetaData;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.SQLUtil;
import oracle.jdbc.driver.ScrollRsetStatement;
import oracle.jdbc.driver.ScrollableResultSet;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

class UpdatableResultSet
extends BaseResultSet {
    static final int concurrencyType = 1008;
    static final int beginColumnIndex = 1;
    PhysicalConnection connection;
    OracleResultSet resultSet;
    boolean isCachedRset;
    ScrollRsetStatement scrollStmt;
    ResultSetMetaData rsetMetaData;
    private int rsetType;
    private int columnCount;
    private OraclePreparedStatement deleteStmt;
    private OraclePreparedStatement insertStmt;
    private OraclePreparedStatement updateStmt;
    private int[] indexColsChanged;
    private Object[] rowBuffer;
    private boolean[] m_nullIndicator;
    private int[][] typeInfo;
    private boolean isInserting;
    private boolean isUpdating;
    private int wasNull;
    private static final int VALUE_NULL = 1;
    private static final int VALUE_NOT_NULL = 2;
    private static final int VALUE_UNKNOWN = 3;
    private static final int VALUE_IN_RSET = 4;
    private static final int ASCII_STREAM = 1;
    private static final int BINARY_STREAM = 2;
    private static final int UNICODE_STREAM = 3;
    private static int _MIN_STREAM_SIZE = 4000;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Jun_22_11:15:48_PDT_2005";

    UpdatableResultSet(ScrollRsetStatement scrollRsetStatement, OracleResultSetImpl oracleResultSetImpl, int n2, int n3) throws SQLException {
        this.init(scrollRsetStatement, oracleResultSetImpl, n2, n3);
        this.isCachedRset = false;
    }

    UpdatableResultSet(ScrollRsetStatement scrollRsetStatement, ScrollableResultSet scrollableResultSet, int n2, int n3) throws SQLException {
        this.init(scrollRsetStatement, scrollableResultSet, n2, n3);
        scrollableResultSet.resetBeginColumnIndex();
        this.isCachedRset = true;
    }

    public synchronized boolean absolute(int n2) throws SQLException {
        this.cancelRowChanges();
        return this.resultSet.absolute(n2);
    }

    public synchronized void afterLast() throws SQLException {
        this.cancelRowChanges();
        this.resultSet.afterLast();
    }

    public synchronized void beforeFirst() throws SQLException {
        this.cancelRowChanges();
        this.resultSet.beforeFirst();
    }

    private void cancelRowChanges() throws SQLException {
        if (this.isInserting) {
            this.cancelRowInserts();
        }
        if (this.isUpdating) {
            this.cancelRowUpdates();
        }
    }

    private void cancelRowInserts() {
        if (this.isInserting) {
            this.isInserting = false;
            this.clearRowBuffer();
        }
    }

    public synchronized void cancelRowUpdates() throws SQLException {
        if (this.isUpdating) {
            this.isUpdating = false;
            this.clearRowBuffer();
        }
    }

    private void clearRowBuffer() {
        int n2;
        if (this.rowBuffer != null) {
            n2 = 0;
            while (n2 < this.rowBuffer.length) {
                this.rowBuffer[n2] = null;
                ++n2;
            }
        }
        if (this.m_nullIndicator != null) {
            n2 = 0;
            while (n2 < this.m_nullIndicator.length) {
                this.m_nullIndicator[n2] = false;
                ++n2;
            }
        }
        if (this.typeInfo != null) {
            n2 = 0;
            while (n2 < this.typeInfo.length) {
                if (this.typeInfo[n2] != null) {
                    int n3 = 0;
                    while (n3 < this.typeInfo[n2].length) {
                        this.typeInfo[n2][n3] = 0;
                        ++n3;
                    }
                }
                ++n2;
            }
        }
    }

    public void clearWarnings() throws SQLException {
        this.sqlWarning = null;
        this.resultSet.clearWarnings();
    }

    public synchronized void close() throws SQLException {
        if (this.resultSet != null) {
            this.resultSet.close();
        }
        if (this.insertStmt != null) {
            this.insertStmt.close();
        }
        if (this.updateStmt != null) {
            this.updateStmt.close();
        }
        if (this.deleteStmt != null) {
            this.deleteStmt.close();
        }
        if (this.scrollStmt != null) {
            this.scrollStmt.notifyCloseRset();
        }
        this.cancelRowInserts();
        this.connection = null;
        this.resultSet = null;
        this.scrollStmt = null;
        this.rsetMetaData = null;
        this.scrollStmt = null;
        this.deleteStmt = null;
        this.insertStmt = null;
        this.updateStmt = null;
        this.indexColsChanged = null;
        this.rowBuffer = null;
        this.m_nullIndicator = null;
        this.typeInfo = null;
    }

    public synchronized void deleteRow() throws SQLException {
        if (this.isOnInsertRow()) {
            DatabaseError.throwSqlException(84);
        }
        this.prepareDeleteRowStatement();
        this.prepareDeleteRowBinds();
        this.executeDeleteRow();
    }

    private void executeDeleteRow() throws SQLException {
        if (this.deleteStmt.executeUpdate() == 0) {
            DatabaseError.throwSqlException(85);
        }
        if (this.isCachedRset) {
            ((ScrollableResultSet)this.resultSet).removeRowInCache(this.getRow());
        }
    }

    private void executeInsertRow() throws SQLException {
        if (this.insertStmt.executeUpdate() != 1) {
            DatabaseError.throwSqlException(85);
        }
    }

    private void executeUpdateRow() throws SQLException {
        block9: {
            try {
                if (this.updateStmt.executeUpdate() == 0) {
                    DatabaseError.throwSqlException(85);
                }
                if (!this.isCachedRset) break block9;
                if (this.autoRefetch) {
                    ((ScrollableResultSet)this.resultSet).refreshRowsInCache(this.getRow(), 1, 1000);
                    this.cancelRowUpdates();
                    break block9;
                }
                if (this.rowBuffer != null) {
                    int n2 = 1;
                    while (n2 < this.getColumnCount()) {
                        if (this.rowBuffer[n2] != null || this.rowBuffer[n2] == null && this.m_nullIndicator[n2]) {
                            ((ScrollableResultSet)this.resultSet).setCurrentRowValueAt(this, n2 + 1, this.rowBuffer[n2]);
                        }
                        ++n2;
                    }
                }
                this.cancelRowUpdates();
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                if (this.updateStmt != null) {
                    this.updateStmt.close();
                    this.updateStmt = null;
                }
                throw throwable;
            }
        }
        Object var2_2 = null;
        if (this.updateStmt != null) {
            this.updateStmt.close();
            this.updateStmt = null;
        }
    }

    public synchronized int findColumn(String string) throws SQLException {
        return this.resultSet.findColumn(string) - 1;
    }

    public synchronized boolean first() throws SQLException {
        this.cancelRowChanges();
        return this.resultSet.first();
    }

    public synchronized ARRAY getARRAY(int n2) throws SQLException {
        ARRAY aRRAY = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Datum datum = this.getRowBufferDatumAt(n2);
            this.setIsNull(datum == null);
            if (datum != null && !(datum instanceof ARRAY)) {
                DatabaseError.throwSqlException(4, "getARRAY");
            }
            aRRAY = (ARRAY)datum;
        } else {
            this.setIsNull(4);
            aRRAY = this.resultSet.getARRAY(n2 + 1);
        }
        return aRRAY;
    }

    public synchronized Array getArray(int n2) throws SQLException {
        return this.getARRAY(n2);
    }

    public synchronized InputStream getAsciiStream(int n2) throws SQLException {
        InputStream inputStream = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Object object = this.getRowBufferAt(n2);
            this.setIsNull(object == null);
            if (object != null) {
                if (object instanceof InputStream) {
                    inputStream = (InputStream)object;
                } else {
                    Datum datum = this.getRowBufferDatumAt(n2);
                    inputStream = datum.asciiStreamValue();
                }
            }
        } else {
            this.setIsNull(4);
            inputStream = this.resultSet.getAsciiStream(n2 + 1);
        }
        return inputStream;
    }

    public synchronized BFILE getBFILE(int n2) throws SQLException {
        BFILE bFILE = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Datum datum = this.getRowBufferDatumAt(n2);
            this.setIsNull(datum == null);
            if (datum != null && !(datum instanceof BFILE)) {
                DatabaseError.throwSqlException(4, "getBFILE");
            }
            bFILE = (BFILE)datum;
        } else {
            this.setIsNull(4);
            bFILE = this.resultSet.getBFILE(n2 + 1);
        }
        return bFILE;
    }

    public synchronized BLOB getBLOB(int n2) throws SQLException {
        BLOB bLOB = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Datum datum = this.getRowBufferDatumAt(n2);
            this.setIsNull(datum == null);
            if (datum != null && !(datum instanceof BLOB)) {
                DatabaseError.throwSqlException(4, "getBLOB");
            }
            bLOB = (BLOB)datum;
        } else {
            this.setIsNull(4);
            bLOB = this.resultSet.getBLOB(n2 + 1);
        }
        return bLOB;
    }

    public synchronized BFILE getBfile(int n2) throws SQLException {
        return this.getBFILE(n2);
    }

    public synchronized BigDecimal getBigDecimal(int n2) throws SQLException {
        BigDecimal bigDecimal = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Datum datum = this.getRowBufferDatumAt(n2);
            this.setIsNull(datum == null);
            if (datum != null) {
                bigDecimal = datum.bigDecimalValue();
            }
        } else {
            this.setIsNull(4);
            bigDecimal = this.resultSet.getBigDecimal(n2 + 1);
        }
        return bigDecimal;
    }

    public synchronized BigDecimal getBigDecimal(int n2, int n3) throws SQLException {
        BigDecimal bigDecimal = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Datum datum = this.getRowBufferDatumAt(n2);
            this.setIsNull(datum == null);
            if (datum != null) {
                bigDecimal = datum.bigDecimalValue();
            }
        } else {
            this.setIsNull(4);
            bigDecimal = this.resultSet.getBigDecimal(n2 + 1);
        }
        return bigDecimal;
    }

    public synchronized InputStream getBinaryStream(int n2) throws SQLException {
        InputStream inputStream = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Object object = this.getRowBufferAt(n2);
            this.setIsNull(object == null);
            if (object != null) {
                if (object instanceof InputStream) {
                    inputStream = (InputStream)object;
                } else {
                    Datum datum = this.getRowBufferDatumAt(n2);
                    inputStream = datum.binaryStreamValue();
                }
            }
        } else {
            this.setIsNull(4);
            inputStream = this.resultSet.getBinaryStream(n2 + 1);
        }
        return inputStream;
    }

    public synchronized Blob getBlob(int n2) throws SQLException {
        return this.getBLOB(n2);
    }

    public synchronized boolean getBoolean(int n2) throws SQLException {
        boolean bl2 = false;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Datum datum = this.getRowBufferDatumAt(n2);
            this.setIsNull(datum == null);
            if (datum != null) {
                bl2 = datum.booleanValue();
            }
        } else {
            this.setIsNull(4);
            bl2 = this.resultSet.getBoolean(n2 + 1);
        }
        return bl2;
    }

    public synchronized byte getByte(int n2) throws SQLException {
        byte by = 0;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Datum datum = this.getRowBufferDatumAt(n2);
            this.setIsNull(datum == null);
            if (datum != null) {
                by = datum.byteValue();
            }
        } else {
            this.setIsNull(4);
            by = this.resultSet.getByte(n2 + 1);
        }
        return by;
    }

    public synchronized byte[] getBytes(int n2) throws SQLException {
        byte[] byArray = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Datum datum = this.getRowBufferDatumAt(n2);
            this.setIsNull(datum == null);
            if (datum != null) {
                byArray = datum.getBytes();
            }
        } else {
            this.setIsNull(4);
            byArray = this.resultSet.getBytes(n2 + 1);
        }
        return byArray;
    }

    public synchronized CHAR getCHAR(int n2) throws SQLException {
        CHAR cHAR = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Datum datum = this.getRowBufferDatumAt(n2);
            this.setIsNull(datum == null);
            if (datum != null && !(datum instanceof CHAR)) {
                DatabaseError.throwSqlException(4, "getCHAR");
            }
            cHAR = (CHAR)datum;
        } else {
            this.setIsNull(4);
            cHAR = this.resultSet.getCHAR(n2 + 1);
        }
        return cHAR;
    }

    public synchronized CLOB getCLOB(int n2) throws SQLException {
        CLOB cLOB = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Datum datum = this.getRowBufferDatumAt(n2);
            this.setIsNull(datum == null);
            if (datum != null && !(datum instanceof CLOB)) {
                DatabaseError.throwSqlException(4, "getCLOB");
            }
            cLOB = (CLOB)datum;
        } else {
            this.setIsNull(4);
            cLOB = this.resultSet.getCLOB(n2 + 1);
        }
        return cLOB;
    }

    public synchronized Reader getCharacterStream(int n2) throws SQLException {
        Reader reader = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Object object = this.getRowBufferAt(n2);
            this.setIsNull(object == null);
            if (object != null) {
                if (object instanceof Reader) {
                    reader = (Reader)object;
                } else {
                    Datum datum = this.getRowBufferDatumAt(n2);
                    reader = datum.characterStreamValue();
                }
            }
        } else {
            this.setIsNull(4);
            reader = this.resultSet.getCharacterStream(n2 + 1);
        }
        return reader;
    }

    public synchronized Clob getClob(int n2) throws SQLException {
        return this.getCLOB(n2);
    }

    int getColumnCount() throws SQLException {
        if (this.columnCount == 0) {
            this.columnCount = this.resultSet instanceof OracleResultSetImpl ? (((OracleResultSetImpl)this.resultSet).statement.accessors != null ? ((OracleResultSetImpl)this.resultSet).statement.numberOfDefinePositions : this.getInternalMetadata().getColumnCount()) : ((ScrollableResultSet)this.resultSet).getColumnCount();
        }
        return this.columnCount;
    }

    public int getConcurrency() throws SQLException {
        return 1008;
    }

    public synchronized ResultSet getCursor(int n2) throws SQLException {
        ResultSet resultSet = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Datum datum = this.getOracleObject(n2);
            this.setIsNull(datum == null);
            DatabaseError.throwSqlException(4, "getCursor");
        } else {
            this.setIsNull(4);
            resultSet = this.resultSet.getCursor(n2 + 1);
        }
        return resultSet;
    }

    public synchronized CustomDatum getCustomDatum(int n2, CustomDatumFactory customDatumFactory) throws SQLException {
        if (customDatumFactory == null) {
            DatabaseError.throwSqlException(68);
        }
        CustomDatum customDatum = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Datum datum = this.getRowBufferDatumAt(n2);
            this.setIsNull(datum == null);
            customDatum = customDatumFactory.create(datum, 0);
        } else {
            this.setIsNull(4);
            customDatum = this.resultSet.getCustomDatum(n2 + 1, customDatumFactory);
        }
        return customDatum;
    }

    public synchronized DATE getDATE(int n2) throws SQLException {
        DATE dATE = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Datum datum = this.getRowBufferDatumAt(n2);
            this.setIsNull(datum == null);
            if (datum != null && !(datum instanceof DATE)) {
                DatabaseError.throwSqlException(4, "getDATE");
            }
            dATE = (DATE)datum;
        } else {
            this.setIsNull(4);
            dATE = this.resultSet.getDATE(n2 + 1);
        }
        return dATE;
    }

    public synchronized Date getDate(int n2) throws SQLException {
        Date date = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Datum datum = this.getRowBufferDatumAt(n2);
            this.setIsNull(datum == null);
            if (datum != null) {
                date = datum.dateValue();
            }
        } else {
            this.setIsNull(4);
            date = this.resultSet.getDate(n2 + 1);
        }
        return date;
    }

    public synchronized Date getDate(int n2, Calendar calendar) throws SQLException {
        Date date = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Datum datum = this.getOracleObject(n2);
            this.setIsNull(datum == null);
            if (datum != null) {
                if (datum instanceof DATE) {
                    date = ((DATE)datum).dateValue(calendar);
                } else {
                    DATE dATE = new DATE(datum.stringValue());
                    if (dATE != null) {
                        date = dATE.dateValue(calendar);
                    }
                }
            }
        } else {
            this.setIsNull(4);
            date = this.resultSet.getDate(n2 + 1, calendar);
        }
        return date;
    }

    public synchronized double getDouble(int n2) throws SQLException {
        double d2 = 0.0;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Datum datum = this.getRowBufferDatumAt(n2);
            this.setIsNull(datum == null);
            if (datum != null) {
                d2 = datum.doubleValue();
            }
        } else {
            this.setIsNull(4);
            d2 = this.resultSet.getDouble(n2 + 1);
        }
        return d2;
    }

    public synchronized int getFetchDirection() throws SQLException {
        return this.resultSet.getFetchDirection();
    }

    public synchronized int getFetchSize() throws SQLException {
        return this.resultSet.getFetchSize();
    }

    int getFirstUserColumnIndex() {
        return 1;
    }

    public synchronized float getFloat(int n2) throws SQLException {
        float f2 = 0.0f;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Datum datum = this.getRowBufferDatumAt(n2);
            this.setIsNull(datum == null);
            if (datum != null) {
                f2 = datum.floatValue();
            }
        } else {
            this.setIsNull(4);
            f2 = this.resultSet.getFloat(n2 + 1);
        }
        return f2;
    }

    public synchronized INTERVALDS getINTERVALDS(int n2) throws SQLException {
        INTERVALDS iNTERVALDS = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Datum datum = this.getRowBufferDatumAt(n2);
            this.setIsNull(datum == null);
            if (datum != null && !(datum instanceof INTERVALDS)) {
                DatabaseError.throwSqlException(4, "getINTERVALDS");
            }
            iNTERVALDS = (INTERVALDS)datum;
        } else {
            this.setIsNull(4);
            iNTERVALDS = this.resultSet.getINTERVALDS(n2 + 1);
        }
        return iNTERVALDS;
    }

    public synchronized INTERVALYM getINTERVALYM(int n2) throws SQLException {
        INTERVALYM iNTERVALYM = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Datum datum = this.getRowBufferDatumAt(n2);
            this.setIsNull(datum == null);
            if (datum != null && !(datum instanceof INTERVALYM)) {
                DatabaseError.throwSqlException(4, "getINTERVALYM");
            }
            iNTERVALYM = (INTERVALYM)datum;
        } else {
            this.setIsNull(4);
            iNTERVALYM = this.resultSet.getINTERVALYM(n2 + 1);
        }
        return iNTERVALYM;
    }

    public synchronized int getInt(int n2) throws SQLException {
        int n3 = 0;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Datum datum = this.getRowBufferDatumAt(n2);
            this.setIsNull(datum == null);
            if (datum != null) {
                n3 = datum.intValue();
            }
        } else {
            this.setIsNull(4);
            n3 = this.resultSet.getInt(n2 + 1);
        }
        return n3;
    }

    ResultSetMetaData getInternalMetadata() throws SQLException {
        if (this.rsetMetaData == null) {
            this.rsetMetaData = this.resultSet.getMetaData();
        }
        return this.rsetMetaData;
    }

    public synchronized long getLong(int n2) throws SQLException {
        long l2 = 0L;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Datum datum = this.getRowBufferDatumAt(n2);
            this.setIsNull(datum == null);
            if (datum != null) {
                l2 = datum.longValue();
            }
        } else {
            this.setIsNull(4);
            l2 = this.resultSet.getLong(n2 + 1);
        }
        return l2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ResultSetMetaData getMetaData() throws SQLException {
        if (((OracleStatement)this.scrollStmt).closed) {
            DatabaseError.throwSqlException(9, "getMetaData");
        }
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            UpdatableResultSet updatableResultSet = this;
            synchronized (updatableResultSet) {
                return new OracleResultSetMetaData(this.connection, (OracleStatement)this.scrollStmt, 1);
            }
        }
    }

    public synchronized NUMBER getNUMBER(int n2) throws SQLException {
        NUMBER nUMBER = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Datum datum = this.getRowBufferDatumAt(n2);
            this.setIsNull(datum == null);
            if (datum != null && !(datum instanceof NUMBER)) {
                DatabaseError.throwSqlException(4, "getNUMBER");
            }
            nUMBER = (NUMBER)datum;
        } else {
            this.setIsNull(4);
            nUMBER = this.resultSet.getNUMBER(n2 + 1);
        }
        return nUMBER;
    }

    private int getNumColumnsChanged() throws SQLException {
        int n2 = 0;
        if (this.indexColsChanged == null) {
            this.indexColsChanged = new int[this.getColumnCount()];
        }
        if (this.rowBuffer != null) {
            int n3 = 1;
            while (n3 < this.getColumnCount()) {
                if (this.rowBuffer[n3] != null || this.rowBuffer[n3] == null && this.m_nullIndicator[n3]) {
                    this.indexColsChanged[n2++] = n3;
                }
                ++n3;
            }
        }
        return n2;
    }

    public synchronized OPAQUE getOPAQUE(int n2) throws SQLException {
        OPAQUE oPAQUE = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Datum datum = this.getRowBufferDatumAt(n2);
            this.setIsNull(datum == null);
            if (datum != null && !(datum instanceof OPAQUE)) {
                DatabaseError.throwSqlException(4, "getOPAQUE");
            }
            oPAQUE = (OPAQUE)datum;
        } else {
            this.setIsNull(4);
            oPAQUE = this.resultSet.getOPAQUE(n2 + 1);
        }
        return oPAQUE;
    }

    public synchronized ORAData getORAData(int n2, ORADataFactory oRADataFactory) throws SQLException {
        if (oRADataFactory == null) {
            DatabaseError.throwSqlException(68);
        }
        ORAData oRAData = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Datum datum = this.getRowBufferDatumAt(n2);
            this.setIsNull(datum == null);
            oRAData = oRADataFactory.create(datum, 0);
        } else {
            this.setIsNull(4);
            oRAData = this.resultSet.getORAData(n2 + 1, oRADataFactory);
        }
        return oRAData;
    }

    public synchronized Object getObject(int n2) throws SQLException {
        Object object = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Datum datum = this.getOracleObject(n2);
            this.setIsNull(datum == null);
            if (datum != null) {
                object = datum.toJdbc();
            }
        } else {
            this.setIsNull(4);
            object = this.resultSet.getObject(n2 + 1);
        }
        return object;
    }

    public synchronized Object getObject(int n2, Map map) throws SQLException {
        Object object = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Datum datum = this.getOracleObject(n2);
            this.setIsNull(datum == null);
            if (datum != null) {
                object = datum instanceof STRUCT ? ((STRUCT)datum).toJdbc(map) : datum.toJdbc();
            }
        } else {
            this.setIsNull(4);
            object = this.resultSet.getObject(n2 + 1, map);
        }
        return object;
    }

    public synchronized Datum getOracleObject(int n2) throws SQLException {
        Datum datum = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            this.setIsNull(datum == null);
            datum = this.getRowBufferDatumAt(n2);
        } else {
            this.setIsNull(4);
            datum = this.resultSet.getOracleObject(n2 + 1);
        }
        return datum;
    }

    public synchronized RAW getRAW(int n2) throws SQLException {
        RAW rAW = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Datum datum = this.getRowBufferDatumAt(n2);
            this.setIsNull(datum == null);
            if (datum != null && !(datum instanceof RAW)) {
                DatabaseError.throwSqlException(4, "getRAW");
            }
            rAW = (RAW)datum;
        } else {
            this.setIsNull(4);
            rAW = this.resultSet.getRAW(n2 + 1);
        }
        return rAW;
    }

    public synchronized REF getREF(int n2) throws SQLException {
        REF rEF = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Datum datum = this.getRowBufferDatumAt(n2);
            this.setIsNull(datum == null);
            if (datum != null && !(datum instanceof REF)) {
                DatabaseError.throwSqlException(4, "getREF");
            }
            rEF = (REF)datum;
        } else {
            this.setIsNull(4);
            rEF = this.resultSet.getREF(n2 + 1);
        }
        return rEF;
    }

    public synchronized ROWID getROWID(int n2) throws SQLException {
        ROWID rOWID = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Datum datum = this.getRowBufferDatumAt(n2);
            this.setIsNull(datum == null);
            if (datum != null && !(datum instanceof ROWID)) {
                DatabaseError.throwSqlException(4, "getROWID");
            }
            rOWID = (ROWID)datum;
        } else {
            this.setIsNull(4);
            rOWID = this.resultSet.getROWID(n2 + 1);
        }
        return rOWID;
    }

    public synchronized Ref getRef(int n2) throws SQLException {
        return this.getREF(n2);
    }

    public synchronized int getRow() throws SQLException {
        return this.resultSet.getRow();
    }

    private Object getRowBufferAt(int n2) throws SQLException {
        if (n2 < 1 || n2 > this.getColumnCount() - 1) {
            DatabaseError.throwSqlException(68, "getRowBufferDatumAt");
        }
        if (this.rowBuffer != null) {
            return this.rowBuffer[n2];
        }
        return null;
    }

    private Datum getRowBufferDatumAt(int n2) throws SQLException {
        Object object;
        if (n2 < 1 || n2 > this.getColumnCount() - 1) {
            DatabaseError.throwSqlException(68, "getRowBufferDatumAt");
        }
        Datum datum = null;
        if (this.rowBuffer != null && (object = this.rowBuffer[n2]) != null) {
            if (object instanceof Datum) {
                datum = (Datum)object;
            } else {
                OracleResultSetMetaData oracleResultSetMetaData = (OracleResultSetMetaData)this.getInternalMetadata();
                int n3 = n2 + 1;
                datum = SQLUtil.makeOracleDatum(this.connection, object, oracleResultSetMetaData.getColumnType(n3), null, oracleResultSetMetaData.isNCHAR(n3));
                this.rowBuffer[n2] = datum;
            }
        }
        return datum;
    }

    public synchronized STRUCT getSTRUCT(int n2) throws SQLException {
        STRUCT sTRUCT = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Datum datum = this.getRowBufferDatumAt(n2);
            this.setIsNull(datum == null);
            if (datum != null && !(datum instanceof STRUCT)) {
                DatabaseError.throwSqlException(4, "getSTRUCT");
            }
            sTRUCT = (STRUCT)datum;
        } else {
            this.setIsNull(4);
            sTRUCT = this.resultSet.getSTRUCT(n2 + 1);
        }
        return sTRUCT;
    }

    public synchronized short getShort(int n2) throws SQLException {
        short s2 = 0;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            long l2 = this.getLong(n2);
            if (l2 > 65537L || l2 < -65538L) {
                DatabaseError.throwSqlException(26, "getShort");
            }
            s2 = (short)l2;
        } else {
            this.setIsNull(4);
            s2 = this.resultSet.getShort(n2 + 1);
        }
        return s2;
    }

    public synchronized Statement getStatement() throws SQLException {
        return (Statement)((Object)this.scrollStmt);
    }

    public synchronized String getString(int n2) throws SQLException {
        String string = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Datum datum = this.getRowBufferDatumAt(n2);
            this.setIsNull(datum == null);
            if (datum != null) {
                string = datum.stringValue();
            }
        } else {
            this.setIsNull(4);
            string = this.resultSet.getString(n2 + 1);
        }
        return string;
    }

    public synchronized TIMESTAMP getTIMESTAMP(int n2) throws SQLException {
        TIMESTAMP tIMESTAMP = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Datum datum = this.getRowBufferDatumAt(n2);
            this.setIsNull(datum == null);
            if (datum != null && !(datum instanceof TIMESTAMP)) {
                DatabaseError.throwSqlException(4, "getTIMESTAMP");
            }
            tIMESTAMP = (TIMESTAMP)datum;
        } else {
            this.setIsNull(4);
            tIMESTAMP = this.resultSet.getTIMESTAMP(n2 + 1);
        }
        return tIMESTAMP;
    }

    public synchronized TIMESTAMPLTZ getTIMESTAMPLTZ(int n2) throws SQLException {
        TIMESTAMPLTZ tIMESTAMPLTZ = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Datum datum = this.getRowBufferDatumAt(n2);
            this.setIsNull(datum == null);
            if (datum != null && !(datum instanceof TIMESTAMPLTZ)) {
                DatabaseError.throwSqlException(4, "getTIMESTAMPLTZ");
            }
            tIMESTAMPLTZ = (TIMESTAMPLTZ)datum;
        } else {
            this.setIsNull(4);
            tIMESTAMPLTZ = this.resultSet.getTIMESTAMPLTZ(n2 + 1);
        }
        return tIMESTAMPLTZ;
    }

    public synchronized TIMESTAMPTZ getTIMESTAMPTZ(int n2) throws SQLException {
        TIMESTAMPTZ tIMESTAMPTZ = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Datum datum = this.getRowBufferDatumAt(n2);
            this.setIsNull(datum == null);
            if (datum != null && !(datum instanceof TIMESTAMPTZ)) {
                DatabaseError.throwSqlException(4, "getTIMESTAMPTZ");
            }
            tIMESTAMPTZ = (TIMESTAMPTZ)datum;
        } else {
            this.setIsNull(4);
            tIMESTAMPTZ = this.resultSet.getTIMESTAMPTZ(n2 + 1);
        }
        return tIMESTAMPTZ;
    }

    public synchronized Time getTime(int n2) throws SQLException {
        Time time = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Datum datum = this.getRowBufferDatumAt(n2);
            this.setIsNull(datum == null);
            if (datum != null) {
                time = datum.timeValue();
            }
        } else {
            this.setIsNull(4);
            time = this.resultSet.getTime(n2 + 1);
        }
        return time;
    }

    public synchronized Time getTime(int n2, Calendar calendar) throws SQLException {
        Time time = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Datum datum = this.getOracleObject(n2);
            this.setIsNull(datum == null);
            if (datum != null) {
                if (datum instanceof DATE) {
                    time = ((DATE)datum).timeValue(calendar);
                } else {
                    DATE dATE = new DATE(datum.stringValue());
                    if (dATE != null) {
                        time = dATE.timeValue(calendar);
                    }
                }
            }
        } else {
            this.setIsNull(4);
            time = this.resultSet.getTime(n2 + 1, calendar);
        }
        return time;
    }

    public synchronized Timestamp getTimestamp(int n2) throws SQLException {
        Timestamp timestamp = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Datum datum = this.getRowBufferDatumAt(n2);
            this.setIsNull(datum == null);
            if (datum != null) {
                timestamp = datum.timestampValue();
            }
        } else {
            this.setIsNull(4);
            timestamp = this.resultSet.getTimestamp(n2 + 1);
        }
        return timestamp;
    }

    public synchronized Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        Timestamp timestamp = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Datum datum = this.getOracleObject(n2);
            this.setIsNull(datum == null);
            if (datum != null) {
                if (datum instanceof DATE) {
                    timestamp = ((DATE)datum).timestampValue(calendar);
                } else {
                    DATE dATE = new DATE(datum.stringValue());
                    if (dATE != null) {
                        timestamp = dATE.timestampValue(calendar);
                    }
                }
            }
        } else {
            this.setIsNull(4);
            timestamp = this.resultSet.getTimestamp(n2 + 1, calendar);
        }
        return timestamp;
    }

    public int getType() throws SQLException {
        return this.rsetType;
    }

    public synchronized URL getURL(int n2) throws SQLException {
        URL uRL = null;
        int n3 = this.getInternalMetadata().getColumnType(n2);
        int n4 = SQLUtil.getInternalType(n3);
        if (n4 == 96 || n4 == 1 || n4 == 8) {
            try {
                uRL = new URL(this.getString(n2));
            }
            catch (MalformedURLException malformedURLException) {
                DatabaseError.throwSqlException(136);
            }
        } else {
            throw new SQLException("Conversion to java.net.URL not supported.");
        }
        return uRL;
    }

    public synchronized InputStream getUnicodeStream(int n2) throws SQLException {
        InputStream inputStream = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Object object = this.getRowBufferAt(n2);
            this.setIsNull(object == null);
            if (object != null) {
                if (object instanceof InputStream) {
                    inputStream = (InputStream)object;
                } else {
                    Datum datum = this.getRowBufferDatumAt(n2);
                    DBConversion dBConversion = this.connection.conversion;
                    byte[] byArray = datum.shareBytes();
                    if (datum instanceof RAW) {
                        inputStream = dBConversion.ConvertStream(new ByteArrayInputStream(byArray), 3);
                    } else if (datum instanceof CHAR) {
                        inputStream = dBConversion.ConvertStream(new ByteArrayInputStream(byArray), 1);
                    } else {
                        DatabaseError.throwSqlException(4, "getUnicodeStream");
                    }
                }
            }
        } else {
            this.setIsNull(4);
            inputStream = this.resultSet.getUnicodeStream(n2 + 1);
        }
        return inputStream;
    }

    public SQLWarning getWarnings() throws SQLException {
        SQLWarning sQLWarning = this.resultSet.getWarnings();
        if (this.sqlWarning == null) {
            return sQLWarning;
        }
        SQLWarning sQLWarning2 = this.sqlWarning;
        while (sQLWarning2.getNextWarning() != null) {
            sQLWarning2 = sQLWarning2.getNextWarning();
        }
        sQLWarning2.setNextWarning(sQLWarning);
        return this.sqlWarning;
    }

    private void init(ScrollRsetStatement scrollRsetStatement, OracleResultSet oracleResultSet, int n2, int n3) throws SQLException {
        if (scrollRsetStatement == null || oracleResultSet == null || n3 != 1008) {
            DatabaseError.throwSqlException(68);
        }
        this.connection = ((OracleStatement)scrollRsetStatement).connection;
        this.resultSet = oracleResultSet;
        this.scrollStmt = scrollRsetStatement;
        this.rsetType = n2;
        this.autoRefetch = scrollRsetStatement.getAutoRefetch();
        this.deleteStmt = null;
        this.insertStmt = null;
        this.updateStmt = null;
        this.indexColsChanged = null;
        this.rowBuffer = null;
        this.m_nullIndicator = null;
        this.typeInfo = null;
        this.isInserting = false;
        this.isUpdating = false;
        this.wasNull = -1;
        this.rsetMetaData = null;
        this.columnCount = 0;
    }

    public synchronized void insertRow() throws SQLException {
        if (!this.isOnInsertRow()) {
            DatabaseError.throwSqlException(83);
        }
        this.prepareInsertRowStatement();
        this.prepareInsertRowBinds();
        this.executeInsertRow();
    }

    public synchronized boolean isAfterLast() throws SQLException {
        return this.resultSet.isAfterLast();
    }

    public synchronized boolean isBeforeFirst() throws SQLException {
        return this.resultSet.isBeforeFirst();
    }

    public synchronized boolean isFirst() throws SQLException {
        return this.resultSet.isFirst();
    }

    public synchronized boolean isLast() throws SQLException {
        return this.resultSet.isLast();
    }

    boolean isOnInsertRow() {
        return this.isInserting;
    }

    private boolean isRowBufferUpdatedAt(int n2) {
        if (this.rowBuffer == null) {
            return false;
        }
        return this.rowBuffer[n2] != null || this.m_nullIndicator[n2];
    }

    final boolean isStreamType(int n2) {
        return n2 == 2004 || n2 == 2005 || n2 == -4 || n2 == -1;
    }

    boolean isUpdatingRow() {
        return this.isUpdating;
    }

    public synchronized boolean last() throws SQLException {
        this.cancelRowChanges();
        return this.resultSet.last();
    }

    public synchronized void moveToCurrentRow() throws SQLException {
        this.cancelRowInserts();
    }

    public synchronized void moveToInsertRow() throws SQLException {
        if (this.isOnInsertRow()) {
            return;
        }
        this.isInserting = true;
        if (this.rowBuffer == null) {
            this.rowBuffer = new Object[this.getColumnCount()];
        }
        if (this.m_nullIndicator == null) {
            this.m_nullIndicator = new boolean[this.getColumnCount()];
        }
        this.clearRowBuffer();
    }

    public synchronized boolean next() throws SQLException {
        this.cancelRowChanges();
        return this.resultSet.next();
    }

    private int prepareCompareSelfBinds(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
        Datum datum = this.resultSet.getOracleObject(1);
        oraclePreparedStatement.setOracleObject(n2, this.resultSet.getOracleObject(1));
        return n2 + 1;
    }

    private void prepareDeleteRowBinds() throws SQLException {
        int n2 = 1;
        n2 = this.prepareSubqueryBinds(this.deleteStmt, n2);
        this.prepareCompareSelfBinds(this.deleteStmt, n2);
    }

    private void prepareDeleteRowStatement() throws SQLException {
        if (this.deleteStmt == null) {
            StringBuffer stringBuffer = new StringBuffer();
            this.deleteStmt = (OraclePreparedStatement)this.connection.prepareStatement(((OracleStatement)this.scrollStmt).sqlObject.getDeleteSqlForUpdatableResultSet(this));
            this.deleteStmt.setQueryTimeout(((Statement)((Object)this.scrollStmt)).getQueryTimeout());
        }
    }

    private void prepareInsertRowBinds() throws SQLException {
        int n2 = 1;
        n2 = this.prepareSubqueryBinds(this.insertStmt, n2);
        OracleResultSetMetaData oracleResultSetMetaData = (OracleResultSetMetaData)this.getInternalMetadata();
        int n3 = 1;
        while (n3 < this.getColumnCount()) {
            Object object = this.getRowBufferAt(n3);
            if (object != null) {
                if (object instanceof Reader) {
                    this.insertStmt.setCharacterStream(n2 + n3 - 1, (Reader)object, this.typeInfo[n3][0]);
                } else if (object instanceof InputStream) {
                    if (this.typeInfo[n3][1] == 2) {
                        this.insertStmt.setBinaryStream(n2 + n3 - 1, (InputStream)object, this.typeInfo[n3][0]);
                    } else if (this.typeInfo[n3][1] == 1) {
                        this.insertStmt.setAsciiStream(n2 + n3 - 1, (InputStream)object, this.typeInfo[n3][0]);
                    }
                } else {
                    Datum datum = this.getRowBufferDatumAt(n3);
                    if (oracleResultSetMetaData.isNCHAR(n3 + 1)) {
                        this.insertStmt.setFormOfUse(n2 + n3 - 1, (short)2);
                    }
                    this.insertStmt.setOracleObject(n2 + n3 - 1, datum);
                }
            } else {
                int n4 = this.getInternalMetadata().getColumnType(n3 + 1);
                if (n4 == 2006 || n4 == 2002 || n4 == 2008 || n4 == 2007 || n4 == 2003) {
                    this.insertStmt.setNull(n2 + n3 - 1, n4, this.getInternalMetadata().getColumnTypeName(n3 + 1));
                } else {
                    this.insertStmt.setNull(n2 + n3 - 1, n4);
                }
            }
            ++n3;
        }
    }

    private void prepareInsertRowStatement() throws SQLException {
        if (this.insertStmt == null) {
            this.insertStmt = (OraclePreparedStatement)this.connection.prepareStatement(((OracleStatement)this.scrollStmt).sqlObject.getInsertSqlForUpdatableResultSet(this));
            this.insertStmt.setQueryTimeout(((Statement)((Object)this.scrollStmt)).getQueryTimeout());
        }
    }

    private int prepareSubqueryBinds(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
        int n3 = this.scrollStmt.copyBinds(oraclePreparedStatement, n2 - 1);
        return n3 + 1;
    }

    private void prepareUpdateRowBinds(int n2) throws SQLException {
        int n3 = 1;
        n3 = this.prepareSubqueryBinds(this.updateStmt, n3);
        OracleResultSetMetaData oracleResultSetMetaData = (OracleResultSetMetaData)this.getInternalMetadata();
        int n4 = 0;
        while (n4 < n2) {
            int n5 = this.indexColsChanged[n4];
            Object object = this.getRowBufferAt(n5);
            if (object != null) {
                if (object instanceof Reader) {
                    this.updateStmt.setCharacterStream(n3++, (Reader)object, this.typeInfo[n5][0]);
                } else if (object instanceof InputStream) {
                    if (this.typeInfo[n5][1] == 2) {
                        this.updateStmt.setBinaryStream(n3++, (InputStream)object, this.typeInfo[n5][0]);
                    } else if (this.typeInfo[n5][1] == 1) {
                        this.updateStmt.setAsciiStream(n3++, (InputStream)object, this.typeInfo[n5][0]);
                    }
                } else {
                    Datum datum = this.getRowBufferDatumAt(n5);
                    if (oracleResultSetMetaData.isNCHAR(n5 + 1)) {
                        this.updateStmt.setFormOfUse(n3, (short)2);
                    }
                    this.updateStmt.setOracleObject(n3++, datum);
                }
            } else {
                int n6 = this.getInternalMetadata().getColumnType(n5 + 1);
                if (n6 == 2006 || n6 == 2002 || n6 == 2008 || n6 == 2007 || n6 == 2003) {
                    this.updateStmt.setNull(n3++, n6, this.getInternalMetadata().getColumnTypeName(n5 + 1));
                } else {
                    this.updateStmt.setNull(n3++, n6);
                }
            }
            ++n4;
        }
        this.prepareCompareSelfBinds(this.updateStmt, n3);
    }

    private void prepareUpdateRowStatement(int n2) throws SQLException {
        if (this.updateStmt != null) {
            this.updateStmt.close();
        }
        this.updateStmt = (OraclePreparedStatement)this.connection.prepareStatement(((OracleStatement)this.scrollStmt).sqlObject.getUpdateSqlForUpdatableResultSet(this, n2, this.rowBuffer, this.indexColsChanged));
        this.updateStmt.setQueryTimeout(((Statement)((Object)this.scrollStmt)).getQueryTimeout());
    }

    public synchronized boolean previous() throws SQLException {
        this.cancelRowChanges();
        return this.resultSet.previous();
    }

    public synchronized void refreshRow() throws SQLException {
        if (this.isOnInsertRow()) {
            DatabaseError.throwSqlException(84);
        }
        this.resultSet.refreshRow();
    }

    public synchronized boolean relative(int n2) throws SQLException {
        this.cancelRowChanges();
        return this.resultSet.relative(n2);
    }

    public boolean rowDeleted() throws SQLException {
        return false;
    }

    public boolean rowInserted() throws SQLException {
        return false;
    }

    public boolean rowUpdated() throws SQLException {
        return false;
    }

    public synchronized void setFetchDirection(int n2) throws SQLException {
        this.resultSet.setFetchDirection(n2);
    }

    public synchronized void setFetchSize(int n2) throws SQLException {
        this.resultSet.setFetchSize(n2);
    }

    private void setIsNull(int n2) {
        this.wasNull = n2;
    }

    private void setIsNull(boolean bl2) {
        this.wasNull = bl2 ? 1 : 2;
    }

    private void setRowBufferAt(int n2, Object object, int[] nArray) throws SQLException {
        if (!this.isInserting) {
            if (this.isBeforeFirst() || this.isAfterLast() || this.getRow() == 0) {
                DatabaseError.throwSqlException(82);
            } else {
                this.isUpdating = true;
            }
        }
        if (n2 < 1 || n2 > this.getColumnCount() - 1) {
            DatabaseError.throwSqlException(68, "setRowBufferAt");
        }
        if (this.rowBuffer == null) {
            this.rowBuffer = new Object[this.getColumnCount()];
        }
        if (this.m_nullIndicator == null) {
            this.m_nullIndicator = new boolean[this.getColumnCount()];
            int n3 = 0;
            while (n3 < this.getColumnCount()) {
                this.m_nullIndicator[n3] = false;
                ++n3;
            }
        }
        if (nArray != null) {
            if (this.typeInfo == null) {
                this.typeInfo = new int[this.getColumnCount()][];
            }
            this.typeInfo[n2] = nArray;
        }
        this.rowBuffer[n2] = object;
        this.m_nullIndicator[n2] = object == null;
    }

    private void setRowBufferAt(int n2, Datum datum) throws SQLException {
        this.setRowBufferAt(n2, datum, null);
    }

    public void updateARRAY(int n2, ARRAY aRRAY) throws SQLException {
        this.updateOracleObject(n2, (Datum)aRRAY);
    }

    public void updateArray(int n2, Array array) throws SQLException {
        this.updateARRAY(n2, (ARRAY)array);
    }

    public void updateAsciiStream(int n2, InputStream inputStream, int n3) throws SQLException {
        int n4 = this.getInternalMetadata().getColumnType(1 + n2);
        if (inputStream != null && n3 > 0) {
            if (!this.isStreamType(n4)) {
                byte[] byArray = new byte[n3];
                try {
                    int n5 = inputStream.read(byArray);
                    inputStream.close();
                    String string = new String(byArray, 0, n5);
                    this.updateString(n2, string);
                }
                catch (IOException iOException) {
                    DatabaseError.throwSqlException(iOException);
                }
            } else {
                int[] nArray = new int[]{n3, 1};
                this.setRowBufferAt(n2, inputStream, nArray);
            }
        } else {
            this.setRowBufferAt(n2, null);
        }
    }

    public void updateBFILE(int n2, BFILE bFILE) throws SQLException {
        this.updateOracleObject(n2, (Datum)bFILE);
    }

    public void updateBLOB(int n2, BLOB bLOB) throws SQLException {
        this.updateOracleObject(n2, (Datum)bLOB);
    }

    public void updateBfile(int n2, BFILE bFILE) throws SQLException {
        this.updateOracleObject(n2, (Datum)bFILE);
    }

    public void updateBigDecimal(int n2, BigDecimal bigDecimal) throws SQLException {
        this.updateObject(n2, (Object)bigDecimal);
    }

    public void updateBinaryStream(int n2, InputStream inputStream, int n3) throws SQLException {
        int n4 = this.getInternalMetadata().getColumnType(1 + n2);
        if (inputStream != null && n3 > 0) {
            if (!this.isStreamType(n4)) {
                byte[] byArray = new byte[n3];
                try {
                    int n5 = inputStream.read(byArray);
                    inputStream.close();
                    this.updateBytes(n2, byArray);
                }
                catch (IOException iOException) {
                    DatabaseError.throwSqlException(iOException);
                }
            } else {
                int[] nArray = new int[]{n3, 2};
                this.setRowBufferAt(n2, inputStream, nArray);
            }
        } else {
            this.setRowBufferAt(n2, null);
        }
    }

    public void updateBlob(int n2, Blob blob) throws SQLException {
        this.updateBLOB(n2, (BLOB)blob);
    }

    public void updateBoolean(int n2, boolean bl2) throws SQLException {
        this.updateObject(n2, (Object)new Boolean(bl2));
    }

    public void updateByte(int n2, byte by) throws SQLException {
        this.updateObject(n2, (Object)new Integer(by));
    }

    public void updateBytes(int n2, byte[] byArray) throws SQLException {
        this.updateObject(n2, (Object)byArray);
    }

    public void updateCHAR(int n2, CHAR cHAR) throws SQLException {
        this.updateOracleObject(n2, (Datum)cHAR);
    }

    public void updateCLOB(int n2, CLOB cLOB) throws SQLException {
        this.updateOracleObject(n2, (Datum)cLOB);
    }

    public void updateCharacterStream(int n2, Reader reader, int n3) throws SQLException {
        int n4 = this.getInternalMetadata().getColumnType(1 + n2);
        if (reader != null && n3 > 0) {
            if (!this.isStreamType(n4)) {
                char[] cArray = new char[n3];
                try {
                    int n5 = reader.read(cArray);
                    reader.close();
                    this.updateString(n2, new String(cArray));
                }
                catch (IOException iOException) {
                    DatabaseError.throwSqlException(iOException);
                }
            } else {
                int[] nArray = new int[]{n3};
                this.setRowBufferAt(n2, reader, nArray);
            }
        } else {
            this.setRowBufferAt(n2, null);
        }
    }

    public void updateClob(int n2, Clob clob) throws SQLException {
        this.updateCLOB(n2, (CLOB)clob);
    }

    public void updateCustomDatum(int n2, CustomDatum customDatum) throws SQLException {
        throw new Error("wanna do datum = ((CustomDatum) x).toDatum(m_comm)");
    }

    public void updateDATE(int n2, DATE dATE) throws SQLException {
        this.updateOracleObject(n2, (Datum)dATE);
    }

    public void updateDate(int n2, Date date) throws SQLException {
        this.updateObject(n2, (Object)date);
    }

    public void updateDouble(int n2, double d2) throws SQLException {
        this.updateObject(n2, (Object)new Double(d2));
    }

    public void updateFloat(int n2, float f2) throws SQLException {
        this.updateObject(n2, (Object)new Float(f2));
    }

    public void updateINTERVALDS(int n2, INTERVALDS iNTERVALDS) throws SQLException {
        this.updateOracleObject(n2, (Datum)iNTERVALDS);
    }

    public void updateINTERVALYM(int n2, INTERVALYM iNTERVALYM) throws SQLException {
        this.updateOracleObject(n2, (Datum)iNTERVALYM);
    }

    public void updateInt(int n2, int n3) throws SQLException {
        this.updateObject(n2, (Object)new Integer(n3));
    }

    public void updateLong(int n2, long l2) throws SQLException {
        this.updateObject(n2, (Object)new Long(l2));
    }

    public void updateNUMBER(int n2, NUMBER nUMBER) throws SQLException {
        this.updateOracleObject(n2, (Datum)nUMBER);
    }

    public synchronized void updateNull(int n2) throws SQLException {
        this.setRowBufferAt(n2, null);
    }

    public void updateOPAQUE(int n2, OPAQUE oPAQUE) throws SQLException {
        this.updateOracleObject(n2, (Datum)oPAQUE);
    }

    public void updateORAData(int n2, ORAData oRAData) throws SQLException {
        Datum datum = oRAData.toDatum(this.connection);
        this.updateOracleObject(n2, datum);
    }

    public synchronized void updateObject(int n2, Object object) throws SQLException {
        Datum datum = null;
        if (object != null) {
            if (object instanceof Datum) {
                datum = (Datum)object;
            } else {
                OracleResultSetMetaData oracleResultSetMetaData = (OracleResultSetMetaData)this.getInternalMetadata();
                int n3 = n2 + 1;
                datum = SQLUtil.makeOracleDatum(this.connection, object, oracleResultSetMetaData.getColumnType(n3), null, oracleResultSetMetaData.isNCHAR(n3));
            }
        }
        this.setRowBufferAt(n2, datum);
    }

    public void updateObject(int n2, Object object, int n3) throws SQLException {
        this.updateObject(n2, object);
    }

    public synchronized void updateOracleObject(int n2, Datum datum) throws SQLException {
        this.setRowBufferAt(n2, datum);
    }

    public void updateRAW(int n2, RAW rAW) throws SQLException {
        this.updateOracleObject(n2, (Datum)rAW);
    }

    public void updateREF(int n2, REF rEF) throws SQLException {
        this.updateOracleObject(n2, (Datum)rEF);
    }

    public void updateROWID(int n2, ROWID rOWID) throws SQLException {
        this.updateOracleObject(n2, (Datum)rOWID);
    }

    public void updateRef(int n2, Ref ref) throws SQLException {
        this.updateREF(n2, (REF)ref);
    }

    public synchronized void updateRow() throws SQLException {
        int n2;
        if (this.isOnInsertRow()) {
            DatabaseError.throwSqlException(84);
        }
        if ((n2 = this.getNumColumnsChanged()) > 0) {
            this.prepareUpdateRowStatement(n2);
            this.prepareUpdateRowBinds(n2);
            this.executeUpdateRow();
        }
    }

    public void updateSTRUCT(int n2, STRUCT sTRUCT) throws SQLException {
        this.updateOracleObject(n2, (Datum)sTRUCT);
    }

    public void updateShort(int n2, short s2) throws SQLException {
        this.updateObject(n2, (Object)new Integer(s2));
    }

    public synchronized void updateString(int n2, String string) throws SQLException {
        this.updateObject(n2, (Object)string);
    }

    public void updateTIMESTAMP(int n2, TIMESTAMP tIMESTAMP) throws SQLException {
        this.updateOracleObject(n2, (Datum)tIMESTAMP);
    }

    public void updateTIMESTAMPLTZ(int n2, TIMESTAMPLTZ tIMESTAMPLTZ) throws SQLException {
        this.updateOracleObject(n2, (Datum)tIMESTAMPLTZ);
    }

    public void updateTIMESTAMPTZ(int n2, TIMESTAMPTZ tIMESTAMPTZ) throws SQLException {
        this.updateOracleObject(n2, (Datum)tIMESTAMPTZ);
    }

    public void updateTime(int n2, Time time) throws SQLException {
        this.updateObject(n2, (Object)time);
    }

    public void updateTimestamp(int n2, Timestamp timestamp) throws SQLException {
        this.updateObject(n2, (Object)timestamp);
    }

    public synchronized boolean wasNull() throws SQLException {
        switch (this.wasNull) {
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            case 4: {
                return this.resultSet.wasNull();
            }
        }
        DatabaseError.throwSqlException(24);
        return false;
    }
}

