/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.NodeMapException;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.TypeTreeElement;
import oracle.sql.Datum;
import oracle.sql.SQLName;
import oracle.sql.TypeDescriptor;

public abstract class OracleNamedType
extends OracleType
implements Serializable {
    transient OracleConnection connection;
    SQLName sqlName = null;
    transient OracleTypeADT parent = null;
    transient int idx;
    transient TypeDescriptor descriptor = null;
    static String getUserTypeTreeSql = "/*+ RULE */select level depth, parent_type, child_type, ATTR_NO, child_type_owner from  (select TYPE_NAME parent_type, ELEM_TYPE_NAME child_type, 0 ATTR_NO,       ELEM_TYPE_OWNER child_type_owner     from USER_COLL_TYPES  union   select TYPE_NAME parent_type, ATTR_TYPE_NAME child_type, ATTR_NO,       ATTR_TYPE_OWNER child_type_owner     from USER_TYPE_ATTRS  ) start with parent_type  = ?  connect by prior  child_type = parent_type";
    static String getAllTypeTreeSql = "/*+ RULE */select parent_type, parent_type_owner, child_type, ATTR_NO, child_type_owner from ( select TYPE_NAME parent_type,  OWNER parent_type_owner,     ELEM_TYPE_NAME child_type, 0 ATTR_NO,     ELEM_TYPE_OWNER child_type_owner   from ALL_COLL_TYPES union   select TYPE_NAME parent_type, OWNER parent_type_owner,     ATTR_TYPE_NAME child_type, ATTR_NO,     ATTR_TYPE_OWNER child_type_owner   from ALL_TYPE_ATTRS ) start with parent_type  = ?  and parent_type_owner = ? connect by prior child_type = parent_type   and ( child_type_owner = parent_type_owner or child_type_owner is null )";
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Jun_22_11:15:36_PDT_2005";

    protected OracleNamedType() {
    }

    public OracleNamedType(String string, OracleConnection oracleConnection) throws SQLException {
        this.setConnectionInternal(oracleConnection);
        this.sqlName = new SQLName(string, oracleConnection);
    }

    protected OracleNamedType(OracleTypeADT oracleTypeADT, int n2, OracleConnection oracleConnection) {
        this.setConnectionInternal(oracleConnection);
        this.parent = oracleTypeADT;
        this.idx = n2;
    }

    public Map createTypesTreeMap() throws SQLException {
        Map map = null;
        String string = this.connection.getUserName();
        if (this.sqlName.getSchema().equals(string)) {
            map = this.getNodeMapFromUserTypes();
        }
        if (map == null) {
            map = this.getNodeMapFromAllTypes();
        }
        return map;
    }

    public void fixupConnection(OracleConnection oracleConnection) throws SQLException {
        if (this.connection == null) {
            this.setConnection(oracleConnection);
        }
    }

    public OracleConnection getConnection() throws SQLException {
        return this.connection;
    }

    public TypeDescriptor getDescriptor() throws SQLException {
        return this.descriptor;
    }

    public String getFullName() throws SQLException {
        return this.getFullName(false);
    }

    public String getFullName(boolean bl2) throws SQLException {
        String string = null;
        if (bl2 | this.sqlName == null) {
            if (this.parent != null && (string = this.parent.getAttributeType(this.idx)) != null) {
                this.sqlName = new SQLName(string, this.connection);
            } else {
                DatabaseError.throwSqlException(1, "Unable to resolve name");
            }
        }
        return this.sqlName.getName();
    }

    Map getNodeMapFromAllTypes() throws SQLException {
        HashMap<SQLName, TypeTreeElement> hashMap = new HashMap<SQLName, TypeTreeElement>();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = this.connection.prepareStatement(getAllTypeTreeSql);
            preparedStatement.setString(1, this.sqlName.getSimpleName());
            preparedStatement.setString(2, this.sqlName.getSchema());
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string = resultSet.getString(1);
                String string2 = resultSet.getString(2);
                String string3 = resultSet.getString(3);
                int n2 = resultSet.getInt(4);
                String string4 = resultSet.getString(5);
                if (string4 == null) {
                    string4 = "SYS";
                }
                if (string.length() <= 0) continue;
                SQLName sQLName = new SQLName(string2, string, this.connection);
                TypeTreeElement typeTreeElement = null;
                if (hashMap.containsKey(sQLName)) {
                    typeTreeElement = (TypeTreeElement)hashMap.get(sQLName);
                } else {
                    typeTreeElement = new TypeTreeElement(string2, string);
                    hashMap.put(sQLName, typeTreeElement);
                }
                typeTreeElement.putChild(string4, string3, n2);
            }
        }
        finally {
            Object var5_11 = null;
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        return hashMap;
    }

    Map getNodeMapFromUserTypes() throws SQLException {
        PreparedStatement preparedStatement;
        HashMap<SQLName, TypeTreeElement> hashMap;
        block11: {
            hashMap = new HashMap<SQLName, TypeTreeElement>();
            preparedStatement = null;
            ResultSet resultSet = null;
            try {
                try {
                    preparedStatement = this.connection.prepareStatement(getUserTypeTreeSql);
                    preparedStatement.setString(1, this.sqlName.getSimpleName());
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        int n2 = resultSet.getInt(1);
                        String string = resultSet.getString(2);
                        String string2 = resultSet.getString(3);
                        int n3 = resultSet.getInt(4);
                        String string3 = resultSet.getString(5);
                        if (string3 != null && !string3.equals(this.sqlName.getSchema())) {
                            throw new NodeMapException();
                        }
                        if (string.length() <= 0) continue;
                        SQLName sQLName = new SQLName(this.sqlName.getSchema(), string, this.connection);
                        TypeTreeElement typeTreeElement = null;
                        if (hashMap.containsKey(sQLName)) {
                            typeTreeElement = (TypeTreeElement)hashMap.get(sQLName);
                        } else {
                            typeTreeElement = new TypeTreeElement(this.sqlName.getSchema(), string);
                            hashMap.put(sQLName, typeTreeElement);
                        }
                        typeTreeElement.putChild(this.sqlName.getSchema(), string2, n3);
                    }
                }
                catch (NodeMapException nodeMapException) {
                    hashMap = null;
                    nodeMapException.printStackTrace(System.err);
                }
                Object var5_12 = null;
                if (resultSet == null) break block11;
            }
            catch (Throwable throwable) {
                Object var5_13 = null;
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                throw throwable;
            }
            resultSet.close();
        }
        if (preparedStatement != null) {
            preparedStatement.close();
        }
        return hashMap;
    }

    public int getOrder() throws SQLException {
        return this.idx;
    }

    public OracleTypeADT getParent() throws SQLException {
        return this.parent;
    }

    public String getSchemaName() throws SQLException {
        if (this.sqlName == null) {
            this.getFullName();
        }
        return this.sqlName.getSchema();
    }

    public String getSimpleName() throws SQLException {
        if (this.sqlName == null) {
            this.getFullName();
        }
        return this.sqlName.getSimpleName();
    }

    public int getTypeVersion() {
        return 1;
    }

    public boolean hasName() throws SQLException {
        return this.sqlName != null;
    }

    public void initNamesRecursively() throws SQLException {
        Map map = this.createTypesTreeMap();
        if (map.size() > 0) {
            this.initChildNamesRecursively(map);
        }
    }

    public byte[] linearize(Datum datum) throws SQLException {
        DatabaseError.throwSqlException(23);
        return null;
    }

    public void printXML(PrintWriter printWriter, int n2) throws SQLException {
        int n3 = 0;
        while (n3 < n2) {
            printWriter.print("  ");
            ++n3;
        }
        printWriter.println("<OracleNamedType/>");
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        String string = objectInputStream.readUTF();
        try {
            this.sqlName = new SQLName(string, null);
        }
        catch (SQLException sQLException) {}
        this.parent = null;
        this.idx = -1;
    }

    public void setConnection(OracleConnection oracleConnection) throws SQLException {
        this.setConnectionInternal(oracleConnection);
    }

    public void setConnectionInternal(OracleConnection oracleConnection) {
        this.connection = oracleConnection;
    }

    public void setDescriptor(TypeDescriptor typeDescriptor) throws SQLException {
        this.descriptor = typeDescriptor;
    }

    public void setNames(String string, String string2) throws SQLException {
        this.sqlName = new SQLName(string, string2, this.connection);
    }

    public void setOrder(int n2) throws SQLException {
        this.idx = n2;
    }

    public void setParent(OracleTypeADT oracleTypeADT) throws SQLException {
        this.parent = oracleTypeADT;
    }

    public void setSqlName(SQLName sQLName) {
        this.sqlName = sQLName;
    }

    public Datum unlinearize(byte[] byArray, long l2, Datum datum, int n2, Map map) throws SQLException {
        DatabaseError.throwSqlException(23);
        return null;
    }

    public Datum unlinearize(byte[] byArray, long l2, Datum datum, long l3, int n2, int n3, Map map) throws SQLException {
        DatabaseError.throwSqlException(23);
        return null;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        try {
            objectOutputStream.writeUTF(this.getFullName());
        }
        catch (SQLException sQLException) {
            DatabaseError.SQLToIOException(sQLException);
        }
    }
}

