/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.UnpickleContext;
import oracle.sql.BLOB;
import oracle.sql.Datum;

public class OracleTypeBLOB
extends OracleType
implements Serializable {
    static final long serialVersionUID = -2311211431562030662L;
    static int fixedDataSize = 86;
    transient OracleConnection connection;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Jun_22_11:15:37_PDT_2005";

    protected OracleTypeBLOB() {
    }

    public OracleTypeBLOB(OracleConnection oracleConnection) {
        this.connection = oracleConnection;
    }

    public int getTypeCode() {
        return 2004;
    }

    protected static Object lobUnpickle80rec(OracleType oracleType, int n2, int n3, UnpickleContext unpickleContext, int n4, int n5, int n6) throws SQLException {
        switch (n4) {
            case 1: {
                if (unpickleContext.isNull(n2)) {
                    return null;
                }
                unpickleContext.skipTo(unpickleContext.ldsOffsets[n3]);
                if (n5 == 9) {
                    unpickleContext.skipBytes(4);
                    return null;
                }
                unpickleContext.markAndSkip();
                byte[] byArray = unpickleContext.readPtrBytes();
                unpickleContext.reset();
                return oracleType.toObject(byArray, n5, null);
            }
            case 2: {
                if ((unpickleContext.readByte() & 1) == 1) {
                    unpickleContext.skipPtrBytes();
                    return null;
                }
            }
            case 3: {
                long l2 = unpickleContext.offset() + n6;
                if (n5 == 9) {
                    unpickleContext.skipTo(l2);
                    return null;
                }
                byte[] byArray = unpickleContext.readPtrBytes();
                if ((long)unpickleContext.offset() < l2) {
                    unpickleContext.skipTo(l2);
                }
                return oracleType.toObject(byArray, n5, null);
            }
        }
        DatabaseError.throwSqlException(1, "format=" + n4);
        return null;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
    }

    public void setConnection(OracleConnection oracleConnection) throws SQLException {
        this.connection = oracleConnection;
    }

    public Datum toDatum(Object object, OracleConnection oracleConnection) throws SQLException {
        BLOB bLOB = null;
        if (object != null) {
            if (object instanceof BLOB) {
                bLOB = (BLOB)object;
            } else {
                DatabaseError.throwSqlException(59, object);
            }
        }
        return bLOB;
    }

    protected Object toObject(byte[] byArray, int n2, Map map) throws SQLException {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        switch (n2) {
            case 1: 
            case 2: {
                return this.connection.createBlob(byArray);
            }
            case 3: {
                return byArray;
            }
        }
        DatabaseError.throwSqlException(59, byArray);
        return null;
    }

    protected Object unpickle80rec(UnpickleContext unpickleContext, int n2, int n3, Map map) throws SQLException {
        return OracleTypeBLOB.lobUnpickle80rec(this, this.nullOffset, this.ldsOffset, unpickleContext, n2, n3, fixedDataSize);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
    }
}

