/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.PickleContext;
import oracle.jdbc.oracore.TDSReader;
import oracle.jdbc.oracore.UnpickleContext;
import oracle.sql.CHAR;
import oracle.sql.CharacterSet;
import oracle.sql.Datum;

public class OracleTypeCHAR
extends OracleType
implements Serializable {
    static final long serialVersionUID = -6899444518695804629L;
    int form;
    int charset;
    int length;
    int characterSemantic;
    private transient OracleConnection connection;
    private short pickleCharaterSetId;
    private transient CharacterSet pickleCharacterSet;
    private short pickleNcharCharacterSet;
    static final int SQLCS_IMPLICIT = 1;
    static final int SQLCS_NCHAR = 2;
    static final int SQLCS_EXPLICIT = 3;
    static final int SQLCS_FLEXIBLE = 4;
    static final int SQLCS_LIT_NULL = 5;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Jun_22_11:15:37_PDT_2005";

    protected OracleTypeCHAR() {
    }

    public OracleTypeCHAR(OracleConnection oracleConnection) {
        this.form = 0;
        this.charset = 0;
        this.length = 0;
        this.connection = oracleConnection;
        this.pickleCharaterSetId = 0;
        this.pickleNcharCharacterSet = 0;
        this.pickleCharacterSet = null;
        try {
            this.pickleCharaterSetId = this.connection.getStructAttrCsId();
        }
        catch (SQLException sQLException) {
            this.pickleCharaterSetId = (short)-1;
        }
        this.pickleCharacterSet = CharacterSet.make(this.pickleCharaterSetId);
    }

    protected OracleTypeCHAR(OracleConnection oracleConnection, int n2) {
        super(n2);
        this.form = 0;
        this.charset = 0;
        this.length = 0;
        this.connection = oracleConnection;
        this.pickleCharaterSetId = 0;
        this.pickleNcharCharacterSet = 0;
        this.pickleCharacterSet = null;
        try {
            this.pickleCharaterSetId = this.connection.getStructAttrCsId();
        }
        catch (SQLException sQLException) {
            this.pickleCharaterSetId = (short)-1;
        }
        this.pickleCharacterSet = CharacterSet.make(this.pickleCharaterSetId);
    }

    private Datum[] cArrayToDatumArray(Object object, OracleConnection oracleConnection, long l2, int n2) throws SQLException {
        Datum[] datumArray = null;
        if (object != null) {
            if (object instanceof char[][]) {
                char[][] cArray = (char[][])object;
                int n3 = (int)(n2 == -1 ? (long)cArray.length : Math.min((long)cArray.length - l2 + 1L, (long)n2));
                datumArray = new Datum[n3];
                int n4 = 0;
                while (n4 < n3) {
                    datumArray[n4] = new CHAR(new String(cArray[(int)l2 + n4 - 1]), this.pickleCharacterSet);
                    ++n4;
                }
            } else if (object instanceof boolean[]) {
                boolean[] blArray = (boolean[])object;
                int n5 = (int)(n2 == -1 ? (long)blArray.length : Math.min((long)blArray.length - l2 + 1L, (long)n2));
                datumArray = new Datum[n5];
                int n6 = 0;
                while (n6 < n5) {
                    datumArray[n6] = new CHAR(new Boolean(blArray[(int)l2 + n6 - 1]), this.pickleCharacterSet);
                    ++n6;
                }
            } else if (object instanceof short[]) {
                short[] sArray = (short[])object;
                int n7 = (int)(n2 == -1 ? (long)sArray.length : Math.min((long)sArray.length - l2 + 1L, (long)n2));
                datumArray = new Datum[n7];
                int n8 = 0;
                while (n8 < n7) {
                    datumArray[n8] = new CHAR(new Integer(sArray[(int)l2 + n8 - 1]), this.pickleCharacterSet);
                    ++n8;
                }
            } else if (object instanceof int[]) {
                int[] nArray = (int[])object;
                int n9 = (int)(n2 == -1 ? (long)nArray.length : Math.min((long)nArray.length - l2 + 1L, (long)n2));
                datumArray = new Datum[n9];
                int n10 = 0;
                while (n10 < n9) {
                    datumArray[n10] = new CHAR(new Integer(nArray[(int)l2 + n10 - 1]), this.pickleCharacterSet);
                    ++n10;
                }
            } else if (object instanceof long[]) {
                long[] lArray = (long[])object;
                int n11 = (int)(n2 == -1 ? (long)lArray.length : Math.min((long)lArray.length - l2 + 1L, (long)n2));
                datumArray = new Datum[n11];
                int n12 = 0;
                while (n12 < n11) {
                    datumArray[n12] = new CHAR(new Long(lArray[(int)l2 + n12 - 1]), this.pickleCharacterSet);
                    ++n12;
                }
            } else if (object instanceof float[]) {
                float[] fArray = (float[])object;
                int n13 = (int)(n2 == -1 ? (long)fArray.length : Math.min((long)fArray.length - l2 + 1L, (long)n2));
                datumArray = new Datum[n13];
                int n14 = 0;
                while (n14 < n13) {
                    datumArray[n14] = new CHAR(new Float(fArray[(int)l2 + n14 - 1]), this.pickleCharacterSet);
                    ++n14;
                }
            } else if (object instanceof double[]) {
                double[] dArray = (double[])object;
                int n15 = (int)(n2 == -1 ? (long)dArray.length : Math.min((long)dArray.length - l2 + 1L, (long)n2));
                datumArray = new Datum[n15];
                int n16 = 0;
                while (n16 < n15) {
                    datumArray[n16] = new CHAR(new Double(dArray[(int)l2 + n16 - 1]), this.pickleCharacterSet);
                    ++n16;
                }
            } else {
                DatabaseError.throwSqlException(59, object);
            }
        }
        return datumArray;
    }

    private CHAR getDbCHAR(Datum datum) {
        CHAR cHAR = (CHAR)datum;
        CHAR cHAR2 = null;
        if (cHAR.getCharacterSet().getOracleId() == this.pickleCharaterSetId) {
            cHAR2 = cHAR;
        } else {
            try {
                cHAR2 = new CHAR(cHAR.toString(), this.pickleCharacterSet);
            }
            catch (SQLException sQLException) {
                cHAR2 = cHAR;
            }
        }
        return cHAR2;
    }

    public int getLength() {
        return this.length;
    }

    public boolean isNCHAR() throws SQLException {
        return this.form == 2;
    }

    public void parseTDSrec(TDSReader tDSReader) throws SQLException {
        super.parseTDSrec(tDSReader);
        try {
            this.length = tDSReader.readShort();
            this.form = tDSReader.readByte();
            this.characterSemantic = this.form & 0x80;
            this.form &= 0x7F;
            this.charset = tDSReader.readShort();
        }
        catch (SQLException sQLException) {
            DatabaseError.throwSqlException(47, "parseTDS");
        }
        if (this.form != 2 || this.pickleNcharCharacterSet != 0) {
            return;
        }
        try {
            this.pickleNcharCharacterSet = this.connection.getStructAttrNCsId();
        }
        catch (SQLException sQLException) {
            this.pickleNcharCharacterSet = (short)2000;
        }
        this.pickleCharaterSetId = this.pickleNcharCharacterSet;
        this.pickleCharacterSet = CharacterSet.make(this.pickleCharaterSetId);
    }

    protected int pickle81(PickleContext pickleContext, Datum datum) throws SQLException {
        CHAR cHAR = this.getDbCHAR(datum);
        if (this.characterSemantic != 0 && this.form != 2) {
            if (cHAR.getString().length() > this.length) {
                DatabaseError.throwSqlException(72, "\"" + cHAR.getString() + "\"");
            }
        } else if (cHAR.getLength() > (long)this.length) {
            DatabaseError.throwSqlException(72, "\"" + cHAR.getString() + "\"");
        }
        return super.pickle81(pickleContext, cHAR);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.form = objectInputStream.readInt();
        this.charset = objectInputStream.readInt();
        this.length = objectInputStream.readInt();
        this.characterSemantic = objectInputStream.readInt();
        this.pickleCharaterSetId = objectInputStream.readShort();
        this.pickleNcharCharacterSet = objectInputStream.readShort();
        this.pickleCharacterSet = this.pickleNcharCharacterSet != 0 ? CharacterSet.make(this.pickleNcharCharacterSet) : CharacterSet.make(this.pickleCharaterSetId);
    }

    public void setConnection(OracleConnection oracleConnection) throws SQLException {
        this.connection = oracleConnection;
    }

    public Datum toDatum(Object object, OracleConnection oracleConnection) throws SQLException {
        if (object == null) {
            return null;
        }
        CHAR cHAR = object instanceof CHAR ? (CHAR)object : new CHAR(object, this.pickleCharacterSet);
        return cHAR;
    }

    public Datum[] toDatumArray(Object object, OracleConnection oracleConnection, long l2, int n2) throws SQLException {
        Datum[] datumArray = null;
        if (object != null) {
            if (object instanceof Object[] && !(object instanceof char[][])) {
                return super.toDatumArray(object, oracleConnection, l2, n2);
            }
            datumArray = this.cArrayToDatumArray(object, oracleConnection, l2, n2);
        }
        return datumArray;
    }

    protected Object toObject(byte[] byArray, int n2, Map map) throws SQLException {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        CHAR cHAR = null;
        switch (this.form) {
            case 1: 
            case 2: {
                cHAR = new CHAR(byArray, this.pickleCharacterSet);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                cHAR = new CHAR(byArray, null);
                break;
            }
        }
        if (n2 == 1) {
            return cHAR;
        }
        if (n2 == 2) {
            return cHAR.stringValue();
        }
        if (n2 == 3) {
            return byArray;
        }
        DatabaseError.throwSqlException(59, byArray);
        return null;
    }

    protected Object unpickle80rec(UnpickleContext unpickleContext, int n2, int n3, Map map) throws SQLException {
        switch (n2) {
            case 1: {
                if (unpickleContext.isNull(this.nullOffset)) {
                    return null;
                }
                unpickleContext.skipTo(unpickleContext.ldsOffsets[this.ldsOffset]);
                if (n3 == 9) {
                    unpickleContext.skipBytes(6);
                    return null;
                }
                long l2 = unpickleContext.readLong();
                if (l2 == 0L) {
                    unpickleContext.skipBytes(2);
                    unpickleContext.mark();
                } else {
                    unpickleContext.markAndSkip(l2);
                }
                byte[] byArray = unpickleContext.readLengthBytes();
                unpickleContext.reset();
                return this.toObject(byArray, n3, map);
            }
            case 2: {
                if ((unpickleContext.readByte() & 1) == 1) {
                    unpickleContext.skipBytes(4);
                    return null;
                }
            }
            case 3: {
                if (n3 == 9) {
                    unpickleContext.skipLengthBytes();
                    return null;
                }
                return this.toObject(unpickleContext.readLengthBytes(), n3, map);
            }
        }
        DatabaseError.throwSqlException(1, "format=" + n2);
        return null;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.form);
        objectOutputStream.writeInt(this.charset);
        objectOutputStream.writeInt(this.length);
        objectOutputStream.writeInt(this.characterSemantic);
        objectOutputStream.writeShort(this.pickleCharaterSetId);
        objectOutputStream.writeShort(this.pickleNcharCharacterSet);
    }
}

