/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeBLOB;
import oracle.jdbc.oracore.UnpickleContext;
import oracle.sql.CLOB;
import oracle.sql.Datum;

public class OracleTypeCLOB
extends OracleType
implements Serializable {
    static final long serialVersionUID = 1122821330765834411L;
    static int fixedDataSize = 86;
    transient OracleConnection connection;
    int form;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Jun_22_11:15:37_PDT_2005";

    protected OracleTypeCLOB() {
    }

    public OracleTypeCLOB(OracleConnection oracleConnection) {
        this.connection = oracleConnection;
    }

    public int getTypeCode() {
        return 2005;
    }

    public boolean isNCHAR() throws SQLException {
        return this.form == 2;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
    }

    public void setConnection(OracleConnection oracleConnection) throws SQLException {
        this.connection = oracleConnection;
    }

    public void setForm(int n2) {
        this.form = n2;
    }

    public Datum toDatum(Object object, OracleConnection oracleConnection) throws SQLException {
        CLOB cLOB = null;
        if (object != null) {
            if (object instanceof CLOB) {
                cLOB = (CLOB)object;
            } else {
                DatabaseError.throwSqlException(59, object);
            }
        }
        return cLOB;
    }

    protected Object toObject(byte[] byArray, int n2, Map map) throws SQLException {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        if (n2 == 1 || n2 == 2) {
            return this.connection.createClob(byArray);
        }
        if (n2 == 3) {
            return byArray;
        }
        DatabaseError.throwSqlException(59, byArray);
        return null;
    }

    protected Object unpickle80rec(UnpickleContext unpickleContext, int n2, int n3, Map map) throws SQLException {
        return OracleTypeBLOB.lobUnpickle80rec(this, this.nullOffset, this.ldsOffset, unpickleContext, n2, n3, fixedDataSize);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
    }
}

