/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.PickleContext;
import oracle.jdbc.oracore.TDSReader;
import oracle.sql.Datum;
import oracle.sql.OPAQUE;
import oracle.sql.OpaqueDescriptor;
import oracle.sql.StructDescriptor;

public class OracleTypeOPAQUE
extends OracleTypeADT
implements Serializable {
    static final long KOLOFLLB = 1L;
    static final long KOLOFLCL = 2L;
    static final long KOLOFLUB = 4L;
    static final long KOLOFLFX = 8L;
    static final long serialVersionUID = -7279638692691669378L;
    long flagBits;
    long maxLen;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Jun_22_11:15:37_PDT_2005";

    public OracleTypeOPAQUE(String string, OracleConnection oracleConnection) throws SQLException {
        super(string, (Connection)oracleConnection);
    }

    public OracleTypeOPAQUE(OracleTypeADT oracleTypeADT, int n2, OracleConnection oracleConnection) throws SQLException {
        super(oracleTypeADT, n2, (Connection)oracleConnection);
    }

    OpaqueDescriptor createOpaqueDescriptor() throws SQLException {
        if (this.sqlName == null) {
            return new OpaqueDescriptor(this, (Connection)this.connection);
        }
        return OpaqueDescriptor.createDescriptor(this.sqlName, (Connection)this.connection);
    }

    public long getMaxLength() throws SQLException {
        return this.maxLen;
    }

    public int getTypeCode() {
        return 2007;
    }

    public boolean isFixedSized() throws SQLException {
        return (this.flagBits & 8L) != 0L;
    }

    public boolean isInHierarchyOf(OracleType oracleType) throws SQLException {
        return false;
    }

    public boolean isInHierarchyOf(StructDescriptor structDescriptor) throws SQLException {
        return false;
    }

    public boolean isModeledInC() throws SQLException {
        return (this.flagBits & 2L) != 0L;
    }

    public boolean isObjectType() {
        return false;
    }

    public boolean isTrustedLibrary() throws SQLException {
        return (this.flagBits & 1L) != 0L;
    }

    public boolean isUnboundedSized() throws SQLException {
        return (this.flagBits & 4L) != 0L;
    }

    public byte[] linearize(Datum datum) throws SQLException {
        return this.pickle81(datum);
    }

    public void parseTDSrec(TDSReader tDSReader) throws SQLException {
        tDSReader.skipBytes(5);
        this.flagBits = tDSReader.readLong();
        this.maxLen = tDSReader.readLong();
    }

    protected int pickle81(PickleContext pickleContext, Datum datum) throws SQLException {
        OPAQUE oPAQUE = (OPAQUE)datum;
        byte[] byArray = oPAQUE.getBytesValue();
        int n2 = 0;
        n2 += pickleContext.writeOpaqueImageHeader(byArray.length);
        return n2 += pickleContext.writeData(byArray);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
    }

    public void setConnection(OracleConnection oracleConnection) throws SQLException {
        this.connection = oracleConnection;
    }

    public Datum toDatum(Object object, OracleConnection oracleConnection) throws SQLException {
        if (object != null) {
            if (object instanceof OPAQUE) {
                return (OPAQUE)object;
            }
            OpaqueDescriptor opaqueDescriptor = this.createOpaqueDescriptor();
            return new OPAQUE(opaqueDescriptor, this.connection, object);
        }
        return null;
    }

    public Datum unlinearize(byte[] byArray, long l2, Datum datum, int n2, Map map) throws SQLException {
        if (byArray == null) {
            return null;
        }
        if ((byArray[0] & 0x80) > 0) {
            PickleContext pickleContext = new PickleContext(byArray, l2);
            return this.unpickle81(pickleContext, (OPAQUE)datum, n2, map);
        }
        return null;
    }

    OPAQUE unpickle81(PickleContext pickleContext, OPAQUE oPAQUE, int n2, Map map) throws SQLException {
        return this.unpickle81datum(pickleContext, oPAQUE, n2);
    }

    private OPAQUE unpickle81datum(PickleContext pickleContext, OPAQUE oPAQUE) throws SQLException {
        return this.unpickle81datum(pickleContext, oPAQUE, 1);
    }

    private OPAQUE unpickle81datum(PickleContext pickleContext, OPAQUE oPAQUE, int n2) throws SQLException {
        pickleContext.skipBytes(2);
        long l2 = pickleContext.readLength(true) - 2;
        if (oPAQUE == null) {
            if (n2 == 2) {
                return new OPAQUE(this.createOpaqueDescriptor(), pickleContext.readBytes((int)l2), this.connection);
            }
            return new OPAQUE(this.createOpaqueDescriptor(), this.connection, pickleContext.readBytes((int)l2));
        }
        oPAQUE.setValue(pickleContext.readBytes((int)l2));
        return oPAQUE;
    }

    protected Object unpickle81rec(PickleContext pickleContext, int n2, Map map) throws SQLException {
        byte by = pickleContext.readByte();
        Object object = null;
        if (PickleContext.isElementNull(by)) {
            return null;
        }
        pickleContext.skipRestOfLength(by);
        switch (n2) {
            case 1: {
                object = this.unpickle81datum(pickleContext, null);
                break;
            }
            case 2: {
                object = this.unpickle81datum(pickleContext, null).toJdbc();
                break;
            }
            case 3: {
                object = new OPAQUE(this.createOpaqueDescriptor(), pickleContext.readDataValue(), this.connection);
                break;
            }
            case 9: {
                pickleContext.skipDataValue();
                break;
            }
            default: {
                DatabaseError.throwSqlException(1);
            }
        }
        return object;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
    }
}

