/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.pool.OracleConnectionCacheImpl;
import oracle.jdbc.pool.OracleDataSource;
import oracle.jdbc.xa.OracleXAConnection;
import oracle.jdbc.xa.OracleXADataSource;

public class OracleXAConnectionCacheImpl
extends OracleConnectionCacheImpl
implements XADataSource,
Serializable {
    private boolean nativeXA = false;
    private static final String clientXADS = "oracle.jdbc.xa.client.OracleXADataSource";
    private static final String serverXADS = "oracle.jdbc.xa.server.OracleXADataSource";
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Jun_22_11:15:49_PDT_2005";

    public OracleXAConnectionCacheImpl() throws SQLException {
        this(null);
    }

    public OracleXAConnectionCacheImpl(ConnectionPoolDataSource connectionPoolDataSource) throws SQLException {
        super(connectionPoolDataSource);
        this.dataSourceName = "OracleXAConnectionCacheImpl";
    }

    public synchronized void closeActualConnection(PooledConnection pooledConnection) throws SQLException {
        ((OracleXAConnection)pooledConnection).close();
    }

    public synchronized boolean getNativeXA() {
        return this.nativeXA;
    }

    PooledConnection getNewPoolOrXAConnection(Properties properties) throws SQLException {
        XAConnection xAConnection = ((OracleXADataSource)this.cpds).getXAConnection(properties);
        ((OracleXAConnection)xAConnection).setStmtCacheSize(this.stmtCacheSize, this.stmtClearMetaData);
        return xAConnection;
    }

    public synchronized XAConnection getXAConnection() throws SQLException {
        XAConnection xAConnection = (XAConnection)super.getPooledConnection(this.user, this.password);
        return xAConnection;
    }

    public synchronized XAConnection getXAConnection(String string, String string2) throws SQLException {
        XAConnection xAConnection = (XAConnection)super.getPooledConnection(string, string2);
        return xAConnection;
    }

    void initializeConnectionPoolDataSource() throws SQLException {
        if (this.cpds == null) {
            if (this.user == null || this.password == null) {
                DatabaseError.throwSqlException(79);
            }
            String string = null;
            string = OracleDriver.getSystemPropertyJserverVersion() == null ? clientXADS : serverXADS;
            try {
                this.cpds = (OracleXADataSource)Class.forName(string).newInstance();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                DatabaseError.throwSqlException(1);
            }
            this.copy((OracleDataSource)((Object)this.cpds));
            ((OracleXADataSource)this.cpds).setNativeXA(this.nativeXA);
        }
    }

    public synchronized void setNativeXA(boolean bl2) {
        this.nativeXA = bl2;
    }
}

