/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringBufferInputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.AbstractList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.sql.RowSet;
import javax.sql.RowSetEvent;
import javax.sql.RowSetInternal;
import javax.sql.RowSetMetaData;
import javax.sql.RowSetReader;
import javax.sql.RowSetWriter;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleSavepoint;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.rowset.OracleCachedRowSetReader;
import oracle.jdbc.rowset.OracleCachedRowSetWriter;
import oracle.jdbc.rowset.OracleRow;
import oracle.jdbc.rowset.OracleRowSet;
import oracle.jdbc.rowset.OracleRowSetMetaData;
import oracle.jdbc.rowset.OracleSerialBlob;
import oracle.jdbc.rowset.OracleSerialClob;
import oracle.sql.BLOB;
import oracle.sql.CLOB;

public class OracleCachedRowSet
extends OracleRowSet
implements RowSet,
RowSetInternal,
Serializable,
Cloneable {
    private SQLWarning sqlWarning;
    protected int presentRow = 0;
    private int currentPage;
    private boolean isPopulateDone;
    private boolean previousColumnWasNull = false;
    private OracleRow insertRow;
    private int insertRowPosition;
    private boolean insertRowFlag = false;
    private int updateRowPosition;
    private boolean updateRowFlag = false;
    protected ResultSetMetaData rowsetMetaData;
    private transient ResultSet resultSet;
    private transient Connection connection;
    private transient boolean isConnectionStayingOpenForTxnControl = false;
    protected Vector rows;
    private Vector param = new Vector();
    private String[] metaData;
    protected int colCount;
    protected int rowCount;
    private RowSetReader reader;
    private RowSetWriter writer;
    private int[] keyColumns;
    private int pageSize;
    private String tableName;
    private boolean driverManagerInitialized = false;

    public OracleCachedRowSet() throws SQLException {
        this.rows = new Vector();
        this.sqlWarning = new SQLWarning();
        this.setReader(new OracleCachedRowSetReader());
        this.setWriter(new OracleCachedRowSetWriter());
        this.currentPage = 0;
        this.pageSize = 0;
        this.isPopulateDone = false;
        this.keyColumns = null;
        this.tableName = null;
    }

    public boolean absolute(int n2) throws SQLException {
        if (this.rowsetType == 1003) {
            throw new SQLException("The RowSet type is TYPE_FORWARD_ONLY");
        }
        if (n2 == 0 || Math.abs(n2) > this.rowCount) {
            return false;
        }
        this.presentRow = n2 < 0 ? this.rowCount + n2 + 1 : n2;
        this.notifyCursorMoved();
        return true;
    }

    public void acceptChanges() throws SQLException {
        this.getWriter().writeData(this);
    }

    public void acceptChanges(Connection connection) throws SQLException {
        this.connection = connection;
        this.isConnectionStayingOpenForTxnControl = true;
        this.acceptChanges();
    }

    public void afterLast() throws SQLException {
        this.presentRow = this.rowCount + 1;
    }

    public void beforeFirst() throws SQLException {
        this.presentRow = 0;
    }

    public void cancelRowDelete() throws SQLException {
        if (!this.getCurrentRow().isRowDeleted()) {
            throw new SQLException("The row is not deleted");
        }
        this.getCurrentRow().setRowDeleted(false);
        this.notifyRowChanged();
    }

    public void cancelRowInsert() throws SQLException {
        if (this.getCurrentRow().isRowInserted()) {
            this.rows.remove(--this.presentRow);
            --this.rowCount;
        } else {
            throw new SQLException("The row is not inserted");
        }
        this.notifyRowChanged();
    }

    public void cancelRowUpdates() throws SQLException {
        if (!this.getCurrentRow().isRowUpdated()) {
            throw new SQLException("The row is not updated.");
        }
        this.updateRowFlag = false;
        this.getCurrentRow().setRowUpdated(false);
        this.notifyRowChanged();
    }

    protected void checkAndFilterObject(int n2, Object object) throws SQLException {
    }

    private final void checkColumnIndex(int n2) throws SQLException {
        if (this.readOnly) {
            throw new SQLException("The RowSet is not write enabled");
        }
        if (n2 < 1 || n2 > this.colCount) {
            throw new SQLException("invalid index : " + n2);
        }
    }

    private final void checkParamIndex(int n2) throws SQLException {
        if (n2 < 1) {
            throw new SQLException("Invalid parameter index : " + n2);
        }
    }

    public synchronized void clearParameters() throws SQLException {
        this.param = null;
        this.param = new Vector();
    }

    public void clearWarnings() throws SQLException {
        this.sqlWarning = null;
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            return this.createCopy();
        }
        catch (SQLException sQLException) {
            throw new CloneNotSupportedException("SQL Error occured while cloning,\n" + sQLException.getMessage());
        }
    }

    public void close() throws SQLException {
        this.release();
    }

    public boolean columnUpdated(int n2) throws SQLException {
        if (this.insertRowFlag) {
            throw new SQLException("Trying to mark an inserted row as original");
        }
        return this.getCurrentRow().isColumnChanged(n2);
    }

    public boolean columnUpdated(String string) throws SQLException {
        return this.columnUpdated(this.getColumnIndex(string));
    }

    public void commit() throws SQLException {
        this.getConnectionInternal().commit();
    }

    public OracleCachedRowSet createCopy() throws SQLException {
        OracleCachedRowSet oracleCachedRowSet = (OracleCachedRowSet)this.createShared();
        int n2 = this.rows.size();
        oracleCachedRowSet.rows = new Vector(n2);
        int n3 = 0;
        while (n3 < n2) {
            oracleCachedRowSet.rows.add(((OracleRow)this.rows.elementAt(n3)).createCopy());
            ++n3;
        }
        return oracleCachedRowSet;
    }

    public OracleCachedRowSet createCopyNoConstraints() throws SQLException {
        OracleCachedRowSet oracleCachedRowSet = this.createCopy();
        oracleCachedRowSet.initializeProperties();
        oracleCachedRowSet.listener = new Vector();
        try {
            oracleCachedRowSet.unsetMatchColumn(oracleCachedRowSet.getMatchColumnIndexes());
            oracleCachedRowSet.unsetMatchColumn(oracleCachedRowSet.getMatchColumnNames());
        }
        catch (SQLException sQLException) {}
        return oracleCachedRowSet;
    }

    public OracleCachedRowSet createCopySchema() throws SQLException {
        OracleCachedRowSet oracleCachedRowSet = this.createCopy();
        oracleCachedRowSet.rows = null;
        oracleCachedRowSet.rowCount = 0;
        oracleCachedRowSet.currentPage = 0;
        return oracleCachedRowSet;
    }

    public RowSet createShared() throws SQLException {
        OracleCachedRowSet oracleCachedRowSet = new OracleCachedRowSet();
        oracleCachedRowSet.rows = this.rows;
        oracleCachedRowSet.setDataSource(this.getDataSource());
        oracleCachedRowSet.setDataSourceName(this.getDataSourceName());
        oracleCachedRowSet.setUsername(this.getUsername());
        oracleCachedRowSet.setPassword(this.getPassword());
        oracleCachedRowSet.setUrl(this.getUrl());
        oracleCachedRowSet.setTypeMap(this.getTypeMap());
        oracleCachedRowSet.setMaxFieldSize(this.getMaxFieldSize());
        oracleCachedRowSet.setMaxRows(this.getMaxRows());
        oracleCachedRowSet.setQueryTimeout(this.getQueryTimeout());
        oracleCachedRowSet.setFetchSize(this.getFetchSize());
        oracleCachedRowSet.setEscapeProcessing(this.getEscapeProcessing());
        oracleCachedRowSet.setConcurrency(this.getConcurrency());
        oracleCachedRowSet.setReadOnly(this.readOnly);
        this.rowsetType = this.getType();
        this.fetchDirection = this.getFetchDirection();
        oracleCachedRowSet.setCommand(this.getCommand());
        oracleCachedRowSet.setTransactionIsolation(this.getTransactionIsolation());
        oracleCachedRowSet.presentRow = this.presentRow;
        oracleCachedRowSet.colCount = this.colCount;
        oracleCachedRowSet.rowCount = this.rowCount;
        oracleCachedRowSet.showDeleted = this.showDeleted;
        oracleCachedRowSet.currentPage = this.currentPage;
        oracleCachedRowSet.pageSize = this.pageSize;
        oracleCachedRowSet.tableName = this.tableName == null ? null : new String(this.tableName);
        oracleCachedRowSet.keyColumns = this.keyColumns == null ? null : (int[])this.keyColumns.clone();
        int n2 = this.listener.size();
        int n3 = 0;
        while (n3 < n2) {
            oracleCachedRowSet.listener.add(this.listener.elementAt(n3));
            ++n3;
        }
        oracleCachedRowSet.rowsetMetaData = new OracleRowSetMetaData(this.rowsetMetaData);
        n2 = this.param.size();
        int n4 = 0;
        while (n4 < n2) {
            oracleCachedRowSet.param.add(this.param.elementAt(n4));
            ++n4;
        }
        oracleCachedRowSet.metaData = new String[this.metaData.length];
        System.arraycopy(this.metaData, 0, oracleCachedRowSet.metaData, 0, this.metaData.length);
        return oracleCachedRowSet;
    }

    public void deleteRow() throws SQLException {
        this.getCurrentRow().setRowDeleted(true);
        this.notifyRowChanged();
    }

    public synchronized void execute() throws SQLException {
        this.isConnectionStayingOpenForTxnControl = false;
        this.getReader().readData(this);
    }

    public synchronized void execute(Connection connection) throws SQLException {
        this.connection = connection;
        this.execute();
    }

    public int findColumn(String string) throws SQLException {
        return this.getColumnIndex(string);
    }

    public boolean first() throws SQLException {
        return this.absolute(1);
    }

    public Array getArray(int n2) throws SQLException {
        Object object = this.getObject(n2);
        if (object == null || object instanceof Array) {
            return (Array)object;
        }
        throw new SQLException("Invalid column type");
    }

    public Array getArray(String string) throws SQLException {
        return this.getArray(this.getColumnIndex(string));
    }

    public InputStream getAsciiStream(int n2) throws SQLException {
        InputStream inputStream = this.getStream(n2);
        return inputStream == null ? null : inputStream;
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.getColumnIndex(string));
    }

    public BigDecimal getBigDecimal(int n2) throws SQLException {
        Number number = this.getNumber(n2);
        if (number == null || number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        if (number instanceof Number) {
            return new BigDecimal(number.doubleValue());
        }
        return null;
    }

    public BigDecimal getBigDecimal(int n2, int n3) throws SQLException {
        return this.getBigDecimal(n2);
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.getColumnIndex(string));
    }

    public BigDecimal getBigDecimal(String string, int n2) throws SQLException {
        return this.getBigDecimal(this.getColumnIndex(string), n2);
    }

    public InputStream getBinaryStream(int n2) throws SQLException {
        InputStream inputStream = this.getStream(n2);
        return inputStream == null ? null : inputStream;
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.getColumnIndex(string));
    }

    public Blob getBlob(int n2) throws SQLException {
        Object object = this.getObject(n2);
        if (object instanceof OracleSerialBlob) {
            return object == null ? null : (Blob)object;
        }
        throw new SQLException("Invalid column type");
    }

    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.getColumnIndex(string));
    }

    public boolean getBoolean(int n2) throws SQLException {
        Object object = this.getObject(n2);
        if (object == null) {
            return false;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue() != 0.0;
        }
        throw new SQLException("Fail to convert to internal representation");
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.getColumnIndex(string));
    }

    public byte getByte(int n2) throws SQLException {
        Object object = this.getObject(n2);
        if (object == null) {
            return 0;
        }
        if (object instanceof Number) {
            return ((Number)object).byteValue();
        }
        if (object instanceof String) {
            return ((String)object).getBytes()[0];
        }
        if (object instanceof OracleSerialBlob) {
            OracleSerialBlob oracleSerialBlob = (OracleSerialBlob)object;
            return oracleSerialBlob.getBytes(0L, 1)[0];
        }
        if (object instanceof OracleSerialClob) {
            OracleSerialClob oracleSerialClob = (OracleSerialClob)object;
            return oracleSerialClob.getSubString(0L, 1).getBytes()[0];
        }
        throw new SQLException("Fail to convert to internal representation");
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.getColumnIndex(string));
    }

    public byte[] getBytes(int n2) throws SQLException {
        Object object = this.getObject(n2);
        if (object == null) {
            return (byte[])object;
        }
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        if (object instanceof String) {
            return ((String)object).getBytes();
        }
        if (object instanceof Number) {
            return ((Number)object).toString().getBytes();
        }
        if (object instanceof BigDecimal) {
            return ((BigDecimal)object).toString().getBytes();
        }
        if (object instanceof OracleSerialBlob) {
            OracleSerialBlob oracleSerialBlob = (OracleSerialBlob)object;
            return oracleSerialBlob.getBytes(0L, (int)oracleSerialBlob.length());
        }
        if (object instanceof OracleSerialClob) {
            OracleSerialClob oracleSerialClob = (OracleSerialClob)object;
            return oracleSerialClob.getSubString(0L, (int)oracleSerialClob.length()).getBytes();
        }
        throw new SQLException("Fail to convert to internal representation");
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.getColumnIndex(string));
    }

    public synchronized Reader getCharacterStream(int n2) throws SQLException {
        try {
            InputStream inputStream = this.getAsciiStream(n2);
            if (inputStream == null) {
                return null;
            }
            StringBuffer stringBuffer = new StringBuffer();
            int n3 = 0;
            while ((n3 = inputStream.read()) != -1) {
                stringBuffer.append((char)n3);
            }
            char[] cArray = new char[stringBuffer.length()];
            stringBuffer.getChars(0, stringBuffer.length(), cArray, 0);
            CharArrayReader charArrayReader = new CharArrayReader(cArray);
            cArray = null;
            return charArrayReader;
        }
        catch (IOException iOException) {
            throw new SQLException("Error: could not read from the stream");
        }
    }

    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.getColumnIndex(string));
    }

    public Clob getClob(int n2) throws SQLException {
        Object object = this.getObject(n2);
        if (object instanceof OracleSerialClob) {
            return object == null ? null : (Clob)object;
        }
        throw new SQLException("Invalid column type");
    }

    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.getColumnIndex(string));
    }

    private final int getColumnIndex(String string) throws SQLException {
        string = string.toUpperCase();
        int n2 = 0;
        while (n2 < this.metaData.length) {
            if (string.equals(this.metaData[n2])) break;
            ++n2;
        }
        if (n2 >= this.metaData.length) {
            throw new SQLException("Invalid column name: " + string);
        }
        return n2 + 1;
    }

    public Connection getConnection() throws SQLException {
        return this.getConnectionInternal();
    }

    Connection getConnectionInternal() throws SQLException {
        if (this.connection == null || this.connection.isClosed()) {
            String string = this.getUsername();
            String string2 = this.getPassword();
            if (this.getDataSourceName() != null) {
                try {
                    Object object;
                    InitialContext initialContext = null;
                    try {
                        object = System.getProperties();
                        initialContext = new InitialContext((Hashtable<?, ?>)object);
                    }
                    catch (SecurityException securityException) {}
                    if (initialContext == null) {
                        initialContext = new InitialContext();
                    }
                    object = (DataSource)initialContext.lookup(this.getDataSourceName());
                    if (this.username == null || string2 == null) {
                        this.connection = object.getConnection();
                    }
                    this.connection = object.getConnection(this.username, string2);
                }
                catch (NamingException namingException) {
                    throw new SQLException("Unable to connect through the DataSource\n" + namingException.getMessage());
                }
            } else if (this.getUrl() != null) {
                String string3;
                if (!this.driverManagerInitialized) {
                    DriverManager.registerDriver(new OracleDriver());
                    this.driverManagerInitialized = true;
                }
                if ((string3 = this.getUrl()).equals("") || string.equals("") || string2.equals("")) {
                    throw new SQLException("One or more of the authenticating parameter not set");
                }
                this.connection = DriverManager.getConnection(string3, string, string2);
            } else {
                throw new SQLException("Authentication parameters not set");
            }
        }
        return this.connection;
    }

    OracleRow getCurrentRow() throws SQLException {
        int n2 = this.presentRow - 1;
        if (this.presentRow < 1 || this.presentRow > this.rowCount) {
            throw new SQLException("Operation with out calling next/previous");
        }
        return (OracleRow)this.rows.elementAt(this.presentRow - 1);
    }

    public String getCursorName() throws SQLException {
        throw new SQLException("Getting the cursor name is not supported.");
    }

    public Date getDate(int n2) throws SQLException {
        Object object = this.getObject(n2);
        if (object == null) {
            return (Date)object;
        }
        if (object instanceof Time) {
            Time time = (Time)object;
            return new Date(time.getTime());
        }
        if (object instanceof java.util.Date) {
            java.util.Date date = (java.util.Date)object;
            return new Date(date.getYear(), date.getMonth(), date.getDate());
        }
        throw new SQLException("Invalid column type");
    }

    public Date getDate(int n2, Calendar calendar) throws SQLException {
        return this.getDate(n2);
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.getColumnIndex(string));
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.getColumnIndex(string), calendar);
    }

    public double getDouble(int n2) throws SQLException {
        Number number = this.getNumber(n2);
        return number == null ? 0.0 : number.doubleValue();
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.getColumnIndex(string));
    }

    public float getFloat(int n2) throws SQLException {
        Number number = this.getNumber(n2);
        return number == null ? 0.0f : number.floatValue();
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.getColumnIndex(string));
    }

    public int getInt(int n2) throws SQLException {
        Number number = this.getNumber(n2);
        return number == null ? 0 : number.intValue();
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.getColumnIndex(string));
    }

    public int[] getKeyColumns() throws SQLException {
        return this.keyColumns;
    }

    public long getLong(int n2) throws SQLException {
        Number number = this.getNumber(n2);
        return number == null ? 0L : number.longValue();
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.getColumnIndex(string));
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.rowsetMetaData;
    }

    private synchronized Number getNumber(int n2) throws SQLException {
        Object object = this.getObject(n2);
        if (object == null || object instanceof BigDecimal || object instanceof Number) {
            return (Number)object;
        }
        if (object instanceof Boolean) {
            return new Integer((Boolean)object != false ? 1 : 0);
        }
        if (object instanceof String) {
            try {
                return new BigDecimal((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SQLException("Fail to convert to internal representation");
            }
        }
        throw new SQLException("Fail to convert to internal representation");
    }

    public synchronized Object getObject(int n2) throws SQLException {
        int n3 = this.presentRow * this.colCount + n2 - 1;
        Object object = null;
        object = !this.isUpdated(n2) ? this.getCurrentRow().getColumn(n2) : this.getCurrentRow().getModifiedColumn(n2);
        this.previousColumnWasNull = object == null;
        return object;
    }

    public Object getObject(int n2, Map map) throws SQLException {
        return this.getObject(n2);
    }

    public synchronized Object getObject(String string) throws SQLException {
        return this.getObject(this.getColumnIndex(string));
    }

    public Object getObject(String string, Map map) throws SQLException {
        return this.getObject(this.getColumnIndex(string), map);
    }

    public ResultSet getOriginal() throws SQLException {
        OracleCachedRowSet oracleCachedRowSet = new OracleCachedRowSet();
        oracleCachedRowSet.rowsetMetaData = this.rowsetMetaData;
        oracleCachedRowSet.rowCount = this.rowCount;
        oracleCachedRowSet.colCount = this.colCount;
        oracleCachedRowSet.presentRow = 0;
        oracleCachedRowSet.setType(1004);
        oracleCachedRowSet.setConcurrency(1008);
        oracleCachedRowSet.setReader(null);
        oracleCachedRowSet.setWriter(null);
        int n2 = this.rowsetMetaData.getColumnCount();
        OracleRow oracleRow = null;
        Iterator iterator = ((AbstractList)this.rows).iterator();
        while (iterator.hasNext()) {
            oracleRow = new OracleRow(n2, ((OracleRow)iterator.next()).getOriginalRow());
            oracleCachedRowSet.rows.add(oracleRow);
        }
        return oracleCachedRowSet;
    }

    public ResultSet getOriginalRow() throws SQLException {
        OracleCachedRowSet oracleCachedRowSet = new OracleCachedRowSet();
        oracleCachedRowSet.rowsetMetaData = this.rowsetMetaData;
        oracleCachedRowSet.rowCount = 1;
        oracleCachedRowSet.colCount = this.colCount;
        oracleCachedRowSet.presentRow = 0;
        oracleCachedRowSet.setReader(null);
        oracleCachedRowSet.setWriter(null);
        OracleRow oracleRow = new OracleRow(this.rowsetMetaData.getColumnCount(), this.getCurrentRow().getOriginalRow());
        oracleCachedRowSet.rows.add(oracleRow);
        return oracleCachedRowSet;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public Object[] getParams() throws SQLException {
        return this.param.toArray();
    }

    public RowSetReader getReader() {
        return this.reader;
    }

    public Ref getRef(int n2) throws SQLException {
        Object object = this.getObject(n2);
        if (object == null || object instanceof Ref) {
            return (Ref)object;
        }
        throw new SQLException("Invalid column type");
    }

    public Ref getRef(String string) throws SQLException {
        return this.getRef(this.getColumnIndex(string));
    }

    public int getRow() throws SQLException {
        if (this.presentRow > this.rowCount) {
            return this.rowCount;
        }
        return this.presentRow;
    }

    public short getShort(int n2) throws SQLException {
        Number number = this.getNumber(n2);
        return number == null ? (short)0 : number.shortValue();
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.getColumnIndex(string));
    }

    public Statement getStatement() throws SQLException {
        if (this.resultSet == null) {
            throw new SQLException("ResultSet not open");
        }
        return this.resultSet.getStatement();
    }

    private synchronized InputStream getStream(int n2) throws SQLException {
        Object object = this.getObject(n2);
        if (object == null) {
            return null;
        }
        if (object instanceof InputStream) {
            return (InputStream)object;
        }
        if (object instanceof String) {
            return new ByteArrayInputStream(((String)object).getBytes());
        }
        if (object instanceof byte[]) {
            return new ByteArrayInputStream((byte[])object);
        }
        if (object instanceof OracleSerialClob) {
            return ((OracleSerialClob)object).getAsciiStream();
        }
        if (object instanceof OracleSerialBlob) {
            return ((OracleSerialBlob)object).getBinaryStream();
        }
        if (object instanceof Reader) {
            try {
                BufferedReader bufferedReader = new BufferedReader((Reader)object);
                int n3 = 0;
                PipedInputStream pipedInputStream = new PipedInputStream();
                PipedOutputStream pipedOutputStream = new PipedOutputStream(pipedInputStream);
                while ((n3 = ((Reader)bufferedReader).read()) != -1) {
                    pipedOutputStream.write(n3);
                }
                pipedOutputStream.close();
                return pipedInputStream;
            }
            catch (IOException iOException) {
                throw new SQLException("Error during conversion: " + iOException.getMessage());
            }
        }
        throw new SQLException("Could not convert the column into a stream type");
    }

    public String getString(int n2) throws SQLException {
        Object object = this.getObject(n2);
        if (object == null) {
            return (String)object;
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Number || object instanceof BigDecimal) {
            return object.toString();
        }
        if (object instanceof Date) {
            return ((Date)object).toString();
        }
        if (object instanceof Timestamp) {
            return ((Date)object).toString();
        }
        if (object instanceof byte[]) {
            return new String((byte[])object);
        }
        if (object instanceof OracleSerialClob) {
            OracleSerialClob oracleSerialClob = (OracleSerialClob)object;
            return oracleSerialClob.getSubString(0L, (int)oracleSerialClob.length());
        }
        if (object instanceof OracleSerialBlob) {
            OracleSerialBlob oracleSerialBlob = (OracleSerialBlob)object;
            return new String(oracleSerialBlob.getBytes(0L, (int)oracleSerialBlob.length()));
        }
        if (object instanceof URL) {
            return ((URL)object).toString();
        }
        if (object instanceof Reader) {
            try {
                Reader reader = (Reader)object;
                char[] cArray = new char[1024];
                int n3 = 0;
                StringBuffer stringBuffer = new StringBuffer(1024);
                while ((n3 = reader.read(cArray)) > 0) {
                    stringBuffer.append(cArray, 0, n3);
                }
                return stringBuffer.substring(0, stringBuffer.length());
            }
            catch (IOException iOException) {
                throw new SQLException("Error during conversion: " + iOException.getMessage());
            }
        }
        throw new SQLException("Fail to convert to internal representation");
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.getColumnIndex(string));
    }

    public String getTableName() throws SQLException {
        return this.tableName;
    }

    public Time getTime(int n2) throws SQLException {
        Object object = this.getObject(n2);
        if (object == null) {
            return (Time)object;
        }
        if (object instanceof java.util.Date) {
            java.util.Date date = (java.util.Date)object;
            return new Time(date.getHours(), date.getMinutes(), date.getSeconds());
        }
        throw new SQLException("Invalid column type");
    }

    public Time getTime(int n2, Calendar calendar) throws SQLException {
        return this.getTime(n2);
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.getColumnIndex(string));
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.getColumnIndex(string), calendar);
    }

    public Timestamp getTimestamp(int n2) throws SQLException {
        Object object = this.getObject(n2);
        if (object == null || object instanceof Timestamp) {
            return (Timestamp)object;
        }
        if (object instanceof java.util.Date) {
            return new Timestamp(((java.util.Date)object).getTime());
        }
        throw new SQLException("Invalid column type");
    }

    public Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        return this.getTimestamp(n2);
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.getColumnIndex(string));
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.getColumnIndex(string), calendar);
    }

    public URL getURL(int n2) throws SQLException {
        Object object = this.getObject(n2);
        if (object == null) {
            return (URL)object;
        }
        if (object instanceof URL) {
            return (URL)object;
        }
        throw new SQLException("Invalid column type");
    }

    public URL getURL(String string) throws SQLException {
        return this.getURL(this.getColumnIndex(string));
    }

    public InputStream getUnicodeStream(int n2) throws SQLException {
        Object object = this.getObject(n2);
        if (object == null) {
            return (InputStream)object;
        }
        if (object instanceof String) {
            return new StringBufferInputStream((String)object);
        }
        throw new SQLException("Fail to convert to internal representation");
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.getColumnIndex(string));
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.sqlWarning;
    }

    public RowSetWriter getWriter() {
        return this.writer;
    }

    public void insertRow() throws SQLException {
        if (!this.insertRowFlag) {
            throw new SQLException("Current row not inserted/updated.");
        }
        if (!this.insertRow.isRowFullyPopulated()) {
            throw new SQLException("All the columns of the row are not set");
        }
        this.insertRow.insertRow();
        this.rows.insertElementAt(this.insertRow, this.insertRowPosition - 1);
        this.insertRowFlag = false;
        ++this.rowCount;
        this.notifyRowChanged();
    }

    public boolean isAfterLast() throws SQLException {
        return this.rowCount > 0 && this.presentRow == this.rowCount + 1;
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.rowCount > 0 && this.presentRow == 0;
    }

    boolean isConnectionStayingOpen() {
        return this.isConnectionStayingOpenForTxnControl;
    }

    public boolean isFirst() throws SQLException {
        return this.presentRow == 1;
    }

    public boolean isLast() throws SQLException {
        return this.presentRow == this.rowCount;
    }

    private final boolean isUpdated(int n2) throws SQLException {
        if (n2 < 1 || n2 > this.colCount) {
            throw new SQLException("Invalid index : " + n2);
        }
        return this.getCurrentRow().isColumnChanged(n2);
    }

    public boolean last() throws SQLException {
        return this.absolute(-1);
    }

    public void moveToCurrentRow() throws SQLException {
        this.insertRowFlag = false;
        this.updateRowFlag = false;
        this.absolute(this.presentRow);
    }

    public void moveToInsertRow() throws SQLException {
        this.insertRow = new OracleRow(this.colCount, true);
        this.insertRowFlag = true;
        this.insertRowPosition = this.isAfterLast() ? this.presentRow : this.presentRow + 1;
    }

    public boolean next() throws SQLException {
        if (this.rowCount < 0) {
            return false;
        }
        if (this.fetchDirection == 1000 || this.fetchDirection == 1002) {
            if (this.presentRow + 1 <= this.rowCount) {
                ++this.presentRow;
                if (!this.showDeleted && this.getCurrentRow().isRowDeleted()) {
                    return this.next();
                }
                this.notifyCursorMoved();
                return true;
            }
            this.presentRow = this.rowCount + 1;
            return false;
        }
        if (this.fetchDirection == 1001) {
            if (this.presentRow - 1 > 0) {
                --this.presentRow;
                if (!this.showDeleted && this.getCurrentRow().isRowDeleted()) {
                    return this.next();
                }
                this.notifyCursorMoved();
                return true;
            }
            this.presentRow = 0;
            return false;
        }
        return false;
    }

    public boolean nextPage() throws SQLException {
        if (this.fetchDirection == 1001 && this.resultSet != null && this.resultSet.getType() == 1003) {
            throw new SQLException("The underlying ResultSet does not support this operation");
        }
        if (this.rows.size() == 0 && !this.isPopulateDone) {
            throw new SQLException("This operation can not be called without previous paging operations");
        }
        this.populate(this.resultSet);
        ++this.currentPage;
        return this.isPopulateDone ^ true;
    }

    protected synchronized void notifyCursorMoved() {
        if (this.insertRowFlag) {
            this.insertRowFlag = false;
            this.insertRow.setRowUpdated(false);
            this.sqlWarning.setNextWarning(new SQLWarning("Cancelling insertion, due to cursor movement."));
        } else if (this.updateRowFlag) {
            try {
                this.updateRowFlag = false;
                int n2 = this.presentRow;
                this.presentRow = this.updateRowPosition;
                this.getCurrentRow().setRowUpdated(false);
                this.presentRow = n2;
                this.sqlWarning.setNextWarning(new SQLWarning("Cancelling all updates, due to cursor movement."));
            }
            catch (SQLException sQLException) {}
        }
        super.notifyCursorMoved();
    }

    public void oracleRollback(OracleSavepoint oracleSavepoint) throws SQLException {
        ((OracleConnection)this.getConnectionInternal()).oracleRollback(oracleSavepoint);
    }

    public synchronized void populate(ResultSet resultSet) throws SQLException {
        if (this.rows == null) {
            this.rows = new Vector(50, 10);
        } else {
            this.rows.clear();
        }
        this.rowsetMetaData = new OracleRowSetMetaData(resultSet.getMetaData());
        this.colCount = this.rowsetMetaData.getColumnCount();
        this.metaData = new String[this.colCount];
        int n2 = 0;
        while (n2 < this.colCount) {
            this.metaData[n2] = this.rowsetMetaData.getColumnName(n2 + 1);
            ++n2;
        }
        if (!(resultSet instanceof OracleCachedRowSet)) {
            this.populateInit(resultSet);
        }
        boolean bl2 = this.fetchDirection == 1000 || this.fetchDirection == 1002;
        this.rowCount = 0;
        OracleRow oracleRow = null;
        int n3 = this.maxRows == 0 && this.pageSize == 0 ? Integer.MAX_VALUE : (this.maxRows == 0 || this.pageSize == 0 ? Math.max(this.maxRows, this.pageSize) : Math.min(this.maxRows, this.pageSize));
        if (resultSet.getType() != 1003 && this.rows.size() == 0 && !bl2) {
            resultSet.afterLast();
        }
        while (this.rowCount < n3) {
            if (bl2 ? !resultSet.next() : !resultSet.previous()) break;
            oracleRow = new OracleRow(this.colCount);
            int n4 = 1;
            while (n4 <= this.colCount) {
                Object object = null;
                try {
                    object = resultSet.getObject(n4, this.typeMap);
                }
                catch (Exception exception) {
                    object = resultSet.getObject(n4);
                }
                catch (AbstractMethodError abstractMethodError) {
                    object = resultSet.getObject(n4);
                }
                if (object instanceof Clob || object instanceof CLOB) {
                    oracleRow.setColumnValue(n4, new OracleSerialClob((Clob)object));
                } else if (object instanceof Blob || object instanceof BLOB) {
                    oracleRow.setColumnValue(n4, new OracleSerialBlob((Blob)object));
                } else {
                    oracleRow.setColumnValue(n4, object);
                }
                oracleRow.markOriginalNull(n4, resultSet.wasNull());
                ++n4;
            }
            if (bl2) {
                this.rows.add(oracleRow);
            } else {
                this.rows.add(1, oracleRow);
            }
            ++this.rowCount;
        }
        if (bl2 && resultSet.isAfterLast() || !bl2 && resultSet.isBeforeFirst()) {
            this.isPopulateDone = true;
        }
        this.connection = null;
        this.notifyRowSetChanged();
    }

    public void populate(ResultSet resultSet, int n2) throws SQLException {
        if (n2 < 0) {
            throw new SQLException("The start position should not be negative");
        }
        if (resultSet == null) {
            throw new SQLException("Null ResultSet supplied to populate");
        }
        int n3 = resultSet.getType();
        if (n3 == 1003) {
            int n4 = 0;
            while (resultSet.next() && n4 < n2) {
                ++n4;
            }
            if (n4 < n2) {
                throw new SQLException("Too few rows to start populating at this position");
            }
        } else {
            resultSet.absolute(n2);
        }
        this.populate(resultSet);
    }

    private final void populateInit(ResultSet resultSet) throws SQLException {
        this.resultSet = resultSet;
        Statement statement = resultSet.getStatement();
        this.maxFieldSize = statement.getMaxFieldSize();
        this.fetchSize = statement.getFetchSize();
        this.queryTimeout = statement.getQueryTimeout();
        this.connection = statement.getConnection();
        this.transactionIsolation = this.connection.getTransactionIsolation();
        this.typeMap = this.connection.getTypeMap();
        DatabaseMetaData databaseMetaData = this.connection.getMetaData();
        this.url = databaseMetaData.getURL();
        this.username = databaseMetaData.getUserName();
    }

    public boolean previous() throws SQLException {
        if (this.rowCount < 0) {
            return false;
        }
        if (this.fetchDirection == 1001) {
            if (this.presentRow + 1 <= this.rowCount) {
                ++this.presentRow;
                if (!this.showDeleted && this.getCurrentRow().isRowDeleted()) {
                    return this.previous();
                }
                this.notifyCursorMoved();
                return true;
            }
            this.presentRow = this.rowCount + 1;
            return false;
        }
        if (this.fetchDirection == 1000 || this.fetchDirection == 1002) {
            if (this.presentRow - 1 > 0) {
                --this.presentRow;
                if (!this.showDeleted && this.getCurrentRow().isRowDeleted()) {
                    return this.previous();
                }
                this.notifyCursorMoved();
                return true;
            }
            this.presentRow = 0;
            return false;
        }
        return false;
    }

    public boolean previousPage() throws SQLException {
        if (this.resultSet != null && this.resultSet.getType() == 1003) {
            throw new SQLException("The underlying ResultSet does not support this operation");
        }
        if (this.rows.size() == 0 && !this.isPopulateDone) {
            throw new SQLException("This operation can not be called without previous paging operations");
        }
        if (this.fetchDirection == 1001) {
            this.resultSet.relative(this.pageSize * 2);
        } else {
            this.resultSet.relative(-2 * this.pageSize);
        }
        this.populate(this.resultSet);
        if (this.currentPage > 0) {
            --this.currentPage;
        }
        return this.currentPage != 0;
    }

    public void refreshRow() throws SQLException {
        OracleRow oracleRow = this.getCurrentRow();
        if (oracleRow.isRowUpdated()) {
            oracleRow.cancelRowUpdates();
        }
    }

    public boolean relative(int n2) throws SQLException {
        return this.absolute(this.presentRow + n2);
    }

    public void release() throws SQLException {
        this.rows = null;
        this.rows = new Vector();
        if (this.connection != null && !this.connection.isClosed()) {
            this.connection.close();
        }
        this.rowCount = 0;
        this.presentRow = 0;
        this.notifyRowSetChanged();
    }

    public void restoreOriginal() throws SQLException {
        boolean bl2 = false;
        int n2 = 0;
        while (n2 < this.rowCount) {
            OracleRow oracleRow = (OracleRow)this.rows.elementAt(n2);
            if (oracleRow.isRowInserted()) {
                this.rows.remove(n2);
                --this.rowCount;
                --n2;
                bl2 = true;
            } else if (oracleRow.isRowUpdated()) {
                oracleRow.setRowUpdated(false);
                bl2 = true;
            } else if (oracleRow.isRowDeleted()) {
                oracleRow.setRowDeleted(false);
                bl2 = true;
            }
            ++n2;
        }
        if (!bl2) {
            throw new SQLException("None of the rows are changed");
        }
        this.notifyRowSetChanged();
        this.presentRow = 0;
    }

    public void rollback() throws SQLException {
        this.getConnectionInternal().rollback();
    }

    public boolean rowDeleted() throws SQLException {
        return this.getCurrentRow().isRowDeleted();
    }

    public boolean rowInserted() throws SQLException {
        return this.getCurrentRow().isRowInserted();
    }

    public void rowSetPopulated(RowSetEvent rowSetEvent, int n2) throws SQLException {
        if (n2 <= 0 || n2 < this.fetchSize) {
            throw new SQLException("Invalid number of row parameter specified");
        }
        if (this.rowCount % n2 == 0) {
            this.rowsetEvent = new RowSetEvent(this);
            this.notifyRowSetChanged();
        }
    }

    public boolean rowUpdated() throws SQLException {
        return this.getCurrentRow().isRowUpdated();
    }

    public void setArray(int n2, Array array) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, array);
    }

    public void setAsciiStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{inputStream, new Integer(n3), new Integer(819)};
        this.param.add(n2 - 1, objectArray);
    }

    public void setBigDecimal(int n2, BigDecimal bigDecimal) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, bigDecimal);
    }

    public void setBinaryStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{inputStream, new Integer(n3), new Integer(546)};
        this.param.add(n2 - 1, objectArray);
    }

    public void setBlob(int n2, Blob blob) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, blob);
    }

    public void setBoolean(int n2, boolean bl2) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, new Boolean(bl2));
    }

    public void setByte(int n2, byte by) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, new Byte(by));
    }

    public void setBytes(int n2, byte[] byArray) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, byArray);
    }

    public void setCharacterStream(int n2, Reader reader, int n3) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{reader, new Integer(n3)};
        this.param.add(n2 - 1, objectArray);
    }

    public void setClob(int n2, Clob clob) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, clob);
    }

    public void setDate(int n2, Date date) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, date);
    }

    public void setDate(int n2, Date date, Calendar calendar) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{date, calendar};
        this.param.add(n2 - 1, objectArray);
    }

    public void setDouble(int n2, double d2) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, new Double(d2));
    }

    public void setFetchDirection(int n2) throws SQLException {
        if (this.rowsetType == 1005) {
            throw new SQLException("Fetch direction cannot be applied when RowSet type is TYPE_SCROLL_SENSITIVE");
        }
        switch (n2) {
            case 1000: 
            case 1002: {
                this.presentRow = 0;
                break;
            }
            case 1001: {
                if (this.rowsetType == 1003) {
                    throw new SQLException("FETCH_REVERSE cannot be applied when RowSet type is TYPE_FORWARD_ONLY");
                }
                this.presentRow = this.rowCount + 1;
                break;
            }
            default: {
                throw new SQLException("Illegal fetch direction");
            }
        }
        super.setFetchDirection(n2);
    }

    public void setFloat(int n2, float f2) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, new Float(f2));
    }

    public void setInt(int n2, int n3) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, new Integer(n3));
    }

    public void setKeyColumns(int[] nArray) throws SQLException {
        int n2 = 0;
        if (this.rowsetMetaData != null) {
            n2 = this.rowsetMetaData.getColumnCount();
            if (nArray == null || nArray.length > n2) {
                throw new SQLException("Invalid number of key columns");
            }
        }
        int n3 = nArray.length;
        this.keyColumns = new int[n3];
        int n4 = 0;
        while (n4 < n3) {
            if (nArray[n4] <= 0 || nArray[n4] > n2) {
                throw new SQLException("Invalid column index: " + nArray[n4]);
            }
            this.keyColumns[n4] = nArray[n4];
            ++n4;
        }
    }

    public void setLong(int n2, long l2) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, new Long(l2));
    }

    public void setMetaData(RowSetMetaData rowSetMetaData) throws SQLException {
        this.rowsetMetaData = rowSetMetaData;
        if (rowSetMetaData != null) {
            this.colCount = rowSetMetaData.getColumnCount();
        }
    }

    public void setNull(int n2, int n3) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, null);
    }

    public void setNull(int n2, int n3, String string) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{new Integer(n3), string};
        this.param.add(n2 - 1, objectArray);
    }

    public void setObject(int n2, Object object) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, object);
    }

    public void setObject(int n2, Object object, int n3) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{object, new Integer(n3)};
        this.param.add(n2 - 1, objectArray);
    }

    public void setObject(int n2, Object object, int n3, int n4) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{object, new Integer(n3), new Integer(n4)};
        this.param.add(n2 - 1, objectArray);
    }

    void setOriginal() throws SQLException {
        int n2 = 1;
        do {
            boolean bl2;
            if (bl2 = this.setOriginalRowInternal(n2)) continue;
            ++n2;
        } while (n2 <= this.rowCount);
        this.notifyRowSetChanged();
        this.presentRow = 0;
    }

    public void setOriginalRow() throws SQLException {
        if (this.insertRowFlag) {
            throw new SQLException("Invalid operation on this row before insertRow is called");
        }
        this.setOriginalRowInternal(this.presentRow);
    }

    boolean setOriginalRowInternal(int n2) throws SQLException {
        if (n2 < 1 || n2 > this.rowCount) {
            throw new SQLException("Invalid cursor position, try next/previous first");
        }
        boolean bl2 = false;
        OracleRow oracleRow = (OracleRow)this.rows.elementAt(n2 - 1);
        if (oracleRow.isRowDeleted()) {
            this.rows.remove(n2 - 1);
            --this.rowCount;
            bl2 = true;
        } else {
            if (oracleRow.isRowInserted()) {
                oracleRow.setInsertedFlag(false);
            }
            if (oracleRow.isRowUpdated()) {
                oracleRow.makeUpdatesOriginal();
            }
        }
        return bl2;
    }

    public void setPageSize(int n2) throws SQLException {
        if (n2 < 0 || this.maxRows > 0 && n2 > this.maxRows) {
            throw new SQLException("Invalid page size specified");
        }
        this.pageSize = n2;
    }

    public void setReader(RowSetReader rowSetReader) {
        this.reader = rowSetReader;
    }

    public void setRef(int n2, Ref ref) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, ref);
    }

    public void setShort(int n2, short s2) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, new Short(s2));
    }

    public void setString(int n2, String string) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, string);
    }

    public void setTableName(String string) throws SQLException {
        this.tableName = string;
    }

    public void setTime(int n2, Time time) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, time);
    }

    public void setTime(int n2, Time time, Calendar calendar) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{time, calendar};
        this.param.add(n2 - 1, objectArray);
    }

    public void setTimestamp(int n2, Timestamp timestamp) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, timestamp);
    }

    public void setTimestamp(int n2, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{timestamp, calendar};
        this.param.add(n2 - 1, objectArray);
    }

    public void setUnicodeStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{inputStream, new Integer(n3), new Integer(273)};
        this.param.add(n2 - 1, objectArray);
    }

    public void setWriter(RowSetWriter rowSetWriter) {
        this.writer = rowSetWriter;
    }

    public int size() {
        return this.rowCount;
    }

    public Collection toCollection() throws SQLException {
        Map<Integer, Collection> map = Collections.synchronizedMap(new TreeMap());
        try {
            int n2 = 0;
            while (n2 < this.rowCount) {
                map.put(new Integer(n2), ((OracleRow)this.rows.elementAt(n2)).toCollection());
                ++n2;
            }
        }
        catch (Exception exception) {
            map = null;
            throw new SQLException("Map operation failed in toCollection()");
        }
        return map.values();
    }

    public Collection toCollection(int n2) throws SQLException {
        if (n2 < 1 || n2 > this.colCount) {
            throw new SQLException("invalid index : " + n2);
        }
        Vector<Object> vector = new Vector<Object>(this.rowCount);
        int n3 = 0;
        while (n3 < this.rowCount) {
            OracleRow oracleRow = (OracleRow)this.rows.elementAt(n3);
            Object object = oracleRow.isColumnChanged(n2) ? oracleRow.getModifiedColumn(n2) : oracleRow.getColumn(n2);
            vector.add(object);
            ++n3;
        }
        return vector;
    }

    public Collection toCollection(String string) throws SQLException {
        return this.toCollection(this.getColumnIndex(string));
    }

    public void undoDelete() throws SQLException {
        this.cancelRowDelete();
    }

    public void undoInsert() throws SQLException {
        this.cancelRowInsert();
    }

    public void undoUpdate() throws SQLException {
        this.cancelRowUpdates();
    }

    public void updateArray(int n2, Array array) throws SQLException {
        this.updateObject(n2, (Object)array);
    }

    public void updateArray(String string, Array array) throws SQLException {
        this.updateArray(this.getColumnIndex(string), array);
    }

    public synchronized void updateAsciiStream(int n2, InputStream inputStream, int n3) throws SQLException {
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            char[] cArray = new char[n3];
            int n4 = 0;
            while ((n4 += inputStreamReader.read(cArray, n4, n3 - n4)) < n3) {
            }
            this.updateObject(n2, (Object)new CharArrayReader(cArray));
            cArray = null;
        }
        catch (IOException iOException) {
            throw new SQLException("Error while reading the Stream\n" + iOException.getMessage());
        }
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n2) throws SQLException {
        this.updateAsciiStream(this.getColumnIndex(string), inputStream, n2);
    }

    public void updateBigDecimal(int n2, BigDecimal bigDecimal) throws SQLException {
        this.updateObject(n2, (Object)bigDecimal);
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.getColumnIndex(string), bigDecimal);
    }

    public synchronized void updateBinaryStream(int n2, InputStream inputStream, int n3) throws SQLException {
        try {
            byte[] byArray = new byte[n3];
            int n4 = 0;
            while ((n4 += inputStream.read(byArray, n4, n3 - n4)) < n3) {
            }
            this.updateObject(n2, (Object)new ByteArrayInputStream(byArray));
            byArray = null;
        }
        catch (IOException iOException) {
            throw new SQLException("Error while reading the Stream\n" + iOException.getMessage());
        }
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n2) throws SQLException {
        this.updateBinaryStream(this.getColumnIndex(string), inputStream, n2);
    }

    public void updateBlob(int n2, Blob blob) throws SQLException {
        this.updateObject(n2, (Object)blob);
    }

    public void updateBlob(String string, Blob blob) throws SQLException {
        this.updateBlob(this.getColumnIndex(string), blob);
    }

    public void updateBoolean(int n2, boolean bl2) throws SQLException {
        this.updateObject(n2, (Object)new Boolean(bl2));
    }

    public void updateBoolean(String string, boolean bl2) throws SQLException {
        this.updateBoolean(this.getColumnIndex(string), bl2);
    }

    public void updateByte(int n2, byte by) throws SQLException {
        this.updateObject(n2, (Object)new Byte(by));
    }

    public void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.getColumnIndex(string), by);
    }

    public void updateBytes(int n2, byte[] byArray) throws SQLException {
        this.updateObject(n2, (Object)byArray);
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.getColumnIndex(string), byArray);
    }

    public synchronized void updateCharacterStream(int n2, Reader reader, int n3) throws SQLException {
        this.checkColumnIndex(n2);
        try {
            char[] cArray = new char[n3];
            int n4 = 0;
            while ((n4 += reader.read(cArray, n4, n3 - n4)) < n3) {
            }
            this.updateObject(n2, (Object)new CharArrayReader(cArray));
            cArray = null;
        }
        catch (IOException iOException) {
            throw new SQLException("Error while reading the Stream\n" + iOException.getMessage());
        }
    }

    public void updateCharacterStream(String string, Reader reader, int n2) throws SQLException {
        this.updateCharacterStream(this.getColumnIndex(string), reader, n2);
    }

    public void updateClob(int n2, Clob clob) throws SQLException {
        this.updateObject(n2, (Object)clob);
    }

    public void updateClob(String string, Clob clob) throws SQLException {
        this.updateClob(this.getColumnIndex(string), clob);
    }

    public void updateDate(int n2, Date date) throws SQLException {
        this.updateObject(n2, (Object)date);
    }

    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.getColumnIndex(string), date);
    }

    public void updateDouble(int n2, double d2) throws SQLException {
        this.updateObject(n2, (Object)new Double(d2));
    }

    public void updateDouble(String string, double d2) throws SQLException {
        this.updateDouble(this.getColumnIndex(string), d2);
    }

    public void updateFloat(int n2, float f2) throws SQLException {
        this.updateObject(n2, (Object)new Float(f2));
    }

    public void updateFloat(String string, float f2) throws SQLException {
        this.updateFloat(this.getColumnIndex(string), f2);
    }

    public void updateInt(int n2, int n3) throws SQLException {
        this.updateObject(n2, (Object)new Integer(n3));
    }

    public void updateInt(String string, int n2) throws SQLException {
        this.updateInt(this.getColumnIndex(string), n2);
    }

    public void updateLong(int n2, long l2) throws SQLException {
        this.updateObject(n2, (Object)new Long(l2));
    }

    public void updateLong(String string, long l2) throws SQLException {
        this.updateLong(this.getColumnIndex(string), l2);
    }

    public void updateNull(int n2) throws SQLException {
        this.updateObject(n2, null);
    }

    public void updateNull(String string) throws SQLException {
        this.updateNull(this.getColumnIndex(string));
    }

    public synchronized void updateObject(int n2, Object object) throws SQLException {
        this.checkColumnIndex(n2);
        if (this.insertRowFlag) {
            this.checkAndFilterObject(n2, object);
            this.insertRow.updateObject(n2, object);
        } else if (!this.isBeforeFirst() && !this.isAfterLast()) {
            this.updateRowFlag = true;
            this.updateRowPosition = this.presentRow;
            this.getCurrentRow().updateObject(n2, object);
        } else {
            throw new SQLException("Updation not allowed on this column");
        }
    }

    public void updateObject(int n2, Object object, int n3) throws SQLException {
        if (!(object instanceof Number)) {
            throw new SQLException("Passed object is not Numeric type");
        }
        this.updateObject(n2, (Object)new BigDecimal(new BigInteger(((Number)object).toString()), n3));
    }

    public void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.getColumnIndex(string), object);
    }

    public void updateObject(String string, Object object, int n2) throws SQLException {
        this.updateObject(this.getColumnIndex(string), object, n2);
    }

    public void updateRef(int n2, Ref ref) throws SQLException {
        this.updateObject(n2, (Object)ref);
    }

    public void updateRef(String string, Ref ref) throws SQLException {
        this.updateRef(this.getColumnIndex(string), ref);
    }

    public void updateRow() throws SQLException {
        if (!this.updateRowFlag) {
            throw new SQLException("Current row not updated");
        }
        this.updateRowFlag = false;
        this.getCurrentRow().setRowUpdated(true);
        this.notifyRowChanged();
    }

    public void updateShort(int n2, short s2) throws SQLException {
        this.updateObject(n2, (Object)new Short(s2));
    }

    public void updateShort(String string, short s2) throws SQLException {
        this.updateShort(this.getColumnIndex(string), s2);
    }

    public void updateString(int n2, String string) throws SQLException {
        this.updateObject(n2, (Object)string);
    }

    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.getColumnIndex(string), string2);
    }

    public void updateTime(int n2, Time time) throws SQLException {
        this.updateObject(n2, (Object)new Timestamp(0, 0, 0, time.getHours(), time.getMinutes(), time.getSeconds(), 0));
    }

    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.getColumnIndex(string), time);
    }

    public void updateTimestamp(int n2, Timestamp timestamp) throws SQLException {
        this.updateObject(n2, (Object)timestamp);
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.getColumnIndex(string), timestamp);
    }

    public boolean wasNull() throws SQLException {
        return this.previousColumnWasNull;
    }
}

