/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.sql.RowSet;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.OracleSavepoint;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.rowset.OracleRowSet;
import oracle.jdbc.rowset.OracleRowSetMetaData;

public class OracleJDBCRowSet
extends OracleRowSet
implements RowSet {
    private Connection connection;
    private static boolean driverManagerInitialized;
    private PreparedStatement preparedStatement;
    private ResultSet resultSet;

    public OracleJDBCRowSet() throws SQLException {
        driverManagerInitialized = false;
    }

    public OracleJDBCRowSet(Connection connection) throws SQLException {
        this();
        this.connection = connection;
    }

    public boolean absolute(int n2) throws SQLException {
        boolean bl2 = this.resultSet.absolute(n2);
        if (bl2) {
            this.notifyCursorMoved();
        }
        return bl2;
    }

    public void afterLast() throws SQLException {
        if (!this.isAfterLast()) {
            this.resultSet.afterLast();
            this.notifyCursorMoved();
        }
    }

    public void beforeFirst() throws SQLException {
        if (!this.isBeforeFirst()) {
            this.resultSet.beforeFirst();
            this.notifyCursorMoved();
        }
    }

    public void cancelRowUpdates() throws SQLException {
        this.resultSet.cancelRowUpdates();
        this.notifyRowChanged();
    }

    public void clearParameters() throws SQLException {
        this.preparedStatement.clearParameters();
    }

    public void clearWarnings() throws SQLException {
        this.resultSet.clearWarnings();
    }

    public void close() throws SQLException {
        if (this.resultSet != null) {
            this.resultSet.close();
        }
        if (this.preparedStatement != null) {
            this.preparedStatement.close();
        }
        if (this.connection != null && !this.connection.isClosed()) {
            this.connection.commit();
            this.connection.close();
        }
        this.notifyRowSetChanged();
    }

    public void commit() throws SQLException {
        if (this.connection == null) {
            throw new SQLException("Connection not open");
        }
        this.connection.commit();
    }

    public void deleteRow() throws SQLException {
        this.resultSet.deleteRow();
        this.notifyRowChanged();
    }

    public void execute() throws SQLException {
        this.connection = this.getConnection(this);
        this.connection.setTransactionIsolation(this.getTransactionIsolation());
        this.connection.setTypeMap(this.getTypeMap());
        if (this.preparedStatement == null) {
            this.preparedStatement = this.connection.prepareStatement(this.getCommand(), this.getType(), this.getConcurrency());
        }
        this.preparedStatement.setFetchSize(this.getFetchSize());
        this.preparedStatement.setFetchDirection(this.getFetchDirection());
        this.preparedStatement.setMaxFieldSize(this.getMaxFieldSize());
        this.preparedStatement.setMaxRows(this.getMaxRows());
        this.preparedStatement.setQueryTimeout(this.getQueryTimeout());
        this.preparedStatement.setEscapeProcessing(this.getEscapeProcessing());
        this.resultSet = this.preparedStatement.executeQuery();
        this.notifyRowSetChanged();
    }

    public int findColumn(String string) throws SQLException {
        return this.resultSet.findColumn(string);
    }

    public boolean first() throws SQLException {
        boolean bl2 = this.resultSet.first();
        if (bl2) {
            this.notifyCursorMoved();
        }
        return bl2;
    }

    public Array getArray(int n2) throws SQLException {
        return this.resultSet.getArray(n2);
    }

    public Array getArray(String string) throws SQLException {
        return this.resultSet.getArray(string);
    }

    public InputStream getAsciiStream(int n2) throws SQLException {
        return this.resultSet.getAsciiStream(n2);
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.resultSet.getAsciiStream(string);
    }

    public boolean getAutoCommit() throws SQLException {
        if (this.connection != null) {
            return this.connection.getAutoCommit();
        }
        throw new SQLException("Connection not open");
    }

    public BigDecimal getBigDecimal(int n2) throws SQLException {
        return this.resultSet.getBigDecimal(n2);
    }

    public BigDecimal getBigDecimal(int n2, int n3) throws SQLException {
        return this.resultSet.getBigDecimal(n2, n3);
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.resultSet.getBigDecimal(string);
    }

    public BigDecimal getBigDecimal(String string, int n2) throws SQLException {
        return this.resultSet.getBigDecimal(string, n2);
    }

    public InputStream getBinaryStream(int n2) throws SQLException {
        return this.resultSet.getBinaryStream(n2);
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.resultSet.getBinaryStream(string);
    }

    public Blob getBlob(int n2) throws SQLException {
        return this.resultSet.getBlob(n2);
    }

    public Blob getBlob(String string) throws SQLException {
        return this.resultSet.getBlob(string);
    }

    public boolean getBoolean(int n2) throws SQLException {
        return this.resultSet.getBoolean(n2);
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.resultSet.getBoolean(string);
    }

    public byte getByte(int n2) throws SQLException {
        return this.resultSet.getByte(n2);
    }

    public byte getByte(String string) throws SQLException {
        return this.resultSet.getByte(string);
    }

    public byte[] getBytes(int n2) throws SQLException {
        return this.resultSet.getBytes(n2);
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.resultSet.getBytes(string);
    }

    public Reader getCharacterStream(int n2) throws SQLException {
        return this.resultSet.getCharacterStream(n2);
    }

    public Reader getCharacterStream(String string) throws SQLException {
        return this.resultSet.getCharacterStream(string);
    }

    public Clob getClob(int n2) throws SQLException {
        return this.resultSet.getClob(n2);
    }

    public Clob getClob(String string) throws SQLException {
        return this.resultSet.getClob(string);
    }

    private Connection getConnection(RowSet rowSet) throws SQLException {
        Connection connection = null;
        if (this.connection != null && !this.connection.isClosed()) {
            connection = this.connection;
        } else if (rowSet.getDataSourceName() != null) {
            try {
                InitialContext initialContext = new InitialContext();
                DataSource dataSource = (DataSource)initialContext.lookup(rowSet.getDataSourceName());
                if (rowSet.getUsername() == null || rowSet.getPassword() == null) {
                    connection = dataSource.getConnection();
                }
                connection = dataSource.getConnection(rowSet.getUsername(), rowSet.getPassword());
            }
            catch (NamingException namingException) {
                throw new SQLException("Unable to connect through the DataSource\n" + namingException.getMessage());
            }
        } else if (rowSet.getUrl() != null) {
            if (!driverManagerInitialized) {
                DriverManager.registerDriver(new OracleDriver());
                driverManagerInitialized = true;
            }
            String string = rowSet.getUrl();
            String string2 = rowSet.getUsername();
            String string3 = rowSet.getPassword();
            if (string.equals("") || string2.equals("") || string3.equals("")) {
                throw new SQLException("One or more of the authenticating parameter not set");
            }
            connection = DriverManager.getConnection(string, string2, string3);
        }
        return connection;
    }

    public String getCursorName() throws SQLException {
        return this.resultSet.getCursorName();
    }

    public Date getDate(int n2) throws SQLException {
        return this.resultSet.getDate(n2);
    }

    public Date getDate(int n2, Calendar calendar) throws SQLException {
        return this.resultSet.getDate(n2, calendar);
    }

    public Date getDate(String string) throws SQLException {
        return this.resultSet.getDate(string);
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.resultSet.getDate(string, calendar);
    }

    public double getDouble(int n2) throws SQLException {
        return this.resultSet.getDouble(n2);
    }

    public double getDouble(String string) throws SQLException {
        return this.resultSet.getDouble(string);
    }

    public float getFloat(int n2) throws SQLException {
        return this.resultSet.getFloat(n2);
    }

    public float getFloat(String string) throws SQLException {
        return this.resultSet.getFloat(string);
    }

    public int getInt(int n2) throws SQLException {
        return this.resultSet.getInt(n2);
    }

    public int getInt(String string) throws SQLException {
        return this.resultSet.getInt(string);
    }

    public long getLong(int n2) throws SQLException {
        return this.resultSet.getLong(n2);
    }

    public long getLong(String string) throws SQLException {
        return this.resultSet.getLong(string);
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return new OracleRowSetMetaData(this.resultSet.getMetaData());
    }

    public Object getObject(int n2) throws SQLException {
        return this.resultSet.getObject(n2);
    }

    public Object getObject(int n2, Map map) throws SQLException {
        return this.resultSet.getObject(n2, map);
    }

    public Object getObject(String string) throws SQLException {
        return this.resultSet.getObject(string);
    }

    public Object getObject(String string, Map map) throws SQLException {
        return this.resultSet.getObject(string, map);
    }

    public Ref getRef(int n2) throws SQLException {
        return this.resultSet.getRef(n2);
    }

    public Ref getRef(String string) throws SQLException {
        return this.resultSet.getRef(string);
    }

    public int getRow() throws SQLException {
        return this.resultSet.getRow();
    }

    public short getShort(int n2) throws SQLException {
        return this.resultSet.getShort(n2);
    }

    public short getShort(String string) throws SQLException {
        return this.resultSet.getShort(string);
    }

    public Statement getStatement() throws SQLException {
        return this.resultSet.getStatement();
    }

    public String getString(int n2) throws SQLException {
        return this.resultSet.getString(n2);
    }

    public String getString(String string) throws SQLException {
        return this.resultSet.getString(string);
    }

    String getTableName() throws SQLException {
        return this.getMetaData().getTableName(this.getMatchColumnIndexes()[0]);
    }

    public Time getTime(int n2) throws SQLException {
        return this.resultSet.getTime(n2);
    }

    public Time getTime(int n2, Calendar calendar) throws SQLException {
        return this.resultSet.getTime(n2, calendar);
    }

    public Time getTime(String string) throws SQLException {
        return this.resultSet.getTime(string);
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.resultSet.getTime(string, calendar);
    }

    public Timestamp getTimestamp(int n2) throws SQLException {
        return this.resultSet.getTimestamp(n2);
    }

    public Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        return this.resultSet.getTimestamp(n2, calendar);
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.resultSet.getTimestamp(string);
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.resultSet.getTimestamp(string, calendar);
    }

    public URL getURL(int n2) throws SQLException {
        return ((OracleResultSet)this.resultSet).getURL(n2);
    }

    public URL getURL(String string) throws SQLException {
        return ((OracleResultSet)this.resultSet).getURL(string);
    }

    public InputStream getUnicodeStream(int n2) throws SQLException {
        return this.resultSet.getUnicodeStream(n2);
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.resultSet.getUnicodeStream(string);
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.resultSet.getWarnings();
    }

    public void insertRow() throws SQLException {
        this.resultSet.insertRow();
        this.notifyRowChanged();
    }

    public boolean isAfterLast() throws SQLException {
        return this.resultSet.isAfterLast();
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.resultSet.isBeforeFirst();
    }

    public boolean isFirst() throws SQLException {
        return this.resultSet.isFirst();
    }

    public boolean isLast() throws SQLException {
        return this.resultSet.isLast();
    }

    public boolean last() throws SQLException {
        boolean bl2 = this.resultSet.last();
        if (bl2) {
            this.notifyCursorMoved();
        }
        return bl2;
    }

    public void moveToCurrentRow() throws SQLException {
        this.resultSet.moveToCurrentRow();
    }

    public void moveToInsertRow() throws SQLException {
        this.resultSet.moveToInsertRow();
    }

    public boolean next() throws SQLException {
        boolean bl2 = this.resultSet.next();
        if (bl2) {
            this.notifyCursorMoved();
        }
        return bl2;
    }

    public void oracleRollback(OracleSavepoint oracleSavepoint) throws SQLException {
        if (this.connection == null) {
            throw new SQLException("Connection not open");
        }
        ((OracleConnection)this.connection).oracleRollback(oracleSavepoint);
    }

    public boolean previous() throws SQLException {
        boolean bl2 = this.resultSet.previous();
        if (bl2) {
            this.notifyCursorMoved();
        }
        return bl2;
    }

    public void refreshRow() throws SQLException {
        this.resultSet.refreshRow();
    }

    public boolean relative(int n2) throws SQLException {
        boolean bl2 = this.resultSet.relative(n2);
        if (bl2) {
            this.notifyCursorMoved();
        }
        return bl2;
    }

    public void rollback() throws SQLException {
        if (this.connection == null) {
            throw new SQLException("Connection not open");
        }
        this.connection.rollback();
    }

    public boolean rowDeleted() throws SQLException {
        return this.resultSet.rowDeleted();
    }

    public boolean rowInserted() throws SQLException {
        return this.resultSet.rowInserted();
    }

    public boolean rowUpdated() throws SQLException {
        return this.resultSet.rowUpdated();
    }

    public void setArray(int n2, Array array) throws SQLException {
        this.preparedStatement.setArray(n2, array);
    }

    public void setAsciiStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.preparedStatement.setAsciiStream(n2, inputStream, n3);
    }

    public void setAutoCommit(boolean bl2) throws SQLException {
        if (this.connection == null) {
            throw new SQLException("Connection not open");
        }
        this.connection.setAutoCommit(bl2);
    }

    public void setBigDecimal(int n2, BigDecimal bigDecimal) throws SQLException {
        this.preparedStatement.setBigDecimal(n2, bigDecimal);
    }

    public void setBinaryStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.preparedStatement.setBinaryStream(n2, inputStream, n3);
    }

    public void setBlob(int n2, Blob blob) throws SQLException {
        this.preparedStatement.setBlob(n2, blob);
    }

    public void setBoolean(int n2, boolean bl2) throws SQLException {
        this.preparedStatement.setBoolean(n2, bl2);
    }

    public void setByte(int n2, byte by) throws SQLException {
        this.preparedStatement.setByte(n2, by);
    }

    public void setBytes(int n2, byte[] byArray) throws SQLException {
        this.preparedStatement.setBytes(n2, byArray);
    }

    public void setCharacterStream(int n2, Reader reader, int n3) throws SQLException {
        this.preparedStatement.setCharacterStream(n2, reader, n3);
    }

    public void setClob(int n2, Clob clob) throws SQLException {
        this.preparedStatement.setClob(n2, clob);
    }

    public void setCommand(String string) throws SQLException {
        super.setCommand(string);
        if (this.connection == null || this.connection.isClosed()) {
            this.connection = this.getConnection(this);
        }
        if (this.preparedStatement != null) {
            try {
                this.preparedStatement.close();
                this.preparedStatement = null;
            }
            catch (SQLException sQLException) {}
        }
        this.preparedStatement = this.connection.prepareStatement(string, this.getType(), this.getConcurrency());
    }

    public void setDate(int n2, Date date) throws SQLException {
        this.preparedStatement.setDate(n2, date);
    }

    public void setDate(int n2, Date date, Calendar calendar) throws SQLException {
        this.preparedStatement.setDate(n2, date, calendar);
    }

    public void setDouble(int n2, double d2) throws SQLException {
        this.preparedStatement.setDouble(n2, d2);
    }

    public void setFetchDirection(int n2) throws SQLException {
        super.setFetchDirection(n2);
        this.resultSet.setFetchDirection(this.fetchDirection);
    }

    public void setFloat(int n2, float f2) throws SQLException {
        this.preparedStatement.setFloat(n2, f2);
    }

    public void setInt(int n2, int n3) throws SQLException {
        this.preparedStatement.setInt(n2, n3);
    }

    public void setLong(int n2, long l2) throws SQLException {
        this.preparedStatement.setLong(n2, l2);
    }

    public void setNull(int n2, int n3) throws SQLException {
        this.preparedStatement.setNull(n2, n3);
    }

    public void setNull(int n2, int n3, String string) throws SQLException {
        this.preparedStatement.setNull(n2, n3, string);
    }

    public void setObject(int n2, Object object) throws SQLException {
        this.preparedStatement.setObject(n2, object);
    }

    public void setObject(int n2, Object object, int n3) throws SQLException {
        this.preparedStatement.setObject(n2, object, n3);
    }

    public void setObject(int n2, Object object, int n3, int n4) throws SQLException {
        this.preparedStatement.setObject(n2, object, n3, n4);
    }

    public void setReadOnly(boolean bl2) throws SQLException {
        super.setReadOnly(bl2);
        if (this.connection == null) {
            throw new SQLException("Connection not open");
        }
        this.connection.setReadOnly(bl2);
    }

    public void setRef(int n2, Ref ref) throws SQLException {
        this.preparedStatement.setRef(n2, ref);
    }

    public void setShort(int n2, short s2) throws SQLException {
        this.preparedStatement.setShort(n2, s2);
    }

    public void setShowDeleted(boolean bl2) throws SQLException {
        if (bl2) {
            throw new SQLException("This JdbcRowSet implementation does not allow deleted rows to be visible");
        }
        super.setShowDeleted(bl2);
    }

    public void setString(int n2, String string) throws SQLException {
        this.preparedStatement.setString(n2, string);
    }

    public void setTime(int n2, Time time) throws SQLException {
        this.preparedStatement.setTime(n2, time);
    }

    public void setTime(int n2, Time time, Calendar calendar) throws SQLException {
        this.preparedStatement.setTime(n2, time, calendar);
    }

    public void setTimestamp(int n2, Timestamp timestamp) throws SQLException {
        this.preparedStatement.setTimestamp(n2, timestamp);
    }

    public void setTimestamp(int n2, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.preparedStatement.setTimestamp(n2, timestamp, calendar);
    }

    public void updateArray(int n2, Array array) throws SQLException {
        ((OracleResultSet)this.resultSet).updateArray(n2, array);
    }

    public void updateArray(String string, Array array) throws SQLException {
        ((OracleResultSet)this.resultSet).updateArray(string, array);
    }

    public void updateAsciiStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.resultSet.updateAsciiStream(n2, inputStream, n3);
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n2) throws SQLException {
        this.resultSet.updateAsciiStream(string, inputStream, n2);
    }

    public void updateBigDecimal(int n2, BigDecimal bigDecimal) throws SQLException {
        this.resultSet.updateBigDecimal(n2, bigDecimal);
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.resultSet.updateBigDecimal(string, bigDecimal);
    }

    public void updateBinaryStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.resultSet.updateBinaryStream(n2, inputStream, n3);
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n2) throws SQLException {
        this.resultSet.updateBinaryStream(string, inputStream, n2);
    }

    public void updateBlob(int n2, Blob blob) throws SQLException {
        ((OracleResultSet)this.resultSet).updateBlob(n2, blob);
    }

    public void updateBlob(String string, Blob blob) throws SQLException {
        ((OracleResultSet)this.resultSet).updateBlob(string, blob);
    }

    public void updateBoolean(int n2, boolean bl2) throws SQLException {
        this.resultSet.updateBoolean(n2, bl2);
    }

    public void updateBoolean(String string, boolean bl2) throws SQLException {
        this.resultSet.updateBoolean(string, bl2);
    }

    public void updateByte(int n2, byte by) throws SQLException {
        this.resultSet.updateByte(n2, by);
    }

    public void updateByte(String string, byte by) throws SQLException {
        this.resultSet.updateByte(string, by);
    }

    public void updateBytes(int n2, byte[] byArray) throws SQLException {
        this.resultSet.updateBytes(n2, byArray);
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.resultSet.updateBytes(string, byArray);
    }

    public void updateCharacterStream(int n2, Reader reader, int n3) throws SQLException {
        this.resultSet.updateCharacterStream(n2, reader, n3);
    }

    public void updateCharacterStream(String string, Reader reader, int n2) throws SQLException {
        this.resultSet.updateCharacterStream(string, reader, n2);
    }

    public void updateClob(int n2, Clob clob) throws SQLException {
        ((OracleResultSet)this.resultSet).updateClob(n2, clob);
    }

    public void updateClob(String string, Clob clob) throws SQLException {
        ((OracleResultSet)this.resultSet).updateClob(string, clob);
    }

    public void updateDate(int n2, Date date) throws SQLException {
        this.resultSet.updateDate(n2, date);
    }

    public void updateDate(String string, Date date) throws SQLException {
        this.resultSet.updateDate(string, date);
    }

    public void updateDouble(int n2, double d2) throws SQLException {
        this.resultSet.updateDouble(n2, d2);
    }

    public void updateDouble(String string, double d2) throws SQLException {
        this.resultSet.updateDouble(string, d2);
    }

    public void updateFloat(int n2, float f2) throws SQLException {
        this.resultSet.updateFloat(n2, f2);
    }

    public void updateFloat(String string, float f2) throws SQLException {
        this.resultSet.updateFloat(string, f2);
    }

    public void updateInt(int n2, int n3) throws SQLException {
        this.resultSet.updateInt(n2, n3);
    }

    public void updateInt(String string, int n2) throws SQLException {
        this.resultSet.updateInt(string, n2);
    }

    public void updateLong(int n2, long l2) throws SQLException {
        this.resultSet.updateLong(n2, l2);
    }

    public void updateLong(String string, long l2) throws SQLException {
        this.resultSet.updateLong(string, l2);
    }

    public void updateNull(int n2) throws SQLException {
        this.resultSet.updateNull(n2);
    }

    public void updateNull(String string) throws SQLException {
        this.resultSet.updateNull(string);
    }

    public void updateObject(int n2, Object object) throws SQLException {
        this.resultSet.updateObject(n2, object);
    }

    public void updateObject(int n2, Object object, int n3) throws SQLException {
        this.resultSet.updateObject(n2, object, n3);
    }

    public void updateObject(String string, Object object) throws SQLException {
        this.resultSet.updateObject(string, object);
    }

    public void updateObject(String string, Object object, int n2) throws SQLException {
        this.resultSet.updateObject(string, object, n2);
    }

    public void updateRef(int n2, Ref ref) throws SQLException {
        ((OracleResultSet)this.resultSet).updateRef(n2, ref);
    }

    public void updateRef(String string, Ref ref) throws SQLException {
        ((OracleResultSet)this.resultSet).updateRef(string, ref);
    }

    public void updateRow() throws SQLException {
        this.resultSet.updateRow();
        this.notifyRowChanged();
    }

    public void updateShort(int n2, short s2) throws SQLException {
        this.resultSet.updateShort(n2, s2);
    }

    public void updateShort(String string, short s2) throws SQLException {
        this.resultSet.updateShort(string, s2);
    }

    public void updateString(int n2, String string) throws SQLException {
        this.resultSet.updateString(n2, string);
    }

    public void updateString(String string, String string2) throws SQLException {
        this.resultSet.updateString(string, string2);
    }

    public void updateTime(int n2, Time time) throws SQLException {
        this.resultSet.updateTime(n2, time);
    }

    public void updateTime(String string, Time time) throws SQLException {
        this.resultSet.updateTime(string, time);
    }

    public void updateTimestamp(int n2, Timestamp timestamp) throws SQLException {
        this.resultSet.updateTimestamp(n2, timestamp);
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.resultSet.updateTimestamp(string, timestamp);
    }

    public boolean wasNull() throws SQLException {
        return this.resultSet.wasNull();
    }
}

