/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Vector;
import javax.sql.RowSet;
import javax.sql.RowSetMetaData;
import oracle.jdbc.rowset.OracleCachedRowSet;
import oracle.jdbc.rowset.OracleJDBCRowSet;
import oracle.jdbc.rowset.OracleJoinable;
import oracle.jdbc.rowset.OracleRow;
import oracle.jdbc.rowset.OracleRowSet;
import oracle.jdbc.rowset.OracleRowSetMetaData;
import oracle.jdbc.rowset.OracleWebRowSet;

public class OracleJoinRowSet
extends OracleWebRowSet {
    public static final int CROSS_JOIN = 0;
    public static final int INNER_JOIN = 1;
    public static final int LEFT_OUTER_JOIN = 2;
    public static final int RIGHT_OUTER_JOIN = 3;
    public static final int FULL_JOIN = 4;
    private static final String MATCH_COLUMN_SUFFIX = "#MATCH_COLUMN";
    private static boolean[] supportedJoins;
    private int joinType = 1;
    private Vector addedRowSets = new Vector();
    private Vector addedRowSetNames = new Vector();
    private Object lockForJoinActions;

    static {
        boolean[] blArray = new boolean[5];
        blArray[1] = true;
        supportedJoins = blArray;
    }

    public synchronized void addRowSet(RowSet rowSet, int n2) throws SQLException {
        ((OracleRowSet)((Object)rowSet)).setMatchColumn(n2);
        this.addRowSet((OracleJoinable)((Object)rowSet));
    }

    public synchronized void addRowSet(RowSet rowSet, String string) throws SQLException {
        ((OracleRowSet)((Object)rowSet)).setMatchColumn(string);
        this.addRowSet((OracleJoinable)((Object)rowSet));
    }

    public synchronized void addRowSet(OracleJoinable oracleJoinable) throws SQLException {
        if (oracleJoinable == null) {
            throw new SQLException("Invalid empty RowSet parameter");
        }
        if (!(oracleJoinable instanceof RowSet)) {
            throw new SQLException("The parameter is not a RowSet instance");
        }
        OracleCachedRowSet oracleCachedRowSet = this.checkAndWrapRowSet((RowSet)((Object)oracleJoinable));
        String string = this.getMatchColumnTableName((RowSet)((Object)oracleJoinable));
        switch (this.joinType) {
            case 1: {
                this.doInnerJoin(oracleCachedRowSet);
                this.addedRowSets.add(oracleJoinable);
                this.addedRowSetNames.add(string);
                break;
            }
            default: {
                throw new SQLException("Join type is not supported");
            }
        }
    }

    public synchronized void addRowSet(RowSet[] rowSetArray, int[] nArray) throws SQLException {
        if (rowSetArray.length != nArray.length) {
            throw new SQLException("Number of elements in rowsets is not equal to match columns");
        }
        int n2 = 0;
        while (n2 < rowSetArray.length) {
            ((OracleRowSet)((Object)rowSetArray[n2])).setMatchColumn(nArray[n2]);
            this.addRowSet((OracleJoinable)((Object)rowSetArray[n2]));
            ++n2;
        }
    }

    public synchronized void addRowSet(RowSet[] rowSetArray, String[] stringArray) throws SQLException {
        if (rowSetArray.length != stringArray.length) {
            throw new SQLException("Number of elements in rowsets is not equal to match columns");
        }
        int n2 = 0;
        while (n2 < rowSetArray.length) {
            ((OracleRowSet)((Object)rowSetArray[n2])).setMatchColumn(stringArray[n2]);
            this.addRowSet((OracleJoinable)((Object)rowSetArray[n2]));
            ++n2;
        }
    }

    private OracleCachedRowSet checkAndWrapRowSet(RowSet rowSet) throws SQLException {
        OracleCachedRowSet oracleCachedRowSet;
        if (rowSet instanceof OracleCachedRowSet) {
            oracleCachedRowSet = (OracleCachedRowSet)rowSet;
        } else if (rowSet instanceof OracleJDBCRowSet) {
            oracleCachedRowSet = new OracleCachedRowSet();
            oracleCachedRowSet.populate(rowSet);
            int[] nArray = ((OracleJDBCRowSet)rowSet).getMatchColumnIndexes();
            oracleCachedRowSet.setMatchColumn(nArray);
        } else {
            throw new SQLException("Third-party RowSet Join not yet supported");
        }
        return oracleCachedRowSet;
    }

    private void doInnerJoin(OracleCachedRowSet oracleCachedRowSet) throws SQLException {
        if (this.addedRowSets.isEmpty()) {
            this.setMetaData((RowSetMetaData)oracleCachedRowSet.getMetaData());
            this.populate(oracleCachedRowSet);
            this.setMatchColumn(oracleCachedRowSet.getMatchColumnIndexes());
        } else {
            int n2;
            boolean bl2;
            Vector<Object> vector = new Vector<Object>(100);
            OracleRowSetMetaData oracleRowSetMetaData = new OracleRowSetMetaData(10);
            int[] nArray = this.getMatchColumnIndexes();
            int[] nArray2 = oracleCachedRowSet.getMatchColumnIndexes();
            int n3 = this.getMetaData().getColumnCount() + oracleCachedRowSet.getMetaData().getColumnCount() - nArray2.length;
            oracleRowSetMetaData.setColumnCount(n3);
            String string = String.valueOf(this.getTableName()) + "#" + oracleCachedRowSet.getTableName();
            int n4 = 1;
            while (n4 <= this.colCount) {
                bl2 = false;
                int n5 = 0;
                while (n5 < nArray.length) {
                    if (n4 == nArray[n5]) {
                        bl2 = true;
                        break;
                    }
                    ++n5;
                }
                this.setNewColumnMetaData(n4, oracleRowSetMetaData, n4, (RowSetMetaData)this.rowsetMetaData, bl2, string);
                ++n4;
            }
            RowSetMetaData rowSetMetaData = (RowSetMetaData)oracleCachedRowSet.getMetaData();
            int n6 = rowSetMetaData.getColumnCount();
            int n7 = this.colCount + 1;
            int[] nArray3 = new int[n6];
            int n8 = 1;
            while (n8 <= n6) {
                bl2 = false;
                n2 = 0;
                while (n2 < nArray2.length) {
                    if (n8 == nArray[n2]) {
                        bl2 = true;
                        break;
                    }
                    ++n2;
                }
                if (!bl2) {
                    this.setNewColumnMetaData(n7, oracleRowSetMetaData, n8, rowSetMetaData, bl2, string);
                    nArray3[n8 - 1] = n7++;
                } else {
                    nArray3[n8 - 1] = -1;
                }
                ++n8;
            }
            this.beforeFirst();
            n2 = oracleCachedRowSet.size();
            boolean bl3 = false;
            int n9 = 1;
            while (n9 <= this.rowCount) {
                this.next();
                oracleCachedRowSet.beforeFirst();
                int n10 = 1;
                while (n10 <= n2) {
                    Object object;
                    oracleCachedRowSet.next();
                    bl3 = true;
                    int n11 = 0;
                    while (n11 < nArray.length) {
                        Object object2;
                        object = this.getObject(nArray[n11]);
                        if (!object.equals(object2 = oracleCachedRowSet.getObject(nArray2[n11]))) {
                            bl3 = false;
                            break;
                        }
                        ++n11;
                    }
                    if (bl3) {
                        object = new OracleRow(n3, true);
                        int n12 = 1;
                        while (n12 <= this.colCount) {
                            ((OracleRow)object).updateObject(n12, this.getObject(n12));
                            ++n12;
                        }
                        int n13 = 1;
                        while (n13 <= n6) {
                            if (nArray3[n13 - 1] != -1) {
                                ((OracleRow)object).updateObject(nArray3[n13 - 1], oracleCachedRowSet.getObject(n13));
                            }
                            ++n13;
                        }
                        vector.add(object);
                    }
                    ++n10;
                }
                ++n9;
            }
            this.rows = vector;
            this.presentRow = 0;
            this.rowCount = this.rows.size();
            this.setMetaData(oracleRowSetMetaData);
        }
    }

    public int getJoinType() {
        return this.joinType;
    }

    private String getMatchColumnTableName(RowSet rowSet) throws SQLException {
        String string = null;
        if (rowSet instanceof OracleRowSet) {
            string = ((OracleRowSet)((Object)rowSet)).getTableName();
        }
        return string;
    }

    public String[] getRowSetNames() throws SQLException {
        Object[] objectArray = this.addedRowSetNames.toArray();
        String[] stringArray = new String[objectArray.length];
        int n2 = 0;
        while (n2 < objectArray.length) {
            stringArray[n2] = (String)objectArray[n2];
            ++n2;
        }
        return stringArray;
    }

    public Collection getRowSets() throws SQLException {
        return this.addedRowSets;
    }

    public synchronized String getWhereClause() throws SQLException {
        if (this.addedRowSets.size() < 2) {
            return "WHERE";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("WHERE\n");
        OracleRowSet oracleRowSet = (OracleRowSet)this.addedRowSets.get(0);
        int[] nArray = oracleRowSet.getMatchColumnIndexes();
        ResultSetMetaData resultSetMetaData = oracleRowSet.getMetaData();
        String string = oracleRowSet.getTableName();
        int n2 = 1;
        while (n2 < this.addedRowSets.size()) {
            if (n2 > 1) {
                stringBuffer.append("\nAND\n");
            }
            OracleRowSet oracleRowSet2 = (OracleRowSet)this.addedRowSets.get(n2);
            int[] nArray2 = oracleRowSet2.getMatchColumnIndexes();
            ResultSetMetaData resultSetMetaData2 = oracleRowSet2.getMetaData();
            String string2 = oracleRowSet2.getTableName();
            int n3 = 0;
            while (n3 < nArray.length) {
                if (n3 > 0) {
                    stringBuffer.append("\nAND\n");
                }
                stringBuffer.append("(" + string + "." + resultSetMetaData.getColumnName(nArray[n3]) + " = " + string2 + "." + resultSetMetaData2.getColumnName(nArray2[n3]) + ")");
                ++n3;
            }
            oracleRowSet = oracleRowSet2;
            nArray = nArray2;
            resultSetMetaData = resultSetMetaData2;
            string = string2;
            ++n2;
        }
        stringBuffer.append(";");
        return stringBuffer.toString();
    }

    public void setJoinType(int n2) throws SQLException {
        if (n2 != 1) {
            throw new SQLException("Join type is not supported");
        }
        this.joinType = n2;
    }

    private void setNewColumnMetaData(int n2, RowSetMetaData rowSetMetaData, int n3, RowSetMetaData rowSetMetaData2, boolean bl2, String string) throws SQLException {
        rowSetMetaData.setAutoIncrement(n2, rowSetMetaData2.isAutoIncrement(n3));
        rowSetMetaData.setCaseSensitive(n2, rowSetMetaData2.isCaseSensitive(n3));
        rowSetMetaData.setCatalogName(n2, rowSetMetaData2.getCatalogName(n3));
        rowSetMetaData.setColumnDisplaySize(n2, rowSetMetaData2.getColumnDisplaySize(n3));
        if (bl2) {
            rowSetMetaData.setColumnName(n2, String.valueOf(rowSetMetaData2.getColumnName(n2)) + MATCH_COLUMN_SUFFIX);
        } else {
            rowSetMetaData.setColumnName(n2, rowSetMetaData2.getColumnName(n3));
        }
        rowSetMetaData.setColumnLabel(n2, rowSetMetaData.getColumnName(n3));
        rowSetMetaData.setColumnType(n2, rowSetMetaData2.getColumnType(n3));
        rowSetMetaData.setColumnTypeName(n2, rowSetMetaData2.getColumnTypeName(n3));
        rowSetMetaData.setCurrency(n2, rowSetMetaData2.isCurrency(n3));
        rowSetMetaData.setNullable(n2, rowSetMetaData2.isNullable(n3));
        rowSetMetaData.setPrecision(n2, rowSetMetaData2.getPrecision(n3));
        rowSetMetaData.setScale(n2, rowSetMetaData2.getScale(n3));
        rowSetMetaData.setSchemaName(n2, rowSetMetaData2.getSchemaName(n3));
        rowSetMetaData.setSearchable(n2, rowSetMetaData2.isSearchable(n3));
        rowSetMetaData.setSigned(n2, rowSetMetaData2.isSigned(n3));
        if (bl2) {
            rowSetMetaData.setTableName(n2, string);
        } else {
            rowSetMetaData.setTableName(n2, rowSetMetaData2.getTableName(n3));
        }
    }

    public boolean supportsCrossJoin() {
        return supportedJoins[0];
    }

    public boolean supportsFullJoin() {
        return supportedJoins[4];
    }

    public boolean supportsInnerJoin() {
        return supportedJoins[1];
    }

    public boolean supportsLeftOuterJoin() {
        return supportedJoins[2];
    }

    public boolean supportsRightOuterJoin() {
        return supportedJoins[3];
    }

    public OracleCachedRowSet toCachedRowSet() throws SQLException {
        OracleCachedRowSet oracleCachedRowSet = this.createCopy();
        oracleCachedRowSet.setCommand("");
        return oracleCachedRowSet;
    }
}

