/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.Vector;

public class OracleRow
implements Serializable,
Cloneable {
    private Object[] column;
    private Object[] changedColumn;
    private boolean[] isOriginalNull;
    private byte[] columnChangeFlag;
    private int noColumn = 0;
    private int noColumnsInserted;
    private boolean rowDeleted = false;
    private boolean rowInserted = false;
    private final byte COLUMN_CHANGED = (byte)17;
    private boolean rowUpdated = false;

    public OracleRow(int n2) {
        this.noColumn = n2;
        this.column = new Object[n2];
        this.changedColumn = new Object[n2];
        this.columnChangeFlag = new byte[n2];
        this.isOriginalNull = new boolean[n2];
        int n3 = 0;
        while (n3 < n2) {
            this.columnChangeFlag[n3] = 0;
            ++n3;
        }
    }

    public OracleRow(int n2, boolean bl2) {
        this(n2);
        this.rowInserted = bl2;
        this.noColumnsInserted = 0;
    }

    public OracleRow(int n2, Object[] objectArray) {
        this(n2);
        System.arraycopy(objectArray, 0, this.column, 0, n2);
    }

    public void cancelRowDeletion() {
        this.rowDeleted = false;
    }

    public void cancelRowUpdates() {
        this.noColumnsInserted = 0;
        int n2 = 0;
        while (n2 < this.noColumn) {
            this.columnChangeFlag[n2] = 0;
            ++n2;
        }
        this.changedColumn = null;
        this.changedColumn = new Object[this.noColumn];
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            return this.createCopy();
        }
        catch (SQLException sQLException) {
            throw new CloneNotSupportedException("Error while cloning\n" + sQLException.getMessage());
        }
    }

    public OracleRow createCopy() throws SQLException {
        OracleRow oracleRow = new OracleRow(this.noColumn);
        int n2 = 0;
        while (n2 < this.noColumn) {
            oracleRow.column[n2] = this.getCopy(this.column[n2]);
            oracleRow.changedColumn[n2] = this.getCopy(this.changedColumn[n2]);
            ++n2;
        }
        System.arraycopy(this.columnChangeFlag, 0, oracleRow.columnChangeFlag, 0, this.noColumn);
        oracleRow.noColumnsInserted = this.noColumnsInserted;
        oracleRow.rowDeleted = this.rowDeleted;
        oracleRow.rowInserted = this.rowInserted;
        oracleRow.rowUpdated = this.rowUpdated;
        return oracleRow;
    }

    public Object getColumn(int n2) {
        return this.column[n2 - 1];
    }

    public Object getCopy(Object object) throws SQLException {
        Object object2;
        block9: {
            object2 = null;
            try {
                if (object == null) {
                    return null;
                }
                if (object instanceof String) {
                    object2 = new String((String)object);
                    break block9;
                }
                if (object instanceof Number) {
                    object2 = new BigDecimal(((Number)object).toString());
                    break block9;
                }
                if (object instanceof java.sql.Date) {
                    object2 = new java.sql.Date(((java.sql.Date)object).getTime());
                    break block9;
                }
                if (object instanceof Timestamp) {
                    object2 = new Timestamp(((Date)((Timestamp)object)).getTime());
                    break block9;
                }
                if (object instanceof InputStream) {
                    object2 = new DataInputStream((InputStream)object);
                    break block9;
                }
                if (object instanceof OutputStream) {
                    object2 = new DataOutputStream((OutputStream)object);
                    break block9;
                }
                throw new SQLException("Error, could not reproduce the copy of the object, " + object.getClass().getName());
            }
            catch (Exception exception) {
                throw new SQLException("Error while creating a copy of the column of type, " + object.getClass().getName() + "\n" + exception.getMessage());
            }
        }
        return object2;
    }

    public Object getModifiedColumn(int n2) {
        return this.changedColumn[n2 - 1];
    }

    public Object[] getOriginalRow() {
        return this.column;
    }

    public void insertRow() {
        this.columnChangeFlag = null;
        this.columnChangeFlag = new byte[this.noColumn];
        System.arraycopy(this.changedColumn, 0, this.column, 0, this.noColumn);
        this.changedColumn = null;
        this.changedColumn = new Object[this.noColumn];
    }

    public boolean isColumnChanged(int n2) {
        return this.columnChangeFlag[n2 - 1] == 17;
    }

    boolean isOriginalNull(int n2) throws SQLException {
        return this.isOriginalNull[n2 - 1];
    }

    public boolean isRowDeleted() {
        return this.rowDeleted;
    }

    public boolean isRowFullyPopulated() {
        if (!this.rowInserted) {
            return false;
        }
        return this.noColumnsInserted == this.noColumn;
    }

    public boolean isRowInserted() {
        return this.rowInserted;
    }

    public boolean isRowUpdated() {
        if (this.rowInserted || this.rowDeleted) {
            return false;
        }
        int n2 = 0;
        while (n2 < this.noColumn) {
            if (this.columnChangeFlag[n2] == 17) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    void makeUpdatesOriginal() {
        int n2 = 0;
        while (n2 < this.noColumn) {
            if (this.columnChangeFlag[n2] == 17) {
                this.column[n2] = this.changedColumn[n2];
                this.changedColumn[n2] = null;
                this.columnChangeFlag[n2] = 0;
            }
            ++n2;
        }
        this.rowUpdated = false;
    }

    void markOriginalNull(int n2, boolean bl2) throws SQLException {
        this.isOriginalNull[n2 - 1] = bl2;
    }

    public void setColumnValue(int n2, Object object) {
        if (this.rowInserted) {
            ++this.noColumnsInserted;
        }
        this.column[n2 - 1] = object;
    }

    public void setInsertedFlag(boolean bl2) {
        this.rowInserted = bl2;
    }

    public void setRowDeleted(boolean bl2) {
        this.rowDeleted = bl2;
    }

    public void setRowUpdated(boolean bl2) {
        this.rowUpdated = bl2;
        if (!bl2) {
            this.cancelRowUpdates();
        }
    }

    public Collection toCollection() {
        Vector<Object> vector = new Vector<Object>(this.noColumn);
        int n2 = 1;
        while (n2 <= this.noColumn) {
            vector.add(this.isColumnChanged(n2) ? this.getModifiedColumn(n2) : this.getColumn(n2));
            ++n2;
        }
        return vector;
    }

    public void updateObject(int n2, Object object) {
        if (this.rowInserted) {
            ++this.noColumnsInserted;
        }
        this.columnChangeFlag[n2 - 1] = 17;
        this.changedColumn[n2 - 1] = object;
    }
}

