/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.Serializable;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.sql.RowSet;
import javax.sql.RowSetEvent;
import javax.sql.RowSetListener;
import oracle.jdbc.rowset.OracleJoinable;

abstract class OracleRowSet
implements Serializable,
Cloneable,
OracleJoinable {
    protected String dataSource;
    protected String dataSourceName;
    protected String url;
    protected String username;
    protected String password;
    protected Map typeMap;
    protected int maxFieldSize;
    protected int maxRows;
    protected int queryTimeout;
    protected int fetchSize;
    protected int transactionIsolation;
    protected boolean escapeProcessing;
    protected String command;
    protected int concurrency;
    protected boolean readOnly;
    protected int fetchDirection;
    protected int rowsetType;
    protected boolean showDeleted;
    protected Vector listener;
    protected RowSetEvent rowsetEvent;
    protected Vector matchColumnIndexes;
    protected Vector matchColumnNames;

    protected OracleRowSet() throws SQLException {
        this.initializeProperties();
        this.matchColumnIndexes = new Vector(10);
        this.matchColumnNames = new Vector(10);
        this.listener = new Vector();
        this.rowsetEvent = new RowSetEvent((RowSet)((Object)this));
    }

    public void addRowSetListener(RowSetListener rowSetListener) {
        int n2 = 0;
        while (n2 < this.listener.size()) {
            if (this.listener.elementAt(n2).equals(rowSetListener)) {
                return;
            }
            ++n2;
        }
        this.listener.add(rowSetListener);
    }

    protected void checkIfMatchColumnIndexesSet() throws SQLException {
        if (this.matchColumnIndexes.size() == 0) {
            throw new SQLException("No match column indexes were set");
        }
    }

    protected void checkIfMatchColumnNamesSet() throws SQLException {
        if (this.matchColumnNames.size() == 0) {
            throw new SQLException("No match column names were set");
        }
    }

    public abstract int findColumn(String var1) throws SQLException;

    public String getCommand() {
        return this.command;
    }

    public int getConcurrency() throws SQLException {
        return this.concurrency;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public boolean getEscapeProcessing() throws SQLException {
        return this.escapeProcessing;
    }

    public int getFetchDirection() throws SQLException {
        return this.fetchDirection;
    }

    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    public int[] getMatchColumnIndexes() throws SQLException {
        int[] nArray;
        if (this.matchColumnIndexes.size() == 0 && this.matchColumnNames.size() == 0) {
            throw new SQLException("No match column indexes were set");
        }
        if (this.matchColumnNames.size() > 0) {
            String[] stringArray = this.getMatchColumnNames();
            int n2 = stringArray.length;
            nArray = new int[n2];
            int n3 = 0;
            while (n3 < n2) {
                nArray[n3] = this.findColumn(stringArray[n3]);
                ++n3;
            }
        } else {
            int n4 = this.matchColumnIndexes.size();
            nArray = new int[n4];
            int n5 = -1;
            int n6 = 0;
            while (n6 < n4) {
                try {
                    n5 = (Integer)this.matchColumnIndexes.get(n6);
                }
                catch (Exception exception) {
                    throw new SQLException("Invalid match column index");
                }
                if (n5 <= 0) {
                    throw new SQLException("Invalid match column index");
                }
                nArray[n6] = n5;
                ++n6;
            }
        }
        return nArray;
    }

    public String[] getMatchColumnNames() throws SQLException {
        this.checkIfMatchColumnNamesSet();
        int n2 = this.matchColumnNames.size();
        String[] stringArray = new String[n2];
        String string = null;
        int n3 = 0;
        while (n3 < n2) {
            try {
                string = (String)this.matchColumnNames.get(n3);
            }
            catch (Exception exception) {
                throw new SQLException("Invalid match column name");
            }
            if (string == null || string.equals("")) {
                throw new SQLException("Invalid match column name");
            }
            stringArray[n3] = string;
            ++n3;
        }
        return stringArray;
    }

    public int getMaxFieldSize() throws SQLException {
        return this.maxFieldSize;
    }

    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    public abstract ResultSetMetaData getMetaData() throws SQLException;

    public String getPassword() {
        return this.password;
    }

    public int getQueryTimeout() throws SQLException {
        return this.queryTimeout;
    }

    public boolean getReadOnly() {
        return this.isReadOnly();
    }

    public boolean getShowDeleted() {
        return this.showDeleted;
    }

    abstract String getTableName() throws SQLException;

    public int getTransactionIsolation() {
        return this.transactionIsolation;
    }

    public int getType() throws SQLException {
        return this.rowsetType;
    }

    public Map getTypeMap() throws SQLException {
        return this.typeMap;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    protected void initializeProperties() {
        this.command = null;
        this.concurrency = 1007;
        this.dataSource = null;
        this.dataSourceName = null;
        this.escapeProcessing = true;
        this.fetchDirection = 1002;
        this.fetchSize = 0;
        this.maxFieldSize = 0;
        this.maxRows = 0;
        this.queryTimeout = 0;
        this.readOnly = true;
        this.showDeleted = false;
        this.transactionIsolation = 2;
        this.rowsetType = 1005;
        this.typeMap = new HashMap();
        this.username = null;
        this.password = null;
        this.url = null;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    protected synchronized void notifyCursorMoved() {
        int n2 = this.listener.size();
        if (n2 > 0) {
            int n3 = 0;
            while (n3 < n2) {
                ((RowSetListener)this.listener.elementAt(n3)).cursorMoved(this.rowsetEvent);
                ++n3;
            }
        }
    }

    protected void notifyRowChanged() {
        int n2 = this.listener.size();
        if (n2 > 0) {
            int n3 = 0;
            while (n3 < n2) {
                ((RowSetListener)this.listener.elementAt(n3)).rowChanged(this.rowsetEvent);
                ++n3;
            }
        }
    }

    protected void notifyRowSetChanged() {
        int n2 = this.listener.size();
        if (n2 > 0) {
            int n3 = 0;
            while (n3 < n2) {
                ((RowSetListener)this.listener.elementAt(n3)).rowSetChanged(this.rowsetEvent);
                ++n3;
            }
        }
    }

    public void removeRowSetListener(RowSetListener rowSetListener) {
        int n2 = 0;
        while (n2 < this.listener.size()) {
            if (this.listener.elementAt(n2).equals(rowSetListener)) {
                this.listener.remove(n2);
            }
            ++n2;
        }
    }

    public void setCommand(String string) throws SQLException {
        this.command = string;
    }

    public void setConcurrency(int n2) throws SQLException {
        if (n2 != 1007 && n2 != 1008) {
            throw new SQLException("Invalid concurrancy mode");
        }
        this.concurrency = n2;
    }

    public void setDataSource(String string) {
        this.dataSource = string;
    }

    public void setDataSourceName(String string) throws SQLException {
        this.dataSourceName = string;
    }

    public void setEscapeProcessing(boolean bl2) throws SQLException {
        this.escapeProcessing = bl2;
    }

    public void setFetchDirection(int n2) throws SQLException {
        this.fetchDirection = n2;
    }

    public void setFetchSize(int n2) throws SQLException {
        this.fetchSize = n2;
    }

    public void setMatchColumn(int n2) throws SQLException {
        if (n2 <= 0) {
            throw new SQLException("The match column index should be greater than 0");
        }
        try {
            this.matchColumnIndexes.clear();
            this.matchColumnNames.clear();
            this.matchColumnIndexes.add(0, new Integer(n2));
        }
        catch (Exception exception) {
            throw new SQLException("The match column index could not be set");
        }
    }

    public void setMatchColumn(String string) throws SQLException {
        if (string == null || string.equals("")) {
            throw new SQLException("The match column name should be non-empty");
        }
        try {
            this.matchColumnIndexes.clear();
            this.matchColumnNames.clear();
            this.matchColumnNames.add(0, string.trim());
        }
        catch (Exception exception) {
            throw new SQLException("The match column name could not be set");
        }
    }

    public void setMatchColumn(int[] nArray) throws SQLException {
        this.matchColumnIndexes.clear();
        this.matchColumnNames.clear();
        if (nArray == null) {
            throw new SQLException("The match column parameter is null");
        }
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] <= 0) {
                throw new SQLException("The match column index should be greater than 0");
            }
            try {
                this.matchColumnIndexes.add(n2, new Integer(nArray[n2]));
            }
            catch (Exception exception) {
                throw new SQLException("The match column index could not be set");
            }
            ++n2;
        }
    }

    public void setMatchColumn(String[] stringArray) throws SQLException {
        this.matchColumnIndexes.clear();
        this.matchColumnNames.clear();
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2] == null || stringArray[n2].equals("")) {
                throw new SQLException("The match column name should be non-empty");
            }
            try {
                this.matchColumnNames.add(n2, stringArray[n2].trim());
            }
            catch (Exception exception) {
                throw new SQLException("The match column name could not be set");
            }
            ++n2;
        }
    }

    public void setMaxFieldSize(int n2) throws SQLException {
        this.maxFieldSize = n2;
    }

    public void setMaxRows(int n2) throws SQLException {
        this.maxRows = n2;
    }

    public void setPassword(String string) throws SQLException {
        this.password = string;
    }

    public void setQueryTimeout(int n2) throws SQLException {
        this.queryTimeout = n2;
    }

    public void setReadOnly(boolean bl2) throws SQLException {
        this.readOnly = bl2;
    }

    public void setShowDeleted(boolean bl2) throws SQLException {
        this.showDeleted = bl2;
    }

    public void setTransactionIsolation(int n2) throws SQLException {
        this.transactionIsolation = n2;
    }

    public void setType(int n2) throws SQLException {
        if (n2 != 1003 && n2 != 1004 && n2 != 1005) {
            throw new SQLException("Unknown RowSet type");
        }
        this.rowsetType = n2;
    }

    public void setTypeMap(Map map) throws SQLException {
        this.typeMap = map;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public void setUsername(String string) throws SQLException {
        this.username = string;
    }

    public void unsetMatchColumn(int n2) throws SQLException {
        this.checkIfMatchColumnIndexesSet();
        if (n2 <= 0) {
            throw new SQLException("The match column index should be greater than 0");
        }
        int n3 = -1;
        try {
            n3 = (Integer)this.matchColumnIndexes.get(0);
        }
        catch (Exception exception) {
            throw new SQLException("No match column indexes were set");
        }
        if (n3 != n2) {
            throw new SQLException("The column index being unset has not been set");
        }
        this.matchColumnIndexes.clear();
        this.matchColumnNames.clear();
    }

    public void unsetMatchColumn(String string) throws SQLException {
        this.checkIfMatchColumnNamesSet();
        if (string == null || string.equals("")) {
            throw new SQLException("The match column name should be non-empty");
        }
        String string2 = null;
        try {
            string2 = (String)this.matchColumnNames.get(0);
        }
        catch (Exception exception) {
            throw new SQLException("No match column names were set");
        }
        if (!string2.equals(string.trim())) {
            throw new SQLException("The column name being unset has not been set");
        }
        this.matchColumnIndexes.clear();
        this.matchColumnNames.clear();
    }

    public void unsetMatchColumn(int[] nArray) throws SQLException {
        this.checkIfMatchColumnIndexesSet();
        if (nArray == null) {
            throw new SQLException("The match column parameter is null");
        }
        int n2 = -1;
        int n3 = 0;
        while (n3 < nArray.length) {
            if (nArray[n3] <= 0) {
                throw new SQLException("The match column index should be greater than 0");
            }
            try {
                n2 = (Integer)this.matchColumnIndexes.get(n3);
            }
            catch (Exception exception) {
                throw new SQLException("No match column indexes were set");
            }
            if (n2 != nArray[n3]) {
                throw new SQLException("The column index being unset has not been set");
            }
            ++n3;
        }
        this.matchColumnIndexes.clear();
        this.matchColumnNames.clear();
    }

    public void unsetMatchColumn(String[] stringArray) throws SQLException {
        this.checkIfMatchColumnNamesSet();
        if (stringArray == null) {
            throw new SQLException("The match column parameter is null");
        }
        String string = null;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2] == null || stringArray[n2].equals("")) {
                throw new SQLException("The match column name should be non-empty");
            }
            try {
                string = (String)this.matchColumnNames.get(n2);
            }
            catch (Exception exception) {
                throw new SQLException("No match column names were set");
            }
            if (!string.equals(stringArray[n2])) {
                throw new SQLException("The column name being unset has not been set");
            }
            ++n2;
        }
        this.matchColumnIndexes.clear();
        this.matchColumnNames.clear();
    }
}

